// Code generated by go-swagger; DO NOT EDIT.

package saml

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PostSLOReader is a Reader for the PostSLO structure.
type PostSLOReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PostSLOReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 302:
		result := NewPostSLOFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 400:
		result := NewPostSLOBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPostSLOForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPostSLOInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /saml/slo] postSLO", response, response.Code())
	}
}

// NewPostSLOFound creates a PostSLOFound with default headers values
func NewPostSLOFound() *PostSLOFound {
	return &PostSLOFound{}
}

/*
PostSLOFound describes a response with status code 302, with default header values.

(empty)
*/
type PostSLOFound struct {
}

// IsSuccess returns true when this post s l o found response has a 2xx status code
func (o *PostSLOFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post s l o found response has a 3xx status code
func (o *PostSLOFound) IsRedirect() bool {
	return true
}

// IsClientError returns true when this post s l o found response has a 4xx status code
func (o *PostSLOFound) IsClientError() bool {
	return false
}

// IsServerError returns true when this post s l o found response has a 5xx status code
func (o *PostSLOFound) IsServerError() bool {
	return false
}

// IsCode returns true when this post s l o found response a status code equal to that given
func (o *PostSLOFound) IsCode(code int) bool {
	return code == 302
}

// Code gets the status code for the post s l o found response
func (o *PostSLOFound) Code() int {
	return 302
}

func (o *PostSLOFound) Error() string {
	return fmt.Sprintf("[POST /saml/slo][%d] postSLOFound ", 302)
}

func (o *PostSLOFound) String() string {
	return fmt.Sprintf("[POST /saml/slo][%d] postSLOFound ", 302)
}

func (o *PostSLOFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPostSLOBadRequest creates a PostSLOBadRequest with default headers values
func NewPostSLOBadRequest() *PostSLOBadRequest {
	return &PostSLOBadRequest{}
}

/*
PostSLOBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type PostSLOBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post s l o bad request response has a 2xx status code
func (o *PostSLOBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post s l o bad request response has a 3xx status code
func (o *PostSLOBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post s l o bad request response has a 4xx status code
func (o *PostSLOBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this post s l o bad request response has a 5xx status code
func (o *PostSLOBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this post s l o bad request response a status code equal to that given
func (o *PostSLOBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the post s l o bad request response
func (o *PostSLOBadRequest) Code() int {
	return 400
}

func (o *PostSLOBadRequest) Error() string {
	return fmt.Sprintf("[POST /saml/slo][%d] postSLOBadRequest  %+v", 400, o.Payload)
}

func (o *PostSLOBadRequest) String() string {
	return fmt.Sprintf("[POST /saml/slo][%d] postSLOBadRequest  %+v", 400, o.Payload)
}

func (o *PostSLOBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostSLOBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostSLOForbidden creates a PostSLOForbidden with default headers values
func NewPostSLOForbidden() *PostSLOForbidden {
	return &PostSLOForbidden{}
}

/*
PostSLOForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type PostSLOForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post s l o forbidden response has a 2xx status code
func (o *PostSLOForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post s l o forbidden response has a 3xx status code
func (o *PostSLOForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post s l o forbidden response has a 4xx status code
func (o *PostSLOForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this post s l o forbidden response has a 5xx status code
func (o *PostSLOForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this post s l o forbidden response a status code equal to that given
func (o *PostSLOForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the post s l o forbidden response
func (o *PostSLOForbidden) Code() int {
	return 403
}

func (o *PostSLOForbidden) Error() string {
	return fmt.Sprintf("[POST /saml/slo][%d] postSLOForbidden  %+v", 403, o.Payload)
}

func (o *PostSLOForbidden) String() string {
	return fmt.Sprintf("[POST /saml/slo][%d] postSLOForbidden  %+v", 403, o.Payload)
}

func (o *PostSLOForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostSLOForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostSLOInternalServerError creates a PostSLOInternalServerError with default headers values
func NewPostSLOInternalServerError() *PostSLOInternalServerError {
	return &PostSLOInternalServerError{}
}

/*
PostSLOInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type PostSLOInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post s l o internal server error response has a 2xx status code
func (o *PostSLOInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post s l o internal server error response has a 3xx status code
func (o *PostSLOInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post s l o internal server error response has a 4xx status code
func (o *PostSLOInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this post s l o internal server error response has a 5xx status code
func (o *PostSLOInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this post s l o internal server error response a status code equal to that given
func (o *PostSLOInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the post s l o internal server error response
func (o *PostSLOInternalServerError) Code() int {
	return 500
}

func (o *PostSLOInternalServerError) Error() string {
	return fmt.Sprintf("[POST /saml/slo][%d] postSLOInternalServerError  %+v", 500, o.Payload)
}

func (o *PostSLOInternalServerError) String() string {
	return fmt.Sprintf("[POST /saml/slo][%d] postSLOInternalServerError  %+v", 500, o.Payload)
}

func (o *PostSLOInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostSLOInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
