// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// AddOrgUserReader is a Reader for the AddOrgUser structure.
type AddOrgUserReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AddOrgUserReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAddOrgUserOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAddOrgUserUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAddOrgUserForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAddOrgUserInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /orgs/{org_id}/users] addOrgUser", response, response.Code())
	}
}

// NewAddOrgUserOK creates a AddOrgUserOK with default headers values
func NewAddOrgUserOK() *AddOrgUserOK {
	return &AddOrgUserOK{}
}

/*
AddOrgUserOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type AddOrgUserOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this add org user Ok response has a 2xx status code
func (o *AddOrgUserOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this add org user Ok response has a 3xx status code
func (o *AddOrgUserOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add org user Ok response has a 4xx status code
func (o *AddOrgUserOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this add org user Ok response has a 5xx status code
func (o *AddOrgUserOK) IsServerError() bool {
	return false
}

// IsCode returns true when this add org user Ok response a status code equal to that given
func (o *AddOrgUserOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the add org user Ok response
func (o *AddOrgUserOK) Code() int {
	return 200
}

func (o *AddOrgUserOK) Error() string {
	return fmt.Sprintf("[POST /orgs/{org_id}/users][%d] addOrgUserOk  %+v", 200, o.Payload)
}

func (o *AddOrgUserOK) String() string {
	return fmt.Sprintf("[POST /orgs/{org_id}/users][%d] addOrgUserOk  %+v", 200, o.Payload)
}

func (o *AddOrgUserOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *AddOrgUserOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddOrgUserUnauthorized creates a AddOrgUserUnauthorized with default headers values
func NewAddOrgUserUnauthorized() *AddOrgUserUnauthorized {
	return &AddOrgUserUnauthorized{}
}

/*
AddOrgUserUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type AddOrgUserUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add org user unauthorized response has a 2xx status code
func (o *AddOrgUserUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add org user unauthorized response has a 3xx status code
func (o *AddOrgUserUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add org user unauthorized response has a 4xx status code
func (o *AddOrgUserUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this add org user unauthorized response has a 5xx status code
func (o *AddOrgUserUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this add org user unauthorized response a status code equal to that given
func (o *AddOrgUserUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the add org user unauthorized response
func (o *AddOrgUserUnauthorized) Code() int {
	return 401
}

func (o *AddOrgUserUnauthorized) Error() string {
	return fmt.Sprintf("[POST /orgs/{org_id}/users][%d] addOrgUserUnauthorized  %+v", 401, o.Payload)
}

func (o *AddOrgUserUnauthorized) String() string {
	return fmt.Sprintf("[POST /orgs/{org_id}/users][%d] addOrgUserUnauthorized  %+v", 401, o.Payload)
}

func (o *AddOrgUserUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddOrgUserUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddOrgUserForbidden creates a AddOrgUserForbidden with default headers values
func NewAddOrgUserForbidden() *AddOrgUserForbidden {
	return &AddOrgUserForbidden{}
}

/*
AddOrgUserForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type AddOrgUserForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add org user forbidden response has a 2xx status code
func (o *AddOrgUserForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add org user forbidden response has a 3xx status code
func (o *AddOrgUserForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add org user forbidden response has a 4xx status code
func (o *AddOrgUserForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this add org user forbidden response has a 5xx status code
func (o *AddOrgUserForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this add org user forbidden response a status code equal to that given
func (o *AddOrgUserForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the add org user forbidden response
func (o *AddOrgUserForbidden) Code() int {
	return 403
}

func (o *AddOrgUserForbidden) Error() string {
	return fmt.Sprintf("[POST /orgs/{org_id}/users][%d] addOrgUserForbidden  %+v", 403, o.Payload)
}

func (o *AddOrgUserForbidden) String() string {
	return fmt.Sprintf("[POST /orgs/{org_id}/users][%d] addOrgUserForbidden  %+v", 403, o.Payload)
}

func (o *AddOrgUserForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddOrgUserForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddOrgUserInternalServerError creates a AddOrgUserInternalServerError with default headers values
func NewAddOrgUserInternalServerError() *AddOrgUserInternalServerError {
	return &AddOrgUserInternalServerError{}
}

/*
AddOrgUserInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type AddOrgUserInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add org user internal server error response has a 2xx status code
func (o *AddOrgUserInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add org user internal server error response has a 3xx status code
func (o *AddOrgUserInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add org user internal server error response has a 4xx status code
func (o *AddOrgUserInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this add org user internal server error response has a 5xx status code
func (o *AddOrgUserInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this add org user internal server error response a status code equal to that given
func (o *AddOrgUserInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the add org user internal server error response
func (o *AddOrgUserInternalServerError) Code() int {
	return 500
}

func (o *AddOrgUserInternalServerError) Error() string {
	return fmt.Sprintf("[POST /orgs/{org_id}/users][%d] addOrgUserInternalServerError  %+v", 500, o.Payload)
}

func (o *AddOrgUserInternalServerError) String() string {
	return fmt.Sprintf("[POST /orgs/{org_id}/users][%d] addOrgUserInternalServerError  %+v", 500, o.Payload)
}

func (o *AddOrgUserInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddOrgUserInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
