// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetDataSourceByIDReader is a Reader for the GetDataSourceByID structure.
type GetDataSourceByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDataSourceByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDataSourceByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetDataSourceByIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetDataSourceByIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetDataSourceByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetDataSourceByIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetDataSourceByIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /datasources/{id}] getDataSourceByID", response, response.Code())
	}
}

// NewGetDataSourceByIDOK creates a GetDataSourceByIDOK with default headers values
func NewGetDataSourceByIDOK() *GetDataSourceByIDOK {
	return &GetDataSourceByIDOK{}
}

/*
GetDataSourceByIDOK describes a response with status code 200, with default header values.

(empty)
*/
type GetDataSourceByIDOK struct {
	Payload *models.DataSource
}

// IsSuccess returns true when this get data source by Id Ok response has a 2xx status code
func (o *GetDataSourceByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get data source by Id Ok response has a 3xx status code
func (o *GetDataSourceByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Id Ok response has a 4xx status code
func (o *GetDataSourceByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source by Id Ok response has a 5xx status code
func (o *GetDataSourceByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Id Ok response a status code equal to that given
func (o *GetDataSourceByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get data source by Id Ok response
func (o *GetDataSourceByIDOK) Code() int {
	return 200
}

func (o *GetDataSourceByIDOK) Error() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdOk  %+v", 200, o.Payload)
}

func (o *GetDataSourceByIDOK) String() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdOk  %+v", 200, o.Payload)
}

func (o *GetDataSourceByIDOK) GetPayload() *models.DataSource {
	return o.Payload
}

func (o *GetDataSourceByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataSource)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByIDBadRequest creates a GetDataSourceByIDBadRequest with default headers values
func NewGetDataSourceByIDBadRequest() *GetDataSourceByIDBadRequest {
	return &GetDataSourceByIDBadRequest{}
}

/*
GetDataSourceByIDBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetDataSourceByIDBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Id bad request response has a 2xx status code
func (o *GetDataSourceByIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Id bad request response has a 3xx status code
func (o *GetDataSourceByIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Id bad request response has a 4xx status code
func (o *GetDataSourceByIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by Id bad request response has a 5xx status code
func (o *GetDataSourceByIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Id bad request response a status code equal to that given
func (o *GetDataSourceByIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get data source by Id bad request response
func (o *GetDataSourceByIDBadRequest) Code() int {
	return 400
}

func (o *GetDataSourceByIDBadRequest) Error() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdBadRequest  %+v", 400, o.Payload)
}

func (o *GetDataSourceByIDBadRequest) String() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdBadRequest  %+v", 400, o.Payload)
}

func (o *GetDataSourceByIDBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByIDUnauthorized creates a GetDataSourceByIDUnauthorized with default headers values
func NewGetDataSourceByIDUnauthorized() *GetDataSourceByIDUnauthorized {
	return &GetDataSourceByIDUnauthorized{}
}

/*
GetDataSourceByIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetDataSourceByIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Id unauthorized response has a 2xx status code
func (o *GetDataSourceByIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Id unauthorized response has a 3xx status code
func (o *GetDataSourceByIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Id unauthorized response has a 4xx status code
func (o *GetDataSourceByIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by Id unauthorized response has a 5xx status code
func (o *GetDataSourceByIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Id unauthorized response a status code equal to that given
func (o *GetDataSourceByIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get data source by Id unauthorized response
func (o *GetDataSourceByIDUnauthorized) Code() int {
	return 401
}

func (o *GetDataSourceByIDUnauthorized) Error() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *GetDataSourceByIDUnauthorized) String() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdUnauthorized  %+v", 401, o.Payload)
}

func (o *GetDataSourceByIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByIDForbidden creates a GetDataSourceByIDForbidden with default headers values
func NewGetDataSourceByIDForbidden() *GetDataSourceByIDForbidden {
	return &GetDataSourceByIDForbidden{}
}

/*
GetDataSourceByIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetDataSourceByIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Id forbidden response has a 2xx status code
func (o *GetDataSourceByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Id forbidden response has a 3xx status code
func (o *GetDataSourceByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Id forbidden response has a 4xx status code
func (o *GetDataSourceByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by Id forbidden response has a 5xx status code
func (o *GetDataSourceByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Id forbidden response a status code equal to that given
func (o *GetDataSourceByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get data source by Id forbidden response
func (o *GetDataSourceByIDForbidden) Code() int {
	return 403
}

func (o *GetDataSourceByIDForbidden) Error() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdForbidden  %+v", 403, o.Payload)
}

func (o *GetDataSourceByIDForbidden) String() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdForbidden  %+v", 403, o.Payload)
}

func (o *GetDataSourceByIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByIDNotFound creates a GetDataSourceByIDNotFound with default headers values
func NewGetDataSourceByIDNotFound() *GetDataSourceByIDNotFound {
	return &GetDataSourceByIDNotFound{}
}

/*
GetDataSourceByIDNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetDataSourceByIDNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Id not found response has a 2xx status code
func (o *GetDataSourceByIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Id not found response has a 3xx status code
func (o *GetDataSourceByIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Id not found response has a 4xx status code
func (o *GetDataSourceByIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by Id not found response has a 5xx status code
func (o *GetDataSourceByIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Id not found response a status code equal to that given
func (o *GetDataSourceByIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get data source by Id not found response
func (o *GetDataSourceByIDNotFound) Code() int {
	return 404
}

func (o *GetDataSourceByIDNotFound) Error() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdNotFound  %+v", 404, o.Payload)
}

func (o *GetDataSourceByIDNotFound) String() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdNotFound  %+v", 404, o.Payload)
}

func (o *GetDataSourceByIDNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByIDInternalServerError creates a GetDataSourceByIDInternalServerError with default headers values
func NewGetDataSourceByIDInternalServerError() *GetDataSourceByIDInternalServerError {
	return &GetDataSourceByIDInternalServerError{}
}

/*
GetDataSourceByIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetDataSourceByIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Id internal server error response has a 2xx status code
func (o *GetDataSourceByIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Id internal server error response has a 3xx status code
func (o *GetDataSourceByIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Id internal server error response has a 4xx status code
func (o *GetDataSourceByIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source by Id internal server error response has a 5xx status code
func (o *GetDataSourceByIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get data source by Id internal server error response a status code equal to that given
func (o *GetDataSourceByIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get data source by Id internal server error response
func (o *GetDataSourceByIDInternalServerError) Code() int {
	return 500
}

func (o *GetDataSourceByIDInternalServerError) Error() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDataSourceByIDInternalServerError) String() string {
	return fmt.Sprintf("[GET /datasources/{id}][%d] getDataSourceByIdInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDataSourceByIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
