// Copyright 2022 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package serial

import (
	flatbuffers "github.com/dolthub/flatbuffers/v23/go"
)

type PrivilegeSetColumn struct {
	_tab flatbuffers.Table
}

func InitPrivilegeSetColumnRoot(o *PrivilegeSetColumn, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if PrivilegeSetColumnNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsPrivilegeSetColumn(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSetColumn, error) {
	x := &PrivilegeSetColumn{}
	return x, InitPrivilegeSetColumnRoot(x, buf, offset)
}

func GetRootAsPrivilegeSetColumn(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSetColumn {
	x := &PrivilegeSetColumn{}
	InitPrivilegeSetColumnRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsPrivilegeSetColumn(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSetColumn, error) {
	x := &PrivilegeSetColumn{}
	return x, InitPrivilegeSetColumnRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsPrivilegeSetColumn(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSetColumn {
	x := &PrivilegeSetColumn{}
	InitPrivilegeSetColumnRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PrivilegeSetColumn) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PrivilegeSetColumn) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PrivilegeSetColumn) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *PrivilegeSetColumn) Privs(j int) int32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetInt32(a + flatbuffers.UOffsetT(j*4))
	}
	return 0
}

func (rcv *PrivilegeSetColumn) PrivsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSetColumn) MutatePrivs(j int, n int32) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateInt32(a+flatbuffers.UOffsetT(j*4), n)
	}
	return false
}

const PrivilegeSetColumnNumFields = 2

func PrivilegeSetColumnStart(builder *flatbuffers.Builder) {
	builder.StartObject(PrivilegeSetColumnNumFields)
}
func PrivilegeSetColumnAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func PrivilegeSetColumnAddPrivs(builder *flatbuffers.Builder, privs flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(privs), 0)
}
func PrivilegeSetColumnStartPrivsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetColumnEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type PrivilegeSetTable struct {
	_tab flatbuffers.Table
}

func InitPrivilegeSetTableRoot(o *PrivilegeSetTable, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if PrivilegeSetTableNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsPrivilegeSetTable(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSetTable, error) {
	x := &PrivilegeSetTable{}
	return x, InitPrivilegeSetTableRoot(x, buf, offset)
}

func GetRootAsPrivilegeSetTable(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSetTable {
	x := &PrivilegeSetTable{}
	InitPrivilegeSetTableRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsPrivilegeSetTable(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSetTable, error) {
	x := &PrivilegeSetTable{}
	return x, InitPrivilegeSetTableRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsPrivilegeSetTable(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSetTable {
	x := &PrivilegeSetTable{}
	InitPrivilegeSetTableRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PrivilegeSetTable) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PrivilegeSetTable) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PrivilegeSetTable) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *PrivilegeSetTable) Privs(j int) int32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetInt32(a + flatbuffers.UOffsetT(j*4))
	}
	return 0
}

func (rcv *PrivilegeSetTable) PrivsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSetTable) MutatePrivs(j int, n int32) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateInt32(a+flatbuffers.UOffsetT(j*4), n)
	}
	return false
}

func (rcv *PrivilegeSetTable) Columns(obj *PrivilegeSetColumn, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *PrivilegeSetTable) TryColumns(obj *PrivilegeSetColumn, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if PrivilegeSetColumnNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *PrivilegeSetTable) ColumnsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

const PrivilegeSetTableNumFields = 3

func PrivilegeSetTableStart(builder *flatbuffers.Builder) {
	builder.StartObject(PrivilegeSetTableNumFields)
}
func PrivilegeSetTableAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func PrivilegeSetTableAddPrivs(builder *flatbuffers.Builder, privs flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(privs), 0)
}
func PrivilegeSetTableStartPrivsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetTableAddColumns(builder *flatbuffers.Builder, columns flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(columns), 0)
}
func PrivilegeSetTableStartColumnsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetTableEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type PrivilegeSetRoutine struct {
	_tab flatbuffers.Table
}

func InitPrivilegeSetRoutineRoot(o *PrivilegeSetRoutine, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if PrivilegeSetRoutineNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsPrivilegeSetRoutine(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSetRoutine, error) {
	x := &PrivilegeSetRoutine{}
	return x, InitPrivilegeSetRoutineRoot(x, buf, offset)
}

func GetRootAsPrivilegeSetRoutine(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSetRoutine {
	x := &PrivilegeSetRoutine{}
	InitPrivilegeSetRoutineRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsPrivilegeSetRoutine(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSetRoutine, error) {
	x := &PrivilegeSetRoutine{}
	return x, InitPrivilegeSetRoutineRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsPrivilegeSetRoutine(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSetRoutine {
	x := &PrivilegeSetRoutine{}
	InitPrivilegeSetRoutineRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PrivilegeSetRoutine) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PrivilegeSetRoutine) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PrivilegeSetRoutine) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *PrivilegeSetRoutine) Privs(j int) int32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetInt32(a + flatbuffers.UOffsetT(j*4))
	}
	return 0
}

func (rcv *PrivilegeSetRoutine) PrivsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSetRoutine) MutatePrivs(j int, n int32) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateInt32(a+flatbuffers.UOffsetT(j*4), n)
	}
	return false
}

func (rcv *PrivilegeSetRoutine) IsProc() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *PrivilegeSetRoutine) MutateIsProc(n bool) bool {
	return rcv._tab.MutateBoolSlot(8, n)
}

const PrivilegeSetRoutineNumFields = 3

func PrivilegeSetRoutineStart(builder *flatbuffers.Builder) {
	builder.StartObject(PrivilegeSetRoutineNumFields)
}
func PrivilegeSetRoutineAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func PrivilegeSetRoutineAddPrivs(builder *flatbuffers.Builder, privs flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(privs), 0)
}
func PrivilegeSetRoutineStartPrivsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetRoutineAddIsProc(builder *flatbuffers.Builder, isProc bool) {
	builder.PrependBoolSlot(2, isProc, false)
}
func PrivilegeSetRoutineEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type PrivilegeSetDatabase struct {
	_tab flatbuffers.Table
}

func InitPrivilegeSetDatabaseRoot(o *PrivilegeSetDatabase, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if PrivilegeSetDatabaseNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsPrivilegeSetDatabase(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSetDatabase, error) {
	x := &PrivilegeSetDatabase{}
	return x, InitPrivilegeSetDatabaseRoot(x, buf, offset)
}

func GetRootAsPrivilegeSetDatabase(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSetDatabase {
	x := &PrivilegeSetDatabase{}
	InitPrivilegeSetDatabaseRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsPrivilegeSetDatabase(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSetDatabase, error) {
	x := &PrivilegeSetDatabase{}
	return x, InitPrivilegeSetDatabaseRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsPrivilegeSetDatabase(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSetDatabase {
	x := &PrivilegeSetDatabase{}
	InitPrivilegeSetDatabaseRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PrivilegeSetDatabase) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PrivilegeSetDatabase) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PrivilegeSetDatabase) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *PrivilegeSetDatabase) Privs(j int) int32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetInt32(a + flatbuffers.UOffsetT(j*4))
	}
	return 0
}

func (rcv *PrivilegeSetDatabase) PrivsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSetDatabase) MutatePrivs(j int, n int32) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateInt32(a+flatbuffers.UOffsetT(j*4), n)
	}
	return false
}

func (rcv *PrivilegeSetDatabase) Tables(obj *PrivilegeSetTable, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *PrivilegeSetDatabase) TryTables(obj *PrivilegeSetTable, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if PrivilegeSetTableNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *PrivilegeSetDatabase) TablesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSetDatabase) Routines(obj *PrivilegeSetRoutine, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *PrivilegeSetDatabase) TryRoutines(obj *PrivilegeSetRoutine, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if PrivilegeSetRoutineNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *PrivilegeSetDatabase) RoutinesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

const PrivilegeSetDatabaseNumFields = 4

func PrivilegeSetDatabaseStart(builder *flatbuffers.Builder) {
	builder.StartObject(PrivilegeSetDatabaseNumFields)
}
func PrivilegeSetDatabaseAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func PrivilegeSetDatabaseAddPrivs(builder *flatbuffers.Builder, privs flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(privs), 0)
}
func PrivilegeSetDatabaseStartPrivsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetDatabaseAddTables(builder *flatbuffers.Builder, tables flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(tables), 0)
}
func PrivilegeSetDatabaseStartTablesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetDatabaseAddRoutines(builder *flatbuffers.Builder, routines flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(routines), 0)
}
func PrivilegeSetDatabaseStartRoutinesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetDatabaseEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type PrivilegeSet struct {
	_tab flatbuffers.Table
}

func InitPrivilegeSetRoot(o *PrivilegeSet, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if PrivilegeSetNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsPrivilegeSet(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSet, error) {
	x := &PrivilegeSet{}
	return x, InitPrivilegeSetRoot(x, buf, offset)
}

func GetRootAsPrivilegeSet(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSet {
	x := &PrivilegeSet{}
	InitPrivilegeSetRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsPrivilegeSet(buf []byte, offset flatbuffers.UOffsetT) (*PrivilegeSet, error) {
	x := &PrivilegeSet{}
	return x, InitPrivilegeSetRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsPrivilegeSet(buf []byte, offset flatbuffers.UOffsetT) *PrivilegeSet {
	x := &PrivilegeSet{}
	InitPrivilegeSetRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PrivilegeSet) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PrivilegeSet) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PrivilegeSet) GlobalStatic(j int) int32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetInt32(a + flatbuffers.UOffsetT(j*4))
	}
	return 0
}

func (rcv *PrivilegeSet) GlobalStaticLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSet) MutateGlobalStatic(j int, n int32) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateInt32(a+flatbuffers.UOffsetT(j*4), n)
	}
	return false
}

func (rcv *PrivilegeSet) GlobalDynamic(j int) []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.ByteVector(a + flatbuffers.UOffsetT(j*4))
	}
	return nil
}

func (rcv *PrivilegeSet) GlobalDynamicLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSet) Databases(obj *PrivilegeSetDatabase, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *PrivilegeSet) TryDatabases(obj *PrivilegeSetDatabase, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if PrivilegeSetDatabaseNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *PrivilegeSet) DatabasesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSet) GlobalDynamicWgo(j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetBool(a + flatbuffers.UOffsetT(j*1))
	}
	return false
}

func (rcv *PrivilegeSet) GlobalDynamicWgoLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PrivilegeSet) MutateGlobalDynamicWgo(j int, n bool) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateBool(a+flatbuffers.UOffsetT(j*1), n)
	}
	return false
}

const PrivilegeSetNumFields = 4

func PrivilegeSetStart(builder *flatbuffers.Builder) {
	builder.StartObject(PrivilegeSetNumFields)
}
func PrivilegeSetAddGlobalStatic(builder *flatbuffers.Builder, globalStatic flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(globalStatic), 0)
}
func PrivilegeSetStartGlobalStaticVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetAddGlobalDynamic(builder *flatbuffers.Builder, globalDynamic flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(globalDynamic), 0)
}
func PrivilegeSetStartGlobalDynamicVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetAddDatabases(builder *flatbuffers.Builder, databases flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(databases), 0)
}
func PrivilegeSetStartDatabasesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PrivilegeSetAddGlobalDynamicWgo(builder *flatbuffers.Builder, globalDynamicWgo flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(globalDynamicWgo), 0)
}
func PrivilegeSetStartGlobalDynamicWgoVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(1, numElems, 1)
}
func PrivilegeSetEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type User struct {
	_tab flatbuffers.Table
}

func InitUserRoot(o *User, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if UserNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsUser(buf []byte, offset flatbuffers.UOffsetT) (*User, error) {
	x := &User{}
	return x, InitUserRoot(x, buf, offset)
}

func GetRootAsUser(buf []byte, offset flatbuffers.UOffsetT) *User {
	x := &User{}
	InitUserRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsUser(buf []byte, offset flatbuffers.UOffsetT) (*User, error) {
	x := &User{}
	return x, InitUserRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsUser(buf []byte, offset flatbuffers.UOffsetT) *User {
	x := &User{}
	InitUserRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *User) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *User) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *User) User() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *User) Host() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *User) PrivilegeSet(obj *PrivilegeSet) *PrivilegeSet {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(PrivilegeSet)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *User) TryPrivilegeSet(obj *PrivilegeSet) (*PrivilegeSet, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(PrivilegeSet)
		}
		obj.Init(rcv._tab.Bytes, x)
		if PrivilegeSetNumFields < obj.Table().NumFields() {
			return nil, flatbuffers.ErrTableHasUnknownFields
		}
		return obj, nil
	}
	return nil, nil
}

func (rcv *User) Plugin() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *User) Password() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *User) PasswordLastChanged() int64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return rcv._tab.GetInt64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *User) MutatePasswordLastChanged(n int64) bool {
	return rcv._tab.MutateInt64Slot(14, n)
}

func (rcv *User) Locked() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *User) MutateLocked(n bool) bool {
	return rcv._tab.MutateBoolSlot(16, n)
}

func (rcv *User) Attributes() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *User) Identity() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

const UserNumFields = 9

func UserStart(builder *flatbuffers.Builder) {
	builder.StartObject(UserNumFields)
}
func UserAddUser(builder *flatbuffers.Builder, user flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(user), 0)
}
func UserAddHost(builder *flatbuffers.Builder, host flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(host), 0)
}
func UserAddPrivilegeSet(builder *flatbuffers.Builder, privilegeSet flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(privilegeSet), 0)
}
func UserAddPlugin(builder *flatbuffers.Builder, plugin flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(plugin), 0)
}
func UserAddPassword(builder *flatbuffers.Builder, password flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(password), 0)
}
func UserAddPasswordLastChanged(builder *flatbuffers.Builder, passwordLastChanged int64) {
	builder.PrependInt64Slot(5, passwordLastChanged, 0)
}
func UserAddLocked(builder *flatbuffers.Builder, locked bool) {
	builder.PrependBoolSlot(6, locked, false)
}
func UserAddAttributes(builder *flatbuffers.Builder, attributes flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(7, flatbuffers.UOffsetT(attributes), 0)
}
func UserAddIdentity(builder *flatbuffers.Builder, identity flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(8, flatbuffers.UOffsetT(identity), 0)
}
func UserEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type RoleEdge struct {
	_tab flatbuffers.Table
}

func InitRoleEdgeRoot(o *RoleEdge, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if RoleEdgeNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsRoleEdge(buf []byte, offset flatbuffers.UOffsetT) (*RoleEdge, error) {
	x := &RoleEdge{}
	return x, InitRoleEdgeRoot(x, buf, offset)
}

func GetRootAsRoleEdge(buf []byte, offset flatbuffers.UOffsetT) *RoleEdge {
	x := &RoleEdge{}
	InitRoleEdgeRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsRoleEdge(buf []byte, offset flatbuffers.UOffsetT) (*RoleEdge, error) {
	x := &RoleEdge{}
	return x, InitRoleEdgeRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsRoleEdge(buf []byte, offset flatbuffers.UOffsetT) *RoleEdge {
	x := &RoleEdge{}
	InitRoleEdgeRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *RoleEdge) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *RoleEdge) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *RoleEdge) FromHost() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *RoleEdge) FromUser() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *RoleEdge) ToHost() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *RoleEdge) ToUser() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *RoleEdge) WithAdminOption() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *RoleEdge) MutateWithAdminOption(n bool) bool {
	return rcv._tab.MutateBoolSlot(12, n)
}

const RoleEdgeNumFields = 5

func RoleEdgeStart(builder *flatbuffers.Builder) {
	builder.StartObject(RoleEdgeNumFields)
}
func RoleEdgeAddFromHost(builder *flatbuffers.Builder, fromHost flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(fromHost), 0)
}
func RoleEdgeAddFromUser(builder *flatbuffers.Builder, fromUser flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(fromUser), 0)
}
func RoleEdgeAddToHost(builder *flatbuffers.Builder, toHost flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(toHost), 0)
}
func RoleEdgeAddToUser(builder *flatbuffers.Builder, toUser flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(toUser), 0)
}
func RoleEdgeAddWithAdminOption(builder *flatbuffers.Builder, withAdminOption bool) {
	builder.PrependBoolSlot(4, withAdminOption, false)
}
func RoleEdgeEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type ReplicaSourceInfo struct {
	_tab flatbuffers.Table
}

func InitReplicaSourceInfoRoot(o *ReplicaSourceInfo, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if ReplicaSourceInfoNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsReplicaSourceInfo(buf []byte, offset flatbuffers.UOffsetT) (*ReplicaSourceInfo, error) {
	x := &ReplicaSourceInfo{}
	return x, InitReplicaSourceInfoRoot(x, buf, offset)
}

func GetRootAsReplicaSourceInfo(buf []byte, offset flatbuffers.UOffsetT) *ReplicaSourceInfo {
	x := &ReplicaSourceInfo{}
	InitReplicaSourceInfoRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsReplicaSourceInfo(buf []byte, offset flatbuffers.UOffsetT) (*ReplicaSourceInfo, error) {
	x := &ReplicaSourceInfo{}
	return x, InitReplicaSourceInfoRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsReplicaSourceInfo(buf []byte, offset flatbuffers.UOffsetT) *ReplicaSourceInfo {
	x := &ReplicaSourceInfo{}
	InitReplicaSourceInfoRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ReplicaSourceInfo) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ReplicaSourceInfo) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *ReplicaSourceInfo) Host() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *ReplicaSourceInfo) User() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *ReplicaSourceInfo) Password() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *ReplicaSourceInfo) Port() uint16 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.GetUint16(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *ReplicaSourceInfo) MutatePort(n uint16) bool {
	return rcv._tab.MutateUint16Slot(10, n)
}

func (rcv *ReplicaSourceInfo) Uuid() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *ReplicaSourceInfo) ConnectRetryInterval() uint32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return rcv._tab.GetUint32(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *ReplicaSourceInfo) MutateConnectRetryInterval(n uint32) bool {
	return rcv._tab.MutateUint32Slot(14, n)
}

func (rcv *ReplicaSourceInfo) ConnectRetryCount() uint64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return rcv._tab.GetUint64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *ReplicaSourceInfo) MutateConnectRetryCount(n uint64) bool {
	return rcv._tab.MutateUint64Slot(16, n)
}

const ReplicaSourceInfoNumFields = 7

func ReplicaSourceInfoStart(builder *flatbuffers.Builder) {
	builder.StartObject(ReplicaSourceInfoNumFields)
}
func ReplicaSourceInfoAddHost(builder *flatbuffers.Builder, host flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(host), 0)
}
func ReplicaSourceInfoAddUser(builder *flatbuffers.Builder, user flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(user), 0)
}
func ReplicaSourceInfoAddPassword(builder *flatbuffers.Builder, password flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(password), 0)
}
func ReplicaSourceInfoAddPort(builder *flatbuffers.Builder, port uint16) {
	builder.PrependUint16Slot(3, port, 0)
}
func ReplicaSourceInfoAddUuid(builder *flatbuffers.Builder, uuid flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(uuid), 0)
}
func ReplicaSourceInfoAddConnectRetryInterval(builder *flatbuffers.Builder, connectRetryInterval uint32) {
	builder.PrependUint32Slot(5, connectRetryInterval, 0)
}
func ReplicaSourceInfoAddConnectRetryCount(builder *flatbuffers.Builder, connectRetryCount uint64) {
	builder.PrependUint64Slot(6, connectRetryCount, 0)
}
func ReplicaSourceInfoEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type MySQLDb struct {
	_tab flatbuffers.Table
}

func InitMySQLDbRoot(o *MySQLDb, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	o.Init(buf, n+offset)
	if MySQLDbNumFields < o.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func TryGetRootAsMySQLDb(buf []byte, offset flatbuffers.UOffsetT) (*MySQLDb, error) {
	x := &MySQLDb{}
	return x, InitMySQLDbRoot(x, buf, offset)
}

func GetRootAsMySQLDb(buf []byte, offset flatbuffers.UOffsetT) *MySQLDb {
	x := &MySQLDb{}
	InitMySQLDbRoot(x, buf, offset)
	return x
}

func TryGetSizePrefixedRootAsMySQLDb(buf []byte, offset flatbuffers.UOffsetT) (*MySQLDb, error) {
	x := &MySQLDb{}
	return x, InitMySQLDbRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func GetSizePrefixedRootAsMySQLDb(buf []byte, offset flatbuffers.UOffsetT) *MySQLDb {
	x := &MySQLDb{}
	InitMySQLDbRoot(x, buf, offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *MySQLDb) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *MySQLDb) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *MySQLDb) User(obj *User, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *MySQLDb) TryUser(obj *User, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if UserNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *MySQLDb) UserLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *MySQLDb) RoleEdges(obj *RoleEdge, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *MySQLDb) TryRoleEdges(obj *RoleEdge, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if RoleEdgeNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *MySQLDb) RoleEdgesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *MySQLDb) ReplicaSourceInfo(obj *ReplicaSourceInfo, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *MySQLDb) TryReplicaSourceInfo(obj *ReplicaSourceInfo, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if ReplicaSourceInfoNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *MySQLDb) ReplicaSourceInfoLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *MySQLDb) SuperUser(obj *User, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *MySQLDb) TrySuperUser(obj *User, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if UserNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *MySQLDb) SuperUserLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

const MySQLDbNumFields = 4

func MySQLDbStart(builder *flatbuffers.Builder) {
	builder.StartObject(MySQLDbNumFields)
}
func MySQLDbAddUser(builder *flatbuffers.Builder, user flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(user), 0)
}
func MySQLDbStartUserVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func MySQLDbAddRoleEdges(builder *flatbuffers.Builder, roleEdges flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(roleEdges), 0)
}
func MySQLDbStartRoleEdgesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func MySQLDbAddReplicaSourceInfo(builder *flatbuffers.Builder, replicaSourceInfo flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(replicaSourceInfo), 0)
}
func MySQLDbStartReplicaSourceInfoVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func MySQLDbAddSuperUser(builder *flatbuffers.Builder, superUser flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(superUser), 0)
}
func MySQLDbStartSuperUserVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func MySQLDbEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
