// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Utf8mb3_tolower_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `utf8mb3_tolower_ci` collation.
func Utf8mb3_tolower_ci_RuneWeight(r rune) int32 {
	weight, ok := utf8mb3_tolower_ci_Weights[r]
	if ok {
		return weight
	} else if r >= 658 && r <= 901 {
		return r - 212
	} else if r >= 1414 && r <= 7679 {
		return r - 409
	} else if r >= 8189 && r <= 8485 {
		return r - 625
	} else if r >= 8575 && r <= 9398 {
		return r - 644
	} else if r >= 9449 && r <= 55295 {
		return r - 670
	} else if r >= 57345 && r <= 65312 {
		return r - 2718
	} else if r >= 65370 && r <= 65535 {
		return r - 2744
	} else {
		return 2147483647
	}
}

// utf8mb3_tolower_ci_Weights contain a map from rune to weight for the `utf8mb3_tolower_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var utf8mb3_tolower_ci_Weights = map[rune]int32{
	0:     0,
	1:     1,
	2:     2,
	3:     3,
	4:     4,
	5:     5,
	6:     6,
	7:     7,
	8:     8,
	9:     9,
	10:    10,
	11:    11,
	12:    12,
	13:    13,
	14:    14,
	15:    15,
	16:    16,
	17:    17,
	18:    18,
	19:    19,
	20:    20,
	21:    21,
	22:    22,
	23:    23,
	24:    24,
	25:    25,
	26:    26,
	27:    27,
	28:    28,
	29:    29,
	30:    30,
	31:    31,
	32:    32,
	33:    33,
	34:    34,
	35:    35,
	36:    36,
	37:    37,
	38:    38,
	39:    39,
	40:    40,
	41:    41,
	42:    42,
	43:    43,
	44:    44,
	45:    45,
	46:    46,
	47:    47,
	48:    48,
	49:    49,
	50:    50,
	51:    51,
	52:    52,
	53:    53,
	54:    54,
	55:    55,
	56:    56,
	57:    57,
	58:    58,
	59:    59,
	60:    60,
	61:    61,
	62:    62,
	63:    63,
	64:    64,
	91:    65,
	92:    66,
	93:    67,
	94:    68,
	95:    69,
	96:    70,
	65:    71,
	97:    71,
	66:    72,
	98:    72,
	67:    73,
	99:    73,
	68:    74,
	100:   74,
	69:    75,
	101:   75,
	70:    76,
	102:   76,
	71:    77,
	103:   77,
	72:    78,
	104:   78,
	73:    79,
	105:   79,
	304:   79,
	74:    80,
	106:   80,
	75:    81,
	107:   81,
	8490:  81,
	76:    82,
	108:   82,
	77:    83,
	109:   83,
	78:    84,
	110:   84,
	79:    85,
	111:   85,
	80:    86,
	112:   86,
	81:    87,
	113:   87,
	82:    88,
	114:   88,
	83:    89,
	115:   89,
	84:    90,
	116:   90,
	85:    91,
	117:   91,
	86:    92,
	118:   92,
	87:    93,
	119:   93,
	88:    94,
	120:   94,
	89:    95,
	121:   95,
	90:    96,
	122:   96,
	123:   97,
	124:   98,
	125:   99,
	126:   100,
	127:   101,
	128:   102,
	129:   103,
	130:   104,
	131:   105,
	132:   106,
	133:   107,
	134:   108,
	135:   109,
	136:   110,
	137:   111,
	138:   112,
	139:   113,
	140:   114,
	141:   115,
	142:   116,
	143:   117,
	144:   118,
	145:   119,
	146:   120,
	147:   121,
	148:   122,
	149:   123,
	150:   124,
	151:   125,
	152:   126,
	153:   127,
	154:   128,
	155:   129,
	156:   130,
	157:   131,
	158:   132,
	159:   133,
	160:   134,
	161:   135,
	162:   136,
	163:   137,
	164:   138,
	165:   139,
	166:   140,
	167:   141,
	168:   142,
	169:   143,
	170:   144,
	171:   145,
	172:   146,
	173:   147,
	174:   148,
	175:   149,
	176:   150,
	177:   151,
	178:   152,
	179:   153,
	180:   154,
	181:   155,
	182:   156,
	183:   157,
	184:   158,
	185:   159,
	186:   160,
	187:   161,
	188:   162,
	189:   163,
	190:   164,
	191:   165,
	215:   166,
	223:   167,
	192:   168,
	224:   168,
	193:   169,
	225:   169,
	194:   170,
	226:   170,
	195:   171,
	227:   171,
	196:   172,
	228:   172,
	197:   173,
	229:   173,
	8491:  173,
	198:   174,
	230:   174,
	199:   175,
	231:   175,
	200:   176,
	232:   176,
	201:   177,
	233:   177,
	202:   178,
	234:   178,
	203:   179,
	235:   179,
	204:   180,
	236:   180,
	205:   181,
	237:   181,
	206:   182,
	238:   182,
	207:   183,
	239:   183,
	208:   184,
	240:   184,
	209:   185,
	241:   185,
	210:   186,
	242:   186,
	211:   187,
	243:   187,
	212:   188,
	244:   188,
	213:   189,
	245:   189,
	214:   190,
	246:   190,
	247:   191,
	216:   192,
	248:   192,
	217:   193,
	249:   193,
	218:   194,
	250:   194,
	219:   195,
	251:   195,
	220:   196,
	252:   196,
	221:   197,
	253:   197,
	222:   198,
	254:   198,
	255:   199,
	376:   199,
	256:   200,
	257:   200,
	258:   201,
	259:   201,
	260:   202,
	261:   202,
	262:   203,
	263:   203,
	264:   204,
	265:   204,
	266:   205,
	267:   205,
	268:   206,
	269:   206,
	270:   207,
	271:   207,
	272:   208,
	273:   208,
	274:   209,
	275:   209,
	276:   210,
	277:   210,
	278:   211,
	279:   211,
	280:   212,
	281:   212,
	282:   213,
	283:   213,
	284:   214,
	285:   214,
	286:   215,
	287:   215,
	288:   216,
	289:   216,
	290:   217,
	291:   217,
	292:   218,
	293:   218,
	294:   219,
	295:   219,
	296:   220,
	297:   220,
	298:   221,
	299:   221,
	300:   222,
	301:   222,
	302:   223,
	303:   223,
	305:   224,
	306:   225,
	307:   225,
	308:   226,
	309:   226,
	310:   227,
	311:   227,
	312:   228,
	313:   229,
	314:   229,
	315:   230,
	316:   230,
	317:   231,
	318:   231,
	319:   232,
	320:   232,
	321:   233,
	322:   233,
	323:   234,
	324:   234,
	325:   235,
	326:   235,
	327:   236,
	328:   236,
	329:   237,
	330:   238,
	331:   238,
	332:   239,
	333:   239,
	334:   240,
	335:   240,
	336:   241,
	337:   241,
	338:   242,
	339:   242,
	340:   243,
	341:   243,
	342:   244,
	343:   244,
	344:   245,
	345:   245,
	346:   246,
	347:   246,
	348:   247,
	349:   247,
	350:   248,
	351:   248,
	352:   249,
	353:   249,
	354:   250,
	355:   250,
	356:   251,
	357:   251,
	358:   252,
	359:   252,
	360:   253,
	361:   253,
	362:   254,
	363:   254,
	364:   255,
	365:   255,
	366:   256,
	367:   256,
	368:   257,
	369:   257,
	370:   258,
	371:   258,
	372:   259,
	373:   259,
	374:   260,
	375:   260,
	377:   261,
	378:   261,
	379:   262,
	380:   262,
	381:   263,
	382:   263,
	383:   264,
	384:   265,
	386:   266,
	387:   266,
	388:   267,
	389:   267,
	391:   268,
	392:   268,
	395:   269,
	396:   269,
	397:   270,
	401:   271,
	402:   271,
	405:   272,
	502:   272,
	408:   273,
	409:   273,
	410:   274,
	411:   275,
	414:   276,
	416:   277,
	417:   277,
	418:   278,
	419:   278,
	420:   279,
	421:   279,
	423:   280,
	424:   280,
	426:   281,
	427:   282,
	428:   283,
	429:   283,
	431:   284,
	432:   284,
	435:   285,
	436:   285,
	437:   286,
	438:   286,
	440:   287,
	441:   287,
	442:   288,
	443:   289,
	444:   290,
	445:   290,
	446:   291,
	447:   292,
	503:   292,
	448:   293,
	449:   294,
	450:   295,
	451:   296,
	452:   297,
	453:   297,
	454:   297,
	455:   298,
	456:   298,
	457:   298,
	458:   299,
	459:   299,
	460:   299,
	461:   300,
	462:   300,
	463:   301,
	464:   301,
	465:   302,
	466:   302,
	467:   303,
	468:   303,
	469:   304,
	470:   304,
	471:   305,
	472:   305,
	473:   306,
	474:   306,
	475:   307,
	476:   307,
	398:   308,
	477:   308,
	478:   309,
	479:   309,
	480:   310,
	481:   310,
	482:   311,
	483:   311,
	484:   312,
	485:   312,
	486:   313,
	487:   313,
	488:   314,
	489:   314,
	490:   315,
	491:   315,
	492:   316,
	493:   316,
	494:   317,
	495:   317,
	496:   318,
	497:   319,
	498:   319,
	499:   319,
	500:   320,
	501:   320,
	504:   321,
	505:   321,
	506:   322,
	507:   322,
	508:   323,
	509:   323,
	510:   324,
	511:   324,
	512:   325,
	513:   325,
	514:   326,
	515:   326,
	516:   327,
	517:   327,
	518:   328,
	519:   328,
	520:   329,
	521:   329,
	522:   330,
	523:   330,
	524:   331,
	525:   331,
	526:   332,
	527:   332,
	528:   333,
	529:   333,
	530:   334,
	531:   334,
	532:   335,
	533:   335,
	534:   336,
	535:   336,
	536:   337,
	537:   337,
	538:   338,
	539:   338,
	540:   339,
	541:   339,
	542:   340,
	543:   340,
	544:   341,
	545:   342,
	546:   343,
	547:   343,
	548:   344,
	549:   344,
	550:   345,
	551:   345,
	552:   346,
	553:   346,
	554:   347,
	555:   347,
	556:   348,
	557:   348,
	558:   349,
	559:   349,
	560:   350,
	561:   350,
	562:   351,
	563:   351,
	564:   352,
	565:   353,
	566:   354,
	567:   355,
	568:   356,
	569:   357,
	570:   358,
	571:   359,
	572:   360,
	573:   361,
	574:   362,
	575:   363,
	576:   364,
	577:   365,
	578:   366,
	579:   367,
	580:   368,
	581:   369,
	582:   370,
	583:   371,
	584:   372,
	585:   373,
	586:   374,
	587:   375,
	588:   376,
	589:   377,
	590:   378,
	591:   379,
	592:   380,
	593:   381,
	594:   382,
	385:   383,
	595:   383,
	390:   384,
	596:   384,
	597:   385,
	393:   386,
	598:   386,
	394:   387,
	599:   387,
	600:   388,
	399:   389,
	601:   389,
	602:   390,
	400:   391,
	603:   391,
	604:   392,
	605:   393,
	606:   394,
	607:   395,
	403:   396,
	608:   396,
	609:   397,
	610:   398,
	404:   399,
	611:   399,
	612:   400,
	613:   401,
	614:   402,
	615:   403,
	407:   404,
	616:   404,
	406:   405,
	617:   405,
	618:   406,
	619:   407,
	620:   408,
	621:   409,
	622:   410,
	412:   411,
	623:   411,
	624:   412,
	625:   413,
	413:   414,
	626:   414,
	627:   415,
	628:   416,
	415:   417,
	629:   417,
	630:   418,
	631:   419,
	632:   420,
	633:   421,
	634:   422,
	635:   423,
	636:   424,
	637:   425,
	638:   426,
	639:   427,
	422:   428,
	640:   428,
	641:   429,
	642:   430,
	425:   431,
	643:   431,
	644:   432,
	645:   433,
	646:   434,
	647:   435,
	430:   436,
	648:   436,
	649:   437,
	433:   438,
	650:   438,
	434:   439,
	651:   439,
	652:   440,
	653:   441,
	654:   442,
	655:   443,
	656:   444,
	657:   445,
	439:   446,
	903:   690,
	907:   691,
	909:   692,
	912:   693,
	930:   694,
	902:   695,
	940:   695,
	904:   696,
	941:   696,
	905:   697,
	942:   697,
	906:   698,
	943:   698,
	944:   699,
	913:   700,
	945:   700,
	914:   701,
	946:   701,
	915:   702,
	947:   702,
	916:   703,
	948:   703,
	917:   704,
	949:   704,
	918:   705,
	950:   705,
	919:   706,
	951:   706,
	920:   707,
	952:   707,
	921:   708,
	953:   708,
	922:   709,
	954:   709,
	923:   710,
	955:   710,
	924:   711,
	956:   711,
	925:   712,
	957:   712,
	926:   713,
	958:   713,
	927:   714,
	959:   714,
	928:   715,
	960:   715,
	929:   716,
	961:   716,
	962:   717,
	931:   718,
	963:   718,
	932:   719,
	964:   719,
	933:   720,
	965:   720,
	934:   721,
	966:   721,
	935:   722,
	967:   722,
	936:   723,
	968:   723,
	937:   724,
	969:   724,
	8486:  724,
	938:   725,
	970:   725,
	939:   726,
	971:   726,
	908:   727,
	972:   727,
	910:   728,
	973:   728,
	911:   729,
	974:   729,
	975:   730,
	976:   731,
	977:   732,
	978:   733,
	979:   734,
	980:   735,
	981:   736,
	982:   737,
	983:   738,
	984:   739,
	985:   740,
	986:   741,
	987:   741,
	988:   742,
	989:   742,
	990:   743,
	991:   743,
	992:   744,
	993:   744,
	994:   745,
	995:   745,
	996:   746,
	997:   746,
	998:   747,
	999:   747,
	1000:  748,
	1001:  748,
	1002:  749,
	1003:  749,
	1004:  750,
	1005:  750,
	1006:  751,
	1007:  751,
	1008:  752,
	1009:  753,
	1010:  754,
	1011:  755,
	1012:  756,
	1013:  757,
	1014:  758,
	1015:  759,
	1016:  760,
	1017:  761,
	1018:  762,
	1019:  763,
	1020:  764,
	1021:  765,
	1022:  766,
	1023:  767,
	1040:  768,
	1072:  768,
	1041:  769,
	1073:  769,
	1042:  770,
	1074:  770,
	1043:  771,
	1075:  771,
	1044:  772,
	1076:  772,
	1045:  773,
	1077:  773,
	1046:  774,
	1078:  774,
	1047:  775,
	1079:  775,
	1048:  776,
	1080:  776,
	1049:  777,
	1081:  777,
	1050:  778,
	1082:  778,
	1051:  779,
	1083:  779,
	1052:  780,
	1084:  780,
	1053:  781,
	1085:  781,
	1054:  782,
	1086:  782,
	1055:  783,
	1087:  783,
	1056:  784,
	1088:  784,
	1057:  785,
	1089:  785,
	1058:  786,
	1090:  786,
	1059:  787,
	1091:  787,
	1060:  788,
	1092:  788,
	1061:  789,
	1093:  789,
	1062:  790,
	1094:  790,
	1063:  791,
	1095:  791,
	1064:  792,
	1096:  792,
	1065:  793,
	1097:  793,
	1066:  794,
	1098:  794,
	1067:  795,
	1099:  795,
	1068:  796,
	1100:  796,
	1069:  797,
	1101:  797,
	1070:  798,
	1102:  798,
	1071:  799,
	1103:  799,
	1024:  800,
	1104:  800,
	1025:  801,
	1105:  801,
	1026:  802,
	1106:  802,
	1027:  803,
	1107:  803,
	1028:  804,
	1108:  804,
	1029:  805,
	1109:  805,
	1030:  806,
	1110:  806,
	1031:  807,
	1111:  807,
	1032:  808,
	1112:  808,
	1033:  809,
	1113:  809,
	1034:  810,
	1114:  810,
	1035:  811,
	1115:  811,
	1036:  812,
	1116:  812,
	1037:  813,
	1117:  813,
	1038:  814,
	1118:  814,
	1039:  815,
	1119:  815,
	1120:  816,
	1121:  816,
	1122:  817,
	1123:  817,
	1124:  818,
	1125:  818,
	1126:  819,
	1127:  819,
	1128:  820,
	1129:  820,
	1130:  821,
	1131:  821,
	1132:  822,
	1133:  822,
	1134:  823,
	1135:  823,
	1136:  824,
	1137:  824,
	1138:  825,
	1139:  825,
	1140:  826,
	1141:  826,
	1142:  827,
	1143:  827,
	1144:  828,
	1145:  828,
	1146:  829,
	1147:  829,
	1148:  830,
	1149:  830,
	1150:  831,
	1151:  831,
	1152:  832,
	1153:  832,
	1154:  833,
	1155:  834,
	1156:  835,
	1157:  836,
	1158:  837,
	1159:  838,
	1160:  839,
	1161:  840,
	1162:  841,
	1163:  842,
	1164:  843,
	1165:  843,
	1166:  844,
	1167:  844,
	1168:  845,
	1169:  845,
	1170:  846,
	1171:  846,
	1172:  847,
	1173:  847,
	1174:  848,
	1175:  848,
	1176:  849,
	1177:  849,
	1178:  850,
	1179:  850,
	1180:  851,
	1181:  851,
	1182:  852,
	1183:  852,
	1184:  853,
	1185:  853,
	1186:  854,
	1187:  854,
	1188:  855,
	1189:  855,
	1190:  856,
	1191:  856,
	1192:  857,
	1193:  857,
	1194:  858,
	1195:  858,
	1196:  859,
	1197:  859,
	1198:  860,
	1199:  860,
	1200:  861,
	1201:  861,
	1202:  862,
	1203:  862,
	1204:  863,
	1205:  863,
	1206:  864,
	1207:  864,
	1208:  865,
	1209:  865,
	1210:  866,
	1211:  866,
	1212:  867,
	1213:  867,
	1214:  868,
	1215:  868,
	1216:  869,
	1217:  870,
	1218:  870,
	1219:  871,
	1220:  871,
	1221:  872,
	1222:  873,
	1223:  874,
	1224:  874,
	1225:  875,
	1226:  876,
	1227:  877,
	1228:  877,
	1229:  878,
	1230:  879,
	1231:  880,
	1232:  881,
	1233:  881,
	1234:  882,
	1235:  882,
	1236:  883,
	1237:  883,
	1238:  884,
	1239:  884,
	1240:  885,
	1241:  885,
	1242:  886,
	1243:  886,
	1244:  887,
	1245:  887,
	1246:  888,
	1247:  888,
	1248:  889,
	1249:  889,
	1250:  890,
	1251:  890,
	1252:  891,
	1253:  891,
	1254:  892,
	1255:  892,
	1256:  893,
	1257:  893,
	1258:  894,
	1259:  894,
	1260:  895,
	1261:  895,
	1262:  896,
	1263:  896,
	1264:  897,
	1265:  897,
	1266:  898,
	1267:  898,
	1268:  899,
	1269:  899,
	1270:  900,
	1271:  901,
	1272:  902,
	1273:  902,
	1274:  903,
	1275:  904,
	1276:  905,
	1277:  906,
	1278:  907,
	1279:  908,
	1280:  909,
	1281:  910,
	1282:  911,
	1283:  912,
	1284:  913,
	1285:  914,
	1286:  915,
	1287:  916,
	1288:  917,
	1289:  918,
	1290:  919,
	1291:  920,
	1292:  921,
	1293:  922,
	1294:  923,
	1295:  924,
	1296:  925,
	1297:  926,
	1298:  927,
	1299:  928,
	1300:  929,
	1301:  930,
	1302:  931,
	1303:  932,
	1304:  933,
	1305:  934,
	1306:  935,
	1307:  936,
	1308:  937,
	1309:  938,
	1310:  939,
	1311:  940,
	1312:  941,
	1313:  942,
	1314:  943,
	1315:  944,
	1316:  945,
	1317:  946,
	1318:  947,
	1319:  948,
	1320:  949,
	1321:  950,
	1322:  951,
	1323:  952,
	1324:  953,
	1325:  954,
	1326:  955,
	1327:  956,
	1328:  957,
	1367:  958,
	1368:  959,
	1369:  960,
	1370:  961,
	1371:  962,
	1372:  963,
	1373:  964,
	1374:  965,
	1375:  966,
	1376:  967,
	1329:  968,
	1377:  968,
	1330:  969,
	1378:  969,
	1331:  970,
	1379:  970,
	1332:  971,
	1380:  971,
	1333:  972,
	1381:  972,
	1334:  973,
	1382:  973,
	1335:  974,
	1383:  974,
	1336:  975,
	1384:  975,
	1337:  976,
	1385:  976,
	1338:  977,
	1386:  977,
	1339:  978,
	1387:  978,
	1340:  979,
	1388:  979,
	1341:  980,
	1389:  980,
	1342:  981,
	1390:  981,
	1343:  982,
	1391:  982,
	1344:  983,
	1392:  983,
	1345:  984,
	1393:  984,
	1346:  985,
	1394:  985,
	1347:  986,
	1395:  986,
	1348:  987,
	1396:  987,
	1349:  988,
	1397:  988,
	1350:  989,
	1398:  989,
	1351:  990,
	1399:  990,
	1352:  991,
	1400:  991,
	1353:  992,
	1401:  992,
	1354:  993,
	1402:  993,
	1355:  994,
	1403:  994,
	1356:  995,
	1404:  995,
	1357:  996,
	1405:  996,
	1358:  997,
	1406:  997,
	1359:  998,
	1407:  998,
	1360:  999,
	1408:  999,
	1361:  1000,
	1409:  1000,
	1362:  1001,
	1410:  1001,
	1363:  1002,
	1411:  1002,
	1364:  1003,
	1412:  1003,
	1365:  1004,
	1413:  1004,
	1366:  1005,
	7680:  7271,
	7681:  7271,
	7682:  7272,
	7683:  7272,
	7684:  7273,
	7685:  7273,
	7686:  7274,
	7687:  7274,
	7688:  7275,
	7689:  7275,
	7690:  7276,
	7691:  7276,
	7692:  7277,
	7693:  7277,
	7694:  7278,
	7695:  7278,
	7696:  7279,
	7697:  7279,
	7698:  7280,
	7699:  7280,
	7700:  7281,
	7701:  7281,
	7702:  7282,
	7703:  7282,
	7704:  7283,
	7705:  7283,
	7706:  7284,
	7707:  7284,
	7708:  7285,
	7709:  7285,
	7710:  7286,
	7711:  7286,
	7712:  7287,
	7713:  7287,
	7714:  7288,
	7715:  7288,
	7716:  7289,
	7717:  7289,
	7718:  7290,
	7719:  7290,
	7720:  7291,
	7721:  7291,
	7722:  7292,
	7723:  7292,
	7724:  7293,
	7725:  7293,
	7726:  7294,
	7727:  7294,
	7728:  7295,
	7729:  7295,
	7730:  7296,
	7731:  7296,
	7732:  7297,
	7733:  7297,
	7734:  7298,
	7735:  7298,
	7736:  7299,
	7737:  7299,
	7738:  7300,
	7739:  7300,
	7740:  7301,
	7741:  7301,
	7742:  7302,
	7743:  7302,
	7744:  7303,
	7745:  7303,
	7746:  7304,
	7747:  7304,
	7748:  7305,
	7749:  7305,
	7750:  7306,
	7751:  7306,
	7752:  7307,
	7753:  7307,
	7754:  7308,
	7755:  7308,
	7756:  7309,
	7757:  7309,
	7758:  7310,
	7759:  7310,
	7760:  7311,
	7761:  7311,
	7762:  7312,
	7763:  7312,
	7764:  7313,
	7765:  7313,
	7766:  7314,
	7767:  7314,
	7768:  7315,
	7769:  7315,
	7770:  7316,
	7771:  7316,
	7772:  7317,
	7773:  7317,
	7774:  7318,
	7775:  7318,
	7776:  7319,
	7777:  7319,
	7778:  7320,
	7779:  7320,
	7780:  7321,
	7781:  7321,
	7782:  7322,
	7783:  7322,
	7784:  7323,
	7785:  7323,
	7786:  7324,
	7787:  7324,
	7788:  7325,
	7789:  7325,
	7790:  7326,
	7791:  7326,
	7792:  7327,
	7793:  7327,
	7794:  7328,
	7795:  7328,
	7796:  7329,
	7797:  7329,
	7798:  7330,
	7799:  7330,
	7800:  7331,
	7801:  7331,
	7802:  7332,
	7803:  7332,
	7804:  7333,
	7805:  7333,
	7806:  7334,
	7807:  7334,
	7808:  7335,
	7809:  7335,
	7810:  7336,
	7811:  7336,
	7812:  7337,
	7813:  7337,
	7814:  7338,
	7815:  7338,
	7816:  7339,
	7817:  7339,
	7818:  7340,
	7819:  7340,
	7820:  7341,
	7821:  7341,
	7822:  7342,
	7823:  7342,
	7824:  7343,
	7825:  7343,
	7826:  7344,
	7827:  7344,
	7828:  7345,
	7829:  7345,
	7830:  7346,
	7831:  7347,
	7832:  7348,
	7833:  7349,
	7834:  7350,
	7835:  7351,
	7836:  7352,
	7837:  7353,
	7838:  7354,
	7839:  7355,
	7840:  7356,
	7841:  7356,
	7842:  7357,
	7843:  7357,
	7844:  7358,
	7845:  7358,
	7846:  7359,
	7847:  7359,
	7848:  7360,
	7849:  7360,
	7850:  7361,
	7851:  7361,
	7852:  7362,
	7853:  7362,
	7854:  7363,
	7855:  7363,
	7856:  7364,
	7857:  7364,
	7858:  7365,
	7859:  7365,
	7860:  7366,
	7861:  7366,
	7862:  7367,
	7863:  7367,
	7864:  7368,
	7865:  7368,
	7866:  7369,
	7867:  7369,
	7868:  7370,
	7869:  7370,
	7870:  7371,
	7871:  7371,
	7872:  7372,
	7873:  7372,
	7874:  7373,
	7875:  7373,
	7876:  7374,
	7877:  7374,
	7878:  7375,
	7879:  7375,
	7880:  7376,
	7881:  7376,
	7882:  7377,
	7883:  7377,
	7884:  7378,
	7885:  7378,
	7886:  7379,
	7887:  7379,
	7888:  7380,
	7889:  7380,
	7890:  7381,
	7891:  7381,
	7892:  7382,
	7893:  7382,
	7894:  7383,
	7895:  7383,
	7896:  7384,
	7897:  7384,
	7898:  7385,
	7899:  7385,
	7900:  7386,
	7901:  7386,
	7902:  7387,
	7903:  7387,
	7904:  7388,
	7905:  7388,
	7906:  7389,
	7907:  7389,
	7908:  7390,
	7909:  7390,
	7910:  7391,
	7911:  7391,
	7912:  7392,
	7913:  7392,
	7914:  7393,
	7915:  7393,
	7916:  7394,
	7917:  7394,
	7918:  7395,
	7919:  7395,
	7920:  7396,
	7921:  7396,
	7922:  7397,
	7923:  7397,
	7924:  7398,
	7925:  7398,
	7926:  7399,
	7927:  7399,
	7928:  7400,
	7929:  7400,
	7930:  7401,
	7931:  7402,
	7932:  7403,
	7933:  7404,
	7934:  7405,
	7935:  7406,
	7936:  7407,
	7944:  7407,
	7937:  7408,
	7945:  7408,
	7938:  7409,
	7946:  7409,
	7939:  7410,
	7947:  7410,
	7940:  7411,
	7948:  7411,
	7941:  7412,
	7949:  7412,
	7942:  7413,
	7950:  7413,
	7943:  7414,
	7951:  7414,
	7952:  7415,
	7960:  7415,
	7953:  7416,
	7961:  7416,
	7954:  7417,
	7962:  7417,
	7955:  7418,
	7963:  7418,
	7956:  7419,
	7964:  7419,
	7957:  7420,
	7965:  7420,
	7958:  7421,
	7959:  7422,
	7966:  7423,
	7967:  7424,
	7968:  7425,
	7976:  7425,
	7969:  7426,
	7977:  7426,
	7970:  7427,
	7978:  7427,
	7971:  7428,
	7979:  7428,
	7972:  7429,
	7980:  7429,
	7973:  7430,
	7981:  7430,
	7974:  7431,
	7982:  7431,
	7975:  7432,
	7983:  7432,
	7984:  7433,
	7992:  7433,
	7985:  7434,
	7993:  7434,
	7986:  7435,
	7994:  7435,
	7987:  7436,
	7995:  7436,
	7988:  7437,
	7996:  7437,
	7989:  7438,
	7997:  7438,
	7990:  7439,
	7998:  7439,
	7991:  7440,
	7999:  7440,
	8000:  7441,
	8008:  7441,
	8001:  7442,
	8009:  7442,
	8002:  7443,
	8010:  7443,
	8003:  7444,
	8011:  7444,
	8004:  7445,
	8012:  7445,
	8005:  7446,
	8013:  7446,
	8006:  7447,
	8007:  7448,
	8014:  7449,
	8015:  7450,
	8016:  7451,
	8017:  7452,
	8025:  7452,
	8018:  7453,
	8019:  7454,
	8027:  7454,
	8020:  7455,
	8021:  7456,
	8029:  7456,
	8022:  7457,
	8023:  7458,
	8031:  7458,
	8024:  7459,
	8026:  7460,
	8028:  7461,
	8030:  7462,
	8032:  7463,
	8040:  7463,
	8033:  7464,
	8041:  7464,
	8034:  7465,
	8042:  7465,
	8035:  7466,
	8043:  7466,
	8036:  7467,
	8044:  7467,
	8037:  7468,
	8045:  7468,
	8038:  7469,
	8046:  7469,
	8039:  7470,
	8047:  7470,
	8048:  7471,
	8122:  7471,
	8049:  7472,
	8123:  7472,
	8050:  7473,
	8136:  7473,
	8051:  7474,
	8137:  7474,
	8052:  7475,
	8138:  7475,
	8053:  7476,
	8139:  7476,
	8054:  7477,
	8154:  7477,
	8055:  7478,
	8155:  7478,
	8056:  7479,
	8184:  7479,
	8057:  7480,
	8185:  7480,
	8058:  7481,
	8170:  7481,
	8059:  7482,
	8171:  7482,
	8060:  7483,
	8186:  7483,
	8061:  7484,
	8187:  7484,
	8062:  7485,
	8063:  7486,
	8064:  7487,
	8072:  7487,
	8065:  7488,
	8073:  7488,
	8066:  7489,
	8074:  7489,
	8067:  7490,
	8075:  7490,
	8068:  7491,
	8076:  7491,
	8069:  7492,
	8077:  7492,
	8070:  7493,
	8078:  7493,
	8071:  7494,
	8079:  7494,
	8080:  7495,
	8088:  7495,
	8081:  7496,
	8089:  7496,
	8082:  7497,
	8090:  7497,
	8083:  7498,
	8091:  7498,
	8084:  7499,
	8092:  7499,
	8085:  7500,
	8093:  7500,
	8086:  7501,
	8094:  7501,
	8087:  7502,
	8095:  7502,
	8096:  7503,
	8104:  7503,
	8097:  7504,
	8105:  7504,
	8098:  7505,
	8106:  7505,
	8099:  7506,
	8107:  7506,
	8100:  7507,
	8108:  7507,
	8101:  7508,
	8109:  7508,
	8102:  7509,
	8110:  7509,
	8103:  7510,
	8111:  7510,
	8112:  7511,
	8120:  7511,
	8113:  7512,
	8121:  7512,
	8114:  7513,
	8115:  7514,
	8124:  7514,
	8116:  7515,
	8117:  7516,
	8118:  7517,
	8119:  7518,
	8125:  7519,
	8126:  7520,
	8127:  7521,
	8128:  7522,
	8129:  7523,
	8130:  7524,
	8131:  7525,
	8140:  7525,
	8132:  7526,
	8133:  7527,
	8134:  7528,
	8135:  7529,
	8141:  7530,
	8142:  7531,
	8143:  7532,
	8144:  7533,
	8152:  7533,
	8145:  7534,
	8153:  7534,
	8146:  7535,
	8147:  7536,
	8148:  7537,
	8149:  7538,
	8150:  7539,
	8151:  7540,
	8156:  7541,
	8157:  7542,
	8158:  7543,
	8159:  7544,
	8160:  7545,
	8168:  7545,
	8161:  7546,
	8169:  7546,
	8162:  7547,
	8163:  7548,
	8164:  7549,
	8165:  7550,
	8172:  7550,
	8166:  7551,
	8167:  7552,
	8173:  7553,
	8174:  7554,
	8175:  7555,
	8176:  7556,
	8177:  7557,
	8178:  7558,
	8179:  7559,
	8188:  7559,
	8180:  7560,
	8181:  7561,
	8182:  7562,
	8183:  7563,
	8487:  7861,
	8488:  7862,
	8489:  7863,
	8492:  7864,
	8493:  7865,
	8494:  7866,
	8495:  7867,
	8496:  7868,
	8497:  7869,
	8498:  7870,
	8499:  7871,
	8500:  7872,
	8501:  7873,
	8502:  7874,
	8503:  7875,
	8504:  7876,
	8505:  7877,
	8506:  7878,
	8507:  7879,
	8508:  7880,
	8509:  7881,
	8510:  7882,
	8511:  7883,
	8512:  7884,
	8513:  7885,
	8514:  7886,
	8515:  7887,
	8516:  7888,
	8517:  7889,
	8518:  7890,
	8519:  7891,
	8520:  7892,
	8521:  7893,
	8522:  7894,
	8523:  7895,
	8524:  7896,
	8525:  7897,
	8526:  7898,
	8527:  7899,
	8528:  7900,
	8529:  7901,
	8530:  7902,
	8531:  7903,
	8532:  7904,
	8533:  7905,
	8534:  7906,
	8535:  7907,
	8536:  7908,
	8537:  7909,
	8538:  7910,
	8539:  7911,
	8540:  7912,
	8541:  7913,
	8542:  7914,
	8543:  7915,
	8544:  7916,
	8560:  7916,
	8545:  7917,
	8561:  7917,
	8546:  7918,
	8562:  7918,
	8547:  7919,
	8563:  7919,
	8548:  7920,
	8564:  7920,
	8549:  7921,
	8565:  7921,
	8550:  7922,
	8566:  7922,
	8551:  7923,
	8567:  7923,
	8552:  7924,
	8568:  7924,
	8553:  7925,
	8569:  7925,
	8554:  7926,
	8570:  7926,
	8555:  7927,
	8571:  7927,
	8556:  7928,
	8572:  7928,
	8557:  7929,
	8573:  7929,
	8558:  7930,
	8574:  7930,
	8559:  7931,
	9424:  8754,
	9399:  8755,
	9425:  8755,
	9400:  8756,
	9426:  8756,
	9401:  8757,
	9427:  8757,
	9402:  8758,
	9428:  8758,
	9403:  8759,
	9429:  8759,
	9404:  8760,
	9430:  8760,
	9405:  8761,
	9431:  8761,
	9406:  8762,
	9432:  8762,
	9407:  8763,
	9433:  8763,
	9408:  8764,
	9434:  8764,
	9409:  8765,
	9435:  8765,
	9410:  8766,
	9436:  8766,
	9411:  8767,
	9437:  8767,
	9412:  8768,
	9438:  8768,
	9413:  8769,
	9439:  8769,
	9414:  8770,
	9440:  8770,
	9415:  8771,
	9441:  8771,
	9416:  8772,
	9442:  8772,
	9417:  8773,
	9443:  8773,
	9418:  8774,
	9444:  8774,
	9419:  8775,
	9445:  8775,
	9420:  8776,
	9446:  8776,
	9421:  8777,
	9447:  8777,
	9422:  8778,
	9448:  8778,
	9423:  8779,
	57344: 54626,
	65339: 62595,
	65340: 62596,
	65341: 62597,
	65342: 62598,
	65343: 62599,
	65344: 62600,
	65313: 62601,
	65345: 62601,
	65314: 62602,
	65346: 62602,
	65315: 62603,
	65347: 62603,
	65316: 62604,
	65348: 62604,
	65317: 62605,
	65349: 62605,
	65318: 62606,
	65350: 62606,
	65319: 62607,
	65351: 62607,
	65320: 62608,
	65352: 62608,
	65321: 62609,
	65353: 62609,
	65322: 62610,
	65354: 62610,
	65323: 62611,
	65355: 62611,
	65324: 62612,
	65356: 62612,
	65325: 62613,
	65357: 62613,
	65326: 62614,
	65358: 62614,
	65327: 62615,
	65359: 62615,
	65328: 62616,
	65360: 62616,
	65329: 62617,
	65361: 62617,
	65330: 62618,
	65362: 62618,
	65331: 62619,
	65363: 62619,
	65332: 62620,
	65364: 62620,
	65333: 62621,
	65365: 62621,
	65334: 62622,
	65366: 62622,
	65335: 62623,
	65367: 62623,
	65336: 62624,
	65368: 62624,
	65337: 62625,
	65369: 62625,
	65338: 62626,
}
