// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Latin7_general_cs_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `latin7_general_cs` collation.
func Latin7_general_cs_RuneWeight(r rune) int32 {
	weight, ok := latin7_general_cs_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// latin7_general_cs_Weights contain a map from rune to weight for the `latin7_general_cs` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var latin7_general_cs_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	127:  32,
	129:  33,
	131:  34,
	136:  35,
	138:  36,
	140:  37,
	144:  38,
	152:  39,
	154:  40,
	156:  41,
	159:  42,
	39:   43,
	45:   44,
	173:  45,
	150:  46,
	151:  47,
	32:   48,
	160:  49,
	33:   50,
	34:   51,
	35:   52,
	36:   53,
	37:   54,
	38:   55,
	40:   56,
	41:   57,
	42:   58,
	44:   59,
	46:   60,
	47:   61,
	58:   62,
	59:   63,
	63:   64,
	64:   65,
	91:   66,
	92:   67,
	93:   68,
	94:   69,
	95:   70,
	96:   71,
	123:  72,
	124:  73,
	125:  74,
	126:  75,
	166:  76,
	141:  77,
	157:  78,
	8220: 79,
	143:  80,
	142:  81,
	8217: 82,
	158:  83,
	145:  84,
	146:  85,
	130:  86,
	147:  87,
	148:  88,
	132:  89,
	139:  90,
	155:  91,
	43:   92,
	60:   93,
	61:   94,
	62:   95,
	177:  96,
	171:  97,
	187:  98,
	215:  99,
	247:  100,
	162:  101,
	163:  102,
	164:  103,
	167:  104,
	169:  105,
	172:  106,
	174:  107,
	176:  108,
	181:  109,
	182:  110,
	183:  111,
	134:  112,
	135:  113,
	149:  114,
	133:  115,
	137:  116,
	128:  117,
	48:   118,
	188:  119,
	189:  120,
	190:  121,
	49:   122,
	185:  123,
	50:   124,
	178:  125,
	51:   126,
	179:  127,
	52:   128,
	53:   129,
	54:   130,
	55:   131,
	56:   132,
	57:   133,
	65:   134,
	97:   135,
	196:  136,
	228:  137,
	256:  138,
	257:  139,
	197:  140,
	229:  141,
	260:  142,
	261:  143,
	198:  144,
	230:  145,
	66:   146,
	98:   147,
	67:   148,
	99:   149,
	262:  150,
	263:  151,
	268:  152,
	269:  153,
	68:   154,
	100:  155,
	69:   156,
	101:  157,
	201:  158,
	233:  159,
	278:  160,
	279:  161,
	274:  162,
	275:  163,
	280:  164,
	281:  165,
	70:   166,
	102:  167,
	71:   168,
	103:  169,
	290:  170,
	291:  171,
	72:   172,
	104:  173,
	73:   174,
	105:  175,
	298:  176,
	299:  177,
	302:  178,
	303:  179,
	74:   180,
	106:  181,
	75:   182,
	107:  183,
	310:  184,
	311:  185,
	76:   186,
	108:  187,
	321:  188,
	322:  189,
	315:  190,
	316:  191,
	77:   192,
	109:  193,
	78:   194,
	110:  195,
	323:  196,
	324:  197,
	325:  198,
	326:  199,
	79:   200,
	111:  201,
	211:  202,
	243:  203,
	214:  204,
	246:  205,
	332:  206,
	333:  207,
	213:  208,
	245:  209,
	248:  210,
	216:  211,
	80:   212,
	112:  213,
	81:   214,
	113:  215,
	82:   216,
	114:  217,
	342:  218,
	343:  219,
	83:   220,
	115:  221,
	346:  222,
	347:  223,
	223:  224,
	352:  225,
	353:  226,
	84:   227,
	116:  228,
	153:  229,
	85:   230,
	117:  231,
	220:  232,
	252:  233,
	362:  234,
	363:  235,
	370:  236,
	371:  237,
	86:   238,
	118:  239,
	87:   240,
	119:  241,
	88:   242,
	120:  243,
	89:   244,
	121:  245,
	90:   246,
	122:  247,
	377:  248,
	378:  249,
	379:  250,
	380:  251,
	381:  252,
	382:  253,
	8221: 254,
	8222: 255,
}
