// Copyright 2022 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Latin1_general_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `latin1_general_ci` collation.
func Latin1_general_ci_RuneWeight(r rune) int32 {
	weight, ok := latin1_general_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// latin1_general_ci_Weights contain a map from rune to weight for the `latin1_general_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var latin1_general_ci_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	32:   32,
	33:   33,
	34:   34,
	35:   35,
	36:   36,
	37:   37,
	38:   38,
	39:   39,
	40:   40,
	41:   41,
	42:   42,
	43:   43,
	44:   44,
	45:   45,
	46:   46,
	47:   47,
	48:   48,
	49:   49,
	50:   50,
	51:   51,
	52:   52,
	53:   53,
	54:   54,
	55:   55,
	56:   56,
	57:   57,
	58:   58,
	59:   59,
	60:   60,
	61:   61,
	62:   62,
	63:   63,
	64:   64,
	65:   65,
	97:   65,
	192:  66,
	224:  66,
	193:  67,
	225:  67,
	194:  68,
	226:  68,
	195:  69,
	227:  69,
	196:  70,
	228:  70,
	197:  71,
	229:  71,
	198:  72,
	230:  72,
	66:   73,
	98:   73,
	67:   74,
	99:   74,
	199:  75,
	231:  75,
	68:   76,
	100:  76,
	208:  77,
	240:  77,
	69:   78,
	101:  78,
	200:  79,
	232:  79,
	201:  80,
	233:  80,
	202:  81,
	234:  81,
	203:  82,
	235:  82,
	70:   83,
	102:  83,
	71:   84,
	103:  84,
	72:   85,
	104:  85,
	73:   86,
	105:  86,
	204:  87,
	236:  87,
	205:  88,
	237:  88,
	206:  89,
	238:  89,
	207:  90,
	239:  90,
	74:   91,
	106:  91,
	75:   92,
	107:  92,
	76:   93,
	108:  93,
	77:   94,
	109:  94,
	78:   95,
	110:  95,
	209:  96,
	241:  96,
	79:   97,
	111:  97,
	210:  98,
	242:  98,
	211:  99,
	243:  99,
	212:  100,
	244:  100,
	213:  101,
	245:  101,
	214:  102,
	246:  102,
	216:  103,
	248:  103,
	80:   104,
	112:  104,
	81:   105,
	113:  105,
	82:   106,
	114:  106,
	83:   107,
	115:  107,
	223:  108,
	84:   109,
	116:  109,
	85:   110,
	117:  110,
	217:  111,
	249:  111,
	218:  112,
	250:  112,
	219:  113,
	251:  113,
	220:  114,
	252:  114,
	86:   115,
	118:  115,
	87:   116,
	119:  116,
	88:   117,
	120:  117,
	89:   118,
	121:  118,
	221:  119,
	253:  119,
	255:  120,
	90:   121,
	122:  121,
	222:  122,
	254:  122,
	91:   123,
	92:   124,
	93:   125,
	94:   126,
	95:   127,
	96:   128,
	123:  129,
	124:  130,
	125:  131,
	126:  132,
	215:  133,
	247:  134,
	127:  135,
	8364: 136,
	129:  137,
	8218: 138,
	402:  139,
	8222: 140,
	8230: 141,
	8224: 142,
	8225: 143,
	710:  144,
	8240: 145,
	352:  146,
	8249: 147,
	338:  148,
	141:  149,
	381:  150,
	143:  151,
	144:  152,
	8216: 153,
	8217: 154,
	8220: 155,
	8221: 156,
	8226: 157,
	8211: 158,
	8212: 159,
	732:  160,
	8482: 161,
	353:  162,
	8250: 163,
	339:  164,
	157:  165,
	382:  166,
	376:  167,
	160:  168,
	161:  169,
	162:  170,
	163:  171,
	164:  172,
	165:  173,
	166:  174,
	167:  175,
	168:  176,
	169:  177,
	170:  178,
	171:  179,
	172:  180,
	173:  181,
	174:  182,
	175:  183,
	176:  184,
	177:  185,
	178:  186,
	179:  187,
	180:  188,
	181:  189,
	182:  190,
	183:  191,
	184:  192,
	185:  193,
	186:  194,
	187:  195,
	188:  196,
	189:  197,
	190:  198,
	191:  199,
}
