// Copyright 2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package encodings

// Cp1257_general_ci_RuneWeight returns the weight of a given rune based on its relational sort order from
// the `cp1257_general_ci` collation.
func Cp1257_general_ci_RuneWeight(r rune) int32 {
	weight, ok := cp1257_general_ci_Weights[r]
	if ok {
		return weight
	} else {
		return 2147483647
	}
}

// cp1257_general_ci_Weights contain a map from rune to weight for the `cp1257_general_ci` collation. The
// map primarily contains mappings that have a random order. Mappings that fit into a sequential range (and are long
// enough) are defined in the calling function to save space.
var cp1257_general_ci_Weights = map[rune]int32{
	0:    0,
	1:    1,
	2:    2,
	3:    3,
	4:    4,
	5:    5,
	6:    6,
	7:    7,
	8:    8,
	9:    9,
	10:   10,
	11:   11,
	12:   12,
	13:   13,
	14:   14,
	15:   15,
	16:   16,
	17:   17,
	18:   18,
	19:   19,
	20:   20,
	21:   21,
	22:   22,
	23:   23,
	24:   24,
	25:   25,
	26:   26,
	27:   27,
	28:   28,
	29:   29,
	30:   30,
	31:   31,
	32:   32,
	33:   33,
	34:   34,
	35:   35,
	36:   36,
	37:   37,
	38:   38,
	39:   39,
	40:   40,
	41:   41,
	42:   42,
	43:   43,
	44:   44,
	45:   45,
	46:   46,
	47:   47,
	48:   48,
	49:   49,
	50:   50,
	51:   51,
	52:   52,
	53:   53,
	54:   54,
	55:   55,
	56:   56,
	57:   57,
	58:   58,
	59:   59,
	60:   60,
	61:   61,
	62:   62,
	63:   63,
	64:   64,
	65:   65,
	97:   65,
	196:  65,
	197:  65,
	198:  65,
	228:  65,
	229:  65,
	230:  65,
	256:  65,
	257:  65,
	260:  65,
	261:  65,
	66:   66,
	98:   66,
	67:   67,
	99:   67,
	262:  67,
	263:  67,
	268:  67,
	269:  67,
	68:   68,
	100:  68,
	69:   69,
	101:  69,
	201:  69,
	233:  69,
	274:  69,
	275:  69,
	278:  69,
	279:  69,
	280:  69,
	281:  69,
	70:   70,
	102:  70,
	71:   71,
	103:  71,
	290:  71,
	291:  71,
	72:   72,
	104:  72,
	73:   73,
	105:  73,
	298:  73,
	299:  73,
	302:  73,
	303:  73,
	74:   74,
	106:  74,
	75:   75,
	107:  75,
	310:  75,
	311:  75,
	76:   76,
	108:  76,
	315:  76,
	316:  76,
	321:  76,
	322:  76,
	77:   77,
	109:  77,
	78:   78,
	110:  78,
	323:  78,
	324:  78,
	325:  78,
	326:  78,
	79:   79,
	111:  79,
	211:  79,
	213:  79,
	214:  79,
	216:  79,
	243:  79,
	245:  79,
	246:  79,
	248:  79,
	332:  79,
	333:  79,
	80:   80,
	112:  80,
	81:   81,
	113:  81,
	82:   82,
	114:  82,
	342:  82,
	343:  82,
	83:   83,
	115:  83,
	223:  83,
	346:  83,
	347:  83,
	352:  83,
	353:  83,
	84:   84,
	116:  84,
	85:   85,
	117:  85,
	220:  85,
	252:  85,
	362:  85,
	363:  85,
	370:  85,
	371:  85,
	86:   86,
	118:  86,
	87:   87,
	119:  87,
	88:   88,
	120:  88,
	89:   89,
	121:  89,
	90:   90,
	122:  90,
	377:  90,
	378:  90,
	379:  90,
	380:  90,
	381:  90,
	382:  90,
	91:   91,
	92:   92,
	93:   93,
	94:   94,
	95:   95,
	96:   96,
	123:  97,
	124:  98,
	125:  99,
	126:  100,
	215:  101,
	247:  102,
	127:  103,
	8364: 104,
	8218: 105,
	8222: 106,
	8230: 107,
	8224: 108,
	8225: 109,
	8240: 110,
	8249: 111,
	168:  112,
	711:  113,
	184:  114,
	8216: 115,
	8217: 116,
	8220: 117,
	8221: 118,
	8226: 119,
	8211: 120,
	8212: 121,
	8482: 122,
	8250: 123,
	175:  124,
	731:  125,
	160:  126,
	162:  127,
	163:  128,
	164:  129,
	166:  130,
	167:  131,
	169:  132,
	171:  133,
	172:  134,
	173:  135,
	174:  136,
	176:  137,
	177:  138,
	178:  139,
	179:  140,
	180:  141,
	181:  142,
	182:  143,
	183:  144,
	185:  145,
	187:  146,
	188:  147,
	189:  148,
	190:  149,
	729:  150,
}
