# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie).

## sdk/go/v0.18.8 - 2025-05-14

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.8`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.8).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.8

### Dependencies
- Bump Engine to v0.18.8 by @cwlbraa in https://github.com/dagger/dagger/pull/10405

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.18.7 - 2025-05-13

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.7`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.7).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.7

### Dependencies
- Bump Go to 1.24.3 by @jedevc in https://github.com/dagger/dagger/pull/10346
- Bump Engine to v0.18.7 by @jedevc in https://github.com/dagger/dagger/pull/10389

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.18.6 - 2025-05-06

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.6`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.6).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.6

### Dependencies
- Bump Engine to v0.18.6 by @sipsma in https://github.com/dagger/dagger/pull/10337

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.18.5 - 2025-04-25

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.5`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.5).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.5

### Dependencies
- Bump Engine to v0.18.5 by @sipsma in https://github.com/dagger/dagger/pull/10274

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.18.4 - 2025-04-22

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.4`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.4).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.4

### Added
- Added default value comments for improved documentation by @jedevc in github.com/dagger/dagger/pull/10100

### Dependencies
- Bump Engine to v0.18.4 by @jedevc in https://github.com/dagger/dagger/pull/10235

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.18.3 - 2025-04-14

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.3

### Dependencies
- Bump Engine to v0.18.3 by @jedevc in https://github.com/dagger/dagger/pull/10149

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.18.2 - 2025-04-04

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.2

### Dependencies
- Bump Engine to v0.18.2 by @marcosnils in https://github.com/dagger/dagger/pull/10072

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.18.1 - 2025-04-01

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.1

### Dependencies
- Bump Engine to v0.18.1 by @vito in https://github.com/dagger/dagger/pull/10041

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.18.0 - 2025-03-31

This SDK uses 🚙 Engine + 🚗 CLI version `v0.18.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.18.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.18.0

### Dependencies
- Bump Engine to v0.18.0 by @sipsma in https://github.com/dagger/dagger/pull/10028

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.17.2 - 2025-03-27

This SDK uses 🚙 Engine + 🚗 CLI version `v0.17.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.17.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.17.2

### Dependencies
- Bump Engine to v0.17.2 by @jedevc in https://github.com/dagger/dagger/pull/9989

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.17.1 - 2025-03-24

This SDK uses 🚙 Engine + 🚗 CLI version `v0.17.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.17.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.17.1

### Dependencies
- Bump Engine to v0.17.1 by @cwlbraa in https://github.com/dagger/dagger/pull/9957

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.17.0 - 2025-03-20

This SDK uses 🚙 Engine + 🚗 CLI version `v0.17.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.17.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.17.0

### Added
- New `sdk.config.goprivate` setting in `dagger.json` for go modules by @rajatjindal in https://github.com/dagger/dagger/pull/9323 \
  This setting allows configuring the `GOPRIVATE` env var in the context of building+running the module code, so that private dependencies can be loaded.
- Automatic forwarding of .gitconfig `insteadOf` directives into go module runtime by @rajatjindal in https://github.com/dagger/dagger/pull/9323 \
  In combination with `goprivate`, this can be used to load private dependencies.

### Dependencies
- Bump Engine to v0.17.0 by @jedevc in https://github.com/dagger/dagger/pull/9918

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.16.3 - 2025-03-12

This SDK uses 🚙 Engine + 🚗 CLI version `v0.16.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.16.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.16.3

### Dependencies
- Bump Engine to v0.16.3 by @jedevc in https://github.com/dagger/dagger/pull/9849

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.16.2 - 2025-02-27

This SDK uses 🚙 Engine + 🚗 CLI version `v0.16.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.16.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.16.2

### Dependencies
- Bump Engine to v0.16.2 by @jedevc in https://github.com/dagger/dagger/pull/9728

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.16.1 - 2025-02-19

This SDK uses 🚙 Engine + 🚗 CLI version `v0.16.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.16.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.16.1

### Dependencies
- Bump Engine to v0.16.1 by @sipsma in https://github.com/dagger/dagger/pull/9634

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.16.0 - 2025-02-19

This SDK uses 🚙 Engine + 🚗 CLI version `v0.16.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.16.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.16.0

### Dependencies
- Bump Engine to v0.16.0 by @sipsma in https://github.com/dagger/dagger/pull/9629

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.15.4 - 2025-02-12

This SDK uses 🚙 Engine + 🚗 CLI version `v0.15.4`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.15.4).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.15.4

### Dependencies
- Bump Engine to v0.15.4 by @jedevc in https://github.com/dagger/dagger/pull/9562

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.15.3 - 2025-01-29

This SDK uses 🚙 Engine + 🚗 CLI version `v0.15.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.15.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.15.3

### Dependencies
- Bump Engine to v0.15.3 by @jedevc in https://github.com/dagger/dagger/pull/9469

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.15.2 - 2025-01-14

This SDK uses 🚙 Engine + 🚗 CLI version `v0.15.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.15.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.15.2

### Dependencies
- Bump Engine to v0.15.2 by @jedevc in https://github.com/dagger/dagger/pull/9383

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.15.1 - 2024-12-12

This SDK uses 🚙 Engine + 🚗 CLI version `v0.15.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.15.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.15.1

### Dependencies
- Bump Engine to v0.15.1 by @cwlbraa in https://github.com/dagger/dagger/pull/9183

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.15.0 - 2024-12-11

This SDK uses 🚙 Engine + 🚗 CLI version `v0.15.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.15.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.15.0

### 🔥 Breaking Changes
- Removed deprecated unscoped enum values by @jedevc in https://github.com/dagger/dagger/pull/8669 \
  Enum values must now be accessed with the name prefixed by the name of the
  enum type - for example, `dagger.Shared` becomes `dagger.CacheSharingModeLocked`.
- `ExecErr.Error` no longer contains the values of `Stdout` or `Stderr` by @vito in https://github.com/dagger/dagger/pull/9033 \
  When comparing error values for expected output, use the more specific values.

### Dependencies
- Bump Engine to v0.15.0 by @jedevc in https://github.com/dagger/dagger/pull/9158

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.14.0 - 2024-11-08

This SDK uses 🚙 Engine + 🚗 CLI version `v0.14.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.14.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.14.0


### Dependencies
- Bump Engine to v0.14.0 by @sipsma in https://github.com/dagger/dagger/pull/8900

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.13.7 - 2024-10-31

This SDK uses 🚙 Engine + 🚗 CLI version `v0.13.7`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.13.7).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.13.7


### Changed
- Deprecate unscoped enum values by @jedevc in https://github.com/dagger/dagger/pull/8669 \
  Enum values should now be accessed with the name prefixed by the name of the
  enum type - for example, `dagger.Shared` should become `dagger.CacheSharingModeLocked`.

### Dependencies
- Bump Engine to v0.13.7 by @jedevc in https://github.com/dagger/dagger/pull/8829

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.13.6 - 2024-10-24

This SDK uses 🚙 Engine + 🚗 CLI version `v0.13.6`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.13.6).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.13.6


### Dependencies
- Bump Engine to v0.13.6 by @jedevc in https://github.com/dagger/dagger/pull/8770

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.13.5 - 2024-10-10

This SDK uses 🚙 Engine + 🚗 CLI version `v0.13.5`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.13.5).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.13.5


### Dependencies
- Bump Engine to v0.13.5 by @sipsma in https://github.com/dagger/dagger/pull/8679

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.13.4 - 2024-10-09

This SDK uses 🚙 Engine + 🚗 CLI version `v0.13.4`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.13.4).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.13.4


### Dependencies
- Bump Engine to v0.13.4 by @jedevc in https://github.com/dagger/dagger/pull/8661

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.13.3 - 2024-09-20

This SDK uses 🚙 Engine + 🚗 CLI version `v0.13.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.13.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.13.3


### Dependencies
- Bump Engine to v0.13.3 by @vito in https://github.com/dagger/dagger/pull/8523

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.13.2 - 2024-09-20

This SDK uses 🚙 Engine + 🚗 CLI version `v0.13.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.13.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.13.2


### Dependencies
- Bump Engine to v0.13.2 by @vito in https://github.com/dagger/dagger/pull/8514

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.13.1 - 2024-09-18

This SDK uses 🚙 Engine + 🚗 CLI version `v0.13.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.13.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.13.1


### Dependencies
- Bump Engine to v0.13.1 by @sipsma in https://github.com/dagger/dagger/pull/8488

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.13.0 - 2024-09-11

This SDK uses 🚙 Engine + 🚗 CLI version `v0.13.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.13.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.13.0


### 🔥 Breaking Changes
- Fix optional function arguments being generated as required in codegen by @helderco in https://github.com/dagger/dagger/pull/8106 \
  If there's a Module dependency that has a non-null Function argument with a default value,
  it will change from required to optional, in the generated client bindings.

### Dependencies
- Bump Engine to v0.13.0 by @jedevc in https://github.com/dagger/dagger/pull/8408

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.12.7 - 2024-09-02

This SDK uses 🚙 Engine + 🚗 CLI version `v0.12.7`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.12.7).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.12.7


### Dependencies
- Bump Engine to v0.12.7 by @jedevc in https://github.com/dagger/dagger/pull/8299

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.12.6 - 2024-08-29

This SDK uses 🚙 Engine + 🚗 CLI version `v0.12.6`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.12.6).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.12.6


### Fixed
- Correctly handle CRLF line endings during comment parsing by @jedevc in https://github.com/dagger/dagger/pull/8217 \
  This previously could result in function argument doc-strings not being
  correctly found, and would interferet st with pragma parsing (e.g. `// +optional`
  and `// +default`).

### Dependencies
- Update to use [Go 1.23](https://go.dev/doc/go1.23) by @jedevc in https://github.com/dagger/dagger/pull/7670 \
  This allows using go 1.23 in modules.

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.12.5 - 2024-08-15

This SDK uses 🚙 Engine + 🚗 CLI version `v0.12.5`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.12.5).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.12.5


### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.12.4 - 2024-08-01

This SDK uses 🚙 Engine + 🚗 CLI version `v0.12.4`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.12.4).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.12.4


### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.12.3 - 2024-07-25

This SDK uses 🚙 Engine + 🚗 CLI version `v0.12.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.12.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.12.3


### Dependencies
- Bump Engine to v0.12.3 by @github-actions in https://github.com/dagger/dagger/pull/8039

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.12.2 - 2024-07-22

This SDK uses 🚙 Engine + 🚗 CLI version `v0.12.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.12.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.12.2


### Dependencies
- Bump Engine to v0.12.2 by @github-actions in https://github.com/dagger/dagger/pull/8006

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.12.1 - 2024-07-18

This SDK uses 🚙 Engine + 🚗 CLI version `v0.12.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.12.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.12.1


### Dependencies
- Bump Engine to v0.12.1 by @github-actions in https://github.com/dagger/dagger/pull/7978

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.12.0 - 2024-07-12

This SDK uses 🚙 Engine + 🚗 CLI version `v0.12.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.12.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.12.0


### 🔥 Breaking Changes
- Don't return `Void` by @helderco in https://github.com/dagger/dagger/pull/7773
- Remove top level type aliases for modules by @jedevc in https://github.com/dagger/dagger/pull/7831 \
  Modules must now use `*dagger.Container` (and similar) instead of `*Container` directly. 

### Dependencies
- Bump Engine to v0.12.0 by @github-actions in https://github.com/dagger/dagger/pull/7903

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.9 - 2024-06-24

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.9`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.9).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.9


### Dependencies
- Bump Engine to v0.11.9 by @github-actions in https://github.com/dagger/dagger/pull/7746

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.8 - 2024-06-18

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.8`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.8).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.8


### Dependencies
- Bump Engine to v0.11.8 by @github-actions in https://github.com/dagger/dagger/pull/7690

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.8-rc.1 - 2024-06-12

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.7`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.7).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.8-rc.1


### Fixed
- Retract v0.11.7 by @gerhard in https://github.com/dagger/dagger/pull/7642
- Improve consistency of codegen ordering by @jedevc in https://github.com/dagger/dagger/pull/7543

### Dependencies
- Bump Engine to v0.11.7 by @github-actions in https://github.com/dagger/dagger/pull/7615

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.6 - 2024-05-30

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.6`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.6).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.6


### Dependencies
- Bump Engine to v0.11.6 by @github-actions in https://github.com/dagger/dagger/pull/7516

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.5 - 2024-05-28

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.5`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.5).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.5


### Dependencies
- Bump Engine to v0.11.5 by @github-actions in https://github.com/dagger/dagger/pull/7482

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.4 - 2024-05-09

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.4`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.4).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.4


### Dependencies
- Bump Engine to v0.11.4 by @github-actions in https://github.com/dagger/dagger/pull/7345

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.3 - 2024-05-08

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.3


### Fixed
- Respect existing go.mod during module initialization by @jedevc in https://github.com/dagger/dagger/pull/7194

### Dependencies
- Bump Engine to v0.11.3 by @github-actions in https://github.com/dagger/dagger/pull/7318

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.2 - 2024-04-26

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.2

### Fixed
- Allow windows CRLF line-endings in go pragmas by @jedevc in https://github.com/dagger/dagger/pull/7121

### Dependencies
- Bump Engine to v0.11.2 by @github-actions in https://github.com/dagger/dagger/pull/7204
- Bump Dagger Modules go version to 1.22 by @jedevc in https://github.com/dagger/dagger/pull/7109

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.1 - 2024-04-16

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.1

### Fixed
- Automatically add `internal/telemetry` directory to generated `.gitignore` files by @yann-soubeyrand in https://github.com/dagger/dagger/issues/7019

### Dependencies
- Bump Engine to v0.11.1 by @github-actions in https://github.com/dagger/dagger/pull/7100

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.11.0 - 2024-04-04

This SDK uses 🚙 Engine + 🚗 CLI version `v0.11.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.11.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.11.0


### Dependencies
- Bump Engine to v0.11.0 by @github-actions in https://github.com/dagger/dagger/pull/7016

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.10.3 - 2024-03-26

This SDK uses 🚙 Engine + 🚗 CLI version `v0.10.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.10.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.10.3


### Dependencies
- Bump Engine to v0.10.3 by @github-actions in https://github.com/dagger/dagger/pull/6936

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.10.2 - 2024-03-12

This SDK uses 🚙 Engine + 🚗 CLI version `v0.10.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.10.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.10.2


### Dependencies
- Bump Engine to v0.10.2 by @github-actions in https://github.com/dagger/dagger/pull/6871

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.10.1 - 2024-03-05

This SDK uses 🚙 Engine + 🚗 CLI version `v0.10.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.10.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.10.1


### Dependencies
- Bump Engine to v0.10.1 by @github-actions in https://github.com/dagger/dagger/pull/6826

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.10.0 - 2024-02-27

This SDK uses 🚙 Engine + 🚗 CLI version `v0.10.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.10.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.10.0


### Dependencies
- Bump Engine to v0.10.0 by @github-actions in https://github.com/dagger/dagger/pull/6758

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.11 - 2024-02-20

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.11`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.11).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.11


### Dependencies
- Bump Engine to v0.9.11 by @github-actions in https://github.com/dagger/dagger/pull/6700

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.10 - 2024-02-13

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.10`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.10).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.10


### Dependencies
- Bump Engine to v0.9.10 by @github-actions in https://github.com/dagger/dagger/pull/6656

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.9 - 2024-02-09

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.9`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.9).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.9


### Dependencies
- Bump Engine to v0.9.9 by @github-actions in https://github.com/dagger/dagger/pull/6636

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.8 - 2024-02-01

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.8`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.8).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.8


### Dependencies
- Bump Engine to v0.9.8 by @github-actions in https://github.com/dagger/dagger/pull/6557

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.7 - 2024-01-19

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.7`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.7).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.7


### Dependencies
- Bump Engine to v0.9.7 by @github-actions in https://github.com/dagger/dagger/pull/6460

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.6 - 2024-01-12

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.6`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.6).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.6


### Added
- Add a default global client at dagger.io/dagger/dag by @jedevc in https://github.com/dagger/dagger/pull/6326

### Dependencies
- Bump Engine to v0.9.6 by @github-actions in https://github.com/dagger/dagger/pull/6410

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.5 - 2023-12-21

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.5`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.5).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.5


### Dependencies
- Bump Engine to v0.9.5 by @github-actions in https://github.com/dagger/dagger/pull/6309

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.4 - 2023-12-08

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.4`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.4).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.4


### Dependencies
- Bump Engine to v0.9.4 by @github-actions in https://github.com/dagger/dagger/pull/6239

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.3 - 2023-11-03

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.3


### Dependencies
- Bump Engine to v0.9.3 by @github-actions in https://github.com/dagger/dagger/pull/6061

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.2 - 2023-10-30

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.2

### Dependencies

- Bump Engine to v0.9.2 by @github-actions in https://github.com/dagger/dagger/pull/6024

### What to do next

- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.1 - 2023-10-26

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.1


### Dependencies
- Bump Engine to v0.9.1 by @github-actions in https://github.com/dagger/dagger/pull/5969

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.9.0 - 2023-10-20

This SDK uses 🚙 Engine + 🚗 CLI version `v0.9.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.9.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.9.0

### 🔥 Breaking Changes

- engine: new services API with container <=> host networking, explicit start/stop by @vito in https://github.com/dagger/dagger/pull/5557
- implement new conventions for IDable objects by @vito in https://github.com/dagger/dagger/pull/5881

### Dependencies

- Bump Engine to v0.9.0 by @github-actions in https://github.com/dagger/dagger/pull/5940

### What to do next

- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.8 - 2023-10-11

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.8`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.8).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.8


### Dependencies
- Bump Engine to v0.8.8 by @github-actions in https://github.com/dagger/dagger/pull/5877

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.7 - 2023-09-18

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.7`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.7).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.7


### Dependencies
- Bump Engine to v0.8.7 by @github-actions in https://github.com/dagger/dagger/pull/5799

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.6 - 2023-09-18

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.6`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.6).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.6


### Fixed
- Check and panic if a nil pointer is sent as argument to a query by @TomChv in https://github.com/dagger/dagger/pull/5785

### Dependencies
- Bump Engine to v0.8.6 by @github-actions in https://github.com/dagger/dagger/pull/5795

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.5 - 2023-09-13

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.5`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.5).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.5


### Dependencies
- Bump Engine to v0.8.5 by @github-actions in https://github.com/dagger/dagger/pull/5779

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.4 - 2023-08-17

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.4`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.4).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.4


### Dependencies
- Bump Engine to v0.8.4 by @github-actions in https://github.com/dagger/dagger/pull/5657

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.3 - 2023-08-16

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.3


### Dependencies
- Bump Engine to v0.8.3 by @github-actions in https://github.com/dagger/dagger/pull/5643

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.2 - 2023-08-10

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.2`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.2).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.2


### Fixed
- Expand `~` to home when using custom CLI path by @wingyplus in https://github.com/dagger/dagger/pull/5555

### Dependencies
- Bump Engine to v0.8.2 by @github-actions in https://github.com/dagger/dagger/pull/5613

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.1 - 2023-08-04

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.1`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.1).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.1


### Dependencies
- Bump Engine to v0.8.1 by @github-actions in https://github.com/dagger/dagger/pull/5581

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.8.0 - 2023-08-03

This SDK uses 🚙 Engine + 🚗 CLI version `v0.8.0`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.8.0).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.8.0

### Added
- Print progress status during automatic Engine provisioning and establishing client connection by @TomChv in https://github.com/dagger/dagger/pull/5488
- Show warning on version mismatch between Engine and SDK by @TomChv in https://github.com/dagger/dagger/pull/5315

### Dependencies
- Bump Engine to v0.8.0 by @github-actions in https://github.com/dagger/dagger/pull/5567

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.7.4 - 2023-07-19

This SDK uses 🚙 Engine + 🚗 CLI version `v0.6.4`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.6.4).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.7.4

### Added
- Added the `With` method to more types by @helderco in https://github.com/dagger/dagger/pull/5447

### Dependencies
- Bump Engine to v0.6.4 by @github-actions in https://github.com/dagger/dagger/pull/5489

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)

## sdk/go/v0.7.3 - 2023-07-04

This SDK uses 🚙 Engine + 🚗 CLI version `v0.6.3`. [See what changed in that release](https://github.com/dagger/dagger/releases/tag/v0.6.3).

🐹 https://pkg.go.dev/dagger.io/dagger@v0.7.3

### Dependencies
- Bump Engine to v0.6.3 by @github-actions in https://github.com/dagger/dagger/pull/5407

### What to do next
- Read the [documentation](https://docs.dagger.io/sdk/go)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)
