// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: parca/query/v1alpha1/query.proto

package queryv1alpha1connect

import (
	v1alpha1 "buf.build/gen/go/parca-dev/parca/protocolbuffers/go/parca/query/v1alpha1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// QueryServiceName is the fully-qualified name of the QueryService service.
	QueryServiceName = "parca.query.v1alpha1.QueryService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// QueryServiceQueryRangeProcedure is the fully-qualified name of the QueryService's QueryRange RPC.
	QueryServiceQueryRangeProcedure = "/parca.query.v1alpha1.QueryService/QueryRange"
	// QueryServiceQueryProcedure is the fully-qualified name of the QueryService's Query RPC.
	QueryServiceQueryProcedure = "/parca.query.v1alpha1.QueryService/Query"
	// QueryServiceSeriesProcedure is the fully-qualified name of the QueryService's Series RPC.
	QueryServiceSeriesProcedure = "/parca.query.v1alpha1.QueryService/Series"
	// QueryServiceProfileTypesProcedure is the fully-qualified name of the QueryService's ProfileTypes
	// RPC.
	QueryServiceProfileTypesProcedure = "/parca.query.v1alpha1.QueryService/ProfileTypes"
	// QueryServiceLabelsProcedure is the fully-qualified name of the QueryService's Labels RPC.
	QueryServiceLabelsProcedure = "/parca.query.v1alpha1.QueryService/Labels"
	// QueryServiceValuesProcedure is the fully-qualified name of the QueryService's Values RPC.
	QueryServiceValuesProcedure = "/parca.query.v1alpha1.QueryService/Values"
	// QueryServiceShareProfileProcedure is the fully-qualified name of the QueryService's ShareProfile
	// RPC.
	QueryServiceShareProfileProcedure = "/parca.query.v1alpha1.QueryService/ShareProfile"
)

// QueryServiceClient is a client for the parca.query.v1alpha1.QueryService service.
type QueryServiceClient interface {
	// QueryRange performs a profile query over a time range
	QueryRange(context.Context, *connect.Request[v1alpha1.QueryRangeRequest]) (*connect.Response[v1alpha1.QueryRangeResponse], error)
	// Query performs a profile query
	Query(context.Context, *connect.Request[v1alpha1.QueryRequest]) (*connect.Response[v1alpha1.QueryResponse], error)
	// Series is unimplemented
	Series(context.Context, *connect.Request[v1alpha1.SeriesRequest]) (*connect.Response[v1alpha1.SeriesResponse], error)
	// ProfileTypes returns the list of available profile types.
	ProfileTypes(context.Context, *connect.Request[v1alpha1.ProfileTypesRequest]) (*connect.Response[v1alpha1.ProfileTypesResponse], error)
	// Labels returns the set of label names against a given matching string and time frame
	Labels(context.Context, *connect.Request[v1alpha1.LabelsRequest]) (*connect.Response[v1alpha1.LabelsResponse], error)
	// Values returns the set of values that match a given label and time frame
	Values(context.Context, *connect.Request[v1alpha1.ValuesRequest]) (*connect.Response[v1alpha1.ValuesResponse], error)
	// ShareProfile uploads the given profile to pprof.me and returns a link to the profile.
	ShareProfile(context.Context, *connect.Request[v1alpha1.ShareProfileRequest]) (*connect.Response[v1alpha1.ShareProfileResponse], error)
}

// NewQueryServiceClient constructs a client for the parca.query.v1alpha1.QueryService service. By
// default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses,
// and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewQueryServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) QueryServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	queryServiceMethods := v1alpha1.File_parca_query_v1alpha1_query_proto.Services().ByName("QueryService").Methods()
	return &queryServiceClient{
		queryRange: connect.NewClient[v1alpha1.QueryRangeRequest, v1alpha1.QueryRangeResponse](
			httpClient,
			baseURL+QueryServiceQueryRangeProcedure,
			connect.WithSchema(queryServiceMethods.ByName("QueryRange")),
			connect.WithClientOptions(opts...),
		),
		query: connect.NewClient[v1alpha1.QueryRequest, v1alpha1.QueryResponse](
			httpClient,
			baseURL+QueryServiceQueryProcedure,
			connect.WithSchema(queryServiceMethods.ByName("Query")),
			connect.WithClientOptions(opts...),
		),
		series: connect.NewClient[v1alpha1.SeriesRequest, v1alpha1.SeriesResponse](
			httpClient,
			baseURL+QueryServiceSeriesProcedure,
			connect.WithSchema(queryServiceMethods.ByName("Series")),
			connect.WithClientOptions(opts...),
		),
		profileTypes: connect.NewClient[v1alpha1.ProfileTypesRequest, v1alpha1.ProfileTypesResponse](
			httpClient,
			baseURL+QueryServiceProfileTypesProcedure,
			connect.WithSchema(queryServiceMethods.ByName("ProfileTypes")),
			connect.WithClientOptions(opts...),
		),
		labels: connect.NewClient[v1alpha1.LabelsRequest, v1alpha1.LabelsResponse](
			httpClient,
			baseURL+QueryServiceLabelsProcedure,
			connect.WithSchema(queryServiceMethods.ByName("Labels")),
			connect.WithClientOptions(opts...),
		),
		values: connect.NewClient[v1alpha1.ValuesRequest, v1alpha1.ValuesResponse](
			httpClient,
			baseURL+QueryServiceValuesProcedure,
			connect.WithSchema(queryServiceMethods.ByName("Values")),
			connect.WithClientOptions(opts...),
		),
		shareProfile: connect.NewClient[v1alpha1.ShareProfileRequest, v1alpha1.ShareProfileResponse](
			httpClient,
			baseURL+QueryServiceShareProfileProcedure,
			connect.WithSchema(queryServiceMethods.ByName("ShareProfile")),
			connect.WithClientOptions(opts...),
		),
	}
}

// queryServiceClient implements QueryServiceClient.
type queryServiceClient struct {
	queryRange   *connect.Client[v1alpha1.QueryRangeRequest, v1alpha1.QueryRangeResponse]
	query        *connect.Client[v1alpha1.QueryRequest, v1alpha1.QueryResponse]
	series       *connect.Client[v1alpha1.SeriesRequest, v1alpha1.SeriesResponse]
	profileTypes *connect.Client[v1alpha1.ProfileTypesRequest, v1alpha1.ProfileTypesResponse]
	labels       *connect.Client[v1alpha1.LabelsRequest, v1alpha1.LabelsResponse]
	values       *connect.Client[v1alpha1.ValuesRequest, v1alpha1.ValuesResponse]
	shareProfile *connect.Client[v1alpha1.ShareProfileRequest, v1alpha1.ShareProfileResponse]
}

// QueryRange calls parca.query.v1alpha1.QueryService.QueryRange.
func (c *queryServiceClient) QueryRange(ctx context.Context, req *connect.Request[v1alpha1.QueryRangeRequest]) (*connect.Response[v1alpha1.QueryRangeResponse], error) {
	return c.queryRange.CallUnary(ctx, req)
}

// Query calls parca.query.v1alpha1.QueryService.Query.
func (c *queryServiceClient) Query(ctx context.Context, req *connect.Request[v1alpha1.QueryRequest]) (*connect.Response[v1alpha1.QueryResponse], error) {
	return c.query.CallUnary(ctx, req)
}

// Series calls parca.query.v1alpha1.QueryService.Series.
func (c *queryServiceClient) Series(ctx context.Context, req *connect.Request[v1alpha1.SeriesRequest]) (*connect.Response[v1alpha1.SeriesResponse], error) {
	return c.series.CallUnary(ctx, req)
}

// ProfileTypes calls parca.query.v1alpha1.QueryService.ProfileTypes.
func (c *queryServiceClient) ProfileTypes(ctx context.Context, req *connect.Request[v1alpha1.ProfileTypesRequest]) (*connect.Response[v1alpha1.ProfileTypesResponse], error) {
	return c.profileTypes.CallUnary(ctx, req)
}

// Labels calls parca.query.v1alpha1.QueryService.Labels.
func (c *queryServiceClient) Labels(ctx context.Context, req *connect.Request[v1alpha1.LabelsRequest]) (*connect.Response[v1alpha1.LabelsResponse], error) {
	return c.labels.CallUnary(ctx, req)
}

// Values calls parca.query.v1alpha1.QueryService.Values.
func (c *queryServiceClient) Values(ctx context.Context, req *connect.Request[v1alpha1.ValuesRequest]) (*connect.Response[v1alpha1.ValuesResponse], error) {
	return c.values.CallUnary(ctx, req)
}

// ShareProfile calls parca.query.v1alpha1.QueryService.ShareProfile.
func (c *queryServiceClient) ShareProfile(ctx context.Context, req *connect.Request[v1alpha1.ShareProfileRequest]) (*connect.Response[v1alpha1.ShareProfileResponse], error) {
	return c.shareProfile.CallUnary(ctx, req)
}

// QueryServiceHandler is an implementation of the parca.query.v1alpha1.QueryService service.
type QueryServiceHandler interface {
	// QueryRange performs a profile query over a time range
	QueryRange(context.Context, *connect.Request[v1alpha1.QueryRangeRequest]) (*connect.Response[v1alpha1.QueryRangeResponse], error)
	// Query performs a profile query
	Query(context.Context, *connect.Request[v1alpha1.QueryRequest]) (*connect.Response[v1alpha1.QueryResponse], error)
	// Series is unimplemented
	Series(context.Context, *connect.Request[v1alpha1.SeriesRequest]) (*connect.Response[v1alpha1.SeriesResponse], error)
	// ProfileTypes returns the list of available profile types.
	ProfileTypes(context.Context, *connect.Request[v1alpha1.ProfileTypesRequest]) (*connect.Response[v1alpha1.ProfileTypesResponse], error)
	// Labels returns the set of label names against a given matching string and time frame
	Labels(context.Context, *connect.Request[v1alpha1.LabelsRequest]) (*connect.Response[v1alpha1.LabelsResponse], error)
	// Values returns the set of values that match a given label and time frame
	Values(context.Context, *connect.Request[v1alpha1.ValuesRequest]) (*connect.Response[v1alpha1.ValuesResponse], error)
	// ShareProfile uploads the given profile to pprof.me and returns a link to the profile.
	ShareProfile(context.Context, *connect.Request[v1alpha1.ShareProfileRequest]) (*connect.Response[v1alpha1.ShareProfileResponse], error)
}

// NewQueryServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewQueryServiceHandler(svc QueryServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	queryServiceMethods := v1alpha1.File_parca_query_v1alpha1_query_proto.Services().ByName("QueryService").Methods()
	queryServiceQueryRangeHandler := connect.NewUnaryHandler(
		QueryServiceQueryRangeProcedure,
		svc.QueryRange,
		connect.WithSchema(queryServiceMethods.ByName("QueryRange")),
		connect.WithHandlerOptions(opts...),
	)
	queryServiceQueryHandler := connect.NewUnaryHandler(
		QueryServiceQueryProcedure,
		svc.Query,
		connect.WithSchema(queryServiceMethods.ByName("Query")),
		connect.WithHandlerOptions(opts...),
	)
	queryServiceSeriesHandler := connect.NewUnaryHandler(
		QueryServiceSeriesProcedure,
		svc.Series,
		connect.WithSchema(queryServiceMethods.ByName("Series")),
		connect.WithHandlerOptions(opts...),
	)
	queryServiceProfileTypesHandler := connect.NewUnaryHandler(
		QueryServiceProfileTypesProcedure,
		svc.ProfileTypes,
		connect.WithSchema(queryServiceMethods.ByName("ProfileTypes")),
		connect.WithHandlerOptions(opts...),
	)
	queryServiceLabelsHandler := connect.NewUnaryHandler(
		QueryServiceLabelsProcedure,
		svc.Labels,
		connect.WithSchema(queryServiceMethods.ByName("Labels")),
		connect.WithHandlerOptions(opts...),
	)
	queryServiceValuesHandler := connect.NewUnaryHandler(
		QueryServiceValuesProcedure,
		svc.Values,
		connect.WithSchema(queryServiceMethods.ByName("Values")),
		connect.WithHandlerOptions(opts...),
	)
	queryServiceShareProfileHandler := connect.NewUnaryHandler(
		QueryServiceShareProfileProcedure,
		svc.ShareProfile,
		connect.WithSchema(queryServiceMethods.ByName("ShareProfile")),
		connect.WithHandlerOptions(opts...),
	)
	return "/parca.query.v1alpha1.QueryService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case QueryServiceQueryRangeProcedure:
			queryServiceQueryRangeHandler.ServeHTTP(w, r)
		case QueryServiceQueryProcedure:
			queryServiceQueryHandler.ServeHTTP(w, r)
		case QueryServiceSeriesProcedure:
			queryServiceSeriesHandler.ServeHTTP(w, r)
		case QueryServiceProfileTypesProcedure:
			queryServiceProfileTypesHandler.ServeHTTP(w, r)
		case QueryServiceLabelsProcedure:
			queryServiceLabelsHandler.ServeHTTP(w, r)
		case QueryServiceValuesProcedure:
			queryServiceValuesHandler.ServeHTTP(w, r)
		case QueryServiceShareProfileProcedure:
			queryServiceShareProfileHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedQueryServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedQueryServiceHandler struct{}

func (UnimplementedQueryServiceHandler) QueryRange(context.Context, *connect.Request[v1alpha1.QueryRangeRequest]) (*connect.Response[v1alpha1.QueryRangeResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("parca.query.v1alpha1.QueryService.QueryRange is not implemented"))
}

func (UnimplementedQueryServiceHandler) Query(context.Context, *connect.Request[v1alpha1.QueryRequest]) (*connect.Response[v1alpha1.QueryResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("parca.query.v1alpha1.QueryService.Query is not implemented"))
}

func (UnimplementedQueryServiceHandler) Series(context.Context, *connect.Request[v1alpha1.SeriesRequest]) (*connect.Response[v1alpha1.SeriesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("parca.query.v1alpha1.QueryService.Series is not implemented"))
}

func (UnimplementedQueryServiceHandler) ProfileTypes(context.Context, *connect.Request[v1alpha1.ProfileTypesRequest]) (*connect.Response[v1alpha1.ProfileTypesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("parca.query.v1alpha1.QueryService.ProfileTypes is not implemented"))
}

func (UnimplementedQueryServiceHandler) Labels(context.Context, *connect.Request[v1alpha1.LabelsRequest]) (*connect.Response[v1alpha1.LabelsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("parca.query.v1alpha1.QueryService.Labels is not implemented"))
}

func (UnimplementedQueryServiceHandler) Values(context.Context, *connect.Request[v1alpha1.ValuesRequest]) (*connect.Response[v1alpha1.ValuesResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("parca.query.v1alpha1.QueryService.Values is not implemented"))
}

func (UnimplementedQueryServiceHandler) ShareProfile(context.Context, *connect.Request[v1alpha1.ShareProfileRequest]) (*connect.Response[v1alpha1.ShareProfileResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("parca.query.v1alpha1.QueryService.ShareProfile is not implemented"))
}
