//
// This file is generated by grafana-app-sdk
// DO NOT EDIT
//

package apis

import (
	"encoding/json"
	"fmt"
	"strings"

	"github.com/grafana/grafana-app-sdk/app"
	"github.com/grafana/grafana-app-sdk/resource"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/kube-openapi/pkg/spec3"
	"k8s.io/kube-openapi/pkg/validation/spec"

	v1alpha1 "github.com/grafana/grafana/apps/shorturl/pkg/apis/shorturl/v1alpha1"
)

var (
	rawSchemaShortURLv1alpha1     = []byte(`{"OperatorState":{"additionalProperties":false,"properties":{"descriptiveState":{"description":"descriptiveState is an optional more descriptive state field which has no requirements on format","type":"string"},"details":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"details contains any extra information that is operator-specific","type":"object"},"lastEvaluation":{"description":"lastEvaluation is the ResourceVersion last evaluated","type":"string"},"state":{"description":"state describes the state of the lastEvaluation.\nIt is limited to three possible states for machine evaluation.","enum":["success","in_progress","failed"],"type":"string"}},"required":["lastEvaluation","state"],"type":"object"},"ShortURL":{"properties":{"spec":{"$ref":"#/components/schemas/spec"},"status":{"$ref":"#/components/schemas/status"}},"required":["spec"]},"spec":{"additionalProperties":false,"properties":{"path":{"description":"The original path to where the short url is linking too e.g. https://localhost:3000/eer8i1kictngga/new-dashboard-with-lib-panel","type":"string"}},"required":["path"],"type":"object"},"status":{"additionalProperties":false,"properties":{"additionalFields":{"additionalProperties":{"additionalProperties":{},"type":"object"},"description":"additionalFields is reserved for future use","type":"object"},"lastSeenAt":{"description":"The last time the short URL was used, 0 is the initial value","type":"integer"},"operatorStates":{"additionalProperties":{"$ref":"#/components/schemas/OperatorState"},"description":"operatorStates is a map of operator ID to operator state evaluations.\nAny operator which consumes this kind SHOULD add its state evaluation information to this field.","type":"object"}},"required":["lastSeenAt"],"type":"object"}}`)
	versionSchemaShortURLv1alpha1 app.VersionSchema
	_                             = json.Unmarshal(rawSchemaShortURLv1alpha1, &versionSchemaShortURLv1alpha1)
)

var appManifestData = app.ManifestData{
	AppName:          "shorturl",
	Group:            "shorturl.grafana.app",
	PreferredVersion: "v1alpha1",
	Versions: []app.ManifestVersion{
		{
			Name:   "v1alpha1",
			Served: true,
			Kinds: []app.ManifestVersionKind{
				{
					Kind:       "ShortURL",
					Plural:     "ShortURLs",
					Scope:      "Namespaced",
					Conversion: false,
					Admission: &app.AdmissionCapabilities{
						Validation: &app.ValidationCapability{
							Operations: []app.AdmissionOperation{
								app.AdmissionOperationCreate,
								app.AdmissionOperationUpdate,
							},
						},
					},
					Schema: &versionSchemaShortURLv1alpha1,
					Routes: map[string]spec3.PathProps{
						"/goto": {
							Get: &spec3.Operation{
								OperationProps: spec3.OperationProps{

									OperationId: "getGoto",

									Responses: &spec3.Responses{
										ResponsesProps: spec3.ResponsesProps{
											Default: &spec3.Response{
												ResponseProps: spec3.ResponseProps{
													Description: "Default OK response",
													Content: map[string]*spec3.MediaType{
														"application/json": {
															MediaTypeProps: spec3.MediaTypeProps{
																Schema: &spec.Schema{
																	SchemaProps: spec.SchemaProps{
																		Type: []string{"object"},
																		Properties: map[string]spec.Schema{
																			"url": {
																				SchemaProps: spec.SchemaProps{
																					Type: []string{"string"},
																				},
																			},
																		},
																		Required: []string{
																			"url",
																		},
																	}},
															}},
													},
												},
											},
										}},
								},
							},
						},
					},
				},
			},
			Routes: app.ManifestVersionRoutes{
				Namespaced: map[string]spec3.PathProps{},
				Cluster:    map[string]spec3.PathProps{},
				Schemas:    map[string]spec.Schema{},
			},
		},
	},
}

func LocalManifest() app.Manifest {
	return app.NewEmbeddedManifest(appManifestData)
}

func RemoteManifest() app.Manifest {
	return app.NewAPIServerManifest("shorturl")
}

var kindVersionToGoType = map[string]resource.Kind{
	"ShortURL/v1alpha1": v1alpha1.ShortURLKind(),
}

// ManifestGoTypeAssociator returns the associated resource.Kind instance for a given Kind and Version, if one exists.
// If there is no association for the provided Kind and Version, exists will return false.
func ManifestGoTypeAssociator(kind, version string) (goType resource.Kind, exists bool) {
	goType, exists = kindVersionToGoType[fmt.Sprintf("%s/%s", kind, version)]
	return goType, exists
}

var customRouteToGoResponseType = map[string]any{
	"v1alpha1|ShortURL|goto|GET": v1alpha1.GetGoto{},
}

// ManifestCustomRouteResponsesAssociator returns the associated response go type for a given kind, version, custom route path, and method, if one exists.
// kind may be empty for custom routes which are not kind subroutes. Leading slashes are removed from subroute paths.
// If there is no association for the provided kind, version, custom route path, and method, exists will return false.
// Resource routes (those without a kind) should prefix their route with "<namespace>/" if the route is namespaced (otherwise the route is assumed to be cluster-scope)
func ManifestCustomRouteResponsesAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoResponseType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoParamsType = map[string]runtime.Object{}

func ManifestCustomRouteQueryAssociator(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoParamsType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoRequestBodyType = map[string]any{}

func ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoRequestBodyType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

type GoTypeAssociator struct{}

func NewGoTypeAssociator() *GoTypeAssociator {
	return &GoTypeAssociator{}
}

func (g *GoTypeAssociator) KindToGoType(kind, version string) (goType resource.Kind, exists bool) {
	return ManifestGoTypeAssociator(kind, version)
}
func (g *GoTypeAssociator) CustomRouteReturnGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteResponsesAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteQueryGoType(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	return ManifestCustomRouteQueryAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteRequestBodyGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb)
}
