// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by client-gen. DO NOT EDIT.

package v0alpha1

import (
	http "net/http"

	provisioningv0alpha1 "github.com/grafana/grafana/apps/provisioning/pkg/apis/provisioning/v0alpha1"
	scheme "github.com/grafana/grafana/apps/provisioning/pkg/generated/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type ProvisioningV0alpha1Interface interface {
	RESTClient() rest.Interface
	HistoricJobsGetter
	JobsGetter
	RepositoriesGetter
}

// ProvisioningV0alpha1Client is used to interact with features provided by the provisioning.grafana.app group.
type ProvisioningV0alpha1Client struct {
	restClient rest.Interface
}

func (c *ProvisioningV0alpha1Client) HistoricJobs(namespace string) HistoricJobInterface {
	return newHistoricJobs(c, namespace)
}

func (c *ProvisioningV0alpha1Client) Jobs(namespace string) JobInterface {
	return newJobs(c, namespace)
}

func (c *ProvisioningV0alpha1Client) Repositories(namespace string) RepositoryInterface {
	return newRepositories(c, namespace)
}

// NewForConfig creates a new ProvisioningV0alpha1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*ProvisioningV0alpha1Client, error) {
	config := *c
	setConfigDefaults(&config)
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new ProvisioningV0alpha1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*ProvisioningV0alpha1Client, error) {
	config := *c
	setConfigDefaults(&config)
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &ProvisioningV0alpha1Client{client}, nil
}

// NewForConfigOrDie creates a new ProvisioningV0alpha1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *ProvisioningV0alpha1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new ProvisioningV0alpha1Client for the given RESTClient.
func New(c rest.Interface) *ProvisioningV0alpha1Client {
	return &ProvisioningV0alpha1Client{c}
}

func setConfigDefaults(config *rest.Config) {
	gv := provisioningv0alpha1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = rest.CodecFactoryForGeneratedClient(scheme.Scheme, scheme.Codecs).WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *ProvisioningV0alpha1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
