//
// This file is generated by grafana-app-sdk
// DO NOT EDIT
//

package apis

import (
	"encoding/json"
	"fmt"
	"strings"

	"github.com/grafana/grafana-app-sdk/app"
	"github.com/grafana/grafana-app-sdk/resource"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/kube-openapi/pkg/spec3"
	"k8s.io/kube-openapi/pkg/validation/spec"

	v1alpha1 "github.com/grafana/grafana/apps/preferences/pkg/apis/preferences/v1alpha1"
)

var (
	rawSchemaPreferencesv1alpha1     = []byte(`{"CookiePreferences":{"additionalProperties":false,"properties":{"analytics":{"additionalProperties":{},"type":"object"},"functional":{"additionalProperties":{},"type":"object"},"performance":{"additionalProperties":{},"type":"object"}},"type":"object"},"NavbarPreference":{"additionalProperties":false,"properties":{"bookmarkUrls":{"items":{"type":"string"},"type":"array"}},"required":["bookmarkUrls"],"type":"object"},"Preferences":{"properties":{"spec":{"$ref":"#/components/schemas/spec"}},"required":["spec"]},"QueryHistoryPreference":{"additionalProperties":false,"properties":{"homeTab":{"description":"one of: '' | 'query' | 'starred';","type":"string"}},"type":"object"},"spec":{"additionalProperties":false,"properties":{"cookiePreferences":{"$ref":"#/components/schemas/CookiePreferences","description":"Cookie preferences"},"homeDashboardUID":{"description":"UID for the home dashboard","type":"string"},"language":{"description":"Selected language (beta)","type":"string"},"navbar":{"$ref":"#/components/schemas/NavbarPreference","description":"Navigation preferences"},"queryHistory":{"$ref":"#/components/schemas/QueryHistoryPreference","description":"Explore query history preferences"},"regionalFormat":{"description":"Selected locale (beta)","type":"string"},"theme":{"description":"light, dark, empty is default","type":"string"},"timezone":{"description":"The timezone selection\nTODO: this should use the timezone defined in common","type":"string"},"weekStart":{"description":"day of the week (sunday, monday, etc)","type":"string"}},"type":"object"}}`)
	versionSchemaPreferencesv1alpha1 app.VersionSchema
	_                                = json.Unmarshal(rawSchemaPreferencesv1alpha1, &versionSchemaPreferencesv1alpha1)
	rawSchemaStarsv1alpha1           = []byte(`{"Resource":{"additionalProperties":false,"properties":{"group":{"type":"string"},"kind":{"type":"string"},"names":{"description":"The set of resources\n+listType=set","items":{"type":"string"},"type":"array"}},"required":["group","kind","names"],"type":"object"},"Stars":{"properties":{"spec":{"$ref":"#/components/schemas/spec"}},"required":["spec"]},"spec":{"additionalProperties":false,"properties":{"resource":{"items":{"$ref":"#/components/schemas/Resource"},"type":"array"}},"required":["resource"],"type":"object"}}`)
	versionSchemaStarsv1alpha1       app.VersionSchema
	_                                = json.Unmarshal(rawSchemaStarsv1alpha1, &versionSchemaStarsv1alpha1)
)

var appManifestData = app.ManifestData{
	AppName:          "preferences",
	Group:            "preferences.grafana.app",
	PreferredVersion: "v1alpha1",
	Versions: []app.ManifestVersion{
		{
			Name:   "v1alpha1",
			Served: true,
			Kinds: []app.ManifestVersionKind{
				{
					Kind:       "Preferences",
					Plural:     "Preferences",
					Scope:      "Namespaced",
					Conversion: false,
					Admission: &app.AdmissionCapabilities{
						Validation: &app.ValidationCapability{
							Operations: []app.AdmissionOperation{
								app.AdmissionOperationCreate,
								app.AdmissionOperationUpdate,
							},
						},
					},
					Schema: &versionSchemaPreferencesv1alpha1,
				},

				{
					Kind:       "Stars",
					Plural:     "Stars",
					Scope:      "Namespaced",
					Conversion: false,
					Admission: &app.AdmissionCapabilities{
						Validation: &app.ValidationCapability{
							Operations: []app.AdmissionOperation{
								app.AdmissionOperationCreate,
								app.AdmissionOperationUpdate,
							},
						},
					},
					Schema: &versionSchemaStarsv1alpha1,
				},
			},
			Routes: app.ManifestVersionRoutes{
				Namespaced: map[string]spec3.PathProps{},
				Cluster:    map[string]spec3.PathProps{},
				Schemas:    map[string]spec.Schema{},
			},
		},
	},
}

func LocalManifest() app.Manifest {
	return app.NewEmbeddedManifest(appManifestData)
}

func RemoteManifest() app.Manifest {
	return app.NewAPIServerManifest("preferences")
}

var kindVersionToGoType = map[string]resource.Kind{
	"Preferences/v1alpha1": v1alpha1.PreferencesKind(),
	"Stars/v1alpha1":       v1alpha1.StarsKind(),
}

// ManifestGoTypeAssociator returns the associated resource.Kind instance for a given Kind and Version, if one exists.
// If there is no association for the provided Kind and Version, exists will return false.
func ManifestGoTypeAssociator(kind, version string) (goType resource.Kind, exists bool) {
	goType, exists = kindVersionToGoType[fmt.Sprintf("%s/%s", kind, version)]
	return goType, exists
}

var customRouteToGoResponseType = map[string]any{}

// ManifestCustomRouteResponsesAssociator returns the associated response go type for a given kind, version, custom route path, and method, if one exists.
// kind may be empty for custom routes which are not kind subroutes. Leading slashes are removed from subroute paths.
// If there is no association for the provided kind, version, custom route path, and method, exists will return false.
// Resource routes (those without a kind) should prefix their route with "<namespace>/" if the route is namespaced (otherwise the route is assumed to be cluster-scope)
func ManifestCustomRouteResponsesAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoResponseType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoParamsType = map[string]runtime.Object{}

func ManifestCustomRouteQueryAssociator(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoParamsType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

var customRouteToGoRequestBodyType = map[string]any{}

func ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoRequestBodyType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}

type GoTypeAssociator struct{}

func NewGoTypeAssociator() *GoTypeAssociator {
	return &GoTypeAssociator{}
}

func (g *GoTypeAssociator) KindToGoType(kind, version string) (goType resource.Kind, exists bool) {
	return ManifestGoTypeAssociator(kind, version)
}
func (g *GoTypeAssociator) CustomRouteReturnGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteResponsesAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteQueryGoType(kind, version, path, verb string) (goType runtime.Object, exists bool) {
	return ManifestCustomRouteQueryAssociator(kind, version, path, verb)
}
func (g *GoTypeAssociator) CustomRouteRequestBodyGoType(kind, version, path, verb string) (goType any, exists bool) {
	return ManifestCustomRouteRequestBodyAssociator(kind, version, path, verb)
}
