#!/bin/sh
# SPDX-FileCopyrightText: 2020-2025 Sébastien Wilmet <swilmet@gnome.org>
# SPDX-License-Identifier: GPL-3.0-or-later

# This script generates an HTML list with the names and descriptions of all
# official gedit plugins.

write_list_for_plugins_dir() {
	plugins_dir="$1"

	echo '<ul>'

	for plugin_desktop_file in `find "${plugins_dir}" -name '*.plugin.desktop*'`
	do
		name=`grep -P '^Name=' "${plugin_desktop_file}" | cut -d'=' -f2`
		echo -n "  <li><strong>${name}</strong> &ndash; "

		desc=`grep -P '^Description=' "${plugin_desktop_file}" | cut -d'=' -f2`
		echo "<em>${desc}</em></li>"
	done | sort

	echo '</ul>'
}

write_content() {
	echo '<h2>Plugins</h2>'
	echo
	echo '<h3>Core plugins</h3>'
	echo
	echo '<p>Plugins that are distributed with gedit itself.</p>'
	echo

	write_list_for_plugins_dir '../plugins'

	echo
	echo '<h3>gedit-plugins package</h3>'
	echo
	echo '<p>'
	echo '  The gedit-plugins package contains useful plugins that are for'
	echo '  historical reasons distributed separately.'
	echo '  It is planned to move them as Core plugins.'
	echo '</p>'
	echo

	write_list_for_plugins_dir '../../gedit-plugins/plugins'
}

write_content
