#!/bin/sh
# SPDX-FileCopyrightText: 2025 Sébastien Wilmet <swilmet@gnome.org>
# SPDX-License-Identifier: GPL-3.0-or-later

set -e

# Configuration

plugin_name_camelcase='FooBar'
plugin_name_for_filenames='foo-bar'

# Generate the boilerplate code for the new plugin

plugin_name_uppercase=`gcu-case-converter --to-uppercase "${plugin_name_camelcase}"`
plugin_name_lowercase=`gcu-case-converter --to-lowercase "${plugin_name_camelcase}"`

cp 'gedit-plugin-name-plugin.h' "gedit-${plugin_name_for_filenames}-plugin.h"
echo "gedit-${plugin_name_for_filenames}-plugin.h generated."

cp 'gedit-plugin-name-plugin.c' "gedit-${plugin_name_for_filenames}-plugin.c"
sed -i "s/gedit-plugin-name/gedit-${plugin_name_for_filenames}/" \
	"gedit-${plugin_name_for_filenames}-plugin.c"
sed -i "s/gedit_plugin_name/gedit_${plugin_name_lowercase}/" \
	"gedit-${plugin_name_for_filenames}-plugin.c"
echo "gedit-${plugin_name_for_filenames}-plugin.c generated."

for ext in app view window
do
	header="gedit-${plugin_name_for_filenames}-${ext}-activatable.h"
	cp "gedit-plugin-name-${ext}-activatable.h" "${header}"
	sed -i "s/PLUGIN_NAME/${plugin_name_uppercase}/g" "${header}"
	sed -i "s/PluginName/${plugin_name_camelcase}/g" "${header}"
	sed -i "s/plugin_name/${plugin_name_lowercase}/g" "${header}"
	echo "${header} generated."

	c_file="gedit-${plugin_name_for_filenames}-${ext}-activatable.c"
	cp "gedit-plugin-name-${ext}-activatable.c" "${c_file}"
	sed -i "s/plugin-name/${plugin_name_for_filenames}/g" "${c_file}"
	sed -i "s/PLUGIN_NAME/${plugin_name_uppercase}/g" "${c_file}"
	sed -i "s/PluginName/${plugin_name_camelcase}/g" "${c_file}"
	sed -i "s/plugin_name/${plugin_name_lowercase}/g" "${c_file}"
	gcu-lineup-parameters --tabs "${c_file}"
	echo "${c_file} generated."
done
