#include "gedit-plugin-name-view-activatable.h"
#include <gedit/gedit-view.h>
#include <gedit/gedit-view-activatable.h>

struct _GeditPluginNameViewActivatablePrivate
{
	GeditView *view;
};

enum
{
	PROP_0,
	PROP_VIEW
};

static void gedit_view_activatable_iface_init (GeditViewActivatableInterface *iface);

G_DEFINE_DYNAMIC_TYPE_EXTENDED (GeditPluginNameViewActivatable,
				gedit_plugin_name_view_activatable,
				G_TYPE_OBJECT,
				0,
				G_ADD_PRIVATE_DYNAMIC (GeditPluginNameViewActivatable)
				G_IMPLEMENT_INTERFACE_DYNAMIC (GEDIT_TYPE_VIEW_ACTIVATABLE,
							       gedit_view_activatable_iface_init))

static void
gedit_plugin_name_view_activatable_get_property (GObject    *object,
						 guint       prop_id,
						 GValue     *value,
						 GParamSpec *pspec)
{
	GeditPluginNameViewActivatable *activatable = GEDIT_PLUGIN_NAME_VIEW_ACTIVATABLE (object);

	switch (prop_id)
	{
		case PROP_VIEW:
			g_value_set_object (value, activatable->priv->view);
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
			break;
	}
}

static void
gedit_plugin_name_view_activatable_set_property (GObject      *object,
						 guint         prop_id,
						 const GValue *value,
						 GParamSpec   *pspec)
{
	GeditPluginNameViewActivatable *activatable = GEDIT_PLUGIN_NAME_VIEW_ACTIVATABLE (object);

	switch (prop_id)
	{
		case PROP_VIEW:
			g_assert (activatable->priv->view == NULL);
			activatable->priv->view = GEDIT_VIEW (g_value_dup_object (value));
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
			break;
	}
}

static void
gedit_plugin_name_view_activatable_dispose (GObject *object)
{
	GeditPluginNameViewActivatable *activatable = GEDIT_PLUGIN_NAME_VIEW_ACTIVATABLE (object);

	g_clear_object (&activatable->priv->view);

	G_OBJECT_CLASS (gedit_plugin_name_view_activatable_parent_class)->dispose (object);
}

static void
gedit_plugin_name_view_activatable_finalize (GObject *object)
{

	G_OBJECT_CLASS (gedit_plugin_name_view_activatable_parent_class)->finalize (object);
}

static void
gedit_plugin_name_view_activatable_class_init (GeditPluginNameViewActivatableClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	object_class->get_property = gedit_plugin_name_view_activatable_get_property;
	object_class->set_property = gedit_plugin_name_view_activatable_set_property;
	object_class->dispose = gedit_plugin_name_view_activatable_dispose;
	object_class->finalize = gedit_plugin_name_view_activatable_finalize;

	g_object_class_override_property (object_class, PROP_VIEW, "view");
}

static void
gedit_plugin_name_view_activatable_class_finalize (GeditPluginNameViewActivatableClass *klass)
{
}

static void
gedit_plugin_name_view_activatable_init (GeditPluginNameViewActivatable *activatable)
{
	activatable->priv = gedit_plugin_name_view_activatable_get_instance_private (activatable);
}

static void
gedit_plugin_name_view_activatable_activate (GeditViewActivatable *activatable)
{
	//GeditPluginNameViewActivatable *self = GEDIT_PLUGIN_NAME_VIEW_ACTIVATABLE (activatable);

	g_message ("%s()", G_STRFUNC);
}

static void
gedit_plugin_name_view_activatable_deactivate (GeditViewActivatable *activatable)
{
	//GeditPluginNameViewActivatable *self = GEDIT_PLUGIN_NAME_VIEW_ACTIVATABLE (activatable);

	g_message ("%s()", G_STRFUNC);
}

static void
gedit_view_activatable_iface_init (GeditViewActivatableInterface *iface)
{
	iface->activate = gedit_plugin_name_view_activatable_activate;
	iface->deactivate = gedit_plugin_name_view_activatable_deactivate;
}

void
gedit_plugin_name_view_activatable_register (PeasObjectModule *module)
{
	gedit_plugin_name_view_activatable_register_type (G_TYPE_MODULE (module));

	peas_object_module_register_extension_type (module,
						    GEDIT_TYPE_VIEW_ACTIVATABLE,
						    GEDIT_TYPE_PLUGIN_NAME_VIEW_ACTIVATABLE);
}
