#include "gedit-plugin-name-app-activatable.h"
#include <gedit/gedit-app.h>
#include <gedit/gedit-app-activatable.h>

struct _GeditPluginNameAppActivatablePrivate
{
	GeditApp *app;
};

enum
{
	PROP_0,
	PROP_APP
};

static void gedit_app_activatable_iface_init (GeditAppActivatableInterface *iface);

G_DEFINE_DYNAMIC_TYPE_EXTENDED (GeditPluginNameAppActivatable,
				gedit_plugin_name_app_activatable,
				G_TYPE_OBJECT,
				0,
				G_ADD_PRIVATE_DYNAMIC (GeditPluginNameAppActivatable)
				G_IMPLEMENT_INTERFACE_DYNAMIC (GEDIT_TYPE_APP_ACTIVATABLE,
							       gedit_app_activatable_iface_init))

static void
gedit_plugin_name_app_activatable_get_property (GObject    *object,
						guint       prop_id,
						GValue     *value,
						GParamSpec *pspec)
{
	GeditPluginNameAppActivatable *activatable = GEDIT_PLUGIN_NAME_APP_ACTIVATABLE (object);

	switch (prop_id)
	{
		case PROP_APP:
			g_value_set_object (value, activatable->priv->app);
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
			break;
	}
}

static void
gedit_plugin_name_app_activatable_set_property (GObject      *object,
						guint         prop_id,
						const GValue *value,
						GParamSpec   *pspec)
{
	GeditPluginNameAppActivatable *activatable = GEDIT_PLUGIN_NAME_APP_ACTIVATABLE (object);

	switch (prop_id)
	{
		case PROP_APP:
			g_assert (activatable->priv->app == NULL);
			activatable->priv->app = GEDIT_APP (g_value_dup_object (value));
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
			break;
	}
}

static void
gedit_plugin_name_app_activatable_dispose (GObject *object)
{
	GeditPluginNameAppActivatable *activatable = GEDIT_PLUGIN_NAME_APP_ACTIVATABLE (object);

	g_clear_object (&activatable->priv->app);

	G_OBJECT_CLASS (gedit_plugin_name_app_activatable_parent_class)->dispose (object);
}

static void
gedit_plugin_name_app_activatable_finalize (GObject *object)
{

	G_OBJECT_CLASS (gedit_plugin_name_app_activatable_parent_class)->finalize (object);
}

static void
gedit_plugin_name_app_activatable_class_init (GeditPluginNameAppActivatableClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	object_class->get_property = gedit_plugin_name_app_activatable_get_property;
	object_class->set_property = gedit_plugin_name_app_activatable_set_property;
	object_class->dispose = gedit_plugin_name_app_activatable_dispose;
	object_class->finalize = gedit_plugin_name_app_activatable_finalize;

	g_object_class_override_property (object_class, PROP_APP, "app");
}

static void
gedit_plugin_name_app_activatable_class_finalize (GeditPluginNameAppActivatableClass *klass)
{
}

static void
gedit_plugin_name_app_activatable_init (GeditPluginNameAppActivatable *activatable)
{
	activatable->priv = gedit_plugin_name_app_activatable_get_instance_private (activatable);
}

static void
gedit_plugin_name_app_activatable_activate (GeditAppActivatable *activatable)
{
	//GeditPluginNameAppActivatable *self = GEDIT_PLUGIN_NAME_APP_ACTIVATABLE (activatable);

	g_message ("%s()", G_STRFUNC);
}

static void
gedit_plugin_name_app_activatable_deactivate (GeditAppActivatable *activatable)
{
	//GeditPluginNameAppActivatable *self = GEDIT_PLUGIN_NAME_APP_ACTIVATABLE (activatable);

	g_message ("%s()", G_STRFUNC);
}

static void
gedit_app_activatable_iface_init (GeditAppActivatableInterface *iface)
{
	iface->activate = gedit_plugin_name_app_activatable_activate;
	iface->deactivate = gedit_plugin_name_app_activatable_deactivate;
}

void
gedit_plugin_name_app_activatable_register (PeasObjectModule *module)
{
	gedit_plugin_name_app_activatable_register_type (G_TYPE_MODULE (module));

	peas_object_module_register_extension_type (module,
						    GEDIT_TYPE_APP_ACTIVATABLE,
						    GEDIT_TYPE_PLUGIN_NAME_APP_ACTIVATABLE);
}
