How to write a gedit plugin
===========================

The [gedit-development-getting-started.md](gedit-development-getting-started.md)
documentation is a good start.

Programming language for a gedit plugin
---------------------------------------

Nowadays **Rust** would be recommended, but have not been tried yet for a gedit
plugin.

All official plugins are implemented in **C**, so there are a lot of examples.

**C++** should be possible too, but have not been tried yet for gedit.

There was a plugin implemented in **Vala** (but has been removed), so that's
another possibility.

For the gedit and gedit-plugins repositories we prefer to deal with a single
programming language (C), that way we avoid the complexity of managing a
multi-language project. That being said, we are normally not opposed to accept a
Rust plugin as part of the official plugins.

For third-party plugins, you thus have the choice between C, Rust, C++ and
Vala. If you plan to propose your plugin for inclusion as an official plugin,
choose C or Rust.

### What about Python?

See
[this blog post](https://gedit-text-editor.org/blog/2025-04-30-no-more-pythons-in-gedit.html).

API reference
-------------

Build gedit with `-D gtk_doc=true`, you can then browse the API reference in the
[Devhelp](https://wiki.gnome.org/Apps/Devhelp) application.

To know how to write a plugin, refer to the
[libpeas](https://wiki.gnome.org/Projects/Libpeas) documentation as well.

Tool to generate a new plugin in C
----------------------------------

In the `tools/` directory there is a script to generate the boilerplate C code.

More documentation and tips
---------------------------

More documentation, for example a tutorial, would be useful. In the meantime,
the recommended thing to do is to see how core gedit plugins are implemented.

### Unofficial documentation and tutorials (may be outdated)

- [Writing plugins in Vala](https://wiki.gnome.org/Projects/Vala/Gedit3PluginSample) (maybe outdated)
