Gedit Development Guidelines - No *.ui files
============================================

Instead of having *.ui XML files (either created and modified by Glade, or
written by hand), write code.

See Christopher Davis's blog post:
[Glade Not Recommended](https://blogs.gnome.org/christopherdavis/2020/11/19/glade-not-recommended/)

Writing long XML files by hand is tedious work. In gedit projects we prefer to
not have *.ui files at all.

With code it's possible to write re-usable utilities, to avoid code or data
duplication. In *.ui files it is often necessary to do the same thing again and
again, so it's a poor practice.

Writing code to create GUI elements can be done in a clean way, if you write
small functions with meaningful names for variables and functions. Writing code
is not a crime. If you don't know how to write clean code, we recommend
_Code Complete_ by Steve McConnell, it'll change the way you do software
development.

At the time of writing, gedit still contains *.ui files. Over time we try to get
rid of them.
