Gedit Development Guidelines - No g_auto
========================================

GLib provides some `g_auto` macros for memory handling in C, but the gedit
projects do not use them because:
1. It makes the memory handling in C less uniform. Uniformity is an important
   principle for programming language design (see
   _“The Psychology of Computer Programming”_ by Gerald M. Weinberg).
   When `g_auto` is used, in order to correctly free memory, sometimes variables
   need to be declared with `g_auto`, and sometimes the unref or free function
   needs to be called explicitly (for example to free the memory of a struct
   field).
2. The developer needs to be very careful when using `g_auto` in certain
   circumstances:
   https://blog.fishsoup.net/2015/11/05/attributecleanup-mixed-declarations-and-code-and-goto/
3. It makes debugging more difficult in case of a memory handling problem.
