Gedit Development Guidelines - GObject subclass style
=====================================================

GObject classes must _not_ be created with a `G_DECLARE` macro, it causes more
problems than it solves.

Changing between `G_DECLARE_FINAL_TYPE()` and `G_DECLARE_DERIVABLE_TYPE()`
implies to adapt a lot of code in the *.c file:

```
/* For a final type */
gint
my_object_get_foo (MyObject *object)
{
	return object->foo;
}

/* For a derivable type */
gint
my_object_get_foo (MyObject *object)
{
	MyObjectPrivate *priv = my_object_get_instance_private (object);

	return priv->foo;
}
```

So we prefer to always use a Private struct, even for final types. And instead
of calling `my_object_get_instance_private()` in every function, we prefer the
convention to have a `priv` field in the object struct to access the Private
struct. This leads to shorter code. For example:

```
/* Convention: have a 'priv' field in the object struct. */
gint
my_object_get_foo (MyObject *object)
{
	return object->priv->foo;
}
```

There is a complete example in the `tools/generate-c-plugin/` directory.
[gdev-c-utils](https://gitlab.gnome.org/swilmet/gdev-c-utils) has examples too.

There might be some code in gedit using a `G_DECLARE` macro, but for new code
this is discouraged.
