Gedit Development Guidelines - GObject subclass - Functions order
=================================================================

Within a *.c file, we prefer to avoid forward declarations (function prototypes,
usually put towards the top of the file) when possible. A forward declaration is
necessary when there is a cyclic calling pattern, but otherwise you can just put
the function definition above.

It's also a good practice to order the function definitions in a logical manner
(in the order of when the functions are called). For a GObject subclass this
means:
- `class_init()` before `init()`.
- `dispose()` before `finalize()`.

So a GObject subclass will typically follow this pattern:

```
helper private functions
get/set_property()
dispose()
finalize()
class_init()
init()
new()
public functions
```
