Gedit Development Guidelines - C code conventions
=================================================

Unless specified otherwise, here are the C code conventions for the gedit
projects.

You may encounter old code that doesn't follow all the following code
conventions, but for new code it is better to follow them, for consistency.

Avoid trailing whitespace.

Indent the C code with tabulations with a width of eight characters.

All blocks should be surrounded by curly braces, even one-line blocks. The curly
braces must be placed on their own lines. Like this:

```
if (foo)
{
	call_foo ();
}
else
{
	call_bar ();
}
```

Rationale: it spaces out the code, to have a better readability. And when
modifying a block of code, if it switches between one and two lines, we don't
need to add/remove the curly braces all the time.

Follow the C89 standard as much as possible. A few things from C99 are accepted,
like the `//`-style comments.

Do not be cheap about blank lines, spacing the code vertically helps
readability. However never use two consecutive blank lines, there is really no
need.

As a general rule of thumb, follow the same coding style as the surrounding
code.
