/*
 * Copyright 2001, 2002, 2003, 2011 Adam Sampson <ats@offog.org>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "iolib.h"

const char *progname = "test-iolib";
const char *proghelp = "none";

int main(int argc, char **argv) {
	buffer b = BUFFER, b2 = BUFFER, b3 = BUFFER, b4 = BUFFER, b5 = BUFFER; 
	int i;
	int is = -12345;
	unsigned int iu = 1234567;
	long ls = -123456;
	unsigned long lu = 12345678;

	bmake(&b, "hello, ");
	bmake(&b2, "world!\n");
	bappend(&b, &b2);
	writeba(fd_out, &b);
	bfree(&b);
	bfree(&b2);

	format(fd_out, "And that's that.\n", 0);

	for (i=0; i<10000; i++) {
		bappends(&b3, "hello world! ");
	}
	bformat(&b4, "Length of long string is: @i!\n", blength(&b3));
	bfree(&b3);

	format(fd_out, "@b", &b4, 0);
	bfree(&b4);

	bmake(&b5, "a string which has some as and is in it a       ");
	format(fd_out, "before: '@b'\n", &b5);
	breplacec(&b5, 'a', 'x');
	format(fd_out, "replaced: '@b'\n", &b5);
	breplacec(&b5, 'i', 'y');
	format(fd_out, "replaced: '@b'\n", &b5);
	bfree(&b5);

	bmake(&b, "hello world!");
	bmake(&b2, "");
	format(fd_out, "initially: '@b' '@b'\n", &b, &b2);
	bpopl(&b, 6, &b2);
	format(fd_out, "after bpopl: '@b' '@b'\n", &b, &b2);
	bpopl(&b, 4, NULL);
	format(fd_out, "after bpopl again: '@b' '@b'\n", &b, &b2);
	bfree(&b);
	bfree(&b2);

	format(fd_out, "int: @i\nuint: @I\nhex: @x\nuhex: @X\n"
		"long: @l\nulong: @L\n",
		is, iu, is, iu, ls, lu);

	return 0;
}

