/*
 * Copyright 2001, 2002, 2003, 2011 Adam Sampson <ats@offog.org>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "iolib.h"
#include "freedt.h"
#include "config.h"
const char *progname = "svok";
const char *proghelp =
	"Usage: svok [OPTIONS] servicedir\n"
	"Check that supervise is running for a service.\n\n";

int main(int argc, char **argv) {
	int fd;

	get_default_args(argc, argv);
	if ((argc - optind) != 1)
		help();

	if (chdir(argv[optind]) < 0)
		die2(argv[optind], "unable to chdir to service dir");

	fd = open("supervise/control", O_WRONLY | O_NONBLOCK);
	if (fd < 0) {
		if (errno == ENXIO || errno == ENOENT)
			return 100;
		die2(argv[optind], "unable to open control pipe");
	}

	close(fd);

	return 0;
}

