/*
 * Copyright 2001, 2002, 2003, 2009 Adam Sampson <ats@offog.org>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _FREEDT_H
#define _FREEDT_H 1

#ifndef MAX
#define MAX(x, y) ((x) > (y) ? (x) : (y))
#endif

#ifdef __GNUC__
#define NORETURN __attribute__ ((noreturn))
#else
#define NORETURN
#endif

/* The name of the current program. Programs should declare this variable if
   they want to link against freedt.o. */
extern const char *progname;

/* Likewise, usage instructions for the current program. */
extern const char *proghelp;

/* Print a warning to stderr including the program name. */
void warn(const char *msg);
void warn2(const char *msg1, const char *msg2);

/* Print a message as with warn(), then exit with error code 111. */
void die(const char *msg) NORETURN;
void die2(const char *msg1, const char *msg2) NORETURN;

/* Show the version message and exit with error code 1. */
void version(void) NORETURN;

/* Show the help message and exit with error code 1. */
void help(void) NORETURN;

/* Process only the -V and -? arguments with getopt. */
void get_default_args(int argc, char **argv);

/* Set the uid, gid and root according to the UID, GID and ROOT environment
   variables if required. die() on error. */
void setuidgidroot(void);

/* Set an environment variable (like setenv(..., 1), but portable to Solaris
   etc.). Return 0 on success, -1 on error. */
int fdt_setenv(const char *name, const char *value);

/* Unset an environment variable. Return 0 on success, -1 on error. */
int fdt_unsetenv(const char *name);

/* Modify the flags on a file descriptor. */
void change_fd_flags(int fd, int add, int remove);

/* Make a file descriptor close-on-exec. */
void set_fd_cloexec(int fd);

/* Sleep for at least n seconds. */
void reliable_sleep(int n);

/* Acquire an advisory lock on a file descriptor, blocking if block > 0.
   Returns 0 on success, -1 on error. */
int lock_fd(int fd, int block);

#endif

