# freedt: service supervision tools
Adam Sampson <ats@offog.org>

Most of the tools in this collection are independent reimplementations
of software by Dan Bernstein, based on his documentation:

* [daemontools 0.70](http://cr.yp.to/daemontools.html)
* [ucspi-tcp 0.88](http://cr.yp.to/ucspi-tcp.html)

I wrote the original versions in 2001, partly because it seemed like an
interesting systems programming project, and partly because DJB's tools
didn't state licensing terms at that point. This has since changed:
DJB's explicitly released much of his software into the public domain,
including daemontools and ucspi-tcp -- so if you like these tools,
you should certainly check out the originals too.

freedt aims to follow current POSIX and C standards; if you're on an
older operating system that doesn't provide (for example) POSIX setenv
or O_SYNC, then freedt is unlikely to work for you.

freedt tools can be invoked as "sometool -V" to print their version
number, or "sometool -?" to print simple usage information.

As of 2013, freedt is available under an OpenBSD-style permissive
license.

## Tools based on daemontools/ucspi-tcp

freedt currently includes feature-equivalent replacements for:

* argv0
* envdir
* envuidgid
* setlock
* setuidgid
* softlimit
* supervise
* svc
* svok
* svscan
* svstat
* recordio (wrapper around ratelimit)

It does not include:

* fghack
* pgrphack (unnecessary; see below)
* multilog
* tai64n
* tai64nlocal

There are some minor differences from DJB's implementations:

* Error messages are somewhat different.
* svc supports a -X flag to cause supervise to quit immediately.
* supervise's internal control protocol and status file are in a
  different format to the original.
* supervise calls setsid() before running its child process, so if the
  child kills everything in its process group (as pppd does), it doesn't
  take out supervise and svscan too. This makes pgrphack unnecessary.
* svscan starts logging services as "supervise x/log" rather than "cd x;
  supervise log", so they show up more sensibly in ps.

## anonidentd

anonidentd is a UCSPI server that provides a "dummy" implementation
of the RFC1413 Identification Protocol. It returns a HIDDEN-USER error
by default or if "-n" is specified, or a UNIX userid of your choice if
one is specified with "-c userid". It logs requests to stderr.

If the environment variables UID or GID are specified, anonidentd will
change to the given UID and/or GID, as setuidgid does.

If the environment variable ROOT is set, anonidentd will chroot() to it
immediately upon startup, before doing any network IO.

A typical service run script for anonidentd might look like:

	#!/bin/sh
	ROOT=/service/anonidentd/root
	export ROOT
	exec 2>&1
	exec envuidgid identd onenetd 0 113 anonidentd -c trustnobody

My [onenetd](http://offog.org/code/onenetd/) program can be used as a
replacement for tcpserver.

## dumblog

dumblog is a logging daemon, like multilog but rather less
sophisticated.  It writes to a single file, adding ctime(3) timestamps
to the start of lines if invoked with the -c option.

Upon receipt of SIGHUP, it will write out any data it has already
received, and then close and reopen its log file (this can be used for
log rotation -- rename(2) the log file and then svc -h the logger).

Upon receipt of SIGTERM, it will write out any buffered data and close
its log file.

## mkservice

mkservice will create an svscan service directory with logging, which
can then be edited as required and linked into /service.

## ratelimit

ratelimit is a generalisation of recordio. It runs a program, limiting
the rate at which it can perform input and output according to the "-i"
or "-o" options, which specify limits in bytes per second.

The "-r" option makes ratelimit record input and output in the same way
as recordio.

ratelimit runs as a child process of the process it's limiting, and
exits when it's seen the end of its output (yes, this is odd, but it's
what recordio does according to the manual, and it does make sense when
you're using it for bandwidth limiting under tcpserver).

