###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//tools/rust_analyzer/3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "anyhow": Label("@rrra//:anyhow-1.0.71"),
            "camino": Label("@rrra//:camino-1.1.9"),
            "clap": Label("@rrra//:clap-4.3.11"),
            "env_logger": Label("@rrra//:env_logger-0.10.0"),
            "itertools": Label("@rrra//:itertools-0.11.0"),
            "log": Label("@rrra//:log-0.4.19"),
            "serde": Label("@rrra//:serde-1.0.171"),
            "serde_json": Label("@rrra//:serde_json-1.0.102"),
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_os = \"android\", target_os = \"linux\"), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\"))))))))": ["@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "cfg(all(not(rustix_use_libc), not(miri), target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\")))))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(windows), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\"))))))))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(not(any(windows, target_os = \"hermit\", target_os = \"unknown\")))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(target_os = \"dragonfly\")": [],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"wasi\")": [],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "rrra__aho-corasick-1.0.2",
        sha256 = "43f6cb1bf222025340178f382c426f13757b2960e89779dfcb319c32542a5a41",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/aho-corasick/1.0.2/download"],
        strip_prefix = "aho-corasick-1.0.2",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.aho-corasick-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__anstream-0.3.2",
        sha256 = "0ca84f3628370c59db74ee214b3263d58f9aadd9b4fe7e711fd87dc452b7f163",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstream/0.3.2/download"],
        strip_prefix = "anstream-0.3.2",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.anstream-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__anstyle-1.0.1",
        sha256 = "3a30da5c5f2d5e72842e00bcb57657162cdabef0931f40e2deb9b4140440cecd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle/1.0.1/download"],
        strip_prefix = "anstyle-1.0.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.anstyle-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__anstyle-parse-0.2.1",
        sha256 = "938874ff5980b03a87c5524b3ae5b59cf99b1d6bc836848df7bc5ada9643c333",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-parse/0.2.1/download"],
        strip_prefix = "anstyle-parse-0.2.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.anstyle-parse-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__anstyle-query-1.0.0",
        sha256 = "5ca11d4be1bab0c8bc8734a9aa7bf4ee8316d462a08c6ac5052f888fef5b494b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-query/1.0.0/download"],
        strip_prefix = "anstyle-query-1.0.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.anstyle-query-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__anstyle-wincon-1.0.1",
        sha256 = "180abfa45703aebe0093f79badacc01b8fd4ea2e35118747e5811127f926e188",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-wincon/1.0.1/download"],
        strip_prefix = "anstyle-wincon-1.0.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.anstyle-wincon-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__anyhow-1.0.71",
        sha256 = "9c7d0618f0e0b7e8ff11427422b64564d5fb0be1940354bfe2e0529b18a9d9b8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anyhow/1.0.71/download"],
        strip_prefix = "anyhow-1.0.71",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.anyhow-1.0.71.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__camino-1.1.9",
        sha256 = "8b96ec4966b5813e2c0507c1f86115c8c5abaadc3980879c3424042a02fd1ad3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/camino/1.1.9/download"],
        strip_prefix = "camino-1.1.9",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.camino-1.1.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__cc-1.0.79",
        sha256 = "50d30906286121d95be3d479533b458f87493b30a4b5f79a607db8f5d11aa91f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cc/1.0.79/download"],
        strip_prefix = "cc-1.0.79",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.cc-1.0.79.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__clap-4.3.11",
        sha256 = "1640e5cc7fb47dbb8338fd471b105e7ed6c3cb2aeb00c2e067127ffd3764a05d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap/4.3.11/download"],
        strip_prefix = "clap-4.3.11",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.clap-4.3.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__clap_builder-4.3.11",
        sha256 = "98c59138d527eeaf9b53f35a77fcc1fad9d883116070c63d5de1c7dc7b00c72b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_builder/4.3.11/download"],
        strip_prefix = "clap_builder-4.3.11",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.clap_builder-4.3.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__clap_derive-4.3.2",
        sha256 = "b8cd2b2a819ad6eec39e8f1d6b53001af1e5469f8c177579cdaeb313115b825f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_derive/4.3.2/download"],
        strip_prefix = "clap_derive-4.3.2",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.clap_derive-4.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__clap_lex-0.5.0",
        sha256 = "2da6da31387c7e4ef160ffab6d5e7f00c42626fe39aea70a7b0f1773f7dd6c1b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_lex/0.5.0/download"],
        strip_prefix = "clap_lex-0.5.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.clap_lex-0.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__colorchoice-1.0.0",
        sha256 = "acbf1af155f9b9ef647e42cdc158db4b64a1b61f743629225fde6f3e0be2a7c7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/colorchoice/1.0.0/download"],
        strip_prefix = "colorchoice-1.0.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.colorchoice-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__either-1.8.1",
        sha256 = "7fcaabb2fef8c910e7f4c7ce9f67a1283a1715879a7c230ca9d6d1ae31f16d91",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/either/1.8.1/download"],
        strip_prefix = "either-1.8.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.either-1.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__env_logger-0.10.0",
        sha256 = "85cdab6a89accf66733ad5a1693a4dcced6aeff64602b634530dd73c1f3ee9f0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/env_logger/0.10.0/download"],
        strip_prefix = "env_logger-0.10.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.env_logger-0.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__errno-0.3.1",
        sha256 = "4bcfec3a70f97c962c307b2d2c56e358cf1d00b558d74262b5f929ee8cc7e73a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/errno/0.3.1/download"],
        strip_prefix = "errno-0.3.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.errno-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__errno-dragonfly-0.1.2",
        sha256 = "aa68f1b12764fab894d2755d2518754e71b4fd80ecfb822714a1206c2aab39bf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/errno-dragonfly/0.1.2/download"],
        strip_prefix = "errno-dragonfly-0.1.2",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.errno-dragonfly-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__heck-0.4.1",
        sha256 = "95505c38b4572b2d910cecb0281560f54b440a19336cbbcb27bf6ce6adc6f5a8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/heck/0.4.1/download"],
        strip_prefix = "heck-0.4.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.heck-0.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__hermit-abi-0.3.2",
        sha256 = "443144c8cdadd93ebf52ddb4056d257f5b52c04d3c804e657d19eb73fc33668b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hermit-abi/0.3.2/download"],
        strip_prefix = "hermit-abi-0.3.2",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.hermit-abi-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__humantime-2.1.0",
        sha256 = "9a3a5bfb195931eeb336b2a7b4d761daec841b97f947d34394601737a7bba5e4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/humantime/2.1.0/download"],
        strip_prefix = "humantime-2.1.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.humantime-2.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__io-lifetimes-1.0.11",
        sha256 = "eae7b9aee968036d54dce06cebaefd919e4472e753296daccd6d344e3e2df0c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/io-lifetimes/1.0.11/download"],
        strip_prefix = "io-lifetimes-1.0.11",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.io-lifetimes-1.0.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__is-terminal-0.4.7",
        sha256 = "adcf93614601c8129ddf72e2d5633df827ba6551541c6d8c59520a371475be1f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/is-terminal/0.4.7/download"],
        strip_prefix = "is-terminal-0.4.7",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.is-terminal-0.4.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__itertools-0.11.0",
        sha256 = "b1c173a5686ce8bfa551b3563d0c2170bf24ca44da99c7ca4bfdab5418c3fe57",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itertools/0.11.0/download"],
        strip_prefix = "itertools-0.11.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.itertools-0.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__itoa-1.0.8",
        sha256 = "62b02a5381cc465bd3041d84623d0fa3b66738b52b8e2fc3bab8ad63ab032f4a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itoa/1.0.8/download"],
        strip_prefix = "itoa-1.0.8",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.itoa-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__libc-0.2.147",
        sha256 = "b4668fb0ea861c1df094127ac5f1da3409a82116a4ba74fca2e58ef927159bb3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.147/download"],
        strip_prefix = "libc-0.2.147",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.libc-0.2.147.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__linux-raw-sys-0.3.8",
        sha256 = "ef53942eb7bf7ff43a617b3e2c1c4a5ecf5944a7c1bc12d7ee39bbb15e5c1519",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/linux-raw-sys/0.3.8/download"],
        strip_prefix = "linux-raw-sys-0.3.8",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.linux-raw-sys-0.3.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__log-0.4.19",
        sha256 = "b06a4cde4c0f271a446782e3eff8de789548ce57dbc8eca9292c27f4a42004b4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.19/download"],
        strip_prefix = "log-0.4.19",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.log-0.4.19.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__memchr-2.5.0",
        sha256 = "2dffe52ecf27772e601905b7522cb4ef790d2cc203488bbd0e2fe85fcb74566d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.5.0/download"],
        strip_prefix = "memchr-2.5.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.memchr-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__once_cell-1.18.0",
        sha256 = "dd8b5dd2ae5ed71462c540258bedcb51965123ad7e7ccf4b9a8cafaa4a63576d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.18.0/download"],
        strip_prefix = "once_cell-1.18.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.once_cell-1.18.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__proc-macro2-1.0.64",
        sha256 = "78803b62cbf1f46fde80d7c0e803111524b9877184cfe7c3033659490ac7a7da",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.64/download"],
        strip_prefix = "proc-macro2-1.0.64",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.proc-macro2-1.0.64.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__quote-1.0.29",
        sha256 = "573015e8ab27661678357f27dc26460738fd2b6c86e46f386fde94cb5d913105",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.29/download"],
        strip_prefix = "quote-1.0.29",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.quote-1.0.29.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__regex-1.9.1",
        sha256 = "b2eae68fc220f7cf2532e4494aded17545fce192d59cd996e0fe7887f4ceb575",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex/1.9.1/download"],
        strip_prefix = "regex-1.9.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.regex-1.9.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__regex-automata-0.3.3",
        sha256 = "39354c10dd07468c2e73926b23bb9c2caca74c5501e38a35da70406f1d923310",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.3.3/download"],
        strip_prefix = "regex-automata-0.3.3",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.regex-automata-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__regex-syntax-0.7.4",
        sha256 = "e5ea92a5b6195c6ef2a0295ea818b312502c6fc94dde986c5553242e18fd4ce2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-syntax/0.7.4/download"],
        strip_prefix = "regex-syntax-0.7.4",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.regex-syntax-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__rustix-0.37.23",
        sha256 = "4d69718bf81c6127a49dc64e44a742e8bb9213c0ff8869a22c308f84c1d4ab06",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustix/0.37.23/download"],
        strip_prefix = "rustix-0.37.23",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.rustix-0.37.23.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__ryu-1.0.14",
        sha256 = "fe232bdf6be8c8de797b22184ee71118d63780ea42ac85b61d1baa6d3b782ae9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ryu/1.0.14/download"],
        strip_prefix = "ryu-1.0.14",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.ryu-1.0.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__serde-1.0.171",
        sha256 = "30e27d1e4fd7659406c492fd6cfaf2066ba8773de45ca75e855590f856dc34a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.171/download"],
        strip_prefix = "serde-1.0.171",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.serde-1.0.171.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__serde_derive-1.0.171",
        sha256 = "389894603bd18c46fa56231694f8d827779c0951a667087194cf9de94ed24682",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.171/download"],
        strip_prefix = "serde_derive-1.0.171",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.serde_derive-1.0.171.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__serde_json-1.0.102",
        sha256 = "b5062a995d481b2308b6064e9af76011f2921c35f97b0468811ed9f6cd91dfed",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_json/1.0.102/download"],
        strip_prefix = "serde_json-1.0.102",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.serde_json-1.0.102.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__strsim-0.10.0",
        sha256 = "73473c0e59e6d5812c5dfe2a064a6444949f089e20eec9a2e5506596494e4623",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/strsim/0.10.0/download"],
        strip_prefix = "strsim-0.10.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.strsim-0.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__syn-2.0.25",
        sha256 = "15e3fc8c0c74267e2df136e5e5fb656a464158aa57624053375eb9c8c6e25ae2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.25/download"],
        strip_prefix = "syn-2.0.25",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.syn-2.0.25.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__termcolor-1.2.0",
        sha256 = "be55cf8942feac5c765c2c993422806843c9a9a45d4d5c407ad6dd2ea95eb9b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/termcolor/1.2.0/download"],
        strip_prefix = "termcolor-1.2.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.termcolor-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__unicode-ident-1.0.10",
        sha256 = "22049a19f4a68748a168c0fc439f9516686aa045927ff767eca0a85101fb6e73",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.10/download"],
        strip_prefix = "unicode-ident-1.0.10",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.unicode-ident-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__utf8parse-0.2.1",
        sha256 = "711b9620af191e0cdc7468a8d14e709c3dcdb115b36f838e601583af800a370a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8parse/0.2.1/download"],
        strip_prefix = "utf8parse-0.2.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.utf8parse-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__winapi-util-0.1.5",
        sha256 = "70ec6ce85bb158151cae5e5c87f95a8e97d2c0c4b001223f33a334e3ce5de178",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-util/0.1.5/download"],
        strip_prefix = "winapi-util-0.1.5",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.winapi-util-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows-sys-0.48.0",
        sha256 = "677d2418bec65e3338edb076e806bc1ec15693c5d0104683f2efe857f61056a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.48.0/download"],
        strip_prefix = "windows-sys-0.48.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows-sys-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows-targets-0.48.1",
        sha256 = "05d4b17490f70499f20b9e791dcf6a299785ce8af4d709018206dc5b4953e95f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.48.1/download"],
        strip_prefix = "windows-targets-0.48.1",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows-targets-0.48.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows_aarch64_gnullvm-0.48.0",
        sha256 = "91ae572e1b79dba883e0d315474df7305d12f569b400fcf90581b06062f7e1bc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.48.0/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.48.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows_aarch64_msvc-0.48.0",
        sha256 = "b2ef27e0d7bdfcfc7b868b317c1d32c641a6fe4629c171b8928c7b08d98d7cf3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.48.0/download"],
        strip_prefix = "windows_aarch64_msvc-0.48.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows_aarch64_msvc-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows_i686_gnu-0.48.0",
        sha256 = "622a1962a7db830d6fd0a69683c80a18fda201879f0f447f065a3b7467daa241",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.48.0/download"],
        strip_prefix = "windows_i686_gnu-0.48.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows_i686_gnu-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows_i686_msvc-0.48.0",
        sha256 = "4542c6e364ce21bf45d69fdd2a8e455fa38d316158cfd43b3ac1c5b1b19f8e00",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.48.0/download"],
        strip_prefix = "windows_i686_msvc-0.48.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows_i686_msvc-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows_x86_64_gnu-0.48.0",
        sha256 = "ca2b8a661f7628cbd23440e50b05d705db3686f894fc9580820623656af974b1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.48.0/download"],
        strip_prefix = "windows_x86_64_gnu-0.48.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows_x86_64_gnu-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows_x86_64_gnullvm-0.48.0",
        sha256 = "7896dbc1f41e08872e9d5e8f8baa8fdd2677f29468c4e156210174edc7f7b953",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.48.0/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.48.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrra__windows_x86_64_msvc-0.48.0",
        sha256 = "1a515f5799fe4961cb532f983ce2b23082366b898e52ffbce459c86f67c8378a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.48.0/download"],
        strip_prefix = "windows_x86_64_msvc-0.48.0",
        build_file = Label("//tools/rust_analyzer/3rdparty/crates:BUILD.windows_x86_64_msvc-0.48.0.bazel"),
    )

    return [
        struct(repo = "rrra__anyhow-1.0.71", is_dev_dep = False),
        struct(repo = "rrra__camino-1.1.9", is_dev_dep = False),
        struct(repo = "rrra__clap-4.3.11", is_dev_dep = False),
        struct(repo = "rrra__env_logger-0.10.0", is_dev_dep = False),
        struct(repo = "rrra__itertools-0.11.0", is_dev_dep = False),
        struct(repo = "rrra__log-0.4.19", is_dev_dep = False),
        struct(repo = "rrra__serde-1.0.171", is_dev_dep = False),
        struct(repo = "rrra__serde_json-1.0.102", is_dev_dep = False),
    ]
