###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "serde_json": Label("@rrwbd//:serde_json-1.0.145"),
            "wasm-bindgen": Label("@rrwbd//:wasm-bindgen-0.2.105"),
            "wasm-bindgen-cli": Label("@rrwbd//:wasm-bindgen-cli-0.2.105"),
            "wasm-bindgen-test": Label("@rrwbd//:wasm-bindgen-test-0.3.55"),
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(all(target_arch = \"aarch64\", target_endian = \"little\"), target_os = \"windows\"))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(all(target_arch = \"aarch64\", target_endian = \"little\"), target_vendor = \"apple\", any(target_os = \"ios\", target_os = \"macos\", target_os = \"tvos\", target_os = \"visionos\", target_os = \"watchos\")))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "cfg(all(any(all(target_arch = \"aarch64\", target_endian = \"little\"), all(target_arch = \"arm\", target_endian = \"little\")), any(target_os = \"android\", target_os = \"linux\")))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"arm64ec\"), target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(any(target_os = \"linux\"), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "cfg(all(any(target_os = \"linux\", target_os = \"android\"), not(any(all(target_os = \"linux\", target_env = \"\"), getrandom_backend = \"custom\", getrandom_backend = \"linux_raw\", getrandom_backend = \"rdrand\", getrandom_backend = \"rndr\"))))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(rustix_use_libc), not(miri), target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"))))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(windows), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"wasm32\", target_os = \"unknown\"))": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "cfg(all(target_arch = \"wasm32\", target_os = \"wasi\", target_env = \"p2\"))": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(all(target_arch = \"wasm32\", wasm_bindgen_unstable_test_coverage))": [],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(target_os = \"uefi\", getrandom_backend = \"efi_rng\"))": [],
    "cfg(any())": [],
    "cfg(any(target_os = \"dragonfly\", target_os = \"freebsd\", target_os = \"hurd\", target_os = \"illumos\", target_os = \"cygwin\", all(target_os = \"horizon\", target_arch = \"arm\")))": ["@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(target_os = \"haiku\", target_os = \"redox\", target_os = \"nto\", target_os = \"aix\"))": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "cfg(any(target_os = \"ios\", target_os = \"visionos\", target_os = \"watchos\", target_os = \"tvos\"))": ["@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(any(target_os = \"macos\", target_os = \"ios\", target_os = \"freebsd\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(target_os = \"macos\", target_os = \"openbsd\", target_os = \"vita\", target_os = \"emscripten\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin"],
    "cfg(any(unix, target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(not(all(target_arch = \"arm\", target_os = \"none\")))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(not(target_has_atomic = \"ptr\"))": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "cfg(not(windows))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(target_feature = \"atomics\")": [],
    "cfg(target_os = \"android\")": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:x86_64-linux-android"],
    "cfg(target_os = \"haiku\")": [],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"netbsd\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"solaris\")": [],
    "cfg(target_os = \"vxworks\")": [],
    "cfg(target_os = \"wasi\")": ["@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(target_os = \"windows\")": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(target_vendor = \"apple\")": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(windows_raw_dylib)": [],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnullvm": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "rrwbd__adler2-2.0.1",
        sha256 = "320119579fcad9c21884f5c4861d16174d0e06250625266f50fe6898340abefa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/adler2/2.0.1/download"],
        strip_prefix = "adler2-2.0.1",
        build_file = Label("//3rdparty/crates:BUILD.adler2-2.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__ahash-0.8.12",
        sha256 = "5a15f179cd60c4584b8a8c596927aadc462e27f2ca70c04e0071964a73ba7a75",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ahash/0.8.12/download"],
        strip_prefix = "ahash-0.8.12",
        build_file = Label("//3rdparty/crates:BUILD.ahash-0.8.12.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__aho-corasick-1.1.3",
        sha256 = "8e60d3430d3a69478ad0993f19238d2df97c507009a52b3c10addcd7f6bcb916",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/aho-corasick/1.1.3/download"],
        strip_prefix = "aho-corasick-1.1.3",
        build_file = Label("//3rdparty/crates:BUILD.aho-corasick-1.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__alloc-no-stdlib-2.0.4",
        sha256 = "cc7bb162ec39d46ab1ca8c77bf72e890535becd1751bb45f64c597edb4c8c6b3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/alloc-no-stdlib/2.0.4/download"],
        strip_prefix = "alloc-no-stdlib-2.0.4",
        build_file = Label("//3rdparty/crates:BUILD.alloc-no-stdlib-2.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__alloc-stdlib-0.2.2",
        sha256 = "94fb8275041c72129eb51b7d0322c29b8387a0386127718b096429201a5d6ece",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/alloc-stdlib/0.2.2/download"],
        strip_prefix = "alloc-stdlib-0.2.2",
        build_file = Label("//3rdparty/crates:BUILD.alloc-stdlib-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__android_system_properties-0.1.5",
        sha256 = "819e7219dbd41043ac279b19830f2efc897156490d7fd6ea916720117ee66311",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/android_system_properties/0.1.5/download"],
        strip_prefix = "android_system_properties-0.1.5",
        build_file = Label("//3rdparty/crates:BUILD.android_system_properties-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__anstream-0.6.21",
        sha256 = "43d5b281e737544384e969a5ccad3f1cdd24b48086a0fc1b2a5262a26b8f4f4a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstream/0.6.21/download"],
        strip_prefix = "anstream-0.6.21",
        build_file = Label("//3rdparty/crates:BUILD.anstream-0.6.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__anstyle-1.0.13",
        sha256 = "5192cca8006f1fd4f7237516f40fa183bb07f8fbdfedaa0036de5ea9b0b45e78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle/1.0.13/download"],
        strip_prefix = "anstyle-1.0.13",
        build_file = Label("//3rdparty/crates:BUILD.anstyle-1.0.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__anstyle-parse-0.2.7",
        sha256 = "4e7644824f0aa2c7b9384579234ef10eb7efb6a0deb83f9630a49594dd9c15c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-parse/0.2.7/download"],
        strip_prefix = "anstyle-parse-0.2.7",
        build_file = Label("//3rdparty/crates:BUILD.anstyle-parse-0.2.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__anstyle-query-1.1.4",
        sha256 = "9e231f6134f61b71076a3eab506c379d4f36122f2af15a9ff04415ea4c3339e2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-query/1.1.4/download"],
        strip_prefix = "anstyle-query-1.1.4",
        build_file = Label("//3rdparty/crates:BUILD.anstyle-query-1.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__anstyle-wincon-3.0.10",
        sha256 = "3e0633414522a32ffaac8ac6cc8f748e090c5717661fddeea04219e2344f5f2a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-wincon/3.0.10/download"],
        strip_prefix = "anstyle-wincon-3.0.10",
        build_file = Label("//3rdparty/crates:BUILD.anstyle-wincon-3.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__anyhow-1.0.100",
        sha256 = "a23eb6b1614318a8071c9b2521f36b424b2c83db5eb3a0fead4a6c0809af6e61",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anyhow/1.0.100/download"],
        strip_prefix = "anyhow-1.0.100",
        build_file = Label("//3rdparty/crates:BUILD.anyhow-1.0.100.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__ascii-1.1.0",
        sha256 = "d92bec98840b8f03a5ff5413de5293bfcd8bf96467cf5452609f939ec6f5de16",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ascii/1.1.0/download"],
        strip_prefix = "ascii-1.1.0",
        build_file = Label("//3rdparty/crates:BUILD.ascii-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__autocfg-1.5.0",
        sha256 = "c08606f8c3cbf4ce6ec8e28fb0014a2c086708fe954eaa885384a6165172e7e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/autocfg/1.5.0/download"],
        strip_prefix = "autocfg-1.5.0",
        build_file = Label("//3rdparty/crates:BUILD.autocfg-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__base64-0.13.1",
        sha256 = "9e1b586273c5702936fe7b7d6896644d8be71e6314cfe09d3167c95f712589e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/base64/0.13.1/download"],
        strip_prefix = "base64-0.13.1",
        build_file = Label("//3rdparty/crates:BUILD.base64-0.13.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__base64-0.22.1",
        sha256 = "72b3254f16251a8381aa12e40e3c4d2f0199f8c6508fbecb9d91f575e0fbb8c6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/base64/0.22.1/download"],
        strip_prefix = "base64-0.22.1",
        build_file = Label("//3rdparty/crates:BUILD.base64-0.22.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__bitflags-2.10.0",
        sha256 = "812e12b5285cc515a9c72a5c1d3b6d46a19dac5acfef5265968c166106e31dd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/2.10.0/download"],
        strip_prefix = "bitflags-2.10.0",
        build_file = Label("//3rdparty/crates:BUILD.bitflags-2.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__brotli-decompressor-4.0.3",
        sha256 = "a334ef7c9e23abf0ce748e8cd309037da93e606ad52eb372e4ce327a0dcfbdfd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/brotli-decompressor/4.0.3/download"],
        strip_prefix = "brotli-decompressor-4.0.3",
        build_file = Label("//3rdparty/crates:BUILD.brotli-decompressor-4.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__buf_redux-0.8.4",
        sha256 = "b953a6887648bb07a535631f2bc00fbdb2a2216f135552cb3f534ed136b9c07f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/buf_redux/0.8.4/download"],
        strip_prefix = "buf_redux-0.8.4",
        build_file = Label("//3rdparty/crates:BUILD.buf_redux-0.8.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__bumpalo-3.19.0",
        sha256 = "46c5e41b57b8bba42a04676d81cb89e9ee8e859a1a66f80a5a72e1cb76b34d43",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bumpalo/3.19.0/download"],
        strip_prefix = "bumpalo-3.19.0",
        build_file = Label("//3rdparty/crates:BUILD.bumpalo-3.19.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__cc-1.2.43",
        sha256 = "739eb0f94557554b3ca9a86d2d37bebd49c5e6d0c1d2bda35ba5bdac830befc2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cc/1.2.43/download"],
        strip_prefix = "cc-1.2.43",
        build_file = Label("//3rdparty/crates:BUILD.cc-1.2.43.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__cfg-if-1.0.4",
        sha256 = "9330f8b2ff13f34540b44e946ef35111825727b38d33286ef986142615121801",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.4/download"],
        strip_prefix = "cfg-if-1.0.4",
        build_file = Label("//3rdparty/crates:BUILD.cfg-if-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__chrono-0.4.42",
        sha256 = "145052bdd345b87320e369255277e3fb5152762ad123a901ef5c262dd38fe8d2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/chrono/0.4.42/download"],
        strip_prefix = "chrono-0.4.42",
        build_file = Label("//3rdparty/crates:BUILD.chrono-0.4.42.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__chunked_transfer-1.5.0",
        sha256 = "6e4de3bc4ea267985becf712dc6d9eed8b04c953b3fcfb339ebc87acd9804901",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/chunked_transfer/1.5.0/download"],
        strip_prefix = "chunked_transfer-1.5.0",
        build_file = Label("//3rdparty/crates:BUILD.chunked_transfer-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__clap-4.5.50",
        sha256 = "0c2cfd7bf8a6017ddaa4e32ffe7403d547790db06bd171c1c53926faab501623",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap/4.5.50/download"],
        strip_prefix = "clap-4.5.50",
        build_file = Label("//3rdparty/crates:BUILD.clap-4.5.50.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__clap_builder-4.5.50",
        sha256 = "0a4c05b9e80c5ccd3a7ef080ad7b6ba7d6fc00a985b8b157197075677c82c7a0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_builder/4.5.50/download"],
        strip_prefix = "clap_builder-4.5.50",
        build_file = Label("//3rdparty/crates:BUILD.clap_builder-4.5.50.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__clap_derive-4.5.49",
        sha256 = "2a0b5487afeab2deb2ff4e03a807ad1a03ac532ff5a2cee5d86884440c7f7671",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_derive/4.5.49/download"],
        strip_prefix = "clap_derive-4.5.49",
        build_file = Label("//3rdparty/crates:BUILD.clap_derive-4.5.49.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__clap_lex-0.7.6",
        sha256 = "a1d728cc89cf3aee9ff92b05e62b19ee65a02b5702cff7d5a377e32c6ae29d8d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_lex/0.7.6/download"],
        strip_prefix = "clap_lex-0.7.6",
        build_file = Label("//3rdparty/crates:BUILD.clap_lex-0.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__colorchoice-1.0.4",
        sha256 = "b05b61dc5112cbb17e4b6cd61790d9845d13888356391624cbe7e41efeac1e75",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/colorchoice/1.0.4/download"],
        strip_prefix = "colorchoice-1.0.4",
        build_file = Label("//3rdparty/crates:BUILD.colorchoice-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__core-foundation-sys-0.8.7",
        sha256 = "773648b94d0e5d620f64f280777445740e61fe701025087ec8b57f45c791888b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/core-foundation-sys/0.8.7/download"],
        strip_prefix = "core-foundation-sys-0.8.7",
        build_file = Label("//3rdparty/crates:BUILD.core-foundation-sys-0.8.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__crc32fast-1.5.0",
        sha256 = "9481c1c90cbf2ac953f07c8d4a58aa3945c425b7185c9154d67a65e4230da511",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crc32fast/1.5.0/download"],
        strip_prefix = "crc32fast-1.5.0",
        build_file = Label("//3rdparty/crates:BUILD.crc32fast-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__crossbeam-deque-0.8.6",
        sha256 = "9dd111b7b7f7d55b72c0a6ae361660ee5853c9af73f70c3c2ef6858b950e2e51",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-deque/0.8.6/download"],
        strip_prefix = "crossbeam-deque-0.8.6",
        build_file = Label("//3rdparty/crates:BUILD.crossbeam-deque-0.8.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__crossbeam-epoch-0.9.18",
        sha256 = "5b82ac4a3c2ca9c3460964f020e1402edd5753411d7737aa39c3714ad1b5420e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-epoch/0.9.18/download"],
        strip_prefix = "crossbeam-epoch-0.9.18",
        build_file = Label("//3rdparty/crates:BUILD.crossbeam-epoch-0.9.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__crossbeam-utils-0.8.21",
        sha256 = "d0a5c400df2834b80a4c3327b3aad3a4c4cd4de0629063962b03235697506a28",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-utils/0.8.21/download"],
        strip_prefix = "crossbeam-utils-0.8.21",
        build_file = Label("//3rdparty/crates:BUILD.crossbeam-utils-0.8.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__deranged-0.5.5",
        sha256 = "ececcb659e7ba858fb4f10388c250a7252eb0a27373f1a72b8748afdd248e587",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/deranged/0.5.5/download"],
        strip_prefix = "deranged-0.5.5",
        build_file = Label("//3rdparty/crates:BUILD.deranged-0.5.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__displaydoc-0.2.5",
        sha256 = "97369cbbc041bc366949bc74d34658d6cda5621039731c6310521892a3a20ae0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/displaydoc/0.2.5/download"],
        strip_prefix = "displaydoc-0.2.5",
        build_file = Label("//3rdparty/crates:BUILD.displaydoc-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__either-1.15.0",
        sha256 = "48c757948c5ede0e46177b7add2e67155f70e33c07fea8284df6576da70b3719",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/either/1.15.0/download"],
        strip_prefix = "either-1.15.0",
        build_file = Label("//3rdparty/crates:BUILD.either-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__env_filter-0.1.4",
        sha256 = "1bf3c259d255ca70051b30e2e95b5446cdb8949ac4cd22c0d7fd634d89f568e2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/env_filter/0.1.4/download"],
        strip_prefix = "env_filter-0.1.4",
        build_file = Label("//3rdparty/crates:BUILD.env_filter-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__env_logger-0.11.8",
        sha256 = "13c863f0904021b108aa8b2f55046443e6b1ebde8fd4a15c399893aae4fa069f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/env_logger/0.11.8/download"],
        strip_prefix = "env_logger-0.11.8",
        build_file = Label("//3rdparty/crates:BUILD.env_logger-0.11.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__equivalent-1.0.2",
        sha256 = "877a4ace8713b0bcf2a4e7eec82529c029f1d0619886d18145fea96c3ffe5c0f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/equivalent/1.0.2/download"],
        strip_prefix = "equivalent-1.0.2",
        build_file = Label("//3rdparty/crates:BUILD.equivalent-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__errno-0.3.14",
        sha256 = "39cab71617ae0d63f51a36d69f866391735b51691dbda63cf6f96d042b63efeb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/errno/0.3.14/download"],
        strip_prefix = "errno-0.3.14",
        build_file = Label("//3rdparty/crates:BUILD.errno-0.3.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__fallible-iterator-0.2.0",
        sha256 = "4443176a9f2c162692bd3d352d745ef9413eec5782a80d8fd6f8a1ac692a07f7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fallible-iterator/0.2.0/download"],
        strip_prefix = "fallible-iterator-0.2.0",
        build_file = Label("//3rdparty/crates:BUILD.fallible-iterator-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__fastrand-2.3.0",
        sha256 = "37909eebbb50d72f9059c3b6d82c0463f2ff062c9e95845c43a6c9c0355411be",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fastrand/2.3.0/download"],
        strip_prefix = "fastrand-2.3.0",
        build_file = Label("//3rdparty/crates:BUILD.fastrand-2.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__filetime-0.2.26",
        sha256 = "bc0505cd1b6fa6580283f6bdf70a73fcf4aba1184038c90902b92b3dd0df63ed",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/filetime/0.2.26/download"],
        strip_prefix = "filetime-0.2.26",
        build_file = Label("//3rdparty/crates:BUILD.filetime-0.2.26.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__find-msvc-tools-0.1.4",
        sha256 = "52051878f80a721bb68ebfbc930e07b65ba72f2da88968ea5c06fd6ca3d3a127",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/find-msvc-tools/0.1.4/download"],
        strip_prefix = "find-msvc-tools-0.1.4",
        build_file = Label("//3rdparty/crates:BUILD.find-msvc-tools-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__flate2-1.1.5",
        sha256 = "bfe33edd8e85a12a67454e37f8c75e730830d83e313556ab9ebf9ee7fbeb3bfb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/flate2/1.1.5/download"],
        strip_prefix = "flate2-1.1.5",
        build_file = Label("//3rdparty/crates:BUILD.flate2-1.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__foldhash-0.1.5",
        sha256 = "d9c4f5dac5e15c24eb999c26181a6ca40b39fe946cbe4c263c7209467bc83af2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/foldhash/0.1.5/download"],
        strip_prefix = "foldhash-0.1.5",
        build_file = Label("//3rdparty/crates:BUILD.foldhash-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__form_urlencoded-1.2.2",
        sha256 = "cb4cb245038516f5f85277875cdaa4f7d2c9a0fa0468de06ed190163b1581fcf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/form_urlencoded/1.2.2/download"],
        strip_prefix = "form_urlencoded-1.2.2",
        build_file = Label("//3rdparty/crates:BUILD.form_urlencoded-1.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__getrandom-0.2.16",
        sha256 = "335ff9f135e4384c8150d6f27c6daed433577f86b4750418338c01a1a2528592",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/getrandom/0.2.16/download"],
        strip_prefix = "getrandom-0.2.16",
        build_file = Label("//3rdparty/crates:BUILD.getrandom-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__getrandom-0.3.4",
        sha256 = "899def5c37c4fd7b2664648c28120ecec138e4d395b459e5ca34f9cce2dd77fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/getrandom/0.3.4/download"],
        strip_prefix = "getrandom-0.3.4",
        build_file = Label("//3rdparty/crates:BUILD.getrandom-0.3.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__gimli-0.26.2",
        sha256 = "22030e2c5a68ec659fde1e949a745124b48e6fa8b045b7ed5bd1fe4ccc5c4e5d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gimli/0.26.2/download"],
        strip_prefix = "gimli-0.26.2",
        build_file = Label("//3rdparty/crates:BUILD.gimli-0.26.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__hashbrown-0.12.3",
        sha256 = "8a9ee70c43aaf417c914396645a0fa852624801b24ebb7ae78fe8272889ac888",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.12.3/download"],
        strip_prefix = "hashbrown-0.12.3",
        build_file = Label("//3rdparty/crates:BUILD.hashbrown-0.12.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__hashbrown-0.14.5",
        sha256 = "e5274423e17b7c9fc20b6e7e208532f9b19825d82dfd615708b70edd83df41f1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.14.5/download"],
        strip_prefix = "hashbrown-0.14.5",
        build_file = Label("//3rdparty/crates:BUILD.hashbrown-0.14.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__hashbrown-0.15.5",
        sha256 = "9229cfe53dfd69f0609a49f65461bd93001ea1ef889cd5529dd176593f5338a1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.15.5/download"],
        strip_prefix = "hashbrown-0.15.5",
        build_file = Label("//3rdparty/crates:BUILD.hashbrown-0.15.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__hashbrown-0.16.0",
        sha256 = "5419bdc4f6a9207fbeba6d11b604d481addf78ecd10c11ad51e76c2f6482748d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.16.0/download"],
        strip_prefix = "hashbrown-0.16.0",
        build_file = Label("//3rdparty/crates:BUILD.hashbrown-0.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__heck-0.5.0",
        sha256 = "2304e00983f87ffb38b55b444b5e3b60a884b5d30c0fca7d82fe33449bbe55ea",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/heck/0.5.0/download"],
        strip_prefix = "heck-0.5.0",
        build_file = Label("//3rdparty/crates:BUILD.heck-0.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__hermit-abi-0.5.2",
        sha256 = "fc0fef456e4baa96da950455cd02c081ca953b141298e41db3fc7e36b1da849c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hermit-abi/0.5.2/download"],
        strip_prefix = "hermit-abi-0.5.2",
        build_file = Label("//3rdparty/crates:BUILD.hermit-abi-0.5.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__httparse-1.10.1",
        sha256 = "6dbf3de79e51f3d586ab4cb9d5c3e2c14aa28ed23d180cf89b4df0454a69cc87",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/httparse/1.10.1/download"],
        strip_prefix = "httparse-1.10.1",
        build_file = Label("//3rdparty/crates:BUILD.httparse-1.10.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__httpdate-1.0.3",
        sha256 = "df3b46402a9d5adb4c86a0cf463f42e19994e3ee891101b1841f30a545cb49a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/httpdate/1.0.3/download"],
        strip_prefix = "httpdate-1.0.3",
        build_file = Label("//3rdparty/crates:BUILD.httpdate-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__iana-time-zone-0.1.64",
        sha256 = "33e57f83510bb73707521ebaffa789ec8caf86f9657cad665b092b581d40e9fb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/iana-time-zone/0.1.64/download"],
        strip_prefix = "iana-time-zone-0.1.64",
        build_file = Label("//3rdparty/crates:BUILD.iana-time-zone-0.1.64.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__iana-time-zone-haiku-0.1.2",
        sha256 = "f31827a206f56af32e590ba56d5d2d085f558508192593743f16b2306495269f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/iana-time-zone-haiku/0.1.2/download"],
        strip_prefix = "iana-time-zone-haiku-0.1.2",
        build_file = Label("//3rdparty/crates:BUILD.iana-time-zone-haiku-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__icu_collections-2.0.0",
        sha256 = "200072f5d0e3614556f94a9930d5dc3e0662a652823904c3a75dc3b0af7fee47",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_collections/2.0.0/download"],
        strip_prefix = "icu_collections-2.0.0",
        build_file = Label("//3rdparty/crates:BUILD.icu_collections-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__icu_locale_core-2.0.0",
        sha256 = "0cde2700ccaed3872079a65fb1a78f6c0a36c91570f28755dda67bc8f7d9f00a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locale_core/2.0.0/download"],
        strip_prefix = "icu_locale_core-2.0.0",
        build_file = Label("//3rdparty/crates:BUILD.icu_locale_core-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__icu_normalizer-2.0.0",
        sha256 = "436880e8e18df4d7bbc06d58432329d6458cc84531f7ac5f024e93deadb37979",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer/2.0.0/download"],
        strip_prefix = "icu_normalizer-2.0.0",
        build_file = Label("//3rdparty/crates:BUILD.icu_normalizer-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__icu_normalizer_data-2.0.0",
        sha256 = "00210d6893afc98edb752b664b8890f0ef174c8adbb8d0be9710fa66fbbf72d3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer_data/2.0.0/download"],
        strip_prefix = "icu_normalizer_data-2.0.0",
        build_file = Label("//3rdparty/crates:BUILD.icu_normalizer_data-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__icu_properties-2.0.1",
        sha256 = "016c619c1eeb94efb86809b015c58f479963de65bdb6253345c1a1276f22e32b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties/2.0.1/download"],
        strip_prefix = "icu_properties-2.0.1",
        build_file = Label("//3rdparty/crates:BUILD.icu_properties-2.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__icu_properties_data-2.0.1",
        sha256 = "298459143998310acd25ffe6810ed544932242d3f07083eee1084d83a71bd632",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties_data/2.0.1/download"],
        strip_prefix = "icu_properties_data-2.0.1",
        build_file = Label("//3rdparty/crates:BUILD.icu_properties_data-2.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__icu_provider-2.0.0",
        sha256 = "03c80da27b5f4187909049ee2d72f276f0d9f99a42c306bd0131ecfe04d8e5af",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_provider/2.0.0/download"],
        strip_prefix = "icu_provider-2.0.0",
        build_file = Label("//3rdparty/crates:BUILD.icu_provider-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__id-arena-2.2.1",
        sha256 = "25a2bc672d1148e28034f176e01fffebb08b35768468cc954630da77a1449005",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/id-arena/2.2.1/download"],
        strip_prefix = "id-arena-2.2.1",
        build_file = Label("//3rdparty/crates:BUILD.id-arena-2.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__idna-1.1.0",
        sha256 = "3b0875f23caa03898994f6ddc501886a45c7d3d62d04d2d90788d47be1b1e4de",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna/1.1.0/download"],
        strip_prefix = "idna-1.1.0",
        build_file = Label("//3rdparty/crates:BUILD.idna-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__idna_adapter-1.2.1",
        sha256 = "3acae9609540aa318d1bc588455225fb2085b9ed0c4f6bd0d9d5bcd86f1a0344",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna_adapter/1.2.1/download"],
        strip_prefix = "idna_adapter-1.2.1",
        build_file = Label("//3rdparty/crates:BUILD.idna_adapter-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__indexmap-1.9.3",
        sha256 = "bd070e393353796e801d209ad339e89596eb4c8d430d18ede6a1cced8fafbd99",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/1.9.3/download"],
        strip_prefix = "indexmap-1.9.3",
        build_file = Label("//3rdparty/crates:BUILD.indexmap-1.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__indexmap-2.12.0",
        sha256 = "6717a8d2a5a929a1a2eb43a12812498ed141a0bcfb7e8f7844fbdbe4303bba9f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/2.12.0/download"],
        strip_prefix = "indexmap-2.12.0",
        build_file = Label("//3rdparty/crates:BUILD.indexmap-2.12.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__is_terminal_polyfill-1.70.2",
        sha256 = "a6cb138bb79a146c1bd460005623e142ef0181e3d0219cb493e02f7d08a35695",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/is_terminal_polyfill/1.70.2/download"],
        strip_prefix = "is_terminal_polyfill-1.70.2",
        build_file = Label("//3rdparty/crates:BUILD.is_terminal_polyfill-1.70.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__itoa-1.0.15",
        sha256 = "4a5f13b858c8d314ee3e8f639011f7ccefe71f97f96e50151fb991f267928e2c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itoa/1.0.15/download"],
        strip_prefix = "itoa-1.0.15",
        build_file = Label("//3rdparty/crates:BUILD.itoa-1.0.15.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__jiff-0.2.15",
        sha256 = "be1f93b8b1eb69c77f24bbb0afdf66f54b632ee39af40ca21c4365a1d7347e49",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jiff/0.2.15/download"],
        strip_prefix = "jiff-0.2.15",
        build_file = Label("//3rdparty/crates:BUILD.jiff-0.2.15.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__jiff-static-0.2.15",
        sha256 = "03343451ff899767262ec32146f6d559dd759fdadf42ff0e227c7c48f72594b4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jiff-static/0.2.15/download"],
        strip_prefix = "jiff-static-0.2.15",
        build_file = Label("//3rdparty/crates:BUILD.jiff-static-0.2.15.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__js-sys-0.3.82",
        sha256 = "b011eec8cc36da2aab2d5cff675ec18454fad408585853910a202391cf9f8e65",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/js-sys/0.3.82/download"],
        strip_prefix = "js-sys-0.3.82",
        build_file = Label("//3rdparty/crates:BUILD.js-sys-0.3.82.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__leb128-0.2.5",
        sha256 = "884e2677b40cc8c339eaefcb701c32ef1fd2493d71118dc0ca4b6a736c93bd67",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/leb128/0.2.5/download"],
        strip_prefix = "leb128-0.2.5",
        build_file = Label("//3rdparty/crates:BUILD.leb128-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__leb128fmt-0.1.0",
        sha256 = "09edd9e8b54e49e587e4f6295a7d29c3ea94d469cb40ab8ca70b288248a81db2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/leb128fmt/0.1.0/download"],
        strip_prefix = "leb128fmt-0.1.0",
        build_file = Label("//3rdparty/crates:BUILD.leb128fmt-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__libc-0.2.177",
        sha256 = "2874a2af47a2325c2001a6e6fad9b16a53b802102b528163885171cf92b15976",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.177/download"],
        strip_prefix = "libc-0.2.177",
        build_file = Label("//3rdparty/crates:BUILD.libc-0.2.177.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__libredox-0.1.10",
        sha256 = "416f7e718bdb06000964960ffa43b4335ad4012ae8b99060261aa4a8088d5ccb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libredox/0.1.10/download"],
        strip_prefix = "libredox-0.1.10",
        build_file = Label("//3rdparty/crates:BUILD.libredox-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__linux-raw-sys-0.11.0",
        sha256 = "df1d3c3b53da64cf5760482273a98e575c651a67eec7f77df96b5b642de8f039",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/linux-raw-sys/0.11.0/download"],
        strip_prefix = "linux-raw-sys-0.11.0",
        build_file = Label("//3rdparty/crates:BUILD.linux-raw-sys-0.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__litemap-0.8.0",
        sha256 = "241eaef5fd12c88705a01fc1066c48c4b36e0dd4377dcdc7ec3942cea7a69956",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/litemap/0.8.0/download"],
        strip_prefix = "litemap-0.8.0",
        build_file = Label("//3rdparty/crates:BUILD.litemap-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__log-0.4.28",
        sha256 = "34080505efa8e45a4b816c349525ebe327ceaa8559756f0356cba97ef3bf7432",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.28/download"],
        strip_prefix = "log-0.4.28",
        build_file = Label("//3rdparty/crates:BUILD.log-0.4.28.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__memchr-2.7.6",
        sha256 = "f52b00d39961fc5b2736ea853c9cc86238e165017a493d1d5c8eac6bdc4cc273",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.7.6/download"],
        strip_prefix = "memchr-2.7.6",
        build_file = Label("//3rdparty/crates:BUILD.memchr-2.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__mime-0.3.17",
        sha256 = "6877bb514081ee2a7ff5ef9de3281f14a4dd4bceac4c09388074a6b5df8a139a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mime/0.3.17/download"],
        strip_prefix = "mime-0.3.17",
        build_file = Label("//3rdparty/crates:BUILD.mime-0.3.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__mime_guess-2.0.5",
        sha256 = "f7c44f8e672c00fe5308fa235f821cb4198414e1c77935c1ab6948d3fd78550e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mime_guess/2.0.5/download"],
        strip_prefix = "mime_guess-2.0.5",
        build_file = Label("//3rdparty/crates:BUILD.mime_guess-2.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__minicov-0.3.7",
        sha256 = "f27fe9f1cc3c22e1687f9446c2083c4c5fc7f0bcf1c7a86bdbded14985895b4b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/minicov/0.3.7/download"],
        strip_prefix = "minicov-0.3.7",
        build_file = Label("//3rdparty/crates:BUILD.minicov-0.3.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__miniz_oxide-0.8.9",
        sha256 = "1fa76a2c86f704bdb222d66965fb3d63269ce38518b83cb0575fca855ebb6316",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/miniz_oxide/0.8.9/download"],
        strip_prefix = "miniz_oxide-0.8.9",
        build_file = Label("//3rdparty/crates:BUILD.miniz_oxide-0.8.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__multipart-0.18.0",
        sha256 = "00dec633863867f29cb39df64a397cdf4a6354708ddd7759f70c7fb51c5f9182",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/multipart/0.18.0/download"],
        strip_prefix = "multipart-0.18.0",
        build_file = Label("//3rdparty/crates:BUILD.multipart-0.18.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__num-conv-0.1.0",
        sha256 = "51d515d32fb182ee37cda2ccdcb92950d6a3c2893aa280e540671c2cd0f3b1d9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num-conv/0.1.0/download"],
        strip_prefix = "num-conv-0.1.0",
        build_file = Label("//3rdparty/crates:BUILD.num-conv-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__num-traits-0.2.19",
        sha256 = "071dfc062690e90b734c0b2273ce72ad0ffa95f0c74596bc250dcfd960262841",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num-traits/0.2.19/download"],
        strip_prefix = "num-traits-0.2.19",
        build_file = Label("//3rdparty/crates:BUILD.num-traits-0.2.19.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__num_cpus-1.17.0",
        sha256 = "91df4bbde75afed763b708b7eee1e8e7651e02d97f6d5dd763e89367e957b23b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num_cpus/1.17.0/download"],
        strip_prefix = "num_cpus-1.17.0",
        build_file = Label("//3rdparty/crates:BUILD.num_cpus-1.17.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__num_threads-0.1.7",
        sha256 = "5c7398b9c8b70908f6371f47ed36737907c87c52af34c268fed0bf0ceb92ead9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num_threads/0.1.7/download"],
        strip_prefix = "num_threads-0.1.7",
        build_file = Label("//3rdparty/crates:BUILD.num_threads-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__once_cell-1.21.3",
        sha256 = "42f5e15c9953c5e4ccceeb2e7382a716482c34515315f7b03532b8b4e8393d2d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.21.3/download"],
        strip_prefix = "once_cell-1.21.3",
        build_file = Label("//3rdparty/crates:BUILD.once_cell-1.21.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__once_cell_polyfill-1.70.2",
        sha256 = "384b8ab6d37215f3c5301a95a4accb5d64aa607f1fcb26a11b5303878451b4fe",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell_polyfill/1.70.2/download"],
        strip_prefix = "once_cell_polyfill-1.70.2",
        build_file = Label("//3rdparty/crates:BUILD.once_cell_polyfill-1.70.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__percent-encoding-2.3.2",
        sha256 = "9b4f627cb1b25917193a259e49bdad08f671f8d9708acfd5fe0a8c1455d87220",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/percent-encoding/2.3.2/download"],
        strip_prefix = "percent-encoding-2.3.2",
        build_file = Label("//3rdparty/crates:BUILD.percent-encoding-2.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__portable-atomic-1.11.1",
        sha256 = "f84267b20a16ea918e43c6a88433c2d54fa145c92a811b5b047ccbe153674483",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/portable-atomic/1.11.1/download"],
        strip_prefix = "portable-atomic-1.11.1",
        build_file = Label("//3rdparty/crates:BUILD.portable-atomic-1.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__portable-atomic-util-0.2.4",
        sha256 = "d8a2f0d8d040d7848a709caf78912debcc3f33ee4b3cac47d73d1e1069e83507",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/portable-atomic-util/0.2.4/download"],
        strip_prefix = "portable-atomic-util-0.2.4",
        build_file = Label("//3rdparty/crates:BUILD.portable-atomic-util-0.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__potential_utf-0.1.3",
        sha256 = "84df19adbe5b5a0782edcab45899906947ab039ccf4573713735ee7de1e6b08a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/potential_utf/0.1.3/download"],
        strip_prefix = "potential_utf-0.1.3",
        build_file = Label("//3rdparty/crates:BUILD.potential_utf-0.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__powerfmt-0.2.0",
        sha256 = "439ee305def115ba05938db6eb1644ff94165c5ab5e9420d1c1bcedbba909391",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/powerfmt/0.2.0/download"],
        strip_prefix = "powerfmt-0.2.0",
        build_file = Label("//3rdparty/crates:BUILD.powerfmt-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__ppv-lite86-0.2.21",
        sha256 = "85eae3c4ed2f50dcfe72643da4befc30deadb458a9b590d720cde2f2b1e97da9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ppv-lite86/0.2.21/download"],
        strip_prefix = "ppv-lite86-0.2.21",
        build_file = Label("//3rdparty/crates:BUILD.ppv-lite86-0.2.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__proc-macro2-1.0.103",
        sha256 = "5ee95bc4ef87b8d5ba32e8b7714ccc834865276eab0aed5c9958d00ec45f49e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.103/download"],
        strip_prefix = "proc-macro2-1.0.103",
        build_file = Label("//3rdparty/crates:BUILD.proc-macro2-1.0.103.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__quick-error-1.2.3",
        sha256 = "a1d01941d82fa2ab50be1e79e6714289dd7cde78eba4c074bc5a4374f650dfe0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quick-error/1.2.3/download"],
        strip_prefix = "quick-error-1.2.3",
        build_file = Label("//3rdparty/crates:BUILD.quick-error-1.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__quote-1.0.41",
        sha256 = "ce25767e7b499d1b604768e7cde645d14cc8584231ea6b295e9c9eb22c02e1d1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.41/download"],
        strip_prefix = "quote-1.0.41",
        build_file = Label("//3rdparty/crates:BUILD.quote-1.0.41.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__r-efi-5.3.0",
        sha256 = "69cdb34c158ceb288df11e18b4bd39de994f6657d83847bdffdbd7f346754b0f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/r-efi/5.3.0/download"],
        strip_prefix = "r-efi-5.3.0",
        build_file = Label("//3rdparty/crates:BUILD.r-efi-5.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rand-0.8.5",
        sha256 = "34af8d1a0e25924bc5b7c43c079c942339d8f0a8b57c39049bef581b46327404",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand/0.8.5/download"],
        strip_prefix = "rand-0.8.5",
        build_file = Label("//3rdparty/crates:BUILD.rand-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rand_chacha-0.3.1",
        sha256 = "e6c10a63a0fa32252be49d21e7709d4d4baf8d231c2dbce1eaa8141b9b127d88",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand_chacha/0.3.1/download"],
        strip_prefix = "rand_chacha-0.3.1",
        build_file = Label("//3rdparty/crates:BUILD.rand_chacha-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rand_core-0.6.4",
        sha256 = "ec0be4795e2f6a28069bec0b5ff3e2ac9bafc99e6a9a7dc3547996c5c816922c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand_core/0.6.4/download"],
        strip_prefix = "rand_core-0.6.4",
        build_file = Label("//3rdparty/crates:BUILD.rand_core-0.6.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rayon-1.11.0",
        sha256 = "368f01d005bf8fd9b1206fb6fa653e6c4a81ceb1466406b81792d87c5677a58f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rayon/1.11.0/download"],
        strip_prefix = "rayon-1.11.0",
        build_file = Label("//3rdparty/crates:BUILD.rayon-1.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rayon-core-1.13.0",
        sha256 = "22e18b0f0062d30d4230b2e85ff77fdfe4326feb054b9783a3460d8435c8ab91",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rayon-core/1.13.0/download"],
        strip_prefix = "rayon-core-1.13.0",
        build_file = Label("//3rdparty/crates:BUILD.rayon-core-1.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__redox_syscall-0.5.18",
        sha256 = "ed2bf2547551a7053d6fdfafda3f938979645c44812fbfcda098faae3f1a362d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/redox_syscall/0.5.18/download"],
        strip_prefix = "redox_syscall-0.5.18",
        build_file = Label("//3rdparty/crates:BUILD.redox_syscall-0.5.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__regex-1.12.2",
        sha256 = "843bc0191f75f3e22651ae5f1e72939ab2f72a4bc30fa80a066bd66edefc24d4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex/1.12.2/download"],
        strip_prefix = "regex-1.12.2",
        build_file = Label("//3rdparty/crates:BUILD.regex-1.12.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__regex-automata-0.4.13",
        sha256 = "5276caf25ac86c8d810222b3dbb938e512c55c6831a10f3e6ed1c93b84041f1c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.4.13/download"],
        strip_prefix = "regex-automata-0.4.13",
        build_file = Label("//3rdparty/crates:BUILD.regex-automata-0.4.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__regex-syntax-0.8.8",
        sha256 = "7a2d987857b319362043e95f5353c0535c1f58eec5336fdfcf626430af7def58",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-syntax/0.8.8/download"],
        strip_prefix = "regex-syntax-0.8.8",
        build_file = Label("//3rdparty/crates:BUILD.regex-syntax-0.8.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__ring-0.17.14",
        sha256 = "a4689e6c2294d81e88dc6261c768b63bc4fcdb852be6d1352498b114f61383b7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ring/0.17.14/download"],
        strip_prefix = "ring-0.17.14",
        build_file = Label("//3rdparty/crates:BUILD.ring-0.17.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rouille-3.6.2",
        sha256 = "3716fbf57fc1084d7a706adf4e445298d123e4a44294c4e8213caf1b85fcc921",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rouille/3.6.2/download"],
        strip_prefix = "rouille-3.6.2",
        build_file = Label("//3rdparty/crates:BUILD.rouille-3.6.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rustc-demangle-0.1.26",
        sha256 = "56f7d92ca342cea22a06f2121d944b4fd82af56988c270852495420f961d4ace",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-demangle/0.1.26/download"],
        strip_prefix = "rustc-demangle-0.1.26",
        build_file = Label("//3rdparty/crates:BUILD.rustc-demangle-0.1.26.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rustix-1.1.2",
        sha256 = "cd15f8a2c5551a84d56efdc1cd049089e409ac19a3072d5037a17fd70719ff3e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustix/1.1.2/download"],
        strip_prefix = "rustix-1.1.2",
        build_file = Label("//3rdparty/crates:BUILD.rustix-1.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rustls-0.23.34",
        sha256 = "6a9586e9ee2b4f8fab52a0048ca7334d7024eef48e2cb9407e3497bb7cab7fa7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustls/0.23.34/download"],
        strip_prefix = "rustls-0.23.34",
        build_file = Label("//3rdparty/crates:BUILD.rustls-0.23.34.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rustls-pki-types-1.13.0",
        sha256 = "94182ad936a0c91c324cd46c6511b9510ed16af436d7b5bab34beab0afd55f7a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustls-pki-types/1.13.0/download"],
        strip_prefix = "rustls-pki-types-1.13.0",
        build_file = Label("//3rdparty/crates:BUILD.rustls-pki-types-1.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rustls-webpki-0.103.7",
        sha256 = "e10b3f4191e8a80e6b43eebabfac91e5dcecebb27a71f04e820c47ec41d314bf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustls-webpki/0.103.7/download"],
        strip_prefix = "rustls-webpki-0.103.7",
        build_file = Label("//3rdparty/crates:BUILD.rustls-webpki-0.103.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__rustversion-1.0.22",
        sha256 = "b39cdef0fa800fc44525c84ccb54a029961a8215f9619753635a9c0d2538d46d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustversion/1.0.22/download"],
        strip_prefix = "rustversion-1.0.22",
        build_file = Label("//3rdparty/crates:BUILD.rustversion-1.0.22.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__ryu-1.0.20",
        sha256 = "28d3b2b1366ec20994f1fd18c3c594f05c5dd4bc44d8bb0c1c632c8d6829481f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ryu/1.0.20/download"],
        strip_prefix = "ryu-1.0.20",
        build_file = Label("//3rdparty/crates:BUILD.ryu-1.0.20.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__safemem-0.3.3",
        sha256 = "ef703b7cb59335eae2eb93ceb664c0eb7ea6bf567079d843e09420219668e072",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/safemem/0.3.3/download"],
        strip_prefix = "safemem-0.3.3",
        build_file = Label("//3rdparty/crates:BUILD.safemem-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__same-file-1.0.6",
        sha256 = "93fc1dc3aaa9bfed95e02e6eadabb4baf7e3078b0bd1b4d7b6b0b68378900502",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/same-file/1.0.6/download"],
        strip_prefix = "same-file-1.0.6",
        build_file = Label("//3rdparty/crates:BUILD.same-file-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__semver-1.0.27",
        sha256 = "d767eb0aabc880b29956c35734170f26ed551a859dbd361d140cdbeca61ab1e2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/semver/1.0.27/download"],
        strip_prefix = "semver-1.0.27",
        build_file = Label("//3rdparty/crates:BUILD.semver-1.0.27.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__serde-1.0.228",
        sha256 = "9a8e94ea7f378bd32cbbd37198a4a91436180c5bb472411e48b5ec2e2124ae9e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.228/download"],
        strip_prefix = "serde-1.0.228",
        build_file = Label("//3rdparty/crates:BUILD.serde-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__serde_core-1.0.228",
        sha256 = "41d385c7d4ca58e59fc732af25c3983b67ac852c1a25000afe1175de458b67ad",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_core/1.0.228/download"],
        strip_prefix = "serde_core-1.0.228",
        build_file = Label("//3rdparty/crates:BUILD.serde_core-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__serde_derive-1.0.228",
        sha256 = "d540f220d3187173da220f885ab66608367b6574e925011a9353e4badda91d79",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.228/download"],
        strip_prefix = "serde_derive-1.0.228",
        build_file = Label("//3rdparty/crates:BUILD.serde_derive-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__serde_json-1.0.145",
        sha256 = "402a6f66d8c709116cf22f558eab210f5a50187f702eb4d7e5ef38d9a7f1c79c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_json/1.0.145/download"],
        strip_prefix = "serde_json-1.0.145",
        build_file = Label("//3rdparty/crates:BUILD.serde_json-1.0.145.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__sha1_smol-1.0.1",
        sha256 = "bbfa15b3dddfee50a0fff136974b3e1bde555604ba463834a7eb7deb6417705d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sha1_smol/1.0.1/download"],
        strip_prefix = "sha1_smol-1.0.1",
        build_file = Label("//3rdparty/crates:BUILD.sha1_smol-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__shlex-1.3.0",
        sha256 = "0fda2ff0d084019ba4d7c6f371c95d8fd75ce3524c3cb8fb653a3023f6323e64",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/shlex/1.3.0/download"],
        strip_prefix = "shlex-1.3.0",
        build_file = Label("//3rdparty/crates:BUILD.shlex-1.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__simd-adler32-0.3.7",
        sha256 = "d66dc143e6b11c1eddc06d5c423cfc97062865baf299914ab64caa38182078fe",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/simd-adler32/0.3.7/download"],
        strip_prefix = "simd-adler32-0.3.7",
        build_file = Label("//3rdparty/crates:BUILD.simd-adler32-0.3.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__smallvec-1.15.1",
        sha256 = "67b1b7a3b5fe4f1376887184045fcf45c69e92af734b7aaddc05fb777b6fbd03",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/1.15.1/download"],
        strip_prefix = "smallvec-1.15.1",
        build_file = Label("//3rdparty/crates:BUILD.smallvec-1.15.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__stable_deref_trait-1.2.1",
        sha256 = "6ce2be8dc25455e1f91df71bfa12ad37d7af1092ae736f3a6cd0e37bc7810596",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/stable_deref_trait/1.2.1/download"],
        strip_prefix = "stable_deref_trait-1.2.1",
        build_file = Label("//3rdparty/crates:BUILD.stable_deref_trait-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__strsim-0.11.1",
        sha256 = "7da8b5736845d9f2fcb837ea5d9e2628564b3b043a70948a3f0b778838c5fb4f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/strsim/0.11.1/download"],
        strip_prefix = "strsim-0.11.1",
        build_file = Label("//3rdparty/crates:BUILD.strsim-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__subtle-2.6.1",
        sha256 = "13c2bddecc57b384dee18652358fb23172facb8a2c51ccc10d74c157bdea3292",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/subtle/2.6.1/download"],
        strip_prefix = "subtle-2.6.1",
        build_file = Label("//3rdparty/crates:BUILD.subtle-2.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__syn-2.0.108",
        sha256 = "da58917d35242480a05c2897064da0a80589a2a0476c9a3f2fdc83b53502e917",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.108/download"],
        strip_prefix = "syn-2.0.108",
        build_file = Label("//3rdparty/crates:BUILD.syn-2.0.108.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__synstructure-0.13.2",
        sha256 = "728a70f3dbaf5bab7f0c4b1ac8d7ae5ea60a4b5549c8a5914361c99147a709d2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/synstructure/0.13.2/download"],
        strip_prefix = "synstructure-0.13.2",
        build_file = Label("//3rdparty/crates:BUILD.synstructure-0.13.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__tempfile-3.23.0",
        sha256 = "2d31c77bdf42a745371d260a26ca7163f1e0924b64afa0b688e61b5a9fa02f16",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tempfile/3.23.0/download"],
        strip_prefix = "tempfile-3.23.0",
        build_file = Label("//3rdparty/crates:BUILD.tempfile-3.23.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__threadpool-1.8.1",
        sha256 = "d050e60b33d41c19108b32cea32164033a9013fe3b46cbd4457559bfbf77afaa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/threadpool/1.8.1/download"],
        strip_prefix = "threadpool-1.8.1",
        build_file = Label("//3rdparty/crates:BUILD.threadpool-1.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__time-0.3.44",
        sha256 = "91e7d9e3bb61134e77bde20dd4825b97c010155709965fedf0f49bb138e52a9d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/time/0.3.44/download"],
        strip_prefix = "time-0.3.44",
        build_file = Label("//3rdparty/crates:BUILD.time-0.3.44.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__time-core-0.1.6",
        sha256 = "40868e7c1d2f0b8d73e4a8c7f0ff63af4f6d19be117e90bd73eb1d62cf831c6b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/time-core/0.1.6/download"],
        strip_prefix = "time-core-0.1.6",
        build_file = Label("//3rdparty/crates:BUILD.time-core-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__tiny_http-0.12.0",
        sha256 = "389915df6413a2e74fb181895f933386023c71110878cd0825588928e64cdc82",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tiny_http/0.12.0/download"],
        strip_prefix = "tiny_http-0.12.0",
        build_file = Label("//3rdparty/crates:BUILD.tiny_http-0.12.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__tinystr-0.8.1",
        sha256 = "5d4f6d1145dcb577acf783d4e601bc1d76a13337bb54e6233add580b07344c8b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tinystr/0.8.1/download"],
        strip_prefix = "tinystr-0.8.1",
        build_file = Label("//3rdparty/crates:BUILD.tinystr-0.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__twoway-0.1.8",
        sha256 = "59b11b2b5241ba34be09c3cc85a36e56e48f9888862e19cedf23336d35316ed1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/twoway/0.1.8/download"],
        strip_prefix = "twoway-0.1.8",
        build_file = Label("//3rdparty/crates:BUILD.twoway-0.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__unicase-2.8.1",
        sha256 = "75b844d17643ee918803943289730bec8aac480150456169e647ed0b576ba539",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicase/2.8.1/download"],
        strip_prefix = "unicase-2.8.1",
        build_file = Label("//3rdparty/crates:BUILD.unicase-2.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__unicode-ident-1.0.20",
        sha256 = "462eeb75aeb73aea900253ce739c8e18a67423fadf006037cd3ff27e82748a06",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.20/download"],
        strip_prefix = "unicode-ident-1.0.20",
        build_file = Label("//3rdparty/crates:BUILD.unicode-ident-1.0.20.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__untrusted-0.9.0",
        sha256 = "8ecb6da28b8a351d773b68d5825ac39017e680750f980f3a1a85cd8dd28a47c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/untrusted/0.9.0/download"],
        strip_prefix = "untrusted-0.9.0",
        build_file = Label("//3rdparty/crates:BUILD.untrusted-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__ureq-2.12.1",
        sha256 = "02d1a66277ed75f640d608235660df48c8e3c19f3b4edb6a263315626cc3c01d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ureq/2.12.1/download"],
        strip_prefix = "ureq-2.12.1",
        build_file = Label("//3rdparty/crates:BUILD.ureq-2.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__url-2.5.7",
        sha256 = "08bc136a29a3d1758e07a9cca267be308aeebf5cfd5a10f3f67ab2097683ef5b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/url/2.5.7/download"],
        strip_prefix = "url-2.5.7",
        build_file = Label("//3rdparty/crates:BUILD.url-2.5.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__utf8_iter-1.0.4",
        sha256 = "b6c140620e7ffbb22c2dee59cafe6084a59b5ffc27a8859a5f0d494b5d52b6be",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8_iter/1.0.4/download"],
        strip_prefix = "utf8_iter-1.0.4",
        build_file = Label("//3rdparty/crates:BUILD.utf8_iter-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__utf8parse-0.2.2",
        sha256 = "06abde3611657adf66d383f00b093d7faecc7fa57071cce2578660c9f1010821",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8parse/0.2.2/download"],
        strip_prefix = "utf8parse-0.2.2",
        build_file = Label("//3rdparty/crates:BUILD.utf8parse-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__version_check-0.9.5",
        sha256 = "0b928f33d975fc6ad9f86c8f283853ad26bdd5b10b7f1542aa2fa15e2289105a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/version_check/0.9.5/download"],
        strip_prefix = "version_check-0.9.5",
        build_file = Label("//3rdparty/crates:BUILD.version_check-0.9.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__walkdir-2.5.0",
        sha256 = "29790946404f91d9c5d06f9874efddea1dc06c5efe94541a7d6863108e3a5e4b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/walkdir/2.5.0/download"],
        strip_prefix = "walkdir-2.5.0",
        build_file = Label("//3rdparty/crates:BUILD.walkdir-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__walrus-0.24.2",
        sha256 = "3b5fbda74aece555fd16909d66141a934c9db314980a98800cf138a00c3e23a8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/walrus/0.24.2/download"],
        strip_prefix = "walrus-0.24.2",
        build_file = Label("//3rdparty/crates:BUILD.walrus-0.24.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__walrus-macro-0.24.0",
        sha256 = "0ef06db404cbaed87cb25fd2ca3a62502af485f43383c9641ffcf1479d02fffd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/walrus-macro/0.24.0/download"],
        strip_prefix = "walrus-macro-0.24.0",
        build_file = Label("//3rdparty/crates:BUILD.walrus-macro-0.24.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasi-0.11.1-wasi-snapshot-preview1",
        sha256 = "ccf3ec651a847eb01de73ccad15eb7d99f80485de043efb2f370cd654f4ea44b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasi/0.11.1+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.1+wasi-snapshot-preview1",
        build_file = Label("//3rdparty/crates:BUILD.wasi-0.11.1+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasip2-1.0.1-wasi-0.2.4",
        sha256 = "0562428422c63773dad2c345a1882263bbf4d65cf3f42e90921f787ef5ad58e7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasip2/1.0.1+wasi-0.2.4/download"],
        strip_prefix = "wasip2-1.0.1+wasi-0.2.4",
        build_file = Label("//3rdparty/crates:BUILD.wasip2-1.0.1+wasi-0.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-0.2.105",
        sha256 = "da95793dfc411fbbd93f5be7715b0578ec61fe87cb1a42b12eb625caa5c5ea60",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen/0.2.105/download"],
        strip_prefix = "wasm-bindgen-0.2.105",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-cli-0.2.105",
        sha256 = "0e6df6de37dde893edef52a54ef1277de313778e1fe3f1b678c15d98c93d3a50",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-cli/0.2.105/download"],
        strip_prefix = "wasm-bindgen-cli-0.2.105",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-cli-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-cli-support-0.2.105",
        sha256 = "0d3f73cd40cc5c6adf6a090e331f24595f87e7a5bd70ccf3db46be0e1d6e0d92",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-cli-support/0.2.105/download"],
        strip_prefix = "wasm-bindgen-cli-support-0.2.105",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-cli-support-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-futures-0.4.55",
        sha256 = "551f88106c6d5e7ccc7cd9a16f312dd3b5d36ea8b4954304657d5dfba115d4a0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-futures/0.4.55/download"],
        strip_prefix = "wasm-bindgen-futures-0.4.55",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-futures-0.4.55.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-macro-0.2.105",
        sha256 = "04264334509e04a7bf8690f2384ef5265f05143a4bff3889ab7a3269adab59c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-macro/0.2.105/download"],
        strip_prefix = "wasm-bindgen-macro-0.2.105",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-macro-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-macro-support-0.2.105",
        sha256 = "420bc339d9f322e562942d52e115d57e950d12d88983a14c79b86859ee6c7ebc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-macro-support/0.2.105/download"],
        strip_prefix = "wasm-bindgen-macro-support-0.2.105",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-macro-support-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-shared-0.2.105",
        sha256 = "76f218a38c84bcb33c25ec7059b07847d465ce0e0a76b995e134a45adcb6af76",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-shared/0.2.105/download"],
        strip_prefix = "wasm-bindgen-shared-0.2.105",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-shared-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-test-0.3.55",
        sha256 = "bfc379bfb624eb59050b509c13e77b4eb53150c350db69628141abce842f2373",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-test/0.3.55/download"],
        strip_prefix = "wasm-bindgen-test-0.3.55",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-test-0.3.55.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-bindgen-test-macro-0.3.55",
        sha256 = "085b2df989e1e6f9620c1311df6c996e83fe16f57792b272ce1e024ac16a90f1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-test-macro/0.3.55/download"],
        strip_prefix = "wasm-bindgen-test-macro-0.3.55",
        build_file = Label("//3rdparty/crates:BUILD.wasm-bindgen-test-macro-0.3.55.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasm-encoder-0.240.0",
        sha256 = "06d642d8c5ecc083aafe9ceb32809276a304547a3a6eeecceb5d8152598bc71f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-encoder/0.240.0/download"],
        strip_prefix = "wasm-encoder-0.240.0",
        build_file = Label("//3rdparty/crates:BUILD.wasm-encoder-0.240.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasmparser-0.214.0",
        sha256 = "5309c1090e3e84dad0d382f42064e9933fdaedb87e468cc239f0eabea73ddcb6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasmparser/0.214.0/download"],
        strip_prefix = "wasmparser-0.214.0",
        build_file = Label("//3rdparty/crates:BUILD.wasmparser-0.214.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wasmparser-0.240.0",
        sha256 = "b722dcf61e0ea47440b53ff83ccb5df8efec57a69d150e4f24882e4eba7e24a4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasmparser/0.240.0/download"],
        strip_prefix = "wasmparser-0.240.0",
        build_file = Label("//3rdparty/crates:BUILD.wasmparser-0.240.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__web-sys-0.3.82",
        sha256 = "3a1f95c0d03a47f4ae1f7a64643a6bb97465d9b740f0fa8f90ea33915c99a9a1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/web-sys/0.3.82/download"],
        strip_prefix = "web-sys-0.3.82",
        build_file = Label("//3rdparty/crates:BUILD.web-sys-0.3.82.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__webpki-roots-0.26.11",
        sha256 = "521bc38abb08001b01866da9f51eb7c5d647a19260e00054a8c7fd5f9e57f7a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/webpki-roots/0.26.11/download"],
        strip_prefix = "webpki-roots-0.26.11",
        build_file = Label("//3rdparty/crates:BUILD.webpki-roots-0.26.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__webpki-roots-1.0.3",
        sha256 = "32b130c0d2d49f8b6889abc456e795e82525204f27c42cf767cf0d7734e089b8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/webpki-roots/1.0.3/download"],
        strip_prefix = "webpki-roots-1.0.3",
        build_file = Label("//3rdparty/crates:BUILD.webpki-roots-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__winapi-util-0.1.11",
        sha256 = "c2a7b1c03c876122aa43f3020e6c3c3ee5c05081c9a00739faf7503aeba10d22",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-util/0.1.11/download"],
        strip_prefix = "winapi-util-0.1.11",
        build_file = Label("//3rdparty/crates:BUILD.winapi-util-0.1.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-core-0.62.2",
        sha256 = "b8e83a14d34d0623b51dce9581199302a221863196a1dde71a7663a4c2be9deb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-core/0.62.2/download"],
        strip_prefix = "windows-core-0.62.2",
        build_file = Label("//3rdparty/crates:BUILD.windows-core-0.62.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-implement-0.60.2",
        sha256 = "053e2e040ab57b9dc951b72c264860db7eb3b0200ba345b4e4c3b14f67855ddf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-implement/0.60.2/download"],
        strip_prefix = "windows-implement-0.60.2",
        build_file = Label("//3rdparty/crates:BUILD.windows-implement-0.60.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-interface-0.59.3",
        sha256 = "3f316c4a2570ba26bbec722032c4099d8c8bc095efccdc15688708623367e358",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-interface/0.59.3/download"],
        strip_prefix = "windows-interface-0.59.3",
        build_file = Label("//3rdparty/crates:BUILD.windows-interface-0.59.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-link-0.2.1",
        sha256 = "f0805222e57f7521d6a62e36fa9163bc891acd422f971defe97d64e70d0a4fe5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-link/0.2.1/download"],
        strip_prefix = "windows-link-0.2.1",
        build_file = Label("//3rdparty/crates:BUILD.windows-link-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-result-0.4.1",
        sha256 = "7781fa89eaf60850ac3d2da7af8e5242a5ea78d1a11c49bf2910bb5a73853eb5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-result/0.4.1/download"],
        strip_prefix = "windows-result-0.4.1",
        build_file = Label("//3rdparty/crates:BUILD.windows-result-0.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-strings-0.5.1",
        sha256 = "7837d08f69c77cf6b07689544538e017c1bfcf57e34b4c0ff58e6c2cd3b37091",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-strings/0.5.1/download"],
        strip_prefix = "windows-strings-0.5.1",
        build_file = Label("//3rdparty/crates:BUILD.windows-strings-0.5.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-sys-0.52.0",
        sha256 = "282be5f36a8ce781fad8c8ae18fa3f9beff57ec1b52cb3de0789201425d9a33d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.52.0/download"],
        strip_prefix = "windows-sys-0.52.0",
        build_file = Label("//3rdparty/crates:BUILD.windows-sys-0.52.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-sys-0.60.2",
        sha256 = "f2f500e4d28234f72040990ec9d39e3a6b950f9f22d3dba18416c35882612bcb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.60.2/download"],
        strip_prefix = "windows-sys-0.60.2",
        build_file = Label("//3rdparty/crates:BUILD.windows-sys-0.60.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-sys-0.61.2",
        sha256 = "ae137229bcbd6cdf0f7b80a31df61766145077ddf49416a728b02cb3921ff3fc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.61.2/download"],
        strip_prefix = "windows-sys-0.61.2",
        build_file = Label("//3rdparty/crates:BUILD.windows-sys-0.61.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-targets-0.52.6",
        sha256 = "9b724f72796e036ab90c1021d4780d4d3d648aca59e491e6b98e725b84e99973",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.52.6/download"],
        strip_prefix = "windows-targets-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows-targets-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows-targets-0.53.5",
        sha256 = "4945f9f551b88e0d65f3db0bc25c33b8acea4d9e41163edf90dcd0b19f9069f3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.53.5/download"],
        strip_prefix = "windows-targets-0.53.5",
        build_file = Label("//3rdparty/crates:BUILD.windows-targets-0.53.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_aarch64_gnullvm-0.52.6",
        sha256 = "32a4622180e7a0ec044bb555404c800bc9fd9ec262ec147edd5989ccd0c02cd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_aarch64_gnullvm-0.53.1",
        sha256 = "a9d8416fa8b42f5c947f8482c43e7d89e73a173cead56d044f6a56104a6d1b53",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.53.1/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.53.1",
        build_file = Label("//3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_aarch64_msvc-0.52.6",
        sha256 = "09ec2a7bb152e2252b53fa7803150007879548bc709c039df7627cabbd05d469",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.52.6/download"],
        strip_prefix = "windows_aarch64_msvc-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_aarch64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_aarch64_msvc-0.53.1",
        sha256 = "b9d782e804c2f632e395708e99a94275910eb9100b2114651e04744e9b125006",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.53.1/download"],
        strip_prefix = "windows_aarch64_msvc-0.53.1",
        build_file = Label("//3rdparty/crates:BUILD.windows_aarch64_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_i686_gnu-0.52.6",
        sha256 = "8e9b5ad5ab802e97eb8e295ac6720e509ee4c243f69d781394014ebfe8bbfa0b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.52.6/download"],
        strip_prefix = "windows_i686_gnu-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_i686_gnu-0.53.1",
        sha256 = "960e6da069d81e09becb0ca57a65220ddff016ff2d6af6a223cf372a506593a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.53.1/download"],
        strip_prefix = "windows_i686_gnu-0.53.1",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_gnu-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_i686_gnullvm-0.52.6",
        sha256 = "0eee52d38c090b3caa76c563b86c3a4bd71ef1a819287c19d586d7334ae8ed66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.52.6/download"],
        strip_prefix = "windows_i686_gnullvm-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_i686_gnullvm-0.53.1",
        sha256 = "fa7359d10048f68ab8b09fa71c3daccfb0e9b559aed648a8f95469c27057180c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.53.1/download"],
        strip_prefix = "windows_i686_gnullvm-0.53.1",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_i686_msvc-0.52.6",
        sha256 = "240948bc05c5e7c6dabba28bf89d89ffce3e303022809e73deaefe4f6ec56c66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.52.6/download"],
        strip_prefix = "windows_i686_msvc-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_i686_msvc-0.53.1",
        sha256 = "1e7ac75179f18232fe9c285163565a57ef8d3c89254a30685b57d83a38d326c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.53.1/download"],
        strip_prefix = "windows_i686_msvc-0.53.1",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_x86_64_gnu-0.52.6",
        sha256 = "147a5c80aabfbf0c7d901cb5895d1de30ef2907eb21fbbab29ca94c5b08b1a78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnu-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_x86_64_gnu-0.53.1",
        sha256 = "9c3842cdd74a865a8066ab39c8a7a473c0778a3f29370b5fd6b4b9aa7df4a499",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.53.1/download"],
        strip_prefix = "windows_x86_64_gnu-0.53.1",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_gnu-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_x86_64_gnullvm-0.52.6",
        sha256 = "24d5b23dc417412679681396f2b49f3de8c1473deb516bd34410872eff51ed0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_x86_64_gnullvm-0.53.1",
        sha256 = "0ffa179e2d07eee8ad8f57493436566c7cc30ac536a3379fdf008f47f6bb7ae1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.53.1/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.53.1",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_x86_64_msvc-0.52.6",
        sha256 = "589f6da84c646204747d1270a2a5661ea66ed1cced2631d546fdfb155959f9ec",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.52.6/download"],
        strip_prefix = "windows_x86_64_msvc-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__windows_x86_64_msvc-0.53.1",
        sha256 = "d6bbff5f0aada427a1e5a6da5f1f98158182f26556f345ac9e04d36d0ebed650",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.53.1/download"],
        strip_prefix = "windows_x86_64_msvc-0.53.1",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__wit-bindgen-0.46.0",
        sha256 = "f17a85883d4e6d00e8a97c586de764dabcc06133f7f1d55dce5cdc070ad7fe59",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wit-bindgen/0.46.0/download"],
        strip_prefix = "wit-bindgen-0.46.0",
        build_file = Label("//3rdparty/crates:BUILD.wit-bindgen-0.46.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__writeable-0.6.1",
        sha256 = "ea2f10b9bb0928dfb1b42b65e1f9e36f7f54dbdf08457afefb38afcdec4fa2bb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/writeable/0.6.1/download"],
        strip_prefix = "writeable-0.6.1",
        build_file = Label("//3rdparty/crates:BUILD.writeable-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__yoke-0.8.0",
        sha256 = "5f41bb01b8226ef4bfd589436a297c53d118f65921786300e427be8d487695cc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke/0.8.0/download"],
        strip_prefix = "yoke-0.8.0",
        build_file = Label("//3rdparty/crates:BUILD.yoke-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__yoke-derive-0.8.0",
        sha256 = "38da3c9736e16c5d3c8c597a9aaa5d1fa565d0532ae05e27c24aa62fb32c0ab6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke-derive/0.8.0/download"],
        strip_prefix = "yoke-derive-0.8.0",
        build_file = Label("//3rdparty/crates:BUILD.yoke-derive-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__zerocopy-0.8.27",
        sha256 = "0894878a5fa3edfd6da3f88c4805f4c8558e2b996227a3d864f47fe11e38282c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy/0.8.27/download"],
        strip_prefix = "zerocopy-0.8.27",
        build_file = Label("//3rdparty/crates:BUILD.zerocopy-0.8.27.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__zerocopy-derive-0.8.27",
        sha256 = "88d2b8d9c68ad2b9e4340d7832716a4d21a22a1154777ad56ea55c51a9cf3831",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy-derive/0.8.27/download"],
        strip_prefix = "zerocopy-derive-0.8.27",
        build_file = Label("//3rdparty/crates:BUILD.zerocopy-derive-0.8.27.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__zerofrom-0.1.6",
        sha256 = "50cc42e0333e05660c3587f3bf9d0478688e15d870fab3346451ce7f8c9fbea5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom/0.1.6/download"],
        strip_prefix = "zerofrom-0.1.6",
        build_file = Label("//3rdparty/crates:BUILD.zerofrom-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__zerofrom-derive-0.1.6",
        sha256 = "d71e5d6e06ab090c67b5e44993ec16b72dcbaabc526db883a360057678b48502",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom-derive/0.1.6/download"],
        strip_prefix = "zerofrom-derive-0.1.6",
        build_file = Label("//3rdparty/crates:BUILD.zerofrom-derive-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__zeroize-1.8.2",
        sha256 = "b97154e67e32c85465826e8bcc1c59429aaaf107c1e4a9e53c8d8ccd5eff88d0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zeroize/1.8.2/download"],
        strip_prefix = "zeroize-1.8.2",
        build_file = Label("//3rdparty/crates:BUILD.zeroize-1.8.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__zerotrie-0.2.2",
        sha256 = "36f0bbd478583f79edad978b407914f61b2972f5af6fa089686016be8f9af595",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerotrie/0.2.2/download"],
        strip_prefix = "zerotrie-0.2.2",
        build_file = Label("//3rdparty/crates:BUILD.zerotrie-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__zerovec-0.11.4",
        sha256 = "e7aa2bd55086f1ab526693ecbe444205da57e25f4489879da80635a46d90e73b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec/0.11.4/download"],
        strip_prefix = "zerovec-0.11.4",
        build_file = Label("//3rdparty/crates:BUILD.zerovec-0.11.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrwbd__zerovec-derive-0.11.1",
        sha256 = "5b96237efa0c878c64bd89c436f661be4e46b2f3eff1ebb976f7ef2321d2f58f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec-derive/0.11.1/download"],
        strip_prefix = "zerovec-derive-0.11.1",
        build_file = Label("//3rdparty/crates:BUILD.zerovec-derive-0.11.1.bazel"),
    )

    return [
        struct(repo = "rrwbd__serde_json-1.0.145", is_dev_dep = False),
        struct(repo = "rrwbd__wasm-bindgen-0.2.105", is_dev_dep = False),
        struct(repo = "rrwbd__wasm-bindgen-cli-0.2.105", is_dev_dep = False),
        struct(repo = "rrwbd__wasm-bindgen-test-0.3.55", is_dev_dep = False),
    ]
