###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "grpc": Label("@rules_rust_protobuf_deps//:grpc-0.6.2"),
            "grpc-compiler": Label("@rules_rust_protobuf_deps//:grpc-compiler-0.6.2"),
            "log": Label("@rules_rust_protobuf_deps//:log-0.4.17"),
            "protobuf": Label("@rules_rust_protobuf_deps//:protobuf-2.8.2"),
            "protobuf-codegen": Label("@rules_rust_protobuf_deps//:protobuf-codegen-2.8.2"),
            "tls-api": Label("@rules_rust_protobuf_deps//:tls-api-0.1.22"),
            "tls-api-stub": Label("@rules_rust_protobuf_deps//:tls-api-stub-0.1.22"),
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"aarch64\"), target_os = \"hermit\"))": [],
    "cfg(any(unix, target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(not(windows))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(target_os = \"cloudabi\")": [],
    "cfg(target_os = \"fuchsia\")": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "cfg(target_os = \"redox\")": [],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__autocfg-1.1.0",
        sha256 = "d468802bab17cbc0cc575e9b053f41e72aa36bfa6b7f55e3529ffa43161b97fa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/autocfg/1.1.0/download"],
        strip_prefix = "autocfg-1.1.0",
        build_file = Label("//3rdparty/crates:BUILD.autocfg-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__base64-0.9.3",
        sha256 = "489d6c0ed21b11d038c31b6ceccca973e65d73ba3bd8ecb9a2babf5546164643",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/base64/0.9.3/download"],
        strip_prefix = "base64-0.9.3",
        build_file = Label("//3rdparty/crates:BUILD.base64-0.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("//3rdparty/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__byteorder-1.4.3",
        sha256 = "14c189c53d098945499cdfa7ecc63567cf3886b3332b312a5b4585d8d3a6a610",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/byteorder/1.4.3/download"],
        strip_prefix = "byteorder-1.4.3",
        build_file = Label("//3rdparty/crates:BUILD.byteorder-1.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__bytes-0.4.12",
        sha256 = "206fdffcfa2df7cbe15601ef46c813fce0965eb3286db6b56c583b814b51c81c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bytes/0.4.12/download"],
        strip_prefix = "bytes-0.4.12",
        build_file = Label("//3rdparty/crates:BUILD.bytes-0.4.12.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__cfg-if-0.1.10",
        sha256 = "4785bdd1c96b2a846b2bd7cc02e86b6b3dbf14e7e53446c4f54c92a361040822",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/0.1.10/download"],
        strip_prefix = "cfg-if-0.1.10",
        build_file = Label("//3rdparty/crates:BUILD.cfg-if-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("//3rdparty/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__cloudabi-0.0.3",
        sha256 = "ddfc5b9aa5d4507acaf872de71051dfd0e309860e88966e1051e462a077aac4f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cloudabi/0.0.3/download"],
        strip_prefix = "cloudabi-0.0.3",
        build_file = Label("//3rdparty/crates:BUILD.cloudabi-0.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__crossbeam-deque-0.7.4",
        sha256 = "c20ff29ded3204c5106278a81a38f4b482636ed4fa1e6cfbeef193291beb29ed",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-deque/0.7.4/download"],
        strip_prefix = "crossbeam-deque-0.7.4",
        build_file = Label("//3rdparty/crates:BUILD.crossbeam-deque-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__crossbeam-epoch-0.8.2",
        sha256 = "058ed274caafc1f60c4997b5fc07bf7dc7cca454af7c6e81edffe5f33f70dace",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-epoch/0.8.2/download"],
        strip_prefix = "crossbeam-epoch-0.8.2",
        build_file = Label("//3rdparty/crates:BUILD.crossbeam-epoch-0.8.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__crossbeam-queue-0.2.3",
        sha256 = "774ba60a54c213d409d5353bda12d49cd68d14e45036a285234c8d6f91f92570",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-queue/0.2.3/download"],
        strip_prefix = "crossbeam-queue-0.2.3",
        build_file = Label("//3rdparty/crates:BUILD.crossbeam-queue-0.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__crossbeam-utils-0.7.2",
        sha256 = "c3c7c73a2d1e9fc0886a08b93e98eb643461230d5f1925e4036204d5f2e261a8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-utils/0.7.2/download"],
        strip_prefix = "crossbeam-utils-0.7.2",
        build_file = Label("//3rdparty/crates:BUILD.crossbeam-utils-0.7.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__fnv-1.0.7",
        sha256 = "3f9eec918d3f24069decb9af1554cad7c880e2da24a9afd88aca000531ab82c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fnv/1.0.7/download"],
        strip_prefix = "fnv-1.0.7",
        build_file = Label("//3rdparty/crates:BUILD.fnv-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__fuchsia-zircon-0.3.3",
        sha256 = "2e9763c69ebaae630ba35f74888db465e49e259ba1bc0eda7d06f4a067615d82",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fuchsia-zircon/0.3.3/download"],
        strip_prefix = "fuchsia-zircon-0.3.3",
        build_file = Label("//3rdparty/crates:BUILD.fuchsia-zircon-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__fuchsia-zircon-sys-0.3.3",
        sha256 = "3dcaa9ae7725d12cdb85b3ad99a434db70b468c09ded17e012d86b5c1010f7a7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fuchsia-zircon-sys/0.3.3/download"],
        strip_prefix = "fuchsia-zircon-sys-0.3.3",
        build_file = Label("//3rdparty/crates:BUILD.fuchsia-zircon-sys-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__futures-0.1.31",
        sha256 = "3a471a38ef8ed83cd6e40aa59c1ffe17db6855c18e3604d9c4ed8c08ebc28678",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures/0.1.31/download"],
        strip_prefix = "futures-0.1.31",
        build_file = Label("//3rdparty/crates:BUILD.futures-0.1.31.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__futures-cpupool-0.1.8",
        sha256 = "ab90cde24b3319636588d0c35fe03b1333857621051837ed769faefb4c2162e4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-cpupool/0.1.8/download"],
        strip_prefix = "futures-cpupool-0.1.8",
        build_file = Label("//3rdparty/crates:BUILD.futures-cpupool-0.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__grpc-0.6.2",
        sha256 = "2aaf1d741fe6f3413f1f9f71b99f5e4e26776d563475a8a53ce53a73a8534c1d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/grpc/0.6.2/download"],
        strip_prefix = "grpc-0.6.2",
        build_file = Label("//3rdparty/crates:BUILD.grpc-0.6.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__grpc-compiler-0.6.2",
        sha256 = "907274ce8ee7b40a0d0b0db09022ea22846a47cfb1fc8ad2c983c70001b4ffb1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/grpc-compiler/0.6.2/download"],
        strip_prefix = "grpc-compiler-0.6.2",
        build_file = Label("//3rdparty/crates:BUILD.grpc-compiler-0.6.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__hermit-abi-0.2.6",
        sha256 = "ee512640fe35acbfb4bb779db6f0d80704c2cacfa2e39b601ef3e3f47d1ae4c7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hermit-abi/0.2.6/download"],
        strip_prefix = "hermit-abi-0.2.6",
        build_file = Label("//3rdparty/crates:BUILD.hermit-abi-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__httpbis-0.7.0",
        sha256 = "7689cfa896b2a71da4f16206af167542b75d242b6906313e53857972a92d5614",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/httpbis/0.7.0/download"],
        strip_prefix = "httpbis-0.7.0",
        build_file = Label("//3rdparty/crates:BUILD.httpbis-0.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__iovec-0.1.4",
        sha256 = "b2b3ea6ff95e175473f8ffe6a7eb7c00d054240321b84c57051175fe3c1e075e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/iovec/0.1.4/download"],
        strip_prefix = "iovec-0.1.4",
        build_file = Label("//3rdparty/crates:BUILD.iovec-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__kernel32-sys-0.2.2",
        sha256 = "7507624b29483431c0ba2d82aece8ca6cdba9382bff4ddd0f7490560c056098d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/kernel32-sys/0.2.2/download"],
        strip_prefix = "kernel32-sys-0.2.2",
        build_file = Label("//3rdparty/crates:BUILD.kernel32-sys-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__lazy_static-1.4.0",
        sha256 = "e2abad23fbc42b3700f2f279844dc832adb2b2eb069b2df918f455c4e18cc646",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lazy_static/1.4.0/download"],
        strip_prefix = "lazy_static-1.4.0",
        build_file = Label("//3rdparty/crates:BUILD.lazy_static-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__libc-0.2.139",
        sha256 = "201de327520df007757c1f0adce6e827fe8562fbc28bfd9c15571c66ca1f5f79",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.139/download"],
        strip_prefix = "libc-0.2.139",
        build_file = Label("//3rdparty/crates:BUILD.libc-0.2.139.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__lock_api-0.3.4",
        sha256 = "c4da24a77a3d8a6d4862d95f72e6fdb9c09a643ecdb402d754004a557f2bec75",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lock_api/0.3.4/download"],
        strip_prefix = "lock_api-0.3.4",
        build_file = Label("//3rdparty/crates:BUILD.lock_api-0.3.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__log-0.3.9",
        sha256 = "e19e8d5c34a3e0e2223db8e060f9e8264aeeb5c5fc64a4ee9965c062211c024b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.3.9/download"],
        strip_prefix = "log-0.3.9",
        build_file = Label("//3rdparty/crates:BUILD.log-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__log-0.4.17",
        sha256 = "abb12e687cfb44aa40f41fc3978ef76448f9b6038cad6aef4259d3c095a2382e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.17/download"],
        strip_prefix = "log-0.4.17",
        build_file = Label("//3rdparty/crates:BUILD.log-0.4.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__maybe-uninit-2.0.0",
        sha256 = "60302e4db3a61da70c0cb7991976248362f30319e88850c487b9b95bbf059e00",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/maybe-uninit/2.0.0/download"],
        strip_prefix = "maybe-uninit-2.0.0",
        build_file = Label("//3rdparty/crates:BUILD.maybe-uninit-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__memoffset-0.5.6",
        sha256 = "043175f069eda7b85febe4a74abbaeff828d9f8b448515d3151a14a3542811aa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memoffset/0.5.6/download"],
        strip_prefix = "memoffset-0.5.6",
        build_file = Label("//3rdparty/crates:BUILD.memoffset-0.5.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__mio-0.6.23",
        sha256 = "4afd66f5b91bf2a3bc13fad0e21caedac168ca4c707504e75585648ae80e4cc4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mio/0.6.23/download"],
        strip_prefix = "mio-0.6.23",
        build_file = Label("//3rdparty/crates:BUILD.mio-0.6.23.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__mio-uds-0.6.8",
        sha256 = "afcb699eb26d4332647cc848492bbc15eafb26f08d0304550d5aa1f612e066f0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mio-uds/0.6.8/download"],
        strip_prefix = "mio-uds-0.6.8",
        build_file = Label("//3rdparty/crates:BUILD.mio-uds-0.6.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__miow-0.2.2",
        sha256 = "ebd808424166322d4a38da87083bfddd3ac4c131334ed55856112eb06d46944d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/miow/0.2.2/download"],
        strip_prefix = "miow-0.2.2",
        build_file = Label("//3rdparty/crates:BUILD.miow-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__net2-0.2.38",
        sha256 = "74d0df99cfcd2530b2e694f6e17e7f37b8e26bb23983ac530c0c97408837c631",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/net2/0.2.38/download"],
        strip_prefix = "net2-0.2.38",
        build_file = Label("//3rdparty/crates:BUILD.net2-0.2.38.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__num_cpus-1.15.0",
        sha256 = "0fac9e2da13b5eb447a6ce3d392f23a29d8694bff781bf03a16cd9ac8697593b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num_cpus/1.15.0/download"],
        strip_prefix = "num_cpus-1.15.0",
        build_file = Label("//3rdparty/crates:BUILD.num_cpus-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__parking_lot-0.9.0",
        sha256 = "f842b1982eb6c2fe34036a4fbfb06dd185a3f5c8edfaacdf7d1ea10b07de6252",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot/0.9.0/download"],
        strip_prefix = "parking_lot-0.9.0",
        build_file = Label("//3rdparty/crates:BUILD.parking_lot-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__parking_lot_core-0.6.3",
        sha256 = "bda66b810a62be75176a80873726630147a5ca780cd33921e0b5709033e66b0a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot_core/0.6.3/download"],
        strip_prefix = "parking_lot_core-0.6.3",
        build_file = Label("//3rdparty/crates:BUILD.parking_lot_core-0.6.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__protobuf-2.8.2",
        patch_args = [
            "-p1",
        ],
        patches = [
            "@rules_rust_protobuf//3rdparty/patches:protobuf-2.8.2.patch",
        ],
        sha256 = "70731852eec72c56d11226c8a5f96ad5058a3dab73647ca5f7ee351e464f2571",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/protobuf/2.8.2/download"],
        strip_prefix = "protobuf-2.8.2",
        build_file = Label("//3rdparty/crates:BUILD.protobuf-2.8.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__protobuf-codegen-2.8.2",
        sha256 = "3d74b9cbbf2ac9a7169c85a3714ec16c51ee9ec7cfd511549527e9a7df720795",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/protobuf-codegen/2.8.2/download"],
        strip_prefix = "protobuf-codegen-2.8.2",
        build_file = Label("//3rdparty/crates:BUILD.protobuf-codegen-2.8.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__redox_syscall-0.1.57",
        sha256 = "41cc0f7e4d5d4544e8861606a285bb08d3e70712ccc7d2b84d7c0ccfaf4b05ce",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/redox_syscall/0.1.57/download"],
        strip_prefix = "redox_syscall-0.1.57",
        build_file = Label("//3rdparty/crates:BUILD.redox_syscall-0.1.57.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__rustc_version-0.2.3",
        sha256 = "138e3e0acb6c9fb258b19b67cb8abd63c00679d2851805ea151465464fe9030a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc_version/0.2.3/download"],
        strip_prefix = "rustc_version-0.2.3",
        build_file = Label("//3rdparty/crates:BUILD.rustc_version-0.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__safemem-0.3.3",
        sha256 = "ef703b7cb59335eae2eb93ceb664c0eb7ea6bf567079d843e09420219668e072",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/safemem/0.3.3/download"],
        strip_prefix = "safemem-0.3.3",
        build_file = Label("//3rdparty/crates:BUILD.safemem-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__scoped-tls-0.1.2",
        sha256 = "332ffa32bf586782a3efaeb58f127980944bbc8c4d6913a86107ac2a5ab24b28",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scoped-tls/0.1.2/download"],
        strip_prefix = "scoped-tls-0.1.2",
        build_file = Label("//3rdparty/crates:BUILD.scoped-tls-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__scopeguard-1.1.0",
        sha256 = "d29ab0c6d3fc0ee92fe66e2d99f700eab17a8d57d1c1d3b748380fb20baa78cd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scopeguard/1.1.0/download"],
        strip_prefix = "scopeguard-1.1.0",
        build_file = Label("//3rdparty/crates:BUILD.scopeguard-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__semver-0.9.0",
        sha256 = "1d7eb9ef2c18661902cc47e535f9bc51b78acd254da71d375c2f6720d9a40403",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/semver/0.9.0/download"],
        strip_prefix = "semver-0.9.0",
        build_file = Label("//3rdparty/crates:BUILD.semver-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__semver-parser-0.7.0",
        sha256 = "388a1df253eca08550bef6c72392cfe7c30914bf41df5269b68cbd6ff8f570a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/semver-parser/0.7.0/download"],
        strip_prefix = "semver-parser-0.7.0",
        build_file = Label("//3rdparty/crates:BUILD.semver-parser-0.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__slab-0.3.0",
        sha256 = "17b4fcaed89ab08ef143da37bc52adbcc04d4a69014f4c1208d6b51f0c47bc23",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/slab/0.3.0/download"],
        strip_prefix = "slab-0.3.0",
        build_file = Label("//3rdparty/crates:BUILD.slab-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__slab-0.4.7",
        sha256 = "4614a76b2a8be0058caa9dbbaf66d988527d86d003c11a94fbd335d7661edcef",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/slab/0.4.7/download"],
        strip_prefix = "slab-0.4.7",
        build_file = Label("//3rdparty/crates:BUILD.slab-0.4.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__smallvec-0.6.14",
        sha256 = "b97fcaeba89edba30f044a10c6a3cc39df9c3f17d7cd829dd1446cab35f890e0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/0.6.14/download"],
        strip_prefix = "smallvec-0.6.14",
        build_file = Label("//3rdparty/crates:BUILD.smallvec-0.6.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tls-api-0.1.22",
        sha256 = "049c03787a0595182357fbd487577947f4351b78ce20c3668f6d49f17feb13d1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tls-api/0.1.22/download"],
        strip_prefix = "tls-api-0.1.22",
        build_file = Label("//3rdparty/crates:BUILD.tls-api-0.1.22.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tls-api-stub-0.1.22",
        sha256 = "c9a0cc8c149724db9de7d73a0e1bc80b1a74f5394f08c6f301e11f9c35fa061e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tls-api-stub/0.1.22/download"],
        strip_prefix = "tls-api-stub-0.1.22",
        build_file = Label("//3rdparty/crates:BUILD.tls-api-stub-0.1.22.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-0.1.22",
        sha256 = "5a09c0b5bb588872ab2f09afa13ee6e9dac11e10a0ec9e8e3ba39a5a5d530af6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio/0.1.22/download"],
        strip_prefix = "tokio-0.1.22",
        build_file = Label("//3rdparty/crates:BUILD.tokio-0.1.22.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-codec-0.1.2",
        sha256 = "25b2998660ba0e70d18684de5d06b70b70a3a747469af9dea7618cc59e75976b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-codec/0.1.2/download"],
        strip_prefix = "tokio-codec-0.1.2",
        build_file = Label("//3rdparty/crates:BUILD.tokio-codec-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-core-0.1.18",
        sha256 = "87b1395334443abca552f63d4f61d0486f12377c2ba8b368e523f89e828cffd4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-core/0.1.18/download"],
        strip_prefix = "tokio-core-0.1.18",
        build_file = Label("//3rdparty/crates:BUILD.tokio-core-0.1.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-current-thread-0.1.7",
        sha256 = "b1de0e32a83f131e002238d7ccde18211c0a5397f60cbfffcb112868c2e0e20e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-current-thread/0.1.7/download"],
        strip_prefix = "tokio-current-thread-0.1.7",
        build_file = Label("//3rdparty/crates:BUILD.tokio-current-thread-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-executor-0.1.10",
        sha256 = "fb2d1b8f4548dbf5e1f7818512e9c406860678f29c300cdf0ebac72d1a3a1671",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-executor/0.1.10/download"],
        strip_prefix = "tokio-executor-0.1.10",
        build_file = Label("//3rdparty/crates:BUILD.tokio-executor-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-fs-0.1.7",
        sha256 = "297a1206e0ca6302a0eed35b700d292b275256f596e2f3fea7729d5e629b6ff4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-fs/0.1.7/download"],
        strip_prefix = "tokio-fs-0.1.7",
        build_file = Label("//3rdparty/crates:BUILD.tokio-fs-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-io-0.1.13",
        sha256 = "57fc868aae093479e3131e3d165c93b1c7474109d13c90ec0dda2a1bbfff0674",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-io/0.1.13/download"],
        strip_prefix = "tokio-io-0.1.13",
        build_file = Label("//3rdparty/crates:BUILD.tokio-io-0.1.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-reactor-0.1.12",
        sha256 = "09bc590ec4ba8ba87652da2068d150dcada2cfa2e07faae270a5e0409aa51351",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-reactor/0.1.12/download"],
        strip_prefix = "tokio-reactor-0.1.12",
        build_file = Label("//3rdparty/crates:BUILD.tokio-reactor-0.1.12.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-sync-0.1.8",
        sha256 = "edfe50152bc8164fcc456dab7891fa9bf8beaf01c5ee7e1dd43a397c3cf87dee",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-sync/0.1.8/download"],
        strip_prefix = "tokio-sync-0.1.8",
        build_file = Label("//3rdparty/crates:BUILD.tokio-sync-0.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-tcp-0.1.4",
        sha256 = "98df18ed66e3b72e742f185882a9e201892407957e45fbff8da17ae7a7c51f72",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-tcp/0.1.4/download"],
        strip_prefix = "tokio-tcp-0.1.4",
        build_file = Label("//3rdparty/crates:BUILD.tokio-tcp-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-threadpool-0.1.18",
        sha256 = "df720b6581784c118f0eb4310796b12b1d242a7eb95f716a8367855325c25f89",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-threadpool/0.1.18/download"],
        strip_prefix = "tokio-threadpool-0.1.18",
        build_file = Label("//3rdparty/crates:BUILD.tokio-threadpool-0.1.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-timer-0.1.2",
        sha256 = "6131e780037787ff1b3f8aad9da83bca02438b72277850dd6ad0d455e0e20efc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-timer/0.1.2/download"],
        strip_prefix = "tokio-timer-0.1.2",
        build_file = Label("//3rdparty/crates:BUILD.tokio-timer-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-timer-0.2.13",
        sha256 = "93044f2d313c95ff1cb7809ce9a7a05735b012288a888b62d4434fd58c94f296",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-timer/0.2.13/download"],
        strip_prefix = "tokio-timer-0.2.13",
        build_file = Label("//3rdparty/crates:BUILD.tokio-timer-0.2.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-tls-api-0.1.22",
        sha256 = "68d0e040d5b1f4cfca70ec4f371229886a5de5bb554d272a4a8da73004a7b2c9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-tls-api/0.1.22/download"],
        strip_prefix = "tokio-tls-api-0.1.22",
        build_file = Label("//3rdparty/crates:BUILD.tokio-tls-api-0.1.22.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-udp-0.1.6",
        sha256 = "e2a0b10e610b39c38b031a2fcab08e4b82f16ece36504988dcbd81dbba650d82",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-udp/0.1.6/download"],
        strip_prefix = "tokio-udp-0.1.6",
        build_file = Label("//3rdparty/crates:BUILD.tokio-udp-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-uds-0.1.7",
        sha256 = "65ae5d255ce739e8537221ed2942e0445f4b3b813daebac1c0050ddaaa3587f9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-uds/0.1.7/download"],
        strip_prefix = "tokio-uds-0.1.7",
        build_file = Label("//3rdparty/crates:BUILD.tokio-uds-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__tokio-uds-0.2.7",
        sha256 = "ab57a4ac4111c8c9dbcf70779f6fc8bc35ae4b2454809febac840ad19bd7e4e0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-uds/0.2.7/download"],
        strip_prefix = "tokio-uds-0.2.7",
        build_file = Label("//3rdparty/crates:BUILD.tokio-uds-0.2.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__unix_socket-0.5.0",
        sha256 = "6aa2700417c405c38f5e6902d699345241c28c0b7ade4abaad71e35a87eb1564",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unix_socket/0.5.0/download"],
        strip_prefix = "unix_socket-0.5.0",
        build_file = Label("//3rdparty/crates:BUILD.unix_socket-0.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__void-1.0.2",
        sha256 = "6a02e4885ed3bc0f2de90ea6dd45ebcbb66dacffe03547fadbb0eeae2770887d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/void/1.0.2/download"],
        strip_prefix = "void-1.0.2",
        build_file = Label("//3rdparty/crates:BUILD.void-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__winapi-0.2.8",
        sha256 = "167dc9d6949a9b857f3451275e911c3f44255842c1f7a76f33c55103a909087a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi/0.2.8/download"],
        strip_prefix = "winapi-0.2.8",
        build_file = Label("//3rdparty/crates:BUILD.winapi-0.2.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("//3rdparty/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__winapi-build-0.1.1",
        sha256 = "2d315eee3b34aca4797b2da6b13ed88266e6d612562a0c46390af8299fc699bc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-build/0.1.1/download"],
        strip_prefix = "winapi-build-0.1.1",
        build_file = Label("//3rdparty/crates:BUILD.winapi-build-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("//3rdparty/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("//3rdparty/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_protobuf_deps__ws2_32-sys-0.2.1",
        sha256 = "d59cefebd0c892fa2dd6de581e937301d8552cb44489cdff035c6187cb63fa5e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ws2_32-sys/0.2.1/download"],
        strip_prefix = "ws2_32-sys-0.2.1",
        build_file = Label("//3rdparty/crates:BUILD.ws2_32-sys-0.2.1.bazel"),
    )

    return [
        struct(repo = "rules_rust_protobuf_deps__grpc-0.6.2", is_dev_dep = False),
        struct(repo = "rules_rust_protobuf_deps__grpc-compiler-0.6.2", is_dev_dep = False),
        struct(repo = "rules_rust_protobuf_deps__log-0.4.17", is_dev_dep = False),
        struct(repo = "rules_rust_protobuf_deps__protobuf-2.8.2", is_dev_dep = False),
        struct(repo = "rules_rust_protobuf_deps__protobuf-codegen-2.8.2", is_dev_dep = False),
        struct(repo = "rules_rust_protobuf_deps__tls-api-0.1.22", is_dev_dep = False),
        struct(repo = "rules_rust_protobuf_deps__tls-api-stub-0.1.22", is_dev_dep = False),
    ]
