###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//private/3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "mdbook": Label("@rmdbi//:mdbook-0.4.44"),
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"arm64ec\"), target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(any(target_os = \"linux\"), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "cfg(all(any(target_os = \"linux\", target_os = \"android\"), not(any(all(target_os = \"linux\", target_env = \"\"), getrandom_backend = \"custom\", getrandom_backend = \"linux_raw\", getrandom_backend = \"rdrand\", getrandom_backend = \"rndr\"))))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(rustix_use_libc), not(miri), target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"))))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(windows), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"aarch64\", target_os = \"linux\"))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "cfg(all(target_arch = \"aarch64\", target_vendor = \"apple\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "cfg(all(target_arch = \"loongarch64\", target_os = \"linux\"))": [],
    "cfg(all(target_arch = \"wasm32\", target_os = \"unknown\"))": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "cfg(all(target_arch = \"wasm32\", target_os = \"wasi\", target_env = \"p2\"))": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(target_os = \"uefi\", getrandom_backend = \"efi_rng\"))": [],
    "cfg(any())": [],
    "cfg(any(target_arch = \"aarch64\", target_arch = \"x86\", target_arch = \"x86_64\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(any(target_arch = \"aarch64\", target_arch = \"x86_64\", target_arch = \"x86\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(any(target_os = \"dragonfly\", target_os = \"freebsd\", target_os = \"hurd\", target_os = \"illumos\", target_os = \"cygwin\", all(target_os = \"horizon\", target_arch = \"arm\")))": ["@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(target_os = \"freebsd\", target_os = \"openbsd\", target_os = \"netbsd\", target_os = \"dragonflybsd\", target_os = \"ios\"))": ["@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(target_os = \"haiku\", target_os = \"redox\", target_os = \"nto\", target_os = \"aix\"))": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "cfg(any(target_os = \"ios\", target_os = \"visionos\", target_os = \"watchos\", target_os = \"tvos\"))": ["@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(any(target_os = \"linux\", target_os = \"android\"))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(any(target_os = \"macos\", target_os = \"openbsd\", target_os = \"vita\", target_os = \"emscripten\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin"],
    "cfg(any(unix, target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(not(target_has_atomic = \"ptr\"))": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "cfg(target_os = \"android\")": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:x86_64-linux-android"],
    "cfg(target_os = \"haiku\")": [],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"linux\")": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(target_os = \"macos\")": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-darwin"],
    "cfg(target_os = \"netbsd\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"solaris\")": [],
    "cfg(target_os = \"vxworks\")": [],
    "cfg(target_os = \"wasi\")": ["@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(target_os = \"windows\")": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(target_vendor = \"apple\")": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(windows_raw_dylib)": [],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnullvm": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "rmdbi__aho-corasick-1.1.4",
        sha256 = "ddd31a130427c27518df266943a5308ed92d4b226cc639f5a8f1002816174301",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/aho-corasick/1.1.4/download"],
        strip_prefix = "aho-corasick-1.1.4",
        build_file = Label("//private/3rdparty/crates:BUILD.aho-corasick-1.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__ammonia-4.1.2",
        sha256 = "17e913097e1a2124b46746c980134e8c954bc17a6a59bb3fde96f088d126dde6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ammonia/4.1.2/download"],
        strip_prefix = "ammonia-4.1.2",
        build_file = Label("//private/3rdparty/crates:BUILD.ammonia-4.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__android_system_properties-0.1.5",
        sha256 = "819e7219dbd41043ac279b19830f2efc897156490d7fd6ea916720117ee66311",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/android_system_properties/0.1.5/download"],
        strip_prefix = "android_system_properties-0.1.5",
        build_file = Label("//private/3rdparty/crates:BUILD.android_system_properties-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__anstream-0.6.21",
        sha256 = "43d5b281e737544384e969a5ccad3f1cdd24b48086a0fc1b2a5262a26b8f4f4a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstream/0.6.21/download"],
        strip_prefix = "anstream-0.6.21",
        build_file = Label("//private/3rdparty/crates:BUILD.anstream-0.6.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__anstyle-1.0.13",
        sha256 = "5192cca8006f1fd4f7237516f40fa183bb07f8fbdfedaa0036de5ea9b0b45e78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle/1.0.13/download"],
        strip_prefix = "anstyle-1.0.13",
        build_file = Label("//private/3rdparty/crates:BUILD.anstyle-1.0.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__anstyle-parse-0.2.7",
        sha256 = "4e7644824f0aa2c7b9384579234ef10eb7efb6a0deb83f9630a49594dd9c15c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-parse/0.2.7/download"],
        strip_prefix = "anstyle-parse-0.2.7",
        build_file = Label("//private/3rdparty/crates:BUILD.anstyle-parse-0.2.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__anstyle-query-1.1.5",
        sha256 = "40c48f72fd53cd289104fc64099abca73db4166ad86ea0b4341abe65af83dadc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-query/1.1.5/download"],
        strip_prefix = "anstyle-query-1.1.5",
        build_file = Label("//private/3rdparty/crates:BUILD.anstyle-query-1.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__anstyle-wincon-3.0.11",
        sha256 = "291e6a250ff86cd4a820112fb8898808a366d8f9f58ce16d1f538353ad55747d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-wincon/3.0.11/download"],
        strip_prefix = "anstyle-wincon-3.0.11",
        build_file = Label("//private/3rdparty/crates:BUILD.anstyle-wincon-3.0.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__anyhow-1.0.100",
        sha256 = "a23eb6b1614318a8071c9b2521f36b424b2c83db5eb3a0fead4a6c0809af6e61",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anyhow/1.0.100/download"],
        strip_prefix = "anyhow-1.0.100",
        build_file = Label("//private/3rdparty/crates:BUILD.anyhow-1.0.100.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__autocfg-1.5.0",
        sha256 = "c08606f8c3cbf4ce6ec8e28fb0014a2c086708fe954eaa885384a6165172e7e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/autocfg/1.5.0/download"],
        strip_prefix = "autocfg-1.5.0",
        build_file = Label("//private/3rdparty/crates:BUILD.autocfg-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__base64-0.21.7",
        sha256 = "9d297deb1925b89f2ccc13d7635fa0714f12c87adce1c75356b39ca9b7178567",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/base64/0.21.7/download"],
        strip_prefix = "base64-0.21.7",
        build_file = Label("//private/3rdparty/crates:BUILD.base64-0.21.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("//private/3rdparty/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__bitflags-2.10.0",
        sha256 = "812e12b5285cc515a9c72a5c1d3b6d46a19dac5acfef5265968c166106e31dd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/2.10.0/download"],
        strip_prefix = "bitflags-2.10.0",
        build_file = Label("//private/3rdparty/crates:BUILD.bitflags-2.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__block-buffer-0.10.4",
        sha256 = "3078c7629b62d3f0439517fa394996acacc5cbc91c5a20d8c658e77abd503a71",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/block-buffer/0.10.4/download"],
        strip_prefix = "block-buffer-0.10.4",
        build_file = Label("//private/3rdparty/crates:BUILD.block-buffer-0.10.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__bstr-1.12.1",
        sha256 = "63044e1ae8e69f3b5a92c736ca6269b8d12fa7efe39bf34ddb06d102cf0e2cab",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bstr/1.12.1/download"],
        strip_prefix = "bstr-1.12.1",
        build_file = Label("//private/3rdparty/crates:BUILD.bstr-1.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__bumpalo-3.19.0",
        sha256 = "46c5e41b57b8bba42a04676d81cb89e9ee8e859a1a66f80a5a72e1cb76b34d43",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bumpalo/3.19.0/download"],
        strip_prefix = "bumpalo-3.19.0",
        build_file = Label("//private/3rdparty/crates:BUILD.bumpalo-3.19.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__byteorder-1.5.0",
        sha256 = "1fd0f2584146f6f2ef48085050886acf353beff7305ebd1ae69500e27c67f64b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/byteorder/1.5.0/download"],
        strip_prefix = "byteorder-1.5.0",
        build_file = Label("//private/3rdparty/crates:BUILD.byteorder-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__bytes-1.11.0",
        sha256 = "b35204fbdc0b3f4446b89fc1ac2cf84a8a68971995d0bf2e925ec7cd960f9cb3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bytes/1.11.0/download"],
        strip_prefix = "bytes-1.11.0",
        build_file = Label("//private/3rdparty/crates:BUILD.bytes-1.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__cc-1.2.46",
        sha256 = "b97463e1064cb1b1c1384ad0a0b9c8abd0988e2a91f52606c80ef14aadb63e36",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cc/1.2.46/download"],
        strip_prefix = "cc-1.2.46",
        build_file = Label("//private/3rdparty/crates:BUILD.cc-1.2.46.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__cfg-if-1.0.4",
        sha256 = "9330f8b2ff13f34540b44e946ef35111825727b38d33286ef986142615121801",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.4/download"],
        strip_prefix = "cfg-if-1.0.4",
        build_file = Label("//private/3rdparty/crates:BUILD.cfg-if-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__chrono-0.4.42",
        sha256 = "145052bdd345b87320e369255277e3fb5152762ad123a901ef5c262dd38fe8d2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/chrono/0.4.42/download"],
        strip_prefix = "chrono-0.4.42",
        build_file = Label("//private/3rdparty/crates:BUILD.chrono-0.4.42.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__clap-4.5.52",
        sha256 = "aa8120877db0e5c011242f96806ce3c94e0737ab8108532a76a3300a01db2ab8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap/4.5.52/download"],
        strip_prefix = "clap-4.5.52",
        build_file = Label("//private/3rdparty/crates:BUILD.clap-4.5.52.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__clap_builder-4.5.52",
        sha256 = "02576b399397b659c26064fbc92a75fede9d18ffd5f80ca1cd74ddab167016e1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_builder/4.5.52/download"],
        strip_prefix = "clap_builder-4.5.52",
        build_file = Label("//private/3rdparty/crates:BUILD.clap_builder-4.5.52.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__clap_complete-4.5.60",
        sha256 = "8e602857739c5a4291dfa33b5a298aeac9006185229a700e5810a3ef7272d971",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_complete/4.5.60/download"],
        strip_prefix = "clap_complete-4.5.60",
        build_file = Label("//private/3rdparty/crates:BUILD.clap_complete-4.5.60.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__clap_lex-0.7.6",
        sha256 = "a1d728cc89cf3aee9ff92b05e62b19ee65a02b5702cff7d5a377e32c6ae29d8d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_lex/0.7.6/download"],
        strip_prefix = "clap_lex-0.7.6",
        build_file = Label("//private/3rdparty/crates:BUILD.clap_lex-0.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__colorchoice-1.0.4",
        sha256 = "b05b61dc5112cbb17e4b6cd61790d9845d13888356391624cbe7e41efeac1e75",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/colorchoice/1.0.4/download"],
        strip_prefix = "colorchoice-1.0.4",
        build_file = Label("//private/3rdparty/crates:BUILD.colorchoice-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__core-foundation-sys-0.8.7",
        sha256 = "773648b94d0e5d620f64f280777445740e61fe701025087ec8b57f45c791888b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/core-foundation-sys/0.8.7/download"],
        strip_prefix = "core-foundation-sys-0.8.7",
        build_file = Label("//private/3rdparty/crates:BUILD.core-foundation-sys-0.8.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__cpufeatures-0.2.17",
        sha256 = "59ed5838eebb26a2bb2e58f6d5b5316989ae9d08bab10e0e6d103e656d1b0280",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cpufeatures/0.2.17/download"],
        strip_prefix = "cpufeatures-0.2.17",
        build_file = Label("//private/3rdparty/crates:BUILD.cpufeatures-0.2.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__crossbeam-deque-0.8.6",
        sha256 = "9dd111b7b7f7d55b72c0a6ae361660ee5853c9af73f70c3c2ef6858b950e2e51",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-deque/0.8.6/download"],
        strip_prefix = "crossbeam-deque-0.8.6",
        build_file = Label("//private/3rdparty/crates:BUILD.crossbeam-deque-0.8.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__crossbeam-epoch-0.9.18",
        sha256 = "5b82ac4a3c2ca9c3460964f020e1402edd5753411d7737aa39c3714ad1b5420e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-epoch/0.9.18/download"],
        strip_prefix = "crossbeam-epoch-0.9.18",
        build_file = Label("//private/3rdparty/crates:BUILD.crossbeam-epoch-0.9.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__crossbeam-utils-0.8.21",
        sha256 = "d0a5c400df2834b80a4c3327b3aad3a4c4cd4de0629063962b03235697506a28",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-utils/0.8.21/download"],
        strip_prefix = "crossbeam-utils-0.8.21",
        build_file = Label("//private/3rdparty/crates:BUILD.crossbeam-utils-0.8.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__crypto-common-0.1.7",
        sha256 = "78c8292055d1c1df0cce5d180393dc8cce0abec0a7102adb6c7b1eef6016d60a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crypto-common/0.1.7/download"],
        strip_prefix = "crypto-common-0.1.7",
        build_file = Label("//private/3rdparty/crates:BUILD.crypto-common-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__cssparser-0.35.0",
        sha256 = "4e901edd733a1472f944a45116df3f846f54d37e67e68640ac8bb69689aca2aa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cssparser/0.35.0/download"],
        strip_prefix = "cssparser-0.35.0",
        build_file = Label("//private/3rdparty/crates:BUILD.cssparser-0.35.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__cssparser-macros-0.6.1",
        sha256 = "13b588ba4ac1a99f7f2964d24b3d896ddc6bf847ee3855dbd4366f058cfcd331",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cssparser-macros/0.6.1/download"],
        strip_prefix = "cssparser-macros-0.6.1",
        build_file = Label("//private/3rdparty/crates:BUILD.cssparser-macros-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__darling-0.20.11",
        sha256 = "fc7f46116c46ff9ab3eb1597a45688b6715c6e628b5c133e288e709a29bcb4ee",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/darling/0.20.11/download"],
        strip_prefix = "darling-0.20.11",
        build_file = Label("//private/3rdparty/crates:BUILD.darling-0.20.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__darling_core-0.20.11",
        sha256 = "0d00b9596d185e565c2207a0b01f8bd1a135483d02d9b7b0a54b11da8d53412e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/darling_core/0.20.11/download"],
        strip_prefix = "darling_core-0.20.11",
        build_file = Label("//private/3rdparty/crates:BUILD.darling_core-0.20.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__darling_macro-0.20.11",
        sha256 = "fc34b93ccb385b40dc71c6fceac4b2ad23662c7eeb248cf10d529b7e055b6ead",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/darling_macro/0.20.11/download"],
        strip_prefix = "darling_macro-0.20.11",
        build_file = Label("//private/3rdparty/crates:BUILD.darling_macro-0.20.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__data-encoding-2.9.0",
        sha256 = "2a2330da5de22e8a3cb63252ce2abb30116bf5265e89c0e01bc17015ce30a476",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/data-encoding/2.9.0/download"],
        strip_prefix = "data-encoding-2.9.0",
        build_file = Label("//private/3rdparty/crates:BUILD.data-encoding-2.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__dbus-0.9.9",
        sha256 = "190b6255e8ab55a7b568df5a883e9497edc3e4821c06396612048b430e5ad1e9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/dbus/0.9.9/download"],
        strip_prefix = "dbus-0.9.9",
        build_file = Label("//private/3rdparty/crates:BUILD.dbus-0.9.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__derive_builder-0.20.2",
        sha256 = "507dfb09ea8b7fa618fcf76e953f4f5e192547945816d5358edffe39f6f94947",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/derive_builder/0.20.2/download"],
        strip_prefix = "derive_builder-0.20.2",
        build_file = Label("//private/3rdparty/crates:BUILD.derive_builder-0.20.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__derive_builder_core-0.20.2",
        sha256 = "2d5bcf7b024d6835cfb3d473887cd966994907effbe9227e8c8219824d06c4e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/derive_builder_core/0.20.2/download"],
        strip_prefix = "derive_builder_core-0.20.2",
        build_file = Label("//private/3rdparty/crates:BUILD.derive_builder_core-0.20.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__derive_builder_macro-0.20.2",
        sha256 = "ab63b0e2bf4d5928aff72e83a7dace85d7bba5fe12dcc3c5a572d78caffd3f3c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/derive_builder_macro/0.20.2/download"],
        strip_prefix = "derive_builder_macro-0.20.2",
        build_file = Label("//private/3rdparty/crates:BUILD.derive_builder_macro-0.20.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__digest-0.10.7",
        sha256 = "9ed9a281f7bc9b7576e61468ba615a66a5c8cfdff42420a70aa82701a3b1e292",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/digest/0.10.7/download"],
        strip_prefix = "digest-0.10.7",
        build_file = Label("//private/3rdparty/crates:BUILD.digest-0.10.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__displaydoc-0.2.5",
        sha256 = "97369cbbc041bc366949bc74d34658d6cda5621039731c6310521892a3a20ae0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/displaydoc/0.2.5/download"],
        strip_prefix = "displaydoc-0.2.5",
        build_file = Label("//private/3rdparty/crates:BUILD.displaydoc-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__dtoa-1.0.10",
        sha256 = "d6add3b8cff394282be81f3fc1a0605db594ed69890078ca6e2cab1c408bcf04",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/dtoa/1.0.10/download"],
        strip_prefix = "dtoa-1.0.10",
        build_file = Label("//private/3rdparty/crates:BUILD.dtoa-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__dtoa-short-0.3.5",
        sha256 = "cd1511a7b6a56299bd043a9c167a6d2bfb37bf84a6dfceaba651168adfb43c87",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/dtoa-short/0.3.5/download"],
        strip_prefix = "dtoa-short-0.3.5",
        build_file = Label("//private/3rdparty/crates:BUILD.dtoa-short-0.3.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__elasticlunr-rs-3.0.2",
        sha256 = "41e83863a500656dfa214fee6682de9c5b9f03de6860fec531235ed2ae9f6571",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/elasticlunr-rs/3.0.2/download"],
        strip_prefix = "elasticlunr-rs-3.0.2",
        build_file = Label("//private/3rdparty/crates:BUILD.elasticlunr-rs-3.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__env_filter-0.1.4",
        sha256 = "1bf3c259d255ca70051b30e2e95b5446cdb8949ac4cd22c0d7fd634d89f568e2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/env_filter/0.1.4/download"],
        strip_prefix = "env_filter-0.1.4",
        build_file = Label("//private/3rdparty/crates:BUILD.env_filter-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__env_logger-0.11.8",
        sha256 = "13c863f0904021b108aa8b2f55046443e6b1ebde8fd4a15c399893aae4fa069f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/env_logger/0.11.8/download"],
        strip_prefix = "env_logger-0.11.8",
        build_file = Label("//private/3rdparty/crates:BUILD.env_logger-0.11.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__equivalent-1.0.2",
        sha256 = "877a4ace8713b0bcf2a4e7eec82529c029f1d0619886d18145fea96c3ffe5c0f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/equivalent/1.0.2/download"],
        strip_prefix = "equivalent-1.0.2",
        build_file = Label("//private/3rdparty/crates:BUILD.equivalent-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__errno-0.3.14",
        sha256 = "39cab71617ae0d63f51a36d69f866391735b51691dbda63cf6f96d042b63efeb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/errno/0.3.14/download"],
        strip_prefix = "errno-0.3.14",
        build_file = Label("//private/3rdparty/crates:BUILD.errno-0.3.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__fastrand-2.3.0",
        sha256 = "37909eebbb50d72f9059c3b6d82c0463f2ff062c9e95845c43a6c9c0355411be",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fastrand/2.3.0/download"],
        strip_prefix = "fastrand-2.3.0",
        build_file = Label("//private/3rdparty/crates:BUILD.fastrand-2.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__find-msvc-tools-0.1.5",
        sha256 = "3a3076410a55c90011c298b04d0cfa770b00fa04e1e3c97d3f6c9de105a03844",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/find-msvc-tools/0.1.5/download"],
        strip_prefix = "find-msvc-tools-0.1.5",
        build_file = Label("//private/3rdparty/crates:BUILD.find-msvc-tools-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__fnv-1.0.7",
        sha256 = "3f9eec918d3f24069decb9af1554cad7c880e2da24a9afd88aca000531ab82c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fnv/1.0.7/download"],
        strip_prefix = "fnv-1.0.7",
        build_file = Label("//private/3rdparty/crates:BUILD.fnv-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__form_urlencoded-1.2.2",
        sha256 = "cb4cb245038516f5f85277875cdaa4f7d2c9a0fa0468de06ed190163b1581fcf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/form_urlencoded/1.2.2/download"],
        strip_prefix = "form_urlencoded-1.2.2",
        build_file = Label("//private/3rdparty/crates:BUILD.form_urlencoded-1.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__fsevent-sys-4.1.0",
        sha256 = "76ee7a02da4d231650c7cea31349b889be2f45ddb3ef3032d2ec8185f6313fd2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fsevent-sys/4.1.0/download"],
        strip_prefix = "fsevent-sys-4.1.0",
        build_file = Label("//private/3rdparty/crates:BUILD.fsevent-sys-4.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__futf-0.1.5",
        sha256 = "df420e2e84819663797d1ec6544b13c5be84629e7bb00dc960d6917db2987843",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futf/0.1.5/download"],
        strip_prefix = "futf-0.1.5",
        build_file = Label("//private/3rdparty/crates:BUILD.futf-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__futures-channel-0.3.31",
        sha256 = "2dff15bf788c671c1934e366d07e30c1814a8ef514e1af724a602e8a2fbe1b10",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-channel/0.3.31/download"],
        strip_prefix = "futures-channel-0.3.31",
        build_file = Label("//private/3rdparty/crates:BUILD.futures-channel-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__futures-core-0.3.31",
        sha256 = "05f29059c0c2090612e8d742178b0580d2dc940c837851ad723096f87af6663e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-core/0.3.31/download"],
        strip_prefix = "futures-core-0.3.31",
        build_file = Label("//private/3rdparty/crates:BUILD.futures-core-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__futures-macro-0.3.31",
        sha256 = "162ee34ebcb7c64a8abebc059ce0fee27c2262618d7b60ed8faf72fef13c3650",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-macro/0.3.31/download"],
        strip_prefix = "futures-macro-0.3.31",
        build_file = Label("//private/3rdparty/crates:BUILD.futures-macro-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__futures-sink-0.3.31",
        sha256 = "e575fab7d1e0dcb8d0c7bcf9a63ee213816ab51902e6d244a95819acacf1d4f7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-sink/0.3.31/download"],
        strip_prefix = "futures-sink-0.3.31",
        build_file = Label("//private/3rdparty/crates:BUILD.futures-sink-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__futures-task-0.3.31",
        sha256 = "f90f7dce0722e95104fcb095585910c0977252f286e354b5e3bd38902cd99988",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-task/0.3.31/download"],
        strip_prefix = "futures-task-0.3.31",
        build_file = Label("//private/3rdparty/crates:BUILD.futures-task-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__futures-util-0.3.31",
        sha256 = "9fa08315bb612088cc391249efdc3bc77536f16c91f6cf495e6fbe85b20a4a81",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-util/0.3.31/download"],
        strip_prefix = "futures-util-0.3.31",
        build_file = Label("//private/3rdparty/crates:BUILD.futures-util-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__generic-array-0.14.7",
        sha256 = "85649ca51fd72272d7821adaf274ad91c288277713d9c18820d8499a7ff69e9a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/generic-array/0.14.7/download"],
        strip_prefix = "generic-array-0.14.7",
        build_file = Label("//private/3rdparty/crates:BUILD.generic-array-0.14.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__getrandom-0.2.16",
        sha256 = "335ff9f135e4384c8150d6f27c6daed433577f86b4750418338c01a1a2528592",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/getrandom/0.2.16/download"],
        strip_prefix = "getrandom-0.2.16",
        build_file = Label("//private/3rdparty/crates:BUILD.getrandom-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__getrandom-0.3.4",
        sha256 = "899def5c37c4fd7b2664648c28120ecec138e4d395b459e5ca34f9cce2dd77fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/getrandom/0.3.4/download"],
        strip_prefix = "getrandom-0.3.4",
        build_file = Label("//private/3rdparty/crates:BUILD.getrandom-0.3.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__globset-0.4.18",
        sha256 = "52dfc19153a48bde0cbd630453615c8151bce3a5adfac7a0aebfbf0a1e1f57e3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/globset/0.4.18/download"],
        strip_prefix = "globset-0.4.18",
        build_file = Label("//private/3rdparty/crates:BUILD.globset-0.4.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__h2-0.3.27",
        sha256 = "0beca50380b1fc32983fc1cb4587bfa4bb9e78fc259aad4a0032d2080309222d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/h2/0.3.27/download"],
        strip_prefix = "h2-0.3.27",
        build_file = Label("//private/3rdparty/crates:BUILD.h2-0.3.27.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__handlebars-6.3.2",
        sha256 = "759e2d5aea3287cb1190c8ec394f42866cb5bf74fcbf213f354e3c856ea26098",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/handlebars/6.3.2/download"],
        strip_prefix = "handlebars-6.3.2",
        build_file = Label("//private/3rdparty/crates:BUILD.handlebars-6.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__hashbrown-0.16.0",
        sha256 = "5419bdc4f6a9207fbeba6d11b604d481addf78ecd10c11ad51e76c2f6482748d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.16.0/download"],
        strip_prefix = "hashbrown-0.16.0",
        build_file = Label("//private/3rdparty/crates:BUILD.hashbrown-0.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__headers-0.3.9",
        sha256 = "06683b93020a07e3dbcf5f8c0f6d40080d725bea7936fc01ad345c01b97dc270",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/headers/0.3.9/download"],
        strip_prefix = "headers-0.3.9",
        build_file = Label("//private/3rdparty/crates:BUILD.headers-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__headers-core-0.2.0",
        sha256 = "e7f66481bfee273957b1f20485a4ff3362987f85b2c236580d81b4eb7a326429",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/headers-core/0.2.0/download"],
        strip_prefix = "headers-core-0.2.0",
        build_file = Label("//private/3rdparty/crates:BUILD.headers-core-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__html5ever-0.35.0",
        sha256 = "55d958c2f74b664487a2035fe1dadb032c48718a03b63f3ab0b8537db8549ed4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/html5ever/0.35.0/download"],
        strip_prefix = "html5ever-0.35.0",
        build_file = Label("//private/3rdparty/crates:BUILD.html5ever-0.35.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__http-0.2.12",
        sha256 = "601cbb57e577e2f5ef5be8e7b83f0f63994f25aa94d673e54a92d5c516d101f1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/http/0.2.12/download"],
        strip_prefix = "http-0.2.12",
        build_file = Label("//private/3rdparty/crates:BUILD.http-0.2.12.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__http-1.3.1",
        sha256 = "f4a85d31aea989eead29a3aaf9e1115a180df8282431156e533de47660892565",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/http/1.3.1/download"],
        strip_prefix = "http-1.3.1",
        build_file = Label("//private/3rdparty/crates:BUILD.http-1.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__http-body-0.4.6",
        sha256 = "7ceab25649e9960c0311ea418d17bee82c0dcec1bd053b5f9a66e265a693bed2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/http-body/0.4.6/download"],
        strip_prefix = "http-body-0.4.6",
        build_file = Label("//private/3rdparty/crates:BUILD.http-body-0.4.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__httparse-1.10.1",
        sha256 = "6dbf3de79e51f3d586ab4cb9d5c3e2c14aa28ed23d180cf89b4df0454a69cc87",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/httparse/1.10.1/download"],
        strip_prefix = "httparse-1.10.1",
        build_file = Label("//private/3rdparty/crates:BUILD.httparse-1.10.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__httpdate-1.0.3",
        sha256 = "df3b46402a9d5adb4c86a0cf463f42e19994e3ee891101b1841f30a545cb49a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/httpdate/1.0.3/download"],
        strip_prefix = "httpdate-1.0.3",
        build_file = Label("//private/3rdparty/crates:BUILD.httpdate-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__hyper-0.14.32",
        sha256 = "41dfc780fdec9373c01bae43289ea34c972e40ee3c9f6b3c8801a35f35586ce7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hyper/0.14.32/download"],
        strip_prefix = "hyper-0.14.32",
        build_file = Label("//private/3rdparty/crates:BUILD.hyper-0.14.32.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__iana-time-zone-0.1.64",
        sha256 = "33e57f83510bb73707521ebaffa789ec8caf86f9657cad665b092b581d40e9fb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/iana-time-zone/0.1.64/download"],
        strip_prefix = "iana-time-zone-0.1.64",
        build_file = Label("//private/3rdparty/crates:BUILD.iana-time-zone-0.1.64.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__iana-time-zone-haiku-0.1.2",
        sha256 = "f31827a206f56af32e590ba56d5d2d085f558508192593743f16b2306495269f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/iana-time-zone-haiku/0.1.2/download"],
        strip_prefix = "iana-time-zone-haiku-0.1.2",
        build_file = Label("//private/3rdparty/crates:BUILD.iana-time-zone-haiku-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__icu_collections-2.1.1",
        sha256 = "4c6b649701667bbe825c3b7e6388cb521c23d88644678e83c0c4d0a621a34b43",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_collections/2.1.1/download"],
        strip_prefix = "icu_collections-2.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.icu_collections-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__icu_locale_core-2.1.1",
        sha256 = "edba7861004dd3714265b4db54a3c390e880ab658fec5f7db895fae2046b5bb6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locale_core/2.1.1/download"],
        strip_prefix = "icu_locale_core-2.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.icu_locale_core-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__icu_normalizer-2.1.1",
        sha256 = "5f6c8828b67bf8908d82127b2054ea1b4427ff0230ee9141c54251934ab1b599",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer/2.1.1/download"],
        strip_prefix = "icu_normalizer-2.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.icu_normalizer-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__icu_normalizer_data-2.1.1",
        sha256 = "7aedcccd01fc5fe81e6b489c15b247b8b0690feb23304303a9e560f37efc560a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer_data/2.1.1/download"],
        strip_prefix = "icu_normalizer_data-2.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.icu_normalizer_data-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__icu_properties-2.1.1",
        sha256 = "e93fcd3157766c0c8da2f8cff6ce651a31f0810eaa1c51ec363ef790bbb5fb99",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties/2.1.1/download"],
        strip_prefix = "icu_properties-2.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.icu_properties-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__icu_properties_data-2.1.1",
        sha256 = "02845b3647bb045f1100ecd6480ff52f34c35f82d9880e029d329c21d1054899",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties_data/2.1.1/download"],
        strip_prefix = "icu_properties_data-2.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.icu_properties_data-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__icu_provider-2.1.1",
        sha256 = "85962cf0ce02e1e0a629cc34e7ca3e373ce20dda4c4d7294bbd0bf1fdb59e614",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_provider/2.1.1/download"],
        strip_prefix = "icu_provider-2.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.icu_provider-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__ident_case-1.0.1",
        sha256 = "b9e0384b61958566e926dc50660321d12159025e767c18e043daf26b70104c39",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ident_case/1.0.1/download"],
        strip_prefix = "ident_case-1.0.1",
        build_file = Label("//private/3rdparty/crates:BUILD.ident_case-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__idna-1.1.0",
        sha256 = "3b0875f23caa03898994f6ddc501886a45c7d3d62d04d2d90788d47be1b1e4de",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna/1.1.0/download"],
        strip_prefix = "idna-1.1.0",
        build_file = Label("//private/3rdparty/crates:BUILD.idna-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__idna_adapter-1.2.1",
        sha256 = "3acae9609540aa318d1bc588455225fb2085b9ed0c4f6bd0d9d5bcd86f1a0344",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna_adapter/1.2.1/download"],
        strip_prefix = "idna_adapter-1.2.1",
        build_file = Label("//private/3rdparty/crates:BUILD.idna_adapter-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__ignore-0.4.25",
        sha256 = "d3d782a365a015e0f5c04902246139249abf769125006fbe7649e2ee88169b4a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ignore/0.4.25/download"],
        strip_prefix = "ignore-0.4.25",
        build_file = Label("//private/3rdparty/crates:BUILD.ignore-0.4.25.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__indexmap-2.12.0",
        sha256 = "6717a8d2a5a929a1a2eb43a12812498ed141a0bcfb7e8f7844fbdbe4303bba9f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/2.12.0/download"],
        strip_prefix = "indexmap-2.12.0",
        build_file = Label("//private/3rdparty/crates:BUILD.indexmap-2.12.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__inotify-0.11.0",
        sha256 = "f37dccff2791ab604f9babef0ba14fbe0be30bd368dc541e2b08d07c8aa908f3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/inotify/0.11.0/download"],
        strip_prefix = "inotify-0.11.0",
        build_file = Label("//private/3rdparty/crates:BUILD.inotify-0.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__inotify-sys-0.1.5",
        sha256 = "e05c02b5e89bff3b946cedeca278abc628fe811e604f027c45a8aa3cf793d0eb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/inotify-sys/0.1.5/download"],
        strip_prefix = "inotify-sys-0.1.5",
        build_file = Label("//private/3rdparty/crates:BUILD.inotify-sys-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__is_terminal_polyfill-1.70.2",
        sha256 = "a6cb138bb79a146c1bd460005623e142ef0181e3d0219cb493e02f7d08a35695",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/is_terminal_polyfill/1.70.2/download"],
        strip_prefix = "is_terminal_polyfill-1.70.2",
        build_file = Label("//private/3rdparty/crates:BUILD.is_terminal_polyfill-1.70.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__itoa-1.0.15",
        sha256 = "4a5f13b858c8d314ee3e8f639011f7ccefe71f97f96e50151fb991f267928e2c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itoa/1.0.15/download"],
        strip_prefix = "itoa-1.0.15",
        build_file = Label("//private/3rdparty/crates:BUILD.itoa-1.0.15.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__jiff-0.2.16",
        sha256 = "49cce2b81f2098e7e3efc35bc2e0a6b7abec9d34128283d7a26fa8f32a6dbb35",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jiff/0.2.16/download"],
        strip_prefix = "jiff-0.2.16",
        build_file = Label("//private/3rdparty/crates:BUILD.jiff-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__jiff-static-0.2.16",
        sha256 = "980af8b43c3ad5d8d349ace167ec8170839f753a42d233ba19e08afe1850fa69",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jiff-static/0.2.16/download"],
        strip_prefix = "jiff-static-0.2.16",
        build_file = Label("//private/3rdparty/crates:BUILD.jiff-static-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__js-sys-0.3.82",
        sha256 = "b011eec8cc36da2aab2d5cff675ec18454fad408585853910a202391cf9f8e65",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/js-sys/0.3.82/download"],
        strip_prefix = "js-sys-0.3.82",
        build_file = Label("//private/3rdparty/crates:BUILD.js-sys-0.3.82.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__kqueue-1.1.1",
        sha256 = "eac30106d7dce88daf4a3fcb4879ea939476d5074a9b7ddd0fb97fa4bed5596a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/kqueue/1.1.1/download"],
        strip_prefix = "kqueue-1.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.kqueue-1.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__kqueue-sys-1.0.4",
        sha256 = "ed9625ffda8729b85e45cf04090035ac368927b8cebc34898e7c120f52e4838b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/kqueue-sys/1.0.4/download"],
        strip_prefix = "kqueue-sys-1.0.4",
        build_file = Label("//private/3rdparty/crates:BUILD.kqueue-sys-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__libc-0.2.177",
        sha256 = "2874a2af47a2325c2001a6e6fad9b16a53b802102b528163885171cf92b15976",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.177/download"],
        strip_prefix = "libc-0.2.177",
        build_file = Label("//private/3rdparty/crates:BUILD.libc-0.2.177.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__libdbus-sys-0.2.6",
        sha256 = "5cbe856efeb50e4681f010e9aaa2bf0a644e10139e54cde10fc83a307c23bd9f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libdbus-sys/0.2.6/download"],
        strip_prefix = "libdbus-sys-0.2.6",
        build_file = Label("//private/3rdparty/crates:BUILD.libdbus-sys-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__linux-raw-sys-0.11.0",
        sha256 = "df1d3c3b53da64cf5760482273a98e575c651a67eec7f77df96b5b642de8f039",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/linux-raw-sys/0.11.0/download"],
        strip_prefix = "linux-raw-sys-0.11.0",
        build_file = Label("//private/3rdparty/crates:BUILD.linux-raw-sys-0.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__litemap-0.8.1",
        sha256 = "6373607a59f0be73a39b6fe456b8192fcc3585f602af20751600e974dd455e77",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/litemap/0.8.1/download"],
        strip_prefix = "litemap-0.8.1",
        build_file = Label("//private/3rdparty/crates:BUILD.litemap-0.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__lock_api-0.4.14",
        sha256 = "224399e74b87b5f3557511d98dff8b14089b3dadafcab6bb93eab67d3aace965",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lock_api/0.4.14/download"],
        strip_prefix = "lock_api-0.4.14",
        build_file = Label("//private/3rdparty/crates:BUILD.lock_api-0.4.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__log-0.4.28",
        sha256 = "34080505efa8e45a4b816c349525ebe327ceaa8559756f0356cba97ef3bf7432",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.28/download"],
        strip_prefix = "log-0.4.28",
        build_file = Label("//private/3rdparty/crates:BUILD.log-0.4.28.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__mac-0.1.1",
        sha256 = "c41e0c4fef86961ac6d6f8a82609f55f31b05e4fce149ac5710e439df7619ba4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mac/0.1.1/download"],
        strip_prefix = "mac-0.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.mac-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__maplit-1.0.2",
        sha256 = "3e2e65a1a2e43cfcb47a895c4c8b10d1f4a61097f9f254f183aee60cad9c651d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/maplit/1.0.2/download"],
        strip_prefix = "maplit-1.0.2",
        build_file = Label("//private/3rdparty/crates:BUILD.maplit-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__markup5ever-0.35.0",
        sha256 = "311fe69c934650f8f19652b3946075f0fc41ad8757dbb68f1ca14e7900ecc1c3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/markup5ever/0.35.0/download"],
        strip_prefix = "markup5ever-0.35.0",
        build_file = Label("//private/3rdparty/crates:BUILD.markup5ever-0.35.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__match_token-0.35.0",
        sha256 = "ac84fd3f360fcc43dc5f5d186f02a94192761a080e8bc58621ad4d12296a58cf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/match_token/0.35.0/download"],
        strip_prefix = "match_token-0.35.0",
        build_file = Label("//private/3rdparty/crates:BUILD.match_token-0.35.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__mdbook-0.4.44",
        sha256 = "f9da1e54401fe5d45a664c57e112e70f18e8c5a73e268c179305b932ee864574",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mdbook/0.4.44/download"],
        strip_prefix = "mdbook-0.4.44",
        build_file = Label("//private/3rdparty/crates:BUILD.mdbook-0.4.44.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__memchr-2.7.6",
        sha256 = "f52b00d39961fc5b2736ea853c9cc86238e165017a493d1d5c8eac6bdc4cc273",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.7.6/download"],
        strip_prefix = "memchr-2.7.6",
        build_file = Label("//private/3rdparty/crates:BUILD.memchr-2.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__mime-0.3.17",
        sha256 = "6877bb514081ee2a7ff5ef9de3281f14a4dd4bceac4c09388074a6b5df8a139a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mime/0.3.17/download"],
        strip_prefix = "mime-0.3.17",
        build_file = Label("//private/3rdparty/crates:BUILD.mime-0.3.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__mime_guess-2.0.5",
        sha256 = "f7c44f8e672c00fe5308fa235f821cb4198414e1c77935c1ab6948d3fd78550e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mime_guess/2.0.5/download"],
        strip_prefix = "mime_guess-2.0.5",
        build_file = Label("//private/3rdparty/crates:BUILD.mime_guess-2.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__mio-1.1.0",
        sha256 = "69d83b0086dc8ecf3ce9ae2874b2d1290252e2a30720bea58a5c6639b0092873",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mio/1.1.0/download"],
        strip_prefix = "mio-1.1.0",
        build_file = Label("//private/3rdparty/crates:BUILD.mio-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__new_debug_unreachable-1.0.6",
        sha256 = "650eef8c711430f1a879fdd01d4745a7deea475becfb90269c06775983bbf086",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/new_debug_unreachable/1.0.6/download"],
        strip_prefix = "new_debug_unreachable-1.0.6",
        build_file = Label("//private/3rdparty/crates:BUILD.new_debug_unreachable-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__normpath-1.5.0",
        sha256 = "bf23ab2b905654b4cb177e30b629937b3868311d4e1cba859f899c041046e69b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/normpath/1.5.0/download"],
        strip_prefix = "normpath-1.5.0",
        build_file = Label("//private/3rdparty/crates:BUILD.normpath-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__notify-8.2.0",
        sha256 = "4d3d07927151ff8575b7087f245456e549fea62edf0ec4e565a5ee50c8402bc3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/notify/8.2.0/download"],
        strip_prefix = "notify-8.2.0",
        build_file = Label("//private/3rdparty/crates:BUILD.notify-8.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__notify-debouncer-mini-0.6.0",
        sha256 = "a689eb4262184d9a1727f9087cd03883ea716682ab03ed24efec57d7716dccb8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/notify-debouncer-mini/0.6.0/download"],
        strip_prefix = "notify-debouncer-mini-0.6.0",
        build_file = Label("//private/3rdparty/crates:BUILD.notify-debouncer-mini-0.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__notify-types-2.0.0",
        sha256 = "5e0826a989adedc2a244799e823aece04662b66609d96af8dff7ac6df9a8925d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/notify-types/2.0.0/download"],
        strip_prefix = "notify-types-2.0.0",
        build_file = Label("//private/3rdparty/crates:BUILD.notify-types-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__num-modular-0.6.1",
        sha256 = "17bb261bf36fa7d83f4c294f834e91256769097b3cb505d44831e0a179ac647f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num-modular/0.6.1/download"],
        strip_prefix = "num-modular-0.6.1",
        build_file = Label("//private/3rdparty/crates:BUILD.num-modular-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__num-order-1.2.0",
        sha256 = "537b596b97c40fcf8056d153049eb22f481c17ebce72a513ec9286e4986d1bb6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num-order/1.2.0/download"],
        strip_prefix = "num-order-1.2.0",
        build_file = Label("//private/3rdparty/crates:BUILD.num-order-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__num-traits-0.2.19",
        sha256 = "071dfc062690e90b734c0b2273ce72ad0ffa95f0c74596bc250dcfd960262841",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num-traits/0.2.19/download"],
        strip_prefix = "num-traits-0.2.19",
        build_file = Label("//private/3rdparty/crates:BUILD.num-traits-0.2.19.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__once_cell-1.21.3",
        sha256 = "42f5e15c9953c5e4ccceeb2e7382a716482c34515315f7b03532b8b4e8393d2d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.21.3/download"],
        strip_prefix = "once_cell-1.21.3",
        build_file = Label("//private/3rdparty/crates:BUILD.once_cell-1.21.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__once_cell_polyfill-1.70.2",
        sha256 = "384b8ab6d37215f3c5301a95a4accb5d64aa607f1fcb26a11b5303878451b4fe",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell_polyfill/1.70.2/download"],
        strip_prefix = "once_cell_polyfill-1.70.2",
        build_file = Label("//private/3rdparty/crates:BUILD.once_cell_polyfill-1.70.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__opener-0.7.2",
        sha256 = "d0812e5e4df08da354c851a3376fead46db31c2214f849d3de356d774d057681",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/opener/0.7.2/download"],
        strip_prefix = "opener-0.7.2",
        build_file = Label("//private/3rdparty/crates:BUILD.opener-0.7.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__parking_lot-0.12.5",
        sha256 = "93857453250e3077bd71ff98b6a65ea6621a19bb0f559a85248955ac12c45a1a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot/0.12.5/download"],
        strip_prefix = "parking_lot-0.12.5",
        build_file = Label("//private/3rdparty/crates:BUILD.parking_lot-0.12.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__parking_lot_core-0.9.12",
        sha256 = "2621685985a2ebf1c516881c026032ac7deafcda1a2c9b7850dc81e3dfcb64c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot_core/0.9.12/download"],
        strip_prefix = "parking_lot_core-0.9.12",
        build_file = Label("//private/3rdparty/crates:BUILD.parking_lot_core-0.9.12.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pathdiff-0.2.3",
        sha256 = "df94ce210e5bc13cb6651479fa48d14f601d9858cfe0467f43ae157023b938d3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pathdiff/0.2.3/download"],
        strip_prefix = "pathdiff-0.2.3",
        build_file = Label("//private/3rdparty/crates:BUILD.pathdiff-0.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__percent-encoding-2.3.2",
        sha256 = "9b4f627cb1b25917193a259e49bdad08f671f8d9708acfd5fe0a8c1455d87220",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/percent-encoding/2.3.2/download"],
        strip_prefix = "percent-encoding-2.3.2",
        build_file = Label("//private/3rdparty/crates:BUILD.percent-encoding-2.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pest-2.8.3",
        sha256 = "989e7521a040efde50c3ab6bbadafbe15ab6dc042686926be59ac35d74607df4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pest/2.8.3/download"],
        strip_prefix = "pest-2.8.3",
        build_file = Label("//private/3rdparty/crates:BUILD.pest-2.8.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pest_derive-2.8.3",
        sha256 = "187da9a3030dbafabbbfb20cb323b976dc7b7ce91fcd84f2f74d6e31d378e2de",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pest_derive/2.8.3/download"],
        strip_prefix = "pest_derive-2.8.3",
        build_file = Label("//private/3rdparty/crates:BUILD.pest_derive-2.8.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pest_generator-2.8.3",
        sha256 = "49b401d98f5757ebe97a26085998d6c0eecec4995cad6ab7fc30ffdf4b052843",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pest_generator/2.8.3/download"],
        strip_prefix = "pest_generator-2.8.3",
        build_file = Label("//private/3rdparty/crates:BUILD.pest_generator-2.8.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pest_meta-2.8.3",
        sha256 = "72f27a2cfee9f9039c4d86faa5af122a0ac3851441a34865b8a043b46be0065a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pest_meta/2.8.3/download"],
        strip_prefix = "pest_meta-2.8.3",
        build_file = Label("//private/3rdparty/crates:BUILD.pest_meta-2.8.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__phf-0.11.3",
        sha256 = "1fd6780a80ae0c52cc120a26a1a42c1ae51b247a253e4e06113d23d2c2edd078",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/phf/0.11.3/download"],
        strip_prefix = "phf-0.11.3",
        build_file = Label("//private/3rdparty/crates:BUILD.phf-0.11.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__phf_codegen-0.11.3",
        sha256 = "aef8048c789fa5e851558d709946d6d79a8ff88c0440c587967f8e94bfb1216a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/phf_codegen/0.11.3/download"],
        strip_prefix = "phf_codegen-0.11.3",
        build_file = Label("//private/3rdparty/crates:BUILD.phf_codegen-0.11.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__phf_generator-0.11.3",
        sha256 = "3c80231409c20246a13fddb31776fb942c38553c51e871f8cbd687a4cfb5843d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/phf_generator/0.11.3/download"],
        strip_prefix = "phf_generator-0.11.3",
        build_file = Label("//private/3rdparty/crates:BUILD.phf_generator-0.11.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__phf_macros-0.11.3",
        sha256 = "f84ac04429c13a7ff43785d75ad27569f2951ce0ffd30a3321230db2fc727216",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/phf_macros/0.11.3/download"],
        strip_prefix = "phf_macros-0.11.3",
        build_file = Label("//private/3rdparty/crates:BUILD.phf_macros-0.11.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__phf_shared-0.11.3",
        sha256 = "67eabc2ef2a60eb7faa00097bd1ffdb5bd28e62bf39990626a582201b7a754e5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/phf_shared/0.11.3/download"],
        strip_prefix = "phf_shared-0.11.3",
        build_file = Label("//private/3rdparty/crates:BUILD.phf_shared-0.11.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pin-project-1.1.10",
        sha256 = "677f1add503faace112b9f1373e43e9e054bfdd22ff1a63c1bc485eaec6a6a8a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project/1.1.10/download"],
        strip_prefix = "pin-project-1.1.10",
        build_file = Label("//private/3rdparty/crates:BUILD.pin-project-1.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pin-project-internal-1.1.10",
        sha256 = "6e918e4ff8c4549eb882f14b3a4bc8c8bc93de829416eacf579f1207a8fbf861",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project-internal/1.1.10/download"],
        strip_prefix = "pin-project-internal-1.1.10",
        build_file = Label("//private/3rdparty/crates:BUILD.pin-project-internal-1.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pin-project-lite-0.2.16",
        sha256 = "3b3cff922bd51709b605d9ead9aa71031d81447142d828eb4a6eba76fe619f9b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project-lite/0.2.16/download"],
        strip_prefix = "pin-project-lite-0.2.16",
        build_file = Label("//private/3rdparty/crates:BUILD.pin-project-lite-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pin-utils-0.1.0",
        sha256 = "8b870d8c151b6f2fb93e84a13146138f05d02ed11c7e7c54f8826aaaf7c9f184",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-utils/0.1.0/download"],
        strip_prefix = "pin-utils-0.1.0",
        build_file = Label("//private/3rdparty/crates:BUILD.pin-utils-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pkg-config-0.3.32",
        sha256 = "7edddbd0b52d732b21ad9a5fab5c704c14cd949e5e9a1ec5929a24fded1b904c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pkg-config/0.3.32/download"],
        strip_prefix = "pkg-config-0.3.32",
        build_file = Label("//private/3rdparty/crates:BUILD.pkg-config-0.3.32.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__portable-atomic-1.11.1",
        sha256 = "f84267b20a16ea918e43c6a88433c2d54fa145c92a811b5b047ccbe153674483",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/portable-atomic/1.11.1/download"],
        strip_prefix = "portable-atomic-1.11.1",
        build_file = Label("//private/3rdparty/crates:BUILD.portable-atomic-1.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__portable-atomic-util-0.2.4",
        sha256 = "d8a2f0d8d040d7848a709caf78912debcc3f33ee4b3cac47d73d1e1069e83507",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/portable-atomic-util/0.2.4/download"],
        strip_prefix = "portable-atomic-util-0.2.4",
        build_file = Label("//private/3rdparty/crates:BUILD.portable-atomic-util-0.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__potential_utf-0.1.4",
        sha256 = "b73949432f5e2a09657003c25bca5e19a0e9c84f8058ca374f49e0ebe605af77",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/potential_utf/0.1.4/download"],
        strip_prefix = "potential_utf-0.1.4",
        build_file = Label("//private/3rdparty/crates:BUILD.potential_utf-0.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__ppv-lite86-0.2.21",
        sha256 = "85eae3c4ed2f50dcfe72643da4befc30deadb458a9b590d720cde2f2b1e97da9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ppv-lite86/0.2.21/download"],
        strip_prefix = "ppv-lite86-0.2.21",
        build_file = Label("//private/3rdparty/crates:BUILD.ppv-lite86-0.2.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__precomputed-hash-0.1.1",
        sha256 = "925383efa346730478fb4838dbe9137d2a47675ad789c546d150a6e1dd4ab31c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/precomputed-hash/0.1.1/download"],
        strip_prefix = "precomputed-hash-0.1.1",
        build_file = Label("//private/3rdparty/crates:BUILD.precomputed-hash-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__proc-macro2-1.0.103",
        sha256 = "5ee95bc4ef87b8d5ba32e8b7714ccc834865276eab0aed5c9958d00ec45f49e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.103/download"],
        strip_prefix = "proc-macro2-1.0.103",
        build_file = Label("//private/3rdparty/crates:BUILD.proc-macro2-1.0.103.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pulldown-cmark-0.10.3",
        sha256 = "76979bea66e7875e7509c4ec5300112b316af87fa7a252ca91c448b32dfe3993",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pulldown-cmark/0.10.3/download"],
        strip_prefix = "pulldown-cmark-0.10.3",
        build_file = Label("//private/3rdparty/crates:BUILD.pulldown-cmark-0.10.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__pulldown-cmark-escape-0.10.1",
        sha256 = "bd348ff538bc9caeda7ee8cad2d1d48236a1f443c1fa3913c6a02fe0043b1dd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pulldown-cmark-escape/0.10.1/download"],
        strip_prefix = "pulldown-cmark-escape-0.10.1",
        build_file = Label("//private/3rdparty/crates:BUILD.pulldown-cmark-escape-0.10.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__quote-1.0.42",
        sha256 = "a338cc41d27e6cc6dce6cefc13a0729dfbb81c262b1f519331575dd80ef3067f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.42/download"],
        strip_prefix = "quote-1.0.42",
        build_file = Label("//private/3rdparty/crates:BUILD.quote-1.0.42.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__r-efi-5.3.0",
        sha256 = "69cdb34c158ceb288df11e18b4bd39de994f6657d83847bdffdbd7f346754b0f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/r-efi/5.3.0/download"],
        strip_prefix = "r-efi-5.3.0",
        build_file = Label("//private/3rdparty/crates:BUILD.r-efi-5.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__rand-0.8.5",
        sha256 = "34af8d1a0e25924bc5b7c43c079c942339d8f0a8b57c39049bef581b46327404",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand/0.8.5/download"],
        strip_prefix = "rand-0.8.5",
        build_file = Label("//private/3rdparty/crates:BUILD.rand-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__rand_chacha-0.3.1",
        sha256 = "e6c10a63a0fa32252be49d21e7709d4d4baf8d231c2dbce1eaa8141b9b127d88",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand_chacha/0.3.1/download"],
        strip_prefix = "rand_chacha-0.3.1",
        build_file = Label("//private/3rdparty/crates:BUILD.rand_chacha-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__rand_core-0.6.4",
        sha256 = "ec0be4795e2f6a28069bec0b5ff3e2ac9bafc99e6a9a7dc3547996c5c816922c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rand_core/0.6.4/download"],
        strip_prefix = "rand_core-0.6.4",
        build_file = Label("//private/3rdparty/crates:BUILD.rand_core-0.6.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__redox_syscall-0.5.18",
        sha256 = "ed2bf2547551a7053d6fdfafda3f938979645c44812fbfcda098faae3f1a362d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/redox_syscall/0.5.18/download"],
        strip_prefix = "redox_syscall-0.5.18",
        build_file = Label("//private/3rdparty/crates:BUILD.redox_syscall-0.5.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__regex-1.12.2",
        sha256 = "843bc0191f75f3e22651ae5f1e72939ab2f72a4bc30fa80a066bd66edefc24d4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex/1.12.2/download"],
        strip_prefix = "regex-1.12.2",
        build_file = Label("//private/3rdparty/crates:BUILD.regex-1.12.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__regex-automata-0.4.13",
        sha256 = "5276caf25ac86c8d810222b3dbb938e512c55c6831a10f3e6ed1c93b84041f1c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.4.13/download"],
        strip_prefix = "regex-automata-0.4.13",
        build_file = Label("//private/3rdparty/crates:BUILD.regex-automata-0.4.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__regex-syntax-0.8.8",
        sha256 = "7a2d987857b319362043e95f5353c0535c1f58eec5336fdfcf626430af7def58",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-syntax/0.8.8/download"],
        strip_prefix = "regex-syntax-0.8.8",
        build_file = Label("//private/3rdparty/crates:BUILD.regex-syntax-0.8.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__rustix-1.1.2",
        sha256 = "cd15f8a2c5551a84d56efdc1cd049089e409ac19a3072d5037a17fd70719ff3e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustix/1.1.2/download"],
        strip_prefix = "rustix-1.1.2",
        build_file = Label("//private/3rdparty/crates:BUILD.rustix-1.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__rustversion-1.0.22",
        sha256 = "b39cdef0fa800fc44525c84ccb54a029961a8215f9619753635a9c0d2538d46d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustversion/1.0.22/download"],
        strip_prefix = "rustversion-1.0.22",
        build_file = Label("//private/3rdparty/crates:BUILD.rustversion-1.0.22.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__ryu-1.0.20",
        sha256 = "28d3b2b1366ec20994f1fd18c3c594f05c5dd4bc44d8bb0c1c632c8d6829481f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ryu/1.0.20/download"],
        strip_prefix = "ryu-1.0.20",
        build_file = Label("//private/3rdparty/crates:BUILD.ryu-1.0.20.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__same-file-1.0.6",
        sha256 = "93fc1dc3aaa9bfed95e02e6eadabb4baf7e3078b0bd1b4d7b6b0b68378900502",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/same-file/1.0.6/download"],
        strip_prefix = "same-file-1.0.6",
        build_file = Label("//private/3rdparty/crates:BUILD.same-file-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__scoped-tls-1.0.1",
        sha256 = "e1cf6437eb19a8f4a6cc0f7dca544973b0b78843adbfeb3683d1a94a0024a294",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scoped-tls/1.0.1/download"],
        strip_prefix = "scoped-tls-1.0.1",
        build_file = Label("//private/3rdparty/crates:BUILD.scoped-tls-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__scopeguard-1.2.0",
        sha256 = "94143f37725109f92c262ed2cf5e59bce7498c01bcc1502d7b9afe439a4e9f49",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scopeguard/1.2.0/download"],
        strip_prefix = "scopeguard-1.2.0",
        build_file = Label("//private/3rdparty/crates:BUILD.scopeguard-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__serde-1.0.228",
        sha256 = "9a8e94ea7f378bd32cbbd37198a4a91436180c5bb472411e48b5ec2e2124ae9e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.228/download"],
        strip_prefix = "serde-1.0.228",
        build_file = Label("//private/3rdparty/crates:BUILD.serde-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__serde_core-1.0.228",
        sha256 = "41d385c7d4ca58e59fc732af25c3983b67ac852c1a25000afe1175de458b67ad",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_core/1.0.228/download"],
        strip_prefix = "serde_core-1.0.228",
        build_file = Label("//private/3rdparty/crates:BUILD.serde_core-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__serde_derive-1.0.228",
        sha256 = "d540f220d3187173da220f885ab66608367b6574e925011a9353e4badda91d79",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.228/download"],
        strip_prefix = "serde_derive-1.0.228",
        build_file = Label("//private/3rdparty/crates:BUILD.serde_derive-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__serde_json-1.0.145",
        sha256 = "402a6f66d8c709116cf22f558eab210f5a50187f702eb4d7e5ef38d9a7f1c79c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_json/1.0.145/download"],
        strip_prefix = "serde_json-1.0.145",
        build_file = Label("//private/3rdparty/crates:BUILD.serde_json-1.0.145.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__serde_urlencoded-0.7.1",
        sha256 = "d3491c14715ca2294c4d6a88f15e84739788c1d030eed8c110436aafdaa2f3fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_urlencoded/0.7.1/download"],
        strip_prefix = "serde_urlencoded-0.7.1",
        build_file = Label("//private/3rdparty/crates:BUILD.serde_urlencoded-0.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__sha1-0.10.6",
        sha256 = "e3bf829a2d51ab4a5ddf1352d8470c140cadc8301b2ae1789db023f01cedd6ba",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sha1/0.10.6/download"],
        strip_prefix = "sha1-0.10.6",
        build_file = Label("//private/3rdparty/crates:BUILD.sha1-0.10.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__sha2-0.10.9",
        sha256 = "a7507d819769d01a365ab707794a4084392c824f54a7a6a7862f8c3d0892b283",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sha2/0.10.9/download"],
        strip_prefix = "sha2-0.10.9",
        build_file = Label("//private/3rdparty/crates:BUILD.sha2-0.10.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__shlex-1.3.0",
        sha256 = "0fda2ff0d084019ba4d7c6f371c95d8fd75ce3524c3cb8fb653a3023f6323e64",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/shlex/1.3.0/download"],
        strip_prefix = "shlex-1.3.0",
        build_file = Label("//private/3rdparty/crates:BUILD.shlex-1.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__siphasher-1.0.1",
        sha256 = "56199f7ddabf13fe5074ce809e7d3f42b42ae711800501b5b16ea82ad029c39d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/siphasher/1.0.1/download"],
        strip_prefix = "siphasher-1.0.1",
        build_file = Label("//private/3rdparty/crates:BUILD.siphasher-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__slab-0.4.11",
        sha256 = "7a2ae44ef20feb57a68b23d846850f861394c2e02dc425a50098ae8c90267589",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/slab/0.4.11/download"],
        strip_prefix = "slab-0.4.11",
        build_file = Label("//private/3rdparty/crates:BUILD.slab-0.4.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__smallvec-1.15.1",
        sha256 = "67b1b7a3b5fe4f1376887184045fcf45c69e92af734b7aaddc05fb777b6fbd03",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/1.15.1/download"],
        strip_prefix = "smallvec-1.15.1",
        build_file = Label("//private/3rdparty/crates:BUILD.smallvec-1.15.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__socket2-0.5.10",
        sha256 = "e22376abed350d73dd1cd119b57ffccad95b4e585a7cda43e286245ce23c0678",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/socket2/0.5.10/download"],
        strip_prefix = "socket2-0.5.10",
        build_file = Label("//private/3rdparty/crates:BUILD.socket2-0.5.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__socket2-0.6.1",
        sha256 = "17129e116933cf371d018bb80ae557e889637989d8638274fb25622827b03881",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/socket2/0.6.1/download"],
        strip_prefix = "socket2-0.6.1",
        build_file = Label("//private/3rdparty/crates:BUILD.socket2-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__stable_deref_trait-1.2.1",
        sha256 = "6ce2be8dc25455e1f91df71bfa12ad37d7af1092ae736f3a6cd0e37bc7810596",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/stable_deref_trait/1.2.1/download"],
        strip_prefix = "stable_deref_trait-1.2.1",
        build_file = Label("//private/3rdparty/crates:BUILD.stable_deref_trait-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__string_cache-0.8.9",
        sha256 = "bf776ba3fa74f83bf4b63c3dcbbf82173db2632ed8452cb2d891d33f459de70f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/string_cache/0.8.9/download"],
        strip_prefix = "string_cache-0.8.9",
        build_file = Label("//private/3rdparty/crates:BUILD.string_cache-0.8.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__string_cache_codegen-0.5.4",
        sha256 = "c711928715f1fe0fe509c53b43e993a9a557babc2d0a3567d0a3006f1ac931a0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/string_cache_codegen/0.5.4/download"],
        strip_prefix = "string_cache_codegen-0.5.4",
        build_file = Label("//private/3rdparty/crates:BUILD.string_cache_codegen-0.5.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__strsim-0.11.1",
        sha256 = "7da8b5736845d9f2fcb837ea5d9e2628564b3b043a70948a3f0b778838c5fb4f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/strsim/0.11.1/download"],
        strip_prefix = "strsim-0.11.1",
        build_file = Label("//private/3rdparty/crates:BUILD.strsim-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__syn-2.0.110",
        sha256 = "a99801b5bd34ede4cf3fc688c5919368fea4e4814a4664359503e6015b280aea",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.110/download"],
        strip_prefix = "syn-2.0.110",
        build_file = Label("//private/3rdparty/crates:BUILD.syn-2.0.110.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__synstructure-0.13.2",
        sha256 = "728a70f3dbaf5bab7f0c4b1ac8d7ae5ea60a4b5549c8a5914361c99147a709d2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/synstructure/0.13.2/download"],
        strip_prefix = "synstructure-0.13.2",
        build_file = Label("//private/3rdparty/crates:BUILD.synstructure-0.13.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tempfile-3.23.0",
        sha256 = "2d31c77bdf42a745371d260a26ca7163f1e0924b64afa0b688e61b5a9fa02f16",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tempfile/3.23.0/download"],
        strip_prefix = "tempfile-3.23.0",
        build_file = Label("//private/3rdparty/crates:BUILD.tempfile-3.23.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tendril-0.4.3",
        sha256 = "d24a120c5fc464a3458240ee02c299ebcb9d67b5249c8848b09d639dca8d7bb0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tendril/0.4.3/download"],
        strip_prefix = "tendril-0.4.3",
        build_file = Label("//private/3rdparty/crates:BUILD.tendril-0.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__terminal_size-0.4.3",
        sha256 = "60b8cb979cb11c32ce1603f8137b22262a9d131aaa5c37b5678025f22b8becd0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/terminal_size/0.4.3/download"],
        strip_prefix = "terminal_size-0.4.3",
        build_file = Label("//private/3rdparty/crates:BUILD.terminal_size-0.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__thiserror-1.0.69",
        sha256 = "b6aaf5339b578ea85b50e080feb250a3e8ae8cfcdff9a461c9ec2904bc923f52",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror/1.0.69/download"],
        strip_prefix = "thiserror-1.0.69",
        build_file = Label("//private/3rdparty/crates:BUILD.thiserror-1.0.69.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__thiserror-2.0.17",
        sha256 = "f63587ca0f12b72a0600bcba1d40081f830876000bb46dd2337a3051618f4fc8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror/2.0.17/download"],
        strip_prefix = "thiserror-2.0.17",
        build_file = Label("//private/3rdparty/crates:BUILD.thiserror-2.0.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__thiserror-impl-1.0.69",
        sha256 = "4fee6c4efc90059e10f81e6d42c60a18f76588c3d74cb83a0b242a2b6c7504c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror-impl/1.0.69/download"],
        strip_prefix = "thiserror-impl-1.0.69",
        build_file = Label("//private/3rdparty/crates:BUILD.thiserror-impl-1.0.69.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__thiserror-impl-2.0.17",
        sha256 = "3ff15c8ecd7de3849db632e14d18d2571fa09dfc5ed93479bc4485c7a517c913",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror-impl/2.0.17/download"],
        strip_prefix = "thiserror-impl-2.0.17",
        build_file = Label("//private/3rdparty/crates:BUILD.thiserror-impl-2.0.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tinystr-0.8.2",
        sha256 = "42d3e9c45c09de15d06dd8acf5f4e0e399e85927b7f00711024eb7ae10fa4869",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tinystr/0.8.2/download"],
        strip_prefix = "tinystr-0.8.2",
        build_file = Label("//private/3rdparty/crates:BUILD.tinystr-0.8.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tokio-1.48.0",
        sha256 = "ff360e02eab121e0bc37a2d3b4d4dc622e6eda3a8e5253d5435ecf5bd4c68408",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio/1.48.0/download"],
        strip_prefix = "tokio-1.48.0",
        build_file = Label("//private/3rdparty/crates:BUILD.tokio-1.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tokio-macros-2.6.0",
        sha256 = "af407857209536a95c8e56f8231ef2c2e2aff839b22e07a1ffcbc617e9db9fa5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-macros/2.6.0/download"],
        strip_prefix = "tokio-macros-2.6.0",
        build_file = Label("//private/3rdparty/crates:BUILD.tokio-macros-2.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tokio-tungstenite-0.21.0",
        sha256 = "c83b561d025642014097b66e6c1bb422783339e0909e4429cde4749d1990bc38",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-tungstenite/0.21.0/download"],
        strip_prefix = "tokio-tungstenite-0.21.0",
        build_file = Label("//private/3rdparty/crates:BUILD.tokio-tungstenite-0.21.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tokio-util-0.7.17",
        sha256 = "2efa149fe76073d6e8fd97ef4f4eca7b67f599660115591483572e406e165594",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-util/0.7.17/download"],
        strip_prefix = "tokio-util-0.7.17",
        build_file = Label("//private/3rdparty/crates:BUILD.tokio-util-0.7.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__toml-0.5.11",
        sha256 = "f4f7f0dd8d50a853a531c426359045b1998f04219d88799810762cd4ad314234",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml/0.5.11/download"],
        strip_prefix = "toml-0.5.11",
        build_file = Label("//private/3rdparty/crates:BUILD.toml-0.5.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__topological-sort-0.2.2",
        sha256 = "ea68304e134ecd095ac6c3574494fc62b909f416c4fca77e440530221e549d3d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/topological-sort/0.2.2/download"],
        strip_prefix = "topological-sort-0.2.2",
        build_file = Label("//private/3rdparty/crates:BUILD.topological-sort-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tower-service-0.3.3",
        sha256 = "8df9b6e13f2d32c91b9bd719c00d1958837bc7dec474d94952798cc8e69eeec3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tower-service/0.3.3/download"],
        strip_prefix = "tower-service-0.3.3",
        build_file = Label("//private/3rdparty/crates:BUILD.tower-service-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tracing-0.1.41",
        sha256 = "784e0ac535deb450455cbfa28a6f0df145ea1bb7ae51b821cf5e7927fdcfbdd0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing/0.1.41/download"],
        strip_prefix = "tracing-0.1.41",
        build_file = Label("//private/3rdparty/crates:BUILD.tracing-0.1.41.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tracing-core-0.1.34",
        sha256 = "b9d12581f227e93f094d3af2ae690a574abb8a2b9b7a96e7cfe9647b2b617678",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-core/0.1.34/download"],
        strip_prefix = "tracing-core-0.1.34",
        build_file = Label("//private/3rdparty/crates:BUILD.tracing-core-0.1.34.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__try-lock-0.2.5",
        sha256 = "e421abadd41a4225275504ea4d6566923418b7f05506fbc9c0fe86ba7396114b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/try-lock/0.2.5/download"],
        strip_prefix = "try-lock-0.2.5",
        build_file = Label("//private/3rdparty/crates:BUILD.try-lock-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__tungstenite-0.21.0",
        sha256 = "9ef1a641ea34f399a848dea702823bbecfb4c486f911735368f1f137cb8257e1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tungstenite/0.21.0/download"],
        strip_prefix = "tungstenite-0.21.0",
        build_file = Label("//private/3rdparty/crates:BUILD.tungstenite-0.21.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__typenum-1.19.0",
        sha256 = "562d481066bde0658276a35467c4af00bdc6ee726305698a55b86e61d7ad82bb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/typenum/1.19.0/download"],
        strip_prefix = "typenum-1.19.0",
        build_file = Label("//private/3rdparty/crates:BUILD.typenum-1.19.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__ucd-trie-0.1.7",
        sha256 = "2896d95c02a80c6d6a5d6e953d479f5ddf2dfdb6a244441010e373ac0fb88971",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ucd-trie/0.1.7/download"],
        strip_prefix = "ucd-trie-0.1.7",
        build_file = Label("//private/3rdparty/crates:BUILD.ucd-trie-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__unicase-2.8.1",
        sha256 = "75b844d17643ee918803943289730bec8aac480150456169e647ed0b576ba539",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicase/2.8.1/download"],
        strip_prefix = "unicase-2.8.1",
        build_file = Label("//private/3rdparty/crates:BUILD.unicase-2.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__unicode-ident-1.0.22",
        sha256 = "9312f7c4f6ff9069b165498234ce8be658059c6728633667c526e27dc2cf1df5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.22/download"],
        strip_prefix = "unicode-ident-1.0.22",
        build_file = Label("//private/3rdparty/crates:BUILD.unicode-ident-1.0.22.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__url-2.5.7",
        sha256 = "08bc136a29a3d1758e07a9cca267be308aeebf5cfd5a10f3f67ab2097683ef5b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/url/2.5.7/download"],
        strip_prefix = "url-2.5.7",
        build_file = Label("//private/3rdparty/crates:BUILD.url-2.5.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__utf-8-0.7.6",
        sha256 = "09cc8ee72d2a9becf2f2febe0205bbed8fc6615b7cb429ad062dc7b7ddd036a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf-8/0.7.6/download"],
        strip_prefix = "utf-8-0.7.6",
        build_file = Label("//private/3rdparty/crates:BUILD.utf-8-0.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__utf8_iter-1.0.4",
        sha256 = "b6c140620e7ffbb22c2dee59cafe6084a59b5ffc27a8859a5f0d494b5d52b6be",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8_iter/1.0.4/download"],
        strip_prefix = "utf8_iter-1.0.4",
        build_file = Label("//private/3rdparty/crates:BUILD.utf8_iter-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__utf8parse-0.2.2",
        sha256 = "06abde3611657adf66d383f00b093d7faecc7fa57071cce2578660c9f1010821",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8parse/0.2.2/download"],
        strip_prefix = "utf8parse-0.2.2",
        build_file = Label("//private/3rdparty/crates:BUILD.utf8parse-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__version_check-0.9.5",
        sha256 = "0b928f33d975fc6ad9f86c8f283853ad26bdd5b10b7f1542aa2fa15e2289105a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/version_check/0.9.5/download"],
        strip_prefix = "version_check-0.9.5",
        build_file = Label("//private/3rdparty/crates:BUILD.version_check-0.9.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__walkdir-2.5.0",
        sha256 = "29790946404f91d9c5d06f9874efddea1dc06c5efe94541a7d6863108e3a5e4b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/walkdir/2.5.0/download"],
        strip_prefix = "walkdir-2.5.0",
        build_file = Label("//private/3rdparty/crates:BUILD.walkdir-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__want-0.3.1",
        sha256 = "bfa7760aed19e106de2c7c0b581b509f2f25d3dacaf737cb82ac61bc6d760b0e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/want/0.3.1/download"],
        strip_prefix = "want-0.3.1",
        build_file = Label("//private/3rdparty/crates:BUILD.want-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__warp-0.3.7",
        sha256 = "4378d202ff965b011c64817db11d5829506d3404edeadb61f190d111da3f231c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/warp/0.3.7/download"],
        strip_prefix = "warp-0.3.7",
        build_file = Label("//private/3rdparty/crates:BUILD.warp-0.3.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__wasi-0.11.1-wasi-snapshot-preview1",
        sha256 = "ccf3ec651a847eb01de73ccad15eb7d99f80485de043efb2f370cd654f4ea44b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasi/0.11.1+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.1+wasi-snapshot-preview1",
        build_file = Label("//private/3rdparty/crates:BUILD.wasi-0.11.1+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__wasip2-1.0.1-wasi-0.2.4",
        sha256 = "0562428422c63773dad2c345a1882263bbf4d65cf3f42e90921f787ef5ad58e7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasip2/1.0.1+wasi-0.2.4/download"],
        strip_prefix = "wasip2-1.0.1+wasi-0.2.4",
        build_file = Label("//private/3rdparty/crates:BUILD.wasip2-1.0.1+wasi-0.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__wasm-bindgen-0.2.105",
        sha256 = "da95793dfc411fbbd93f5be7715b0578ec61fe87cb1a42b12eb625caa5c5ea60",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen/0.2.105/download"],
        strip_prefix = "wasm-bindgen-0.2.105",
        build_file = Label("//private/3rdparty/crates:BUILD.wasm-bindgen-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__wasm-bindgen-macro-0.2.105",
        sha256 = "04264334509e04a7bf8690f2384ef5265f05143a4bff3889ab7a3269adab59c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-macro/0.2.105/download"],
        strip_prefix = "wasm-bindgen-macro-0.2.105",
        build_file = Label("//private/3rdparty/crates:BUILD.wasm-bindgen-macro-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__wasm-bindgen-macro-support-0.2.105",
        sha256 = "420bc339d9f322e562942d52e115d57e950d12d88983a14c79b86859ee6c7ebc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-macro-support/0.2.105/download"],
        strip_prefix = "wasm-bindgen-macro-support-0.2.105",
        build_file = Label("//private/3rdparty/crates:BUILD.wasm-bindgen-macro-support-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__wasm-bindgen-shared-0.2.105",
        sha256 = "76f218a38c84bcb33c25ec7059b07847d465ce0e0a76b995e134a45adcb6af76",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasm-bindgen-shared/0.2.105/download"],
        strip_prefix = "wasm-bindgen-shared-0.2.105",
        build_file = Label("//private/3rdparty/crates:BUILD.wasm-bindgen-shared-0.2.105.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__web_atoms-0.1.3",
        sha256 = "57ffde1dc01240bdf9992e3205668b235e59421fd085e8a317ed98da0178d414",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/web_atoms/0.1.3/download"],
        strip_prefix = "web_atoms-0.1.3",
        build_file = Label("//private/3rdparty/crates:BUILD.web_atoms-0.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__winapi-util-0.1.11",
        sha256 = "c2a7b1c03c876122aa43f3020e6c3c3ee5c05081c9a00739faf7503aeba10d22",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-util/0.1.11/download"],
        strip_prefix = "winapi-util-0.1.11",
        build_file = Label("//private/3rdparty/crates:BUILD.winapi-util-0.1.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-core-0.62.2",
        sha256 = "b8e83a14d34d0623b51dce9581199302a221863196a1dde71a7663a4c2be9deb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-core/0.62.2/download"],
        strip_prefix = "windows-core-0.62.2",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-core-0.62.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-implement-0.60.2",
        sha256 = "053e2e040ab57b9dc951b72c264860db7eb3b0200ba345b4e4c3b14f67855ddf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-implement/0.60.2/download"],
        strip_prefix = "windows-implement-0.60.2",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-implement-0.60.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-interface-0.59.3",
        sha256 = "3f316c4a2570ba26bbec722032c4099d8c8bc095efccdc15688708623367e358",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-interface/0.59.3/download"],
        strip_prefix = "windows-interface-0.59.3",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-interface-0.59.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-link-0.2.1",
        sha256 = "f0805222e57f7521d6a62e36fa9163bc891acd422f971defe97d64e70d0a4fe5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-link/0.2.1/download"],
        strip_prefix = "windows-link-0.2.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-link-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-result-0.4.1",
        sha256 = "7781fa89eaf60850ac3d2da7af8e5242a5ea78d1a11c49bf2910bb5a73853eb5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-result/0.4.1/download"],
        strip_prefix = "windows-result-0.4.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-result-0.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-strings-0.5.1",
        sha256 = "7837d08f69c77cf6b07689544538e017c1bfcf57e34b4c0ff58e6c2cd3b37091",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-strings/0.5.1/download"],
        strip_prefix = "windows-strings-0.5.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-strings-0.5.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-sys-0.52.0",
        sha256 = "282be5f36a8ce781fad8c8ae18fa3f9beff57ec1b52cb3de0789201425d9a33d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.52.0/download"],
        strip_prefix = "windows-sys-0.52.0",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-sys-0.52.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-sys-0.59.0",
        sha256 = "1e38bc4d79ed67fd075bcc251a1c39b32a1776bbe92e5bef1f0bf1f8c531853b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.59.0/download"],
        strip_prefix = "windows-sys-0.59.0",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-sys-0.59.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-sys-0.60.2",
        sha256 = "f2f500e4d28234f72040990ec9d39e3a6b950f9f22d3dba18416c35882612bcb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.60.2/download"],
        strip_prefix = "windows-sys-0.60.2",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-sys-0.60.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-sys-0.61.2",
        sha256 = "ae137229bcbd6cdf0f7b80a31df61766145077ddf49416a728b02cb3921ff3fc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.61.2/download"],
        strip_prefix = "windows-sys-0.61.2",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-sys-0.61.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-targets-0.52.6",
        sha256 = "9b724f72796e036ab90c1021d4780d4d3d648aca59e491e6b98e725b84e99973",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.52.6/download"],
        strip_prefix = "windows-targets-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-targets-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows-targets-0.53.5",
        sha256 = "4945f9f551b88e0d65f3db0bc25c33b8acea4d9e41163edf90dcd0b19f9069f3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.53.5/download"],
        strip_prefix = "windows-targets-0.53.5",
        build_file = Label("//private/3rdparty/crates:BUILD.windows-targets-0.53.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_aarch64_gnullvm-0.52.6",
        sha256 = "32a4622180e7a0ec044bb555404c800bc9fd9ec262ec147edd5989ccd0c02cd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_aarch64_gnullvm-0.53.1",
        sha256 = "a9d8416fa8b42f5c947f8482c43e7d89e73a173cead56d044f6a56104a6d1b53",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.53.1/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.53.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_aarch64_msvc-0.52.6",
        sha256 = "09ec2a7bb152e2252b53fa7803150007879548bc709c039df7627cabbd05d469",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.52.6/download"],
        strip_prefix = "windows_aarch64_msvc-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_aarch64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_aarch64_msvc-0.53.1",
        sha256 = "b9d782e804c2f632e395708e99a94275910eb9100b2114651e04744e9b125006",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.53.1/download"],
        strip_prefix = "windows_aarch64_msvc-0.53.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_aarch64_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_i686_gnu-0.52.6",
        sha256 = "8e9b5ad5ab802e97eb8e295ac6720e509ee4c243f69d781394014ebfe8bbfa0b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.52.6/download"],
        strip_prefix = "windows_i686_gnu-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_i686_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_i686_gnu-0.53.1",
        sha256 = "960e6da069d81e09becb0ca57a65220ddff016ff2d6af6a223cf372a506593a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.53.1/download"],
        strip_prefix = "windows_i686_gnu-0.53.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_i686_gnu-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_i686_gnullvm-0.52.6",
        sha256 = "0eee52d38c090b3caa76c563b86c3a4bd71ef1a819287c19d586d7334ae8ed66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.52.6/download"],
        strip_prefix = "windows_i686_gnullvm-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_i686_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_i686_gnullvm-0.53.1",
        sha256 = "fa7359d10048f68ab8b09fa71c3daccfb0e9b559aed648a8f95469c27057180c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.53.1/download"],
        strip_prefix = "windows_i686_gnullvm-0.53.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_i686_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_i686_msvc-0.52.6",
        sha256 = "240948bc05c5e7c6dabba28bf89d89ffce3e303022809e73deaefe4f6ec56c66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.52.6/download"],
        strip_prefix = "windows_i686_msvc-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_i686_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_i686_msvc-0.53.1",
        sha256 = "1e7ac75179f18232fe9c285163565a57ef8d3c89254a30685b57d83a38d326c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.53.1/download"],
        strip_prefix = "windows_i686_msvc-0.53.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_i686_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_x86_64_gnu-0.52.6",
        sha256 = "147a5c80aabfbf0c7d901cb5895d1de30ef2907eb21fbbab29ca94c5b08b1a78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnu-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_x86_64_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_x86_64_gnu-0.53.1",
        sha256 = "9c3842cdd74a865a8066ab39c8a7a473c0778a3f29370b5fd6b4b9aa7df4a499",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.53.1/download"],
        strip_prefix = "windows_x86_64_gnu-0.53.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_x86_64_gnu-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_x86_64_gnullvm-0.52.6",
        sha256 = "24d5b23dc417412679681396f2b49f3de8c1473deb516bd34410872eff51ed0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_x86_64_gnullvm-0.53.1",
        sha256 = "0ffa179e2d07eee8ad8f57493436566c7cc30ac536a3379fdf008f47f6bb7ae1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.53.1/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.53.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_x86_64_msvc-0.52.6",
        sha256 = "589f6da84c646204747d1270a2a5661ea66ed1cced2631d546fdfb155959f9ec",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.52.6/download"],
        strip_prefix = "windows_x86_64_msvc-0.52.6",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_x86_64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__windows_x86_64_msvc-0.53.1",
        sha256 = "d6bbff5f0aada427a1e5a6da5f1f98158182f26556f345ac9e04d36d0ebed650",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.53.1/download"],
        strip_prefix = "windows_x86_64_msvc-0.53.1",
        build_file = Label("//private/3rdparty/crates:BUILD.windows_x86_64_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__wit-bindgen-0.46.0",
        sha256 = "f17a85883d4e6d00e8a97c586de764dabcc06133f7f1d55dce5cdc070ad7fe59",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wit-bindgen/0.46.0/download"],
        strip_prefix = "wit-bindgen-0.46.0",
        build_file = Label("//private/3rdparty/crates:BUILD.wit-bindgen-0.46.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__writeable-0.6.2",
        sha256 = "9edde0db4769d2dc68579893f2306b26c6ecfbe0ef499b013d731b7b9247e0b9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/writeable/0.6.2/download"],
        strip_prefix = "writeable-0.6.2",
        build_file = Label("//private/3rdparty/crates:BUILD.writeable-0.6.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__yoke-0.8.1",
        sha256 = "72d6e5c6afb84d73944e5cedb052c4680d5657337201555f9f2a16b7406d4954",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke/0.8.1/download"],
        strip_prefix = "yoke-0.8.1",
        build_file = Label("//private/3rdparty/crates:BUILD.yoke-0.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__yoke-derive-0.8.1",
        sha256 = "b659052874eb698efe5b9e8cf382204678a0086ebf46982b79d6ca3182927e5d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke-derive/0.8.1/download"],
        strip_prefix = "yoke-derive-0.8.1",
        build_file = Label("//private/3rdparty/crates:BUILD.yoke-derive-0.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__zerocopy-0.8.27",
        sha256 = "0894878a5fa3edfd6da3f88c4805f4c8558e2b996227a3d864f47fe11e38282c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy/0.8.27/download"],
        strip_prefix = "zerocopy-0.8.27",
        build_file = Label("//private/3rdparty/crates:BUILD.zerocopy-0.8.27.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__zerocopy-derive-0.8.27",
        sha256 = "88d2b8d9c68ad2b9e4340d7832716a4d21a22a1154777ad56ea55c51a9cf3831",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy-derive/0.8.27/download"],
        strip_prefix = "zerocopy-derive-0.8.27",
        build_file = Label("//private/3rdparty/crates:BUILD.zerocopy-derive-0.8.27.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__zerofrom-0.1.6",
        sha256 = "50cc42e0333e05660c3587f3bf9d0478688e15d870fab3346451ce7f8c9fbea5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom/0.1.6/download"],
        strip_prefix = "zerofrom-0.1.6",
        build_file = Label("//private/3rdparty/crates:BUILD.zerofrom-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__zerofrom-derive-0.1.6",
        sha256 = "d71e5d6e06ab090c67b5e44993ec16b72dcbaabc526db883a360057678b48502",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom-derive/0.1.6/download"],
        strip_prefix = "zerofrom-derive-0.1.6",
        build_file = Label("//private/3rdparty/crates:BUILD.zerofrom-derive-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__zerotrie-0.2.3",
        sha256 = "2a59c17a5562d507e4b54960e8569ebee33bee890c70aa3fe7b97e85a9fd7851",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerotrie/0.2.3/download"],
        strip_prefix = "zerotrie-0.2.3",
        build_file = Label("//private/3rdparty/crates:BUILD.zerotrie-0.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__zerovec-0.11.5",
        sha256 = "6c28719294829477f525be0186d13efa9a3c602f7ec202ca9e353d310fb9a002",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec/0.11.5/download"],
        strip_prefix = "zerovec-0.11.5",
        build_file = Label("//private/3rdparty/crates:BUILD.zerovec-0.11.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rmdbi__zerovec-derive-0.11.2",
        sha256 = "eadce39539ca5cb3985590102671f2567e659fca9666581ad3411d59207951f3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec-derive/0.11.2/download"],
        strip_prefix = "zerovec-derive-0.11.2",
        build_file = Label("//private/3rdparty/crates:BUILD.zerovec-derive-0.11.2.bazel"),
    )

    return [
        struct(repo = "rmdbi__mdbook-0.4.44", is_dev_dep = False),
    ]
