###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "bindgen": Label("@rules_rust_bindgen_deps//:bindgen-0.71.1"),
            "clang-sys": Label("@rules_rust_bindgen_deps//:clang-sys-1.8.1"),
            "clap": Label("@rules_rust_bindgen_deps//:clap-4.5.32"),
            "clap_complete": Label("@rules_rust_bindgen_deps//:clap_complete-4.5.46"),
            "env_logger": Label("@rules_rust_bindgen_deps//:env_logger-0.10.2"),
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"arm64ec\"), target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(any(unix, target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(target_os = \"hermit\")": [],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnullvm": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__aho-corasick-1.1.3",
        sha256 = "8e60d3430d3a69478ad0993f19238d2df97c507009a52b3c10addcd7f6bcb916",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/aho-corasick/1.1.3/download"],
        strip_prefix = "aho-corasick-1.1.3",
        build_file = Label("//3rdparty/crates:BUILD.aho-corasick-1.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__annotate-snippets-0.11.5",
        sha256 = "710e8eae58854cdc1790fcb56cca04d712a17be849eeb81da2a724bf4bae2bc4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/annotate-snippets/0.11.5/download"],
        strip_prefix = "annotate-snippets-0.11.5",
        build_file = Label("//3rdparty/crates:BUILD.annotate-snippets-0.11.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__anstream-0.6.18",
        sha256 = "8acc5369981196006228e28809f761875c0327210a891e941f4c683b3a99529b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstream/0.6.18/download"],
        strip_prefix = "anstream-0.6.18",
        build_file = Label("//3rdparty/crates:BUILD.anstream-0.6.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__anstyle-1.0.10",
        sha256 = "55cc3b69f167a1ef2e161439aa98aed94e6028e5f9a59be9a6ffb47aef1651f9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle/1.0.10/download"],
        strip_prefix = "anstyle-1.0.10",
        build_file = Label("//3rdparty/crates:BUILD.anstyle-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__anstyle-parse-0.2.6",
        sha256 = "3b2d16507662817a6a20a9ea92df6652ee4f94f914589377d69f3b21bc5798a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-parse/0.2.6/download"],
        strip_prefix = "anstyle-parse-0.2.6",
        build_file = Label("//3rdparty/crates:BUILD.anstyle-parse-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__anstyle-query-1.1.2",
        sha256 = "79947af37f4177cfead1110013d678905c37501914fba0efea834c3fe9a8d60c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-query/1.1.2/download"],
        strip_prefix = "anstyle-query-1.1.2",
        build_file = Label("//3rdparty/crates:BUILD.anstyle-query-1.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__anstyle-wincon-3.0.7",
        sha256 = "ca3534e77181a9cc07539ad51f2141fe32f6c3ffd4df76db8ad92346b003ae4e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-wincon/3.0.7/download"],
        strip_prefix = "anstyle-wincon-3.0.7",
        build_file = Label("//3rdparty/crates:BUILD.anstyle-wincon-3.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__bindgen-0.71.1",
        sha256 = "5f58bf3d7db68cfbac37cfc485a8d711e87e064c3d0fe0435b92f7a407f9d6b3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bindgen/0.71.1/download"],
        strip_prefix = "bindgen-0.71.1",
        build_file = Label("//3rdparty/crates:BUILD.bindgen-0.71.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__bitflags-2.9.0",
        sha256 = "5c8214115b7bf84099f1309324e63141d4c5d7cc26862f97a0a857dbefe165bd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/2.9.0/download"],
        strip_prefix = "bitflags-2.9.0",
        build_file = Label("//3rdparty/crates:BUILD.bitflags-2.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__cexpr-0.6.0",
        sha256 = "6fac387a98bb7c37292057cffc56d62ecb629900026402633ae9160df93a8766",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cexpr/0.6.0/download"],
        strip_prefix = "cexpr-0.6.0",
        build_file = Label("//3rdparty/crates:BUILD.cexpr-0.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("//3rdparty/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__clang-sys-1.8.1",
        sha256 = "0b023947811758c97c59bf9d1c188fd619ad4718dcaa767947df1cadb14f39f4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clang-sys/1.8.1/download"],
        strip_prefix = "clang-sys-1.8.1",
        build_file = Label("//3rdparty/crates:BUILD.clang-sys-1.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__clap-4.5.32",
        sha256 = "6088f3ae8c3608d19260cd7445411865a485688711b78b5be70d78cd96136f83",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap/4.5.32/download"],
        strip_prefix = "clap-4.5.32",
        build_file = Label("//3rdparty/crates:BUILD.clap-4.5.32.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__clap_builder-4.5.32",
        sha256 = "22a7ef7f676155edfb82daa97f99441f3ebf4a58d5e32f295a56259f1b6facc8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_builder/4.5.32/download"],
        strip_prefix = "clap_builder-4.5.32",
        build_file = Label("//3rdparty/crates:BUILD.clap_builder-4.5.32.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__clap_complete-4.5.46",
        sha256 = "f5c5508ea23c5366f77e53f5a0070e5a84e51687ec3ef9e0464c86dc8d13ce98",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_complete/4.5.46/download"],
        strip_prefix = "clap_complete-4.5.46",
        build_file = Label("//3rdparty/crates:BUILD.clap_complete-4.5.46.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__clap_derive-4.5.32",
        sha256 = "09176aae279615badda0765c0c0b3f6ed53f4709118af73cf4655d85d1530cd7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_derive/4.5.32/download"],
        strip_prefix = "clap_derive-4.5.32",
        build_file = Label("//3rdparty/crates:BUILD.clap_derive-4.5.32.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__clap_lex-0.7.4",
        sha256 = "f46ad14479a25103f283c0f10005961cf086d8dc42205bb44c46ac563475dca6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_lex/0.7.4/download"],
        strip_prefix = "clap_lex-0.7.4",
        build_file = Label("//3rdparty/crates:BUILD.clap_lex-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__colorchoice-1.0.3",
        sha256 = "5b63caa9aa9397e2d9480a9b13673856c78d8ac123288526c37d7839f2a86990",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/colorchoice/1.0.3/download"],
        strip_prefix = "colorchoice-1.0.3",
        build_file = Label("//3rdparty/crates:BUILD.colorchoice-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__either-1.15.0",
        sha256 = "48c757948c5ede0e46177b7add2e67155f70e33c07fea8284df6576da70b3719",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/either/1.15.0/download"],
        strip_prefix = "either-1.15.0",
        build_file = Label("//3rdparty/crates:BUILD.either-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__env_logger-0.10.2",
        sha256 = "4cd405aab171cb85d6735e5c8d9db038c17d3ca007a4d2c25f337935c3d90580",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/env_logger/0.10.2/download"],
        strip_prefix = "env_logger-0.10.2",
        build_file = Label("//3rdparty/crates:BUILD.env_logger-0.10.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__glob-0.3.2",
        sha256 = "a8d1add55171497b4705a648c6b583acafb01d58050a51727785f0b2c8e0a2b2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/glob/0.3.2/download"],
        strip_prefix = "glob-0.3.2",
        build_file = Label("//3rdparty/crates:BUILD.glob-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__heck-0.5.0",
        sha256 = "2304e00983f87ffb38b55b444b5e3b60a884b5d30c0fca7d82fe33449bbe55ea",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/heck/0.5.0/download"],
        strip_prefix = "heck-0.5.0",
        build_file = Label("//3rdparty/crates:BUILD.heck-0.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__hermit-abi-0.5.0",
        sha256 = "fbd780fe5cc30f81464441920d82ac8740e2e46b29a6fad543ddd075229ce37e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hermit-abi/0.5.0/download"],
        strip_prefix = "hermit-abi-0.5.0",
        build_file = Label("//3rdparty/crates:BUILD.hermit-abi-0.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__humantime-2.2.0",
        sha256 = "9b112acc8b3adf4b107a8ec20977da0273a8c386765a3ec0229bd500a1443f9f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/humantime/2.2.0/download"],
        strip_prefix = "humantime-2.2.0",
        build_file = Label("//3rdparty/crates:BUILD.humantime-2.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__is-terminal-0.4.16",
        sha256 = "e04d7f318608d35d4b61ddd75cbdaee86b023ebe2bd5a66ee0915f0bf93095a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/is-terminal/0.4.16/download"],
        strip_prefix = "is-terminal-0.4.16",
        build_file = Label("//3rdparty/crates:BUILD.is-terminal-0.4.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__is_terminal_polyfill-1.70.1",
        sha256 = "7943c866cc5cd64cbc25b2e01621d07fa8eb2a1a23160ee81ce38704e97b8ecf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/is_terminal_polyfill/1.70.1/download"],
        strip_prefix = "is_terminal_polyfill-1.70.1",
        build_file = Label("//3rdparty/crates:BUILD.is_terminal_polyfill-1.70.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__itertools-0.13.0",
        sha256 = "413ee7dfc52ee1a4949ceeb7dbc8a33f2d6c088194d9f922fb8318faf1f01186",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itertools/0.13.0/download"],
        strip_prefix = "itertools-0.13.0",
        build_file = Label("//3rdparty/crates:BUILD.itertools-0.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__libc-0.2.171",
        sha256 = "c19937216e9d3aa9956d9bb8dfc0b0c8beb6058fc4f7a4dc4d850edf86a237d6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.171/download"],
        strip_prefix = "libc-0.2.171",
        build_file = Label("//3rdparty/crates:BUILD.libc-0.2.171.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__libloading-0.8.6",
        sha256 = "fc2f4eb4bc735547cfed7c0a4922cbd04a4655978c09b54f1f7b228750664c34",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libloading/0.8.6/download"],
        strip_prefix = "libloading-0.8.6",
        build_file = Label("//3rdparty/crates:BUILD.libloading-0.8.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__log-0.4.26",
        sha256 = "30bde2b3dc3671ae49d8e2e9f044c7c005836e7a023ee57cffa25ab82764bb9e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.26/download"],
        strip_prefix = "log-0.4.26",
        build_file = Label("//3rdparty/crates:BUILD.log-0.4.26.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__memchr-2.7.4",
        sha256 = "78ca9ab1a0babb1e7d5695e3530886289c18cf2f87ec19a575a0abdce112e3a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.7.4/download"],
        strip_prefix = "memchr-2.7.4",
        build_file = Label("//3rdparty/crates:BUILD.memchr-2.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__minimal-lexical-0.2.1",
        sha256 = "68354c5c6bd36d73ff3feceb05efa59b6acb7626617f4962be322a825e61f79a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/minimal-lexical/0.2.1/download"],
        strip_prefix = "minimal-lexical-0.2.1",
        build_file = Label("//3rdparty/crates:BUILD.minimal-lexical-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__nom-7.1.3",
        sha256 = "d273983c5a657a70a3e8f2a01329822f3b8c8172b73826411a55751e404a0a4a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/nom/7.1.3/download"],
        strip_prefix = "nom-7.1.3",
        build_file = Label("//3rdparty/crates:BUILD.nom-7.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__once_cell-1.21.1",
        sha256 = "d75b0bedcc4fe52caa0e03d9f1151a323e4aa5e2d78ba3580400cd3c9e2bc4bc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.21.1/download"],
        strip_prefix = "once_cell-1.21.1",
        build_file = Label("//3rdparty/crates:BUILD.once_cell-1.21.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__prettyplease-0.2.31",
        sha256 = "5316f57387668042f561aae71480de936257848f9c43ce528e311d89a07cadeb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/prettyplease/0.2.31/download"],
        strip_prefix = "prettyplease-0.2.31",
        build_file = Label("//3rdparty/crates:BUILD.prettyplease-0.2.31.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__proc-macro2-1.0.94",
        sha256 = "a31971752e70b8b2686d7e46ec17fb38dad4051d94024c88df49b667caea9c84",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.94/download"],
        strip_prefix = "proc-macro2-1.0.94",
        build_file = Label("//3rdparty/crates:BUILD.proc-macro2-1.0.94.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__quote-1.0.40",
        sha256 = "1885c039570dc00dcb4ff087a89e185fd56bae234ddc7f056a945bf36467248d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.40/download"],
        strip_prefix = "quote-1.0.40",
        build_file = Label("//3rdparty/crates:BUILD.quote-1.0.40.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__regex-1.11.1",
        sha256 = "b544ef1b4eac5dc2db33ea63606ae9ffcfac26c1416a2806ae0bf5f56b201191",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex/1.11.1/download"],
        strip_prefix = "regex-1.11.1",
        build_file = Label("//3rdparty/crates:BUILD.regex-1.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__regex-automata-0.4.9",
        sha256 = "809e8dc61f6de73b46c85f4c96486310fe304c434cfa43669d7b40f711150908",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.4.9/download"],
        strip_prefix = "regex-automata-0.4.9",
        build_file = Label("//3rdparty/crates:BUILD.regex-automata-0.4.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__regex-syntax-0.8.5",
        sha256 = "2b15c43186be67a4fd63bee50d0303afffcef381492ebe2c5d87f324e1b8815c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-syntax/0.8.5/download"],
        strip_prefix = "regex-syntax-0.8.5",
        build_file = Label("//3rdparty/crates:BUILD.regex-syntax-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__rustc-hash-2.1.1",
        sha256 = "357703d41365b4b27c590e3ed91eabb1b663f07c4c084095e60cbed4362dff0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-hash/2.1.1/download"],
        strip_prefix = "rustc-hash-2.1.1",
        build_file = Label("//3rdparty/crates:BUILD.rustc-hash-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__shlex-1.3.0",
        sha256 = "0fda2ff0d084019ba4d7c6f371c95d8fd75ce3524c3cb8fb653a3023f6323e64",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/shlex/1.3.0/download"],
        strip_prefix = "shlex-1.3.0",
        build_file = Label("//3rdparty/crates:BUILD.shlex-1.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__strsim-0.11.1",
        sha256 = "7da8b5736845d9f2fcb837ea5d9e2628564b3b043a70948a3f0b778838c5fb4f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/strsim/0.11.1/download"],
        strip_prefix = "strsim-0.11.1",
        build_file = Label("//3rdparty/crates:BUILD.strsim-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__syn-2.0.100",
        sha256 = "b09a44accad81e1ba1cd74a32461ba89dee89095ba17b32f5d03683b1b1fc2a0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.100/download"],
        strip_prefix = "syn-2.0.100",
        build_file = Label("//3rdparty/crates:BUILD.syn-2.0.100.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__termcolor-1.4.1",
        sha256 = "06794f8f6c5c898b3275aebefa6b8a1cb24cd2c6c79397ab15774837a0bc5755",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/termcolor/1.4.1/download"],
        strip_prefix = "termcolor-1.4.1",
        build_file = Label("//3rdparty/crates:BUILD.termcolor-1.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__unicode-ident-1.0.18",
        sha256 = "5a5f39404a5da50712a4c1eecf25e90dd62b613502b7e925fd4e4d19b5c96512",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.18/download"],
        strip_prefix = "unicode-ident-1.0.18",
        build_file = Label("//3rdparty/crates:BUILD.unicode-ident-1.0.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__unicode-width-0.2.0",
        sha256 = "1fc81956842c57dac11422a97c3b8195a1ff727f06e85c84ed2e8aa277c9a0fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-width/0.2.0/download"],
        strip_prefix = "unicode-width-0.2.0",
        build_file = Label("//3rdparty/crates:BUILD.unicode-width-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__utf8parse-0.2.2",
        sha256 = "06abde3611657adf66d383f00b093d7faecc7fa57071cce2578660c9f1010821",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8parse/0.2.2/download"],
        strip_prefix = "utf8parse-0.2.2",
        build_file = Label("//3rdparty/crates:BUILD.utf8parse-0.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__winapi-util-0.1.9",
        sha256 = "cf221c93e13a30d793f7645a0e7762c55d169dbb0a49671918a2319d289b10bb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-util/0.1.9/download"],
        strip_prefix = "winapi-util-0.1.9",
        build_file = Label("//3rdparty/crates:BUILD.winapi-util-0.1.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows-sys-0.59.0",
        sha256 = "1e38bc4d79ed67fd075bcc251a1c39b32a1776bbe92e5bef1f0bf1f8c531853b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.59.0/download"],
        strip_prefix = "windows-sys-0.59.0",
        build_file = Label("//3rdparty/crates:BUILD.windows-sys-0.59.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows-targets-0.52.6",
        sha256 = "9b724f72796e036ab90c1021d4780d4d3d648aca59e491e6b98e725b84e99973",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.52.6/download"],
        strip_prefix = "windows-targets-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows-targets-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows_aarch64_gnullvm-0.52.6",
        sha256 = "32a4622180e7a0ec044bb555404c800bc9fd9ec262ec147edd5989ccd0c02cd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows_aarch64_msvc-0.52.6",
        sha256 = "09ec2a7bb152e2252b53fa7803150007879548bc709c039df7627cabbd05d469",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.52.6/download"],
        strip_prefix = "windows_aarch64_msvc-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_aarch64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows_i686_gnu-0.52.6",
        sha256 = "8e9b5ad5ab802e97eb8e295ac6720e509ee4c243f69d781394014ebfe8bbfa0b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.52.6/download"],
        strip_prefix = "windows_i686_gnu-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows_i686_gnullvm-0.52.6",
        sha256 = "0eee52d38c090b3caa76c563b86c3a4bd71ef1a819287c19d586d7334ae8ed66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.52.6/download"],
        strip_prefix = "windows_i686_gnullvm-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows_i686_msvc-0.52.6",
        sha256 = "240948bc05c5e7c6dabba28bf89d89ffce3e303022809e73deaefe4f6ec56c66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.52.6/download"],
        strip_prefix = "windows_i686_msvc-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_i686_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows_x86_64_gnu-0.52.6",
        sha256 = "147a5c80aabfbf0c7d901cb5895d1de30ef2907eb21fbbab29ca94c5b08b1a78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnu-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows_x86_64_gnullvm-0.52.6",
        sha256 = "24d5b23dc417412679681396f2b49f3de8c1473deb516bd34410872eff51ed0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_bindgen_deps__windows_x86_64_msvc-0.52.6",
        sha256 = "589f6da84c646204747d1270a2a5661ea66ed1cced2631d546fdfb155959f9ec",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.52.6/download"],
        strip_prefix = "windows_x86_64_msvc-0.52.6",
        build_file = Label("//3rdparty/crates:BUILD.windows_x86_64_msvc-0.52.6.bazel"),
    )

    return [
        struct(repo = "rules_rust_bindgen_deps__bindgen-0.71.1", is_dev_dep = False),
        struct(repo = "rules_rust_bindgen_deps__clang-sys-1.8.1", is_dev_dep = False),
        struct(repo = "rules_rust_bindgen_deps__clap-4.5.32", is_dev_dep = False),
        struct(repo = "rules_rust_bindgen_deps__clap_complete-4.5.46", is_dev_dep = False),
        struct(repo = "rules_rust_bindgen_deps__env_logger-0.10.2", is_dev_dep = False),
    ]
