###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     See https://github.com/bazelbuild/rules_rust/blob/main/examples/crate_universe/vendor_local_pkgs/BUILD.bazel
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "axum": Label("@crates_vendor_pkgs//:axum-0.4.8"),
            "hyper": Label("@crates_vendor_pkgs//:hyper-0.14.32"),
            "mime": Label("@crates_vendor_pkgs//:mime-0.3.17"),
            "serde_json": Label("@crates_vendor_pkgs//:serde_json-1.0.135"),
            "socket2": Label("@crates_vendor_pkgs//:socket2-0.4.10"),
            "tokio": Label("@crates_vendor_pkgs//:tokio-1.43.0"),
            "tower": Label("@crates_vendor_pkgs//:tower-0.4.13"),
            "tower-http": Label("@crates_vendor_pkgs//:tower-http-0.2.5"),
            "tracing": Label("@crates_vendor_pkgs//:tracing-0.1.41"),
            "tracing-subscriber": Label("@crates_vendor_pkgs//:tracing-subscriber-0.3.19"),
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"arm64ec\"), target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(any())": [],
    "cfg(not(all(windows, target_env = \"msvc\", not(target_vendor = \"uwp\"))))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"wasi\")": ["@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(target_os = \"windows\")": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(tokio_taskdump)": [],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-gnullvm": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "crates_vendor_pkgs__addr2line-0.24.2",
        sha256 = "dfbe277e56a376000877090da837660b4427aad530e3028d44e0bffe4f89a1c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/addr2line/0.24.2/download"],
        strip_prefix = "addr2line-0.24.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.addr2line-0.24.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__adler2-2.0.0",
        sha256 = "512761e0bb2578dd7380c6baaa0f4ce03e84f95e960231d1dec8bf4d7d6e2627",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/adler2/2.0.0/download"],
        strip_prefix = "adler2-2.0.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.adler2-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__async-trait-0.1.85",
        sha256 = "3f934833b4b7233644e5848f235df3f57ed8c80f1528a26c3dfa13d2147fa056",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/async-trait/0.1.85/download"],
        strip_prefix = "async-trait-0.1.85",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.async-trait-0.1.85.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__autocfg-1.4.0",
        sha256 = "ace50bade8e6234aa140d9a2f552bbee1db4d353f69b8217bc503490fc1a9f26",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/autocfg/1.4.0/download"],
        strip_prefix = "autocfg-1.4.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.autocfg-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__axum-0.4.8",
        sha256 = "c9f346c92c1e9a71d14fe4aaf7c2a5d9932cc4e5e48d8fb6641524416eb79ddd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/axum/0.4.8/download"],
        strip_prefix = "axum-0.4.8",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.axum-0.4.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__axum-core-0.1.2",
        sha256 = "6dbcda393bef9c87572779cb8ef916f12d77750b27535dd6819fa86591627a51",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/axum-core/0.1.2/download"],
        strip_prefix = "axum-core-0.1.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.axum-core-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__backtrace-0.3.74",
        sha256 = "8d82cb332cdfaed17ae235a638438ac4d4839913cc2af585c3c6746e8f8bee1a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/backtrace/0.3.74/download"],
        strip_prefix = "backtrace-0.3.74",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.backtrace-0.3.74.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__bitflags-2.6.0",
        sha256 = "b048fb63fd8b5923fc5aa7b340d8e156aec7ec02f0c78fa8a6ddc2613f6f71de",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/2.6.0/download"],
        strip_prefix = "bitflags-2.6.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.bitflags-2.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__bytes-1.9.0",
        sha256 = "325918d6fe32f23b19878fe4b34794ae41fc19ddbe53b10571a4874d44ffd39b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bytes/1.9.0/download"],
        strip_prefix = "bytes-1.9.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.bytes-1.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__equivalent-1.0.1",
        sha256 = "5443807d6dff69373d433ab9ef5378ad8df50ca6298caf15de6e52e24aaf54d5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/equivalent/1.0.1/download"],
        strip_prefix = "equivalent-1.0.1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.equivalent-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__fnv-1.0.7",
        sha256 = "3f9eec918d3f24069decb9af1554cad7c880e2da24a9afd88aca000531ab82c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fnv/1.0.7/download"],
        strip_prefix = "fnv-1.0.7",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.fnv-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__form_urlencoded-1.2.1",
        sha256 = "e13624c2627564efccf4934284bdd98cbaa14e79b0b5a141218e507b3a823456",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/form_urlencoded/1.2.1/download"],
        strip_prefix = "form_urlencoded-1.2.1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.form_urlencoded-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-channel-0.3.31",
        sha256 = "2dff15bf788c671c1934e366d07e30c1814a8ef514e1af724a602e8a2fbe1b10",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-channel/0.3.31/download"],
        strip_prefix = "futures-channel-0.3.31",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.futures-channel-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-core-0.3.31",
        sha256 = "05f29059c0c2090612e8d742178b0580d2dc940c837851ad723096f87af6663e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-core/0.3.31/download"],
        strip_prefix = "futures-core-0.3.31",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.futures-core-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-sink-0.3.31",
        sha256 = "e575fab7d1e0dcb8d0c7bcf9a63ee213816ab51902e6d244a95819acacf1d4f7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-sink/0.3.31/download"],
        strip_prefix = "futures-sink-0.3.31",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.futures-sink-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-task-0.3.31",
        sha256 = "f90f7dce0722e95104fcb095585910c0977252f286e354b5e3bd38902cd99988",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-task/0.3.31/download"],
        strip_prefix = "futures-task-0.3.31",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.futures-task-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__futures-util-0.3.31",
        sha256 = "9fa08315bb612088cc391249efdc3bc77536f16c91f6cf495e6fbe85b20a4a81",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-util/0.3.31/download"],
        strip_prefix = "futures-util-0.3.31",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.futures-util-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__gimli-0.31.1",
        sha256 = "07e28edb80900c19c28f1072f2e8aeca7fa06b23cd4169cefe1af5aa3260783f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gimli/0.31.1/download"],
        strip_prefix = "gimli-0.31.1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.gimli-0.31.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__h2-0.3.26",
        sha256 = "81fe527a889e1532da5c525686d96d4c2e74cdd345badf8dfef9f6b39dd5f5e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/h2/0.3.26/download"],
        strip_prefix = "h2-0.3.26",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.h2-0.3.26.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__hashbrown-0.15.2",
        sha256 = "bf151400ff0baff5465007dd2f3e717f3fe502074ca563069ce3a6629d07b289",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.15.2/download"],
        strip_prefix = "hashbrown-0.15.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.hashbrown-0.15.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-0.2.12",
        sha256 = "601cbb57e577e2f5ef5be8e7b83f0f63994f25aa94d673e54a92d5c516d101f1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/http/0.2.12/download"],
        strip_prefix = "http-0.2.12",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.http-0.2.12.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-body-0.4.6",
        sha256 = "7ceab25649e9960c0311ea418d17bee82c0dcec1bd053b5f9a66e265a693bed2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/http-body/0.4.6/download"],
        strip_prefix = "http-body-0.4.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.http-body-0.4.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__http-range-header-0.3.1",
        sha256 = "add0ab9360ddbd88cfeb3bd9574a1d85cfdfa14db10b3e21d3700dbc4328758f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/http-range-header/0.3.1/download"],
        strip_prefix = "http-range-header-0.3.1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.http-range-header-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__httparse-1.9.5",
        sha256 = "7d71d3574edd2771538b901e6549113b4006ece66150fb69c0fb6d9a2adae946",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/httparse/1.9.5/download"],
        strip_prefix = "httparse-1.9.5",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.httparse-1.9.5.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__httpdate-1.0.3",
        sha256 = "df3b46402a9d5adb4c86a0cf463f42e19994e3ee891101b1841f30a545cb49a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/httpdate/1.0.3/download"],
        strip_prefix = "httpdate-1.0.3",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.httpdate-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__hyper-0.14.32",
        sha256 = "41dfc780fdec9373c01bae43289ea34c972e40ee3c9f6b3c8801a35f35586ce7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hyper/0.14.32/download"],
        strip_prefix = "hyper-0.14.32",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.hyper-0.14.32.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__indexmap-2.7.0",
        sha256 = "62f822373a4fe84d4bb149bf54e584a7f4abec90e072ed49cda0edea5b95471f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/2.7.0/download"],
        strip_prefix = "indexmap-2.7.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.indexmap-2.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__itoa-1.0.14",
        sha256 = "d75a2a4b1b190afb6f5425f10f6a8f959d2ea0b9c2b1d79553551850539e4674",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itoa/1.0.14/download"],
        strip_prefix = "itoa-1.0.14",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.itoa-1.0.14.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__lazy_static-1.5.0",
        sha256 = "bbd2bcb4c963f2ddae06a2efc7e9f3591312473c50c6685e1f298068316e66fe",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lazy_static/1.5.0/download"],
        strip_prefix = "lazy_static-1.5.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.lazy_static-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__libc-0.2.169",
        sha256 = "b5aba8db14291edd000dfcc4d620c7ebfb122c613afb886ca8803fa4e128a20a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.169/download"],
        strip_prefix = "libc-0.2.169",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.libc-0.2.169.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__lock_api-0.4.12",
        sha256 = "07af8b9cdd281b7915f413fa73f29ebd5d55d0d3f0155584dade1ff18cea1b17",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lock_api/0.4.12/download"],
        strip_prefix = "lock_api-0.4.12",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.lock_api-0.4.12.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__log-0.4.22",
        sha256 = "a7a70ba024b9dc04c27ea2f0c0548feb474ec5c54bba33a7f72f873a39d07b24",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.22/download"],
        strip_prefix = "log-0.4.22",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.log-0.4.22.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__matchit-0.4.6",
        sha256 = "9376a4f0340565ad675d11fc1419227faf5f60cd7ac9cb2e7185a471f30af833",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/matchit/0.4.6/download"],
        strip_prefix = "matchit-0.4.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.matchit-0.4.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__memchr-2.7.4",
        sha256 = "78ca9ab1a0babb1e7d5695e3530886289c18cf2f87ec19a575a0abdce112e3a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.7.4/download"],
        strip_prefix = "memchr-2.7.4",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.memchr-2.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__mime-0.3.17",
        sha256 = "6877bb514081ee2a7ff5ef9de3281f14a4dd4bceac4c09388074a6b5df8a139a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mime/0.3.17/download"],
        strip_prefix = "mime-0.3.17",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.mime-0.3.17.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__miniz_oxide-0.8.2",
        sha256 = "4ffbe83022cedc1d264172192511ae958937694cd57ce297164951b8b3568394",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/miniz_oxide/0.8.2/download"],
        strip_prefix = "miniz_oxide-0.8.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.miniz_oxide-0.8.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__mio-1.0.3",
        sha256 = "2886843bf800fba2e3377cff24abf6379b4c4d5c6681eaf9ea5b0d15090450bd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mio/1.0.3/download"],
        strip_prefix = "mio-1.0.3",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.mio-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__nu-ansi-term-0.46.0",
        sha256 = "77a8165726e8236064dbb45459242600304b42a5ea24ee2948e18e023bf7ba84",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/nu-ansi-term/0.46.0/download"],
        strip_prefix = "nu-ansi-term-0.46.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.nu-ansi-term-0.46.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__object-0.36.7",
        sha256 = "62948e14d923ea95ea2c7c86c71013138b66525b86bdc08d2dcc262bdb497b87",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/object/0.36.7/download"],
        strip_prefix = "object-0.36.7",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.object-0.36.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__once_cell-1.20.2",
        sha256 = "1261fe7e33c73b354eab43b1273a57c8f967d0391e80353e51f764ac02cf6775",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.20.2/download"],
        strip_prefix = "once_cell-1.20.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.once_cell-1.20.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__overload-0.1.1",
        sha256 = "b15813163c1d831bf4a13c3610c05c0d03b39feb07f7e09fa234dac9b15aaf39",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/overload/0.1.1/download"],
        strip_prefix = "overload-0.1.1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.overload-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__parking_lot-0.12.3",
        sha256 = "f1bf18183cf54e8d6059647fc3063646a1801cf30896933ec2311622cc4b9a27",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot/0.12.3/download"],
        strip_prefix = "parking_lot-0.12.3",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.parking_lot-0.12.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__parking_lot_core-0.9.10",
        sha256 = "1e401f977ab385c9e4e3ab30627d6f26d00e2c73eef317493c4ec6d468726cf8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot_core/0.9.10/download"],
        strip_prefix = "parking_lot_core-0.9.10",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.parking_lot_core-0.9.10.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__percent-encoding-2.3.1",
        sha256 = "e3148f5046208a5d56bcfc03053e3ca6334e51da8dfb19b6cdc8b306fae3283e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/percent-encoding/2.3.1/download"],
        strip_prefix = "percent-encoding-2.3.1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.percent-encoding-2.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-1.1.8",
        sha256 = "1e2ec53ad785f4d35dac0adea7f7dc6f1bb277ad84a680c7afefeae05d1f5916",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project/1.1.8/download"],
        strip_prefix = "pin-project-1.1.8",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.pin-project-1.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-internal-1.1.8",
        sha256 = "d56a66c0c55993aa927429d0f8a0abfd74f084e4d9c192cffed01e418d83eefb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project-internal/1.1.8/download"],
        strip_prefix = "pin-project-internal-1.1.8",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.pin-project-internal-1.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-project-lite-0.2.16",
        sha256 = "3b3cff922bd51709b605d9ead9aa71031d81447142d828eb4a6eba76fe619f9b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project-lite/0.2.16/download"],
        strip_prefix = "pin-project-lite-0.2.16",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.pin-project-lite-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__pin-utils-0.1.0",
        sha256 = "8b870d8c151b6f2fb93e84a13146138f05d02ed11c7e7c54f8826aaaf7c9f184",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-utils/0.1.0/download"],
        strip_prefix = "pin-utils-0.1.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.pin-utils-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__proc-macro2-1.0.92",
        sha256 = "37d3544b3f2748c54e147655edb5025752e2303145b5aefb3c3ea2c78b973bb0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.92/download"],
        strip_prefix = "proc-macro2-1.0.92",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.proc-macro2-1.0.92.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__quote-1.0.38",
        sha256 = "0e4dccaaaf89514f546c693ddc140f729f958c247918a13380cccc6078391acc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.38/download"],
        strip_prefix = "quote-1.0.38",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.quote-1.0.38.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__redox_syscall-0.5.8",
        sha256 = "03a862b389f93e68874fbf580b9de08dd02facb9a788ebadaf4a3fd33cf58834",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/redox_syscall/0.5.8/download"],
        strip_prefix = "redox_syscall-0.5.8",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.redox_syscall-0.5.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__rustc-demangle-0.1.24",
        sha256 = "719b953e2095829ee67db738b3bfa9fa368c94900df327b3f07fe6e794d2fe1f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-demangle/0.1.24/download"],
        strip_prefix = "rustc-demangle-0.1.24",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.rustc-demangle-0.1.24.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__ryu-1.0.18",
        sha256 = "f3cb5ba0dc43242ce17de99c180e96db90b235b8a9fdc9543c96d2209116bd9f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ryu/1.0.18/download"],
        strip_prefix = "ryu-1.0.18",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.ryu-1.0.18.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__scopeguard-1.2.0",
        sha256 = "94143f37725109f92c262ed2cf5e59bce7498c01bcc1502d7b9afe439a4e9f49",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scopeguard/1.2.0/download"],
        strip_prefix = "scopeguard-1.2.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.scopeguard-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde-1.0.217",
        sha256 = "02fc4265df13d6fa1d00ecff087228cc0a2b5f3c0e87e258d8b94a156e984c70",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.217/download"],
        strip_prefix = "serde-1.0.217",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.serde-1.0.217.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde_derive-1.0.217",
        sha256 = "5a9bf7cf98d04a2b28aead066b7496853d4779c9cc183c440dbac457641e19a0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.217/download"],
        strip_prefix = "serde_derive-1.0.217",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.serde_derive-1.0.217.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde_json-1.0.135",
        sha256 = "2b0d7ba2887406110130a978386c4e1befb98c674b4fba677954e4db976630d9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_json/1.0.135/download"],
        strip_prefix = "serde_json-1.0.135",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.serde_json-1.0.135.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__serde_urlencoded-0.7.1",
        sha256 = "d3491c14715ca2294c4d6a88f15e84739788c1d030eed8c110436aafdaa2f3fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_urlencoded/0.7.1/download"],
        strip_prefix = "serde_urlencoded-0.7.1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.serde_urlencoded-0.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__sharded-slab-0.1.7",
        sha256 = "f40ca3c46823713e0d4209592e8d6e826aa57e928f09752619fc696c499637f6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sharded-slab/0.1.7/download"],
        strip_prefix = "sharded-slab-0.1.7",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.sharded-slab-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__signal-hook-registry-1.4.2",
        sha256 = "a9e9e0b4211b72e7b8b6e85c807d36c212bdb33ea8587f7569562a84df5465b1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/signal-hook-registry/1.4.2/download"],
        strip_prefix = "signal-hook-registry-1.4.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.signal-hook-registry-1.4.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__slab-0.4.9",
        sha256 = "8f92a496fb766b417c996b9c5e57daf2f7ad3b0bebe1ccfca4856390e3d3bb67",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/slab/0.4.9/download"],
        strip_prefix = "slab-0.4.9",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.slab-0.4.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__smallvec-1.13.2",
        sha256 = "3c5e1a9a646d36c3599cd173a41282daf47c44583ad367b8e6837255952e5c67",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/1.13.2/download"],
        strip_prefix = "smallvec-1.13.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.smallvec-1.13.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__socket2-0.4.10",
        sha256 = "9f7916fc008ca5542385b89a3d3ce689953c143e9304a9bf8beec1de48994c0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/socket2/0.4.10/download"],
        strip_prefix = "socket2-0.4.10",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.socket2-0.4.10.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__socket2-0.5.8",
        sha256 = "c970269d99b64e60ec3bd6ad27270092a5394c4e309314b18ae3fe575695fbe8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/socket2/0.5.8/download"],
        strip_prefix = "socket2-0.5.8",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.socket2-0.5.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__syn-2.0.95",
        sha256 = "46f71c0377baf4ef1cc3e3402ded576dccc315800fbc62dfc7fe04b009773b4a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.95/download"],
        strip_prefix = "syn-2.0.95",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.syn-2.0.95.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__sync_wrapper-0.1.2",
        sha256 = "2047c6ded9c721764247e62cd3b03c09ffc529b2ba5b10ec482ae507a4a70160",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sync_wrapper/0.1.2/download"],
        strip_prefix = "sync_wrapper-0.1.2",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.sync_wrapper-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__thread_local-1.1.8",
        sha256 = "8b9ef9bad013ada3808854ceac7b46812a6465ba368859a37e2100283d2d719c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thread_local/1.1.8/download"],
        strip_prefix = "thread_local-1.1.8",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.thread_local-1.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-1.43.0",
        sha256 = "3d61fa4ffa3de412bfea335c6ecff681de2b609ba3c77ef3e00e521813a9ed9e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio/1.43.0/download"],
        strip_prefix = "tokio-1.43.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tokio-1.43.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-macros-2.5.0",
        sha256 = "6e06d43f1345a3bcd39f6a56dbb7dcab2ba47e68e8ac134855e7e2bdbaf8cab8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-macros/2.5.0/download"],
        strip_prefix = "tokio-macros-2.5.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tokio-macros-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tokio-util-0.7.13",
        sha256 = "d7fcaa8d55a2bdd6b83ace262b016eca0d79ee02818c5c1bcdf0305114081078",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-util/0.7.13/download"],
        strip_prefix = "tokio-util-0.7.13",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tokio-util-0.7.13.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-0.4.13",
        sha256 = "b8fa9be0de6cf49e536ce1851f987bd21a43b771b09473c3549a6c853db37c1c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tower/0.4.13/download"],
        strip_prefix = "tower-0.4.13",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tower-0.4.13.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-http-0.2.5",
        sha256 = "aba3f3efabf7fb41fae8534fc20a817013dd1c12cb45441efb6c82e6556b4cd8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tower-http/0.2.5/download"],
        strip_prefix = "tower-http-0.2.5",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tower-http-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-layer-0.3.3",
        sha256 = "121c2a6cda46980bb0fcd1647ffaf6cd3fc79a013de288782836f6df9c48780e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tower-layer/0.3.3/download"],
        strip_prefix = "tower-layer-0.3.3",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tower-layer-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tower-service-0.3.3",
        sha256 = "8df9b6e13f2d32c91b9bd719c00d1958837bc7dec474d94952798cc8e69eeec3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tower-service/0.3.3/download"],
        strip_prefix = "tower-service-0.3.3",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tower-service-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-0.1.41",
        sha256 = "784e0ac535deb450455cbfa28a6f0df145ea1bb7ae51b821cf5e7927fdcfbdd0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing/0.1.41/download"],
        strip_prefix = "tracing-0.1.41",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tracing-0.1.41.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-attributes-0.1.28",
        sha256 = "395ae124c09f9e6918a2310af6038fba074bcf474ac352496d5910dd59a2226d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-attributes/0.1.28/download"],
        strip_prefix = "tracing-attributes-0.1.28",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tracing-attributes-0.1.28.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-core-0.1.33",
        sha256 = "e672c95779cf947c5311f83787af4fa8fffd12fb27e4993211a84bdfd9610f9c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-core/0.1.33/download"],
        strip_prefix = "tracing-core-0.1.33",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tracing-core-0.1.33.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-log-0.2.0",
        sha256 = "ee855f1f400bd0e5c02d150ae5de3840039a3f54b025156404e34c23c03f47c3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-log/0.2.0/download"],
        strip_prefix = "tracing-log-0.2.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tracing-log-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__tracing-subscriber-0.3.19",
        sha256 = "e8189decb5ac0fa7bc8b96b7cb9b2701d60d48805aca84a238004d665fcc4008",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-subscriber/0.3.19/download"],
        strip_prefix = "tracing-subscriber-0.3.19",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.tracing-subscriber-0.3.19.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__try-lock-0.2.5",
        sha256 = "e421abadd41a4225275504ea4d6566923418b7f05506fbc9c0fe86ba7396114b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/try-lock/0.2.5/download"],
        strip_prefix = "try-lock-0.2.5",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.try-lock-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__unicode-ident-1.0.14",
        sha256 = "adb9e6ca4f869e1180728b7950e35922a7fc6397f7b641499e8f3ef06e50dc83",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.14/download"],
        strip_prefix = "unicode-ident-1.0.14",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.unicode-ident-1.0.14.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__valuable-0.1.0",
        sha256 = "830b7e5d4d90034032940e4ace0d9a9a057e7a45cd94e6c007832e39edb82f6d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/valuable/0.1.0/download"],
        strip_prefix = "valuable-0.1.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.valuable-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__want-0.3.1",
        sha256 = "bfa7760aed19e106de2c7c0b581b509f2f25d3dacaf737cb82ac61bc6d760b0e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/want/0.3.1/download"],
        strip_prefix = "want-0.3.1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.want-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__wasi-0.11.0-wasi-snapshot-preview1",
        sha256 = "9c8d87e72b64a3b4db28d11ce29237c246188f4f51057d65a7eab63b7987e423",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasi/0.11.0+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.0+wasi-snapshot-preview1",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.wasi-0.11.0+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows-sys-0.52.0",
        sha256 = "282be5f36a8ce781fad8c8ae18fa3f9beff57ec1b52cb3de0789201425d9a33d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.52.0/download"],
        strip_prefix = "windows-sys-0.52.0",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows-sys-0.52.0.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows-targets-0.52.6",
        sha256 = "9b724f72796e036ab90c1021d4780d4d3d648aca59e491e6b98e725b84e99973",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.52.6/download"],
        strip_prefix = "windows-targets-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows-targets-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_aarch64_gnullvm-0.52.6",
        sha256 = "32a4622180e7a0ec044bb555404c800bc9fd9ec262ec147edd5989ccd0c02cd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows_aarch64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_aarch64_msvc-0.52.6",
        sha256 = "09ec2a7bb152e2252b53fa7803150007879548bc709c039df7627cabbd05d469",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.52.6/download"],
        strip_prefix = "windows_aarch64_msvc-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows_aarch64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_i686_gnu-0.52.6",
        sha256 = "8e9b5ad5ab802e97eb8e295ac6720e509ee4c243f69d781394014ebfe8bbfa0b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.52.6/download"],
        strip_prefix = "windows_i686_gnu-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows_i686_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_i686_gnullvm-0.52.6",
        sha256 = "0eee52d38c090b3caa76c563b86c3a4bd71ef1a819287c19d586d7334ae8ed66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.52.6/download"],
        strip_prefix = "windows_i686_gnullvm-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows_i686_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_i686_msvc-0.52.6",
        sha256 = "240948bc05c5e7c6dabba28bf89d89ffce3e303022809e73deaefe4f6ec56c66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.52.6/download"],
        strip_prefix = "windows_i686_msvc-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows_i686_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_x86_64_gnu-0.52.6",
        sha256 = "147a5c80aabfbf0c7d901cb5895d1de30ef2907eb21fbbab29ca94c5b08b1a78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnu-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows_x86_64_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_x86_64_gnullvm-0.52.6",
        sha256 = "24d5b23dc417412679681396f2b49f3de8c1473deb516bd34410872eff51ed0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows_x86_64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "crates_vendor_pkgs__windows_x86_64_msvc-0.52.6",
        sha256 = "589f6da84c646204747d1270a2a5661ea66ed1cced2631d546fdfb155959f9ec",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.52.6/download"],
        strip_prefix = "windows_x86_64_msvc-0.52.6",
        build_file = Label("//vendor_remote_pkgs/crates:BUILD.windows_x86_64_msvc-0.52.6.bazel"),
    )

    return [
        struct(repo = "crates_vendor_pkgs__axum-0.4.8", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__hyper-0.14.32", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__mime-0.3.17", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__serde_json-1.0.135", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__socket2-0.4.10", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__tokio-1.43.0", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__tower-0.4.13", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__tower-http-0.2.5", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__tracing-0.1.41", is_dev_dep = False),
        struct(repo = "crates_vendor_pkgs__tracing-subscriber-0.3.19", is_dev_dep = False),
    ]
