###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//vendor_remote_manifests:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
            "serde_yaml": Label("@cvm//:serde_yaml-0.9.34+deprecated"),
            "tokio": Label("@cvm//:tokio-1.48.0"),
        },
    },
}

_NORMAL_ALIASES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
            "tempfile": Label("@cvm//:tempfile-3.23.0"),
            "tokio-test": Label("@cvm//:tokio-test-0.4.4"),
        },
    },
}

_NORMAL_DEV_ALIASES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
        },
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "vendor_remote_manifests": {
    },
}

_PROC_MACRO_ALIASES = {
    "vendor_remote_manifests": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "vendor_remote_manifests": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
        },
    },
}

_BUILD_DEPENDENCIES = {
    "vendor_remote_manifests": {
    },
}

_BUILD_ALIASES = {
    "vendor_remote_manifests": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "vendor_remote_manifests": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "vendor_remote_manifests": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"arm64ec\"), target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(any(target_os = \"linux\"), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "cfg(all(any(target_os = \"linux\", target_os = \"android\"), not(any(all(target_os = \"linux\", target_env = \"\"), getrandom_backend = \"custom\", getrandom_backend = \"linux_raw\", getrandom_backend = \"rdrand\", getrandom_backend = \"rndr\"))))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(rustix_use_libc), not(miri), target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"))))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(windows), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"wasm32\", target_os = \"wasi\", target_env = \"p2\"))": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(target_os = \"uefi\", getrandom_backend = \"efi_rng\"))": [],
    "cfg(any())": [],
    "cfg(any(target_os = \"dragonfly\", target_os = \"freebsd\", target_os = \"hurd\", target_os = \"illumos\", target_os = \"cygwin\", all(target_os = \"horizon\", target_arch = \"arm\")))": ["@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(target_os = \"haiku\", target_os = \"redox\", target_os = \"nto\", target_os = \"aix\"))": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "cfg(any(target_os = \"ios\", target_os = \"visionos\", target_os = \"watchos\", target_os = \"tvos\"))": ["@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(any(target_os = \"macos\", target_os = \"openbsd\", target_os = \"vita\", target_os = \"emscripten\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin"],
    "cfg(any(unix, target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"netbsd\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"solaris\")": [],
    "cfg(target_os = \"vxworks\")": [],
    "cfg(target_os = \"wasi\")": ["@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(windows_raw_dylib)": [],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnullvm": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "cvm__async-stream-0.3.6",
        sha256 = "0b5a71a6f37880a80d1d7f19efd781e4b5de42c88f0722cc13bcb6cc2cfe8476",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/async-stream/0.3.6/download"],
        strip_prefix = "async-stream-0.3.6",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.async-stream-0.3.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__async-stream-impl-0.3.6",
        sha256 = "c7c24de15d275a1ecfd47a380fb4d5ec9bfe0933f309ed5e705b775596a3574d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/async-stream-impl/0.3.6/download"],
        strip_prefix = "async-stream-impl-0.3.6",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.async-stream-impl-0.3.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__bitflags-2.10.0",
        sha256 = "812e12b5285cc515a9c72a5c1d3b6d46a19dac5acfef5265968c166106e31dd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/2.10.0/download"],
        strip_prefix = "bitflags-2.10.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.bitflags-2.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__bytes-1.11.0",
        sha256 = "b35204fbdc0b3f4446b89fc1ac2cf84a8a68971995d0bf2e925ec7cd960f9cb3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bytes/1.11.0/download"],
        strip_prefix = "bytes-1.11.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.bytes-1.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__cfg-if-1.0.4",
        sha256 = "9330f8b2ff13f34540b44e946ef35111825727b38d33286ef986142615121801",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.4/download"],
        strip_prefix = "cfg-if-1.0.4",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.cfg-if-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__equivalent-1.0.2",
        sha256 = "877a4ace8713b0bcf2a4e7eec82529c029f1d0619886d18145fea96c3ffe5c0f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/equivalent/1.0.2/download"],
        strip_prefix = "equivalent-1.0.2",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.equivalent-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__errno-0.3.14",
        sha256 = "39cab71617ae0d63f51a36d69f866391735b51691dbda63cf6f96d042b63efeb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/errno/0.3.14/download"],
        strip_prefix = "errno-0.3.14",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.errno-0.3.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__fastrand-2.3.0",
        sha256 = "37909eebbb50d72f9059c3b6d82c0463f2ff062c9e95845c43a6c9c0355411be",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fastrand/2.3.0/download"],
        strip_prefix = "fastrand-2.3.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.fastrand-2.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__futures-core-0.3.31",
        sha256 = "05f29059c0c2090612e8d742178b0580d2dc940c837851ad723096f87af6663e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/futures-core/0.3.31/download"],
        strip_prefix = "futures-core-0.3.31",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.futures-core-0.3.31.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__getrandom-0.3.4",
        sha256 = "899def5c37c4fd7b2664648c28120ecec138e4d395b459e5ca34f9cce2dd77fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/getrandom/0.3.4/download"],
        strip_prefix = "getrandom-0.3.4",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.getrandom-0.3.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__hashbrown-0.16.0",
        sha256 = "5419bdc4f6a9207fbeba6d11b604d481addf78ecd10c11ad51e76c2f6482748d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.16.0/download"],
        strip_prefix = "hashbrown-0.16.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.hashbrown-0.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__indexmap-2.12.0",
        sha256 = "6717a8d2a5a929a1a2eb43a12812498ed141a0bcfb7e8f7844fbdbe4303bba9f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/2.12.0/download"],
        strip_prefix = "indexmap-2.12.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.indexmap-2.12.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__itoa-1.0.15",
        sha256 = "4a5f13b858c8d314ee3e8f639011f7ccefe71f97f96e50151fb991f267928e2c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itoa/1.0.15/download"],
        strip_prefix = "itoa-1.0.15",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.itoa-1.0.15.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__libc-0.2.177",
        sha256 = "2874a2af47a2325c2001a6e6fad9b16a53b802102b528163885171cf92b15976",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.177/download"],
        strip_prefix = "libc-0.2.177",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.libc-0.2.177.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__linux-raw-sys-0.11.0",
        sha256 = "df1d3c3b53da64cf5760482273a98e575c651a67eec7f77df96b5b642de8f039",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/linux-raw-sys/0.11.0/download"],
        strip_prefix = "linux-raw-sys-0.11.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.linux-raw-sys-0.11.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__lock_api-0.4.14",
        sha256 = "224399e74b87b5f3557511d98dff8b14089b3dadafcab6bb93eab67d3aace965",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lock_api/0.4.14/download"],
        strip_prefix = "lock_api-0.4.14",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.lock_api-0.4.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__mio-1.1.0",
        sha256 = "69d83b0086dc8ecf3ce9ae2874b2d1290252e2a30720bea58a5c6639b0092873",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/mio/1.1.0/download"],
        strip_prefix = "mio-1.1.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.mio-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__once_cell-1.21.3",
        sha256 = "42f5e15c9953c5e4ccceeb2e7382a716482c34515315f7b03532b8b4e8393d2d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.21.3/download"],
        strip_prefix = "once_cell-1.21.3",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.once_cell-1.21.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__parking_lot-0.12.5",
        sha256 = "93857453250e3077bd71ff98b6a65ea6621a19bb0f559a85248955ac12c45a1a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot/0.12.5/download"],
        strip_prefix = "parking_lot-0.12.5",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.parking_lot-0.12.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__parking_lot_core-0.9.12",
        sha256 = "2621685985a2ebf1c516881c026032ac7deafcda1a2c9b7850dc81e3dfcb64c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot_core/0.9.12/download"],
        strip_prefix = "parking_lot_core-0.9.12",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.parking_lot_core-0.9.12.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__pin-project-lite-0.2.16",
        sha256 = "3b3cff922bd51709b605d9ead9aa71031d81447142d828eb4a6eba76fe619f9b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project-lite/0.2.16/download"],
        strip_prefix = "pin-project-lite-0.2.16",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.pin-project-lite-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__proc-macro2-1.0.103",
        sha256 = "5ee95bc4ef87b8d5ba32e8b7714ccc834865276eab0aed5c9958d00ec45f49e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.103/download"],
        strip_prefix = "proc-macro2-1.0.103",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.proc-macro2-1.0.103.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__quote-1.0.42",
        sha256 = "a338cc41d27e6cc6dce6cefc13a0729dfbb81c262b1f519331575dd80ef3067f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.42/download"],
        strip_prefix = "quote-1.0.42",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.quote-1.0.42.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__r-efi-5.3.0",
        sha256 = "69cdb34c158ceb288df11e18b4bd39de994f6657d83847bdffdbd7f346754b0f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/r-efi/5.3.0/download"],
        strip_prefix = "r-efi-5.3.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.r-efi-5.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__redox_syscall-0.5.18",
        sha256 = "ed2bf2547551a7053d6fdfafda3f938979645c44812fbfcda098faae3f1a362d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/redox_syscall/0.5.18/download"],
        strip_prefix = "redox_syscall-0.5.18",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.redox_syscall-0.5.18.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__rustix-1.1.2",
        sha256 = "cd15f8a2c5551a84d56efdc1cd049089e409ac19a3072d5037a17fd70719ff3e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustix/1.1.2/download"],
        strip_prefix = "rustix-1.1.2",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.rustix-1.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__ryu-1.0.20",
        sha256 = "28d3b2b1366ec20994f1fd18c3c594f05c5dd4bc44d8bb0c1c632c8d6829481f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ryu/1.0.20/download"],
        strip_prefix = "ryu-1.0.20",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.ryu-1.0.20.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__scopeguard-1.2.0",
        sha256 = "94143f37725109f92c262ed2cf5e59bce7498c01bcc1502d7b9afe439a4e9f49",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scopeguard/1.2.0/download"],
        strip_prefix = "scopeguard-1.2.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.scopeguard-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__serde-1.0.228",
        sha256 = "9a8e94ea7f378bd32cbbd37198a4a91436180c5bb472411e48b5ec2e2124ae9e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.228/download"],
        strip_prefix = "serde-1.0.228",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.serde-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__serde_core-1.0.228",
        sha256 = "41d385c7d4ca58e59fc732af25c3983b67ac852c1a25000afe1175de458b67ad",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_core/1.0.228/download"],
        strip_prefix = "serde_core-1.0.228",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.serde_core-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__serde_derive-1.0.228",
        sha256 = "d540f220d3187173da220f885ab66608367b6574e925011a9353e4badda91d79",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.228/download"],
        strip_prefix = "serde_derive-1.0.228",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.serde_derive-1.0.228.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__serde_yaml-0.9.34-deprecated",
        sha256 = "6a8b1a1a2ebf674015cc02edccce75287f1a0130d394307b36743c2f5d504b47",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_yaml/0.9.34+deprecated/download"],
        strip_prefix = "serde_yaml-0.9.34+deprecated",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.serde_yaml-0.9.34+deprecated.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__signal-hook-registry-1.4.6",
        sha256 = "b2a4719bff48cee6b39d12c020eeb490953ad2443b7055bd0b21fca26bd8c28b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/signal-hook-registry/1.4.6/download"],
        strip_prefix = "signal-hook-registry-1.4.6",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.signal-hook-registry-1.4.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__smallvec-1.15.1",
        sha256 = "67b1b7a3b5fe4f1376887184045fcf45c69e92af734b7aaddc05fb777b6fbd03",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/1.15.1/download"],
        strip_prefix = "smallvec-1.15.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.smallvec-1.15.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__socket2-0.6.1",
        sha256 = "17129e116933cf371d018bb80ae557e889637989d8638274fb25622827b03881",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/socket2/0.6.1/download"],
        strip_prefix = "socket2-0.6.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.socket2-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__syn-2.0.110",
        sha256 = "a99801b5bd34ede4cf3fc688c5919368fea4e4814a4664359503e6015b280aea",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.110/download"],
        strip_prefix = "syn-2.0.110",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.syn-2.0.110.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tempfile-3.23.0",
        sha256 = "2d31c77bdf42a745371d260a26ca7163f1e0924b64afa0b688e61b5a9fa02f16",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tempfile/3.23.0/download"],
        strip_prefix = "tempfile-3.23.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.tempfile-3.23.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tokio-1.48.0",
        sha256 = "ff360e02eab121e0bc37a2d3b4d4dc622e6eda3a8e5253d5435ecf5bd4c68408",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio/1.48.0/download"],
        strip_prefix = "tokio-1.48.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.tokio-1.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tokio-macros-2.6.0",
        sha256 = "af407857209536a95c8e56f8231ef2c2e2aff839b22e07a1ffcbc617e9db9fa5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-macros/2.6.0/download"],
        strip_prefix = "tokio-macros-2.6.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.tokio-macros-2.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tokio-stream-0.1.17",
        sha256 = "eca58d7bba4a75707817a2c44174253f9236b2d5fbd055602e9d5c07c139a047",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-stream/0.1.17/download"],
        strip_prefix = "tokio-stream-0.1.17",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.tokio-stream-0.1.17.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tokio-test-0.4.4",
        sha256 = "2468baabc3311435b55dd935f702f42cd1b8abb7e754fb7dfb16bd36aa88f9f7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tokio-test/0.4.4/download"],
        strip_prefix = "tokio-test-0.4.4",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.tokio-test-0.4.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__unicode-ident-1.0.22",
        sha256 = "9312f7c4f6ff9069b165498234ce8be658059c6728633667c526e27dc2cf1df5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.22/download"],
        strip_prefix = "unicode-ident-1.0.22",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.unicode-ident-1.0.22.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__unsafe-libyaml-0.2.11",
        sha256 = "673aac59facbab8a9007c7f6108d11f63b603f7cabff99fabf650fea5c32b861",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unsafe-libyaml/0.2.11/download"],
        strip_prefix = "unsafe-libyaml-0.2.11",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.unsafe-libyaml-0.2.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__wasi-0.11.1-wasi-snapshot-preview1",
        sha256 = "ccf3ec651a847eb01de73ccad15eb7d99f80485de043efb2f370cd654f4ea44b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasi/0.11.1+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.1+wasi-snapshot-preview1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.wasi-0.11.1+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__wasip2-1.0.1-wasi-0.2.4",
        sha256 = "0562428422c63773dad2c345a1882263bbf4d65cf3f42e90921f787ef5ad58e7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasip2/1.0.1+wasi-0.2.4/download"],
        strip_prefix = "wasip2-1.0.1+wasi-0.2.4",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.wasip2-1.0.1+wasi-0.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows-link-0.2.1",
        sha256 = "f0805222e57f7521d6a62e36fa9163bc891acd422f971defe97d64e70d0a4fe5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-link/0.2.1/download"],
        strip_prefix = "windows-link-0.2.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows-link-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows-sys-0.60.2",
        sha256 = "f2f500e4d28234f72040990ec9d39e3a6b950f9f22d3dba18416c35882612bcb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.60.2/download"],
        strip_prefix = "windows-sys-0.60.2",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows-sys-0.60.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows-sys-0.61.2",
        sha256 = "ae137229bcbd6cdf0f7b80a31df61766145077ddf49416a728b02cb3921ff3fc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.61.2/download"],
        strip_prefix = "windows-sys-0.61.2",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows-sys-0.61.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows-targets-0.53.5",
        sha256 = "4945f9f551b88e0d65f3db0bc25c33b8acea4d9e41163edf90dcd0b19f9069f3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.53.5/download"],
        strip_prefix = "windows-targets-0.53.5",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows-targets-0.53.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_aarch64_gnullvm-0.53.1",
        sha256 = "a9d8416fa8b42f5c947f8482c43e7d89e73a173cead56d044f6a56104a6d1b53",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.53.1/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.53.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows_aarch64_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_aarch64_msvc-0.53.1",
        sha256 = "b9d782e804c2f632e395708e99a94275910eb9100b2114651e04744e9b125006",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.53.1/download"],
        strip_prefix = "windows_aarch64_msvc-0.53.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows_aarch64_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_i686_gnu-0.53.1",
        sha256 = "960e6da069d81e09becb0ca57a65220ddff016ff2d6af6a223cf372a506593a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.53.1/download"],
        strip_prefix = "windows_i686_gnu-0.53.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows_i686_gnu-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_i686_gnullvm-0.53.1",
        sha256 = "fa7359d10048f68ab8b09fa71c3daccfb0e9b559aed648a8f95469c27057180c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.53.1/download"],
        strip_prefix = "windows_i686_gnullvm-0.53.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows_i686_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_i686_msvc-0.53.1",
        sha256 = "1e7ac75179f18232fe9c285163565a57ef8d3c89254a30685b57d83a38d326c2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.53.1/download"],
        strip_prefix = "windows_i686_msvc-0.53.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows_i686_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_x86_64_gnu-0.53.1",
        sha256 = "9c3842cdd74a865a8066ab39c8a7a473c0778a3f29370b5fd6b4b9aa7df4a499",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.53.1/download"],
        strip_prefix = "windows_x86_64_gnu-0.53.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows_x86_64_gnu-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_x86_64_gnullvm-0.53.1",
        sha256 = "0ffa179e2d07eee8ad8f57493436566c7cc30ac536a3379fdf008f47f6bb7ae1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.53.1/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.53.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows_x86_64_gnullvm-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_x86_64_msvc-0.53.1",
        sha256 = "d6bbff5f0aada427a1e5a6da5f1f98158182f26556f345ac9e04d36d0ebed650",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.53.1/download"],
        strip_prefix = "windows_x86_64_msvc-0.53.1",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.windows_x86_64_msvc-0.53.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__wit-bindgen-0.46.0",
        sha256 = "f17a85883d4e6d00e8a97c586de764dabcc06133f7f1d55dce5cdc070ad7fe59",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wit-bindgen/0.46.0/download"],
        strip_prefix = "wit-bindgen-0.46.0",
        build_file = Label("//vendor_remote_manifests/crates:BUILD.wit-bindgen-0.46.0.bazel"),
    )

    return [
        struct(repo = "cvm__serde_yaml-0.9.34-deprecated", is_dev_dep = False),
        struct(repo = "cvm__tokio-1.48.0", is_dev_dep = False),
        struct(repo = "cvm__tempfile-3.23.0", is_dev_dep = True),
        struct(repo = "cvm__tokio-test-0.4.4", is_dev_dep = True),
    ]
