"""A generate file containing all source files used to produce `cargo-bazel`"""

# Each source file is tracked as a target so the `cargo_bootstrap_repository`
# rule will know to automatically rebuild if any of the sources changed.

# Run 'bazel run //crate_universe/private:srcs_module.install' to regenerate.

CARGO_BAZEL_SRCS = [
    Label("//crate_universe:src/api.rs"),
    Label("//crate_universe:src/api/lockfile.rs"),
    Label("//crate_universe:src/cli.rs"),
    Label("//crate_universe:src/cli/generate.rs"),
    Label("//crate_universe:src/cli/query.rs"),
    Label("//crate_universe:src/cli/render.rs"),
    Label("//crate_universe:src/cli/splice.rs"),
    Label("//crate_universe:src/cli/vendor.rs"),
    Label("//crate_universe:src/config.rs"),
    Label("//crate_universe:src/context.rs"),
    Label("//crate_universe:src/context/crate_context.rs"),
    Label("//crate_universe:src/context/platforms.rs"),
    Label("//crate_universe:src/lib.rs"),
    Label("//crate_universe:src/lockfile.rs"),
    Label("//crate_universe:src/main.rs"),
    Label("//crate_universe:src/metadata.rs"),
    Label("//crate_universe:src/metadata/cargo_bin.rs"),
    Label("//crate_universe:src/metadata/cargo_tree_resolver.rs"),
    Label("//crate_universe:src/metadata/cargo_tree_rustc_wrapper.bat"),
    Label("//crate_universe:src/metadata/cargo_tree_rustc_wrapper.sh"),
    Label("//crate_universe:src/metadata/dependency.rs"),
    Label("//crate_universe:src/metadata/metadata_annotation.rs"),
    Label("//crate_universe:src/rendering.rs"),
    Label("//crate_universe:src/rendering/template_engine.rs"),
    Label("//crate_universe:src/rendering/templates/module_bzl.j2"),
    Label("//crate_universe:src/rendering/templates/partials/header.j2"),
    Label("//crate_universe:src/rendering/templates/partials/module/aliases_map.j2"),
    Label("//crate_universe:src/rendering/templates/partials/module/deps_map.j2"),
    Label("//crate_universe:src/rendering/templates/partials/module/repo_git.j2"),
    Label("//crate_universe:src/rendering/templates/partials/module/repo_http.j2"),
    Label("//crate_universe:src/rendering/templates/vendor_module.j2"),
    Label("//crate_universe:src/rendering/verbatim/alias_rules.bzl"),
    Label("//crate_universe:src/select.rs"),
    Label("//crate_universe:src/splicing.rs"),
    Label("//crate_universe:src/splicing/cargo_config.rs"),
    Label("//crate_universe:src/splicing/crate_index_lookup.rs"),
    Label("//crate_universe:src/splicing/splicer.rs"),
    Label("//crate_universe:src/test.rs"),
    Label("//crate_universe:src/utils.rs"),
    Label("//crate_universe:src/utils/starlark.rs"),
    Label("//crate_universe:src/utils/starlark/glob.rs"),
    Label("//crate_universe:src/utils/starlark/label.rs"),
    Label("//crate_universe:src/utils/starlark/select.rs"),
    Label("//crate_universe:src/utils/starlark/select_dict.rs"),
    Label("//crate_universe:src/utils/starlark/select_list.rs"),
    Label("//crate_universe:src/utils/starlark/select_scalar.rs"),
    Label("//crate_universe:src/utils/starlark/select_set.rs"),
    Label("//crate_universe:src/utils/starlark/serialize.rs"),
    Label("//crate_universe:src/utils/starlark/target_compatible_with.rs"),
    Label("//crate_universe:src/utils/symlink.rs"),
    Label("//crate_universe:src/utils/target_triple.rs"),
]
