###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//crate_universe/3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "crate_universe": {
        _COMMON_CONDITION: {
            "anyhow": Label("@cui//:anyhow-1.0.98"),
            "camino": Label("@cui//:camino-1.1.9"),
            "cargo-lock": Label("@cui//:cargo-lock-10.1.0"),
            "cargo-platform": Label("@cui//:cargo-platform-0.1.9"),
            "cargo_metadata": Label("@cui//:cargo_metadata-0.19.2"),
            "cargo_toml": Label("@cui//:cargo_toml-0.22.1"),
            "cfg-expr": Label("@cui//:cfg-expr-0.18.0"),
            "clap": Label("@cui//:clap-4.5.37"),
            "crates-index": Label("@cui//:crates-index-3.7.0"),
            "glob": Label("@cui//:glob-0.3.2"),
            "hex": Label("@cui//:hex-0.4.3"),
            "itertools": Label("@cui//:itertools-0.14.0"),
            "normpath": Label("@cui//:normpath-1.3.0"),
            "once_cell": Label("@cui//:once_cell-1.21.3"),
            "pathdiff": Label("@cui//:pathdiff-0.2.3"),
            "regex": Label("@cui//:regex-1.11.1"),
            "semver": Label("@cui//:semver-1.0.26"),
            "serde": Label("@cui//:serde-1.0.219"),
            "serde_json": Label("@cui//:serde_json-1.0.140"),
            "serde_starlark": Label("@cui//:serde_starlark-0.1.17"),
            "sha2": Label("@cui//:sha2-0.10.8"),
            "spdx": Label("@cui//:spdx-0.10.8"),
            "tempfile": Label("@cui//:tempfile-3.19.1"),
            "tera": Label("@cui//:tera-1.20.0"),
            "textwrap": Label("@cui//:textwrap-0.16.2"),
            "toml": Label("@cui//:toml-0.8.21"),
            "tracing": Label("@cui//:tracing-0.1.41"),
            "tracing-subscriber": Label("@cui//:tracing-subscriber-0.3.19"),
            "url": Label("@cui//:url-2.5.4"),
            "walkdir": Label("@cui//:walkdir-2.5.0"),
        },
    },
    "crate_universe/tools/cross_installer": {
        _COMMON_CONDITION: {
            "clap": Label("@cui//:clap-4.5.37"),
        },
    },
    "crate_universe/tools/urls_generator": {
        _COMMON_CONDITION: {
            "clap": Label("@cui//:clap-4.5.37"),
            "hex": Label("@cui//:hex-0.4.3"),
            "serde_json": Label("@cui//:serde_json-1.0.140"),
            "sha2": Label("@cui//:sha2-0.10.8"),
        },
    },
}

_NORMAL_ALIASES = {
    "crate_universe": {
        _COMMON_CONDITION: {
        },
    },
    "crate_universe/tools/cross_installer": {
        _COMMON_CONDITION: {
        },
    },
    "crate_universe/tools/urls_generator": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "crate_universe": {
        _COMMON_CONDITION: {
            "maplit": Label("@cui//:maplit-1.0.2"),
        },
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_NORMAL_DEV_ALIASES = {
    "crate_universe": {
        _COMMON_CONDITION: {
        },
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "crate_universe": {
        _COMMON_CONDITION: {
            "indoc": Label("@cui//:indoc-2.0.6"),
        },
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_PROC_MACRO_ALIASES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "crate_universe": {
        _COMMON_CONDITION: {
        },
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_BUILD_DEPENDENCIES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_BUILD_ALIASES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "crate_universe": {
    },
    "crate_universe/tools/cross_installer": {
    },
    "crate_universe/tools/urls_generator": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-gnullvm": [],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"arm64ec\"), target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(any(target_os = \"android\", target_os = \"linux\"), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android"],
    "cfg(all(any(target_os = \"android\", target_os = \"linux\"), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", target_arch = \"s390x\"), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android"],
    "cfg(all(any(target_os = \"linux\", target_os = \"android\"), not(any(all(target_os = \"linux\", target_env = \"\"), getrandom_backend = \"custom\", getrandom_backend = \"linux_raw\", getrandom_backend = \"rdrand\", getrandom_backend = \"rndr\"))))": ["@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(rustix_use_libc), not(miri), target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"))))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(rustix_use_libc), not(miri), target_os = \"linux\", any(target_endian = \"little\", target_arch = \"s390x\"), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"))))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(not(windows), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", any(target_arch = \"s390x\", target_arch = \"powerpc\")), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc\"), all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(all(not(windows), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_endian = \"little\", target_arch = \"s390x\"), any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"riscv64\", all(rustix_use_experimental_asm, target_arch = \"powerpc64\"), all(rustix_use_experimental_asm, target_arch = \"s390x\"), all(rustix_use_experimental_asm, target_arch = \"mips\"), all(rustix_use_experimental_asm, target_arch = \"mips32r6\"), all(rustix_use_experimental_asm, target_arch = \"mips64\"), all(rustix_use_experimental_asm, target_arch = \"mips64r6\"), target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\")))))))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"aarch64\", target_os = \"linux\"))": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "cfg(all(target_arch = \"aarch64\", target_vendor = \"apple\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "cfg(all(target_arch = \"wasm32\", target_os = \"wasi\", target_env = \"p2\"))": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(all(target_os = \"uefi\", getrandom_backend = \"efi_rng\"))": [],
    "cfg(any())": [],
    "cfg(any(target_arch = \"aarch64\", target_arch = \"x86_64\", target_arch = \"x86\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(any(target_os = \"dragonfly\", target_os = \"freebsd\", target_os = \"hurd\", target_os = \"illumos\", target_os = \"cygwin\", all(target_os = \"horizon\", target_arch = \"arm\")))": ["@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "cfg(any(target_os = \"haiku\", target_os = \"redox\", target_os = \"nto\", target_os = \"aix\"))": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "cfg(any(target_os = \"ios\", target_os = \"visionos\", target_os = \"watchos\", target_os = \"tvos\"))": ["@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:x86_64-apple-ios"],
    "cfg(any(target_os = \"macos\", target_os = \"openbsd\", target_os = \"vita\", target_os = \"emscripten\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin"],
    "cfg(any(unix, target_os = \"wasi\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(not(all(target_arch = \"arm\", target_os = \"none\")))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(not(target_family = \"wasm\"))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(not(windows))": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:aarch64-unknown-uefi", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv32imc-unknown-none-elf", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-none-elf", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:thumbv7em-none-eabi", "@rules_rust//rust/platform:thumbv8m.main-none-eabi", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:wasm32-unknown-unknown", "@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu", "@rules_rust//rust/platform:x86_64-unknown-none", "@rules_rust//rust/platform:x86_64-unknown-uefi"],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"netbsd\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"solaris\")": [],
    "cfg(target_os = \"vxworks\")": [],
    "cfg(target_os = \"wasi\")": ["@rules_rust//rust/platform:wasm32-wasip1", "@rules_rust//rust/platform:wasm32-wasip1-threads", "@rules_rust//rust/platform:wasm32-wasip2"],
    "cfg(target_os = \"windows\")": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "cfg(unix)": ["@rules_rust//rust/platform:aarch64-apple-darwin", "@rules_rust//rust/platform:aarch64-apple-ios", "@rules_rust//rust/platform:aarch64-apple-ios-sim", "@rules_rust//rust/platform:aarch64-linux-android", "@rules_rust//rust/platform:aarch64-unknown-fuchsia", "@rules_rust//rust/platform:aarch64-unknown-linux-gnu", "@rules_rust//rust/platform:aarch64-unknown-nixos-gnu", "@rules_rust//rust/platform:aarch64-unknown-nto-qnx710", "@rules_rust//rust/platform:arm-unknown-linux-gnueabi", "@rules_rust//rust/platform:armv7-linux-androideabi", "@rules_rust//rust/platform:armv7-unknown-linux-gnueabi", "@rules_rust//rust/platform:i686-apple-darwin", "@rules_rust//rust/platform:i686-linux-android", "@rules_rust//rust/platform:i686-unknown-freebsd", "@rules_rust//rust/platform:i686-unknown-linux-gnu", "@rules_rust//rust/platform:powerpc-unknown-linux-gnu", "@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu", "@rules_rust//rust/platform:s390x-unknown-linux-gnu", "@rules_rust//rust/platform:wasm32-unknown-emscripten", "@rules_rust//rust/platform:x86_64-apple-darwin", "@rules_rust//rust/platform:x86_64-apple-ios", "@rules_rust//rust/platform:x86_64-linux-android", "@rules_rust//rust/platform:x86_64-unknown-freebsd", "@rules_rust//rust/platform:x86_64-unknown-fuchsia", "@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "cfg(windows)": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc", "@rules_rust//rust/platform:i686-pc-windows-msvc", "@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-gnullvm": [],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-gnullvm": [],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu", "@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "cui__adler2-2.0.0",
        sha256 = "512761e0bb2578dd7380c6baaa0f4ce03e84f95e960231d1dec8bf4d7d6e2627",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/adler2/2.0.0/download"],
        strip_prefix = "adler2-2.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.adler2-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__ahash-0.8.11",
        sha256 = "e89da841a80418a9b391ebaea17f5c112ffaaa96f621d2c285b5174da76b9011",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ahash/0.8.11/download"],
        strip_prefix = "ahash-0.8.11",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.ahash-0.8.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__aho-corasick-1.0.2",
        sha256 = "43f6cb1bf222025340178f382c426f13757b2960e89779dfcb319c32542a5a41",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/aho-corasick/1.0.2/download"],
        strip_prefix = "aho-corasick-1.0.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.aho-corasick-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__allocator-api2-0.2.18",
        sha256 = "5c6cb57a04249c6480766f7f7cef5467412af1490f8d1e243141daddada3264f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/allocator-api2/0.2.18/download"],
        strip_prefix = "allocator-api2-0.2.18",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.allocator-api2-0.2.18.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__anstream-0.6.18",
        sha256 = "8acc5369981196006228e28809f761875c0327210a891e941f4c683b3a99529b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstream/0.6.18/download"],
        strip_prefix = "anstream-0.6.18",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.anstream-0.6.18.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__anstyle-1.0.10",
        sha256 = "55cc3b69f167a1ef2e161439aa98aed94e6028e5f9a59be9a6ffb47aef1651f9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle/1.0.10/download"],
        strip_prefix = "anstyle-1.0.10",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.anstyle-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__anstyle-parse-0.2.1",
        sha256 = "938874ff5980b03a87c5524b3ae5b59cf99b1d6bc836848df7bc5ada9643c333",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-parse/0.2.1/download"],
        strip_prefix = "anstyle-parse-0.2.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.anstyle-parse-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__anstyle-query-1.0.0",
        sha256 = "5ca11d4be1bab0c8bc8734a9aa7bf4ee8316d462a08c6ac5052f888fef5b494b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-query/1.0.0/download"],
        strip_prefix = "anstyle-query-1.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.anstyle-query-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__anstyle-wincon-3.0.6",
        sha256 = "2109dbce0e72be3ec00bed26e6a7479ca384ad226efdd66db8fa2e3a38c83125",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anstyle-wincon/3.0.6/download"],
        strip_prefix = "anstyle-wincon-3.0.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.anstyle-wincon-3.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__anyhow-1.0.98",
        sha256 = "e16d2d3311acee920a9eb8d33b8cbc1787ce4a264e85f964c2404b969bdcd487",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/anyhow/1.0.98/download"],
        strip_prefix = "anyhow-1.0.98",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.anyhow-1.0.98.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__arc-swap-1.6.0",
        sha256 = "bddcadddf5e9015d310179a59bb28c4d4b9920ad0f11e8e14dbadf654890c9a6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/arc-swap/1.6.0/download"],
        strip_prefix = "arc-swap-1.6.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.arc-swap-1.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__arrayvec-0.7.4",
        sha256 = "96d30a06541fbafbc7f82ed10c06164cfbd2c401138f6addd8404629c4b16711",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/arrayvec/0.7.4/download"],
        strip_prefix = "arrayvec-0.7.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.arrayvec-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__autocfg-1.1.0",
        sha256 = "d468802bab17cbc0cc575e9b053f41e72aa36bfa6b7f55e3529ffa43161b97fa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/autocfg/1.1.0/download"],
        strip_prefix = "autocfg-1.1.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.autocfg-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__bitflags-2.4.1",
        sha256 = "327762f6e5a765692301e5bb513e0d9fef63be86bbc14528052b1cd3e6f03e07",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bitflags/2.4.1/download"],
        strip_prefix = "bitflags-2.4.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.bitflags-2.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__block-buffer-0.10.4",
        sha256 = "3078c7629b62d3f0439517fa394996acacc5cbc91c5a20d8c658e77abd503a71",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/block-buffer/0.10.4/download"],
        strip_prefix = "block-buffer-0.10.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.block-buffer-0.10.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__borsh-1.5.3",
        sha256 = "2506947f73ad44e344215ccd6403ac2ae18cd8e046e581a441bf8d199f257f03",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/borsh/1.5.3/download"],
        strip_prefix = "borsh-1.5.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.borsh-1.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__bstr-1.6.0",
        sha256 = "6798148dccfbff0fae41c7574d2fa8f1ef3492fba0face179de5d8d447d67b05",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/bstr/1.6.0/download"],
        strip_prefix = "bstr-1.6.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.bstr-1.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__camino-1.1.9",
        sha256 = "8b96ec4966b5813e2c0507c1f86115c8c5abaadc3980879c3424042a02fd1ad3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/camino/1.1.9/download"],
        strip_prefix = "camino-1.1.9",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.camino-1.1.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cargo-lock-10.1.0",
        sha256 = "c06acb4f71407ba205a07cb453211e0e6a67b21904e47f6ba1f9589e38f2e454",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo-lock/10.1.0/download"],
        strip_prefix = "cargo-lock-10.1.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.cargo-lock-10.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cargo-platform-0.1.9",
        sha256 = "e35af189006b9c0f00a064685c727031e3ed2d8020f7ba284d78cc2671bd36ea",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo-platform/0.1.9/download"],
        strip_prefix = "cargo-platform-0.1.9",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.cargo-platform-0.1.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cargo_metadata-0.19.2",
        sha256 = "dd5eb614ed4c27c5d706420e4320fbe3216ab31fa1c33cd8246ac36dae4479ba",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo_metadata/0.19.2/download"],
        strip_prefix = "cargo_metadata-0.19.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.cargo_metadata-0.19.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cargo_toml-0.22.1",
        sha256 = "02260d489095346e5cafd04dea8e8cb54d1d74fcd759022a9b72986ebe9a1257",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo_toml/0.22.1/download"],
        strip_prefix = "cargo_toml-0.22.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.cargo_toml-0.22.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cfg-expr-0.18.0",
        sha256 = "1a2b34126159980f92da2a08bdec0694fd80fb5eb9e48aff25d20a0d8dfa710d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-expr/0.18.0/download"],
        strip_prefix = "cfg-expr-0.18.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.cfg-expr-0.18.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cfg_aliases-0.2.1",
        sha256 = "613afe47fcd5fac7ccf1db93babcb082c5994d996f20b8b159f2ad1658eb5724",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cfg_aliases/0.2.1/download"],
        strip_prefix = "cfg_aliases-0.2.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.cfg_aliases-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__clap-4.5.37",
        sha256 = "eccb054f56cbd38340b380d4a8e69ef1f02f1af43db2f0cc817a4774d80ae071",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap/4.5.37/download"],
        strip_prefix = "clap-4.5.37",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.clap-4.5.37.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__clap_builder-4.5.37",
        sha256 = "efd9466fac8543255d3b1fcad4762c5e116ffe808c8a3043d4263cd4fd4862a2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_builder/4.5.37/download"],
        strip_prefix = "clap_builder-4.5.37",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.clap_builder-4.5.37.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__clap_derive-4.5.32",
        sha256 = "09176aae279615badda0765c0c0b3f6ed53f4709118af73cf4655d85d1530cd7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_derive/4.5.32/download"],
        strip_prefix = "clap_derive-4.5.32",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.clap_derive-4.5.32.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__clap_lex-0.7.4",
        sha256 = "f46ad14479a25103f283c0f10005961cf086d8dc42205bb44c46ac563475dca6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clap_lex/0.7.4/download"],
        strip_prefix = "clap_lex-0.7.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.clap_lex-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__clru-0.6.1",
        sha256 = "b8191fa7302e03607ff0e237d4246cc043ff5b3cb9409d995172ba3bea16b807",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/clru/0.6.1/download"],
        strip_prefix = "clru-0.6.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.clru-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__colorchoice-1.0.0",
        sha256 = "acbf1af155f9b9ef647e42cdc158db4b64a1b61f743629225fde6f3e0be2a7c7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/colorchoice/1.0.0/download"],
        strip_prefix = "colorchoice-1.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.colorchoice-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__cpufeatures-0.2.9",
        sha256 = "a17b76ff3a4162b0b27f354a0c87015ddad39d35f9c0c36607a3bdd175dde1f1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cpufeatures/0.2.9/download"],
        strip_prefix = "cpufeatures-0.2.9",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.cpufeatures-0.2.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__crates-index-3.7.0",
        sha256 = "7c5dc2f0ba9eaac8a56b9544e7ec604ac259dd5d7f8d1d10db81448dbbbc4d43",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crates-index/3.7.0/download"],
        strip_prefix = "crates-index-3.7.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.crates-index-3.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__crc32fast-1.3.2",
        sha256 = "b540bd8bc810d3885c6ea91e2018302f68baba2129ab3e88f32389ee9370880d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crc32fast/1.3.2/download"],
        strip_prefix = "crc32fast-1.3.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.crc32fast-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__crossbeam-channel-0.5.8",
        sha256 = "a33c2bf77f2df06183c3aa30d1e96c0695a313d4f9c453cc3762a6db39f99200",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-channel/0.5.8/download"],
        strip_prefix = "crossbeam-channel-0.5.8",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.crossbeam-channel-0.5.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__crossbeam-utils-0.8.16",
        sha256 = "5a22b2d63d4d1dc0b7f1b6b2747dd0088008a9be28b6ddf0b1e7d335e3037294",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crossbeam-utils/0.8.16/download"],
        strip_prefix = "crossbeam-utils-0.8.16",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.crossbeam-utils-0.8.16.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__crypto-common-0.1.6",
        sha256 = "1bfb12502f3fc46cca1bb51ac28df9d618d813cdc3d2f25b9fe775a34af26bb3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/crypto-common/0.1.6/download"],
        strip_prefix = "crypto-common-0.1.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.crypto-common-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__digest-0.10.7",
        sha256 = "9ed9a281f7bc9b7576e61468ba615a66a5c8cfdff42420a70aa82701a3b1e292",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/digest/0.10.7/download"],
        strip_prefix = "digest-0.10.7",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.digest-0.10.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__displaydoc-0.2.5",
        sha256 = "97369cbbc041bc366949bc74d34658d6cda5621039731c6310521892a3a20ae0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/displaydoc/0.2.5/download"],
        strip_prefix = "displaydoc-0.2.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.displaydoc-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__dunce-1.0.4",
        sha256 = "56ce8c6da7551ec6c462cbaf3bfbc75131ebbfa1c944aeaa9dab51ca1c5f0c3b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/dunce/1.0.4/download"],
        strip_prefix = "dunce-1.0.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.dunce-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__either-1.9.0",
        sha256 = "a26ae43d7bcc3b814de94796a5e736d4029efb0ee900c12e2d54c993ad1a1e07",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/either/1.9.0/download"],
        strip_prefix = "either-1.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.either-1.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__encoding_rs-0.8.33",
        sha256 = "7268b386296a025e474d5140678f75d6de9493ae55a5d709eeb9dd08149945e1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/encoding_rs/0.8.33/download"],
        strip_prefix = "encoding_rs-0.8.33",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.encoding_rs-0.8.33.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__equivalent-1.0.1",
        sha256 = "5443807d6dff69373d433ab9ef5378ad8df50ca6298caf15de6e52e24aaf54d5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/equivalent/1.0.1/download"],
        strip_prefix = "equivalent-1.0.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.equivalent-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__errno-0.3.11",
        sha256 = "976dd42dc7e85965fe702eb8164f21f450704bdde31faefd6471dba214cb594e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/errno/0.3.11/download"],
        strip_prefix = "errno-0.3.11",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.errno-0.3.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__faster-hex-0.9.0",
        sha256 = "a2a2b11eda1d40935b26cf18f6833c526845ae8c41e58d09af6adeb6f0269183",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/faster-hex/0.9.0/download"],
        strip_prefix = "faster-hex-0.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.faster-hex-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__fastrand-2.1.1",
        sha256 = "e8c02a5121d4ea3eb16a80748c74f5549a5665e4c21333c6098f283870fbdea6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fastrand/2.1.1/download"],
        strip_prefix = "fastrand-2.1.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.fastrand-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__filetime-0.2.22",
        sha256 = "d4029edd3e734da6fe05b6cd7bd2960760a616bd2ddd0d59a0124746d6272af0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/filetime/0.2.22/download"],
        strip_prefix = "filetime-0.2.22",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.filetime-0.2.22.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__flate2-1.0.35",
        sha256 = "c936bfdafb507ebbf50b8074c54fa31c5be9a1e7e5f467dd659697041407d07c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/flate2/1.0.35/download"],
        strip_prefix = "flate2-1.0.35",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.flate2-1.0.35.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__fnv-1.0.7",
        sha256 = "3f9eec918d3f24069decb9af1554cad7c880e2da24a9afd88aca000531ab82c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/fnv/1.0.7/download"],
        strip_prefix = "fnv-1.0.7",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.fnv-1.0.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__form_urlencoded-1.2.1",
        sha256 = "e13624c2627564efccf4934284bdd98cbaa14e79b0b5a141218e507b3a823456",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/form_urlencoded/1.2.1/download"],
        strip_prefix = "form_urlencoded-1.2.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.form_urlencoded-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__generic-array-0.14.7",
        sha256 = "85649ca51fd72272d7821adaf274ad91c288277713d9c18820d8499a7ff69e9a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/generic-array/0.14.7/download"],
        strip_prefix = "generic-array-0.14.7",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.generic-array-0.14.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__getrandom-0.3.2",
        sha256 = "73fea8450eea4bac3940448fb7ae50d91f034f941199fcd9d909a5a07aa455f0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/getrandom/0.3.2/download"],
        strip_prefix = "getrandom-0.3.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.getrandom-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-0.70.0",
        sha256 = "736f14636705f3a56ea52b553e67282519418d9a35bb1e90b3a9637a00296b68",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix/0.70.0/download"],
        strip_prefix = "gix-0.70.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-0.70.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-actor-0.33.2",
        sha256 = "20018a1a6332e065f1fcc8305c1c932c6b8c9985edea2284b3c79dc6fa3ee4b2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-actor/0.33.2/download"],
        strip_prefix = "gix-actor-0.33.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-actor-0.33.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-attributes-0.24.0",
        sha256 = "f151000bf662ef5f641eca6102d942ee31ace80f271a3ef642e99776ce6ddb38",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-attributes/0.24.0/download"],
        strip_prefix = "gix-attributes-0.24.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-attributes-0.24.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-bitmap-0.2.14",
        sha256 = "b1db9765c69502650da68f0804e3dc2b5f8ccc6a2d104ca6c85bc40700d37540",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-bitmap/0.2.14/download"],
        strip_prefix = "gix-bitmap-0.2.14",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-bitmap-0.2.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-chunk-0.4.11",
        sha256 = "0b1f1d8764958699dc764e3f727cef280ff4d1bd92c107bbf8acd85b30c1bd6f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-chunk/0.4.11/download"],
        strip_prefix = "gix-chunk-0.4.11",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-chunk-0.4.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-command-0.4.1",
        sha256 = "cb410b84d6575db45e62025a9118bdbf4d4b099ce7575a76161e898d9ca98df1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-command/0.4.1/download"],
        strip_prefix = "gix-command-0.4.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-command-0.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-commitgraph-0.26.0",
        sha256 = "e23a8ec2d8a16026a10dafdb6ed51bcfd08f5d97f20fa52e200bc50cb72e4877",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-commitgraph/0.26.0/download"],
        strip_prefix = "gix-commitgraph-0.26.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-commitgraph-0.26.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-config-0.43.0",
        sha256 = "377c1efd2014d5d469e0b3cd2952c8097bce9828f634e04d5665383249f1d9e9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-config/0.43.0/download"],
        strip_prefix = "gix-config-0.43.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-config-0.43.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-config-value-0.14.11",
        sha256 = "11365144ef93082f3403471dbaa94cfe4b5e72743bdb9560719a251d439f4cee",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-config-value/0.14.11/download"],
        strip_prefix = "gix-config-value-0.14.11",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-config-value-0.14.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-credentials-0.27.0",
        sha256 = "cf950f9ee1690bb9c4388b5152baa8a9f41ad61e5cf1ba0ec8c207b08dab9e45",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-credentials/0.27.0/download"],
        strip_prefix = "gix-credentials-0.27.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-credentials-0.27.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-date-0.9.3",
        sha256 = "c57c477b645ee248b173bb1176b52dd528872f12c50375801a58aaf5ae91113f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-date/0.9.3/download"],
        strip_prefix = "gix-date-0.9.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-date-0.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-diff-0.50.0",
        sha256 = "62afb7f4ca0acdf4e9dad92065b2eb1bf2993bcc5014b57bc796e3a365b17c4d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-diff/0.50.0/download"],
        strip_prefix = "gix-diff-0.50.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-diff-0.50.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-discover-0.38.0",
        sha256 = "d0c2414bdf04064e0f5a5aa029dfda1e663cf9a6c4bfc8759f2d369299bb65d8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-discover/0.38.0/download"],
        strip_prefix = "gix-discover-0.38.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-discover-0.38.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-features-0.40.0",
        sha256 = "8bfdd4838a8d42bd482c9f0cb526411d003ee94cc7c7b08afe5007329c71d554",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-features/0.40.0/download"],
        strip_prefix = "gix-features-0.40.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-features-0.40.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-filter-0.17.0",
        sha256 = "bdcc36cd7dbc63ed0ec3558645886553d1afd3cd09daa5efb9cba9cceb942bbb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-filter/0.17.0/download"],
        strip_prefix = "gix-filter-0.17.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-filter-0.17.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-fs-0.13.0",
        sha256 = "182e7fa7bfdf44ffb7cfe7451b373cdf1e00870ac9a488a49587a110c562063d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-fs/0.13.0/download"],
        strip_prefix = "gix-fs-0.13.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-fs-0.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-glob-0.18.0",
        sha256 = "4e9c7249fa0a78f9b363aa58323db71e0a6161fd69860ed6f48dedf0ef3a314e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-glob/0.18.0/download"],
        strip_prefix = "gix-glob-0.18.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-glob-0.18.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-hash-0.16.0",
        sha256 = "e81c5ec48649b1821b3ed066a44efb95f1a268b35c1d91295e61252539fbe9f8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-hash/0.16.0/download"],
        strip_prefix = "gix-hash-0.16.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-hash-0.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-hashtable-0.7.0",
        sha256 = "189130bc372accd02e0520dc5ab1cef318dcc2bc829b76ab8d84bbe90ac212d1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-hashtable/0.7.0/download"],
        strip_prefix = "gix-hashtable-0.7.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-hashtable-0.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-ignore-0.13.0",
        sha256 = "4f529dcb80bf9855c0a7c49f0ac588df6d6952d63a63fefc254b9c869d2cdf6f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-ignore/0.13.0/download"],
        strip_prefix = "gix-ignore-0.13.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-ignore-0.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-index-0.38.0",
        sha256 = "acd12e3626879369310fffe2ac61acc828613ef656b50c4ea984dd59d7dc85d8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-index/0.38.0/download"],
        strip_prefix = "gix-index-0.38.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-index-0.38.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-lock-16.0.0",
        sha256 = "9739815270ff6940968441824d162df9433db19211ca9ba8c3fc1b50b849c642",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-lock/16.0.0/download"],
        strip_prefix = "gix-lock-16.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-lock-16.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-negotiate-0.18.0",
        sha256 = "a6a8af1ef7bbe303d30b55312b7f4d33e955de43a3642ae9b7347c623d80ef80",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-negotiate/0.18.0/download"],
        strip_prefix = "gix-negotiate-0.18.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-negotiate-0.18.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-object-0.47.0",
        sha256 = "ddc4b3a0044244f0fe22347fb7a79cca165e37829d668b41b85ff46a43e5fd68",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-object/0.47.0/download"],
        strip_prefix = "gix-object-0.47.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-object-0.47.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-odb-0.67.0",
        sha256 = "3e93457df69cd09573608ce9fa4f443fbd84bc8d15d8d83adecd471058459c1b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-odb/0.67.0/download"],
        strip_prefix = "gix-odb-0.67.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-odb-0.67.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-pack-0.57.0",
        sha256 = "fc13a475b3db735617017fb35f816079bf503765312d4b1913b18cf96f3fa515",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-pack/0.57.0/download"],
        strip_prefix = "gix-pack-0.57.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-pack-0.57.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-packetline-0.18.3",
        sha256 = "c7e5ae6bc3ac160a6bf44a55f5537813ca3ddb08549c0fd3e7ef699c73c439cd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-packetline/0.18.3/download"],
        strip_prefix = "gix-packetline-0.18.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-packetline-0.18.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-packetline-blocking-0.18.2",
        sha256 = "c1cbf8767c6abd5a6779f586702b5bcd8702380f4208219449cf1c9d0cd1e17c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-packetline-blocking/0.18.2/download"],
        strip_prefix = "gix-packetline-blocking-0.18.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-packetline-blocking-0.18.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-path-0.10.14",
        sha256 = "c40f12bb65a8299be0cfb90fe718e3be236b7a94b434877012980863a883a99f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-path/0.10.14/download"],
        strip_prefix = "gix-path-0.10.14",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-path-0.10.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-pathspec-0.9.0",
        sha256 = "6430d3a686c08e9d59019806faa78c17315fe22ae73151a452195857ca02f86c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-pathspec/0.9.0/download"],
        strip_prefix = "gix-pathspec-0.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-pathspec-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-prompt-0.9.1",
        sha256 = "79f2185958e1512b989a007509df8d61dca014aa759a22bee80cfa6c594c3b6d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-prompt/0.9.1/download"],
        strip_prefix = "gix-prompt-0.9.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-prompt-0.9.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-protocol-0.48.0",
        sha256 = "6c61bd61afc6b67d213241e2100394c164be421e3f7228d3521b04f48ca5ba90",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-protocol/0.48.0/download"],
        strip_prefix = "gix-protocol-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-protocol-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-quote-0.4.15",
        sha256 = "e49357fccdb0c85c0d3a3292a9f6db32d9b3535959b5471bb9624908f4a066c6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-quote/0.4.15/download"],
        strip_prefix = "gix-quote-0.4.15",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-quote-0.4.15.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-ref-0.50.0",
        sha256 = "47adf4c5f933429f8554e95d0d92eee583cfe4b95d2bf665cd6fd4a1531ee20c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-ref/0.50.0/download"],
        strip_prefix = "gix-ref-0.50.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-ref-0.50.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-refspec-0.28.0",
        sha256 = "59650228d8f612f68e7f7a25f517fcf386c5d0d39826085492e94766858b0a90",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-refspec/0.28.0/download"],
        strip_prefix = "gix-refspec-0.28.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-refspec-0.28.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-revision-0.32.0",
        sha256 = "3fe28bbccca55da6d66e6c6efc6bb4003c29d407afd8178380293729733e6b53",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-revision/0.32.0/download"],
        strip_prefix = "gix-revision-0.32.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-revision-0.32.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-revwalk-0.18.0",
        sha256 = "d4ecb80c235b1e9ef2b99b23a81ea50dd569a88a9eb767179793269e0e616247",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-revwalk/0.18.0/download"],
        strip_prefix = "gix-revwalk-0.18.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-revwalk-0.18.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-sec-0.10.11",
        sha256 = "d84dae13271f4313f8d60a166bf27e54c968c7c33e2ffd31c48cafe5da649875",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-sec/0.10.11/download"],
        strip_prefix = "gix-sec-0.10.11",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-sec-0.10.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-shallow-0.2.0",
        sha256 = "ab72543011e303e52733c85bef784603ef39632ddf47f69723def52825e35066",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-shallow/0.2.0/download"],
        strip_prefix = "gix-shallow-0.2.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-shallow-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-submodule-0.17.0",
        sha256 = "74972fe8d46ac8a09490ae1e843b4caf221c5b157c5ac17057e8e1c38417a3ac",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-submodule/0.17.0/download"],
        strip_prefix = "gix-submodule-0.17.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-submodule-0.17.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-tempfile-16.0.0",
        sha256 = "2558f423945ef24a8328c55d1fd6db06b8376b0e7013b1bb476cc4ffdf678501",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-tempfile/16.0.0/download"],
        strip_prefix = "gix-tempfile-16.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-tempfile-16.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-trace-0.1.12",
        sha256 = "7c396a2036920c69695f760a65e7f2677267ccf483f25046977d87e4cb2665f7",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-trace/0.1.12/download"],
        strip_prefix = "gix-trace-0.1.12",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-trace-0.1.12.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-transport-0.45.0",
        sha256 = "11187418489477b1b5b862ae1aedbbac77e582f2c4b0ef54280f20cfe5b964d9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-transport/0.45.0/download"],
        strip_prefix = "gix-transport-0.45.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-transport-0.45.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-traverse-0.44.0",
        sha256 = "2bec70e53896586ef32a3efa7e4427b67308531ed186bb6120fb3eca0f0d61b4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-traverse/0.44.0/download"],
        strip_prefix = "gix-traverse-0.44.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-traverse-0.44.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-url-0.29.0",
        sha256 = "29218c768b53dd8f116045d87fec05b294c731a4b2bdd257eeca2084cc150b13",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-url/0.29.0/download"],
        strip_prefix = "gix-url-0.29.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-url-0.29.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-utils-0.1.14",
        sha256 = "ff08f24e03ac8916c478c8419d7d3c33393da9bb41fa4c24455d5406aeefd35f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-utils/0.1.14/download"],
        strip_prefix = "gix-utils-0.1.14",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-utils-0.1.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-validate-0.9.3",
        sha256 = "9eaa01c3337d885617c0a42e92823922a2aea71f4caeace6fe87002bdcadbd90",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-validate/0.9.3/download"],
        strip_prefix = "gix-validate-0.9.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-validate-0.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__gix-worktree-0.39.0",
        sha256 = "6673512f7eaa57a6876adceca6978a501d6c6569a4f177767dc405f8b9778958",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/gix-worktree/0.39.0/download"],
        strip_prefix = "gix-worktree-0.39.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.gix-worktree-0.39.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__glob-0.3.2",
        sha256 = "a8d1add55171497b4705a648c6b583acafb01d58050a51727785f0b2c8e0a2b2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/glob/0.3.2/download"],
        strip_prefix = "glob-0.3.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.glob-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__globset-0.4.11",
        sha256 = "1391ab1f92ffcc08911957149833e682aa3fe252b9f45f966d2ef972274c97df",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/globset/0.4.11/download"],
        strip_prefix = "globset-0.4.11",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.globset-0.4.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__globwalk-0.9.1",
        sha256 = "0bf760ebf69878d9fd8f110c89703d90ce35095324d1f1edcb595c63945ee757",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/globwalk/0.9.1/download"],
        strip_prefix = "globwalk-0.9.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.globwalk-0.9.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__hashbrown-0.14.3",
        sha256 = "290f1a1d9242c78d09ce40a5e87e7554ee637af1351968159f4952f028f75604",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.14.3/download"],
        strip_prefix = "hashbrown-0.14.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.hashbrown-0.14.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__hashbrown-0.15.0",
        sha256 = "1e087f84d4f86bf4b218b927129862374b72199ae7d8657835f1e89000eea4fb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.15.0/download"],
        strip_prefix = "hashbrown-0.15.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.hashbrown-0.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__heck-0.5.0",
        sha256 = "2304e00983f87ffb38b55b444b5e3b60a884b5d30c0fca7d82fe33449bbe55ea",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/heck/0.5.0/download"],
        strip_prefix = "heck-0.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.heck-0.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__hex-0.4.3",
        sha256 = "7f24254aa9a54b5c858eaee2f5bccdb46aaf0e486a595ed5fd8f86ba55232a70",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hex/0.4.3/download"],
        strip_prefix = "hex-0.4.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.hex-0.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__home-0.5.5",
        sha256 = "5444c27eef6923071f7ebcc33e3444508466a76f7a2b93da00ed6e19f30c1ddb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/home/0.5.5/download"],
        strip_prefix = "home-0.5.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.home-0.5.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_collections-1.5.0",
        sha256 = "db2fa452206ebee18c4b5c2274dbf1de17008e874b4dc4f0aea9d01ca79e4526",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_collections/1.5.0/download"],
        strip_prefix = "icu_collections-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_collections-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_locid-1.5.0",
        sha256 = "13acbb8371917fc971be86fc8057c41a64b521c184808a698c02acc242dbf637",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locid/1.5.0/download"],
        strip_prefix = "icu_locid-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_locid-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_locid_transform-1.5.0",
        sha256 = "01d11ac35de8e40fdeda00d9e1e9d92525f3f9d887cdd7aa81d727596788b54e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locid_transform/1.5.0/download"],
        strip_prefix = "icu_locid_transform-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_locid_transform-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_locid_transform_data-1.5.0",
        sha256 = "fdc8ff3388f852bede6b579ad4e978ab004f139284d7b28715f773507b946f6e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locid_transform_data/1.5.0/download"],
        strip_prefix = "icu_locid_transform_data-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_locid_transform_data-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_normalizer-1.5.0",
        sha256 = "19ce3e0da2ec68599d193c93d088142efd7f9c5d6fc9b803774855747dc6a84f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer/1.5.0/download"],
        strip_prefix = "icu_normalizer-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_normalizer-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_normalizer_data-1.5.0",
        sha256 = "f8cafbf7aa791e9b22bec55a167906f9e1215fd475cd22adfcf660e03e989516",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer_data/1.5.0/download"],
        strip_prefix = "icu_normalizer_data-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_normalizer_data-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_properties-1.5.1",
        sha256 = "93d6020766cfc6302c15dbbc9c8778c37e62c14427cb7f6e601d849e092aeef5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties/1.5.1/download"],
        strip_prefix = "icu_properties-1.5.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_properties-1.5.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_properties_data-1.5.0",
        sha256 = "67a8effbc3dd3e4ba1afa8ad918d5684b8868b3b26500753effea8d2eed19569",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties_data/1.5.0/download"],
        strip_prefix = "icu_properties_data-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_properties_data-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_provider-1.5.0",
        sha256 = "6ed421c8a8ef78d3e2dbc98a973be2f3770cb42b606e3ab18d6237c4dfde68d9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_provider/1.5.0/download"],
        strip_prefix = "icu_provider-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_provider-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__icu_provider_macros-1.5.0",
        sha256 = "1ec89e9337638ecdc08744df490b221a7399bf8d164eb52a665454e60e075ad6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_provider_macros/1.5.0/download"],
        strip_prefix = "icu_provider_macros-1.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.icu_provider_macros-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__idna-1.0.3",
        sha256 = "686f825264d630750a544639377bae737628043f20d38bbc029e8f29ea968a7e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna/1.0.3/download"],
        strip_prefix = "idna-1.0.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.idna-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__idna_adapter-1.2.0",
        sha256 = "daca1df1c957320b2cf139ac61e7bd64fed304c5040df000a745aa1de3b4ef71",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna_adapter/1.2.0/download"],
        strip_prefix = "idna_adapter-1.2.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.idna_adapter-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__ignore-0.4.18",
        sha256 = "713f1b139373f96a2e0ce3ac931cd01ee973c3c5dd7c40c0c2efe96ad2b6751d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ignore/0.4.18/download"],
        strip_prefix = "ignore-0.4.18",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.ignore-0.4.18.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__indexmap-2.6.0",
        sha256 = "707907fe3c25f5424cce2cb7e1cbcafee6bdbe735ca90ef77c29e84591e5b9da",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/2.6.0/download"],
        strip_prefix = "indexmap-2.6.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.indexmap-2.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__indoc-2.0.6",
        sha256 = "f4c7245a08504955605670dbf141fceab975f15ca21570696aebe9d2e71576bd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indoc/2.0.6/download"],
        strip_prefix = "indoc-2.0.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.indoc-2.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__is_terminal_polyfill-1.70.1",
        sha256 = "7943c866cc5cd64cbc25b2e01621d07fa8eb2a1a23160ee81ce38704e97b8ecf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/is_terminal_polyfill/1.70.1/download"],
        strip_prefix = "is_terminal_polyfill-1.70.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.is_terminal_polyfill-1.70.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__itertools-0.14.0",
        sha256 = "2b192c782037fadd9cfa75548310488aabdbf3d2da73885b31bd0abd03351285",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itertools/0.14.0/download"],
        strip_prefix = "itertools-0.14.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.itertools-0.14.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__itoa-1.0.8",
        sha256 = "62b02a5381cc465bd3041d84623d0fa3b66738b52b8e2fc3bab8ad63ab032f4a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/itoa/1.0.8/download"],
        strip_prefix = "itoa-1.0.8",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.itoa-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__jiff-0.1.13",
        sha256 = "8a45489186a6123c128fdf6016183fcfab7113e1820eb813127e036e287233fb",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jiff/0.1.13/download"],
        strip_prefix = "jiff-0.1.13",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.jiff-0.1.13.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__jiff-tzdb-0.1.1",
        sha256 = "91335e575850c5c4c673b9bd467b0e025f164ca59d0564f69d0c2ee0ffad4653",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jiff-tzdb/0.1.1/download"],
        strip_prefix = "jiff-tzdb-0.1.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.jiff-tzdb-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__jiff-tzdb-platform-0.1.1",
        sha256 = "9835f0060a626fe59f160437bc725491a6af23133ea906500027d1bd2f8f4329",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/jiff-tzdb-platform/0.1.1/download"],
        strip_prefix = "jiff-tzdb-platform-0.1.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.jiff-tzdb-platform-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__kstring-2.0.2",
        sha256 = "558bf9508a558512042d3095138b1f7b8fe90c5467d94f9f1da28b3731c5dbd1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/kstring/2.0.2/download"],
        strip_prefix = "kstring-2.0.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.kstring-2.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__lazy_static-1.4.0",
        sha256 = "e2abad23fbc42b3700f2f279844dc832adb2b2eb069b2df918f455c4e18cc646",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lazy_static/1.4.0/download"],
        strip_prefix = "lazy_static-1.4.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.lazy_static-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__libc-0.2.172",
        sha256 = "d750af042f7ef4f724306de029d18836c26c1765a54a6a3f094cbd23a7267ffa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/libc/0.2.172/download"],
        strip_prefix = "libc-0.2.172",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.libc-0.2.172.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__linux-raw-sys-0.4.14",
        sha256 = "78b3ae25bc7c8c38cec158d1f2757ee79e9b3740fbc7ccf0e59e4b08d793fa89",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/linux-raw-sys/0.4.14/download"],
        strip_prefix = "linux-raw-sys-0.4.14",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.linux-raw-sys-0.4.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__linux-raw-sys-0.9.4",
        sha256 = "cd945864f07fe9f5371a27ad7b52a172b4b499999f1d97574c9fa68373937e12",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/linux-raw-sys/0.9.4/download"],
        strip_prefix = "linux-raw-sys-0.9.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.linux-raw-sys-0.9.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__litemap-0.7.4",
        sha256 = "4ee93343901ab17bd981295f2cf0026d4ad018c7c31ba84549a4ddbb47a45104",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/litemap/0.7.4/download"],
        strip_prefix = "litemap-0.7.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.litemap-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__lock_api-0.4.11",
        sha256 = "3c168f8615b12bc01f9c17e2eb0cc07dcae1940121185446edc3744920e8ef45",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/lock_api/0.4.11/download"],
        strip_prefix = "lock_api-0.4.11",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.lock_api-0.4.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__log-0.4.19",
        sha256 = "b06a4cde4c0f271a446782e3eff8de789548ce57dbc8eca9292c27f4a42004b4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/log/0.4.19/download"],
        strip_prefix = "log-0.4.19",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.log-0.4.19.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__maplit-1.0.2",
        sha256 = "3e2e65a1a2e43cfcb47a895c4c8b10d1f4a61097f9f254f183aee60cad9c651d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/maplit/1.0.2/download"],
        strip_prefix = "maplit-1.0.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.maplit-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__maybe-async-0.2.7",
        sha256 = "0f1b8c13cb1f814b634a96b2c725449fe7ed464a7b8781de8688be5ffbd3f305",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/maybe-async/0.2.7/download"],
        strip_prefix = "maybe-async-0.2.7",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.maybe-async-0.2.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__memchr-2.6.4",
        sha256 = "f665ee40bc4a3c5590afb1e9677db74a508659dfd71e126420da8274909a0167",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.6.4/download"],
        strip_prefix = "memchr-2.6.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.memchr-2.6.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__memmap2-0.9.5",
        sha256 = "fd3f7eed9d3848f8b98834af67102b720745c4ec028fcd0aa0239277e7de374f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memmap2/0.9.5/download"],
        strip_prefix = "memmap2-0.9.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.memmap2-0.9.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__miniz_oxide-0.8.0",
        sha256 = "e2d80299ef12ff69b16a84bb182e3b9df68b5a91574d3d4fa6e41b65deec4df1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/miniz_oxide/0.8.0/download"],
        strip_prefix = "miniz_oxide-0.8.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.miniz_oxide-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__normpath-1.3.0",
        sha256 = "c8911957c4b1549ac0dc74e30db9c8b0e66ddcd6d7acc33098f4c63a64a6d7ed",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/normpath/1.3.0/download"],
        strip_prefix = "normpath-1.3.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.normpath-1.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__nu-ansi-term-0.46.0",
        sha256 = "77a8165726e8236064dbb45459242600304b42a5ea24ee2948e18e023bf7ba84",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/nu-ansi-term/0.46.0/download"],
        strip_prefix = "nu-ansi-term-0.46.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.nu-ansi-term-0.46.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__once_cell-1.21.3",
        sha256 = "42f5e15c9953c5e4ccceeb2e7382a716482c34515315f7b03532b8b4e8393d2d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/once_cell/1.21.3/download"],
        strip_prefix = "once_cell-1.21.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.once_cell-1.21.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__overload-0.1.1",
        sha256 = "b15813163c1d831bf4a13c3610c05c0d03b39feb07f7e09fa234dac9b15aaf39",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/overload/0.1.1/download"],
        strip_prefix = "overload-0.1.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.overload-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__parking_lot-0.12.1",
        sha256 = "3742b2c103b9f06bc9fff0a37ff4912935851bee6d36f3c02bcc755bcfec228f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot/0.12.1/download"],
        strip_prefix = "parking_lot-0.12.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.parking_lot-0.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__parking_lot_core-0.9.9",
        sha256 = "4c42a9226546d68acdd9c0a280d17ce19bfe27a46bf68784e4066115788d008e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/parking_lot_core/0.9.9/download"],
        strip_prefix = "parking_lot_core-0.9.9",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.parking_lot_core-0.9.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pathdiff-0.2.3",
        sha256 = "df94ce210e5bc13cb6651479fa48d14f601d9858cfe0467f43ae157023b938d3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pathdiff/0.2.3/download"],
        strip_prefix = "pathdiff-0.2.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.pathdiff-0.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__percent-encoding-2.3.1",
        sha256 = "e3148f5046208a5d56bcfc03053e3ca6334e51da8dfb19b6cdc8b306fae3283e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/percent-encoding/2.3.1/download"],
        strip_prefix = "percent-encoding-2.3.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.percent-encoding-2.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pest-2.7.0",
        sha256 = "f73935e4d55e2abf7f130186537b19e7a4abc886a0252380b59248af473a3fc9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pest/2.7.0/download"],
        strip_prefix = "pest-2.7.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.pest-2.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pest_derive-2.7.0",
        sha256 = "aef623c9bbfa0eedf5a0efba11a5ee83209c326653ca31ff019bec3a95bfff2b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pest_derive/2.7.0/download"],
        strip_prefix = "pest_derive-2.7.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.pest_derive-2.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pest_generator-2.7.0",
        sha256 = "b3e8cba4ec22bada7fc55ffe51e2deb6a0e0db2d0b7ab0b103acc80d2510c190",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pest_generator/2.7.0/download"],
        strip_prefix = "pest_generator-2.7.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.pest_generator-2.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pest_meta-2.7.0",
        sha256 = "a01f71cb40bd8bb94232df14b946909e14660e33fc05db3e50ae2a82d7ea0ca0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pest_meta/2.7.0/download"],
        strip_prefix = "pest_meta-2.7.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.pest_meta-2.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__pin-project-lite-0.2.13",
        sha256 = "8afb450f006bf6385ca15ef45d71d2288452bc3683ce2e2cacc0d18e4be60b58",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pin-project-lite/0.2.13/download"],
        strip_prefix = "pin-project-lite-0.2.13",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.pin-project-lite-0.2.13.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__proc-macro2-1.0.92",
        sha256 = "37d3544b3f2748c54e147655edb5025752e2303145b5aefb3c3ea2c78b973bb0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.92/download"],
        strip_prefix = "proc-macro2-1.0.92",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.proc-macro2-1.0.92.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__prodash-29.0.0",
        sha256 = "a266d8d6020c61a437be704c5e618037588e1985c7dbb7bf8d265db84cffe325",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/prodash/29.0.0/download"],
        strip_prefix = "prodash-29.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.prodash-29.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__quote-1.0.37",
        sha256 = "b5b9d34b8991d19d98081b46eacdd8eb58c6f2b201139f7c5f643cc155a633af",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.37/download"],
        strip_prefix = "quote-1.0.37",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.quote-1.0.37.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__r-efi-5.2.0",
        sha256 = "74765f6d916ee2faa39bc8e68e4f3ed8949b48cccdac59983d287a7cb71ce9c5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/r-efi/5.2.0/download"],
        strip_prefix = "r-efi-5.2.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.r-efi-5.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__redox_syscall-0.3.5",
        sha256 = "567664f262709473930a4bf9e51bf2ebf3348f2e748ccc50dea20646858f8f29",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/redox_syscall/0.3.5/download"],
        strip_prefix = "redox_syscall-0.3.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.redox_syscall-0.3.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__redox_syscall-0.4.1",
        sha256 = "4722d768eff46b75989dd134e5c353f0d6296e5aaa3132e776cbdb56be7731aa",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/redox_syscall/0.4.1/download"],
        strip_prefix = "redox_syscall-0.4.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.redox_syscall-0.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__regex-1.11.1",
        sha256 = "b544ef1b4eac5dc2db33ea63606ae9ffcfac26c1416a2806ae0bf5f56b201191",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex/1.11.1/download"],
        strip_prefix = "regex-1.11.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.regex-1.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__regex-automata-0.3.3",
        sha256 = "39354c10dd07468c2e73926b23bb9c2caca74c5501e38a35da70406f1d923310",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.3.3/download"],
        strip_prefix = "regex-automata-0.3.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.regex-automata-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__regex-automata-0.4.8",
        sha256 = "368758f23274712b504848e9d5a6f010445cc8b87a7cdb4d7cbee666c1288da3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-automata/0.4.8/download"],
        strip_prefix = "regex-automata-0.4.8",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.regex-automata-0.4.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__regex-syntax-0.8.5",
        sha256 = "2b15c43186be67a4fd63bee50d0303afffcef381492ebe2c5d87f324e1b8815c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/regex-syntax/0.8.5/download"],
        strip_prefix = "regex-syntax-0.8.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.regex-syntax-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rustc-hash-2.0.0",
        sha256 = "583034fd73374156e66797ed8e5b0d5690409c9226b22d87cb7f19821c05d152",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-hash/2.0.0/download"],
        strip_prefix = "rustc-hash-2.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.rustc-hash-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rustc-stable-hash-0.1.1",
        sha256 = "2febf9acc5ee5e99d1ad0afcdbccc02d87aa3f857a1f01f825b80eacf8edfcd1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustc-stable-hash/0.1.1/download"],
        strip_prefix = "rustc-stable-hash-0.1.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.rustc-stable-hash-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rustix-0.38.41",
        sha256 = "d7f649912bc1495e167a6edee79151c84b1bad49748cb4f1f1167f459f6224f6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustix/0.38.41/download"],
        strip_prefix = "rustix-0.38.41",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.rustix-0.38.41.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__rustix-1.0.5",
        sha256 = "d97817398dd4bb2e6da002002db259209759911da105da92bec29ccb12cf58bf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/rustix/1.0.5/download"],
        strip_prefix = "rustix-1.0.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.rustix-1.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__ryu-1.0.14",
        sha256 = "fe232bdf6be8c8de797b22184ee71118d63780ea42ac85b61d1baa6d3b782ae9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ryu/1.0.14/download"],
        strip_prefix = "ryu-1.0.14",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.ryu-1.0.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__same-file-1.0.6",
        sha256 = "93fc1dc3aaa9bfed95e02e6eadabb4baf7e3078b0bd1b4d7b6b0b68378900502",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/same-file/1.0.6/download"],
        strip_prefix = "same-file-1.0.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.same-file-1.0.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__scopeguard-1.2.0",
        sha256 = "94143f37725109f92c262ed2cf5e59bce7498c01bcc1502d7b9afe439a4e9f49",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/scopeguard/1.2.0/download"],
        strip_prefix = "scopeguard-1.2.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.scopeguard-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__semver-1.0.26",
        sha256 = "56e6fa9c48d24d85fb3de5ad847117517440f6beceb7798af16b4a87d616b8d0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/semver/1.0.26/download"],
        strip_prefix = "semver-1.0.26",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.semver-1.0.26.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde-1.0.219",
        sha256 = "5f0e2c6ed6606019b4e29e69dbaba95b11854410e5347d525002456dbbb786b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.219/download"],
        strip_prefix = "serde-1.0.219",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.serde-1.0.219.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde_derive-1.0.219",
        sha256 = "5b0276cf7f2c73365f7157c8123c21cd9a50fbbd844757af28ca1f5925fc2a00",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.219/download"],
        strip_prefix = "serde_derive-1.0.219",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.serde_derive-1.0.219.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde_json-1.0.140",
        sha256 = "20068b6e96dc6c9bd23e01df8827e6c7e1f2fddd43c21810382803c136b99373",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_json/1.0.140/download"],
        strip_prefix = "serde_json-1.0.140",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.serde_json-1.0.140.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde_spanned-0.6.8",
        sha256 = "87607cb1398ed59d48732e575a4c28a7a8ebf2454b964fe3f224f2afc07909e1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_spanned/0.6.8/download"],
        strip_prefix = "serde_spanned-0.6.8",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.serde_spanned-0.6.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__serde_starlark-0.1.17",
        sha256 = "45f0ec43438c1213326fe5e26e20b748322e4b5d324bef7e06676b8cbf280fd0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_starlark/0.1.17/download"],
        strip_prefix = "serde_starlark-0.1.17",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.serde_starlark-0.1.17.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__sha1_smol-1.0.0",
        sha256 = "ae1a47186c03a32177042e55dbc5fd5aee900b8e0069a8d70fba96a9375cd012",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sha1_smol/1.0.0/download"],
        strip_prefix = "sha1_smol-1.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.sha1_smol-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__sha2-0.10.8",
        sha256 = "793db75ad2bcafc3ffa7c68b215fee268f537982cd901d132f89c6343f3a3dc8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sha2/0.10.8/download"],
        strip_prefix = "sha2-0.10.8",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.sha2-0.10.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__sharded-slab-0.1.7",
        sha256 = "f40ca3c46823713e0d4209592e8d6e826aa57e928f09752619fc696c499637f6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/sharded-slab/0.1.7/download"],
        strip_prefix = "sharded-slab-0.1.7",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.sharded-slab-0.1.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__shell-words-1.1.0",
        sha256 = "24188a676b6ae68c3b2cb3a01be17fbf7240ce009799bb56d5b1409051e78fde",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/shell-words/1.1.0/download"],
        strip_prefix = "shell-words-1.1.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.shell-words-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__smallvec-1.15.0",
        sha256 = "8917285742e9f3e1683f0a9c4e6b57960b7314d0b08d30d1ecd426713ee2eee9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/1.15.0/download"],
        strip_prefix = "smallvec-1.15.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.smallvec-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__smawk-0.3.2",
        sha256 = "b7c388c1b5e93756d0c740965c41e8822f866621d41acbdf6336a6a168f8840c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smawk/0.3.2/download"],
        strip_prefix = "smawk-0.3.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.smawk-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__smol_str-0.3.2",
        sha256 = "9676b89cd56310a87b93dec47b11af744f34d5fc9f367b829474eec0a891350d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smol_str/0.3.2/download"],
        strip_prefix = "smol_str-0.3.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.smol_str-0.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__spdx-0.10.8",
        sha256 = "58b69356da67e2fc1f542c71ea7e654a361a79c938e4424392ecf4fa065d2193",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/spdx/0.10.8/download"],
        strip_prefix = "spdx-0.10.8",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.spdx-0.10.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__stable_deref_trait-1.2.0",
        sha256 = "a8f112729512f8e442d81f95a8a7ddf2b7c6b8a1a6f509a95864142b30cab2d3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/stable_deref_trait/1.2.0/download"],
        strip_prefix = "stable_deref_trait-1.2.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.stable_deref_trait-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__static_assertions-1.1.0",
        sha256 = "a2eb9349b6444b326872e140eb1cf5e7c522154d69e7a0ffb0fb81c06b37543f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/static_assertions/1.1.0/download"],
        strip_prefix = "static_assertions-1.1.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.static_assertions-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__strsim-0.11.1",
        sha256 = "7da8b5736845d9f2fcb837ea5d9e2628564b3b043a70948a3f0b778838c5fb4f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/strsim/0.11.1/download"],
        strip_prefix = "strsim-0.11.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.strsim-0.11.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__syn-1.0.109",
        sha256 = "72b64191b275b66ffe2469e8af2c1cfe3bafa67b529ead792a6d0160888b4237",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/1.0.109/download"],
        strip_prefix = "syn-1.0.109",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.syn-1.0.109.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__syn-2.0.90",
        sha256 = "919d3b74a5dd0ccd15aeb8f93e7006bd9e14c295087c9896a110f490752bcf31",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.90/download"],
        strip_prefix = "syn-2.0.90",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.syn-2.0.90.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__synstructure-0.13.1",
        sha256 = "c8af7666ab7b6390ab78131fb5b0fce11d6b7a6951602017c35fa82800708971",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/synstructure/0.13.1/download"],
        strip_prefix = "synstructure-0.13.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.synstructure-0.13.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tempfile-3.19.1",
        sha256 = "7437ac7763b9b123ccf33c338a5cc1bac6f69b45a136c19bdd8a65e3916435bf",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tempfile/3.19.1/download"],
        strip_prefix = "tempfile-3.19.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tempfile-3.19.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tera-1.20.0",
        sha256 = "ab9d851b45e865f178319da0abdbfe6acbc4328759ff18dafc3a41c16b4cd2ee",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tera/1.20.0/download"],
        strip_prefix = "tera-1.20.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tera-1.20.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__textwrap-0.16.2",
        sha256 = "c13547615a44dc9c452a8a534638acdf07120d4b6847c8178705da06306a3057",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/textwrap/0.16.2/download"],
        strip_prefix = "textwrap-0.16.2",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.textwrap-0.16.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__thiserror-1.0.50",
        sha256 = "f9a7210f5c9a7156bb50aa36aed4c95afb51df0df00713949448cf9e97d382d2",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror/1.0.50/download"],
        strip_prefix = "thiserror-1.0.50",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.thiserror-1.0.50.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__thiserror-2.0.4",
        sha256 = "2f49a1853cf82743e3b7950f77e0f4d622ca36cf4317cba00c767838bac8d490",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror/2.0.4/download"],
        strip_prefix = "thiserror-2.0.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.thiserror-2.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__thiserror-impl-1.0.50",
        sha256 = "266b2e40bc00e5a6c09c3584011e08b06f123c00362c92b975ba9843aaaa14b8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror-impl/1.0.50/download"],
        strip_prefix = "thiserror-impl-1.0.50",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.thiserror-impl-1.0.50.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__thiserror-impl-2.0.4",
        sha256 = "8381894bb3efe0c4acac3ded651301ceee58a15d47c2e34885ed1908ad667061",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror-impl/2.0.4/download"],
        strip_prefix = "thiserror-impl-2.0.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.thiserror-impl-2.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__thread_local-1.1.4",
        sha256 = "5516c27b78311c50bf42c071425c560ac799b11c30b31f87e3081965fe5e0180",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thread_local/1.1.4/download"],
        strip_prefix = "thread_local-1.1.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.thread_local-1.1.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tinystr-0.7.6",
        sha256 = "9117f5d4db391c1cf6927e7bea3db74b9a1c1add8f7eda9ffd5364f40f57b82f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tinystr/0.7.6/download"],
        strip_prefix = "tinystr-0.7.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tinystr-0.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tinyvec-1.6.0",
        sha256 = "87cc5ceb3875bb20c2890005a4e226a4651264a5c75edb2421b52861a0a0cb50",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tinyvec/1.6.0/download"],
        strip_prefix = "tinyvec-1.6.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tinyvec-1.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tinyvec_macros-0.1.1",
        sha256 = "1f3ccbac311fea05f86f61904b462b55fb3df8837a366dfc601a0161d0532f20",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tinyvec_macros/0.1.1/download"],
        strip_prefix = "tinyvec_macros-0.1.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tinyvec_macros-0.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__toml-0.8.21",
        sha256 = "900f6c86a685850b1bc9f6223b20125115ee3f31e01207d81655bbcc0aea9231",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml/0.8.21/download"],
        strip_prefix = "toml-0.8.21",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.toml-0.8.21.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__toml_datetime-0.6.9",
        sha256 = "3da5db5a963e24bc68be8b17b6fa82814bb22ee8660f192bb182771d498f09a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml_datetime/0.6.9/download"],
        strip_prefix = "toml_datetime-0.6.9",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.toml_datetime-0.6.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__toml_edit-0.22.25",
        sha256 = "10558ed0bd2a1562e630926a2d1f0b98c827da99fabd3fe20920a59642504485",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml_edit/0.22.25/download"],
        strip_prefix = "toml_edit-0.22.25",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.toml_edit-0.22.25.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__toml_write-0.1.0",
        sha256 = "28391a4201ba7eb1984cfeb6862c0b3ea2cfe23332298967c749dddc0d6cd976",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml_write/0.1.0/download"],
        strip_prefix = "toml_write-0.1.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.toml_write-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tracing-0.1.41",
        sha256 = "784e0ac535deb450455cbfa28a6f0df145ea1bb7ae51b821cf5e7927fdcfbdd0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing/0.1.41/download"],
        strip_prefix = "tracing-0.1.41",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tracing-0.1.41.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tracing-attributes-0.1.28",
        sha256 = "395ae124c09f9e6918a2310af6038fba074bcf474ac352496d5910dd59a2226d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-attributes/0.1.28/download"],
        strip_prefix = "tracing-attributes-0.1.28",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tracing-attributes-0.1.28.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tracing-core-0.1.33",
        sha256 = "e672c95779cf947c5311f83787af4fa8fffd12fb27e4993211a84bdfd9610f9c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-core/0.1.33/download"],
        strip_prefix = "tracing-core-0.1.33",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tracing-core-0.1.33.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tracing-log-0.2.0",
        sha256 = "ee855f1f400bd0e5c02d150ae5de3840039a3f54b025156404e34c23c03f47c3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-log/0.2.0/download"],
        strip_prefix = "tracing-log-0.2.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tracing-log-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__tracing-subscriber-0.3.19",
        sha256 = "e8189decb5ac0fa7bc8b96b7cb9b2701d60d48805aca84a238004d665fcc4008",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tracing-subscriber/0.3.19/download"],
        strip_prefix = "tracing-subscriber-0.3.19",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.tracing-subscriber-0.3.19.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__typenum-1.16.0",
        sha256 = "497961ef93d974e23eb6f433eb5fe1b7930b659f06d12dec6fc44a8f554c0bba",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/typenum/1.16.0/download"],
        strip_prefix = "typenum-1.16.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.typenum-1.16.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__ucd-trie-0.1.6",
        sha256 = "ed646292ffc8188ef8ea4d1e0e0150fb15a5c2e12ad9b8fc191ae7a8a7f3c4b9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ucd-trie/0.1.6/download"],
        strip_prefix = "ucd-trie-0.1.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.ucd-trie-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__uluru-3.0.0",
        sha256 = "794a32261a1f5eb6a4462c81b59cec87b5c27d5deea7dd1ac8fc781c41d226db",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/uluru/3.0.0/download"],
        strip_prefix = "uluru-3.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.uluru-3.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-char-property-0.9.0",
        sha256 = "a8c57a407d9b6fa02b4795eb81c5b6652060a15a7903ea981f3d723e6c0be221",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unic-char-property/0.9.0/download"],
        strip_prefix = "unic-char-property-0.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unic-char-property-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-char-range-0.9.0",
        sha256 = "0398022d5f700414f6b899e10b8348231abf9173fa93144cbc1a43b9793c1fbc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unic-char-range/0.9.0/download"],
        strip_prefix = "unic-char-range-0.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unic-char-range-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-common-0.9.0",
        sha256 = "80d7ff825a6a654ee85a63e80f92f054f904f21e7d12da4e22f9834a4aaa35bc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unic-common/0.9.0/download"],
        strip_prefix = "unic-common-0.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unic-common-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-segment-0.9.0",
        sha256 = "e4ed5d26be57f84f176157270c112ef57b86debac9cd21daaabbe56db0f88f23",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unic-segment/0.9.0/download"],
        strip_prefix = "unic-segment-0.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unic-segment-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-ucd-segment-0.9.0",
        sha256 = "2079c122a62205b421f499da10f3ee0f7697f012f55b675e002483c73ea34700",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unic-ucd-segment/0.9.0/download"],
        strip_prefix = "unic-ucd-segment-0.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unic-ucd-segment-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unic-ucd-version-0.9.0",
        sha256 = "96bd2f2237fe450fcd0a1d2f5f4e91711124f7857ba2e964247776ebeeb7b0c4",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unic-ucd-version/0.9.0/download"],
        strip_prefix = "unic-ucd-version-0.9.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unic-ucd-version-0.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-bom-2.0.3",
        sha256 = "7eec5d1121208364f6793f7d2e222bf75a915c19557537745b195b253dd64217",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-bom/2.0.3/download"],
        strip_prefix = "unicode-bom-2.0.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unicode-bom-2.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-ident-1.0.10",
        sha256 = "22049a19f4a68748a168c0fc439f9516686aa045927ff767eca0a85101fb6e73",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.10/download"],
        strip_prefix = "unicode-ident-1.0.10",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unicode-ident-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-linebreak-0.1.5",
        sha256 = "3b09c83c3c29d37506a3e260c08c03743a6bb66a9cd432c6934ab501a190571f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-linebreak/0.1.5/download"],
        strip_prefix = "unicode-linebreak-0.1.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unicode-linebreak-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-normalization-0.1.22",
        sha256 = "5c5713f0fc4b5db668a2ac63cdb7bb4469d8c9fed047b1d0292cc7b0ce2ba921",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-normalization/0.1.22/download"],
        strip_prefix = "unicode-normalization-0.1.22",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unicode-normalization-0.1.22.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__unicode-width-0.2.0",
        sha256 = "1fc81956842c57dac11422a97c3b8195a1ff727f06e85c84ed2e8aa277c9a0fd",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-width/0.2.0/download"],
        strip_prefix = "unicode-width-0.2.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.unicode-width-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__url-2.5.4",
        sha256 = "32f8b686cadd1473f4bd0117a5d28d36b1ade384ea9b5069a1c40aefed7fda60",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/url/2.5.4/download"],
        strip_prefix = "url-2.5.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.url-2.5.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__utf16_iter-1.0.5",
        sha256 = "c8232dd3cdaed5356e0f716d285e4b40b932ac434100fe9b7e0e8e935b9e6246",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf16_iter/1.0.5/download"],
        strip_prefix = "utf16_iter-1.0.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.utf16_iter-1.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__utf8_iter-1.0.4",
        sha256 = "b6c140620e7ffbb22c2dee59cafe6084a59b5ffc27a8859a5f0d494b5d52b6be",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8_iter/1.0.4/download"],
        strip_prefix = "utf8_iter-1.0.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.utf8_iter-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__utf8parse-0.2.1",
        sha256 = "711b9620af191e0cdc7468a8d14e709c3dcdb115b36f838e601583af800a370a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8parse/0.2.1/download"],
        strip_prefix = "utf8parse-0.2.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.utf8parse-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__valuable-0.1.0",
        sha256 = "830b7e5d4d90034032940e4ace0d9a9a057e7a45cd94e6c007832e39edb82f6d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/valuable/0.1.0/download"],
        strip_prefix = "valuable-0.1.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.valuable-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__version_check-0.9.4",
        sha256 = "49874b5167b65d7193b8aba1567f5c7d93d001cafc34600cee003eda787e483f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/version_check/0.9.4/download"],
        strip_prefix = "version_check-0.9.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.version_check-0.9.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__walkdir-2.5.0",
        sha256 = "29790946404f91d9c5d06f9874efddea1dc06c5efe94541a7d6863108e3a5e4b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/walkdir/2.5.0/download"],
        strip_prefix = "walkdir-2.5.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.walkdir-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__wasi-0.14.2-wasi-0.2.4",
        sha256 = "9683f9a5a998d873c0d21fcbe3c083009670149a8fab228644b8bd36b2c48cb3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wasi/0.14.2+wasi-0.2.4/download"],
        strip_prefix = "wasi-0.14.2+wasi-0.2.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.wasi-0.14.2+wasi-0.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winapi-util-0.1.5",
        sha256 = "70ec6ce85bb158151cae5e5c87f95a8e97d2c0c4b001223f33a334e3ce5de178",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-util/0.1.5/download"],
        strip_prefix = "winapi-util-0.1.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.winapi-util-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows-sys-0.48.0",
        sha256 = "677d2418bec65e3338edb076e806bc1ec15693c5d0104683f2efe857f61056a9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.48.0/download"],
        strip_prefix = "windows-sys-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows-sys-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows-sys-0.52.0",
        sha256 = "282be5f36a8ce781fad8c8ae18fa3f9beff57ec1b52cb3de0789201425d9a33d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.52.0/download"],
        strip_prefix = "windows-sys-0.52.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows-sys-0.52.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows-sys-0.59.0",
        sha256 = "1e38bc4d79ed67fd075bcc251a1c39b32a1776bbe92e5bef1f0bf1f8c531853b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-sys/0.59.0/download"],
        strip_prefix = "windows-sys-0.59.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows-sys-0.59.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows-targets-0.48.1",
        sha256 = "05d4b17490f70499f20b9e791dcf6a299785ce8af4d709018206dc5b4953e95f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.48.1/download"],
        strip_prefix = "windows-targets-0.48.1",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows-targets-0.48.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows-targets-0.52.6",
        sha256 = "9b724f72796e036ab90c1021d4780d4d3d648aca59e491e6b98e725b84e99973",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows-targets/0.52.6/download"],
        strip_prefix = "windows-targets-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows-targets-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_aarch64_gnullvm-0.48.0",
        sha256 = "91ae572e1b79dba883e0d315474df7305d12f569b400fcf90581b06062f7e1bc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.48.0/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_aarch64_gnullvm-0.52.6",
        sha256 = "32a4622180e7a0ec044bb555404c800bc9fd9ec262ec147edd5989ccd0c02cd3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_aarch64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_aarch64_msvc-0.48.0",
        sha256 = "b2ef27e0d7bdfcfc7b868b317c1d32c641a6fe4629c171b8928c7b08d98d7cf3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.48.0/download"],
        strip_prefix = "windows_aarch64_msvc-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_aarch64_msvc-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_aarch64_msvc-0.52.6",
        sha256 = "09ec2a7bb152e2252b53fa7803150007879548bc709c039df7627cabbd05d469",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_aarch64_msvc/0.52.6/download"],
        strip_prefix = "windows_aarch64_msvc-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_aarch64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_i686_gnu-0.48.0",
        sha256 = "622a1962a7db830d6fd0a69683c80a18fda201879f0f447f065a3b7467daa241",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.48.0/download"],
        strip_prefix = "windows_i686_gnu-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_i686_gnu-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_i686_gnu-0.52.6",
        sha256 = "8e9b5ad5ab802e97eb8e295ac6720e509ee4c243f69d781394014ebfe8bbfa0b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnu/0.52.6/download"],
        strip_prefix = "windows_i686_gnu-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_i686_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_i686_gnullvm-0.52.6",
        sha256 = "0eee52d38c090b3caa76c563b86c3a4bd71ef1a819287c19d586d7334ae8ed66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_gnullvm/0.52.6/download"],
        strip_prefix = "windows_i686_gnullvm-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_i686_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_i686_msvc-0.48.0",
        sha256 = "4542c6e364ce21bf45d69fdd2a8e455fa38d316158cfd43b3ac1c5b1b19f8e00",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.48.0/download"],
        strip_prefix = "windows_i686_msvc-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_i686_msvc-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_i686_msvc-0.52.6",
        sha256 = "240948bc05c5e7c6dabba28bf89d89ffce3e303022809e73deaefe4f6ec56c66",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_i686_msvc/0.52.6/download"],
        strip_prefix = "windows_i686_msvc-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_i686_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_gnu-0.48.0",
        sha256 = "ca2b8a661f7628cbd23440e50b05d705db3686f894fc9580820623656af974b1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.48.0/download"],
        strip_prefix = "windows_x86_64_gnu-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_x86_64_gnu-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_gnu-0.52.6",
        sha256 = "147a5c80aabfbf0c7d901cb5895d1de30ef2907eb21fbbab29ca94c5b08b1a78",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnu/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnu-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_x86_64_gnu-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_gnullvm-0.48.0",
        sha256 = "7896dbc1f41e08872e9d5e8f8baa8fdd2677f29468c4e156210174edc7f7b953",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.48.0/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_gnullvm-0.52.6",
        sha256 = "24d5b23dc417412679681396f2b49f3de8c1473deb516bd34410872eff51ed0d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_gnullvm/0.52.6/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_x86_64_gnullvm-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_msvc-0.48.0",
        sha256 = "1a515f5799fe4961cb532f983ce2b23082366b898e52ffbce459c86f67c8378a",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.48.0/download"],
        strip_prefix = "windows_x86_64_msvc-0.48.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_x86_64_msvc-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__windows_x86_64_msvc-0.52.6",
        sha256 = "589f6da84c646204747d1270a2a5661ea66ed1cced2631d546fdfb155959f9ec",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/windows_x86_64_msvc/0.52.6/download"],
        strip_prefix = "windows_x86_64_msvc-0.52.6",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.windows_x86_64_msvc-0.52.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winnow-0.6.20",
        sha256 = "36c1fec1a2bb5866f07c25f68c26e565c4c200aebb96d7e55710c19d3e8ac49b",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winnow/0.6.20/download"],
        strip_prefix = "winnow-0.6.20",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.winnow-0.6.20.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__winnow-0.7.7",
        sha256 = "6cb8234a863ea0e8cd7284fcdd4f145233eb00fee02bbdd9861aec44e6477bc5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winnow/0.7.7/download"],
        strip_prefix = "winnow-0.7.7",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.winnow-0.7.7.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__wit-bindgen-rt-0.39.0",
        sha256 = "6f42320e61fe2cfd34354ecb597f86f413484a798ba44a8ca1165c58d42da6c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/wit-bindgen-rt/0.39.0/download"],
        strip_prefix = "wit-bindgen-rt-0.39.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.wit-bindgen-rt-0.39.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__write16-1.0.0",
        sha256 = "d1890f4022759daae28ed4fe62859b1236caebfc61ede2f63ed4e695f3f6d936",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/write16/1.0.0/download"],
        strip_prefix = "write16-1.0.0",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.write16-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__writeable-0.5.5",
        sha256 = "1e9df38ee2d2c3c5948ea468a8406ff0db0b29ae1ffde1bcf20ef305bcc95c51",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/writeable/0.5.5/download"],
        strip_prefix = "writeable-0.5.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.writeable-0.5.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__yoke-0.7.5",
        sha256 = "120e6aef9aa629e3d4f52dc8cc43a015c7724194c97dfaf45180d2daf2b77f40",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke/0.7.5/download"],
        strip_prefix = "yoke-0.7.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.yoke-0.7.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__yoke-derive-0.7.5",
        sha256 = "2380878cad4ac9aac1e2435f3eb4020e8374b5f13c296cb75b4620ff8e229154",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke-derive/0.7.5/download"],
        strip_prefix = "yoke-derive-0.7.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.yoke-derive-0.7.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__zerocopy-0.7.35",
        sha256 = "1b9b4fd18abc82b8136838da5d50bae7bdea537c574d8dc1a34ed098d6c166f0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy/0.7.35/download"],
        strip_prefix = "zerocopy-0.7.35",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.zerocopy-0.7.35.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__zerocopy-derive-0.7.35",
        sha256 = "fa4f8080344d4671fb4e831a13ad1e68092748387dfc4f55e356242fae12ce3e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerocopy-derive/0.7.35/download"],
        strip_prefix = "zerocopy-derive-0.7.35",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.zerocopy-derive-0.7.35.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__zerofrom-0.1.5",
        sha256 = "cff3ee08c995dee1859d998dea82f7374f2826091dd9cd47def953cae446cd2e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom/0.1.5/download"],
        strip_prefix = "zerofrom-0.1.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.zerofrom-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__zerofrom-derive-0.1.5",
        sha256 = "595eed982f7d355beb85837f651fa22e90b3c044842dc7f2c2842c086f295808",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom-derive/0.1.5/download"],
        strip_prefix = "zerofrom-derive-0.1.5",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.zerofrom-derive-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__zerovec-0.10.4",
        sha256 = "aa2b893d79df23bfb12d5461018d408ea19dfafe76c2c7ef6d4eba614f8ff079",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec/0.10.4/download"],
        strip_prefix = "zerovec-0.10.4",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.zerovec-0.10.4.bazel"),
    )

    maybe(
        http_archive,
        name = "cui__zerovec-derive-0.10.3",
        sha256 = "6eafa6dfb17584ea3e2bd6e76e0cc15ad7af12b09abdd1ca55961bed9b1063c6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec-derive/0.10.3/download"],
        strip_prefix = "zerovec-derive-0.10.3",
        build_file = Label("//crate_universe/3rdparty/crates:BUILD.zerovec-derive-0.10.3.bazel"),
    )

    return [
        struct(repo = "cui__anyhow-1.0.98", is_dev_dep = False),
        struct(repo = "cui__camino-1.1.9", is_dev_dep = False),
        struct(repo = "cui__cargo-lock-10.1.0", is_dev_dep = False),
        struct(repo = "cui__cargo-platform-0.1.9", is_dev_dep = False),
        struct(repo = "cui__cargo_metadata-0.19.2", is_dev_dep = False),
        struct(repo = "cui__cargo_toml-0.22.1", is_dev_dep = False),
        struct(repo = "cui__cfg-expr-0.18.0", is_dev_dep = False),
        struct(repo = "cui__clap-4.5.37", is_dev_dep = False),
        struct(repo = "cui__crates-index-3.7.0", is_dev_dep = False),
        struct(repo = "cui__glob-0.3.2", is_dev_dep = False),
        struct(repo = "cui__hex-0.4.3", is_dev_dep = False),
        struct(repo = "cui__indoc-2.0.6", is_dev_dep = False),
        struct(repo = "cui__itertools-0.14.0", is_dev_dep = False),
        struct(repo = "cui__normpath-1.3.0", is_dev_dep = False),
        struct(repo = "cui__once_cell-1.21.3", is_dev_dep = False),
        struct(repo = "cui__pathdiff-0.2.3", is_dev_dep = False),
        struct(repo = "cui__regex-1.11.1", is_dev_dep = False),
        struct(repo = "cui__semver-1.0.26", is_dev_dep = False),
        struct(repo = "cui__serde-1.0.219", is_dev_dep = False),
        struct(repo = "cui__serde_json-1.0.140", is_dev_dep = False),
        struct(repo = "cui__serde_starlark-0.1.17", is_dev_dep = False),
        struct(repo = "cui__sha2-0.10.8", is_dev_dep = False),
        struct(repo = "cui__spdx-0.10.8", is_dev_dep = False),
        struct(repo = "cui__tempfile-3.19.1", is_dev_dep = False),
        struct(repo = "cui__tera-1.20.0", is_dev_dep = False),
        struct(repo = "cui__textwrap-0.16.2", is_dev_dep = False),
        struct(repo = "cui__toml-0.8.21", is_dev_dep = False),
        struct(repo = "cui__tracing-0.1.41", is_dev_dep = False),
        struct(repo = "cui__tracing-subscriber-0.3.19", is_dev_dep = False),
        struct(repo = "cui__url-2.5.4", is_dev_dep = False),
        struct(repo = "cui__walkdir-2.5.0", is_dev_dep = False),
        struct(repo = "cui__maplit-1.0.2", is_dev_dep = True),
    ]
