###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @@//cargo/3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({
            tuple(_CONDITIONS[condition]): deps.values(),
            "//conditions:default": [],
        })

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": dict(common_items)}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        for triple in condition_triples:
            if triple in crate_aliases:
                crate_aliases[triple].update(deps)
            else:
                crate_aliases.update({triple: dict(deps.items() + common_items)})

    return select(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "cargo/private/cargo_toml_info": {
        _COMMON_CONDITION: {
            "cargo_toml": Label("@rrc//:cargo_toml-0.20.5"),
        },
    },
    "cargo/private/cargo_toml_variable_extractor": {
        _COMMON_CONDITION: {
            "cargo-util-schemas": Label("@rrc//:cargo-util-schemas-0.3.1"),
            "pathdiff": Label("@rrc//:pathdiff-0.1.0"),
            "semver": Label("@rrc//:semver-1.0.25"),
            "toml": Label("@rrc//:toml-0.8.20"),
        },
    },
}

_NORMAL_ALIASES = {
    "cargo/private/cargo_toml_info": {
        _COMMON_CONDITION: {
        },
    },
    "cargo/private/cargo_toml_variable_extractor": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_NORMAL_DEV_ALIASES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_PROC_MACRO_ALIASES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_BUILD_DEPENDENCIES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_BUILD_ALIASES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "cargo/private/cargo_toml_info": {
    },
    "cargo/private/cargo_toml_variable_extractor": {
    },
}

_CONDITIONS = {
    "aarch64-apple-darwin": ["@rules_rust//rust/platform:aarch64-apple-darwin"],
    "aarch64-apple-ios": ["@rules_rust//rust/platform:aarch64-apple-ios"],
    "aarch64-apple-ios-sim": ["@rules_rust//rust/platform:aarch64-apple-ios-sim"],
    "aarch64-linux-android": ["@rules_rust//rust/platform:aarch64-linux-android"],
    "aarch64-pc-windows-msvc": ["@rules_rust//rust/platform:aarch64-pc-windows-msvc"],
    "aarch64-unknown-fuchsia": ["@rules_rust//rust/platform:aarch64-unknown-fuchsia"],
    "aarch64-unknown-linux-gnu": ["@rules_rust//rust/platform:aarch64-unknown-linux-gnu"],
    "aarch64-unknown-nixos-gnu": ["@rules_rust//rust/platform:aarch64-unknown-nixos-gnu"],
    "aarch64-unknown-nto-qnx710": ["@rules_rust//rust/platform:aarch64-unknown-nto-qnx710"],
    "aarch64-unknown-uefi": ["@rules_rust//rust/platform:aarch64-unknown-uefi"],
    "arm-unknown-linux-gnueabi": ["@rules_rust//rust/platform:arm-unknown-linux-gnueabi"],
    "armv7-linux-androideabi": ["@rules_rust//rust/platform:armv7-linux-androideabi"],
    "armv7-unknown-linux-gnueabi": ["@rules_rust//rust/platform:armv7-unknown-linux-gnueabi"],
    "i686-apple-darwin": ["@rules_rust//rust/platform:i686-apple-darwin"],
    "i686-linux-android": ["@rules_rust//rust/platform:i686-linux-android"],
    "i686-pc-windows-msvc": ["@rules_rust//rust/platform:i686-pc-windows-msvc"],
    "i686-unknown-freebsd": ["@rules_rust//rust/platform:i686-unknown-freebsd"],
    "i686-unknown-linux-gnu": ["@rules_rust//rust/platform:i686-unknown-linux-gnu"],
    "powerpc-unknown-linux-gnu": ["@rules_rust//rust/platform:powerpc-unknown-linux-gnu"],
    "riscv32imc-unknown-none-elf": ["@rules_rust//rust/platform:riscv32imc-unknown-none-elf"],
    "riscv64gc-unknown-linux-gnu": ["@rules_rust//rust/platform:riscv64gc-unknown-linux-gnu"],
    "riscv64gc-unknown-none-elf": ["@rules_rust//rust/platform:riscv64gc-unknown-none-elf"],
    "s390x-unknown-linux-gnu": ["@rules_rust//rust/platform:s390x-unknown-linux-gnu"],
    "thumbv7em-none-eabi": ["@rules_rust//rust/platform:thumbv7em-none-eabi"],
    "thumbv8m.main-none-eabi": ["@rules_rust//rust/platform:thumbv8m.main-none-eabi"],
    "wasm32-unknown-emscripten": ["@rules_rust//rust/platform:wasm32-unknown-emscripten"],
    "wasm32-unknown-unknown": ["@rules_rust//rust/platform:wasm32-unknown-unknown"],
    "wasm32-wasip1": ["@rules_rust//rust/platform:wasm32-wasip1"],
    "wasm32-wasip1-threads": ["@rules_rust//rust/platform:wasm32-wasip1-threads"],
    "wasm32-wasip2": ["@rules_rust//rust/platform:wasm32-wasip2"],
    "x86_64-apple-darwin": ["@rules_rust//rust/platform:x86_64-apple-darwin"],
    "x86_64-apple-ios": ["@rules_rust//rust/platform:x86_64-apple-ios"],
    "x86_64-linux-android": ["@rules_rust//rust/platform:x86_64-linux-android"],
    "x86_64-pc-windows-msvc": ["@rules_rust//rust/platform:x86_64-pc-windows-msvc"],
    "x86_64-unknown-freebsd": ["@rules_rust//rust/platform:x86_64-unknown-freebsd"],
    "x86_64-unknown-fuchsia": ["@rules_rust//rust/platform:x86_64-unknown-fuchsia"],
    "x86_64-unknown-linux-gnu": ["@rules_rust//rust/platform:x86_64-unknown-linux-gnu"],
    "x86_64-unknown-nixos-gnu": ["@rules_rust//rust/platform:x86_64-unknown-nixos-gnu"],
    "x86_64-unknown-none": ["@rules_rust//rust/platform:x86_64-unknown-none"],
    "x86_64-unknown-uefi": ["@rules_rust//rust/platform:x86_64-unknown-uefi"],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates.

    Returns:
      A list of repos visible to the module through the module extension.
    """
    maybe(
        http_archive,
        name = "rrc__autocfg-1.5.0",
        sha256 = "c08606f8c3cbf4ce6ec8e28fb0014a2c086708fe954eaa885384a6165172e7e8",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/autocfg/1.5.0/download"],
        strip_prefix = "autocfg-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.autocfg-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__cargo-util-schemas-0.3.1",
        sha256 = "161d4f7828830c7893180528e121e701bb8070b80c0f97f793a930d285b315a6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo-util-schemas/0.3.1/download"],
        strip_prefix = "cargo-util-schemas-0.3.1",
        build_file = Label("//cargo/3rdparty/crates:BUILD.cargo-util-schemas-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__cargo_toml-0.20.5",
        sha256 = "88da5a13c620b4ca0078845707ea9c3faf11edbc3ffd8497d11d686211cd1ac0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/cargo_toml/0.20.5/download"],
        strip_prefix = "cargo_toml-0.20.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.cargo_toml-0.20.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__displaydoc-0.2.5",
        sha256 = "97369cbbc041bc366949bc74d34658d6cda5621039731c6310521892a3a20ae0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/displaydoc/0.2.5/download"],
        strip_prefix = "displaydoc-0.2.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.displaydoc-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__equivalent-1.0.1",
        sha256 = "5443807d6dff69373d433ab9ef5378ad8df50ca6298caf15de6e52e24aaf54d5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/equivalent/1.0.1/download"],
        strip_prefix = "equivalent-1.0.1",
        build_file = Label("//cargo/3rdparty/crates:BUILD.equivalent-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__erased-serde-0.4.5",
        sha256 = "24e2389d65ab4fab27dc2a5de7b191e1f6617d1f1c8855c0dc569c94a4cbb18d",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/erased-serde/0.4.5/download"],
        strip_prefix = "erased-serde-0.4.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.erased-serde-0.4.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__form_urlencoded-1.2.1",
        sha256 = "e13624c2627564efccf4934284bdd98cbaa14e79b0b5a141218e507b3a823456",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/form_urlencoded/1.2.1/download"],
        strip_prefix = "form_urlencoded-1.2.1",
        build_file = Label("//cargo/3rdparty/crates:BUILD.form_urlencoded-1.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__hashbrown-0.15.2",
        sha256 = "bf151400ff0baff5465007dd2f3e717f3fe502074ca563069ce3a6629d07b289",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/hashbrown/0.15.2/download"],
        strip_prefix = "hashbrown-0.15.2",
        build_file = Label("//cargo/3rdparty/crates:BUILD.hashbrown-0.15.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_collections-1.5.0",
        sha256 = "db2fa452206ebee18c4b5c2274dbf1de17008e874b4dc4f0aea9d01ca79e4526",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_collections/1.5.0/download"],
        strip_prefix = "icu_collections-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_collections-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_locid-1.5.0",
        sha256 = "13acbb8371917fc971be86fc8057c41a64b521c184808a698c02acc242dbf637",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locid/1.5.0/download"],
        strip_prefix = "icu_locid-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_locid-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_locid_transform-1.5.0",
        sha256 = "01d11ac35de8e40fdeda00d9e1e9d92525f3f9d887cdd7aa81d727596788b54e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locid_transform/1.5.0/download"],
        strip_prefix = "icu_locid_transform-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_locid_transform-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_locid_transform_data-1.5.0",
        sha256 = "fdc8ff3388f852bede6b579ad4e978ab004f139284d7b28715f773507b946f6e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_locid_transform_data/1.5.0/download"],
        strip_prefix = "icu_locid_transform_data-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_locid_transform_data-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_normalizer-1.5.0",
        sha256 = "19ce3e0da2ec68599d193c93d088142efd7f9c5d6fc9b803774855747dc6a84f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer/1.5.0/download"],
        strip_prefix = "icu_normalizer-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_normalizer-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_normalizer_data-1.5.0",
        sha256 = "f8cafbf7aa791e9b22bec55a167906f9e1215fd475cd22adfcf660e03e989516",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_normalizer_data/1.5.0/download"],
        strip_prefix = "icu_normalizer_data-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_normalizer_data-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_properties-1.5.1",
        sha256 = "93d6020766cfc6302c15dbbc9c8778c37e62c14427cb7f6e601d849e092aeef5",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties/1.5.1/download"],
        strip_prefix = "icu_properties-1.5.1",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_properties-1.5.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_properties_data-1.5.0",
        sha256 = "67a8effbc3dd3e4ba1afa8ad918d5684b8868b3b26500753effea8d2eed19569",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_properties_data/1.5.0/download"],
        strip_prefix = "icu_properties_data-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_properties_data-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_provider-1.5.0",
        sha256 = "6ed421c8a8ef78d3e2dbc98a973be2f3770cb42b606e3ab18d6237c4dfde68d9",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_provider/1.5.0/download"],
        strip_prefix = "icu_provider-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_provider-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__icu_provider_macros-1.5.0",
        sha256 = "1ec89e9337638ecdc08744df490b221a7399bf8d164eb52a665454e60e075ad6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/icu_provider_macros/1.5.0/download"],
        strip_prefix = "icu_provider_macros-1.5.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.icu_provider_macros-1.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__idna-1.0.3",
        sha256 = "686f825264d630750a544639377bae737628043f20d38bbc029e8f29ea968a7e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna/1.0.3/download"],
        strip_prefix = "idna-1.0.3",
        build_file = Label("//cargo/3rdparty/crates:BUILD.idna-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__idna_adapter-1.2.0",
        sha256 = "daca1df1c957320b2cf139ac61e7bd64fed304c5040df000a745aa1de3b4ef71",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/idna_adapter/1.2.0/download"],
        strip_prefix = "idna_adapter-1.2.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.idna_adapter-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__indexmap-2.7.1",
        sha256 = "8c9c992b02b5b4c94ea26e32fe5bccb7aa7d9f390ab5c1221ff895bc7ea8b652",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/indexmap/2.7.1/download"],
        strip_prefix = "indexmap-2.7.1",
        build_file = Label("//cargo/3rdparty/crates:BUILD.indexmap-2.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__litemap-0.7.4",
        sha256 = "4ee93343901ab17bd981295f2cf0026d4ad018c7c31ba84549a4ddbb47a45104",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/litemap/0.7.4/download"],
        strip_prefix = "litemap-0.7.4",
        build_file = Label("//cargo/3rdparty/crates:BUILD.litemap-0.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__memchr-2.7.4",
        sha256 = "78ca9ab1a0babb1e7d5695e3530886289c18cf2f87ec19a575a0abdce112e3a3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/memchr/2.7.4/download"],
        strip_prefix = "memchr-2.7.4",
        build_file = Label("//cargo/3rdparty/crates:BUILD.memchr-2.7.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__num-traits-0.2.19",
        sha256 = "071dfc062690e90b734c0b2273ce72ad0ffa95f0c74596bc250dcfd960262841",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/num-traits/0.2.19/download"],
        strip_prefix = "num-traits-0.2.19",
        build_file = Label("//cargo/3rdparty/crates:BUILD.num-traits-0.2.19.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__ordered-float-2.10.1",
        sha256 = "68f19d67e5a2795c94e73e0bb1cc1a7edeb2e28efd39e2e1c9b7a40c1108b11c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/ordered-float/2.10.1/download"],
        strip_prefix = "ordered-float-2.10.1",
        build_file = Label("//cargo/3rdparty/crates:BUILD.ordered-float-2.10.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__pathdiff-0.1.0",
        sha256 = "a3bf70094d203e07844da868b634207e71bfab254fe713171fae9a6e751ccf31",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/pathdiff/0.1.0/download"],
        strip_prefix = "pathdiff-0.1.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.pathdiff-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__percent-encoding-2.3.1",
        sha256 = "e3148f5046208a5d56bcfc03053e3ca6334e51da8dfb19b6cdc8b306fae3283e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/percent-encoding/2.3.1/download"],
        strip_prefix = "percent-encoding-2.3.1",
        build_file = Label("//cargo/3rdparty/crates:BUILD.percent-encoding-2.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__proc-macro2-1.0.93",
        sha256 = "60946a68e5f9d28b0dc1c21bb8a97ee7d018a8b322fa57838ba31cc878e22d99",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/proc-macro2/1.0.93/download"],
        strip_prefix = "proc-macro2-1.0.93",
        build_file = Label("//cargo/3rdparty/crates:BUILD.proc-macro2-1.0.93.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__quote-1.0.38",
        sha256 = "0e4dccaaaf89514f546c693ddc140f729f958c247918a13380cccc6078391acc",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/quote/1.0.38/download"],
        strip_prefix = "quote-1.0.38",
        build_file = Label("//cargo/3rdparty/crates:BUILD.quote-1.0.38.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__semver-1.0.25",
        sha256 = "f79dfe2d285b0488816f30e700a7438c5a73d816b5b7d3ac72fbc48b0d185e03",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/semver/1.0.25/download"],
        strip_prefix = "semver-1.0.25",
        build_file = Label("//cargo/3rdparty/crates:BUILD.semver-1.0.25.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__serde-1.0.217",
        sha256 = "02fc4265df13d6fa1d00ecff087228cc0a2b5f3c0e87e258d8b94a156e984c70",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde/1.0.217/download"],
        strip_prefix = "serde-1.0.217",
        build_file = Label("//cargo/3rdparty/crates:BUILD.serde-1.0.217.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__serde-untagged-0.1.6",
        sha256 = "2676ba99bd82f75cae5cbd2c8eda6fa0b8760f18978ea840e980dd5567b5c5b6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde-untagged/0.1.6/download"],
        strip_prefix = "serde-untagged-0.1.6",
        build_file = Label("//cargo/3rdparty/crates:BUILD.serde-untagged-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__serde-value-0.7.0",
        sha256 = "f3a1a3341211875ef120e117ea7fd5228530ae7e7036a779fdc9117be6b3282c",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde-value/0.7.0/download"],
        strip_prefix = "serde-value-0.7.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.serde-value-0.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__serde_derive-1.0.217",
        sha256 = "5a9bf7cf98d04a2b28aead066b7496853d4779c9cc183c440dbac457641e19a0",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_derive/1.0.217/download"],
        strip_prefix = "serde_derive-1.0.217",
        build_file = Label("//cargo/3rdparty/crates:BUILD.serde_derive-1.0.217.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__serde_spanned-0.6.8",
        sha256 = "87607cb1398ed59d48732e575a4c28a7a8ebf2454b964fe3f224f2afc07909e1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/serde_spanned/0.6.8/download"],
        strip_prefix = "serde_spanned-0.6.8",
        build_file = Label("//cargo/3rdparty/crates:BUILD.serde_spanned-0.6.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__smallvec-1.13.2",
        sha256 = "3c5e1a9a646d36c3599cd173a41282daf47c44583ad367b8e6837255952e5c67",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/smallvec/1.13.2/download"],
        strip_prefix = "smallvec-1.13.2",
        build_file = Label("//cargo/3rdparty/crates:BUILD.smallvec-1.13.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__stable_deref_trait-1.2.0",
        sha256 = "a8f112729512f8e442d81f95a8a7ddf2b7c6b8a1a6f509a95864142b30cab2d3",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/stable_deref_trait/1.2.0/download"],
        strip_prefix = "stable_deref_trait-1.2.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.stable_deref_trait-1.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__syn-2.0.98",
        sha256 = "36147f1a48ae0ec2b5b3bc5b537d267457555a10dc06f3dbc8cb11ba3006d3b1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/syn/2.0.98/download"],
        strip_prefix = "syn-2.0.98",
        build_file = Label("//cargo/3rdparty/crates:BUILD.syn-2.0.98.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__synstructure-0.13.1",
        sha256 = "c8af7666ab7b6390ab78131fb5b0fce11d6b7a6951602017c35fa82800708971",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/synstructure/0.13.1/download"],
        strip_prefix = "synstructure-0.13.1",
        build_file = Label("//cargo/3rdparty/crates:BUILD.synstructure-0.13.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__thiserror-1.0.69",
        sha256 = "b6aaf5339b578ea85b50e080feb250a3e8ae8cfcdff9a461c9ec2904bc923f52",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror/1.0.69/download"],
        strip_prefix = "thiserror-1.0.69",
        build_file = Label("//cargo/3rdparty/crates:BUILD.thiserror-1.0.69.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__thiserror-impl-1.0.69",
        sha256 = "4fee6c4efc90059e10f81e6d42c60a18f76588c3d74cb83a0b242a2b6c7504c1",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/thiserror-impl/1.0.69/download"],
        strip_prefix = "thiserror-impl-1.0.69",
        build_file = Label("//cargo/3rdparty/crates:BUILD.thiserror-impl-1.0.69.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__tinystr-0.7.6",
        sha256 = "9117f5d4db391c1cf6927e7bea3db74b9a1c1add8f7eda9ffd5364f40f57b82f",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/tinystr/0.7.6/download"],
        strip_prefix = "tinystr-0.7.6",
        build_file = Label("//cargo/3rdparty/crates:BUILD.tinystr-0.7.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__toml-0.8.20",
        sha256 = "cd87a5cdd6ffab733b2f74bc4fd7ee5fff6634124999ac278c35fc78c6120148",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml/0.8.20/download"],
        strip_prefix = "toml-0.8.20",
        build_file = Label("//cargo/3rdparty/crates:BUILD.toml-0.8.20.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__toml_datetime-0.6.8",
        sha256 = "0dd7358ecb8fc2f8d014bf86f6f638ce72ba252a2c3a2572f2a795f1d23efb41",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml_datetime/0.6.8/download"],
        strip_prefix = "toml_datetime-0.6.8",
        build_file = Label("//cargo/3rdparty/crates:BUILD.toml_datetime-0.6.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__toml_edit-0.22.24",
        sha256 = "17b4795ff5edd201c7cd6dca065ae59972ce77d1b80fa0a84d94950ece7d1474",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/toml_edit/0.22.24/download"],
        strip_prefix = "toml_edit-0.22.24",
        build_file = Label("//cargo/3rdparty/crates:BUILD.toml_edit-0.22.24.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__typeid-1.0.2",
        sha256 = "0e13db2e0ccd5e14a544e8a246ba2312cd25223f616442d7f2cb0e3db614236e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/typeid/1.0.2/download"],
        strip_prefix = "typeid-1.0.2",
        build_file = Label("//cargo/3rdparty/crates:BUILD.typeid-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__unicode-ident-1.0.16",
        sha256 = "a210d160f08b701c8721ba1c726c11662f877ea6b7094007e1ca9a1041945034",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-ident/1.0.16/download"],
        strip_prefix = "unicode-ident-1.0.16",
        build_file = Label("//cargo/3rdparty/crates:BUILD.unicode-ident-1.0.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__unicode-xid-0.2.6",
        sha256 = "ebc1c04c71510c7f702b52b7c350734c9ff1295c464a03335b00bb84fc54f853",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/unicode-xid/0.2.6/download"],
        strip_prefix = "unicode-xid-0.2.6",
        build_file = Label("//cargo/3rdparty/crates:BUILD.unicode-xid-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__url-2.5.4",
        sha256 = "32f8b686cadd1473f4bd0117a5d28d36b1ade384ea9b5069a1c40aefed7fda60",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/url/2.5.4/download"],
        strip_prefix = "url-2.5.4",
        build_file = Label("//cargo/3rdparty/crates:BUILD.url-2.5.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__utf16_iter-1.0.5",
        sha256 = "c8232dd3cdaed5356e0f716d285e4b40b932ac434100fe9b7e0e8e935b9e6246",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf16_iter/1.0.5/download"],
        strip_prefix = "utf16_iter-1.0.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.utf16_iter-1.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__utf8_iter-1.0.4",
        sha256 = "b6c140620e7ffbb22c2dee59cafe6084a59b5ffc27a8859a5f0d494b5d52b6be",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/utf8_iter/1.0.4/download"],
        strip_prefix = "utf8_iter-1.0.4",
        build_file = Label("//cargo/3rdparty/crates:BUILD.utf8_iter-1.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__winnow-0.7.2",
        sha256 = "59690dea168f2198d1a3b0cac23b8063efcd11012f10ae4698f284808c8ef603",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/winnow/0.7.2/download"],
        strip_prefix = "winnow-0.7.2",
        build_file = Label("//cargo/3rdparty/crates:BUILD.winnow-0.7.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__write16-1.0.0",
        sha256 = "d1890f4022759daae28ed4fe62859b1236caebfc61ede2f63ed4e695f3f6d936",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/write16/1.0.0/download"],
        strip_prefix = "write16-1.0.0",
        build_file = Label("//cargo/3rdparty/crates:BUILD.write16-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__writeable-0.5.5",
        sha256 = "1e9df38ee2d2c3c5948ea468a8406ff0db0b29ae1ffde1bcf20ef305bcc95c51",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/writeable/0.5.5/download"],
        strip_prefix = "writeable-0.5.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.writeable-0.5.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__yoke-0.7.5",
        sha256 = "120e6aef9aa629e3d4f52dc8cc43a015c7724194c97dfaf45180d2daf2b77f40",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke/0.7.5/download"],
        strip_prefix = "yoke-0.7.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.yoke-0.7.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__yoke-derive-0.7.5",
        sha256 = "2380878cad4ac9aac1e2435f3eb4020e8374b5f13c296cb75b4620ff8e229154",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/yoke-derive/0.7.5/download"],
        strip_prefix = "yoke-derive-0.7.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.yoke-derive-0.7.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__zerofrom-0.1.5",
        sha256 = "cff3ee08c995dee1859d998dea82f7374f2826091dd9cd47def953cae446cd2e",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom/0.1.5/download"],
        strip_prefix = "zerofrom-0.1.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.zerofrom-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__zerofrom-derive-0.1.5",
        sha256 = "595eed982f7d355beb85837f651fa22e90b3c044842dc7f2c2842c086f295808",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerofrom-derive/0.1.5/download"],
        strip_prefix = "zerofrom-derive-0.1.5",
        build_file = Label("//cargo/3rdparty/crates:BUILD.zerofrom-derive-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__zerovec-0.10.4",
        sha256 = "aa2b893d79df23bfb12d5461018d408ea19dfafe76c2c7ef6d4eba614f8ff079",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec/0.10.4/download"],
        strip_prefix = "zerovec-0.10.4",
        build_file = Label("//cargo/3rdparty/crates:BUILD.zerovec-0.10.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rrc__zerovec-derive-0.10.3",
        sha256 = "6eafa6dfb17584ea3e2bd6e76e0cc15ad7af12b09abdd1ca55961bed9b1063c6",
        type = "tar.gz",
        urls = ["https://static.crates.io/crates/zerovec-derive/0.10.3/download"],
        strip_prefix = "zerovec-derive-0.10.3",
        build_file = Label("//cargo/3rdparty/crates:BUILD.zerovec-derive-0.10.3.bazel"),
    )

    return [
        struct(repo = "rrc__cargo-util-schemas-0.3.1", is_dev_dep = False),
        struct(repo = "rrc__cargo_toml-0.20.5", is_dev_dep = False),
        struct(repo = "rrc__pathdiff-0.1.0", is_dev_dep = False),
        struct(repo = "rrc__semver-1.0.25", is_dev_dep = False),
        struct(repo = "rrc__toml-0.8.20", is_dev_dep = False),
    ]
