#pragma once

#include <stdio.h>
#include <string.h>

//
// Keyboard definition. Everything below = 0x100 matches
// a mode 1 keyboard scan code.
//

enum EKeyCodes
{
	KEY_PAUSE				= 0xc5,	// DIK_PAUSE
	KEY_RIGHTARROW			= 0xcd,	// DIK_RIGHT
	KEY_LEFTARROW			= 0xcb,	// DIK_LEFT
	KEY_UPARROW 			= 0xc8,	// DIK_UP
	KEY_DOWNARROW			= 0xd0,	// DIK_DOWN
	KEY_ESCAPE				= 0x01,	// DIK_ESCAPE
	KEY_ENTER				= 0x1c,	// DIK_RETURN
	KEY_SPACE				= 0x39,	// DIK_SPACE
	KEY_TAB 				= 0x0f,	// DIK_TAB
	KEY_F1					= 0x3b,	// DIK_F1
	KEY_F2					= 0x3c,	// DIK_F2
	KEY_F3					= 0x3d,	// DIK_F3
	KEY_F4					= 0x3e,	// DIK_F4
	KEY_F5					= 0x3f,	// DIK_F5
	KEY_F6					= 0x40,	// DIK_F6
	KEY_F7					= 0x41,	// DIK_F7
	KEY_F8					= 0x42,	// DIK_F8
	KEY_F9					= 0x43,	// DIK_F9
	KEY_F10 				= 0x44,	// DIK_F10
	KEY_F11 				= 0x57,	// DIK_F11
	KEY_F12 				= 0x58,	// DIK_F12
	KEY_GRAVE				= 0x29,	// DIK_GRAVE

	KEY_BACKSPACE			= 0x0e,	// DIK_BACK

	KEY_EQUALS				= 0x0d,	// DIK_EQUALS
	KEY_MINUS				= 0x0c,	// DIK_MINUS

	KEY_LSHIFT				= 0x2A,	// DIK_LSHIFT
	KEY_LCTRL				= 0x1d,	// DIK_LCONTROL
	KEY_LALT				= 0x38,	// DIK_LMENU

	KEY_RSHIFT				= 0x36,
	KEY_RCTRL				= 0x9d,
	KEY_RALT				= 0xb8,

	KEY_INS 				= 0xd2,	// DIK_INSERT
	KEY_DEL 				= 0xd3,	// DIK_DELETE
	KEY_END 				= 0xcf,	// DIK_END
	KEY_HOME				= 0xc7,	// DIK_HOME
	KEY_PGUP				= 0xc9,	// DIK_PRIOR
	KEY_PGDN				= 0xd1,	// DIK_NEXT

	KEY_VOLUMEDOWN			= 0xAE, // DIK_VOLUMEDOWN
	KEY_VOLUMEUP			= 0xB0, // DIK_VOLUMEUP

	KEY_FIRSTMOUSEBUTTON	= 0x100,
	KEY_MOUSE1				= 0x100,
	KEY_MOUSE2				= 0x101,
	KEY_MOUSE3				= 0x102,
	KEY_MOUSE4				= 0x103,
	KEY_MOUSE5				= 0x104,
	KEY_MOUSE6				= 0x105,
	KEY_MOUSE7				= 0x106,
	KEY_MOUSE8				= 0x107,

	KEY_FIRSTJOYBUTTON		= 0x108,
	KEY_FIRSTJOY2BUTTON		= 0x128,
	KEY_FIRSTJOY3BUTTON		= 0x148,
	KEY_FIRSTJOY4BUTTON		= 0x168,
	KEY_JOY1				= KEY_FIRSTJOYBUTTON+0,
	KEY_JOY2,
	KEY_JOY3,
	KEY_JOY4,
	KEY_JOY5,
	KEY_JOY6,
	KEY_JOY7,
	KEY_JOY8,
	KEY_JOY14			= KEY_FIRSTJOYBUTTON+13,
	KEY_JOY15			= KEY_FIRSTJOYBUTTON+14,
	KEY_LASTJOYBUTTON		= 0x187,
	KEY_JOYPOV1_UP			= 0x188,
	KEY_JOYPOV1_RIGHT		= 0x189,
	KEY_JOYPOV1_DOWN		= 0x18a,
	KEY_JOYPOV1_LEFT		= 0x18b,
	KEY_JOYPOV2_UP			= 0x18c,
	KEY_JOYPOV3_UP			= 0x190,
	KEY_JOYPOV4_UP			= 0x194,

	KEY_MWHEELUP			= 0x198,
	KEY_MWHEELDOWN			= 0x199,
	KEY_MWHEELRIGHT			= 0x19A,
	KEY_MWHEELLEFT			= 0x19B,

	KEY_JOYAXIS1PLUS		= 0x19C,
	KEY_JOYAXIS1MINUS		= 0x19D,
	KEY_JOYAXIS2PLUS		= 0x19E,
	KEY_JOYAXIS2MINUS		= 0x19F,
	KEY_JOYAXIS3PLUS		= 0x1A0,
	KEY_JOYAXIS3MINUS		= 0x1A1,
	KEY_JOYAXIS4PLUS		= 0x1A2,
	KEY_JOYAXIS4MINUS		= 0x1A3,
	KEY_JOYAXIS5PLUS		= 0x1A4,
	KEY_JOYAXIS5MINUS		= 0x1A5,
	KEY_JOYAXIS6PLUS		= 0x1A6,
	KEY_JOYAXIS6MINUS		= 0x1A7,
	KEY_JOYAXIS7PLUS		= 0x1A8,
	KEY_JOYAXIS7MINUS		= 0x1A9,
	KEY_JOYAXIS8PLUS		= 0x1AA,
	KEY_JOYAXIS8MINUS		= 0x1AB,

	KEY_PAD_LTHUMB_RIGHT	= 0x1AC,
	KEY_PAD_LTHUMB_LEFT		= 0x1AD,
	KEY_PAD_LTHUMB_DOWN		= 0x1AE,
	KEY_PAD_LTHUMB_UP		= 0x1AF,

	KEY_PAD_RTHUMB_RIGHT	= 0x1B0,
	KEY_PAD_RTHUMB_LEFT		= 0x1B1,
	KEY_PAD_RTHUMB_DOWN		= 0x1B2,
	KEY_PAD_RTHUMB_UP		= 0x1B3,

	KEY_PAD_DPAD_UP			= 0x1B4,
	KEY_PAD_DPAD_DOWN		= 0x1B5,
	KEY_PAD_DPAD_LEFT		= 0x1B6,
	KEY_PAD_DPAD_RIGHT		= 0x1B7,
	KEY_PAD_START			= 0x1B8,
	KEY_PAD_BACK			= 0x1B9,
	KEY_PAD_LTHUMB			= 0x1BA,
	KEY_PAD_RTHUMB			= 0x1BB,
	KEY_PAD_LSHOULDER		= 0x1BC,
	KEY_PAD_RSHOULDER		= 0x1BD,
	KEY_PAD_LTRIGGER		= 0x1BE,
	KEY_PAD_RTRIGGER		= 0x1BF,
	KEY_PAD_A				= 0x1C0,
	KEY_PAD_B				= 0x1C1,
	KEY_PAD_X				= 0x1C2,
	KEY_PAD_Y				= 0x1C3,

	KEY_JOY2POV1_UP			= 0x1C4,
	KEY_JOY2POV2_UP			= 0x1C8,
	KEY_JOY2POV3_UP			= 0x1CC,
	KEY_JOY2POV4_UP			= 0x1D0,
	KEY_JOY3POV1_UP			= 0x1D4,
	KEY_JOY3POV2_UP			= 0x1D8,
	KEY_JOY3POV3_UP			= 0x1DC,
	KEY_JOY3POV4_UP			= 0x1E0,
	KEY_JOY4POV1_UP			= 0x1E4,
	KEY_JOY4POV2_UP			= 0x1E8,
	KEY_JOY4POV3_UP			= 0x1EC,
	KEY_JOY4POV4_UP			= 0x1F0,

	KEY_JOY2AXIS1PLUS		= 0x1F4,
	KEY_JOY2AXIS1MINUS		= 0x1F5,
	KEY_JOY2AXIS2PLUS		= 0x1F6,
	KEY_JOY2AXIS2MINUS		= 0x1F7,
	KEY_JOY2AXIS3PLUS		= 0x1F8,
	KEY_JOY2AXIS3MINUS		= 0x1F9,
	KEY_JOY2AXIS4PLUS		= 0x1FA,
	KEY_JOY2AXIS4MINUS		= 0x1FB,
	KEY_JOY2AXIS5PLUS		= 0x1FC,
	KEY_JOY2AXIS5MINUS		= 0x1FD,
	KEY_JOY2AXIS6PLUS		= 0x1FE,
	KEY_JOY2AXIS6MINUS		= 0x1FF,
	KEY_JOY2AXIS7PLUS		= 0x200,
	KEY_JOY2AXIS7MINUS		= 0x201,
	KEY_JOY2AXIS8PLUS		= 0x202,
	KEY_JOY2AXIS8MINUS		= 0x203,
	KEY_JOY3AXIS1PLUS		= 0x204,
	KEY_JOY3AXIS1MINUS		= 0x205,
	KEY_JOY3AXIS2PLUS		= 0x206,
	KEY_JOY3AXIS2MINUS		= 0x207,
	KEY_JOY3AXIS3PLUS		= 0x208,
	KEY_JOY3AXIS3MINUS		= 0x209,
	KEY_JOY3AXIS4PLUS		= 0x20A,
	KEY_JOY3AXIS4MINUS		= 0x20B,
	KEY_JOY3AXIS5PLUS		= 0x20C,
	KEY_JOY3AXIS5MINUS		= 0x20D,
	KEY_JOY3AXIS6PLUS		= 0x20E,
	KEY_JOY3AXIS6MINUS		= 0x20F,
	KEY_JOY3AXIS7PLUS		= 0x210,
	KEY_JOY3AXIS7MINUS		= 0x211,
	KEY_JOY3AXIS8PLUS		= 0x212,
	KEY_JOY3AXIS8MINUS		= 0x213,
	KEY_JOY4AXIS1PLUS		= 0x214,
	KEY_JOY4AXIS1MINUS		= 0x215,
	KEY_JOY4AXIS2PLUS		= 0x216,
	KEY_JOY4AXIS2MINUS		= 0x217,
	KEY_JOY4AXIS3PLUS		= 0x218,
	KEY_JOY4AXIS3MINUS		= 0x219,
	KEY_JOY4AXIS4PLUS		= 0x21A,
	KEY_JOY4AXIS4MINUS		= 0x21B,
	KEY_JOY4AXIS5PLUS		= 0x21C,
	KEY_JOY4AXIS5MINUS		= 0x21D,
	KEY_JOY4AXIS6PLUS		= 0x21E,
	KEY_JOY4AXIS6MINUS		= 0x21F,
	KEY_JOY4AXIS7PLUS		= 0x220,
	KEY_JOY4AXIS7MINUS		= 0x221,
	KEY_JOY4AXIS8PLUS		= 0x222,
	KEY_JOY4AXIS8MINUS		= 0x223,

	KEY_PAD2_LTHUMB_RIGHT	= 0x224,
	KEY_PAD2_LTHUMB_LEFT	= 0x225,
	KEY_PAD2_LTHUMB_DOWN	= 0x226,
	KEY_PAD2_LTHUMB_UP		= 0x227,

	KEY_PAD2_RTHUMB_RIGHT	= 0x228,
	KEY_PAD2_RTHUMB_LEFT	= 0x229,
	KEY_PAD2_RTHUMB_DOWN	= 0x22A,
	KEY_PAD2_RTHUMB_UP		= 0x22B,

	KEY_PAD2_DPAD_UP		= 0x22C,
	KEY_PAD2_DPAD_DOWN		= 0x22D,
	KEY_PAD2_DPAD_LEFT		= 0x22E,
	KEY_PAD2_DPAD_RIGHT		= 0x22F,
	KEY_PAD2_START			= 0x230,
	KEY_PAD2_BACK			= 0x231,
	KEY_PAD2_LTHUMB			= 0x232,
	KEY_PAD2_RTHUMB			= 0x233,
	KEY_PAD2_LSHOULDER		= 0x234,
	KEY_PAD2_RSHOULDER		= 0x235,
	KEY_PAD2_LTRIGGER		= 0x236,
	KEY_PAD2_RTRIGGER		= 0x237,
	KEY_PAD2_A				= 0x238,
	KEY_PAD2_B				= 0x239,
	KEY_PAD2_X				= 0x23A,
	KEY_PAD2_Y				= 0x23B,

	KEY_PAD3_LTHUMB_RIGHT	= 0x23C,
	KEY_PAD3_LTHUMB_LEFT	= 0x23D,
	KEY_PAD3_LTHUMB_DOWN	= 0x23E,
	KEY_PAD3_LTHUMB_UP		= 0x23F,

	KEY_PAD3_RTHUMB_RIGHT	= 0x240,
	KEY_PAD3_RTHUMB_LEFT	= 0x241,
	KEY_PAD3_RTHUMB_DOWN	= 0x242,
	KEY_PAD3_RTHUMB_UP		= 0x243,

	KEY_PAD3_DPAD_UP		= 0x244,
	KEY_PAD3_DPAD_DOWN		= 0x245,
	KEY_PAD3_DPAD_LEFT		= 0x246,
	KEY_PAD3_DPAD_RIGHT		= 0x247,
	KEY_PAD3_START			= 0x248,
	KEY_PAD3_BACK			= 0x249,
	KEY_PAD3_LTHUMB			= 0x24A,
	KEY_PAD3_RTHUMB			= 0x24B,
	KEY_PAD3_LSHOULDER		= 0x24C,
	KEY_PAD3_RSHOULDER		= 0x24D,
	KEY_PAD3_LTRIGGER		= 0x24E,
	KEY_PAD3_RTRIGGER		= 0x24F,
	KEY_PAD3_A				= 0x250,
	KEY_PAD3_B				= 0x251,
	KEY_PAD3_X				= 0x252,
	KEY_PAD3_Y				= 0x253,

	KEY_PAD4_LTHUMB_RIGHT	= 0x254,
	KEY_PAD4_LTHUMB_LEFT	= 0x255,
	KEY_PAD4_LTHUMB_DOWN	= 0x256,
	KEY_PAD4_LTHUMB_UP		= 0x257,

	KEY_PAD4_RTHUMB_RIGHT	= 0x258,
	KEY_PAD4_RTHUMB_LEFT	= 0x259,
	KEY_PAD4_RTHUMB_DOWN	= 0x25A,
	KEY_PAD4_RTHUMB_UP		= 0x25B,

	KEY_PAD4_DPAD_UP		= 0x25C,
	KEY_PAD4_DPAD_DOWN		= 0x25D,
	KEY_PAD4_DPAD_LEFT		= 0x25E,
	KEY_PAD4_DPAD_RIGHT		= 0x25F,
	KEY_PAD4_START			= 0x260,
	KEY_PAD4_BACK			= 0x261,
	KEY_PAD4_LTHUMB			= 0x262,
	KEY_PAD4_RTHUMB			= 0x263,
	KEY_PAD4_LSHOULDER		= 0x264,
	KEY_PAD4_RSHOULDER		= 0x265,
	KEY_PAD4_LTRIGGER		= 0x266,
	KEY_PAD4_RTRIGGER		= 0x267,
	KEY_PAD4_A				= 0x268,
	KEY_PAD4_B				= 0x269,
	KEY_PAD4_X				= 0x26A,
	KEY_PAD4_Y				= 0x26B,

	NUM_KEYS				= 0x26C,


	NUM_JOYAXISBUTTONS		= 8,
};

