/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util.zip;

import com.googlecode.d2j.util.zip.ZipConstants;
import com.googlecode.d2j.util.zip.ZipFile;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.GregorianCalendar;

public final class ZipEntry
implements ZipConstants,
Cloneable {
    String name;
    String comment;
    long crc = -1L;
    long compressedSize = -1L;
    long size = -1L;
    int compressionMethod = -1;
    int time = -1;
    int modDate = -1;
    byte[] extra;
    int nameLength = -1;
    long localHeaderRelOffset = -1L;
    public static final int DEFLATED = 8;
    public static final int STORED = 0;

    public String getComment() {
        return this.comment;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc() {
        return this.crc;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public int getMethod() {
        return this.compressionMethod;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        if (this.time != -1) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(14, 0);
            cal.set(1980 + (this.modDate >> 9 & 0x7F), (this.modDate >> 5 & 0xF) - 1, this.modDate & 0x1F, this.time >> 11 & 0x1F, this.time >> 5 & 0x3F, (this.time & 0x1F) << 1);
            return cal.getTime().getTime();
        }
        return -1L;
    }

    public boolean isDirectory() {
        return this.name.charAt(this.name.length() - 1) == '/';
    }

    public String toString() {
        return this.name;
    }

    public Object clone() {
        try {
            ZipEntry result = (ZipEntry)super.clone();
            result.extra = this.extra != null ? (byte[])this.extra.clone() : null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    ZipEntry(ByteBuffer it0, boolean skipCommentsAndExtra) throws IOException {
        ByteBuffer it = (ByteBuffer)it0.slice().order(ByteOrder.LITTLE_ENDIAN).limit(46);
        ZipFile.skip(it0, 46);
        int sig = it.getInt();
        if ((long)sig != 33639248L) {
            ZipFile.throwZipException("Central Directory Entry", sig);
        }
        it.position(8);
        int gpbf = it.getShort() & 0xFFFF;
        this.compressionMethod = it.getShort() & 0xFFFF;
        this.time = it.getShort() & 0xFFFF;
        this.modDate = it.getShort() & 0xFFFF;
        this.crc = (long)it.getInt() & 0xFFFFFFFFL;
        this.compressedSize = (long)it.getInt() & 0xFFFFFFFFL;
        this.size = (long)it.getInt() & 0xFFFFFFFFL;
        this.nameLength = it.getShort() & 0xFFFF;
        int extraLength = it.getShort() & 0xFFFF;
        int commentByteCount = it.getShort() & 0xFFFF;
        it.position(42);
        this.localHeaderRelOffset = (long)it.getInt() & 0xFFFFFFFFL;
        byte[] nameBytes = new byte[this.nameLength];
        it0.get(nameBytes);
        this.name = new String(nameBytes, 0, nameBytes.length, StandardCharsets.UTF_8);
        if (extraLength > 0) {
            if (skipCommentsAndExtra) {
                ZipFile.skip(it0, extraLength);
            } else {
                this.extra = new byte[extraLength];
                it.get(this.extra);
            }
        }
        if (commentByteCount > 0) {
            if (skipCommentsAndExtra) {
                ZipFile.skip(it0, commentByteCount);
            } else {
                byte[] commentBytes = new byte[commentByteCount];
                it0.get(commentBytes);
                this.comment = new String(commentBytes, 0, commentBytes.length, StandardCharsets.UTF_8);
            }
        }
    }

    private static boolean containsNulByte(byte[] bytes) {
        for (byte b : bytes) {
            if (b != 0) continue;
            return true;
        }
        return false;
    }
}

