# Deno Standard Library

[![JSR @std](https://jsr.io/badges/@std)](https://jsr.io/@std)
[![codecov](https://codecov.io/gh/denoland/std/branch/main/graph/badge.svg?token=w6s3ODtULz)](https://codecov.io/gh/denoland/std)
[![ci](https://github.com/denoland/std/actions/workflows/ci.yml/badge.svg)](https://github.com/denoland/std/actions/workflows/ci.yml)

High-quality APIs for [Deno](https://deno.com/) and the web. Use fearlessly.

> [!IMPORTANT]
> Newer versions of the Standard Library are now hosted on
> [JSR](https://jsr.io/@std). Older versions up till 0.224.0 are still available
> at [deno.land/std](https://deno.land/std).

## Resources

- [Package list](https://jsr.io/@std)
- [Architecture guide](./.github/ARCHITECTURE.md)
- [Design documentation](.github/ARCHITECTURE.md#design)
- [Contributing guidelines](.github/CONTRIBUTING.md)
- [Frequently asked questions (FAQ)](./.github/FAQ.md)
- [Test coverage explorer](https://std-coverage.deno.dev/)

## Releases

Package versions >=1.0.0 follow [Semantic Versioning](https://semver.org/), and
package versions <1.0.0 follow
[this proposal](https://github.com/semver/semver/pull/923).

## Badge

> [!NOTE]
> Previously, this repo hosted the badge SVG file. Now, the badge is retrieved
> directly from [Shields.io](https://shields.io/).

[![Built with the Deno Standard Library](https://img.shields.io/badge/Built_with_std-black?logo=deno)](https://jsr.io/@std)

```html
<a href="https://jsr.io/@std">
  <img
    width="135"
    height="20"
    src="https://img.shields.io/badge/Built_with_std-black?logo=deno"
    alt="Built with the Deno Standard Library"
  />
</a>
```

```md
[![Built with the Deno Standard Library](https://img.shields.io/badge/Built_with_std-black?logo=deno)](https://jsr.io/@std)
```
