/*
 *
 *  Copyright (C) 2022, OFFIS e.V.
 *  All rights reserved.  See COPYRIGHT file for details.
 *
 *  This software and supporting documentation were developed by
 *
 *    OFFIS e.V.
 *    R&D Division Health
 *    Escherweg 2
 *    D-26121 Oldenburg, Germany
 *
 *
 *  Module:  oficonv
 *
 *  Author:  Marco Eichelberg
 *
 *  Purpose: JIS_X0212 related tables for oficonv unit tests
 *
 */

#ifndef TABLES_JIS_X0212_H
#define TABLES_JIS_X0212_H

unsigned char jis_x0212_row_02[] = {
    0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x42, 0x43, 
    0x44, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71
};

unsigned char jis_x0212_row_06[] = {
    0x61, 0x62, 0x63, 0x64, 0x65, 0x67, 0x69, 0x6a, 0x6c, 0x71, 0x72, 0x73, 0x74, 
    0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c
};

unsigned char jis_x0212_row_07[] = {
    0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 
    0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e
};

unsigned char jis_x0212_row_09[] = {
    0x21, 0x22, 0x24, 0x26, 0x28, 0x29, 0x2b, 0x2c, 0x2d, 0x2f, 0x30, 0x41, 0x42, 
    0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 
    0x50
};

unsigned char jis_x0212_row_10[] = {
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77
};

unsigned char jis_x0212_row_11[] = {
    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 
    0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 
    0x3b, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x45, 0x46, 0x47, 0x48, 0x49, 
    0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 
    0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x63, 
    0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 
    0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77
};

unsigned char jis_x0212_row_16_to_76[] = {
        0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
  0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
  0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
  0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
  0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
  0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e
};

unsigned char jis_x0212_row_77[] = {
    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 
    0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 
    0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 
    0x55, 0x56, 0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 
    0x62, 0x63, 
};

// Non-Kanji rows

unsigned char jis_x0212_row_02_converted_to_utf8[] = {
  0xcb, 0x98, 0xcb, 0x87, 0xc2, 0xb8, 0xcb, 0x99, 0xcb, 0x9d, 0xc2, 0xaf,
  0xcb, 0x9b, 0xcb, 0x9a, 0x7e, 0xce, 0x84, 0xce, 0x85, 0xc2, 0xa1, 0xc2,
  0xa6, 0xc2, 0xbf, 0xc2, 0xba, 0xc2, 0xaa, 0xc2, 0xa9, 0xc2, 0xae, 0xe2,
  0x84, 0xa2, 0xc2, 0xa4, 0xe2, 0x84, 0x96
};

unsigned char jis_x0212_row_06_converted_to_utf8[] = {
  0xce, 0x86, 0xce, 0x88, 0xce, 0x89, 0xce, 0x8a, 0xce, 0xaa, 0xce, 0x8c,
  0xce, 0x8e, 0xce, 0xab, 0xce, 0x8f, 0xce, 0xac, 0xce, 0xad, 0xce, 0xae,
  0xce, 0xaf, 0xcf, 0x8a, 0xce, 0x90, 0xcf, 0x8c, 0xcf, 0x82, 0xcf, 0x8d,
  0xcf, 0x8b, 0xce, 0xb0, 0xcf, 0x8e
};

unsigned char jis_x0212_row_07_converted_to_utf8[] = {
  0xd0, 0x82, 0xd0, 0x83, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x86, 0xd0, 0x87,
  0xd0, 0x88, 0xd0, 0x89, 0xd0, 0x8a, 0xd0, 0x8b, 0xd0, 0x8c, 0xd0, 0x8e,
  0xd0, 0x8f, 0xd1, 0x92, 0xd1, 0x93, 0xd1, 0x94, 0xd1, 0x95, 0xd1, 0x96,
  0xd1, 0x97, 0xd1, 0x98, 0xd1, 0x99, 0xd1, 0x9a, 0xd1, 0x9b, 0xd1, 0x9c,
  0xd1, 0x9e, 0xd1, 0x9f
};

unsigned char jis_x0212_row_09_converted_to_utf8[] = {
  0xc3, 0x86, 0xc4, 0x90, 0xc4, 0xa6, 0xc4, 0xb2, 0xc5, 0x81, 0xc4, 0xbf,
  0xc5, 0x8a, 0xc3, 0x98, 0xc5, 0x92, 0xc5, 0xa6, 0xc3, 0x9e, 0xc3, 0xa6,
  0xc4, 0x91, 0xc3, 0xb0, 0xc4, 0xa7, 0xc4, 0xb1, 0xc4, 0xb3, 0xc4, 0xb8,
  0xc5, 0x82, 0xc5, 0x80, 0xc5, 0x89, 0xc5, 0x8b, 0xc3, 0xb8, 0xc5, 0x93,
  0xc3, 0x9f, 0xc5, 0xa7, 0xc3, 0xbe
};

unsigned char jis_x0212_row_10_converted_to_utf8[] = {
  0xc7, 0x95, 0xc5, 0xb4, 0xc3, 0x9d, 0xc5, 0xb8, 0xc5, 0xb6, 0xc5, 0xb9,
  0xc5, 0xbd, 0xc5, 0xbb
};

unsigned char jis_x0212_row_11_converted_to_utf8[] = {
  0xc3, 0xa1, 0xc3, 0xa0, 0xc3, 0xa4, 0xc3, 0xa2, 0xc4, 0x83, 0xc7, 0x8e,
  0xc4, 0x81, 0xc4, 0x85, 0xc3, 0xa5, 0xc3, 0xa3, 0xc4, 0x87, 0xc4, 0x89,
  0xc4, 0x8d, 0xc3, 0xa7, 0xc4, 0x8b, 0xc4, 0x8f, 0xc3, 0xa9, 0xc3, 0xa8,
  0xc3, 0xab, 0xc3, 0xaa, 0xc4, 0x9b, 0xc4, 0x97, 0xc4, 0x93, 0xc4, 0x99,
  0xc7, 0xb5, 0xc4, 0x9d, 0xc4, 0x9f, 0xc4, 0xa1, 0xc4, 0xa5, 0xc3, 0xad,
  0xc3, 0xac, 0xc3, 0xaf, 0xc3, 0xae, 0xc7, 0x90, 0xc4, 0xab, 0xc4, 0xaf,
  0xc4, 0xa9, 0xc4, 0xb5, 0xc4, 0xb7, 0xc4, 0xba, 0xc4, 0xbe, 0xc4, 0xbc,
  0xc5, 0x84, 0xc5, 0x88, 0xc5, 0x86, 0xc3, 0xb1, 0xc3, 0xb3, 0xc3, 0xb2,
  0xc3, 0xb6, 0xc3, 0xb4, 0xc7, 0x92, 0xc5, 0x91, 0xc5, 0x8d, 0xc3, 0xb5,
  0xc5, 0x95, 0xc5, 0x99, 0xc5, 0x97, 0xc5, 0x9b, 0xc5, 0x9d, 0xc5, 0xa1,
  0xc5, 0x9f, 0xc5, 0xa5, 0xc5, 0xa3, 0xc3, 0xba, 0xc3, 0xb9, 0xc3, 0xbc,
  0xc3, 0xbb, 0xc5, 0xad, 0xc7, 0x94, 0xc5, 0xb1, 0xc5, 0xab, 0xc5, 0xb3,
  0xc5, 0xaf, 0xc5, 0xa9, 0xc7, 0x98, 0xc7, 0x9c, 0xc7, 0x9a, 0xc7, 0x96,
  0xc5, 0xb5, 0xc3, 0xbd, 0xc3, 0xbf, 0xc5, 0xb7, 0xc5, 0xba, 0xc5, 0xbe,
  0xc5, 0xbc
};

unsigned char jis_x0212_row_16_converted_to_utf8[] = {
  0xe4, 0xb8, 0x82, 0xe4, 0xb8, 0x84, 0xe4, 0xb8, 0x85, 0xe4, 0xb8, 0x8c,
  0xe4, 0xb8, 0x92, 0xe4, 0xb8, 0x9f, 0xe4, 0xb8, 0xa3, 0xe4, 0xb8, 0xa4,
  0xe4, 0xb8, 0xa8, 0xe4, 0xb8, 0xab, 0xe4, 0xb8, 0xae, 0xe4, 0xb8, 0xaf,
  0xe4, 0xb8, 0xb0, 0xe4, 0xb8, 0xb5, 0xe4, 0xb9, 0x80, 0xe4, 0xb9, 0x81,
  0xe4, 0xb9, 0x84, 0xe4, 0xb9, 0x87, 0xe4, 0xb9, 0x91, 0xe4, 0xb9, 0x9a,
  0xe4, 0xb9, 0x9c, 0xe4, 0xb9, 0xa3, 0xe4, 0xb9, 0xa8, 0xe4, 0xb9, 0xa9,
  0xe4, 0xb9, 0xb4, 0xe4, 0xb9, 0xb5, 0xe4, 0xb9, 0xb9, 0xe4, 0xb9, 0xbf,
  0xe4, 0xba, 0x8d, 0xe4, 0xba, 0x96, 0xe4, 0xba, 0x97, 0xe4, 0xba, 0x9d,
  0xe4, 0xba, 0xaf, 0xe4, 0xba, 0xb9, 0xe4, 0xbb, 0x83, 0xe4, 0xbb, 0x90,
  0xe4, 0xbb, 0x9a, 0xe4, 0xbb, 0x9b, 0xe4, 0xbb, 0xa0, 0xe4, 0xbb, 0xa1,
  0xe4, 0xbb, 0xa2, 0xe4, 0xbb, 0xa8, 0xe4, 0xbb, 0xaf, 0xe4, 0xbb, 0xb1,
  0xe4, 0xbb, 0xb3, 0xe4, 0xbb, 0xb5, 0xe4, 0xbb, 0xbd, 0xe4, 0xbb, 0xbe,
  0xe4, 0xbb, 0xbf, 0xe4, 0xbc, 0x80, 0xe4, 0xbc, 0x82, 0xe4, 0xbc, 0x83,
  0xe4, 0xbc, 0x88, 0xe4, 0xbc, 0x8b, 0xe4, 0xbc, 0x8c, 0xe4, 0xbc, 0x92,
  0xe4, 0xbc, 0x95, 0xe4, 0xbc, 0x96, 0xe4, 0xbc, 0x97, 0xe4, 0xbc, 0x99,
  0xe4, 0xbc, 0xae, 0xe4, 0xbc, 0xb1, 0xe4, 0xbd, 0xa0, 0xe4, 0xbc, 0xb3,
  0xe4, 0xbc, 0xb5, 0xe4, 0xbc, 0xb7, 0xe4, 0xbc, 0xb9, 0xe4, 0xbc, 0xbb,
  0xe4, 0xbc, 0xbe, 0xe4, 0xbd, 0x80, 0xe4, 0xbd, 0x82, 0xe4, 0xbd, 0x88,
  0xe4, 0xbd, 0x89, 0xe4, 0xbd, 0x8b, 0xe4, 0xbd, 0x8c, 0xe4, 0xbd, 0x92,
  0xe4, 0xbd, 0x94, 0xe4, 0xbd, 0x96, 0xe4, 0xbd, 0x98, 0xe4, 0xbd, 0x9f,
  0xe4, 0xbd, 0xa3, 0xe4, 0xbd, 0xaa, 0xe4, 0xbd, 0xac, 0xe4, 0xbd, 0xae,
  0xe4, 0xbd, 0xb1, 0xe4, 0xbd, 0xb7, 0xe4, 0xbd, 0xb8, 0xe4, 0xbd, 0xb9,
  0xe4, 0xbd, 0xba, 0xe4, 0xbd, 0xbd, 0xe4, 0xbd, 0xbe, 0xe4, 0xbe, 0x81,
  0xe4, 0xbe, 0x82, 0xe4, 0xbe, 0x84
};

unsigned char jis_x0212_row_17_converted_to_utf8[] = {
  0xe4, 0xbe, 0x85, 0xe4, 0xbe, 0x89, 0xe4, 0xbe, 0x8a, 0xe4, 0xbe, 0x8c,
  0xe4, 0xbe, 0x8e, 0xe4, 0xbe, 0x90, 0xe4, 0xbe, 0x92, 0xe4, 0xbe, 0x93,
  0xe4, 0xbe, 0x94, 0xe4, 0xbe, 0x97, 0xe4, 0xbe, 0x99, 0xe4, 0xbe, 0x9a,
  0xe4, 0xbe, 0x9e, 0xe4, 0xbe, 0x9f, 0xe4, 0xbe, 0xb2, 0xe4, 0xbe, 0xb7,
  0xe4, 0xbe, 0xb9, 0xe4, 0xbe, 0xbb, 0xe4, 0xbe, 0xbc, 0xe4, 0xbe, 0xbd,
  0xe4, 0xbe, 0xbe, 0xe4, 0xbf, 0x80, 0xe4, 0xbf, 0x81, 0xe4, 0xbf, 0x85,
  0xe4, 0xbf, 0x86, 0xe4, 0xbf, 0x88, 0xe4, 0xbf, 0x89, 0xe4, 0xbf, 0x8b,
  0xe4, 0xbf, 0x8c, 0xe4, 0xbf, 0x8d, 0xe4, 0xbf, 0x8f, 0xe4, 0xbf, 0x92,
  0xe4, 0xbf, 0x9c, 0xe4, 0xbf, 0xa0, 0xe4, 0xbf, 0xa2, 0xe4, 0xbf, 0xb0,
  0xe4, 0xbf, 0xb2, 0xe4, 0xbf, 0xbc, 0xe4, 0xbf, 0xbd, 0xe4, 0xbf, 0xbf,
  0xe5, 0x80, 0x80, 0xe5, 0x80, 0x81, 0xe5, 0x80, 0x84, 0xe5, 0x80, 0x87,
  0xe5, 0x80, 0x8a, 0xe5, 0x80, 0x8c, 0xe5, 0x80, 0x8e, 0xe5, 0x80, 0x90,
  0xe5, 0x80, 0x93, 0xe5, 0x80, 0x97, 0xe5, 0x80, 0x98, 0xe5, 0x80, 0x9b,
  0xe5, 0x80, 0x9c, 0xe5, 0x80, 0x9d, 0xe5, 0x80, 0x9e, 0xe5, 0x80, 0xa2,
  0xe5, 0x80, 0xa7, 0xe5, 0x80, 0xae, 0xe5, 0x80, 0xb0, 0xe5, 0x80, 0xb2,
  0xe5, 0x80, 0xb3, 0xe5, 0x80, 0xb5, 0xe5, 0x81, 0x80, 0xe5, 0x81, 0x81,
  0xe5, 0x81, 0x82, 0xe5, 0x81, 0x85, 0xe5, 0x81, 0x86, 0xe5, 0x81, 0x8a,
  0xe5, 0x81, 0x8c, 0xe5, 0x81, 0x8e, 0xe5, 0x81, 0x91, 0xe5, 0x81, 0x92,
  0xe5, 0x81, 0x93, 0xe5, 0x81, 0x97, 0xe5, 0x81, 0x99, 0xe5, 0x81, 0x9f,
  0xe5, 0x81, 0xa0, 0xe5, 0x81, 0xa2, 0xe5, 0x81, 0xa3, 0xe5, 0x81, 0xa6,
  0xe5, 0x81, 0xa7, 0xe5, 0x81, 0xaa, 0xe5, 0x81, 0xad, 0xe5, 0x81, 0xb0,
  0xe5, 0x81, 0xb1, 0xe5, 0x80, 0xbb, 0xe5, 0x82, 0x81, 0xe5, 0x82, 0x83,
  0xe5, 0x82, 0x84, 0xe5, 0x82, 0x86, 0xe5, 0x82, 0x8a, 0xe5, 0x82, 0x8e,
  0xe5, 0x82, 0x8f, 0xe5, 0x82, 0x90
};

unsigned char jis_x0212_row_18_converted_to_utf8[] = {
  0xe5, 0x82, 0x92, 0xe5, 0x82, 0x93, 0xe5, 0x82, 0x94, 0xe5, 0x82, 0x96,
  0xe5, 0x82, 0x9b, 0xe5, 0x82, 0x9c, 0xe5, 0x82, 0x9e, 0xe5, 0x82, 0x9f,
  0xe5, 0x82, 0xa0, 0xe5, 0x82, 0xa1, 0xe5, 0x82, 0xa2, 0xe5, 0x82, 0xaa,
  0xe5, 0x82, 0xaf, 0xe5, 0x82, 0xb0, 0xe5, 0x82, 0xb9, 0xe5, 0x82, 0xba,
  0xe5, 0x82, 0xbd, 0xe5, 0x83, 0x80, 0xe5, 0x83, 0x83, 0xe5, 0x83, 0x84,
  0xe5, 0x83, 0x87, 0xe5, 0x83, 0x8c, 0xe5, 0x83, 0x8e, 0xe5, 0x83, 0x90,
  0xe5, 0x83, 0x93, 0xe5, 0x83, 0x94, 0xe5, 0x83, 0x98, 0xe5, 0x83, 0x9c,
  0xe5, 0x83, 0x9d, 0xe5, 0x83, 0x9f, 0xe5, 0x83, 0xa2, 0xe5, 0x83, 0xa4,
  0xe5, 0x83, 0xa6, 0xe5, 0x83, 0xa8, 0xe5, 0x83, 0xa9, 0xe5, 0x83, 0xaf,
  0xe5, 0x83, 0xb1, 0xe5, 0x83, 0xb6, 0xe5, 0x83, 0xba, 0xe5, 0x83, 0xbe,
  0xe5, 0x84, 0x83, 0xe5, 0x84, 0x86, 0xe5, 0x84, 0x87, 0xe5, 0x84, 0x88,
  0xe5, 0x84, 0x8b, 0xe5, 0x84, 0x8c, 0xe5, 0x84, 0x8d, 0xe5, 0x84, 0x8e,
  0xe5, 0x83, 0xb2, 0xe5, 0x84, 0x90, 0xe5, 0x84, 0x97, 0xe5, 0x84, 0x99,
  0xe5, 0x84, 0x9b, 0xe5, 0x84, 0x9c, 0xe5, 0x84, 0x9d, 0xe5, 0x84, 0x9e,
  0xe5, 0x84, 0xa3, 0xe5, 0x84, 0xa7, 0xe5, 0x84, 0xa8, 0xe5, 0x84, 0xac,
  0xe5, 0x84, 0xad, 0xe5, 0x84, 0xaf, 0xe5, 0x84, 0xb1, 0xe5, 0x84, 0xb3,
  0xe5, 0x84, 0xb4, 0xe5, 0x84, 0xb5, 0xe5, 0x84, 0xb8, 0xe5, 0x84, 0xb9,
  0xe5, 0x85, 0x82, 0xe5, 0x85, 0x8a, 0xe5, 0x85, 0x8f, 0xe5, 0x85, 0x93,
  0xe5, 0x85, 0x95, 0xe5, 0x85, 0x97, 0xe5, 0x85, 0x98, 0xe5, 0x85, 0x9f,
  0xe5, 0x85, 0xa4, 0xe5, 0x85, 0xa6, 0xe5, 0x85, 0xbe, 0xe5, 0x86, 0x83,
  0xe5, 0x86, 0x84, 0xe5, 0x86, 0x8b, 0xe5, 0x86, 0x8e, 0xe5, 0x86, 0x98,
  0xe5, 0x86, 0x9d, 0xe5, 0x86, 0xa1, 0xe5, 0x86, 0xa3, 0xe5, 0x86, 0xad,
  0xe5, 0x86, 0xb8, 0xe5, 0x86, 0xba, 0xe5, 0x86, 0xbc, 0xe5, 0x86, 0xbe,
  0xe5, 0x86, 0xbf, 0xe5, 0x87, 0x82
};

unsigned char jis_x0212_row_19_converted_to_utf8[] = {
  0xe5, 0x87, 0x88, 0xe5, 0x87, 0x8f, 0xe5, 0x87, 0x91, 0xe5, 0x87, 0x92,
  0xe5, 0x87, 0x93, 0xe5, 0x87, 0x95, 0xe5, 0x87, 0x98, 0xe5, 0x87, 0x9e,
  0xe5, 0x87, 0xa2, 0xe5, 0x87, 0xa5, 0xe5, 0x87, 0xae, 0xe5, 0x87, 0xb2,
  0xe5, 0x87, 0xb3, 0xe5, 0x87, 0xb4, 0xe5, 0x87, 0xb7, 0xe5, 0x88, 0x81,
  0xe5, 0x88, 0x82, 0xe5, 0x88, 0x85, 0xe5, 0x88, 0x92, 0xe5, 0x88, 0x93,
  0xe5, 0x88, 0x95, 0xe5, 0x88, 0x96, 0xe5, 0x88, 0x98, 0xe5, 0x88, 0xa2,
  0xe5, 0x88, 0xa8, 0xe5, 0x88, 0xb1, 0xe5, 0x88, 0xb2, 0xe5, 0x88, 0xb5,
  0xe5, 0x88, 0xbc, 0xe5, 0x89, 0x85, 0xe5, 0x89, 0x89, 0xe5, 0x89, 0x95,
  0xe5, 0x89, 0x97, 0xe5, 0x89, 0x98, 0xe5, 0x89, 0x9a, 0xe5, 0x89, 0x9c,
  0xe5, 0x89, 0x9f, 0xe5, 0x89, 0xa0, 0xe5, 0x89, 0xa1, 0xe5, 0x89, 0xa6,
  0xe5, 0x89, 0xae, 0xe5, 0x89, 0xb7, 0xe5, 0x89, 0xb8, 0xe5, 0x89, 0xb9,
  0xe5, 0x8a, 0x80, 0xe5, 0x8a, 0x82, 0xe5, 0x8a, 0x85, 0xe5, 0x8a, 0x8a,
  0xe5, 0x8a, 0x8c, 0xe5, 0x8a, 0x93, 0xe5, 0x8a, 0x95, 0xe5, 0x8a, 0x96,
  0xe5, 0x8a, 0x97, 0xe5, 0x8a, 0x98, 0xe5, 0x8a, 0x9a, 0xe5, 0x8a, 0x9c,
  0xe5, 0x8a, 0xa4, 0xe5, 0x8a, 0xa5, 0xe5, 0x8a, 0xa6, 0xe5, 0x8a, 0xa7,
  0xe5, 0x8a, 0xaf, 0xe5, 0x8a, 0xb0, 0xe5, 0x8a, 0xb6, 0xe5, 0x8a, 0xb7,
  0xe5, 0x8a, 0xb8, 0xe5, 0x8a, 0xba, 0xe5, 0x8a, 0xbb, 0xe5, 0x8a, 0xbd,
  0xe5, 0x8b, 0x80, 0xe5, 0x8b, 0x84, 0xe5, 0x8b, 0x86, 0xe5, 0x8b, 0x88,
  0xe5, 0x8b, 0x8c, 0xe5, 0x8b, 0x8f, 0xe5, 0x8b, 0x91, 0xe5, 0x8b, 0x94,
  0xe5, 0x8b, 0x96, 0xe5, 0x8b, 0x9b, 0xe5, 0x8b, 0x9c, 0xe5, 0x8b, 0xa1,
  0xe5, 0x8b, 0xa5, 0xe5, 0x8b, 0xa8, 0xe5, 0x8b, 0xa9, 0xe5, 0x8b, 0xaa,
  0xe5, 0x8b, 0xac, 0xe5, 0x8b, 0xb0, 0xe5, 0x8b, 0xb1, 0xe5, 0x8b, 0xb4,
  0xe5, 0x8b, 0xb6, 0xe5, 0x8b, 0xb7, 0xe5, 0x8c, 0x80, 0xe5, 0x8c, 0x83,
  0xe5, 0x8c, 0x8a, 0xe5, 0x8c, 0x8b
};

unsigned char jis_x0212_row_20_converted_to_utf8[] = {
  0xe5, 0x8c, 0x8c, 0xe5, 0x8c, 0x91, 0xe5, 0x8c, 0x93, 0xe5, 0x8c, 0x98,
  0xe5, 0x8c, 0x9b, 0xe5, 0x8c, 0x9c, 0xe5, 0x8c, 0x9e, 0xe5, 0x8c, 0x9f,
  0xe5, 0x8c, 0xa5, 0xe5, 0x8c, 0xa7, 0xe5, 0x8c, 0xa8, 0xe5, 0x8c, 0xa9,
  0xe5, 0x8c, 0xab, 0xe5, 0x8c, 0xac, 0xe5, 0x8c, 0xad, 0xe5, 0x8c, 0xb0,
  0xe5, 0x8c, 0xb2, 0xe5, 0x8c, 0xb5, 0xe5, 0x8c, 0xbc, 0xe5, 0x8c, 0xbd,
  0xe5, 0x8c, 0xbe, 0xe5, 0x8d, 0x82, 0xe5, 0x8d, 0x8c, 0xe5, 0x8d, 0x8b,
  0xe5, 0x8d, 0x99, 0xe5, 0x8d, 0x9b, 0xe5, 0x8d, 0xa1, 0xe5, 0x8d, 0xa3,
  0xe5, 0x8d, 0xa5, 0xe5, 0x8d, 0xac, 0xe5, 0x8d, 0xad, 0xe5, 0x8d, 0xb2,
  0xe5, 0x8d, 0xb9, 0xe5, 0x8d, 0xbe, 0xe5, 0x8e, 0x83, 0xe5, 0x8e, 0x87,
  0xe5, 0x8e, 0x88, 0xe5, 0x8e, 0x8e, 0xe5, 0x8e, 0x93, 0xe5, 0x8e, 0x94,
  0xe5, 0x8e, 0x99, 0xe5, 0x8e, 0x9d, 0xe5, 0x8e, 0xa1, 0xe5, 0x8e, 0xa4,
  0xe5, 0x8e, 0xaa, 0xe5, 0x8e, 0xab, 0xe5, 0x8e, 0xaf, 0xe5, 0x8e, 0xb2,
  0xe5, 0x8e, 0xb4, 0xe5, 0x8e, 0xb5, 0xe5, 0x8e, 0xb7, 0xe5, 0x8e, 0xb8,
  0xe5, 0x8e, 0xba, 0xe5, 0x8e, 0xbd, 0xe5, 0x8f, 0x80, 0xe5, 0x8f, 0x85,
  0xe5, 0x8f, 0x8f, 0xe5, 0x8f, 0x92, 0xe5, 0x8f, 0x93, 0xe5, 0x8f, 0x95,
  0xe5, 0x8f, 0x9a, 0xe5, 0x8f, 0x9d, 0xe5, 0x8f, 0x9e, 0xe5, 0x8f, 0xa0,
  0xe5, 0x8f, 0xa6, 0xe5, 0x8f, 0xa7, 0xe5, 0x8f, 0xb5, 0xe5, 0x90, 0x82,
  0xe5, 0x90, 0x93, 0xe5, 0x90, 0x9a, 0xe5, 0x90, 0xa1, 0xe5, 0x90, 0xa7,
  0xe5, 0x90, 0xa8, 0xe5, 0x90, 0xaa, 0xe5, 0x90, 0xaf, 0xe5, 0x90, 0xb1,
  0xe5, 0x90, 0xb4, 0xe5, 0x90, 0xb5, 0xe5, 0x91, 0x83, 0xe5, 0x91, 0x84,
  0xe5, 0x91, 0x87, 0xe5, 0x91, 0x8d, 0xe5, 0x91, 0x8f, 0xe5, 0x91, 0x9e,
  0xe5, 0x91, 0xa2, 0xe5, 0x91, 0xa4, 0xe5, 0x91, 0xa6, 0xe5, 0x91, 0xa7,
  0xe5, 0x91, 0xa9, 0xe5, 0x91, 0xab, 0xe5, 0x91, 0xad, 0xe5, 0x91, 0xae,
  0xe5, 0x91, 0xb4, 0xe5, 0x91, 0xbf
};

unsigned char jis_x0212_row_21_converted_to_utf8[] = {
  0xe5, 0x92, 0x81, 0xe5, 0x92, 0x83, 0xe5, 0x92, 0x85, 0xe5, 0x92, 0x88,
  0xe5, 0x92, 0x89, 0xe5, 0x92, 0x8d, 0xe5, 0x92, 0x91, 0xe5, 0x92, 0x95,
  0xe5, 0x92, 0x96, 0xe5, 0x92, 0x9c, 0xe5, 0x92, 0x9f, 0xe5, 0x92, 0xa1,
  0xe5, 0x92, 0xa6, 0xe5, 0x92, 0xa7, 0xe5, 0x92, 0xa9, 0xe5, 0x92, 0xaa,
  0xe5, 0x92, 0xad, 0xe5, 0x92, 0xae, 0xe5, 0x92, 0xb1, 0xe5, 0x92, 0xb7,
  0xe5, 0x92, 0xb9, 0xe5, 0x92, 0xba, 0xe5, 0x92, 0xbb, 0xe5, 0x92, 0xbf,
  0xe5, 0x93, 0x86, 0xe5, 0x93, 0x8a, 0xe5, 0x93, 0x8d, 0xe5, 0x93, 0x8e,
  0xe5, 0x93, 0xa0, 0xe5, 0x93, 0xaa, 0xe5, 0x93, 0xac, 0xe5, 0x93, 0xaf,
  0xe5, 0x93, 0xb6, 0xe5, 0x93, 0xbc, 0xe5, 0x93, 0xbe, 0xe5, 0x93, 0xbf,
  0xe5, 0x94, 0x80, 0xe5, 0x94, 0x81, 0xe5, 0x94, 0x85, 0xe5, 0x94, 0x88,
  0xe5, 0x94, 0x89, 0xe5, 0x94, 0x8c, 0xe5, 0x94, 0x8d, 0xe5, 0x94, 0x8e,
  0xe5, 0x94, 0x95, 0xe5, 0x94, 0xaa, 0xe5, 0x94, 0xab, 0xe5, 0x94, 0xb2,
  0xe5, 0x94, 0xb5, 0xe5, 0x94, 0xb6, 0xe5, 0x94, 0xbb, 0xe5, 0x94, 0xbc,
  0xe5, 0x94, 0xbd, 0xe5, 0x95, 0x81, 0xe5, 0x95, 0x87, 0xe5, 0x95, 0x89,
  0xe5, 0x95, 0x8a, 0xe5, 0x95, 0x8d, 0xe5, 0x95, 0x90, 0xe5, 0x95, 0x91,
  0xe5, 0x95, 0x98, 0xe5, 0x95, 0x9a, 0xe5, 0x95, 0x9b, 0xe5, 0x95, 0x9e,
  0xe5, 0x95, 0xa0, 0xe5, 0x95, 0xa1, 0xe5, 0x95, 0xa4, 0xe5, 0x95, 0xa6,
  0xe5, 0x95, 0xbf, 0xe5, 0x96, 0x81, 0xe5, 0x96, 0x82, 0xe5, 0x96, 0x86,
  0xe5, 0x96, 0x88, 0xe5, 0x96, 0x8e, 0xe5, 0x96, 0x8f, 0xe5, 0x96, 0x91,
  0xe5, 0x96, 0x92, 0xe5, 0x96, 0x93, 0xe5, 0x96, 0x94, 0xe5, 0x96, 0x97,
  0xe5, 0x96, 0xa3, 0xe5, 0x96, 0xa4, 0xe5, 0x96, 0xad, 0xe5, 0x96, 0xb2,
  0xe5, 0x96, 0xbf, 0xe5, 0x97, 0x81, 0xe5, 0x97, 0x83, 0xe5, 0x97, 0x86,
  0xe5, 0x97, 0x89, 0xe5, 0x97, 0x8b, 0xe5, 0x97, 0x8c, 0xe5, 0x97, 0x8e,
  0xe5, 0x97, 0x91, 0xe5, 0x97, 0x92
};

unsigned char jis_x0212_row_22_converted_to_utf8[] = {
  0xe5, 0x97, 0x93, 0xe5, 0x97, 0x97, 0xe5, 0x97, 0x98, 0xe5, 0x97, 0x9b,
  0xe5, 0x97, 0x9e, 0xe5, 0x97, 0xa2, 0xe5, 0x97, 0xa9, 0xe5, 0x97, 0xb6,
  0xe5, 0x97, 0xbf, 0xe5, 0x98, 0x85, 0xe5, 0x98, 0x88, 0xe5, 0x98, 0x8a,
  0xe5, 0x98, 0x8d, 0xe5, 0x98, 0x8e, 0xe5, 0x98, 0x8f, 0xe5, 0x98, 0x90,
  0xe5, 0x98, 0x91, 0xe5, 0x98, 0x92, 0xe5, 0x98, 0x99, 0xe5, 0x98, 0xac,
  0xe5, 0x98, 0xb0, 0xe5, 0x98, 0xb3, 0xe5, 0x98, 0xb5, 0xe5, 0x98, 0xb7,
  0xe5, 0x98, 0xb9, 0xe5, 0x98, 0xbb, 0xe5, 0x98, 0xbc, 0xe5, 0x98, 0xbd,
  0xe5, 0x98, 0xbf, 0xe5, 0x99, 0x80, 0xe5, 0x99, 0x81, 0xe5, 0x99, 0x83,
  0xe5, 0x99, 0x84, 0xe5, 0x99, 0x86, 0xe5, 0x99, 0x89, 0xe5, 0x99, 0x8b,
  0xe5, 0x99, 0x8d, 0xe5, 0x99, 0x8f, 0xe5, 0x99, 0x94, 0xe5, 0x99, 0x9e,
  0xe5, 0x99, 0xa0, 0xe5, 0x99, 0xa1, 0xe5, 0x99, 0xa2, 0xe5, 0x99, 0xa3,
  0xe5, 0x99, 0xa6, 0xe5, 0x99, 0xa9, 0xe5, 0x99, 0xad, 0xe5, 0x99, 0xaf,
  0xe5, 0x99, 0xb1, 0xe5, 0x99, 0xb2, 0xe5, 0x99, 0xb5, 0xe5, 0x9a, 0x84,
  0xe5, 0x9a, 0x85, 0xe5, 0x9a, 0x88, 0xe5, 0x9a, 0x8b, 0xe5, 0x9a, 0x8c,
  0xe5, 0x9a, 0x95, 0xe5, 0x9a, 0x99, 0xe5, 0x9a, 0x9a, 0xe5, 0x9a, 0x9d,
  0xe5, 0x9a, 0x9e, 0xe5, 0x9a, 0x9f, 0xe5, 0x9a, 0xa6, 0xe5, 0x9a, 0xa7,
  0xe5, 0x9a, 0xa8, 0xe5, 0x9a, 0xa9, 0xe5, 0x9a, 0xab, 0xe5, 0x9a, 0xac,
  0xe5, 0x9a, 0xad, 0xe5, 0x9a, 0xb1, 0xe5, 0x9a, 0xb3, 0xe5, 0x9a, 0xb7,
  0xe5, 0x9a, 0xbe, 0xe5, 0x9b, 0x85, 0xe5, 0x9b, 0x89, 0xe5, 0x9b, 0x8a,
  0xe5, 0x9b, 0x8b, 0xe5, 0x9b, 0x8f, 0xe5, 0x9b, 0x90, 0xe5, 0x9b, 0x8c,
  0xe5, 0x9b, 0x8d, 0xe5, 0x9b, 0x99, 0xe5, 0x9b, 0x9c, 0xe5, 0x9b, 0x9d,
  0xe5, 0x9b, 0x9f, 0xe5, 0x9b, 0xa1, 0xe5, 0x9b, 0xa4, 0xe5, 0x9b, 0xa5,
  0xe5, 0x9b, 0xa6, 0xe5, 0x9b, 0xa7, 0xe5, 0x9b, 0xa8, 0xe5, 0x9b, 0xb1,
  0xe5, 0x9b, 0xab, 0xe5, 0x9b, 0xad
};

unsigned char jis_x0212_row_23_converted_to_utf8[] = {
  0xe5, 0x9b, 0xb6, 0xe5, 0x9b, 0xb7, 0xe5, 0x9c, 0x81, 0xe5, 0x9c, 0x82,
  0xe5, 0x9c, 0x87, 0xe5, 0x9c, 0x8a, 0xe5, 0x9c, 0x8c, 0xe5, 0x9c, 0x91,
  0xe5, 0x9c, 0x95, 0xe5, 0x9c, 0x9a, 0xe5, 0x9c, 0x9b, 0xe5, 0x9c, 0x9d,
  0xe5, 0x9c, 0xa0, 0xe5, 0x9c, 0xa2, 0xe5, 0x9c, 0xa3, 0xe5, 0x9c, 0xa4,
  0xe5, 0x9c, 0xa5, 0xe5, 0x9c, 0xa9, 0xe5, 0x9c, 0xaa, 0xe5, 0x9c, 0xac,
  0xe5, 0x9c, 0xae, 0xe5, 0x9c, 0xaf, 0xe5, 0x9c, 0xb3, 0xe5, 0x9c, 0xb4,
  0xe5, 0x9c, 0xbd, 0xe5, 0x9c, 0xbe, 0xe5, 0x9c, 0xbf, 0xe5, 0x9d, 0x85,
  0xe5, 0x9d, 0x86, 0xe5, 0x9d, 0x8c, 0xe5, 0x9d, 0x8d, 0xe5, 0x9d, 0x92,
  0xe5, 0x9d, 0xa2, 0xe5, 0x9d, 0xa5, 0xe5, 0x9d, 0xa7, 0xe5, 0x9d, 0xa8,
  0xe5, 0x9d, 0xab, 0xe5, 0x9d, 0xad, 0xe5, 0x9d, 0xae, 0xe5, 0x9d, 0xaf,
  0xe5, 0x9d, 0xb0, 0xe5, 0x9d, 0xb1, 0xe5, 0x9d, 0xb3, 0xe5, 0x9d, 0xb4,
  0xe5, 0x9d, 0xb5, 0xe5, 0x9d, 0xb7, 0xe5, 0x9d, 0xb9, 0xe5, 0x9d, 0xba,
  0xe5, 0x9d, 0xbb, 0xe5, 0x9d, 0xbc, 0xe5, 0x9d, 0xbe, 0xe5, 0x9e, 0x81,
  0xe5, 0x9e, 0x83, 0xe5, 0x9e, 0x8c, 0xe5, 0x9e, 0x94, 0xe5, 0x9e, 0x97,
  0xe5, 0x9e, 0x99, 0xe5, 0x9e, 0x9a, 0xe5, 0x9e, 0x9c, 0xe5, 0x9e, 0x9d,
  0xe5, 0x9e, 0x9e, 0xe5, 0x9e, 0x9f, 0xe5, 0x9e, 0xa1, 0xe5, 0x9e, 0x95,
  0xe5, 0x9e, 0xa7, 0xe5, 0x9e, 0xa8, 0xe5, 0x9e, 0xa9, 0xe5, 0x9e, 0xac,
  0xe5, 0x9e, 0xb8, 0xe5, 0x9e, 0xbd, 0xe5, 0x9f, 0x87, 0xe5, 0x9f, 0x88,
  0xe5, 0x9f, 0x8c, 0xe5, 0x9f, 0x8f, 0xe5, 0x9f, 0x95, 0xe5, 0x9f, 0x9d,
  0xe5, 0x9f, 0x9e, 0xe5, 0x9f, 0xa4, 0xe5, 0x9f, 0xa6, 0xe5, 0x9f, 0xa7,
  0xe5, 0x9f, 0xa9, 0xe5, 0x9f, 0xad, 0xe5, 0x9f, 0xb0, 0xe5, 0x9f, 0xb5,
  0xe5, 0x9f, 0xb6, 0xe5, 0x9f, 0xb8, 0xe5, 0x9f, 0xbd, 0xe5, 0x9f, 0xbe,
  0xe5, 0x9f, 0xbf, 0xe5, 0xa0, 0x83, 0xe5, 0xa0, 0x84, 0xe5, 0xa0, 0x88,
  0xe5, 0xa0, 0x89, 0xe5, 0x9f, 0xa1
};

unsigned char jis_x0212_row_24_converted_to_utf8[] = {
  0xe5, 0xa0, 0x8c, 0xe5, 0xa0, 0x8d, 0xe5, 0xa0, 0x9b, 0xe5, 0xa0, 0x9e,
  0xe5, 0xa0, 0x9f, 0xe5, 0xa0, 0xa0, 0xe5, 0xa0, 0xa6, 0xe5, 0xa0, 0xa7,
  0xe5, 0xa0, 0xad, 0xe5, 0xa0, 0xb2, 0xe5, 0xa0, 0xb9, 0xe5, 0xa0, 0xbf,
  0xe5, 0xa1, 0x89, 0xe5, 0xa1, 0x8c, 0xe5, 0xa1, 0x8d, 0xe5, 0xa1, 0x8f,
  0xe5, 0xa1, 0x90, 0xe5, 0xa1, 0x95, 0xe5, 0xa1, 0x9f, 0xe5, 0xa1, 0xa1,
  0xe5, 0xa1, 0xa4, 0xe5, 0xa1, 0xa7, 0xe5, 0xa1, 0xa8, 0xe5, 0xa1, 0xb8,
  0xe5, 0xa1, 0xbc, 0xe5, 0xa1, 0xbf, 0xe5, 0xa2, 0x80, 0xe5, 0xa2, 0x81,
  0xe5, 0xa2, 0x87, 0xe5, 0xa2, 0x88, 0xe5, 0xa2, 0x89, 0xe5, 0xa2, 0x8a,
  0xe5, 0xa2, 0x8c, 0xe5, 0xa2, 0x8d, 0xe5, 0xa2, 0x8f, 0xe5, 0xa2, 0x90,
  0xe5, 0xa2, 0x94, 0xe5, 0xa2, 0x96, 0xe5, 0xa2, 0x9d, 0xe5, 0xa2, 0xa0,
  0xe5, 0xa2, 0xa1, 0xe5, 0xa2, 0xa2, 0xe5, 0xa2, 0xa6, 0xe5, 0xa2, 0xa9,
  0xe5, 0xa2, 0xb1, 0xe5, 0xa2, 0xb2, 0xe5, 0xa3, 0x84, 0xe5, 0xa2, 0xbc,
  0xe5, 0xa3, 0x82, 0xe5, 0xa3, 0x88, 0xe5, 0xa3, 0x8d, 0xe5, 0xa3, 0x8e,
  0xe5, 0xa3, 0x90, 0xe5, 0xa3, 0x92, 0xe5, 0xa3, 0x94, 0xe5, 0xa3, 0x96,
  0xe5, 0xa3, 0x9a, 0xe5, 0xa3, 0x9d, 0xe5, 0xa3, 0xa1, 0xe5, 0xa3, 0xa2,
  0xe5, 0xa3, 0xa9, 0xe5, 0xa3, 0xb3, 0xe5, 0xa4, 0x85, 0xe5, 0xa4, 0x86,
  0xe5, 0xa4, 0x8b, 0xe5, 0xa4, 0x8c, 0xe5, 0xa4, 0x92, 0xe5, 0xa4, 0x93,
  0xe5, 0xa4, 0x94, 0xe8, 0x99, 0x81, 0xe5, 0xa4, 0x9d, 0xe5, 0xa4, 0xa1,
  0xe5, 0xa4, 0xa3, 0xe5, 0xa4, 0xa4, 0xe5, 0xa4, 0xa8, 0xe5, 0xa4, 0xaf,
  0xe5, 0xa4, 0xb0, 0xe5, 0xa4, 0xb3, 0xe5, 0xa4, 0xb5, 0xe5, 0xa4, 0xb6,
  0xe5, 0xa4, 0xbf, 0xe5, 0xa5, 0x83, 0xe5, 0xa5, 0x86, 0xe5, 0xa5, 0x92,
  0xe5, 0xa5, 0x93, 0xe5, 0xa5, 0x99, 0xe5, 0xa5, 0x9b, 0xe5, 0xa5, 0x9d,
  0xe5, 0xa5, 0x9e, 0xe5, 0xa5, 0x9f, 0xe5, 0xa5, 0xa1, 0xe5, 0xa5, 0xa3,
  0xe5, 0xa5, 0xab, 0xe5, 0xa5, 0xad
};

unsigned char jis_x0212_row_25_converted_to_utf8[] = {
  0xe5, 0xa5, 0xaf, 0xe5, 0xa5, 0xb2, 0xe5, 0xa5, 0xb5, 0xe5, 0xa5, 0xb6,
  0xe5, 0xa5, 0xb9, 0xe5, 0xa5, 0xbb, 0xe5, 0xa5, 0xbc, 0xe5, 0xa6, 0x8b,
  0xe5, 0xa6, 0x8c, 0xe5, 0xa6, 0x8e, 0xe5, 0xa6, 0x92, 0xe5, 0xa6, 0x95,
  0xe5, 0xa6, 0x97, 0xe5, 0xa6, 0x9f, 0xe5, 0xa6, 0xa4, 0xe5, 0xa6, 0xa7,
  0xe5, 0xa6, 0xad, 0xe5, 0xa6, 0xae, 0xe5, 0xa6, 0xaf, 0xe5, 0xa6, 0xb0,
  0xe5, 0xa6, 0xb3, 0xe5, 0xa6, 0xb7, 0xe5, 0xa6, 0xba, 0xe5, 0xa6, 0xbc,
  0xe5, 0xa7, 0x81, 0xe5, 0xa7, 0x83, 0xe5, 0xa7, 0x84, 0xe5, 0xa7, 0x88,
  0xe5, 0xa7, 0x8a, 0xe5, 0xa7, 0x8d, 0xe5, 0xa7, 0x92, 0xe5, 0xa7, 0x9d,
  0xe5, 0xa7, 0x9e, 0xe5, 0xa7, 0x9f, 0xe5, 0xa7, 0xa3, 0xe5, 0xa7, 0xa4,
  0xe5, 0xa7, 0xa7, 0xe5, 0xa7, 0xae, 0xe5, 0xa7, 0xaf, 0xe5, 0xa7, 0xb1,
  0xe5, 0xa7, 0xb2, 0xe5, 0xa7, 0xb4, 0xe5, 0xa7, 0xb7, 0xe5, 0xa8, 0x80,
  0xe5, 0xa8, 0x84, 0xe5, 0xa8, 0x8c, 0xe5, 0xa8, 0x8d, 0xe5, 0xa8, 0x8e,
  0xe5, 0xa8, 0x92, 0xe5, 0xa8, 0x93, 0xe5, 0xa8, 0x9e, 0xe5, 0xa8, 0xa3,
  0xe5, 0xa8, 0xa4, 0xe5, 0xa8, 0xa7, 0xe5, 0xa8, 0xa8, 0xe5, 0xa8, 0xaa,
  0xe5, 0xa8, 0xad, 0xe5, 0xa8, 0xb0, 0xe5, 0xa9, 0x84, 0xe5, 0xa9, 0x85,
  0xe5, 0xa9, 0x87, 0xe5, 0xa9, 0x88, 0xe5, 0xa9, 0x8c, 0xe5, 0xa9, 0x90,
  0xe5, 0xa9, 0x95, 0xe5, 0xa9, 0x9e, 0xe5, 0xa9, 0xa3, 0xe5, 0xa9, 0xa5,
  0xe5, 0xa9, 0xa7, 0xe5, 0xa9, 0xad, 0xe5, 0xa9, 0xb7, 0xe5, 0xa9, 0xba,
  0xe5, 0xa9, 0xbb, 0xe5, 0xa9, 0xbe, 0xe5, 0xaa, 0x8b, 0xe5, 0xaa, 0x90,
  0xe5, 0xaa, 0x93, 0xe5, 0xaa, 0x96, 0xe5, 0xaa, 0x99, 0xe5, 0xaa, 0x9c,
  0xe5, 0xaa, 0x9e, 0xe5, 0xaa, 0x9f, 0xe5, 0xaa, 0xa0, 0xe5, 0xaa, 0xa2,
  0xe5, 0xaa, 0xa7, 0xe5, 0xaa, 0xac, 0xe5, 0xaa, 0xb1, 0xe5, 0xaa, 0xb2,
  0xe5, 0xaa, 0xb3, 0xe5, 0xaa, 0xb5, 0xe5, 0xaa, 0xb8, 0xe5, 0xaa, 0xba,
  0xe5, 0xaa, 0xbb, 0xe5, 0xaa, 0xbf
};

unsigned char jis_x0212_row_26_converted_to_utf8[] = {
  0xe5, 0xab, 0x84, 0xe5, 0xab, 0x86, 0xe5, 0xab, 0x88, 0xe5, 0xab, 0x8f,
  0xe5, 0xab, 0x9a, 0xe5, 0xab, 0x9c, 0xe5, 0xab, 0xa0, 0xe5, 0xab, 0xa5,
  0xe5, 0xab, 0xaa, 0xe5, 0xab, 0xae, 0xe5, 0xab, 0xb5, 0xe5, 0xab, 0xb6,
  0xe5, 0xab, 0xbd, 0xe5, 0xac, 0x80, 0xe5, 0xac, 0x81, 0xe5, 0xac, 0x88,
  0xe5, 0xac, 0x97, 0xe5, 0xac, 0xb4, 0xe5, 0xac, 0x99, 0xe5, 0xac, 0x9b,
  0xe5, 0xac, 0x9d, 0xe5, 0xac, 0xa1, 0xe5, 0xac, 0xa5, 0xe5, 0xac, 0xad,
  0xe5, 0xac, 0xb8, 0xe5, 0xad, 0x81, 0xe5, 0xad, 0x8b, 0xe5, 0xad, 0x8c,
  0xe5, 0xad, 0x92, 0xe5, 0xad, 0x96, 0xe5, 0xad, 0x9e, 0xe5, 0xad, 0xa8,
  0xe5, 0xad, 0xae, 0xe5, 0xad, 0xaf, 0xe5, 0xad, 0xbc, 0xe5, 0xad, 0xbd,
  0xe5, 0xad, 0xbe, 0xe5, 0xad, 0xbf, 0xe5, 0xae, 0x81, 0xe5, 0xae, 0x84,
  0xe5, 0xae, 0x86, 0xe5, 0xae, 0x8a, 0xe5, 0xae, 0x8e, 0xe5, 0xae, 0x90,
  0xe5, 0xae, 0x91, 0xe5, 0xae, 0x93, 0xe5, 0xae, 0x94, 0xe5, 0xae, 0x96,
  0xe5, 0xae, 0xa8, 0xe5, 0xae, 0xa9, 0xe5, 0xae, 0xac, 0xe5, 0xae, 0xad,
  0xe5, 0xae, 0xaf, 0xe5, 0xae, 0xb1, 0xe5, 0xae, 0xb2, 0xe5, 0xae, 0xb7,
  0xe5, 0xae, 0xba, 0xe5, 0xae, 0xbc, 0xe5, 0xaf, 0x80, 0xe5, 0xaf, 0x81,
  0xe5, 0xaf, 0x8d, 0xe5, 0xaf, 0x8f, 0xe5, 0xaf, 0x96, 0xe5, 0xaf, 0x97,
  0xe5, 0xaf, 0x98, 0xe5, 0xaf, 0x99, 0xe5, 0xaf, 0x9a, 0xe5, 0xaf, 0xa0,
  0xe5, 0xaf, 0xaf, 0xe5, 0xaf, 0xb1, 0xe5, 0xaf, 0xb4, 0xe5, 0xaf, 0xbd,
  0xe5, 0xb0, 0x8c, 0xe5, 0xb0, 0x97, 0xe5, 0xb0, 0x9e, 0xe5, 0xb0, 0x9f,
  0xe5, 0xb0, 0xa3, 0xe5, 0xb0, 0xa6, 0xe5, 0xb0, 0xa9, 0xe5, 0xb0, 0xab,
  0xe5, 0xb0, 0xac, 0xe5, 0xb0, 0xae, 0xe5, 0xb0, 0xb0, 0xe5, 0xb0, 0xb2,
  0xe5, 0xb0, 0xb5, 0xe5, 0xb0, 0xb6, 0xe5, 0xb1, 0x99, 0xe5, 0xb1, 0x9a,
  0xe5, 0xb1, 0x9c, 0xe5, 0xb1, 0xa2, 0xe5, 0xb1, 0xa3, 0xe5, 0xb1, 0xa7,
  0xe5, 0xb1, 0xa8, 0xe5, 0xb1, 0xa9
};

unsigned char jis_x0212_row_27_converted_to_utf8[] = {
  0xe5, 0xb1, 0xad, 0xe5, 0xb1, 0xb0, 0xe5, 0xb1, 0xb4, 0xe5, 0xb1, 0xb5,
  0xe5, 0xb1, 0xba, 0xe5, 0xb1, 0xbb, 0xe5, 0xb1, 0xbc, 0xe5, 0xb1, 0xbd,
  0xe5, 0xb2, 0x87, 0xe5, 0xb2, 0x88, 0xe5, 0xb2, 0x8a, 0xe5, 0xb2, 0x8f,
  0xe5, 0xb2, 0x92, 0xe5, 0xb2, 0x9d, 0xe5, 0xb2, 0x9f, 0xe5, 0xb2, 0xa0,
  0xe5, 0xb2, 0xa2, 0xe5, 0xb2, 0xa3, 0xe5, 0xb2, 0xa6, 0xe5, 0xb2, 0xaa,
  0xe5, 0xb2, 0xb2, 0xe5, 0xb2, 0xb4, 0xe5, 0xb2, 0xb5, 0xe5, 0xb2, 0xba,
  0xe5, 0xb3, 0x89, 0xe5, 0xb3, 0x8b, 0xe5, 0xb3, 0x92, 0xe5, 0xb3, 0x9d,
  0xe5, 0xb3, 0x97, 0xe5, 0xb3, 0xae, 0xe5, 0xb3, 0xb1, 0xe5, 0xb3, 0xb2,
  0xe5, 0xb3, 0xb4, 0xe5, 0xb4, 0x81, 0xe5, 0xb4, 0x86, 0xe5, 0xb4, 0x8d,
  0xe5, 0xb4, 0x92, 0xe5, 0xb4, 0xab, 0xe5, 0xb4, 0xa3, 0xe5, 0xb4, 0xa4,
  0xe5, 0xb4, 0xa6, 0xe5, 0xb4, 0xa7, 0xe5, 0xb4, 0xb1, 0xe5, 0xb4, 0xb4,
  0xe5, 0xb4, 0xb9, 0xe5, 0xb4, 0xbd, 0xe5, 0xb4, 0xbf, 0xe5, 0xb5, 0x82,
  0xe5, 0xb5, 0x83, 0xe5, 0xb5, 0x86, 0xe5, 0xb5, 0x88, 0xe5, 0xb5, 0x95,
  0xe5, 0xb5, 0x91, 0xe5, 0xb5, 0x99, 0xe5, 0xb5, 0x8a, 0xe5, 0xb5, 0x9f,
  0xe5, 0xb5, 0xa0, 0xe5, 0xb5, 0xa1, 0xe5, 0xb5, 0xa2, 0xe5, 0xb5, 0xa4,
  0xe5, 0xb5, 0xaa, 0xe5, 0xb5, 0xad, 0xe5, 0xb5, 0xb0, 0xe5, 0xb5, 0xb9,
  0xe5, 0xb5, 0xba, 0xe5, 0xb5, 0xbe, 0xe5, 0xb5, 0xbf, 0xe5, 0xb6, 0x81,
  0xe5, 0xb6, 0x83, 0xe5, 0xb6, 0x88, 0xe5, 0xb6, 0x8a, 0xe5, 0xb6, 0x92,
  0xe5, 0xb6, 0x93, 0xe5, 0xb6, 0x94, 0xe5, 0xb6, 0x95, 0xe5, 0xb6, 0x99,
  0xe5, 0xb6, 0x9b, 0xe5, 0xb6, 0x9f, 0xe5, 0xb6, 0xa0, 0xe5, 0xb6, 0xa7,
  0xe5, 0xb6, 0xab, 0xe5, 0xb6, 0xb0, 0xe5, 0xb6, 0xb4, 0xe5, 0xb6, 0xb8,
  0xe5, 0xb6, 0xb9, 0xe5, 0xb7, 0x83, 0xe5, 0xb7, 0x87, 0xe5, 0xb7, 0x8b,
  0xe5, 0xb7, 0x90, 0xe5, 0xb7, 0x8e, 0xe5, 0xb7, 0x98, 0xe5, 0xb7, 0x99,
  0xe5, 0xb7, 0xa0, 0xe5, 0xb7, 0xa4
};

unsigned char jis_x0212_row_28_converted_to_utf8[] = {
  0xe5, 0xb7, 0xa9, 0xe5, 0xb7, 0xb8, 0xe5, 0xb7, 0xb9, 0xe5, 0xb8, 0x80,
  0xe5, 0xb8, 0x87, 0xe5, 0xb8, 0x8d, 0xe5, 0xb8, 0x92, 0xe5, 0xb8, 0x94,
  0xe5, 0xb8, 0x95, 0xe5, 0xb8, 0x98, 0xe5, 0xb8, 0x9f, 0xe5, 0xb8, 0xa0,
  0xe5, 0xb8, 0xae, 0xe5, 0xb8, 0xa8, 0xe5, 0xb8, 0xb2, 0xe5, 0xb8, 0xb5,
  0xe5, 0xb8, 0xbe, 0xe5, 0xb9, 0x8b, 0xe5, 0xb9, 0x90, 0xe5, 0xb9, 0x89,
  0xe5, 0xb9, 0x91, 0xe5, 0xb9, 0x96, 0xe5, 0xb9, 0x98, 0xe5, 0xb9, 0x9b,
  0xe5, 0xb9, 0x9c, 0xe5, 0xb9, 0x9e, 0xe5, 0xb9, 0xa8, 0xe5, 0xb9, 0xaa,
  0xe5, 0xb9, 0xab, 0xe5, 0xb9, 0xac, 0xe5, 0xb9, 0xad, 0xe5, 0xb9, 0xae,
  0xe5, 0xb9, 0xb0, 0xe5, 0xba, 0x80, 0xe5, 0xba, 0x8b, 0xe5, 0xba, 0x8e,
  0xe5, 0xba, 0xa2, 0xe5, 0xba, 0xa4, 0xe5, 0xba, 0xa5, 0xe5, 0xba, 0xa8,
  0xe5, 0xba, 0xaa, 0xe5, 0xba, 0xac, 0xe5, 0xba, 0xb1, 0xe5, 0xba, 0xb3,
  0xe5, 0xba, 0xbd, 0xe5, 0xba, 0xbe, 0xe5, 0xba, 0xbf, 0xe5, 0xbb, 0x86,
  0xe5, 0xbb, 0x8c, 0xe5, 0xbb, 0x8b, 0xe5, 0xbb, 0x8e, 0xe5, 0xbb, 0x91,
  0xe5, 0xbb, 0x92, 0xe5, 0xbb, 0x94, 0xe5, 0xbb, 0x95, 0xe5, 0xbb, 0x9c,
  0xe5, 0xbb, 0x9e, 0xe5, 0xbb, 0xa5, 0xe5, 0xbb, 0xab, 0xe5, 0xbc, 0x82,
  0xe5, 0xbc, 0x86, 0xe5, 0xbc, 0x87, 0xe5, 0xbc, 0x88, 0xe5, 0xbc, 0x8e,
  0xe5, 0xbc, 0x99, 0xe5, 0xbc, 0x9c, 0xe5, 0xbc, 0x9d, 0xe5, 0xbc, 0xa1,
  0xe5, 0xbc, 0xa2, 0xe5, 0xbc, 0xa3, 0xe5, 0xbc, 0xa4, 0xe5, 0xbc, 0xa8,
  0xe5, 0xbc, 0xab, 0xe5, 0xbc, 0xac, 0xe5, 0xbc, 0xae, 0xe5, 0xbc, 0xb0,
  0xe5, 0xbc, 0xb4, 0xe5, 0xbc, 0xb6, 0xe5, 0xbc, 0xbb, 0xe5, 0xbc, 0xbd,
  0xe5, 0xbc, 0xbf, 0xe5, 0xbd, 0x80, 0xe5, 0xbd, 0x84, 0xe5, 0xbd, 0x85,
  0xe5, 0xbd, 0x87, 0xe5, 0xbd, 0x8d, 0xe5, 0xbd, 0x90, 0xe5, 0xbd, 0x94,
  0xe5, 0xbd, 0x98, 0xe5, 0xbd, 0x9b, 0xe5, 0xbd, 0xa0, 0xe5, 0xbd, 0xa3,
  0xe5, 0xbd, 0xa4, 0xe5, 0xbd, 0xa7
};

unsigned char jis_x0212_row_29_converted_to_utf8[] = {
  0xe5, 0xbd, 0xaf, 0xe5, 0xbd, 0xb2, 0xe5, 0xbd, 0xb4, 0xe5, 0xbd, 0xb5,
  0xe5, 0xbd, 0xb8, 0xe5, 0xbd, 0xba, 0xe5, 0xbd, 0xbd, 0xe5, 0xbd, 0xbe,
  0xe5, 0xbe, 0x89, 0xe5, 0xbe, 0x8d, 0xe5, 0xbe, 0x8f, 0xe5, 0xbe, 0x96,
  0xe5, 0xbe, 0x9c, 0xe5, 0xbe, 0x9d, 0xe5, 0xbe, 0xa2, 0xe5, 0xbe, 0xa7,
  0xe5, 0xbe, 0xab, 0xe5, 0xbe, 0xa4, 0xe5, 0xbe, 0xac, 0xe5, 0xbe, 0xaf,
  0xe5, 0xbe, 0xb0, 0xe5, 0xbe, 0xb1, 0xe5, 0xbe, 0xb8, 0xe5, 0xbf, 0x84,
  0xe5, 0xbf, 0x87, 0xe5, 0xbf, 0x88, 0xe5, 0xbf, 0x89, 0xe5, 0xbf, 0x8b,
  0xe5, 0xbf, 0x90, 0xe5, 0xbf, 0x91, 0xe5, 0xbf, 0x92, 0xe5, 0xbf, 0x93,
  0xe5, 0xbf, 0x94, 0xe5, 0xbf, 0x9e, 0xe5, 0xbf, 0xa1, 0xe5, 0xbf, 0xa2,
  0xe5, 0xbf, 0xa8, 0xe5, 0xbf, 0xa9, 0xe5, 0xbf, 0xaa, 0xe5, 0xbf, 0xac,
  0xe5, 0xbf, 0xad, 0xe5, 0xbf, 0xae, 0xe5, 0xbf, 0xaf, 0xe5, 0xbf, 0xb2,
  0xe5, 0xbf, 0xb3, 0xe5, 0xbf, 0xb6, 0xe5, 0xbf, 0xba, 0xe5, 0xbf, 0xbc,
  0xe6, 0x80, 0x87, 0xe6, 0x80, 0x8a, 0xe6, 0x80, 0x8d, 0xe6, 0x80, 0x93,
  0xe6, 0x80, 0x94, 0xe6, 0x80, 0x97, 0xe6, 0x80, 0x98, 0xe6, 0x80, 0x9a,
  0xe6, 0x80, 0x9f, 0xe6, 0x80, 0xa4, 0xe6, 0x80, 0xad, 0xe6, 0x80, 0xb3,
  0xe6, 0x80, 0xb5, 0xe6, 0x81, 0x80, 0xe6, 0x81, 0x87, 0xe6, 0x81, 0x88,
  0xe6, 0x81, 0x89, 0xe6, 0x81, 0x8c, 0xe6, 0x81, 0x91, 0xe6, 0x81, 0x94,
  0xe6, 0x81, 0x96, 0xe6, 0x81, 0x97, 0xe6, 0x81, 0x9d, 0xe6, 0x81, 0xa1,
  0xe6, 0x81, 0xa7, 0xe6, 0x81, 0xb1, 0xe6, 0x81, 0xbe, 0xe6, 0x81, 0xbf,
  0xe6, 0x82, 0x82, 0xe6, 0x82, 0x86, 0xe6, 0x82, 0x88, 0xe6, 0x82, 0x8a,
  0xe6, 0x82, 0x8e, 0xe6, 0x82, 0x91, 0xe6, 0x82, 0x93, 0xe6, 0x82, 0x95,
  0xe6, 0x82, 0x98, 0xe6, 0x82, 0x9d, 0xe6, 0x82, 0x9e, 0xe6, 0x82, 0xa2,
  0xe6, 0x82, 0xa4, 0xe6, 0x82, 0xa5, 0xe6, 0x82, 0xa8, 0xe6, 0x82, 0xb0,
  0xe6, 0x82, 0xb1, 0xe6, 0x82, 0xb7
};

unsigned char jis_x0212_row_30_converted_to_utf8[] = {
  0xe6, 0x82, 0xbb, 0xe6, 0x82, 0xbe, 0xe6, 0x83, 0x82, 0xe6, 0x83, 0x84,
  0xe6, 0x83, 0x88, 0xe6, 0x83, 0x89, 0xe6, 0x83, 0x8a, 0xe6, 0x83, 0x8b,
  0xe6, 0x83, 0x8e, 0xe6, 0x83, 0x8f, 0xe6, 0x83, 0x94, 0xe6, 0x83, 0x95,
  0xe6, 0x83, 0x99, 0xe6, 0x83, 0x9b, 0xe6, 0x83, 0x9d, 0xe6, 0x83, 0x9e,
  0xe6, 0x83, 0xa2, 0xe6, 0x83, 0xa5, 0xe6, 0x83, 0xb2, 0xe6, 0x83, 0xb5,
  0xe6, 0x83, 0xb8, 0xe6, 0x83, 0xbc, 0xe6, 0x83, 0xbd, 0xe6, 0x84, 0x82,
  0xe6, 0x84, 0x87, 0xe6, 0x84, 0x8a, 0xe6, 0x84, 0x8c, 0xe6, 0x84, 0x90,
  0xe6, 0x84, 0x91, 0xe6, 0x84, 0x92, 0xe6, 0x84, 0x93, 0xe6, 0x84, 0x94,
  0xe6, 0x84, 0x96, 0xe6, 0x84, 0x97, 0xe6, 0x84, 0x99, 0xe6, 0x84, 0x9c,
  0xe6, 0x84, 0x9e, 0xe6, 0x84, 0xa2, 0xe6, 0x84, 0xaa, 0xe6, 0x84, 0xab,
  0xe6, 0x84, 0xb0, 0xe6, 0x84, 0xb1, 0xe6, 0x84, 0xb5, 0xe6, 0x84, 0xb6,
  0xe6, 0x84, 0xb7, 0xe6, 0x84, 0xb9, 0xe6, 0x85, 0x81, 0xe6, 0x85, 0x85,
  0xe6, 0x85, 0x86, 0xe6, 0x85, 0x89, 0xe6, 0x85, 0x9e, 0xe6, 0x85, 0xa0,
  0xe6, 0x85, 0xac, 0xe6, 0x85, 0xb2, 0xe6, 0x85, 0xb8, 0xe6, 0x85, 0xbb,
  0xe6, 0x85, 0xbc, 0xe6, 0x85, 0xbf, 0xe6, 0x86, 0x80, 0xe6, 0x86, 0x81,
  0xe6, 0x86, 0x83, 0xe6, 0x86, 0x84, 0xe6, 0x86, 0x8b, 0xe6, 0x86, 0x8d,
  0xe6, 0x86, 0x92, 0xe6, 0x86, 0x93, 0xe6, 0x86, 0x97, 0xe6, 0x86, 0x98,
  0xe6, 0x86, 0x9c, 0xe6, 0x86, 0x9d, 0xe6, 0x86, 0x9f, 0xe6, 0x86, 0xa0,
  0xe6, 0x86, 0xa5, 0xe6, 0x86, 0xa8, 0xe6, 0x86, 0xaa, 0xe6, 0x86, 0xad,
  0xe6, 0x86, 0xb8, 0xe6, 0x86, 0xb9, 0xe6, 0x86, 0xbc, 0xe6, 0x87, 0x80,
  0xe6, 0x87, 0x81, 0xe6, 0x87, 0x82, 0xe6, 0x87, 0x8e, 0xe6, 0x87, 0x8f,
  0xe6, 0x87, 0x95, 0xe6, 0x87, 0x9c, 0xe6, 0x87, 0x9d, 0xe6, 0x87, 0x9e,
  0xe6, 0x87, 0x9f, 0xe6, 0x87, 0xa1, 0xe6, 0x87, 0xa2, 0xe6, 0x87, 0xa7,
  0xe6, 0x87, 0xa9, 0xe6, 0x87, 0xa5
};

unsigned char jis_x0212_row_31_converted_to_utf8[] = {
  0xe6, 0x87, 0xac, 0xe6, 0x87, 0xad, 0xe6, 0x87, 0xaf, 0xe6, 0x88, 0x81,
  0xe6, 0x88, 0x83, 0xe6, 0x88, 0x84, 0xe6, 0x88, 0x87, 0xe6, 0x88, 0x93,
  0xe6, 0x88, 0x95, 0xe6, 0x88, 0x9c, 0xe6, 0x88, 0xa0, 0xe6, 0x88, 0xa2,
  0xe6, 0x88, 0xa3, 0xe6, 0x88, 0xa7, 0xe6, 0x88, 0xa9, 0xe6, 0x88, 0xab,
  0xe6, 0x88, 0xb9, 0xe6, 0x88, 0xbd, 0xe6, 0x89, 0x82, 0xe6, 0x89, 0x83,
  0xe6, 0x89, 0x84, 0xe6, 0x89, 0x86, 0xe6, 0x89, 0x8c, 0xe6, 0x89, 0x90,
  0xe6, 0x89, 0x91, 0xe6, 0x89, 0x92, 0xe6, 0x89, 0x94, 0xe6, 0x89, 0x96,
  0xe6, 0x89, 0x9a, 0xe6, 0x89, 0x9c, 0xe6, 0x89, 0xa4, 0xe6, 0x89, 0xad,
  0xe6, 0x89, 0xaf, 0xe6, 0x89, 0xb3, 0xe6, 0x89, 0xba, 0xe6, 0x89, 0xbd,
  0xe6, 0x8a, 0x8d, 0xe6, 0x8a, 0x8e, 0xe6, 0x8a, 0x8f, 0xe6, 0x8a, 0x90,
  0xe6, 0x8a, 0xa6, 0xe6, 0x8a, 0xa8, 0xe6, 0x8a, 0xb3, 0xe6, 0x8a, 0xb6,
  0xe6, 0x8a, 0xb7, 0xe6, 0x8a, 0xba, 0xe6, 0x8a, 0xbe, 0xe6, 0x8a, 0xbf,
  0xe6, 0x8b, 0x84, 0xe6, 0x8b, 0x8e, 0xe6, 0x8b, 0x95, 0xe6, 0x8b, 0x96,
  0xe6, 0x8b, 0x9a, 0xe6, 0x8b, 0xaa, 0xe6, 0x8b, 0xb2, 0xe6, 0x8b, 0xb4,
  0xe6, 0x8b, 0xbc, 0xe6, 0x8b, 0xbd, 0xe6, 0x8c, 0x83, 0xe6, 0x8c, 0x84,
  0xe6, 0x8c, 0x8a, 0xe6, 0x8c, 0x8b, 0xe6, 0x8c, 0x8d, 0xe6, 0x8c, 0x90,
  0xe6, 0x8c, 0x93, 0xe6, 0x8c, 0x96, 0xe6, 0x8c, 0x98, 0xe6, 0x8c, 0xa9,
  0xe6, 0x8c, 0xaa, 0xe6, 0x8c, 0xad, 0xe6, 0x8c, 0xb5, 0xe6, 0x8c, 0xb6,
  0xe6, 0x8c, 0xb9, 0xe6, 0x8c, 0xbc, 0xe6, 0x8d, 0x81, 0xe6, 0x8d, 0x82,
  0xe6, 0x8d, 0x83, 0xe6, 0x8d, 0x84, 0xe6, 0x8d, 0x86, 0xe6, 0x8d, 0x8a,
  0xe6, 0x8d, 0x8b, 0xe6, 0x8d, 0x8e, 0xe6, 0x8d, 0x92, 0xe6, 0x8d, 0x93,
  0xe6, 0x8d, 0x94, 0xe6, 0x8d, 0x98, 0xe6, 0x8d, 0x9b, 0xe6, 0x8d, 0xa5,
  0xe6, 0x8d, 0xa6, 0xe6, 0x8d, 0xac, 0xe6, 0x8d, 0xad, 0xe6, 0x8d, 0xb1,
  0xe6, 0x8d, 0xb4, 0xe6, 0x8d, 0xb5
};

unsigned char jis_x0212_row_32_converted_to_utf8[] = {
  0xe6, 0x8d, 0xb8, 0xe6, 0x8d, 0xbc, 0xe6, 0x8d, 0xbd, 0xe6, 0x8d, 0xbf,
  0xe6, 0x8e, 0x82, 0xe6, 0x8e, 0x84, 0xe6, 0x8e, 0x87, 0xe6, 0x8e, 0x8a,
  0xe6, 0x8e, 0x90, 0xe6, 0x8e, 0x94, 0xe6, 0x8e, 0x95, 0xe6, 0x8e, 0x99,
  0xe6, 0x8e, 0x9a, 0xe6, 0x8e, 0x9e, 0xe6, 0x8e, 0xa4, 0xe6, 0x8e, 0xa6,
  0xe6, 0x8e, 0xad, 0xe6, 0x8e, 0xae, 0xe6, 0x8e, 0xaf, 0xe6, 0x8e, 0xbd,
  0xe6, 0x8f, 0x81, 0xe6, 0x8f, 0x85, 0xe6, 0x8f, 0x88, 0xe6, 0x8f, 0x8e,
  0xe6, 0x8f, 0x91, 0xe6, 0x8f, 0x93, 0xe6, 0x8f, 0x94, 0xe6, 0x8f, 0x95,
  0xe6, 0x8f, 0x9c, 0xe6, 0x8f, 0xa0, 0xe6, 0x8f, 0xa5, 0xe6, 0x8f, 0xaa,
  0xe6, 0x8f, 0xac, 0xe6, 0x8f, 0xb2, 0xe6, 0x8f, 0xb3, 0xe6, 0x8f, 0xb5,
  0xe6, 0x8f, 0xb8, 0xe6, 0x8f, 0xb9, 0xe6, 0x90, 0x89, 0xe6, 0x90, 0x8a,
  0xe6, 0x90, 0x90, 0xe6, 0x90, 0x92, 0xe6, 0x90, 0x94, 0xe6, 0x90, 0x98,
  0xe6, 0x90, 0x9e, 0xe6, 0x90, 0xa0, 0xe6, 0x90, 0xa2, 0xe6, 0x90, 0xa4,
  0xe6, 0x90, 0xa5, 0xe6, 0x90, 0xa9, 0xe6, 0x90, 0xaa, 0xe6, 0x90, 0xaf,
  0xe6, 0x90, 0xb0, 0xe6, 0x90, 0xb5, 0xe6, 0x90, 0xbd, 0xe6, 0x90, 0xbf,
  0xe6, 0x91, 0x8b, 0xe6, 0x91, 0x8f, 0xe6, 0x91, 0x91, 0xe6, 0x91, 0x92,
  0xe6, 0x91, 0x93, 0xe6, 0x91, 0x94, 0xe6, 0x91, 0x9a, 0xe6, 0x91, 0x9b,
  0xe6, 0x91, 0x9c, 0xe6, 0x91, 0x9d, 0xe6, 0x91, 0x9f, 0xe6, 0x91, 0xa0,
  0xe6, 0x91, 0xa1, 0xe6, 0x91, 0xa3, 0xe6, 0x91, 0xad, 0xe6, 0x91, 0xb3,
  0xe6, 0x91, 0xb4, 0xe6, 0x91, 0xbb, 0xe6, 0x91, 0xbd, 0xe6, 0x92, 0x85,
  0xe6, 0x92, 0x87, 0xe6, 0x92, 0x8f, 0xe6, 0x92, 0x90, 0xe6, 0x92, 0x91,
  0xe6, 0x92, 0x98, 0xe6, 0x92, 0x99, 0xe6, 0x92, 0x9b, 0xe6, 0x92, 0x9d,
  0xe6, 0x92, 0x9f, 0xe6, 0x92, 0xa1, 0xe6, 0x92, 0xa3, 0xe6, 0x92, 0xa6,
  0xe6, 0x92, 0xa8, 0xe6, 0x92, 0xac, 0xe6, 0x92, 0xb3, 0xe6, 0x92, 0xbd,
  0xe6, 0x92, 0xbe, 0xe6, 0x92, 0xbf
};

unsigned char jis_x0212_row_33_converted_to_utf8[] = {
  0xe6, 0x93, 0x84, 0xe6, 0x93, 0x89, 0xe6, 0x93, 0x8a, 0xe6, 0x93, 0x8b,
  0xe6, 0x93, 0x8c, 0xe6, 0x93, 0x8e, 0xe6, 0x93, 0x90, 0xe6, 0x93, 0x91,
  0xe6, 0x93, 0x95, 0xe6, 0x93, 0x97, 0xe6, 0x93, 0xa4, 0xe6, 0x93, 0xa5,
  0xe6, 0x93, 0xa9, 0xe6, 0x93, 0xaa, 0xe6, 0x93, 0xad, 0xe6, 0x93, 0xb0,
  0xe6, 0x93, 0xb5, 0xe6, 0x93, 0xb7, 0xe6, 0x93, 0xbb, 0xe6, 0x93, 0xbf,
  0xe6, 0x94, 0x81, 0xe6, 0x94, 0x84, 0xe6, 0x94, 0x88, 0xe6, 0x94, 0x89,
  0xe6, 0x94, 0x8a, 0xe6, 0x94, 0x8f, 0xe6, 0x94, 0x93, 0xe6, 0x94, 0x94,
  0xe6, 0x94, 0x96, 0xe6, 0x94, 0x99, 0xe6, 0x94, 0x9b, 0xe6, 0x94, 0x9e,
  0xe6, 0x94, 0x9f, 0xe6, 0x94, 0xa2, 0xe6, 0x94, 0xa6, 0xe6, 0x94, 0xa9,
  0xe6, 0x94, 0xae, 0xe6, 0x94, 0xb1, 0xe6, 0x94, 0xba, 0xe6, 0x94, 0xbc,
  0xe6, 0x94, 0xbd, 0xe6, 0x95, 0x83, 0xe6, 0x95, 0x87, 0xe6, 0x95, 0x89,
  0xe6, 0x95, 0x90, 0xe6, 0x95, 0x92, 0xe6, 0x95, 0x94, 0xe6, 0x95, 0x9f,
  0xe6, 0x95, 0xa0, 0xe6, 0x95, 0xa7, 0xe6, 0x95, 0xab, 0xe6, 0x95, 0xba,
  0xe6, 0x95, 0xbd, 0xe6, 0x96, 0x81, 0xe6, 0x96, 0x85, 0xe6, 0x96, 0x8a,
  0xe6, 0x96, 0x92, 0xe6, 0x96, 0x95, 0xe6, 0x96, 0x98, 0xe6, 0x96, 0x9d,
  0xe6, 0x96, 0xa0, 0xe6, 0x96, 0xa3, 0xe6, 0x96, 0xa6, 0xe6, 0x96, 0xae,
  0xe6, 0x96, 0xb2, 0xe6, 0x96, 0xb3, 0xe6, 0x96, 0xb4, 0xe6, 0x96, 0xbf,
  0xe6, 0x97, 0x82, 0xe6, 0x97, 0x88, 0xe6, 0x97, 0x89, 0xe6, 0x97, 0x8e,
  0xe6, 0x97, 0x90, 0xe6, 0x97, 0x94, 0xe6, 0x97, 0x96, 0xe6, 0x97, 0x98,
  0xe6, 0x97, 0x9f, 0xe6, 0x97, 0xb0, 0xe6, 0x97, 0xb2, 0xe6, 0x97, 0xb4,
  0xe6, 0x97, 0xb5, 0xe6, 0x97, 0xb9, 0xe6, 0x97, 0xbe, 0xe6, 0x97, 0xbf,
  0xe6, 0x98, 0x80, 0xe6, 0x98, 0x84, 0xe6, 0x98, 0x88, 0xe6, 0x98, 0x89,
  0xe6, 0x98, 0x8d, 0xe6, 0x98, 0x91, 0xe6, 0x98, 0x92, 0xe6, 0x98, 0x95,
  0xe6, 0x98, 0x96, 0xe6, 0x98, 0x9d
};

unsigned char jis_x0212_row_34_converted_to_utf8[] = {
  0xe6, 0x98, 0x9e, 0xe6, 0x98, 0xa1, 0xe6, 0x98, 0xa2, 0xe6, 0x98, 0xa3,
  0xe6, 0x98, 0xa4, 0xe6, 0x98, 0xa6, 0xe6, 0x98, 0xa9, 0xe6, 0x98, 0xaa,
  0xe6, 0x98, 0xab, 0xe6, 0x98, 0xac, 0xe6, 0x98, 0xae, 0xe6, 0x98, 0xb0,
  0xe6, 0x98, 0xb1, 0xe6, 0x98, 0xb3, 0xe6, 0x98, 0xb9, 0xe6, 0x98, 0xb7,
  0xe6, 0x99, 0x80, 0xe6, 0x99, 0x85, 0xe6, 0x99, 0x86, 0xe6, 0x99, 0x8a,
  0xe6, 0x99, 0x8c, 0xe6, 0x99, 0x91, 0xe6, 0x99, 0x8e, 0xe6, 0x99, 0x97,
  0xe6, 0x99, 0x98, 0xe6, 0x99, 0x99, 0xe6, 0x99, 0x9b, 0xe6, 0x99, 0x9c,
  0xe6, 0x99, 0xa0, 0xe6, 0x99, 0xa1, 0xe6, 0x9b, 0xbb, 0xe6, 0x99, 0xaa,
  0xe6, 0x99, 0xab, 0xe6, 0x99, 0xac, 0xe6, 0x99, 0xbe, 0xe6, 0x99, 0xb3,
  0xe6, 0x99, 0xb5, 0xe6, 0x99, 0xbf, 0xe6, 0x99, 0xb7, 0xe6, 0x99, 0xb8,
  0xe6, 0x99, 0xb9, 0xe6, 0x99, 0xbb, 0xe6, 0x9a, 0x80, 0xe6, 0x99, 0xbc,
  0xe6, 0x9a, 0x8b, 0xe6, 0x9a, 0x8c, 0xe6, 0x9a, 0x8d, 0xe6, 0x9a, 0x90,
  0xe6, 0x9a, 0x92, 0xe6, 0x9a, 0x99, 0xe6, 0x9a, 0x9a, 0xe6, 0x9a, 0x9b,
  0xe6, 0x9a, 0x9c, 0xe6, 0x9a, 0x9f, 0xe6, 0x9a, 0xa0, 0xe6, 0x9a, 0xa4,
  0xe6, 0x9a, 0xad, 0xe6, 0x9a, 0xb1, 0xe6, 0x9a, 0xb2, 0xe6, 0x9a, 0xb5,
  0xe6, 0x9a, 0xbb, 0xe6, 0x9a, 0xbf, 0xe6, 0x9b, 0x80, 0xe6, 0x9b, 0x82,
  0xe6, 0x9b, 0x83, 0xe6, 0x9b, 0x88, 0xe6, 0x9b, 0x8c, 0xe6, 0x9b, 0x8e,
  0xe6, 0x9b, 0x8f, 0xe6, 0x9b, 0x94, 0xe6, 0x9b, 0x9b, 0xe6, 0x9b, 0x9f,
  0xe6, 0x9b, 0xa8, 0xe6, 0x9b, 0xab, 0xe6, 0x9b, 0xac, 0xe6, 0x9b, 0xae,
  0xe6, 0x9b, 0xba, 0xe6, 0x9c, 0x85, 0xe6, 0x9c, 0x87, 0xe6, 0x9c, 0x8e,
  0xe6, 0x9c, 0x93, 0xe6, 0x9c, 0x99, 0xe6, 0x9c, 0x9c, 0xe6, 0x9c, 0xa0,
  0xe6, 0x9c, 0xa2, 0xe6, 0x9c, 0xb3, 0xe6, 0x9c, 0xbe, 0xe6, 0x9d, 0x85,
  0xe6, 0x9d, 0x87, 0xe6, 0x9d, 0x88, 0xe6, 0x9d, 0x8c, 0xe6, 0x9d, 0x94,
  0xe6, 0x9d, 0x95, 0xe6, 0x9d, 0x9d
};

unsigned char jis_x0212_row_35_converted_to_utf8[] = {
  0xe6, 0x9d, 0xa6, 0xe6, 0x9d, 0xac, 0xe6, 0x9d, 0xae, 0xe6, 0x9d, 0xb4,
  0xe6, 0x9d, 0xb6, 0xe6, 0x9d, 0xbb, 0xe6, 0x9e, 0x81, 0xe6, 0x9e, 0x84,
  0xe6, 0x9e, 0x8e, 0xe6, 0x9e, 0x8f, 0xe6, 0x9e, 0x91, 0xe6, 0x9e, 0x93,
  0xe6, 0x9e, 0x96, 0xe6, 0x9e, 0x98, 0xe6, 0x9e, 0x99, 0xe6, 0x9e, 0x9b,
  0xe6, 0x9e, 0xb0, 0xe6, 0x9e, 0xb1, 0xe6, 0x9e, 0xb2, 0xe6, 0x9e, 0xb5,
  0xe6, 0x9e, 0xbb, 0xe6, 0x9e, 0xbc, 0xe6, 0x9e, 0xbd, 0xe6, 0x9f, 0xb9,
  0xe6, 0x9f, 0x80, 0xe6, 0x9f, 0x82, 0xe6, 0x9f, 0x83, 0xe6, 0x9f, 0x85,
  0xe6, 0x9f, 0x88, 0xe6, 0x9f, 0x89, 0xe6, 0x9f, 0x92, 0xe6, 0x9f, 0x97,
  0xe6, 0x9f, 0x99, 0xe6, 0x9f, 0x9c, 0xe6, 0x9f, 0xa1, 0xe6, 0x9f, 0xa6,
  0xe6, 0x9f, 0xb0, 0xe6, 0x9f, 0xb2, 0xe6, 0x9f, 0xb6, 0xe6, 0x9f, 0xb7,
  0xe6, 0xa1, 0x92, 0xe6, 0xa0, 0x94, 0xe6, 0xa0, 0x99, 0xe6, 0xa0, 0x9d,
  0xe6, 0xa0, 0x9f, 0xe6, 0xa0, 0xa8, 0xe6, 0xa0, 0xa7, 0xe6, 0xa0, 0xac,
  0xe6, 0xa0, 0xad, 0xe6, 0xa0, 0xaf, 0xe6, 0xa0, 0xb0, 0xe6, 0xa0, 0xb1,
  0xe6, 0xa0, 0xb3, 0xe6, 0xa0, 0xbb, 0xe6, 0xa0, 0xbf, 0xe6, 0xa1, 0x84,
  0xe6, 0xa1, 0x85, 0xe6, 0xa1, 0x8a, 0xe6, 0xa1, 0x8c, 0xe6, 0xa1, 0x95,
  0xe6, 0xa1, 0x97, 0xe6, 0xa1, 0x98, 0xe6, 0xa1, 0x9b, 0xe6, 0xa1, 0xab,
  0xe6, 0xa1, 0xae, 0xe6, 0xa1, 0xaf, 0xe6, 0xa1, 0xb0, 0xe6, 0xa1, 0xb1,
  0xe6, 0xa1, 0xb2, 0xe6, 0xa1, 0xb5, 0xe6, 0xa1, 0xb9, 0xe6, 0xa1, 0xba,
  0xe6, 0xa1, 0xbb, 0xe6, 0xa1, 0xbc, 0xe6, 0xa2, 0x82, 0xe6, 0xa2, 0x84,
  0xe6, 0xa2, 0x86, 0xe6, 0xa2, 0x88, 0xe6, 0xa2, 0x96, 0xe6, 0xa2, 0x98,
  0xe6, 0xa2, 0x9a, 0xe6, 0xa2, 0x9c, 0xe6, 0xa2, 0xa1, 0xe6, 0xa2, 0xa3,
  0xe6, 0xa2, 0xa5, 0xe6, 0xa2, 0xa9, 0xe6, 0xa2, 0xaa, 0xe6, 0xa2, 0xae,
  0xe6, 0xa2, 0xb2, 0xe6, 0xa2, 0xbb, 0xe6, 0xa3, 0x85, 0xe6, 0xa3, 0x88,
  0xe6, 0xa3, 0x8c, 0xe6, 0xa3, 0x8f
};

unsigned char jis_x0212_row_36_converted_to_utf8[] = {
  0xe6, 0xa3, 0x90, 0xe6, 0xa3, 0x91, 0xe6, 0xa3, 0x93, 0xe6, 0xa3, 0x96,
  0xe6, 0xa3, 0x99, 0xe6, 0xa3, 0x9c, 0xe6, 0xa3, 0x9d, 0xe6, 0xa3, 0xa5,
  0xe6, 0xa3, 0xa8, 0xe6, 0xa3, 0xaa, 0xe6, 0xa3, 0xab, 0xe6, 0xa3, 0xac,
  0xe6, 0xa3, 0xad, 0xe6, 0xa3, 0xb0, 0xe6, 0xa3, 0xb1, 0xe6, 0xa3, 0xb5,
  0xe6, 0xa3, 0xb6, 0xe6, 0xa3, 0xbb, 0xe6, 0xa3, 0xbc, 0xe6, 0xa3, 0xbd,
  0xe6, 0xa4, 0x86, 0xe6, 0xa4, 0x89, 0xe6, 0xa4, 0x8a, 0xe6, 0xa4, 0x90,
  0xe6, 0xa4, 0x91, 0xe6, 0xa4, 0x93, 0xe6, 0xa4, 0x96, 0xe6, 0xa4, 0x97,
  0xe6, 0xa4, 0xb1, 0xe6, 0xa4, 0xb3, 0xe6, 0xa4, 0xb5, 0xe6, 0xa4, 0xb8,
  0xe6, 0xa4, 0xbb, 0xe6, 0xa5, 0x82, 0xe6, 0xa5, 0x85, 0xe6, 0xa5, 0x89,
  0xe6, 0xa5, 0x8e, 0xe6, 0xa5, 0x97, 0xe6, 0xa5, 0x9b, 0xe6, 0xa5, 0xa3,
  0xe6, 0xa5, 0xa4, 0xe6, 0xa5, 0xa5, 0xe6, 0xa5, 0xa6, 0xe6, 0xa5, 0xa8,
  0xe6, 0xa5, 0xa9, 0xe6, 0xa5, 0xac, 0xe6, 0xa5, 0xb0, 0xe6, 0xa5, 0xb1,
  0xe6, 0xa5, 0xb2, 0xe6, 0xa5, 0xba, 0xe6, 0xa5, 0xbb, 0xe6, 0xa5, 0xbf,
  0xe6, 0xa6, 0x80, 0xe6, 0xa6, 0x8d, 0xe6, 0xa6, 0x92, 0xe6, 0xa6, 0x96,
  0xe6, 0xa6, 0x98, 0xe6, 0xa6, 0xa1, 0xe6, 0xa6, 0xa5, 0xe6, 0xa6, 0xa6,
  0xe6, 0xa6, 0xa8, 0xe6, 0xa6, 0xab, 0xe6, 0xa6, 0xad, 0xe6, 0xa6, 0xaf,
  0xe6, 0xa6, 0xb7, 0xe6, 0xa6, 0xb8, 0xe6, 0xa6, 0xba, 0xe6, 0xa6, 0xbc,
  0xe6, 0xa7, 0x85, 0xe6, 0xa7, 0x88, 0xe6, 0xa7, 0x91, 0xe6, 0xa7, 0x96,
  0xe6, 0xa7, 0x97, 0xe6, 0xa7, 0xa2, 0xe6, 0xa7, 0xa5, 0xe6, 0xa7, 0xae,
  0xe6, 0xa7, 0xaf, 0xe6, 0xa7, 0xb1, 0xe6, 0xa7, 0xb3, 0xe6, 0xa7, 0xb5,
  0xe6, 0xa7, 0xbe, 0xe6, 0xa8, 0x80, 0xe6, 0xa8, 0x81, 0xe6, 0xa8, 0x83,
  0xe6, 0xa8, 0x8f, 0xe6, 0xa8, 0x91, 0xe6, 0xa8, 0x95, 0xe6, 0xa8, 0x9a,
  0xe6, 0xa8, 0x9d, 0xe6, 0xa8, 0xa0, 0xe6, 0xa8, 0xa4, 0xe6, 0xa8, 0xa8,
  0xe6, 0xa8, 0xb0, 0xe6, 0xa8, 0xb2
};

unsigned char jis_x0212_row_37_converted_to_utf8[] = {
  0xe6, 0xa8, 0xb4, 0xe6, 0xa8, 0xb7, 0xe6, 0xa8, 0xbb, 0xe6, 0xa8, 0xbe,
  0xe6, 0xa8, 0xbf, 0xe6, 0xa9, 0x85, 0xe6, 0xa9, 0x86, 0xe6, 0xa9, 0x89,
  0xe6, 0xa9, 0x8a, 0xe6, 0xa9, 0x8e, 0xe6, 0xa9, 0x90, 0xe6, 0xa9, 0x91,
  0xe6, 0xa9, 0x92, 0xe6, 0xa9, 0x95, 0xe6, 0xa9, 0x96, 0xe6, 0xa9, 0x9b,
  0xe6, 0xa9, 0xa4, 0xe6, 0xa9, 0xa7, 0xe6, 0xa9, 0xaa, 0xe6, 0xa9, 0xb1,
  0xe6, 0xa9, 0xb3, 0xe6, 0xa9, 0xbe, 0xe6, 0xaa, 0x81, 0xe6, 0xaa, 0x83,
  0xe6, 0xaa, 0x86, 0xe6, 0xaa, 0x87, 0xe6, 0xaa, 0x89, 0xe6, 0xaa, 0x8b,
  0xe6, 0xaa, 0x91, 0xe6, 0xaa, 0x9b, 0xe6, 0xaa, 0x9d, 0xe6, 0xaa, 0x9e,
  0xe6, 0xaa, 0x9f, 0xe6, 0xaa, 0xa5, 0xe6, 0xaa, 0xab, 0xe6, 0xaa, 0xaf,
  0xe6, 0xaa, 0xb0, 0xe6, 0xaa, 0xb1, 0xe6, 0xaa, 0xb4, 0xe6, 0xaa, 0xbd,
  0xe6, 0xaa, 0xbe, 0xe6, 0xaa, 0xbf, 0xe6, 0xab, 0x86, 0xe6, 0xab, 0x89,
  0xe6, 0xab, 0x88, 0xe6, 0xab, 0x8c, 0xe6, 0xab, 0x90, 0xe6, 0xab, 0x94,
  0xe6, 0xab, 0x95, 0xe6, 0xab, 0x96, 0xe6, 0xab, 0x9c, 0xe6, 0xab, 0x9d,
  0xe6, 0xab, 0xa4, 0xe6, 0xab, 0xa7, 0xe6, 0xab, 0xac, 0xe6, 0xab, 0xb0,
  0xe6, 0xab, 0xb1, 0xe6, 0xab, 0xb2, 0xe6, 0xab, 0xbc, 0xe6, 0xab, 0xbd,
  0xe6, 0xac, 0x82, 0xe6, 0xac, 0x83, 0xe6, 0xac, 0x86, 0xe6, 0xac, 0x87,
  0xe6, 0xac, 0x89, 0xe6, 0xac, 0x8f, 0xe6, 0xac, 0x90, 0xe6, 0xac, 0x91,
  0xe6, 0xac, 0x97, 0xe6, 0xac, 0x9b, 0xe6, 0xac, 0x9e, 0xe6, 0xac, 0xa4,
  0xe6, 0xac, 0xa8, 0xe6, 0xac, 0xab, 0xe6, 0xac, 0xac, 0xe6, 0xac, 0xaf,
  0xe6, 0xac, 0xb5, 0xe6, 0xac, 0xb6, 0xe6, 0xac, 0xbb, 0xe6, 0xac, 0xbf,
  0xe6, 0xad, 0x86, 0xe6, 0xad, 0x8a, 0xe6, 0xad, 0x8d, 0xe6, 0xad, 0x92,
  0xe6, 0xad, 0x96, 0xe6, 0xad, 0x98, 0xe6, 0xad, 0x9d, 0xe6, 0xad, 0xa0,
  0xe6, 0xad, 0xa7, 0xe6, 0xad, 0xab, 0xe6, 0xad, 0xae, 0xe6, 0xad, 0xb0,
  0xe6, 0xad, 0xb5, 0xe6, 0xad, 0xbd
};

unsigned char jis_x0212_row_38_converted_to_utf8[] = {
  0xe6, 0xad, 0xbe, 0xe6, 0xae, 0x82, 0xe6, 0xae, 0x85, 0xe6, 0xae, 0x97,
  0xe6, 0xae, 0x9b, 0xe6, 0xae, 0x9f, 0xe6, 0xae, 0xa0, 0xe6, 0xae, 0xa2,
  0xe6, 0xae, 0xa3, 0xe6, 0xae, 0xa8, 0xe6, 0xae, 0xa9, 0xe6, 0xae, 0xac,
  0xe6, 0xae, 0xad, 0xe6, 0xae, 0xae, 0xe6, 0xae, 0xb0, 0xe6, 0xae, 0xb8,
  0xe6, 0xae, 0xb9, 0xe6, 0xae, 0xbd, 0xe6, 0xae, 0xbe, 0xe6, 0xaf, 0x83,
  0xe6, 0xaf, 0x84, 0xe6, 0xaf, 0x89, 0xe6, 0xaf, 0x8c, 0xe6, 0xaf, 0x96,
  0xe6, 0xaf, 0x9a, 0xe6, 0xaf, 0xa1, 0xe6, 0xaf, 0xa3, 0xe6, 0xaf, 0xa6,
  0xe6, 0xaf, 0xa7, 0xe6, 0xaf, 0xae, 0xe6, 0xaf, 0xb1, 0xe6, 0xaf, 0xb7,
  0xe6, 0xaf, 0xb9, 0xe6, 0xaf, 0xbf, 0xe6, 0xb0, 0x82, 0xe6, 0xb0, 0x84,
  0xe6, 0xb0, 0x85, 0xe6, 0xb0, 0x89, 0xe6, 0xb0, 0x8d, 0xe6, 0xb0, 0x8e,
  0xe6, 0xb0, 0x90, 0xe6, 0xb0, 0x92, 0xe6, 0xb0, 0x99, 0xe6, 0xb0, 0x9f,
  0xe6, 0xb0, 0xa6, 0xe6, 0xb0, 0xa7, 0xe6, 0xb0, 0xa8, 0xe6, 0xb0, 0xac,
  0xe6, 0xb0, 0xae, 0xe6, 0xb0, 0xb3, 0xe6, 0xb0, 0xb5, 0xe6, 0xb0, 0xb6,
  0xe6, 0xb0, 0xba, 0xe6, 0xb0, 0xbb, 0xe6, 0xb0, 0xbf, 0xe6, 0xb1, 0x8a,
  0xe6, 0xb1, 0x8b, 0xe6, 0xb1, 0x8d, 0xe6, 0xb1, 0x8f, 0xe6, 0xb1, 0x92,
  0xe6, 0xb1, 0x94, 0xe6, 0xb1, 0x99, 0xe6, 0xb1, 0x9b, 0xe6, 0xb1, 0x9c,
  0xe6, 0xb1, 0xab, 0xe6, 0xb1, 0xad, 0xe6, 0xb1, 0xaf, 0xe6, 0xb1, 0xb4,
  0xe6, 0xb1, 0xb6, 0xe6, 0xb1, 0xb8, 0xe6, 0xb1, 0xb9, 0xe6, 0xb1, 0xbb,
  0xe6, 0xb2, 0x85, 0xe6, 0xb2, 0x86, 0xe6, 0xb2, 0x87, 0xe6, 0xb2, 0x89,
  0xe6, 0xb2, 0x94, 0xe6, 0xb2, 0x95, 0xe6, 0xb2, 0x97, 0xe6, 0xb2, 0x98,
  0xe6, 0xb2, 0x9c, 0xe6, 0xb2, 0x9f, 0xe6, 0xb2, 0xb0, 0xe6, 0xb2, 0xb2,
  0xe6, 0xb2, 0xb4, 0xe6, 0xb3, 0x82, 0xe6, 0xb3, 0x86, 0xe6, 0xb3, 0x8d,
  0xe6, 0xb3, 0x8f, 0xe6, 0xb3, 0x90, 0xe6, 0xb3, 0x91, 0xe6, 0xb3, 0x92,
  0xe6, 0xb3, 0x94, 0xe6, 0xb3, 0x96
};

unsigned char jis_x0212_row_39_converted_to_utf8[] = {
  0xe6, 0xb3, 0x9a, 0xe6, 0xb3, 0x9c, 0xe6, 0xb3, 0xa0, 0xe6, 0xb3, 0xa7,
  0xe6, 0xb3, 0xa9, 0xe6, 0xb3, 0xab, 0xe6, 0xb3, 0xac, 0xe6, 0xb3, 0xae,
  0xe6, 0xb3, 0xb2, 0xe6, 0xb3, 0xb4, 0xe6, 0xb4, 0x84, 0xe6, 0xb4, 0x87,
  0xe6, 0xb4, 0x8a, 0xe6, 0xb4, 0x8e, 0xe6, 0xb4, 0x8f, 0xe6, 0xb4, 0x91,
  0xe6, 0xb4, 0x93, 0xe6, 0xb4, 0x9a, 0xe6, 0xb4, 0xa6, 0xe6, 0xb4, 0xa7,
  0xe6, 0xb4, 0xa8, 0xe6, 0xb1, 0xa7, 0xe6, 0xb4, 0xae, 0xe6, 0xb4, 0xaf,
  0xe6, 0xb4, 0xb1, 0xe6, 0xb4, 0xb9, 0xe6, 0xb4, 0xbc, 0xe6, 0xb4, 0xbf,
  0xe6, 0xb5, 0x97, 0xe6, 0xb5, 0x9e, 0xe6, 0xb5, 0x9f, 0xe6, 0xb5, 0xa1,
  0xe6, 0xb5, 0xa5, 0xe6, 0xb5, 0xa7, 0xe6, 0xb5, 0xaf, 0xe6, 0xb5, 0xb0,
  0xe6, 0xb5, 0xbc, 0xe6, 0xb6, 0x82, 0xe6, 0xb6, 0x87, 0xe6, 0xb6, 0x91,
  0xe6, 0xb6, 0x92, 0xe6, 0xb6, 0x94, 0xe6, 0xb6, 0x96, 0xe6, 0xb6, 0x97,
  0xe6, 0xb6, 0x98, 0xe6, 0xb6, 0xaa, 0xe6, 0xb6, 0xac, 0xe6, 0xb6, 0xb4,
  0xe6, 0xb6, 0xb7, 0xe6, 0xb6, 0xb9, 0xe6, 0xb6, 0xbd, 0xe6, 0xb6, 0xbf,
  0xe6, 0xb7, 0x84, 0xe6, 0xb7, 0x88, 0xe6, 0xb7, 0x8a, 0xe6, 0xb7, 0x8e,
  0xe6, 0xb7, 0x8f, 0xe6, 0xb7, 0x96, 0xe6, 0xb7, 0x9b, 0xe6, 0xb7, 0x9d,
  0xe6, 0xb7, 0x9f, 0xe6, 0xb7, 0xa0, 0xe6, 0xb7, 0xa2, 0xe6, 0xb7, 0xa5,
  0xe6, 0xb7, 0xa9, 0xe6, 0xb7, 0xaf, 0xe6, 0xb7, 0xb0, 0xe6, 0xb7, 0xb4,
  0xe6, 0xb7, 0xb6, 0xe6, 0xb7, 0xbc, 0xe6, 0xb8, 0x80, 0xe6, 0xb8, 0x84,
  0xe6, 0xb8, 0x9e, 0xe6, 0xb8, 0xa2, 0xe6, 0xb8, 0xa7, 0xe6, 0xb8, 0xb2,
  0xe6, 0xb8, 0xb6, 0xe6, 0xb8, 0xb9, 0xe6, 0xb8, 0xbb, 0xe6, 0xb8, 0xbc,
  0xe6, 0xb9, 0x84, 0xe6, 0xb9, 0x85, 0xe6, 0xb9, 0x88, 0xe6, 0xb9, 0x89,
  0xe6, 0xb9, 0x8b, 0xe6, 0xb9, 0x8f, 0xe6, 0xb9, 0x91, 0xe6, 0xb9, 0x92,
  0xe6, 0xb9, 0x93, 0xe6, 0xb9, 0x94, 0xe6, 0xb9, 0x97, 0xe6, 0xb9, 0x9c,
  0xe6, 0xb9, 0x9d, 0xe6, 0xb9, 0x9e
};

unsigned char jis_x0212_row_40_converted_to_utf8[] = {
  0xe6, 0xb9, 0xa2, 0xe6, 0xb9, 0xa3, 0xe6, 0xb9, 0xa8, 0xe6, 0xb9, 0xb3,
  0xe6, 0xb9, 0xbb, 0xe6, 0xb9, 0xbd, 0xe6, 0xba, 0x8d, 0xe6, 0xba, 0x93,
  0xe6, 0xba, 0x99, 0xe6, 0xba, 0xa0, 0xe6, 0xba, 0xa7, 0xe6, 0xba, 0xad,
  0xe6, 0xba, 0xae, 0xe6, 0xba, 0xb1, 0xe6, 0xba, 0xb3, 0xe6, 0xba, 0xbb,
  0xe6, 0xba, 0xbf, 0xe6, 0xbb, 0x80, 0xe6, 0xbb, 0x81, 0xe6, 0xbb, 0x83,
  0xe6, 0xbb, 0x87, 0xe6, 0xbb, 0x88, 0xe6, 0xbb, 0x8a, 0xe6, 0xbb, 0x8d,
  0xe6, 0xbb, 0x8e, 0xe6, 0xbb, 0x8f, 0xe6, 0xbb, 0xab, 0xe6, 0xbb, 0xad,
  0xe6, 0xbb, 0xae, 0xe6, 0xbb, 0xb9, 0xe6, 0xbb, 0xbb, 0xe6, 0xbb, 0xbd,
  0xe6, 0xbc, 0x84, 0xe6, 0xbc, 0x88, 0xe6, 0xbc, 0x8a, 0xe6, 0xbc, 0x8c,
  0xe6, 0xbc, 0x8d, 0xe6, 0xbc, 0x96, 0xe6, 0xbc, 0x98, 0xe6, 0xbc, 0x9a,
  0xe6, 0xbc, 0x9b, 0xe6, 0xbc, 0xa6, 0xe6, 0xbc, 0xa9, 0xe6, 0xbc, 0xaa,
  0xe6, 0xbc, 0xaf, 0xe6, 0xbc, 0xb0, 0xe6, 0xbc, 0xb3, 0xe6, 0xbc, 0xb6,
  0xe6, 0xbc, 0xbb, 0xe6, 0xbc, 0xbc, 0xe6, 0xbc, 0xad, 0xe6, 0xbd, 0x8f,
  0xe6, 0xbd, 0x91, 0xe6, 0xbd, 0x92, 0xe6, 0xbd, 0x93, 0xe6, 0xbd, 0x97,
  0xe6, 0xbd, 0x99, 0xe6, 0xbd, 0x9a, 0xe6, 0xbd, 0x9d, 0xe6, 0xbd, 0x9e,
  0xe6, 0xbd, 0xa1, 0xe6, 0xbd, 0xa2, 0xe6, 0xbd, 0xa8, 0xe6, 0xbd, 0xac,
  0xe6, 0xbd, 0xbd, 0xe6, 0xbd, 0xbe, 0xe6, 0xbe, 0x83, 0xe6, 0xbe, 0x87,
  0xe6, 0xbe, 0x88, 0xe6, 0xbe, 0x8b, 0xe6, 0xbe, 0x8c, 0xe6, 0xbe, 0x8d,
  0xe6, 0xbe, 0x90, 0xe6, 0xbe, 0x92, 0xe6, 0xbe, 0x93, 0xe6, 0xbe, 0x94,
  0xe6, 0xbe, 0x96, 0xe6, 0xbe, 0x9a, 0xe6, 0xbe, 0x9f, 0xe6, 0xbe, 0xa0,
  0xe6, 0xbe, 0xa5, 0xe6, 0xbe, 0xa6, 0xe6, 0xbe, 0xa7, 0xe6, 0xbe, 0xa8,
  0xe6, 0xbe, 0xae, 0xe6, 0xbe, 0xaf, 0xe6, 0xbe, 0xb0, 0xe6, 0xbe, 0xb5,
  0xe6, 0xbe, 0xb6, 0xe6, 0xbe, 0xbc, 0xe6, 0xbf, 0x85, 0xe6, 0xbf, 0x87,
  0xe6, 0xbf, 0x88, 0xe6, 0xbf, 0x8a
};

unsigned char jis_x0212_row_41_converted_to_utf8[] = {
  0xe6, 0xbf, 0x9a, 0xe6, 0xbf, 0x9e, 0xe6, 0xbf, 0xa8, 0xe6, 0xbf, 0xa9,
  0xe6, 0xbf, 0xb0, 0xe6, 0xbf, 0xb5, 0xe6, 0xbf, 0xb9, 0xe6, 0xbf, 0xbc,
  0xe6, 0xbf, 0xbd, 0xe7, 0x80, 0x80, 0xe7, 0x80, 0x85, 0xe7, 0x80, 0x86,
  0xe7, 0x80, 0x87, 0xe7, 0x80, 0x8d, 0xe7, 0x80, 0x97, 0xe7, 0x80, 0xa0,
  0xe7, 0x80, 0xa3, 0xe7, 0x80, 0xaf, 0xe7, 0x80, 0xb4, 0xe7, 0x80, 0xb7,
  0xe7, 0x80, 0xb9, 0xe7, 0x80, 0xbc, 0xe7, 0x81, 0x83, 0xe7, 0x81, 0x84,
  0xe7, 0x81, 0x88, 0xe7, 0x81, 0x89, 0xe7, 0x81, 0x8a, 0xe7, 0x81, 0x8b,
  0xe7, 0x81, 0x94, 0xe7, 0x81, 0x95, 0xe7, 0x81, 0x9d, 0xe7, 0x81, 0x9e,
  0xe7, 0x81, 0x8e, 0xe7, 0x81, 0xa4, 0xe7, 0x81, 0xa5, 0xe7, 0x81, 0xac,
  0xe7, 0x81, 0xae, 0xe7, 0x81, 0xb5, 0xe7, 0x81, 0xb6, 0xe7, 0x81, 0xbe,
  0xe7, 0x82, 0x81, 0xe7, 0x82, 0x85, 0xe7, 0x82, 0x86, 0xe7, 0x82, 0x94,
  0xe7, 0x82, 0x95, 0xe7, 0x82, 0x96, 0xe7, 0x82, 0x97, 0xe7, 0x82, 0x98,
  0xe7, 0x82, 0x9b, 0xe7, 0x82, 0xa4, 0xe7, 0x82, 0xab, 0xe7, 0x82, 0xb0,
  0xe7, 0x82, 0xb1, 0xe7, 0x82, 0xb4, 0xe7, 0x82, 0xb7, 0xe7, 0x83, 0x8a,
  0xe7, 0x83, 0x91, 0xe7, 0x83, 0x93, 0xe7, 0x83, 0x94, 0xe7, 0x83, 0x95,
  0xe7, 0x83, 0x96, 0xe7, 0x83, 0x98, 0xe7, 0x83, 0x9c, 0xe7, 0x83, 0xa4,
  0xe7, 0x83, 0xba, 0xe7, 0x84, 0x83, 0xe7, 0x84, 0x84, 0xe7, 0x84, 0x85,
  0xe7, 0x84, 0x86, 0xe7, 0x84, 0x87, 0xe7, 0x84, 0x8b, 0xe7, 0x84, 0x8c,
  0xe7, 0x84, 0x8f, 0xe7, 0x84, 0x9e, 0xe7, 0x84, 0xa0, 0xe7, 0x84, 0xab,
  0xe7, 0x84, 0xad, 0xe7, 0x84, 0xaf, 0xe7, 0x84, 0xb0, 0xe7, 0x84, 0xb1,
  0xe7, 0x84, 0xb8, 0xe7, 0x85, 0x81, 0xe7, 0x85, 0x85, 0xe7, 0x85, 0x86,
  0xe7, 0x85, 0x87, 0xe7, 0x85, 0x8a, 0xe7, 0x85, 0x8b, 0xe7, 0x85, 0x90,
  0xe7, 0x85, 0x92, 0xe7, 0x85, 0x97, 0xe7, 0x85, 0x9a, 0xe7, 0x85, 0x9c,
  0xe7, 0x85, 0x9e, 0xe7, 0x85, 0xa0
};

unsigned char jis_x0212_row_42_converted_to_utf8[] = {
  0xe7, 0x85, 0xa8, 0xe7, 0x85, 0xb9, 0xe7, 0x86, 0x80, 0xe7, 0x86, 0x85,
  0xe7, 0x86, 0x87, 0xe7, 0x86, 0x8c, 0xe7, 0x86, 0x92, 0xe7, 0x86, 0x9a,
  0xe7, 0x86, 0x9b, 0xe7, 0x86, 0xa0, 0xe7, 0x86, 0xa2, 0xe7, 0x86, 0xaf,
  0xe7, 0x86, 0xb0, 0xe7, 0x86, 0xb2, 0xe7, 0x86, 0xb3, 0xe7, 0x86, 0xba,
  0xe7, 0x86, 0xbf, 0xe7, 0x87, 0x80, 0xe7, 0x87, 0x81, 0xe7, 0x87, 0x84,
  0xe7, 0x87, 0x8b, 0xe7, 0x87, 0x8c, 0xe7, 0x87, 0x93, 0xe7, 0x87, 0x96,
  0xe7, 0x87, 0x99, 0xe7, 0x87, 0x9a, 0xe7, 0x87, 0x9c, 0xe7, 0x87, 0xb8,
  0xe7, 0x87, 0xbe, 0xe7, 0x88, 0x80, 0xe7, 0x88, 0x87, 0xe7, 0x88, 0x88,
  0xe7, 0x88, 0x89, 0xe7, 0x88, 0x93, 0xe7, 0x88, 0x97, 0xe7, 0x88, 0x9a,
  0xe7, 0x88, 0x9d, 0xe7, 0x88, 0x9f, 0xe7, 0x88, 0xa4, 0xe7, 0x88, 0xab,
  0xe7, 0x88, 0xaf, 0xe7, 0x88, 0xb4, 0xe7, 0x88, 0xb8, 0xe7, 0x88, 0xb9,
  0xe7, 0x89, 0x81, 0xe7, 0x89, 0x82, 0xe7, 0x89, 0x83, 0xe7, 0x89, 0x85,
  0xe7, 0x89, 0x8e, 0xe7, 0x89, 0x8f, 0xe7, 0x89, 0x90, 0xe7, 0x89, 0x93,
  0xe7, 0x89, 0x95, 0xe7, 0x89, 0x96, 0xe7, 0x89, 0x9a, 0xe7, 0x89, 0x9c,
  0xe7, 0x89, 0x9e, 0xe7, 0x89, 0xa0, 0xe7, 0x89, 0xa3, 0xe7, 0x89, 0xa8,
  0xe7, 0x89, 0xab, 0xe7, 0x89, 0xae, 0xe7, 0x89, 0xaf, 0xe7, 0x89, 0xb1,
  0xe7, 0x89, 0xb7, 0xe7, 0x89, 0xb8, 0xe7, 0x89, 0xbb, 0xe7, 0x89, 0xbc,
  0xe7, 0x89, 0xbf, 0xe7, 0x8a, 0x84, 0xe7, 0x8a, 0x89, 0xe7, 0x8a, 0x8d,
  0xe7, 0x8a, 0x8e, 0xe7, 0x8a, 0x93, 0xe7, 0x8a, 0x9b, 0xe7, 0x8a, 0xa8,
  0xe7, 0x8a, 0xad, 0xe7, 0x8a, 0xae, 0xe7, 0x8a, 0xb1, 0xe7, 0x8a, 0xb4,
  0xe7, 0x8a, 0xbe, 0xe7, 0x8b, 0x81, 0xe7, 0x8b, 0x87, 0xe7, 0x8b, 0x89,
  0xe7, 0x8b, 0x8c, 0xe7, 0x8b, 0x95, 0xe7, 0x8b, 0x96, 0xe7, 0x8b, 0x98,
  0xe7, 0x8b, 0x9f, 0xe7, 0x8b, 0xa5, 0xe7, 0x8b, 0xb3, 0xe7, 0x8b, 0xb4,
  0xe7, 0x8b, 0xba, 0xe7, 0x8b, 0xbb
};

unsigned char jis_x0212_row_43_converted_to_utf8[] = {
  0xe7, 0x8b, 0xbe, 0xe7, 0x8c, 0x82, 0xe7, 0x8c, 0x84, 0xe7, 0x8c, 0x85,
  0xe7, 0x8c, 0x87, 0xe7, 0x8c, 0x8b, 0xe7, 0x8c, 0x8d, 0xe7, 0x8c, 0x92,
  0xe7, 0x8c, 0x93, 0xe7, 0x8c, 0x98, 0xe7, 0x8c, 0x99, 0xe7, 0x8c, 0x9e,
  0xe7, 0x8c, 0xa2, 0xe7, 0x8c, 0xa4, 0xe7, 0x8c, 0xa7, 0xe7, 0x8c, 0xa8,
  0xe7, 0x8c, 0xac, 0xe7, 0x8c, 0xb1, 0xe7, 0x8c, 0xb2, 0xe7, 0x8c, 0xb5,
  0xe7, 0x8c, 0xba, 0xe7, 0x8c, 0xbb, 0xe7, 0x8c, 0xbd, 0xe7, 0x8d, 0x83,
  0xe7, 0x8d, 0x8d, 0xe7, 0x8d, 0x90, 0xe7, 0x8d, 0x92, 0xe7, 0x8d, 0x96,
  0xe7, 0x8d, 0x98, 0xe7, 0x8d, 0x9d, 0xe7, 0x8d, 0x9e, 0xe7, 0x8d, 0x9f,
  0xe7, 0x8d, 0xa0, 0xe7, 0x8d, 0xa6, 0xe7, 0x8d, 0xa7, 0xe7, 0x8d, 0xa9,
  0xe7, 0x8d, 0xab, 0xe7, 0x8d, 0xac, 0xe7, 0x8d, 0xae, 0xe7, 0x8d, 0xaf,
  0xe7, 0x8d, 0xb1, 0xe7, 0x8d, 0xb7, 0xe7, 0x8d, 0xb9, 0xe7, 0x8d, 0xbc,
  0xe7, 0x8e, 0x80, 0xe7, 0x8e, 0x81, 0xe7, 0x8e, 0x83, 0xe7, 0x8e, 0x85,
  0xe7, 0x8e, 0x86, 0xe7, 0x8e, 0x8e, 0xe7, 0x8e, 0x90, 0xe7, 0x8e, 0x93,
  0xe7, 0x8e, 0x95, 0xe7, 0x8e, 0x97, 0xe7, 0x8e, 0x98, 0xe7, 0x8e, 0x9c,
  0xe7, 0x8e, 0x9e, 0xe7, 0x8e, 0x9f, 0xe7, 0x8e, 0xa0, 0xe7, 0x8e, 0xa2,
  0xe7, 0x8e, 0xa5, 0xe7, 0x8e, 0xa6, 0xe7, 0x8e, 0xaa, 0xe7, 0x8e, 0xab,
  0xe7, 0x8e, 0xad, 0xe7, 0x8e, 0xb5, 0xe7, 0x8e, 0xb7, 0xe7, 0x8e, 0xb9,
  0xe7, 0x8e, 0xbc, 0xe7, 0x8e, 0xbd, 0xe7, 0x8e, 0xbf, 0xe7, 0x8f, 0x85,
  0xe7, 0x8f, 0x86, 0xe7, 0x8f, 0x89, 0xe7, 0x8f, 0x8b, 0xe7, 0x8f, 0x8c,
  0xe7, 0x8f, 0x8f, 0xe7, 0x8f, 0x92, 0xe7, 0x8f, 0x93, 0xe7, 0x8f, 0x96,
  0xe7, 0x8f, 0x99, 0xe7, 0x8f, 0x9d, 0xe7, 0x8f, 0xa1, 0xe7, 0x8f, 0xa3,
  0xe7, 0x8f, 0xa6, 0xe7, 0x8f, 0xa7, 0xe7, 0x8f, 0xa9, 0xe7, 0x8f, 0xb4,
  0xe7, 0x8f, 0xb5, 0xe7, 0x8f, 0xb7, 0xe7, 0x8f, 0xb9, 0xe7, 0x8f, 0xba,
  0xe7, 0x8f, 0xbb, 0xe7, 0x8f, 0xbd
};

unsigned char jis_x0212_row_44_converted_to_utf8[] = {
  0xe7, 0x8f, 0xbf, 0xe7, 0x90, 0x80, 0xe7, 0x90, 0x81, 0xe7, 0x90, 0x84,
  0xe7, 0x90, 0x87, 0xe7, 0x90, 0x8a, 0xe7, 0x90, 0x91, 0xe7, 0x90, 0x9a,
  0xe7, 0x90, 0x9b, 0xe7, 0x90, 0xa4, 0xe7, 0x90, 0xa6, 0xe7, 0x90, 0xa8,
  0xe7, 0x90, 0xa9, 0xe7, 0x90, 0xaa, 0xe7, 0x90, 0xab, 0xe7, 0x90, 0xac,
  0xe7, 0x90, 0xad, 0xe7, 0x90, 0xae, 0xe7, 0x90, 0xaf, 0xe7, 0x90, 0xb0,
  0xe7, 0x90, 0xb1, 0xe7, 0x90, 0xb9, 0xe7, 0x91, 0x80, 0xe7, 0x91, 0x83,
  0xe7, 0x91, 0x84, 0xe7, 0x91, 0x86, 0xe7, 0x91, 0x87, 0xe7, 0x91, 0x8b,
  0xe7, 0x91, 0x8d, 0xe7, 0x91, 0x91, 0xe7, 0x91, 0x92, 0xe7, 0x91, 0x97,
  0xe7, 0x91, 0x9d, 0xe7, 0x91, 0xa2, 0xe7, 0x91, 0xa6, 0xe7, 0x91, 0xa7,
  0xe7, 0x91, 0xa8, 0xe7, 0x91, 0xab, 0xe7, 0x91, 0xad, 0xe7, 0x91, 0xae,
  0xe7, 0x91, 0xb1, 0xe7, 0x91, 0xb2, 0xe7, 0x92, 0x80, 0xe7, 0x92, 0x81,
  0xe7, 0x92, 0x85, 0xe7, 0x92, 0x86, 0xe7, 0x92, 0x87, 0xe7, 0x92, 0x89,
  0xe7, 0x92, 0x8f, 0xe7, 0x92, 0x90, 0xe7, 0x92, 0x91, 0xe7, 0x92, 0x92,
  0xe7, 0x92, 0x98, 0xe7, 0x92, 0x99, 0xe7, 0x92, 0x9a, 0xe7, 0x92, 0x9c,
  0xe7, 0x92, 0x9f, 0xe7, 0x92, 0xa0, 0xe7, 0x92, 0xa1, 0xe7, 0x92, 0xa3,
  0xe7, 0x92, 0xa6, 0xe7, 0x92, 0xa8, 0xe7, 0x92, 0xa9, 0xe7, 0x92, 0xaa,
  0xe7, 0x92, 0xab, 0xe7, 0x92, 0xae, 0xe7, 0x92, 0xaf, 0xe7, 0x92, 0xb1,
  0xe7, 0x92, 0xb2, 0xe7, 0x92, 0xb5, 0xe7, 0x92, 0xb9, 0xe7, 0x92, 0xbb,
  0xe7, 0x92, 0xbf, 0xe7, 0x93, 0x88, 0xe7, 0x93, 0x89, 0xe7, 0x93, 0x8c,
  0xe7, 0x93, 0x90, 0xe7, 0x93, 0x93, 0xe7, 0x93, 0x98, 0xe7, 0x93, 0x9a,
  0xe7, 0x93, 0x9b, 0xe7, 0x93, 0x9e, 0xe7, 0x93, 0x9f, 0xe7, 0x93, 0xa4,
  0xe7, 0x93, 0xa8, 0xe7, 0x93, 0xaa, 0xe7, 0x93, 0xab, 0xe7, 0x93, 0xaf,
  0xe7, 0x93, 0xb4, 0xe7, 0x93, 0xba, 0xe7, 0x93, 0xbb, 0xe7, 0x93, 0xbc,
  0xe7, 0x93, 0xbf, 0xe7, 0x94, 0x86
};

unsigned char jis_x0212_row_45_converted_to_utf8[] = {
  0xe7, 0x94, 0x92, 0xe7, 0x94, 0x96, 0xe7, 0x94, 0x97, 0xe7, 0x94, 0xa0,
  0xe7, 0x94, 0xa1, 0xe7, 0x94, 0xa4, 0xe7, 0x94, 0xa7, 0xe7, 0x94, 0xa9,
  0xe7, 0x94, 0xaa, 0xe7, 0x94, 0xaf, 0xe7, 0x94, 0xb6, 0xe7, 0x94, 0xb9,
  0xe7, 0x94, 0xbd, 0xe7, 0x94, 0xbe, 0xe7, 0x94, 0xbf, 0xe7, 0x95, 0x80,
  0xe7, 0x95, 0x83, 0xe7, 0x95, 0x87, 0xe7, 0x95, 0x88, 0xe7, 0x95, 0x8e,
  0xe7, 0x95, 0x90, 0xe7, 0x95, 0x92, 0xe7, 0x95, 0x97, 0xe7, 0x95, 0x9e,
  0xe7, 0x95, 0x9f, 0xe7, 0x95, 0xa1, 0xe7, 0x95, 0xaf, 0xe7, 0x95, 0xb1,
  0xe7, 0x95, 0xb9, 0xe7, 0x95, 0xba, 0xe7, 0x95, 0xbb, 0xe7, 0x95, 0xbc,
  0xe7, 0x95, 0xbd, 0xe7, 0x95, 0xbe, 0xe7, 0x96, 0x81, 0xe7, 0x96, 0x85,
  0xe7, 0x96, 0x90, 0xe7, 0x96, 0x92, 0xe7, 0x96, 0x93, 0xe7, 0x96, 0x95,
  0xe7, 0x96, 0x99, 0xe7, 0x96, 0x9c, 0xe7, 0x96, 0xa2, 0xe7, 0x96, 0xa4,
  0xe7, 0x96, 0xb4, 0xe7, 0x96, 0xba, 0xe7, 0x96, 0xbf, 0xe7, 0x97, 0x80,
  0xe7, 0x97, 0x81, 0xe7, 0x97, 0x84, 0xe7, 0x97, 0x86, 0xe7, 0x97, 0x8c,
  0xe7, 0x97, 0x8e, 0xe7, 0x97, 0x8f, 0xe7, 0x97, 0x97, 0xe7, 0x97, 0x9c,
  0xe7, 0x97, 0x9f, 0xe7, 0x97, 0xa0, 0xe7, 0x97, 0xa1, 0xe7, 0x97, 0xa4,
  0xe7, 0x97, 0xa7, 0xe7, 0x97, 0xac, 0xe7, 0x97, 0xae, 0xe7, 0x97, 0xaf,
  0xe7, 0x97, 0xb1, 0xe7, 0x97, 0xb9, 0xe7, 0x98, 0x80, 0xe7, 0x98, 0x82,
  0xe7, 0x98, 0x83, 0xe7, 0x98, 0x84, 0xe7, 0x98, 0x87, 0xe7, 0x98, 0x88,
  0xe7, 0x98, 0x8a, 0xe7, 0x98, 0x8c, 0xe7, 0x98, 0x8f, 0xe7, 0x98, 0x92,
  0xe7, 0x98, 0x93, 0xe7, 0x98, 0x95, 0xe7, 0x98, 0x96, 0xe7, 0x98, 0x99,
  0xe7, 0x98, 0x9b, 0xe7, 0x98, 0x9c, 0xe7, 0x98, 0x9d, 0xe7, 0x98, 0x9e,
  0xe7, 0x98, 0xa3, 0xe7, 0x98, 0xa5, 0xe7, 0x98, 0xa6, 0xe7, 0x98, 0xa9,
  0xe7, 0x98, 0xad, 0xe7, 0x98, 0xb2, 0xe7, 0x98, 0xb3, 0xe7, 0x98, 0xb5,
  0xe7, 0x98, 0xb8, 0xe7, 0x98, 0xb9
};

unsigned char jis_x0212_row_46_converted_to_utf8[] = {
  0xe7, 0x98, 0xba, 0xe7, 0x98, 0xbc, 0xe7, 0x99, 0x8a, 0xe7, 0x99, 0x80,
  0xe7, 0x99, 0x81, 0xe7, 0x99, 0x83, 0xe7, 0x99, 0x84, 0xe7, 0x99, 0x85,
  0xe7, 0x99, 0x89, 0xe7, 0x99, 0x8b, 0xe7, 0x99, 0x95, 0xe7, 0x99, 0x99,
  0xe7, 0x99, 0x9f, 0xe7, 0x99, 0xa4, 0xe7, 0x99, 0xa5, 0xe7, 0x99, 0xad,
  0xe7, 0x99, 0xae, 0xe7, 0x99, 0xaf, 0xe7, 0x99, 0xb1, 0xe7, 0x99, 0xb4,
  0xe7, 0x9a, 0x81, 0xe7, 0x9a, 0x85, 0xe7, 0x9a, 0x8c, 0xe7, 0x9a, 0x8d,
  0xe7, 0x9a, 0x95, 0xe7, 0x9a, 0x9b, 0xe7, 0x9a, 0x9c, 0xe7, 0x9a, 0x9d,
  0xe7, 0x9a, 0x9f, 0xe7, 0x9a, 0xa0, 0xe7, 0x9a, 0xa2, 0xe7, 0x9a, 0xa3,
  0xe7, 0x9a, 0xa4, 0xe7, 0x9a, 0xa5, 0xe7, 0x9a, 0xa6, 0xe7, 0x9a, 0xa7,
  0xe7, 0x9a, 0xa8, 0xe7, 0x9a, 0xaa, 0xe7, 0x9a, 0xad, 0xe7, 0x9a, 0xbd,
  0xe7, 0x9b, 0x81, 0xe7, 0x9b, 0x85, 0xe7, 0x9b, 0x89, 0xe7, 0x9b, 0x8b,
  0xe7, 0x9b, 0x8c, 0xe7, 0x9b, 0x8e, 0xe7, 0x9b, 0x94, 0xe7, 0x9b, 0x99,
  0xe7, 0x9b, 0xa0, 0xe7, 0x9b, 0xa6, 0xe7, 0x9b, 0xa8, 0xe7, 0x9b, 0xac,
  0xe7, 0x9b, 0xb0, 0xe7, 0x9b, 0xb1, 0xe7, 0x9b, 0xb6, 0xe7, 0x9b, 0xb9,
  0xe7, 0x9b, 0xbc, 0xe7, 0x9c, 0x80, 0xe7, 0x9c, 0x86, 0xe7, 0x9c, 0x8a,
  0xe7, 0x9c, 0x8e, 0xe7, 0x9c, 0x92, 0xe7, 0x9c, 0x94, 0xe7, 0x9c, 0x95,
  0xe7, 0x9c, 0x97, 0xe7, 0x9c, 0x99, 0xe7, 0x9c, 0x9a, 0xe7, 0x9c, 0x9c,
  0xe7, 0x9c, 0xa2, 0xe7, 0x9c, 0xa8, 0xe7, 0x9c, 0xad, 0xe7, 0x9c, 0xae,
  0xe7, 0x9c, 0xaf, 0xe7, 0x9c, 0xb4, 0xe7, 0x9c, 0xb5, 0xe7, 0x9c, 0xb6,
  0xe7, 0x9c, 0xb9, 0xe7, 0x9c, 0xbd, 0xe7, 0x9c, 0xbe, 0xe7, 0x9d, 0x82,
  0xe7, 0x9d, 0x85, 0xe7, 0x9d, 0x86, 0xe7, 0x9d, 0x8a, 0xe7, 0x9d, 0x8d,
  0xe7, 0x9d, 0x8e, 0xe7, 0x9d, 0x8f, 0xe7, 0x9d, 0x92, 0xe7, 0x9d, 0x96,
  0xe7, 0x9d, 0x97, 0xe7, 0x9d, 0x9c, 0xe7, 0x9d, 0x9e, 0xe7, 0x9d, 0x9f,
  0xe7, 0x9d, 0xa0, 0xe7, 0x9d, 0xa2
};

unsigned char jis_x0212_row_47_converted_to_utf8[] = {
  0xe7, 0x9d, 0xa4, 0xe7, 0x9d, 0xa7, 0xe7, 0x9d, 0xaa, 0xe7, 0x9d, 0xac,
  0xe7, 0x9d, 0xb0, 0xe7, 0x9d, 0xb2, 0xe7, 0x9d, 0xb3, 0xe7, 0x9d, 0xb4,
  0xe7, 0x9d, 0xba, 0xe7, 0x9d, 0xbd, 0xe7, 0x9e, 0x80, 0xe7, 0x9e, 0x84,
  0xe7, 0x9e, 0x8c, 0xe7, 0x9e, 0x8d, 0xe7, 0x9e, 0x94, 0xe7, 0x9e, 0x95,
  0xe7, 0x9e, 0x96, 0xe7, 0x9e, 0x9a, 0xe7, 0x9e, 0x9f, 0xe7, 0x9e, 0xa2,
  0xe7, 0x9e, 0xa7, 0xe7, 0x9e, 0xaa, 0xe7, 0x9e, 0xae, 0xe7, 0x9e, 0xaf,
  0xe7, 0x9e, 0xb1, 0xe7, 0x9e, 0xb5, 0xe7, 0x9e, 0xbe, 0xe7, 0x9f, 0x83,
  0xe7, 0x9f, 0x89, 0xe7, 0x9f, 0x91, 0xe7, 0x9f, 0x92, 0xe7, 0x9f, 0x95,
  0xe7, 0x9f, 0x99, 0xe7, 0x9f, 0x9e, 0xe7, 0x9f, 0x9f, 0xe7, 0x9f, 0xa0,
  0xe7, 0x9f, 0xa4, 0xe7, 0x9f, 0xa6, 0xe7, 0x9f, 0xaa, 0xe7, 0x9f, 0xac,
  0xe7, 0x9f, 0xb0, 0xe7, 0x9f, 0xb1, 0xe7, 0x9f, 0xb4, 0xe7, 0x9f, 0xb8,
  0xe7, 0x9f, 0xbb, 0xe7, 0xa0, 0x85, 0xe7, 0xa0, 0x86, 0xe7, 0xa0, 0x89,
  0xe7, 0xa0, 0x8d, 0xe7, 0xa0, 0x8e, 0xe7, 0xa0, 0x91, 0xe7, 0xa0, 0x9d,
  0xe7, 0xa0, 0xa1, 0xe7, 0xa0, 0xa2, 0xe7, 0xa0, 0xa3, 0xe7, 0xa0, 0xad,
  0xe7, 0xa0, 0xae, 0xe7, 0xa0, 0xb0, 0xe7, 0xa0, 0xb5, 0xe7, 0xa0, 0xb7,
  0xe7, 0xa1, 0x83, 0xe7, 0xa1, 0x84, 0xe7, 0xa1, 0x87, 0xe7, 0xa1, 0x88,
  0xe7, 0xa1, 0x8c, 0xe7, 0xa1, 0x8e, 0xe7, 0xa1, 0x92, 0xe7, 0xa1, 0x9c,
  0xe7, 0xa1, 0x9e, 0xe7, 0xa1, 0xa0, 0xe7, 0xa1, 0xa1, 0xe7, 0xa1, 0xa3,
  0xe7, 0xa1, 0xa4, 0xe7, 0xa1, 0xa8, 0xe7, 0xa1, 0xaa, 0xe7, 0xa1, 0xae,
  0xe7, 0xa1, 0xba, 0xe7, 0xa1, 0xbe, 0xe7, 0xa2, 0x8a, 0xe7, 0xa2, 0x8f,
  0xe7, 0xa2, 0x94, 0xe7, 0xa2, 0x98, 0xe7, 0xa2, 0xa1, 0xe7, 0xa2, 0x9d,
  0xe7, 0xa2, 0x9e, 0xe7, 0xa2, 0x9f, 0xe7, 0xa2, 0xa4, 0xe7, 0xa2, 0xa8,
  0xe7, 0xa2, 0xac, 0xe7, 0xa2, 0xad, 0xe7, 0xa2, 0xb0, 0xe7, 0xa2, 0xb1,
  0xe7, 0xa2, 0xb2, 0xe7, 0xa2, 0xb3
};

unsigned char jis_x0212_row_48_converted_to_utf8[] = {
  0xe7, 0xa2, 0xbb, 0xe7, 0xa2, 0xbd, 0xe7, 0xa2, 0xbf, 0xe7, 0xa3, 0x87,
  0xe7, 0xa3, 0x88, 0xe7, 0xa3, 0x89, 0xe7, 0xa3, 0x8c, 0xe7, 0xa3, 0x8e,
  0xe7, 0xa3, 0x92, 0xe7, 0xa3, 0x93, 0xe7, 0xa3, 0x95, 0xe7, 0xa3, 0x96,
  0xe7, 0xa3, 0xa4, 0xe7, 0xa3, 0x9b, 0xe7, 0xa3, 0x9f, 0xe7, 0xa3, 0xa0,
  0xe7, 0xa3, 0xa1, 0xe7, 0xa3, 0xa6, 0xe7, 0xa3, 0xaa, 0xe7, 0xa3, 0xb2,
  0xe7, 0xa3, 0xb3, 0xe7, 0xa4, 0x80, 0xe7, 0xa3, 0xb6, 0xe7, 0xa3, 0xb7,
  0xe7, 0xa3, 0xba, 0xe7, 0xa3, 0xbb, 0xe7, 0xa3, 0xbf, 0xe7, 0xa4, 0x86,
  0xe7, 0xa4, 0x8c, 0xe7, 0xa4, 0x90, 0xe7, 0xa4, 0x9a, 0xe7, 0xa4, 0x9c,
  0xe7, 0xa4, 0x9e, 0xe7, 0xa4, 0x9f, 0xe7, 0xa4, 0xa0, 0xe7, 0xa4, 0xa5,
  0xe7, 0xa4, 0xa7, 0xe7, 0xa4, 0xa9, 0xe7, 0xa4, 0xad, 0xe7, 0xa4, 0xb1,
  0xe7, 0xa4, 0xb4, 0xe7, 0xa4, 0xb5, 0xe7, 0xa4, 0xbb, 0xe7, 0xa4, 0xbd,
  0xe7, 0xa4, 0xbf, 0xe7, 0xa5, 0x84, 0xe7, 0xa5, 0x85, 0xe7, 0xa5, 0x86,
  0xe7, 0xa5, 0x8a, 0xe7, 0xa5, 0x8b, 0xe7, 0xa5, 0x8f, 0xe7, 0xa5, 0x91,
  0xe7, 0xa5, 0x94, 0xe7, 0xa5, 0x98, 0xe7, 0xa5, 0x9b, 0xe7, 0xa5, 0x9c,
  0xe7, 0xa5, 0xa7, 0xe7, 0xa5, 0xa9, 0xe7, 0xa5, 0xab, 0xe7, 0xa5, 0xb2,
  0xe7, 0xa5, 0xb9, 0xe7, 0xa5, 0xbb, 0xe7, 0xa5, 0xbc, 0xe7, 0xa5, 0xbe,
  0xe7, 0xa6, 0x8b, 0xe7, 0xa6, 0x8c, 0xe7, 0xa6, 0x91, 0xe7, 0xa6, 0x93,
  0xe7, 0xa6, 0x94, 0xe7, 0xa6, 0x95, 0xe7, 0xa6, 0x96, 0xe7, 0xa6, 0x98,
  0xe7, 0xa6, 0x9b, 0xe7, 0xa6, 0x9c, 0xe7, 0xa6, 0xa1, 0xe7, 0xa6, 0xa8,
  0xe7, 0xa6, 0xa9, 0xe7, 0xa6, 0xab, 0xe7, 0xa6, 0xaf, 0xe7, 0xa6, 0xb1,
  0xe7, 0xa6, 0xb4, 0xe7, 0xa6, 0xb8, 0xe7, 0xa6, 0xbb, 0xe7, 0xa7, 0x82,
  0xe7, 0xa7, 0x84, 0xe7, 0xa7, 0x87, 0xe7, 0xa7, 0x88, 0xe7, 0xa7, 0x8a,
  0xe7, 0xa7, 0x8f, 0xe7, 0xa7, 0x94, 0xe7, 0xa7, 0x96, 0xe7, 0xa7, 0x9a,
  0xe7, 0xa7, 0x9d, 0xe7, 0xa7, 0x9e
};

unsigned char jis_x0212_row_49_converted_to_utf8[] = {
  0xe7, 0xa7, 0xa0, 0xe7, 0xa7, 0xa2, 0xe7, 0xa7, 0xa5, 0xe7, 0xa7, 0xaa,
  0xe7, 0xa7, 0xab, 0xe7, 0xa7, 0xad, 0xe7, 0xa7, 0xb1, 0xe7, 0xa7, 0xb8,
  0xe7, 0xa7, 0xbc, 0xe7, 0xa8, 0x82, 0xe7, 0xa8, 0x83, 0xe7, 0xa8, 0x87,
  0xe7, 0xa8, 0x89, 0xe7, 0xa8, 0x8a, 0xe7, 0xa8, 0x8c, 0xe7, 0xa8, 0x91,
  0xe7, 0xa8, 0x95, 0xe7, 0xa8, 0x9b, 0xe7, 0xa8, 0x9e, 0xe7, 0xa8, 0xa1,
  0xe7, 0xa8, 0xa7, 0xe7, 0xa8, 0xab, 0xe7, 0xa8, 0xad, 0xe7, 0xa8, 0xaf,
  0xe7, 0xa8, 0xb0, 0xe7, 0xa8, 0xb4, 0xe7, 0xa8, 0xb5, 0xe7, 0xa8, 0xb8,
  0xe7, 0xa8, 0xb9, 0xe7, 0xa8, 0xba, 0xe7, 0xa9, 0x84, 0xe7, 0xa9, 0x85,
  0xe7, 0xa9, 0x87, 0xe7, 0xa9, 0x88, 0xe7, 0xa9, 0x8c, 0xe7, 0xa9, 0x95,
  0xe7, 0xa9, 0x96, 0xe7, 0xa9, 0x99, 0xe7, 0xa9, 0x9c, 0xe7, 0xa9, 0x9d,
  0xe7, 0xa9, 0x9f, 0xe7, 0xa9, 0xa0, 0xe7, 0xa9, 0xa5, 0xe7, 0xa9, 0xa7,
  0xe7, 0xa9, 0xaa, 0xe7, 0xa9, 0xad, 0xe7, 0xa9, 0xb5, 0xe7, 0xa9, 0xb8,
  0xe7, 0xa9, 0xbe, 0xe7, 0xaa, 0x80, 0xe7, 0xaa, 0x82, 0xe7, 0xaa, 0x85,
  0xe7, 0xaa, 0x86, 0xe7, 0xaa, 0x8a, 0xe7, 0xaa, 0x8b, 0xe7, 0xaa, 0x90,
  0xe7, 0xaa, 0x91, 0xe7, 0xaa, 0x94, 0xe7, 0xaa, 0x9e, 0xe7, 0xaa, 0xa0,
  0xe7, 0xaa, 0xa3, 0xe7, 0xaa, 0xac, 0xe7, 0xaa, 0xb3, 0xe7, 0xaa, 0xb5,
  0xe7, 0xaa, 0xb9, 0xe7, 0xaa, 0xbb, 0xe7, 0xaa, 0xbc, 0xe7, 0xab, 0x86,
  0xe7, 0xab, 0x89, 0xe7, 0xab, 0x8c, 0xe7, 0xab, 0x8e, 0xe7, 0xab, 0x91,
  0xe7, 0xab, 0x9b, 0xe7, 0xab, 0xa8, 0xe7, 0xab, 0xa9, 0xe7, 0xab, 0xab,
  0xe7, 0xab, 0xac, 0xe7, 0xab, 0xb1, 0xe7, 0xab, 0xb4, 0xe7, 0xab, 0xbb,
  0xe7, 0xab, 0xbd, 0xe7, 0xab, 0xbe, 0xe7, 0xac, 0x87, 0xe7, 0xac, 0x94,
  0xe7, 0xac, 0x9f, 0xe7, 0xac, 0xa3, 0xe7, 0xac, 0xa7, 0xe7, 0xac, 0xa9,
  0xe7, 0xac, 0xaa, 0xe7, 0xac, 0xab, 0xe7, 0xac, 0xad, 0xe7, 0xac, 0xae,
  0xe7, 0xac, 0xaf, 0xe7, 0xac, 0xb0
};

unsigned char jis_x0212_row_50_converted_to_utf8[] = {
  0xe7, 0xac, 0xb1, 0xe7, 0xac, 0xb4, 0xe7, 0xac, 0xbd, 0xe7, 0xac, 0xbf,
  0xe7, 0xad, 0x80, 0xe7, 0xad, 0x81, 0xe7, 0xad, 0x87, 0xe7, 0xad, 0x8e,
  0xe7, 0xad, 0x95, 0xe7, 0xad, 0xa0, 0xe7, 0xad, 0xa4, 0xe7, 0xad, 0xa6,
  0xe7, 0xad, 0xa9, 0xe7, 0xad, 0xaa, 0xe7, 0xad, 0xad, 0xe7, 0xad, 0xaf,
  0xe7, 0xad, 0xb2, 0xe7, 0xad, 0xb3, 0xe7, 0xad, 0xb7, 0xe7, 0xae, 0x84,
  0xe7, 0xae, 0x89, 0xe7, 0xae, 0x8e, 0xe7, 0xae, 0x90, 0xe7, 0xae, 0x91,
  0xe7, 0xae, 0x96, 0xe7, 0xae, 0x9b, 0xe7, 0xae, 0x9e, 0xe7, 0xae, 0xa0,
  0xe7, 0xae, 0xa5, 0xe7, 0xae, 0xac, 0xe7, 0xae, 0xaf, 0xe7, 0xae, 0xb0,
  0xe7, 0xae, 0xb2, 0xe7, 0xae, 0xb5, 0xe7, 0xae, 0xb6, 0xe7, 0xae, 0xba,
  0xe7, 0xae, 0xbb, 0xe7, 0xae, 0xbc, 0xe7, 0xae, 0xbd, 0xe7, 0xaf, 0x82,
  0xe7, 0xaf, 0x85, 0xe7, 0xaf, 0x88, 0xe7, 0xaf, 0x8a, 0xe7, 0xaf, 0x94,
  0xe7, 0xaf, 0x96, 0xe7, 0xaf, 0x97, 0xe7, 0xaf, 0x99, 0xe7, 0xaf, 0x9a,
  0xe7, 0xaf, 0x9b, 0xe7, 0xaf, 0xa8, 0xe7, 0xaf, 0xaa, 0xe7, 0xaf, 0xb2,
  0xe7, 0xaf, 0xb4, 0xe7, 0xaf, 0xb5, 0xe7, 0xaf, 0xb8, 0xe7, 0xaf, 0xb9,
  0xe7, 0xaf, 0xba, 0xe7, 0xaf, 0xbc, 0xe7, 0xaf, 0xbe, 0xe7, 0xb0, 0x81,
  0xe7, 0xb0, 0x82, 0xe7, 0xb0, 0x83, 0xe7, 0xb0, 0x84, 0xe7, 0xb0, 0x86,
  0xe7, 0xb0, 0x89, 0xe7, 0xb0, 0x8b, 0xe7, 0xb0, 0x8c, 0xe7, 0xb0, 0x8e,
  0xe7, 0xb0, 0x8f, 0xe7, 0xb0, 0x99, 0xe7, 0xb0, 0x9b, 0xe7, 0xb0, 0xa0,
  0xe7, 0xb0, 0xa5, 0xe7, 0xb0, 0xa6, 0xe7, 0xb0, 0xa8, 0xe7, 0xb0, 0xac,
  0xe7, 0xb0, 0xb1, 0xe7, 0xb0, 0xb3, 0xe7, 0xb0, 0xb4, 0xe7, 0xb0, 0xb6,
  0xe7, 0xb0, 0xb9, 0xe7, 0xb0, 0xba, 0xe7, 0xb1, 0x86, 0xe7, 0xb1, 0x8a,
  0xe7, 0xb1, 0x95, 0xe7, 0xb1, 0x91, 0xe7, 0xb1, 0x92, 0xe7, 0xb1, 0x93,
  0xe7, 0xb1, 0x99, 0xe7, 0xb1, 0x9a, 0xe7, 0xb1, 0x9b, 0xe7, 0xb1, 0x9c,
  0xe7, 0xb1, 0x9d, 0xe7, 0xb1, 0x9e
};

unsigned char jis_x0212_row_51_converted_to_utf8[] = {
  0xe7, 0xb1, 0xa1, 0xe7, 0xb1, 0xa3, 0xe7, 0xb1, 0xa7, 0xe7, 0xb1, 0xa9,
  0xe7, 0xb1, 0xad, 0xe7, 0xb1, 0xae, 0xe7, 0xb1, 0xb0, 0xe7, 0xb1, 0xb2,
  0xe7, 0xb1, 0xb9, 0xe7, 0xb1, 0xbc, 0xe7, 0xb1, 0xbd, 0xe7, 0xb2, 0x86,
  0xe7, 0xb2, 0x87, 0xe7, 0xb2, 0x8f, 0xe7, 0xb2, 0x94, 0xe7, 0xb2, 0x9e,
  0xe7, 0xb2, 0xa0, 0xe7, 0xb2, 0xa6, 0xe7, 0xb2, 0xb0, 0xe7, 0xb2, 0xb6,
  0xe7, 0xb2, 0xb7, 0xe7, 0xb2, 0xba, 0xe7, 0xb2, 0xbb, 0xe7, 0xb2, 0xbc,
  0xe7, 0xb2, 0xbf, 0xe7, 0xb3, 0x84, 0xe7, 0xb3, 0x87, 0xe7, 0xb3, 0x88,
  0xe7, 0xb3, 0x89, 0xe7, 0xb3, 0x8d, 0xe7, 0xb3, 0x8f, 0xe7, 0xb3, 0x93,
  0xe7, 0xb3, 0x94, 0xe7, 0xb3, 0x95, 0xe7, 0xb3, 0x97, 0xe7, 0xb3, 0x99,
  0xe7, 0xb3, 0x9a, 0xe7, 0xb3, 0x9d, 0xe7, 0xb3, 0xa6, 0xe7, 0xb3, 0xa9,
  0xe7, 0xb3, 0xab, 0xe7, 0xb3, 0xb5, 0xe7, 0xb4, 0x83, 0xe7, 0xb4, 0x87,
  0xe7, 0xb4, 0x88, 0xe7, 0xb4, 0x89, 0xe7, 0xb4, 0x8f, 0xe7, 0xb4, 0x91,
  0xe7, 0xb4, 0x92, 0xe7, 0xb4, 0x93, 0xe7, 0xb4, 0x96, 0xe7, 0xb4, 0x9d,
  0xe7, 0xb4, 0x9e, 0xe7, 0xb4, 0xa3, 0xe7, 0xb4, 0xa6, 0xe7, 0xb4, 0xaa,
  0xe7, 0xb4, 0xad, 0xe7, 0xb4, 0xb1, 0xe7, 0xb4, 0xbc, 0xe7, 0xb4, 0xbd,
  0xe7, 0xb4, 0xbe, 0xe7, 0xb5, 0x80, 0xe7, 0xb5, 0x81, 0xe7, 0xb5, 0x87,
  0xe7, 0xb5, 0x88, 0xe7, 0xb5, 0x8d, 0xe7, 0xb5, 0x91, 0xe7, 0xb5, 0x93,
  0xe7, 0xb5, 0x97, 0xe7, 0xb5, 0x99, 0xe7, 0xb5, 0x9a, 0xe7, 0xb5, 0x9c,
  0xe7, 0xb5, 0x9d, 0xe7, 0xb5, 0xa5, 0xe7, 0xb5, 0xa7, 0xe7, 0xb5, 0xaa,
  0xe7, 0xb5, 0xb0, 0xe7, 0xb5, 0xb8, 0xe7, 0xb5, 0xba, 0xe7, 0xb5, 0xbb,
  0xe7, 0xb5, 0xbf, 0xe7, 0xb6, 0x81, 0xe7, 0xb6, 0x82, 0xe7, 0xb6, 0x83,
  0xe7, 0xb6, 0x85, 0xe7, 0xb6, 0x86, 0xe7, 0xb6, 0x88, 0xe7, 0xb6, 0x8b,
  0xe7, 0xb6, 0x8c, 0xe7, 0xb6, 0x8d, 0xe7, 0xb6, 0x91, 0xe7, 0xb6, 0x96,
  0xe7, 0xb6, 0x97, 0xe7, 0xb6, 0x9d
};

unsigned char jis_x0212_row_52_converted_to_utf8[] = {
  0xe7, 0xb6, 0x9e, 0xe7, 0xb6, 0xa6, 0xe7, 0xb6, 0xa7, 0xe7, 0xb6, 0xaa,
  0xe7, 0xb6, 0xb3, 0xe7, 0xb6, 0xb6, 0xe7, 0xb6, 0xb7, 0xe7, 0xb6, 0xb9,
  0xe7, 0xb7, 0x82, 0xe7, 0xb7, 0x83, 0xe7, 0xb7, 0x84, 0xe7, 0xb7, 0x85,
  0xe7, 0xb7, 0x86, 0xe7, 0xb7, 0x8c, 0xe7, 0xb7, 0x8d, 0xe7, 0xb7, 0x8e,
  0xe7, 0xb7, 0x97, 0xe7, 0xb7, 0x99, 0xe7, 0xb8, 0x80, 0xe7, 0xb7, 0xa2,
  0xe7, 0xb7, 0xa5, 0xe7, 0xb7, 0xa6, 0xe7, 0xb7, 0xaa, 0xe7, 0xb7, 0xab,
  0xe7, 0xb7, 0xad, 0xe7, 0xb7, 0xb1, 0xe7, 0xb7, 0xb5, 0xe7, 0xb7, 0xb6,
  0xe7, 0xb7, 0xb9, 0xe7, 0xb7, 0xba, 0xe7, 0xb8, 0x88, 0xe7, 0xb8, 0x90,
  0xe7, 0xb8, 0x91, 0xe7, 0xb8, 0x95, 0xe7, 0xb8, 0x97, 0xe7, 0xb8, 0x9c,
  0xe7, 0xb8, 0x9d, 0xe7, 0xb8, 0xa0, 0xe7, 0xb8, 0xa7, 0xe7, 0xb8, 0xa8,
  0xe7, 0xb8, 0xac, 0xe7, 0xb8, 0xad, 0xe7, 0xb8, 0xaf, 0xe7, 0xb8, 0xb3,
  0xe7, 0xb8, 0xb6, 0xe7, 0xb8, 0xbf, 0xe7, 0xb9, 0x84, 0xe7, 0xb9, 0x85,
  0xe7, 0xb9, 0x87, 0xe7, 0xb9, 0x8e, 0xe7, 0xb9, 0x90, 0xe7, 0xb9, 0x92,
  0xe7, 0xb9, 0x98, 0xe7, 0xb9, 0x9f, 0xe7, 0xb9, 0xa1, 0xe7, 0xb9, 0xa2,
  0xe7, 0xb9, 0xa5, 0xe7, 0xb9, 0xab, 0xe7, 0xb9, 0xae, 0xe7, 0xb9, 0xaf,
  0xe7, 0xb9, 0xb3, 0xe7, 0xb9, 0xb8, 0xe7, 0xb9, 0xbe, 0xe7, 0xba, 0x81,
  0xe7, 0xba, 0x86, 0xe7, 0xba, 0x87, 0xe7, 0xba, 0x8a, 0xe7, 0xba, 0x8d,
  0xe7, 0xba, 0x91, 0xe7, 0xba, 0x95, 0xe7, 0xba, 0x98, 0xe7, 0xba, 0x9a,
  0xe7, 0xba, 0x9d, 0xe7, 0xba, 0x9e, 0xe7, 0xbc, 0xbc, 0xe7, 0xbc, 0xbb,
  0xe7, 0xbc, 0xbd, 0xe7, 0xbc, 0xbe, 0xe7, 0xbc, 0xbf, 0xe7, 0xbd, 0x83,
  0xe7, 0xbd, 0x84, 0xe7, 0xbd, 0x87, 0xe7, 0xbd, 0x8f, 0xe7, 0xbd, 0x92,
  0xe7, 0xbd, 0x93, 0xe7, 0xbd, 0x9b, 0xe7, 0xbd, 0x9c, 0xe7, 0xbd, 0x9d,
  0xe7, 0xbd, 0xa1, 0xe7, 0xbd, 0xa3, 0xe7, 0xbd, 0xa4, 0xe7, 0xbd, 0xa5,
  0xe7, 0xbd, 0xa6, 0xe7, 0xbd, 0xad
};

unsigned char jis_x0212_row_53_converted_to_utf8[] = {
  0xe7, 0xbd, 0xb1, 0xe7, 0xbd, 0xbd, 0xe7, 0xbd, 0xbe, 0xe7, 0xbd, 0xbf,
  0xe7, 0xbe, 0x80, 0xe7, 0xbe, 0x8b, 0xe7, 0xbe, 0x8d, 0xe7, 0xbe, 0x8f,
  0xe7, 0xbe, 0x90, 0xe7, 0xbe, 0x91, 0xe7, 0xbe, 0x96, 0xe7, 0xbe, 0x97,
  0xe7, 0xbe, 0x9c, 0xe7, 0xbe, 0xa1, 0xe7, 0xbe, 0xa2, 0xe7, 0xbe, 0xa6,
  0xe7, 0xbe, 0xaa, 0xe7, 0xbe, 0xad, 0xe7, 0xbe, 0xb4, 0xe7, 0xbe, 0xbc,
  0xe7, 0xbe, 0xbf, 0xe7, 0xbf, 0x80, 0xe7, 0xbf, 0x83, 0xe7, 0xbf, 0x88,
  0xe7, 0xbf, 0x8e, 0xe7, 0xbf, 0x8f, 0xe7, 0xbf, 0x9b, 0xe7, 0xbf, 0x9f,
  0xe7, 0xbf, 0xa3, 0xe7, 0xbf, 0xa5, 0xe7, 0xbf, 0xa8, 0xe7, 0xbf, 0xac,
  0xe7, 0xbf, 0xae, 0xe7, 0xbf, 0xaf, 0xe7, 0xbf, 0xb2, 0xe7, 0xbf, 0xba,
  0xe7, 0xbf, 0xbd, 0xe7, 0xbf, 0xbe, 0xe7, 0xbf, 0xbf, 0xe8, 0x80, 0x87,
  0xe8, 0x80, 0x88, 0xe8, 0x80, 0x8a, 0xe8, 0x80, 0x8d, 0xe8, 0x80, 0x8e,
  0xe8, 0x80, 0x8f, 0xe8, 0x80, 0x91, 0xe8, 0x80, 0x93, 0xe8, 0x80, 0x94,
  0xe8, 0x80, 0x96, 0xe8, 0x80, 0x9d, 0xe8, 0x80, 0x9e, 0xe8, 0x80, 0x9f,
  0xe8, 0x80, 0xa0, 0xe8, 0x80, 0xa4, 0xe8, 0x80, 0xa6, 0xe8, 0x80, 0xac,
  0xe8, 0x80, 0xae, 0xe8, 0x80, 0xb0, 0xe8, 0x80, 0xb4, 0xe8, 0x80, 0xb5,
  0xe8, 0x80, 0xb7, 0xe8, 0x80, 0xb9, 0xe8, 0x80, 0xba, 0xe8, 0x80, 0xbc,
  0xe8, 0x80, 0xbe, 0xe8, 0x81, 0x80, 0xe8, 0x81, 0x84, 0xe8, 0x81, 0xa0,
  0xe8, 0x81, 0xa4, 0xe8, 0x81, 0xa6, 0xe8, 0x81, 0xad, 0xe8, 0x81, 0xb1,
  0xe8, 0x81, 0xb5, 0xe8, 0x82, 0x81, 0xe8, 0x82, 0x88, 0xe8, 0x82, 0x8e,
  0xe8, 0x82, 0x9c, 0xe8, 0x82, 0x9e, 0xe8, 0x82, 0xa6, 0xe8, 0x82, 0xa7,
  0xe8, 0x82, 0xab, 0xe8, 0x82, 0xb8, 0xe8, 0x82, 0xb9, 0xe8, 0x83, 0x88,
  0xe8, 0x83, 0x8d, 0xe8, 0x83, 0x8f, 0xe8, 0x83, 0x92, 0xe8, 0x83, 0x94,
  0xe8, 0x83, 0x95, 0xe8, 0x83, 0x97, 0xe8, 0x83, 0x98, 0xe8, 0x83, 0xa0,
  0xe8, 0x83, 0xad, 0xe8, 0x83, 0xae
};

unsigned char jis_x0212_row_54_converted_to_utf8[] = {
  0xe8, 0x83, 0xb0, 0xe8, 0x83, 0xb2, 0xe8, 0x83, 0xb3, 0xe8, 0x83, 0xb6,
  0xe8, 0x83, 0xb9, 0xe8, 0x83, 0xba, 0xe8, 0x83, 0xbe, 0xe8, 0x84, 0x83,
  0xe8, 0x84, 0x8b, 0xe8, 0x84, 0x96, 0xe8, 0x84, 0x97, 0xe8, 0x84, 0x98,
  0xe8, 0x84, 0x9c, 0xe8, 0x84, 0x9e, 0xe8, 0x84, 0xa0, 0xe8, 0x84, 0xa4,
  0xe8, 0x84, 0xa7, 0xe8, 0x84, 0xac, 0xe8, 0x84, 0xb0, 0xe8, 0x84, 0xb5,
  0xe8, 0x84, 0xba, 0xe8, 0x84, 0xbc, 0xe8, 0x85, 0x85, 0xe8, 0x85, 0x87,
  0xe8, 0x85, 0x8a, 0xe8, 0x85, 0x8c, 0xe8, 0x85, 0x92, 0xe8, 0x85, 0x97,
  0xe8, 0x85, 0xa0, 0xe8, 0x85, 0xa1, 0xe8, 0x85, 0xa7, 0xe8, 0x85, 0xa8,
  0xe8, 0x85, 0xa9, 0xe8, 0x85, 0xad, 0xe8, 0x85, 0xaf, 0xe8, 0x85, 0xb7,
  0xe8, 0x86, 0x81, 0xe8, 0x86, 0x90, 0xe8, 0x86, 0x84, 0xe8, 0x86, 0x85,
  0xe8, 0x86, 0x86, 0xe8, 0x86, 0x8b, 0xe8, 0x86, 0x8e, 0xe8, 0x86, 0x96,
  0xe8, 0x86, 0x98, 0xe8, 0x86, 0x9b, 0xe8, 0x86, 0x9e, 0xe8, 0x86, 0xa2,
  0xe8, 0x86, 0xae, 0xe8, 0x86, 0xb2, 0xe8, 0x86, 0xb4, 0xe8, 0x86, 0xbb,
  0xe8, 0x87, 0x8b, 0xe8, 0x87, 0x83, 0xe8, 0x87, 0x85, 0xe8, 0x87, 0x8a,
  0xe8, 0x87, 0x8e, 0xe8, 0x87, 0x8f, 0xe8, 0x87, 0x95, 0xe8, 0x87, 0x97,
  0xe8, 0x87, 0x9b, 0xe8, 0x87, 0x9d, 0xe8, 0x87, 0x9e, 0xe8, 0x87, 0xa1,
  0xe8, 0x87, 0xa4, 0xe8, 0x87, 0xab, 0xe8, 0x87, 0xac, 0xe8, 0x87, 0xb0,
  0xe8, 0x87, 0xb1, 0xe8, 0x87, 0xb2, 0xe8, 0x87, 0xb5, 0xe8, 0x87, 0xb6,
  0xe8, 0x87, 0xb8, 0xe8, 0x87, 0xb9, 0xe8, 0x87, 0xbd, 0xe8, 0x87, 0xbf,
  0xe8, 0x88, 0x80, 0xe8, 0x88, 0x83, 0xe8, 0x88, 0x8f, 0xe8, 0x88, 0x93,
  0xe8, 0x88, 0x94, 0xe8, 0x88, 0x99, 0xe8, 0x88, 0x9a, 0xe8, 0x88, 0x9d,
  0xe8, 0x88, 0xa1, 0xe8, 0x88, 0xa2, 0xe8, 0x88, 0xa8, 0xe8, 0x88, 0xb2,
  0xe8, 0x88, 0xb4, 0xe8, 0x88, 0xba, 0xe8, 0x89, 0x83, 0xe8, 0x89, 0x84,
  0xe8, 0x89, 0x85, 0xe8, 0x89, 0x86
};

unsigned char jis_x0212_row_55_converted_to_utf8[] = {
  0xe8, 0x89, 0x8b, 0xe8, 0x89, 0x8e, 0xe8, 0x89, 0x8f, 0xe8, 0x89, 0x91,
  0xe8, 0x89, 0x96, 0xe8, 0x89, 0x9c, 0xe8, 0x89, 0xa0, 0xe8, 0x89, 0xa3,
  0xe8, 0x89, 0xa7, 0xe8, 0x89, 0xad, 0xe8, 0x89, 0xb4, 0xe8, 0x89, 0xbb,
  0xe8, 0x89, 0xbd, 0xe8, 0x89, 0xbf, 0xe8, 0x8a, 0x80, 0xe8, 0x8a, 0x81,
  0xe8, 0x8a, 0x83, 0xe8, 0x8a, 0x84, 0xe8, 0x8a, 0x87, 0xe8, 0x8a, 0x89,
  0xe8, 0x8a, 0x8a, 0xe8, 0x8a, 0x8e, 0xe8, 0x8a, 0x91, 0xe8, 0x8a, 0x94,
  0xe8, 0x8a, 0x96, 0xe8, 0x8a, 0x98, 0xe8, 0x8a, 0x9a, 0xe8, 0x8a, 0x9b,
  0xe8, 0x8a, 0xa0, 0xe8, 0x8a, 0xa1, 0xe8, 0x8a, 0xa3, 0xe8, 0x8a, 0xa4,
  0xe8, 0x8a, 0xa7, 0xe8, 0x8a, 0xa8, 0xe8, 0x8a, 0xa9, 0xe8, 0x8a, 0xaa,
  0xe8, 0x8a, 0xae, 0xe8, 0x8a, 0xb0, 0xe8, 0x8a, 0xb2, 0xe8, 0x8a, 0xb4,
  0xe8, 0x8a, 0xb7, 0xe8, 0x8a, 0xba, 0xe8, 0x8a, 0xbc, 0xe8, 0x8a, 0xbe,
  0xe8, 0x8a, 0xbf, 0xe8, 0x8b, 0x86, 0xe8, 0x8b, 0x90, 0xe8, 0x8b, 0x95,
  0xe8, 0x8b, 0x9a, 0xe8, 0x8b, 0xa0, 0xe8, 0x8b, 0xa2, 0xe8, 0x8b, 0xa4,
  0xe8, 0x8b, 0xa8, 0xe8, 0x8b, 0xaa, 0xe8, 0x8b, 0xad, 0xe8, 0x8b, 0xaf,
  0xe8, 0x8b, 0xb6, 0xe8, 0x8b, 0xb7, 0xe8, 0x8b, 0xbd, 0xe8, 0x8b, 0xbe,
  0xe8, 0x8c, 0x80, 0xe8, 0x8c, 0x81, 0xe8, 0x8c, 0x87, 0xe8, 0x8c, 0x88,
  0xe8, 0x8c, 0x8a, 0xe8, 0x8c, 0x8b, 0xe8, 0x8d, 0x94, 0xe8, 0x8c, 0x9b,
  0xe8, 0x8c, 0x9d, 0xe8, 0x8c, 0x9e, 0xe8, 0x8c, 0x9f, 0xe8, 0x8c, 0xa1,
  0xe8, 0x8c, 0xa2, 0xe8, 0x8c, 0xac, 0xe8, 0x8c, 0xad, 0xe8, 0x8c, 0xae,
  0xe8, 0x8c, 0xb0, 0xe8, 0x8c, 0xb3, 0xe8, 0x8c, 0xb7, 0xe8, 0x8c, 0xba,
  0xe8, 0x8c, 0xbc, 0xe8, 0x8c, 0xbd, 0xe8, 0x8d, 0x82, 0xe8, 0x8d, 0x83,
  0xe8, 0x8d, 0x84, 0xe8, 0x8d, 0x87, 0xe8, 0x8d, 0x8d, 0xe8, 0x8d, 0x8e,
  0xe8, 0x8d, 0x91, 0xe8, 0x8d, 0x95, 0xe8, 0x8d, 0x96, 0xe8, 0x8d, 0x97,
  0xe8, 0x8d, 0xb0, 0xe8, 0x8d, 0xb8
};

unsigned char jis_x0212_row_56_converted_to_utf8[] = {
  0xe8, 0x8d, 0xbd, 0xe8, 0x8d, 0xbf, 0xe8, 0x8e, 0x80, 0xe8, 0x8e, 0x82,
  0xe8, 0x8e, 0x84, 0xe8, 0x8e, 0x86, 0xe8, 0x8e, 0x8d, 0xe8, 0x8e, 0x92,
  0xe8, 0x8e, 0x94, 0xe8, 0x8e, 0x95, 0xe8, 0x8e, 0x98, 0xe8, 0x8e, 0x99,
  0xe8, 0x8e, 0x9b, 0xe8, 0x8e, 0x9c, 0xe8, 0x8e, 0x9d, 0xe8, 0x8e, 0xa6,
  0xe8, 0x8e, 0xa7, 0xe8, 0x8e, 0xa9, 0xe8, 0x8e, 0xac, 0xe8, 0x8e, 0xbe,
  0xe8, 0x8e, 0xbf, 0xe8, 0x8f, 0x80, 0xe8, 0x8f, 0x87, 0xe8, 0x8f, 0x89,
  0xe8, 0x8f, 0x8f, 0xe8, 0x8f, 0x90, 0xe8, 0x8f, 0x91, 0xe8, 0x8f, 0x94,
  0xe8, 0x8f, 0x9d, 0xe8, 0x8d, 0x93, 0xe8, 0x8f, 0xa8, 0xe8, 0x8f, 0xaa,
  0xe8, 0x8f, 0xb6, 0xe8, 0x8f, 0xb8, 0xe8, 0x8f, 0xb9, 0xe8, 0x8f, 0xbc,
  0xe8, 0x90, 0x81, 0xe8, 0x90, 0x86, 0xe8, 0x90, 0x8a, 0xe8, 0x90, 0x8f,
  0xe8, 0x90, 0x91, 0xe8, 0x90, 0x95, 0xe8, 0x90, 0x99, 0xe8, 0x8e, 0xad,
  0xe8, 0x90, 0xaf, 0xe8, 0x90, 0xb9, 0xe8, 0x91, 0x85, 0xe8, 0x91, 0x87,
  0xe8, 0x91, 0x88, 0xe8, 0x91, 0x8a, 0xe8, 0x91, 0x8d, 0xe8, 0x91, 0x8f,
  0xe8, 0x91, 0x91, 0xe8, 0x91, 0x92, 0xe8, 0x91, 0x96, 0xe8, 0x91, 0x98,
  0xe8, 0x91, 0x99, 0xe8, 0x91, 0x9a, 0xe8, 0x91, 0x9c, 0xe8, 0x91, 0xa0,
  0xe8, 0x91, 0xa4, 0xe8, 0x91, 0xa5, 0xe8, 0x91, 0xa7, 0xe8, 0x91, 0xaa,
  0xe8, 0x91, 0xb0, 0xe8, 0x91, 0xb3, 0xe8, 0x91, 0xb4, 0xe8, 0x91, 0xb6,
  0xe8, 0x91, 0xb8, 0xe8, 0x91, 0xbc, 0xe8, 0x91, 0xbd, 0xe8, 0x92, 0x81,
  0xe8, 0x92, 0x85, 0xe8, 0x92, 0x92, 0xe8, 0x92, 0x93, 0xe8, 0x92, 0x95,
  0xe8, 0x92, 0x9e, 0xe8, 0x92, 0xa6, 0xe8, 0x92, 0xa8, 0xe8, 0x92, 0xa9,
  0xe8, 0x92, 0xaa, 0xe8, 0x92, 0xaf, 0xe8, 0x92, 0xb1, 0xe8, 0x92, 0xb4,
  0xe8, 0x92, 0xba, 0xe8, 0x92, 0xbd, 0xe8, 0x92, 0xbe, 0xe8, 0x93, 0x80,
  0xe8, 0x93, 0x82, 0xe8, 0x93, 0x87, 0xe8, 0x93, 0x88, 0xe8, 0x93, 0x8c,
  0xe8, 0x93, 0x8f, 0xe8, 0x93, 0x93
};

unsigned char jis_x0212_row_57_converted_to_utf8[] = {
  0xe8, 0x93, 0x9c, 0xe8, 0x93, 0xa7, 0xe8, 0x93, 0xaa, 0xe8, 0x93, 0xaf,
  0xe8, 0x93, 0xb0, 0xe8, 0x93, 0xb1, 0xe8, 0x93, 0xb2, 0xe8, 0x93, 0xb7,
  0xe8, 0x94, 0xb2, 0xe8, 0x93, 0xba, 0xe8, 0x93, 0xbb, 0xe8, 0x93, 0xbd,
  0xe8, 0x94, 0x82, 0xe8, 0x94, 0x83, 0xe8, 0x94, 0x87, 0xe8, 0x94, 0x8c,
  0xe8, 0x94, 0x8e, 0xe8, 0x94, 0x90, 0xe8, 0x94, 0x9c, 0xe8, 0x94, 0x9e,
  0xe8, 0x94, 0xa2, 0xe8, 0x94, 0xa3, 0xe8, 0x94, 0xa4, 0xe8, 0x94, 0xa5,
  0xe8, 0x94, 0xa7, 0xe8, 0x94, 0xaa, 0xe8, 0x94, 0xab, 0xe8, 0x94, 0xaf,
  0xe8, 0x94, 0xb3, 0xe8, 0x94, 0xb4, 0xe8, 0x94, 0xb6, 0xe8, 0x94, 0xbf,
  0xe8, 0x95, 0x86, 0xe8, 0x95, 0x8f, 0xe8, 0x95, 0x90, 0xe8, 0x95, 0x91,
  0xe8, 0x95, 0x92, 0xe8, 0x95, 0x93, 0xe8, 0x95, 0x96, 0xe8, 0x95, 0x99,
  0xe8, 0x95, 0x9c, 0xe8, 0x95, 0x9d, 0xe8, 0x95, 0x9e, 0xe8, 0x95, 0x9f,
  0xe8, 0x95, 0xa0, 0xe8, 0x95, 0xa1, 0xe8, 0x95, 0xa2, 0xe8, 0x95, 0xa4,
  0xe8, 0x95, 0xab, 0xe8, 0x95, 0xaf, 0xe8, 0x95, 0xb9, 0xe8, 0x95, 0xba,
  0xe8, 0x95, 0xbb, 0xe8, 0x95, 0xbd, 0xe8, 0x95, 0xbf, 0xe8, 0x96, 0x81,
  0xe8, 0x96, 0x85, 0xe8, 0x96, 0x86, 0xe8, 0x96, 0x89, 0xe8, 0x96, 0x8b,
  0xe8, 0x96, 0x8c, 0xe8, 0x96, 0x8f, 0xe8, 0x96, 0x93, 0xe8, 0x96, 0x98,
  0xe8, 0x96, 0x9d, 0xe8, 0x96, 0x9f, 0xe8, 0x96, 0xa0, 0xe8, 0x96, 0xa2,
  0xe8, 0x96, 0xa5, 0xe8, 0x96, 0xa7, 0xe8, 0x96, 0xb4, 0xe8, 0x96, 0xb6,
  0xe8, 0x96, 0xb7, 0xe8, 0x96, 0xb8, 0xe8, 0x96, 0xbc, 0xe8, 0x96, 0xbd,
  0xe8, 0x96, 0xbe, 0xe8, 0x96, 0xbf, 0xe8, 0x97, 0x82, 0xe8, 0x97, 0x87,
  0xe8, 0x97, 0x8a, 0xe8, 0x97, 0x8b, 0xe8, 0x97, 0x8e, 0xe8, 0x96, 0xad,
  0xe8, 0x97, 0x98, 0xe8, 0x97, 0x9a, 0xe8, 0x97, 0x9f, 0xe8, 0x97, 0xa0,
  0xe8, 0x97, 0xa6, 0xe8, 0x97, 0xa8, 0xe8, 0x97, 0xad, 0xe8, 0x97, 0xb3,
  0xe8, 0x97, 0xb6, 0xe8, 0x97, 0xbc
};

unsigned char jis_x0212_row_58_converted_to_utf8[] = {
  0xe8, 0x97, 0xbf, 0xe8, 0x98, 0x80, 0xe8, 0x98, 0x84, 0xe8, 0x98, 0x85,
  0xe8, 0x98, 0x8d, 0xe8, 0x98, 0x8e, 0xe8, 0x98, 0x90, 0xe8, 0x98, 0x91,
  0xe8, 0x98, 0x92, 0xe8, 0x98, 0x98, 0xe8, 0x98, 0x99, 0xe8, 0x98, 0x9b,
  0xe8, 0x98, 0x9e, 0xe8, 0x98, 0xa1, 0xe8, 0x98, 0xa7, 0xe8, 0x98, 0xa9,
  0xe8, 0x98, 0xb6, 0xe8, 0x98, 0xb8, 0xe8, 0x98, 0xba, 0xe8, 0x98, 0xbc,
  0xe8, 0x98, 0xbd, 0xe8, 0x99, 0x80, 0xe8, 0x99, 0x82, 0xe8, 0x99, 0x86,
  0xe8, 0x99, 0x92, 0xe8, 0x99, 0x93, 0xe8, 0x99, 0x96, 0xe8, 0x99, 0x97,
  0xe8, 0x99, 0x98, 0xe8, 0x99, 0x99, 0xe8, 0x99, 0x9d, 0xe8, 0x99, 0xa0,
  0xe8, 0x99, 0xa1, 0xe8, 0x99, 0xa2, 0xe8, 0x99, 0xa3, 0xe8, 0x99, 0xa4,
  0xe8, 0x99, 0xa9, 0xe8, 0x99, 0xac, 0xe8, 0x99, 0xaf, 0xe8, 0x99, 0xb5,
  0xe8, 0x99, 0xb6, 0xe8, 0x99, 0xb7, 0xe8, 0x99, 0xba, 0xe8, 0x9a, 0x8d,
  0xe8, 0x9a, 0x91, 0xe8, 0x9a, 0x96, 0xe8, 0x9a, 0x98, 0xe8, 0x9a, 0x9a,
  0xe8, 0x9a, 0x9c, 0xe8, 0x9a, 0xa1, 0xe8, 0x9a, 0xa6, 0xe8, 0x9a, 0xa7,
  0xe8, 0x9a, 0xa8, 0xe8, 0x9a, 0xad, 0xe8, 0x9a, 0xb1, 0xe8, 0x9a, 0xb3,
  0xe8, 0x9a, 0xb4, 0xe8, 0x9a, 0xb5, 0xe8, 0x9a, 0xb7, 0xe8, 0x9a, 0xb8,
  0xe8, 0x9a, 0xb9, 0xe8, 0x9a, 0xbf, 0xe8, 0x9b, 0x80, 0xe8, 0x9b, 0x81,
  0xe8, 0x9b, 0x83, 0xe8, 0x9b, 0x85, 0xe8, 0x9b, 0x91, 0xe8, 0x9b, 0x92,
  0xe8, 0x9b, 0x95, 0xe8, 0x9b, 0x97, 0xe8, 0x9b, 0x9a, 0xe8, 0x9b, 0x9c,
  0xe8, 0x9b, 0xa0, 0xe8, 0x9b, 0xa3, 0xe8, 0x9b, 0xa5, 0xe8, 0x9b, 0xa7,
  0xe8, 0x9a, 0x88, 0xe8, 0x9b, 0xba, 0xe8, 0x9b, 0xbc, 0xe8, 0x9b, 0xbd,
  0xe8, 0x9c, 0x84, 0xe8, 0x9c, 0x85, 0xe8, 0x9c, 0x87, 0xe8, 0x9c, 0x8b,
  0xe8, 0x9c, 0x8e, 0xe8, 0x9c, 0x8f, 0xe8, 0x9c, 0x90, 0xe8, 0x9c, 0x93,
  0xe8, 0x9c, 0x94, 0xe8, 0x9c, 0x99, 0xe8, 0x9c, 0x9e, 0xe8, 0x9c, 0x9f,
  0xe8, 0x9c, 0xa1, 0xe8, 0x9c, 0xa3
};

unsigned char jis_x0212_row_59_converted_to_utf8[] = {
  0xe8, 0x9c, 0xa8, 0xe8, 0x9c, 0xae, 0xe8, 0x9c, 0xaf, 0xe8, 0x9c, 0xb1,
  0xe8, 0x9c, 0xb2, 0xe8, 0x9c, 0xb9, 0xe8, 0x9c, 0xba, 0xe8, 0x9c, 0xbc,
  0xe8, 0x9c, 0xbd, 0xe8, 0x9c, 0xbe, 0xe8, 0x9d, 0x80, 0xe8, 0x9d, 0x83,
  0xe8, 0x9d, 0x85, 0xe8, 0x9d, 0x8d, 0xe8, 0x9d, 0x98, 0xe8, 0x9d, 0x9d,
  0xe8, 0x9d, 0xa1, 0xe8, 0x9d, 0xa4, 0xe8, 0x9d, 0xa5, 0xe8, 0x9d, 0xaf,
  0xe8, 0x9d, 0xb1, 0xe8, 0x9d, 0xb2, 0xe8, 0x9d, 0xbb, 0xe8, 0x9e, 0x83,
  0xe8, 0x9e, 0x84, 0xe8, 0x9e, 0x85, 0xe8, 0x9e, 0x86, 0xe8, 0x9e, 0x87,
  0xe8, 0x9e, 0x88, 0xe8, 0x9e, 0x89, 0xe8, 0x9e, 0x8b, 0xe8, 0x9e, 0x8c,
  0xe8, 0x9e, 0x90, 0xe8, 0x9e, 0x93, 0xe8, 0x9e, 0x95, 0xe8, 0x9e, 0x97,
  0xe8, 0x9e, 0x98, 0xe8, 0x9e, 0x99, 0xe8, 0x9e, 0x9e, 0xe8, 0x9e, 0xa0,
  0xe8, 0x9e, 0xa3, 0xe8, 0x9e, 0xa7, 0xe8, 0x9e, 0xac, 0xe8, 0x9e, 0xad,
  0xe8, 0x9e, 0xae, 0xe8, 0x9e, 0xb1, 0xe8, 0x9e, 0xb5, 0xe8, 0x9e, 0xbe,
  0xe8, 0x9e, 0xbf, 0xe8, 0x9f, 0x81, 0xe8, 0x9f, 0x88, 0xe8, 0x9f, 0x89,
  0xe8, 0x9f, 0x8a, 0xe8, 0x9f, 0x8e, 0xe8, 0x9f, 0x95, 0xe8, 0x9f, 0x96,
  0xe8, 0x9f, 0x99, 0xe8, 0x9f, 0x9a, 0xe8, 0x9f, 0x9c, 0xe8, 0x9f, 0x9f,
  0xe8, 0x9f, 0xa2, 0xe8, 0x9f, 0xa3, 0xe8, 0x9f, 0xa4, 0xe8, 0x9f, 0xaa,
  0xe8, 0x9f, 0xab, 0xe8, 0x9f, 0xad, 0xe8, 0x9f, 0xb1, 0xe8, 0x9f, 0xb3,
  0xe8, 0x9f, 0xb8, 0xe8, 0x9f, 0xba, 0xe8, 0x9f, 0xbf, 0xe8, 0xa0, 0x81,
  0xe8, 0xa0, 0x83, 0xe8, 0xa0, 0x86, 0xe8, 0xa0, 0x89, 0xe8, 0xa0, 0x8a,
  0xe8, 0xa0, 0x8b, 0xe8, 0xa0, 0x90, 0xe8, 0xa0, 0x99, 0xe8, 0xa0, 0x92,
  0xe8, 0xa0, 0x93, 0xe8, 0xa0, 0x94, 0xe8, 0xa0, 0x98, 0xe8, 0xa0, 0x9a,
  0xe8, 0xa0, 0x9b, 0xe8, 0xa0, 0x9c, 0xe8, 0xa0, 0x9e, 0xe8, 0xa0, 0x9f,
  0xe8, 0xa0, 0xa8, 0xe8, 0xa0, 0xad, 0xe8, 0xa0, 0xae, 0xe8, 0xa0, 0xb0,
  0xe8, 0xa0, 0xb2, 0xe8, 0xa0, 0xb5
};

unsigned char jis_x0212_row_60_converted_to_utf8[] = {
  0xe8, 0xa0, 0xba, 0xe8, 0xa0, 0xbc, 0xe8, 0xa1, 0x81, 0xe8, 0xa1, 0x83,
  0xe8, 0xa1, 0x85, 0xe8, 0xa1, 0x88, 0xe8, 0xa1, 0x89, 0xe8, 0xa1, 0x8a,
  0xe8, 0xa1, 0x8b, 0xe8, 0xa1, 0x8e, 0xe8, 0xa1, 0x91, 0xe8, 0xa1, 0x95,
  0xe8, 0xa1, 0x96, 0xe8, 0xa1, 0x98, 0xe8, 0xa1, 0x9a, 0xe8, 0xa1, 0x9c,
  0xe8, 0xa1, 0x9f, 0xe8, 0xa1, 0xa0, 0xe8, 0xa1, 0xa4, 0xe8, 0xa1, 0xa9,
  0xe8, 0xa1, 0xb1, 0xe8, 0xa1, 0xb9, 0xe8, 0xa1, 0xbb, 0xe8, 0xa2, 0x80,
  0xe8, 0xa2, 0x98, 0xe8, 0xa2, 0x9a, 0xe8, 0xa2, 0x9b, 0xe8, 0xa2, 0x9c,
  0xe8, 0xa2, 0x9f, 0xe8, 0xa2, 0xa0, 0xe8, 0xa2, 0xa8, 0xe8, 0xa2, 0xaa,
  0xe8, 0xa2, 0xba, 0xe8, 0xa2, 0xbd, 0xe8, 0xa2, 0xbe, 0xe8, 0xa3, 0x80,
  0xe8, 0xa3, 0x8a, 0xe8, 0xa3, 0x8b, 0xe8, 0xa3, 0x8c, 0xe8, 0xa3, 0x8d,
  0xe8, 0xa3, 0x8e, 0xe8, 0xa3, 0x91, 0xe8, 0xa3, 0x92, 0xe8, 0xa3, 0x93,
  0xe8, 0xa3, 0x9b, 0xe8, 0xa3, 0x9e, 0xe8, 0xa3, 0xa7, 0xe8, 0xa3, 0xaf,
  0xe8, 0xa3, 0xb0, 0xe8, 0xa3, 0xb1, 0xe8, 0xa3, 0xb5, 0xe8, 0xa3, 0xb7,
  0xe8, 0xa4, 0x81, 0xe8, 0xa4, 0x86, 0xe8, 0xa4, 0x8d, 0xe8, 0xa4, 0x8e,
  0xe8, 0xa4, 0x8f, 0xe8, 0xa4, 0x95, 0xe8, 0xa4, 0x96, 0xe8, 0xa4, 0x98,
  0xe8, 0xa4, 0x99, 0xe8, 0xa4, 0x9a, 0xe8, 0xa4, 0x9c, 0xe8, 0xa4, 0xa0,
  0xe8, 0xa4, 0xa6, 0xe8, 0xa4, 0xa7, 0xe8, 0xa4, 0xa8, 0xe8, 0xa4, 0xb0,
  0xe8, 0xa4, 0xb1, 0xe8, 0xa4, 0xb2, 0xe8, 0xa4, 0xb5, 0xe8, 0xa4, 0xb9,
  0xe8, 0xa4, 0xba, 0xe8, 0xa4, 0xbe, 0xe8, 0xa5, 0x80, 0xe8, 0xa5, 0x82,
  0xe8, 0xa5, 0x85, 0xe8, 0xa5, 0x86, 0xe8, 0xa5, 0x89, 0xe8, 0xa5, 0x8f,
  0xe8, 0xa5, 0x92, 0xe8, 0xa5, 0x97, 0xe8, 0xa5, 0x9a, 0xe8, 0xa5, 0x9b,
  0xe8, 0xa5, 0x9c, 0xe8, 0xa5, 0xa1, 0xe8, 0xa5, 0xa2, 0xe8, 0xa5, 0xa3,
  0xe8, 0xa5, 0xab, 0xe8, 0xa5, 0xae, 0xe8, 0xa5, 0xb0, 0xe8, 0xa5, 0xb3,
  0xe8, 0xa5, 0xb5, 0xe8, 0xa5, 0xba
};

unsigned char jis_x0212_row_61_converted_to_utf8[] = {
  0xe8, 0xa5, 0xbb, 0xe8, 0xa5, 0xbc, 0xe8, 0xa5, 0xbd, 0xe8, 0xa6, 0x89,
  0xe8, 0xa6, 0x8d, 0xe8, 0xa6, 0x90, 0xe8, 0xa6, 0x94, 0xe8, 0xa6, 0x95,
  0xe8, 0xa6, 0x9b, 0xe8, 0xa6, 0x9c, 0xe8, 0xa6, 0x9f, 0xe8, 0xa6, 0xa0,
  0xe8, 0xa6, 0xa5, 0xe8, 0xa6, 0xb0, 0xe8, 0xa6, 0xb4, 0xe8, 0xa6, 0xb5,
  0xe8, 0xa6, 0xb6, 0xe8, 0xa6, 0xb7, 0xe8, 0xa6, 0xbc, 0xe8, 0xa7, 0x94,
  0xe8, 0xa7, 0x95, 0xe8, 0xa7, 0x96, 0xe8, 0xa7, 0x97, 0xe8, 0xa7, 0x98,
  0xe8, 0xa7, 0xa5, 0xe8, 0xa7, 0xa9, 0xe8, 0xa7, 0xab, 0xe8, 0xa7, 0xad,
  0xe8, 0xa7, 0xb1, 0xe8, 0xa7, 0xb3, 0xe8, 0xa7, 0xb6, 0xe8, 0xa7, 0xb9,
  0xe8, 0xa7, 0xbd, 0xe8, 0xa7, 0xbf, 0xe8, 0xa8, 0x84, 0xe8, 0xa8, 0x85,
  0xe8, 0xa8, 0x87, 0xe8, 0xa8, 0x8f, 0xe8, 0xa8, 0x91, 0xe8, 0xa8, 0x92,
  0xe8, 0xa8, 0x94, 0xe8, 0xa8, 0x95, 0xe8, 0xa8, 0x9e, 0xe8, 0xa8, 0xa0,
  0xe8, 0xa8, 0xa2, 0xe8, 0xa8, 0xa4, 0xe8, 0xa8, 0xa6, 0xe8, 0xa8, 0xab,
  0xe8, 0xa8, 0xac, 0xe8, 0xa8, 0xaf, 0xe8, 0xa8, 0xb5, 0xe8, 0xa8, 0xb7,
  0xe8, 0xa8, 0xbd, 0xe8, 0xa8, 0xbe, 0xe8, 0xa9, 0x80, 0xe8, 0xa9, 0x83,
  0xe8, 0xa9, 0x85, 0xe8, 0xa9, 0x87, 0xe8, 0xa9, 0x89, 0xe8, 0xa9, 0x8d,
  0xe8, 0xa9, 0x8e, 0xe8, 0xa9, 0x93, 0xe8, 0xa9, 0x96, 0xe8, 0xa9, 0x97,
  0xe8, 0xa9, 0x98, 0xe8, 0xa9, 0x9c, 0xe8, 0xa9, 0x9d, 0xe8, 0xa9, 0xa1,
  0xe8, 0xa9, 0xa5, 0xe8, 0xa9, 0xa7, 0xe8, 0xa9, 0xb5, 0xe8, 0xa9, 0xb6,
  0xe8, 0xa9, 0xb7, 0xe8, 0xa9, 0xb9, 0xe8, 0xa9, 0xba, 0xe8, 0xa9, 0xbb,
  0xe8, 0xa9, 0xbe, 0xe8, 0xa9, 0xbf, 0xe8, 0xaa, 0x80, 0xe8, 0xaa, 0x83,
  0xe8, 0xaa, 0x86, 0xe8, 0xaa, 0x8b, 0xe8, 0xaa, 0x8f, 0xe8, 0xaa, 0x90,
  0xe8, 0xaa, 0x92, 0xe8, 0xaa, 0x96, 0xe8, 0xaa, 0x97, 0xe8, 0xaa, 0x99,
  0xe8, 0xaa, 0x9f, 0xe8, 0xaa, 0xa7, 0xe8, 0xaa, 0xa9, 0xe8, 0xaa, 0xae,
  0xe8, 0xaa, 0xaf, 0xe8, 0xaa, 0xb3
};

unsigned char jis_x0212_row_62_converted_to_utf8[] = {
  0xe8, 0xaa, 0xb6, 0xe8, 0xaa, 0xb7, 0xe8, 0xaa, 0xbb, 0xe8, 0xaa, 0xbe,
  0xe8, 0xab, 0x83, 0xe8, 0xab, 0x86, 0xe8, 0xab, 0x88, 0xe8, 0xab, 0x89,
  0xe8, 0xab, 0x8a, 0xe8, 0xab, 0x91, 0xe8, 0xab, 0x93, 0xe8, 0xab, 0x94,
  0xe8, 0xab, 0x95, 0xe8, 0xab, 0x97, 0xe8, 0xab, 0x9d, 0xe8, 0xab, 0x9f,
  0xe8, 0xab, 0xac, 0xe8, 0xab, 0xb0, 0xe8, 0xab, 0xb4, 0xe8, 0xab, 0xb5,
  0xe8, 0xab, 0xb6, 0xe8, 0xab, 0xbc, 0xe8, 0xab, 0xbf, 0xe8, 0xac, 0x85,
  0xe8, 0xac, 0x86, 0xe8, 0xac, 0x8b, 0xe8, 0xac, 0x91, 0xe8, 0xac, 0x9c,
  0xe8, 0xac, 0x9e, 0xe8, 0xac, 0x9f, 0xe8, 0xac, 0x8a, 0xe8, 0xac, 0xad,
  0xe8, 0xac, 0xb0, 0xe8, 0xac, 0xb7, 0xe8, 0xac, 0xbc, 0xe8, 0xad, 0x82,
  0xe8, 0xad, 0x83, 0xe8, 0xad, 0x84, 0xe8, 0xad, 0x85, 0xe8, 0xad, 0x86,
  0xe8, 0xad, 0x88, 0xe8, 0xad, 0x92, 0xe8, 0xad, 0x93, 0xe8, 0xad, 0x94,
  0xe8, 0xad, 0x99, 0xe8, 0xad, 0x8d, 0xe8, 0xad, 0x9e, 0xe8, 0xad, 0xa3,
  0xe8, 0xad, 0xad, 0xe8, 0xad, 0xb6, 0xe8, 0xad, 0xb8, 0xe8, 0xad, 0xb9,
  0xe8, 0xad, 0xbc, 0xe8, 0xad, 0xbe, 0xe8, 0xae, 0x81, 0xe8, 0xae, 0x84,
  0xe8, 0xae, 0x85, 0xe8, 0xae, 0x8b, 0xe8, 0xae, 0x8d, 0xe8, 0xae, 0x8f,
  0xe8, 0xae, 0x94, 0xe8, 0xae, 0x95, 0xe8, 0xae, 0x9c, 0xe8, 0xae, 0x9e,
  0xe8, 0xae, 0x9f, 0xe8, 0xb0, 0xb8, 0xe8, 0xb0, 0xb9, 0xe8, 0xb0, 0xbd,
  0xe8, 0xb0, 0xbe, 0xe8, 0xb1, 0x85, 0xe8, 0xb1, 0x87, 0xe8, 0xb1, 0x89,
  0xe8, 0xb1, 0x8b, 0xe8, 0xb1, 0x8f, 0xe8, 0xb1, 0x91, 0xe8, 0xb1, 0x93,
  0xe8, 0xb1, 0x94, 0xe8, 0xb1, 0x97, 0xe8, 0xb1, 0x98, 0xe8, 0xb1, 0x9b,
  0xe8, 0xb1, 0x9d, 0xe8, 0xb1, 0x99, 0xe8, 0xb1, 0xa3, 0xe8, 0xb1, 0xa4,
  0xe8, 0xb1, 0xa6, 0xe8, 0xb1, 0xa8, 0xe8, 0xb1, 0xa9, 0xe8, 0xb1, 0xad,
  0xe8, 0xb1, 0xb3, 0xe8, 0xb1, 0xb5, 0xe8, 0xb1, 0xb6, 0xe8, 0xb1, 0xbb,
  0xe8, 0xb1, 0xbe, 0xe8, 0xb2, 0x86
};

unsigned char jis_x0212_row_63_converted_to_utf8[] = {
  0xe8, 0xb2, 0x87, 0xe8, 0xb2, 0x8b, 0xe8, 0xb2, 0x90, 0xe8, 0xb2, 0x92,
  0xe8, 0xb2, 0x93, 0xe8, 0xb2, 0x99, 0xe8, 0xb2, 0x9b, 0xe8, 0xb2, 0x9c,
  0xe8, 0xb2, 0xa4, 0xe8, 0xb2, 0xb9, 0xe8, 0xb2, 0xba, 0xe8, 0xb3, 0x85,
  0xe8, 0xb3, 0x86, 0xe8, 0xb3, 0x89, 0xe8, 0xb3, 0x8b, 0xe8, 0xb3, 0x8f,
  0xe8, 0xb3, 0x96, 0xe8, 0xb3, 0x95, 0xe8, 0xb3, 0x99, 0xe8, 0xb3, 0x9d,
  0xe8, 0xb3, 0xa1, 0xe8, 0xb3, 0xa8, 0xe8, 0xb3, 0xac, 0xe8, 0xb3, 0xaf,
  0xe8, 0xb3, 0xb0, 0xe8, 0xb3, 0xb2, 0xe8, 0xb3, 0xb5, 0xe8, 0xb3, 0xb7,
  0xe8, 0xb3, 0xb8, 0xe8, 0xb3, 0xbe, 0xe8, 0xb3, 0xbf, 0xe8, 0xb4, 0x81,
  0xe8, 0xb4, 0x83, 0xe8, 0xb4, 0x89, 0xe8, 0xb4, 0x92, 0xe8, 0xb4, 0x97,
  0xe8, 0xb4, 0x9b, 0xe8, 0xb5, 0xa5, 0xe8, 0xb5, 0xa9, 0xe8, 0xb5, 0xac,
  0xe8, 0xb5, 0xae, 0xe8, 0xb5, 0xbf, 0xe8, 0xb6, 0x82, 0xe8, 0xb6, 0x84,
  0xe8, 0xb6, 0x88, 0xe8, 0xb6, 0x8d, 0xe8, 0xb6, 0x90, 0xe8, 0xb6, 0x91,
  0xe8, 0xb6, 0x95, 0xe8, 0xb6, 0x9e, 0xe8, 0xb6, 0x9f, 0xe8, 0xb6, 0xa0,
  0xe8, 0xb6, 0xa6, 0xe8, 0xb6, 0xab, 0xe8, 0xb6, 0xac, 0xe8, 0xb6, 0xaf,
  0xe8, 0xb6, 0xb2, 0xe8, 0xb6, 0xb5, 0xe8, 0xb6, 0xb7, 0xe8, 0xb6, 0xb9,
  0xe8, 0xb6, 0xbb, 0xe8, 0xb7, 0x80, 0xe8, 0xb7, 0x85, 0xe8, 0xb7, 0x86,
  0xe8, 0xb7, 0x87, 0xe8, 0xb7, 0x88, 0xe8, 0xb7, 0x8a, 0xe8, 0xb7, 0x8e,
  0xe8, 0xb7, 0x91, 0xe8, 0xb7, 0x94, 0xe8, 0xb7, 0x95, 0xe8, 0xb7, 0x97,
  0xe8, 0xb7, 0x99, 0xe8, 0xb7, 0xa4, 0xe8, 0xb7, 0xa5, 0xe8, 0xb7, 0xa7,
  0xe8, 0xb7, 0xac, 0xe8, 0xb7, 0xb0, 0xe8, 0xb6, 0xbc, 0xe8, 0xb7, 0xb1,
  0xe8, 0xb7, 0xb2, 0xe8, 0xb7, 0xb4, 0xe8, 0xb7, 0xbd, 0xe8, 0xb8, 0x81,
  0xe8, 0xb8, 0x84, 0xe8, 0xb8, 0x85, 0xe8, 0xb8, 0x86, 0xe8, 0xb8, 0x8b,
  0xe8, 0xb8, 0x91, 0xe8, 0xb8, 0x94, 0xe8, 0xb8, 0x96, 0xe8, 0xb8, 0xa0,
  0xe8, 0xb8, 0xa1, 0xe8, 0xb8, 0xa2
};

unsigned char jis_x0212_row_64_converted_to_utf8[] = {
  0xe8, 0xb8, 0xa3, 0xe8, 0xb8, 0xa6, 0xe8, 0xb8, 0xa7, 0xe8, 0xb8, 0xb1,
  0xe8, 0xb8, 0xb3, 0xe8, 0xb8, 0xb6, 0xe8, 0xb8, 0xb7, 0xe8, 0xb8, 0xb8,
  0xe8, 0xb8, 0xb9, 0xe8, 0xb8, 0xbd, 0xe8, 0xb9, 0x80, 0xe8, 0xb9, 0x81,
  0xe8, 0xb9, 0x8b, 0xe8, 0xb9, 0x8d, 0xe8, 0xb9, 0x8e, 0xe8, 0xb9, 0x8f,
  0xe8, 0xb9, 0x94, 0xe8, 0xb9, 0x9b, 0xe8, 0xb9, 0x9c, 0xe8, 0xb9, 0x9d,
  0xe8, 0xb9, 0x9e, 0xe8, 0xb9, 0xa1, 0xe8, 0xb9, 0xa2, 0xe8, 0xb9, 0xa9,
  0xe8, 0xb9, 0xac, 0xe8, 0xb9, 0xad, 0xe8, 0xb9, 0xaf, 0xe8, 0xb9, 0xb0,
  0xe8, 0xb9, 0xb1, 0xe8, 0xb9, 0xb9, 0xe8, 0xb9, 0xba, 0xe8, 0xb9, 0xbb,
  0xe8, 0xba, 0x82, 0xe8, 0xba, 0x83, 0xe8, 0xba, 0x89, 0xe8, 0xba, 0x90,
  0xe8, 0xba, 0x92, 0xe8, 0xba, 0x95, 0xe8, 0xba, 0x9a, 0xe8, 0xba, 0x9b,
  0xe8, 0xba, 0x9d, 0xe8, 0xba, 0x9e, 0xe8, 0xba, 0xa2, 0xe8, 0xba, 0xa7,
  0xe8, 0xba, 0xa9, 0xe8, 0xba, 0xad, 0xe8, 0xba, 0xae, 0xe8, 0xba, 0xb3,
  0xe8, 0xba, 0xb5, 0xe8, 0xba, 0xba, 0xe8, 0xba, 0xbb, 0xe8, 0xbb, 0x80,
  0xe8, 0xbb, 0x81, 0xe8, 0xbb, 0x83, 0xe8, 0xbb, 0x84, 0xe8, 0xbb, 0x87,
  0xe8, 0xbb, 0x8f, 0xe8, 0xbb, 0x91, 0xe8, 0xbb, 0x94, 0xe8, 0xbb, 0x9c,
  0xe8, 0xbb, 0xa8, 0xe8, 0xbb, 0xae, 0xe8, 0xbb, 0xb0, 0xe8, 0xbb, 0xb1,
  0xe8, 0xbb, 0xb7, 0xe8, 0xbb, 0xb9, 0xe8, 0xbb, 0xba, 0xe8, 0xbb, 0xad,
  0xe8, 0xbc, 0x80, 0xe8, 0xbc, 0x82, 0xe8, 0xbc, 0x87, 0xe8, 0xbc, 0x88,
  0xe8, 0xbc, 0x8f, 0xe8, 0xbc, 0x90, 0xe8, 0xbc, 0x96, 0xe8, 0xbc, 0x97,
  0xe8, 0xbc, 0x98, 0xe8, 0xbc, 0x9e, 0xe8, 0xbc, 0xa0, 0xe8, 0xbc, 0xa1,
  0xe8, 0xbc, 0xa3, 0xe8, 0xbc, 0xa5, 0xe8, 0xbc, 0xa7, 0xe8, 0xbc, 0xa8,
  0xe8, 0xbc, 0xac, 0xe8, 0xbc, 0xad, 0xe8, 0xbc, 0xae, 0xe8, 0xbc, 0xb4,
  0xe8, 0xbc, 0xb5, 0xe8, 0xbc, 0xb6, 0xe8, 0xbc, 0xb7, 0xe8, 0xbc, 0xba,
  0xe8, 0xbd, 0x80, 0xe8, 0xbd, 0x81
};

unsigned char jis_x0212_row_65_converted_to_utf8[] = {
  0xe8, 0xbd, 0x83, 0xe8, 0xbd, 0x87, 0xe8, 0xbd, 0x8f, 0xe8, 0xbd, 0x91,
  0xe8, 0xbd, 0x92, 0xe8, 0xbd, 0x93, 0xe8, 0xbd, 0x94, 0xe8, 0xbd, 0x95,
  0xe8, 0xbd, 0x98, 0xe8, 0xbd, 0x9d, 0xe8, 0xbd, 0x9e, 0xe8, 0xbd, 0xa5,
  0xe8, 0xbe, 0x9d, 0xe8, 0xbe, 0xa0, 0xe8, 0xbe, 0xa1, 0xe8, 0xbe, 0xa4,
  0xe8, 0xbe, 0xa5, 0xe8, 0xbe, 0xa6, 0xe8, 0xbe, 0xb5, 0xe8, 0xbe, 0xb6,
  0xe8, 0xbe, 0xb8, 0xe8, 0xbe, 0xbe, 0xe8, 0xbf, 0x80, 0xe8, 0xbf, 0x81,
  0xe8, 0xbf, 0x86, 0xe8, 0xbf, 0x8a, 0xe8, 0xbf, 0x8b, 0xe8, 0xbf, 0x8d,
  0xe8, 0xbf, 0x90, 0xe8, 0xbf, 0x92, 0xe8, 0xbf, 0x93, 0xe8, 0xbf, 0x95,
  0xe8, 0xbf, 0xa0, 0xe8, 0xbf, 0xa3, 0xe8, 0xbf, 0xa4, 0xe8, 0xbf, 0xa8,
  0xe8, 0xbf, 0xae, 0xe8, 0xbf, 0xb1, 0xe8, 0xbf, 0xb5, 0xe8, 0xbf, 0xb6,
  0xe8, 0xbf, 0xbb, 0xe8, 0xbf, 0xbe, 0xe9, 0x80, 0x82, 0xe9, 0x80, 0x84,
  0xe9, 0x80, 0x88, 0xe9, 0x80, 0x8c, 0xe9, 0x80, 0x98, 0xe9, 0x80, 0x9b,
  0xe9, 0x80, 0xa8, 0xe9, 0x80, 0xa9, 0xe9, 0x80, 0xaf, 0xe9, 0x80, 0xaa,
  0xe9, 0x80, 0xac, 0xe9, 0x80, 0xad, 0xe9, 0x80, 0xb3, 0xe9, 0x80, 0xb4,
  0xe9, 0x80, 0xb7, 0xe9, 0x80, 0xbf, 0xe9, 0x81, 0x83, 0xe9, 0x81, 0x84,
  0xe9, 0x81, 0x8c, 0xe9, 0x81, 0x9b, 0xe9, 0x81, 0x9d, 0xe9, 0x81, 0xa2,
  0xe9, 0x81, 0xa6, 0xe9, 0x81, 0xa7, 0xe9, 0x81, 0xac, 0xe9, 0x81, 0xb0,
  0xe9, 0x81, 0xb4, 0xe9, 0x81, 0xb9, 0xe9, 0x82, 0x85, 0xe9, 0x82, 0x88,
  0xe9, 0x82, 0x8b, 0xe9, 0x82, 0x8c, 0xe9, 0x82, 0x8e, 0xe9, 0x82, 0x90,
  0xe9, 0x82, 0x95, 0xe9, 0x82, 0x97, 0xe9, 0x82, 0x98, 0xe9, 0x82, 0x99,
  0xe9, 0x82, 0x9b, 0xe9, 0x82, 0xa0, 0xe9, 0x82, 0xa1, 0xe9, 0x82, 0xa2,
  0xe9, 0x82, 0xa5, 0xe9, 0x82, 0xb0, 0xe9, 0x82, 0xb2, 0xe9, 0x82, 0xb3,
  0xe9, 0x82, 0xb4, 0xe9, 0x82, 0xb6, 0xe9, 0x82, 0xbd, 0xe9, 0x83, 0x8c,
  0xe9, 0x82, 0xbe, 0xe9, 0x83, 0x83
};

unsigned char jis_x0212_row_66_converted_to_utf8[] = {
  0xe9, 0x83, 0x84, 0xe9, 0x83, 0x85, 0xe9, 0x83, 0x87, 0xe9, 0x83, 0x88,
  0xe9, 0x83, 0x95, 0xe9, 0x83, 0x97, 0xe9, 0x83, 0x98, 0xe9, 0x83, 0x99,
  0xe9, 0x83, 0x9c, 0xe9, 0x83, 0x9d, 0xe9, 0x83, 0x9f, 0xe9, 0x83, 0xa5,
  0xe9, 0x83, 0x92, 0xe9, 0x83, 0xb6, 0xe9, 0x83, 0xab, 0xe9, 0x83, 0xaf,
  0xe9, 0x83, 0xb0, 0xe9, 0x83, 0xb4, 0xe9, 0x83, 0xbe, 0xe9, 0x83, 0xbf,
  0xe9, 0x84, 0x80, 0xe9, 0x84, 0x84, 0xe9, 0x84, 0x85, 0xe9, 0x84, 0x86,
  0xe9, 0x84, 0x88, 0xe9, 0x84, 0x8d, 0xe9, 0x84, 0x90, 0xe9, 0x84, 0x94,
  0xe9, 0x84, 0x96, 0xe9, 0x84, 0x97, 0xe9, 0x84, 0x98, 0xe9, 0x84, 0x9a,
  0xe9, 0x84, 0x9c, 0xe9, 0x84, 0x9e, 0xe9, 0x84, 0xa0, 0xe9, 0x84, 0xa5,
  0xe9, 0x84, 0xa2, 0xe9, 0x84, 0xa3, 0xe9, 0x84, 0xa7, 0xe9, 0x84, 0xa9,
  0xe9, 0x84, 0xae, 0xe9, 0x84, 0xaf, 0xe9, 0x84, 0xb1, 0xe9, 0x84, 0xb4,
  0xe9, 0x84, 0xb6, 0xe9, 0x84, 0xb7, 0xe9, 0x84, 0xb9, 0xe9, 0x84, 0xba,
  0xe9, 0x84, 0xbc, 0xe9, 0x84, 0xbd, 0xe9, 0x85, 0x83, 0xe9, 0x85, 0x87,
  0xe9, 0x85, 0x88, 0xe9, 0x85, 0x8f, 0xe9, 0x85, 0x93, 0xe9, 0x85, 0x97,
  0xe9, 0x85, 0x99, 0xe9, 0x85, 0x9a, 0xe9, 0x85, 0x9b, 0xe9, 0x85, 0xa1,
  0xe9, 0x85, 0xa4, 0xe9, 0x85, 0xa7, 0xe9, 0x85, 0xad, 0xe9, 0x85, 0xb4,
  0xe9, 0x85, 0xb9, 0xe9, 0x85, 0xba, 0xe9, 0x85, 0xbb, 0xe9, 0x86, 0x81,
  0xe9, 0x86, 0x83, 0xe9, 0x86, 0x85, 0xe9, 0x86, 0x86, 0xe9, 0x86, 0x8a,
  0xe9, 0x86, 0x8e, 0xe9, 0x86, 0x91, 0xe9, 0x86, 0x93, 0xe9, 0x86, 0x94,
  0xe9, 0x86, 0x95, 0xe9, 0x86, 0x98, 0xe9, 0x86, 0x9e, 0xe9, 0x86, 0xa1,
  0xe9, 0x86, 0xa6, 0xe9, 0x86, 0xa8, 0xe9, 0x86, 0xac, 0xe9, 0x86, 0xad,
  0xe9, 0x86, 0xae, 0xe9, 0x86, 0xb0, 0xe9, 0x86, 0xb1, 0xe9, 0x86, 0xb2,
  0xe9, 0x86, 0xb3, 0xe9, 0x86, 0xb6, 0xe9, 0x86, 0xbb, 0xe9, 0x86, 0xbc,
  0xe9, 0x86, 0xbd, 0xe9, 0x86, 0xbf
};

unsigned char jis_x0212_row_67_converted_to_utf8[] = {
  0xe9, 0x87, 0x82, 0xe9, 0x87, 0x83, 0xe9, 0x87, 0x85, 0xe9, 0x87, 0x93,
  0xe9, 0x87, 0x94, 0xe9, 0x87, 0x97, 0xe9, 0x87, 0x99, 0xe9, 0x87, 0x9a,
  0xe9, 0x87, 0x9e, 0xe9, 0x87, 0xa4, 0xe9, 0x87, 0xa5, 0xe9, 0x87, 0xa9,
  0xe9, 0x87, 0xaa, 0xe9, 0x87, 0xac, 0xe9, 0x87, 0xad, 0xe9, 0x87, 0xae,
  0xe9, 0x87, 0xaf, 0xe9, 0x87, 0xb0, 0xe9, 0x87, 0xb1, 0xe9, 0x87, 0xb7,
  0xe9, 0x87, 0xb9, 0xe9, 0x87, 0xbb, 0xe9, 0x87, 0xbd, 0xe9, 0x88, 0x80,
  0xe9, 0x88, 0x81, 0xe9, 0x88, 0x84, 0xe9, 0x88, 0x85, 0xe9, 0x88, 0x86,
  0xe9, 0x88, 0x87, 0xe9, 0x88, 0x89, 0xe9, 0x88, 0x8a, 0xe9, 0x88, 0x8c,
  0xe9, 0x88, 0x90, 0xe9, 0x88, 0x92, 0xe9, 0x88, 0x93, 0xe9, 0x88, 0x96,
  0xe9, 0x88, 0x98, 0xe9, 0x88, 0x9c, 0xe9, 0x88, 0x9d, 0xe9, 0x88, 0xa3,
  0xe9, 0x88, 0xa4, 0xe9, 0x88, 0xa5, 0xe9, 0x88, 0xa6, 0xe9, 0x88, 0xa8,
  0xe9, 0x88, 0xae, 0xe9, 0x88, 0xaf, 0xe9, 0x88, 0xb0, 0xe9, 0x88, 0xb3,
  0xe9, 0x88, 0xb5, 0xe9, 0x88, 0xb6, 0xe9, 0x88, 0xb8, 0xe9, 0x88, 0xb9,
  0xe9, 0x88, 0xba, 0xe9, 0x88, 0xbc, 0xe9, 0x88, 0xbe, 0xe9, 0x89, 0x80,
  0xe9, 0x89, 0x82, 0xe9, 0x89, 0x83, 0xe9, 0x89, 0x86, 0xe9, 0x89, 0x87,
  0xe9, 0x89, 0x8a, 0xe9, 0x89, 0x8d, 0xe9, 0x89, 0x8e, 0xe9, 0x89, 0x8f,
  0xe9, 0x89, 0x91, 0xe9, 0x89, 0x98, 0xe9, 0x89, 0x99, 0xe9, 0x89, 0x9c,
  0xe9, 0x89, 0x9d, 0xe9, 0x89, 0xa0, 0xe9, 0x89, 0xa1, 0xe9, 0x89, 0xa5,
  0xe9, 0x89, 0xa7, 0xe9, 0x89, 0xa8, 0xe9, 0x89, 0xa9, 0xe9, 0x89, 0xae,
  0xe9, 0x89, 0xaf, 0xe9, 0x89, 0xb0, 0xe9, 0x89, 0xb5, 0xe9, 0x89, 0xb6,
  0xe9, 0x89, 0xb7, 0xe9, 0x89, 0xb8, 0xe9, 0x89, 0xb9, 0xe9, 0x89, 0xbb,
  0xe9, 0x89, 0xbc, 0xe9, 0x89, 0xbd, 0xe9, 0x89, 0xbf, 0xe9, 0x8a, 0x88,
  0xe9, 0x8a, 0x89, 0xe9, 0x8a, 0x8a, 0xe9, 0x8a, 0x8d, 0xe9, 0x8a, 0x8e,
  0xe9, 0x8a, 0x92, 0xe9, 0x8a, 0x97
};

unsigned char jis_x0212_row_68_converted_to_utf8[] = {
  0xe9, 0x8a, 0x99, 0xe9, 0x8a, 0x9f, 0xe9, 0x8a, 0xa0, 0xe9, 0x8a, 0xa4,
  0xe9, 0x8a, 0xa5, 0xe9, 0x8a, 0xa7, 0xe9, 0x8a, 0xa8, 0xe9, 0x8a, 0xab,
  0xe9, 0x8a, 0xaf, 0xe9, 0x8a, 0xb2, 0xe9, 0x8a, 0xb6, 0xe9, 0x8a, 0xb8,
  0xe9, 0x8a, 0xba, 0xe9, 0x8a, 0xbb, 0xe9, 0x8a, 0xbc, 0xe9, 0x8a, 0xbd,
  0xe9, 0x8a, 0xbf, 0xe9, 0x8b, 0x80, 0xe9, 0x8b, 0x81, 0xe9, 0x8b, 0x82,
  0xe9, 0x8b, 0x83, 0xe9, 0x8b, 0x85, 0xe9, 0x8b, 0x86, 0xe9, 0x8b, 0x87,
  0xe9, 0x8b, 0x88, 0xe9, 0x8b, 0x8b, 0xe9, 0x8b, 0x8c, 0xe9, 0x8b, 0x8d,
  0xe9, 0x8b, 0x8e, 0xe9, 0x8b, 0x90, 0xe9, 0x8b, 0x93, 0xe9, 0x8b, 0x95,
  0xe9, 0x8b, 0x97, 0xe9, 0x8b, 0x98, 0xe9, 0x8b, 0x99, 0xe9, 0x8b, 0x9c,
  0xe9, 0x8b, 0x9d, 0xe9, 0x8b, 0x9f, 0xe9, 0x8b, 0xa0, 0xe9, 0x8b, 0xa1,
  0xe9, 0x8b, 0xa3, 0xe9, 0x8b, 0xa5, 0xe9, 0x8b, 0xa7, 0xe9, 0x8b, 0xa8,
  0xe9, 0x8b, 0xac, 0xe9, 0x8b, 0xae, 0xe9, 0x8b, 0xb0, 0xe9, 0x8b, 0xb9,
  0xe9, 0x8b, 0xbb, 0xe9, 0x8b, 0xbf, 0xe9, 0x8c, 0x80, 0xe9, 0x8c, 0x82,
  0xe9, 0x8c, 0x88, 0xe9, 0x8c, 0x8d, 0xe9, 0x8c, 0x91, 0xe9, 0x8c, 0x94,
  0xe9, 0x8c, 0x95, 0xe9, 0x8c, 0x9c, 0xe9, 0x8c, 0x9d, 0xe9, 0x8c, 0x9e,
  0xe9, 0x8c, 0x9f, 0xe9, 0x8c, 0xa1, 0xe9, 0x8c, 0xa4, 0xe9, 0x8c, 0xa5,
  0xe9, 0x8c, 0xa7, 0xe9, 0x8c, 0xa9, 0xe9, 0x8c, 0xaa, 0xe9, 0x8c, 0xb3,
  0xe9, 0x8c, 0xb4, 0xe9, 0x8c, 0xb6, 0xe9, 0x8c, 0xb7, 0xe9, 0x8d, 0x87,
  0xe9, 0x8d, 0x88, 0xe9, 0x8d, 0x89, 0xe9, 0x8d, 0x90, 0xe9, 0x8d, 0x91,
  0xe9, 0x8d, 0x92, 0xe9, 0x8d, 0x95, 0xe9, 0x8d, 0x97, 0xe9, 0x8d, 0x98,
  0xe9, 0x8d, 0x9a, 0xe9, 0x8d, 0x9e, 0xe9, 0x8d, 0xa4, 0xe9, 0x8d, 0xa5,
  0xe9, 0x8d, 0xa7, 0xe9, 0x8d, 0xa9, 0xe9, 0x8d, 0xaa, 0xe9, 0x8d, 0xad,
  0xe9, 0x8d, 0xaf, 0xe9, 0x8d, 0xb0, 0xe9, 0x8d, 0xb1, 0xe9, 0x8d, 0xb3,
  0xe9, 0x8d, 0xb4, 0xe9, 0x8d, 0xb6
};

unsigned char jis_x0212_row_69_converted_to_utf8[] = {
  0xe9, 0x8d, 0xba, 0xe9, 0x8d, 0xbd, 0xe9, 0x8d, 0xbf, 0xe9, 0x8e, 0x80,
  0xe9, 0x8e, 0x81, 0xe9, 0x8e, 0x82, 0xe9, 0x8e, 0x88, 0xe9, 0x8e, 0x8a,
  0xe9, 0x8e, 0x8b, 0xe9, 0x8e, 0x8d, 0xe9, 0x8e, 0x8f, 0xe9, 0x8e, 0x92,
  0xe9, 0x8e, 0x95, 0xe9, 0x8e, 0x98, 0xe9, 0x8e, 0x9b, 0xe9, 0x8e, 0x9e,
  0xe9, 0x8e, 0xa1, 0xe9, 0x8e, 0xa3, 0xe9, 0x8e, 0xa4, 0xe9, 0x8e, 0xa6,
  0xe9, 0x8e, 0xa8, 0xe9, 0x8e, 0xab, 0xe9, 0x8e, 0xb4, 0xe9, 0x8e, 0xb5,
  0xe9, 0x8e, 0xb6, 0xe9, 0x8e, 0xba, 0xe9, 0x8e, 0xa9, 0xe9, 0x8f, 0x81,
  0xe9, 0x8f, 0x84, 0xe9, 0x8f, 0x85, 0xe9, 0x8f, 0x86, 0xe9, 0x8f, 0x87,
  0xe9, 0x8f, 0x89, 0xe9, 0x8f, 0x8a, 0xe9, 0x8f, 0x8b, 0xe9, 0x8f, 0x8c,
  0xe9, 0x8f, 0x8d, 0xe9, 0x8f, 0x93, 0xe9, 0x8f, 0x99, 0xe9, 0x8f, 0x9c,
  0xe9, 0x8f, 0x9e, 0xe9, 0x8f, 0x9f, 0xe9, 0x8f, 0xa2, 0xe9, 0x8f, 0xa6,
  0xe9, 0x8f, 0xa7, 0xe9, 0x8f, 0xb9, 0xe9, 0x8f, 0xb7, 0xe9, 0x8f, 0xb8,
  0xe9, 0x8f, 0xba, 0xe9, 0x8f, 0xbb, 0xe9, 0x8f, 0xbd, 0xe9, 0x90, 0x81,
  0xe9, 0x90, 0x82, 0xe9, 0x90, 0x84, 0xe9, 0x90, 0x88, 0xe9, 0x90, 0x89,
  0xe9, 0x90, 0x8d, 0xe9, 0x90, 0x8e, 0xe9, 0x90, 0x8f, 0xe9, 0x90, 0x95,
  0xe9, 0x90, 0x96, 0xe9, 0x90, 0x97, 0xe9, 0x90, 0x9f, 0xe9, 0x90, 0xae,
  0xe9, 0x90, 0xaf, 0xe9, 0x90, 0xb1, 0xe9, 0x90, 0xb2, 0xe9, 0x90, 0xb3,
  0xe9, 0x90, 0xb4, 0xe9, 0x90, 0xbb, 0xe9, 0x90, 0xbf, 0xe9, 0x90, 0xbd,
  0xe9, 0x91, 0x83, 0xe9, 0x91, 0x85, 0xe9, 0x91, 0x88, 0xe9, 0x91, 0x8a,
  0xe9, 0x91, 0x8c, 0xe9, 0x91, 0x95, 0xe9, 0x91, 0x99, 0xe9, 0x91, 0x9c,
  0xe9, 0x91, 0x9f, 0xe9, 0x91, 0xa1, 0xe9, 0x91, 0xa3, 0xe9, 0x91, 0xa8,
  0xe9, 0x91, 0xab, 0xe9, 0x91, 0xad, 0xe9, 0x91, 0xae, 0xe9, 0x91, 0xaf,
  0xe9, 0x91, 0xb1, 0xe9, 0x91, 0xb2, 0xe9, 0x92, 0x84, 0xe9, 0x92, 0x83,
  0xe9, 0x95, 0xb8, 0xe9, 0x95, 0xb9
};

unsigned char jis_x0212_row_70_converted_to_utf8[] = {
  0xe9, 0x95, 0xbe, 0xe9, 0x96, 0x84, 0xe9, 0x96, 0x88, 0xe9, 0x96, 0x8c,
  0xe9, 0x96, 0x8d, 0xe9, 0x96, 0x8e, 0xe9, 0x96, 0x9d, 0xe9, 0x96, 0x9e,
  0xe9, 0x96, 0x9f, 0xe9, 0x96, 0xa1, 0xe9, 0x96, 0xa6, 0xe9, 0x96, 0xa9,
  0xe9, 0x96, 0xab, 0xe9, 0x96, 0xac, 0xe9, 0x96, 0xb4, 0xe9, 0x96, 0xb6,
  0xe9, 0x96, 0xba, 0xe9, 0x96, 0xbd, 0xe9, 0x96, 0xbf, 0xe9, 0x97, 0x86,
  0xe9, 0x97, 0x88, 0xe9, 0x97, 0x89, 0xe9, 0x97, 0x8b, 0xe9, 0x97, 0x90,
  0xe9, 0x97, 0x91, 0xe9, 0x97, 0x92, 0xe9, 0x97, 0x93, 0xe9, 0x97, 0x99,
  0xe9, 0x97, 0x9a, 0xe9, 0x97, 0x9d, 0xe9, 0x97, 0x9e, 0xe9, 0x97, 0x9f,
  0xe9, 0x97, 0xa0, 0xe9, 0x97, 0xa4, 0xe9, 0x97, 0xa6, 0xe9, 0x98, 0x9d,
  0xe9, 0x98, 0x9e, 0xe9, 0x98, 0xa2, 0xe9, 0x98, 0xa4, 0xe9, 0x98, 0xa5,
  0xe9, 0x98, 0xa6, 0xe9, 0x98, 0xac, 0xe9, 0x98, 0xb1, 0xe9, 0x98, 0xb3,
  0xe9, 0x98, 0xb7, 0xe9, 0x98, 0xb8, 0xe9, 0x98, 0xb9, 0xe9, 0x98, 0xba,
  0xe9, 0x98, 0xbc, 0xe9, 0x98, 0xbd, 0xe9, 0x99, 0x81, 0xe9, 0x99, 0x92,
  0xe9, 0x99, 0x94, 0xe9, 0x99, 0x96, 0xe9, 0x99, 0x97, 0xe9, 0x99, 0x98,
  0xe9, 0x99, 0xa1, 0xe9, 0x99, 0xae, 0xe9, 0x99, 0xb4, 0xe9, 0x99, 0xbb,
  0xe9, 0x99, 0xbc, 0xe9, 0x99, 0xbe, 0xe9, 0x99, 0xbf, 0xe9, 0x9a, 0x81,
  0xe9, 0x9a, 0x82, 0xe9, 0x9a, 0x83, 0xe9, 0x9a, 0x84, 0xe9, 0x9a, 0x89,
  0xe9, 0x9a, 0x91, 0xe9, 0x9a, 0x96, 0xe9, 0x9a, 0x9a, 0xe9, 0x9a, 0x9d,
  0xe9, 0x9a, 0x9f, 0xe9, 0x9a, 0xa4, 0xe9, 0x9a, 0xa5, 0xe9, 0x9a, 0xa6,
  0xe9, 0x9a, 0xa9, 0xe9, 0x9a, 0xae, 0xe9, 0x9a, 0xaf, 0xe9, 0x9a, 0xb3,
  0xe9, 0x9a, 0xba, 0xe9, 0x9b, 0x8a, 0xe9, 0x9b, 0x92, 0xe5, 0xb6, 0xb2,
  0xe9, 0x9b, 0x98, 0xe9, 0x9b, 0x9a, 0xe9, 0x9b, 0x9d, 0xe9, 0x9b, 0x9e,
  0xe9, 0x9b, 0x9f, 0xe9, 0x9b, 0xa9, 0xe9, 0x9b, 0xaf, 0xe9, 0x9b, 0xb1,
  0xe9, 0x9b, 0xba, 0xe9, 0x9c, 0x82
};

unsigned char jis_x0212_row_71_converted_to_utf8[] = {
  0xe9, 0x9c, 0x83, 0xe9, 0x9c, 0x85, 0xe9, 0x9c, 0x89, 0xe9, 0x9c, 0x9a,
  0xe9, 0x9c, 0x9b, 0xe9, 0x9c, 0x9d, 0xe9, 0x9c, 0xa1, 0xe9, 0x9c, 0xa2,
  0xe9, 0x9c, 0xa3, 0xe9, 0x9c, 0xa8, 0xe9, 0x9c, 0xb1, 0xe9, 0x9c, 0xb3,
  0xe9, 0x9d, 0x81, 0xe9, 0x9d, 0x83, 0xe9, 0x9d, 0x8a, 0xe9, 0x9d, 0x8e,
  0xe9, 0x9d, 0x8f, 0xe9, 0x9d, 0x95, 0xe9, 0x9d, 0x97, 0xe9, 0x9d, 0x98,
  0xe9, 0x9d, 0x9a, 0xe9, 0x9d, 0x9b, 0xe9, 0x9d, 0xa3, 0xe9, 0x9d, 0xa7,
  0xe9, 0x9d, 0xaa, 0xe9, 0x9d, 0xae, 0xe9, 0x9d, 0xb3, 0xe9, 0x9d, 0xb6,
  0xe9, 0x9d, 0xb7, 0xe9, 0x9d, 0xb8, 0xe9, 0x9d, 0xbb, 0xe9, 0x9d, 0xbd,
  0xe9, 0x9d, 0xbf, 0xe9, 0x9e, 0x80, 0xe9, 0x9e, 0x89, 0xe9, 0x9e, 0x95,
  0xe9, 0x9e, 0x96, 0xe9, 0x9e, 0x97, 0xe9, 0x9e, 0x99, 0xe9, 0x9e, 0x9a,
  0xe9, 0x9e, 0x9e, 0xe9, 0x9e, 0x9f, 0xe9, 0x9e, 0xa2, 0xe9, 0x9e, 0xac,
  0xe9, 0x9e, 0xae, 0xe9, 0x9e, 0xb1, 0xe9, 0x9e, 0xb2, 0xe9, 0x9e, 0xb5,
  0xe9, 0x9e, 0xb6, 0xe9, 0x9e, 0xb8, 0xe9, 0x9e, 0xb9, 0xe9, 0x9e, 0xba,
  0xe9, 0x9e, 0xbc, 0xe9, 0x9e, 0xbe, 0xe9, 0x9e, 0xbf, 0xe9, 0x9f, 0x81,
  0xe9, 0x9f, 0x84, 0xe9, 0x9f, 0x85, 0xe9, 0x9f, 0x87, 0xe9, 0x9f, 0x89,
  0xe9, 0x9f, 0x8a, 0xe9, 0x9f, 0x8c, 0xe9, 0x9f, 0x8d, 0xe9, 0x9f, 0x8e,
  0xe9, 0x9f, 0x90, 0xe9, 0x9f, 0x91, 0xe9, 0x9f, 0x94, 0xe9, 0x9f, 0x97,
  0xe9, 0x9f, 0x98, 0xe9, 0x9f, 0x99, 0xe9, 0x9f, 0x9d, 0xe9, 0x9f, 0x9e,
  0xe9, 0x9f, 0xa0, 0xe9, 0x9f, 0x9b, 0xe9, 0x9f, 0xa1, 0xe9, 0x9f, 0xa4,
  0xe9, 0x9f, 0xaf, 0xe9, 0x9f, 0xb1, 0xe9, 0x9f, 0xb4, 0xe9, 0x9f, 0xb7,
  0xe9, 0x9f, 0xb8, 0xe9, 0x9f, 0xba, 0xe9, 0xa0, 0x87, 0xe9, 0xa0, 0x8a,
  0xe9, 0xa0, 0x99, 0xe9, 0xa0, 0x8d, 0xe9, 0xa0, 0x8e, 0xe9, 0xa0, 0x94,
  0xe9, 0xa0, 0x96, 0xe9, 0xa0, 0x9c, 0xe9, 0xa0, 0x9e, 0xe9, 0xa0, 0xa0,
  0xe9, 0xa0, 0xa3, 0xe9, 0xa0, 0xa6
};

unsigned char jis_x0212_row_72_converted_to_utf8[] = {
  0xe9, 0xa0, 0xab, 0xe9, 0xa0, 0xae, 0xe9, 0xa0, 0xaf, 0xe9, 0xa0, 0xb0,
  0xe9, 0xa0, 0xb2, 0xe9, 0xa0, 0xb3, 0xe9, 0xa0, 0xb5, 0xe9, 0xa0, 0xa5,
  0xe9, 0xa0, 0xbe, 0xe9, 0xa1, 0x84, 0xe9, 0xa1, 0x87, 0xe9, 0xa1, 0x8a,
  0xe9, 0xa1, 0x91, 0xe9, 0xa1, 0x92, 0xe9, 0xa1, 0x93, 0xe9, 0xa1, 0x96,
  0xe9, 0xa1, 0x97, 0xe9, 0xa1, 0x99, 0xe9, 0xa1, 0x9a, 0xe9, 0xa1, 0xa2,
  0xe9, 0xa1, 0xa3, 0xe9, 0xa1, 0xa5, 0xe9, 0xa1, 0xa6, 0xe9, 0xa1, 0xaa,
  0xe9, 0xa1, 0xac, 0xe9, 0xa2, 0xab, 0xe9, 0xa2, 0xad, 0xe9, 0xa2, 0xae,
  0xe9, 0xa2, 0xb0, 0xe9, 0xa2, 0xb4, 0xe9, 0xa2, 0xb7, 0xe9, 0xa2, 0xb8,
  0xe9, 0xa2, 0xba, 0xe9, 0xa2, 0xbb, 0xe9, 0xa2, 0xbf, 0xe9, 0xa3, 0x82,
  0xe9, 0xa3, 0x85, 0xe9, 0xa3, 0x88, 0xe9, 0xa3, 0x8c, 0xe9, 0xa3, 0xa1,
  0xe9, 0xa3, 0xa3, 0xe9, 0xa3, 0xa5, 0xe9, 0xa3, 0xa6, 0xe9, 0xa3, 0xa7,
  0xe9, 0xa3, 0xaa, 0xe9, 0xa3, 0xb3, 0xe9, 0xa3, 0xb6, 0xe9, 0xa4, 0x82,
  0xe9, 0xa4, 0x87, 0xe9, 0xa4, 0x88, 0xe9, 0xa4, 0x91, 0xe9, 0xa4, 0x95,
  0xe9, 0xa4, 0x96, 0xe9, 0xa4, 0x97, 0xe9, 0xa4, 0x9a, 0xe9, 0xa4, 0x9b,
  0xe9, 0xa4, 0x9c, 0xe9, 0xa4, 0x9f, 0xe9, 0xa4, 0xa2, 0xe9, 0xa4, 0xa6,
  0xe9, 0xa4, 0xa7, 0xe9, 0xa4, 0xab, 0xe9, 0xa4, 0xb1, 0xe9, 0xa4, 0xb2,
  0xe9, 0xa4, 0xb3, 0xe9, 0xa4, 0xb4, 0xe9, 0xa4, 0xb5, 0xe9, 0xa4, 0xb9,
  0xe9, 0xa4, 0xba, 0xe9, 0xa4, 0xbb, 0xe9, 0xa4, 0xbc, 0xe9, 0xa5, 0x80,
  0xe9, 0xa5, 0x81, 0xe9, 0xa5, 0x86, 0xe9, 0xa5, 0x87, 0xe9, 0xa5, 0x88,
  0xe9, 0xa5, 0x8d, 0xe9, 0xa5, 0x8e, 0xe9, 0xa5, 0x94, 0xe9, 0xa5, 0x98,
  0xe9, 0xa5, 0x99, 0xe9, 0xa5, 0x9b, 0xe9, 0xa5, 0x9c, 0xe9, 0xa5, 0x9e,
  0xe9, 0xa5, 0x9f, 0xe9, 0xa5, 0xa0, 0xe9, 0xa6, 0x9b, 0xe9, 0xa6, 0x9d,
  0xe9, 0xa6, 0x9f, 0xe9, 0xa6, 0xa6, 0xe9, 0xa6, 0xb0, 0xe9, 0xa6, 0xb1,
  0xe9, 0xa6, 0xb2, 0xe9, 0xa6, 0xb5
};

unsigned char jis_x0212_row_73_converted_to_utf8[] = {
  0xe9, 0xa6, 0xb9, 0xe9, 0xa6, 0xba, 0xe9, 0xa6, 0xbd, 0xe9, 0xa6, 0xbf,
  0xe9, 0xa7, 0x83, 0xe9, 0xa7, 0x89, 0xe9, 0xa7, 0x93, 0xe9, 0xa7, 0x94,
  0xe9, 0xa7, 0x99, 0xe9, 0xa7, 0x9a, 0xe9, 0xa7, 0x9c, 0xe9, 0xa7, 0x9e,
  0xe9, 0xa7, 0xa7, 0xe9, 0xa7, 0xaa, 0xe9, 0xa7, 0xab, 0xe9, 0xa7, 0xac,
  0xe9, 0xa7, 0xb0, 0xe9, 0xa7, 0xb4, 0xe9, 0xa7, 0xb5, 0xe9, 0xa7, 0xb9,
  0xe9, 0xa7, 0xbd, 0xe9, 0xa7, 0xbe, 0xe9, 0xa8, 0x82, 0xe9, 0xa8, 0x83,
  0xe9, 0xa8, 0x84, 0xe9, 0xa8, 0x8b, 0xe9, 0xa8, 0x8c, 0xe9, 0xa8, 0x90,
  0xe9, 0xa8, 0x91, 0xe9, 0xa8, 0x96, 0xe9, 0xa8, 0x9e, 0xe9, 0xa8, 0xa0,
  0xe9, 0xa8, 0xa2, 0xe9, 0xa8, 0xa3, 0xe9, 0xa8, 0xa4, 0xe9, 0xa8, 0xa7,
  0xe9, 0xa8, 0xad, 0xe9, 0xa8, 0xae, 0xe9, 0xa8, 0xb3, 0xe9, 0xa8, 0xb5,
  0xe9, 0xa8, 0xb6, 0xe9, 0xa8, 0xb8, 0xe9, 0xa9, 0x87, 0xe9, 0xa9, 0x81,
  0xe9, 0xa9, 0x84, 0xe9, 0xa9, 0x8a, 0xe9, 0xa9, 0x8b, 0xe9, 0xa9, 0x8c,
  0xe9, 0xa9, 0x8e, 0xe9, 0xa9, 0x91, 0xe9, 0xa9, 0x94, 0xe9, 0xa9, 0x96,
  0xe9, 0xa9, 0x9d, 0xe9, 0xaa, 0xaa, 0xe9, 0xaa, 0xac, 0xe9, 0xaa, 0xae,
  0xe9, 0xaa, 0xaf, 0xe9, 0xaa, 0xb2, 0xe9, 0xaa, 0xb4, 0xe9, 0xaa, 0xb5,
  0xe9, 0xaa, 0xb6, 0xe9, 0xaa, 0xb9, 0xe9, 0xaa, 0xbb, 0xe9, 0xaa, 0xbe,
  0xe9, 0xaa, 0xbf, 0xe9, 0xab, 0x81, 0xe9, 0xab, 0x83, 0xe9, 0xab, 0x86,
  0xe9, 0xab, 0x88, 0xe9, 0xab, 0x8e, 0xe9, 0xab, 0x90, 0xe9, 0xab, 0x92,
  0xe9, 0xab, 0x95, 0xe9, 0xab, 0x96, 0xe9, 0xab, 0x97, 0xe9, 0xab, 0x9b,
  0xe9, 0xab, 0x9c, 0xe9, 0xab, 0xa0, 0xe9, 0xab, 0xa4, 0xe9, 0xab, 0xa5,
  0xe9, 0xab, 0xa7, 0xe9, 0xab, 0xa9, 0xe9, 0xab, 0xac, 0xe9, 0xab, 0xb2,
  0xe9, 0xab, 0xb3, 0xe9, 0xab, 0xb5, 0xe9, 0xab, 0xb9, 0xe9, 0xab, 0xba,
  0xe9, 0xab, 0xbd, 0xe9, 0xab, 0xbf, 0xe9, 0xac, 0x80, 0xe9, 0xac, 0x81,
  0xe9, 0xac, 0x82, 0xe9, 0xac, 0x83
};

unsigned char jis_x0212_row_74_converted_to_utf8[] = {
  0xe9, 0xac, 0x84, 0xe9, 0xac, 0x85, 0xe9, 0xac, 0x88, 0xe9, 0xac, 0x89,
  0xe9, 0xac, 0x8b, 0xe9, 0xac, 0x8c, 0xe9, 0xac, 0x8d, 0xe9, 0xac, 0x8e,
  0xe9, 0xac, 0x90, 0xe9, 0xac, 0x92, 0xe9, 0xac, 0x96, 0xe9, 0xac, 0x99,
  0xe9, 0xac, 0x9b, 0xe9, 0xac, 0x9c, 0xe9, 0xac, 0xa0, 0xe9, 0xac, 0xa6,
  0xe9, 0xac, 0xab, 0xe9, 0xac, 0xad, 0xe9, 0xac, 0xb3, 0xe9, 0xac, 0xb4,
  0xe9, 0xac, 0xb5, 0xe9, 0xac, 0xb7, 0xe9, 0xac, 0xb9, 0xe9, 0xac, 0xba,
  0xe9, 0xac, 0xbd, 0xe9, 0xad, 0x88, 0xe9, 0xad, 0x8b, 0xe9, 0xad, 0x8c,
  0xe9, 0xad, 0x95, 0xe9, 0xad, 0x96, 0xe9, 0xad, 0x97, 0xe9, 0xad, 0x9b,
  0xe9, 0xad, 0x9e, 0xe9, 0xad, 0xa1, 0xe9, 0xad, 0xa3, 0xe9, 0xad, 0xa5,
  0xe9, 0xad, 0xa6, 0xe9, 0xad, 0xa8, 0xe9, 0xad, 0xaa, 0xe9, 0xad, 0xab,
  0xe9, 0xad, 0xac, 0xe9, 0xad, 0xad, 0xe9, 0xad, 0xae, 0xe9, 0xad, 0xb3,
  0xe9, 0xad, 0xb5, 0xe9, 0xad, 0xb7, 0xe9, 0xad, 0xb8, 0xe9, 0xad, 0xb9,
  0xe9, 0xad, 0xbf, 0xe9, 0xae, 0x80, 0xe9, 0xae, 0x84, 0xe9, 0xae, 0x85,
  0xe9, 0xae, 0x86, 0xe9, 0xae, 0x87, 0xe9, 0xae, 0x89, 0xe9, 0xae, 0x8a,
  0xe9, 0xae, 0x8b, 0xe9, 0xae, 0x8d, 0xe9, 0xae, 0x8f, 0xe9, 0xae, 0x90,
  0xe9, 0xae, 0x94, 0xe9, 0xae, 0x9a, 0xe9, 0xae, 0x9d, 0xe9, 0xae, 0x9e,
  0xe9, 0xae, 0xa6, 0xe9, 0xae, 0xa7, 0xe9, 0xae, 0xa9, 0xe9, 0xae, 0xac,
  0xe9, 0xae, 0xb0, 0xe9, 0xae, 0xb1, 0xe9, 0xae, 0xb2, 0xe9, 0xae, 0xb7,
  0xe9, 0xae, 0xb8, 0xe9, 0xae, 0xbb, 0xe9, 0xae, 0xbc, 0xe9, 0xae, 0xbe,
  0xe9, 0xae, 0xbf, 0xe9, 0xaf, 0x81, 0xe9, 0xaf, 0x87, 0xe9, 0xaf, 0x88,
  0xe9, 0xaf, 0x8e, 0xe9, 0xaf, 0x90, 0xe9, 0xaf, 0x97, 0xe9, 0xaf, 0x98,
  0xe9, 0xaf, 0x9d, 0xe9, 0xaf, 0x9f, 0xe9, 0xaf, 0xa5, 0xe9, 0xaf, 0xa7,
  0xe9, 0xaf, 0xaa, 0xe9, 0xaf, 0xab, 0xe9, 0xaf, 0xaf, 0xe9, 0xaf, 0xb3,
  0xe9, 0xaf, 0xb7, 0xe9, 0xaf, 0xb8
};

unsigned char jis_x0212_row_75_converted_to_utf8[] = {
  0xe9, 0xaf, 0xb9, 0xe9, 0xaf, 0xba, 0xe9, 0xaf, 0xbd, 0xe9, 0xaf, 0xbf,
  0xe9, 0xb0, 0x80, 0xe9, 0xb0, 0x82, 0xe9, 0xb0, 0x8b, 0xe9, 0xb0, 0x8f,
  0xe9, 0xb0, 0x91, 0xe9, 0xb0, 0x96, 0xe9, 0xb0, 0x98, 0xe9, 0xb0, 0x99,
  0xe9, 0xb0, 0x9a, 0xe9, 0xb0, 0x9c, 0xe9, 0xb0, 0x9e, 0xe9, 0xb0, 0xa2,
  0xe9, 0xb0, 0xa3, 0xe9, 0xb0, 0xa6, 0xe9, 0xb0, 0xa7, 0xe9, 0xb0, 0xa8,
  0xe9, 0xb0, 0xa9, 0xe9, 0xb0, 0xaa, 0xe9, 0xb0, 0xb1, 0xe9, 0xb0, 0xb5,
  0xe9, 0xb0, 0xb6, 0xe9, 0xb0, 0xb7, 0xe9, 0xb0, 0xbd, 0xe9, 0xb1, 0x81,
  0xe9, 0xb1, 0x83, 0xe9, 0xb1, 0x84, 0xe9, 0xb1, 0x85, 0xe9, 0xb1, 0x89,
  0xe9, 0xb1, 0x8a, 0xe9, 0xb1, 0x8e, 0xe9, 0xb1, 0x8f, 0xe9, 0xb1, 0x90,
  0xe9, 0xb1, 0x93, 0xe9, 0xb1, 0x94, 0xe9, 0xb1, 0x96, 0xe9, 0xb1, 0x98,
  0xe9, 0xb1, 0x9b, 0xe9, 0xb1, 0x9d, 0xe9, 0xb1, 0x9e, 0xe9, 0xb1, 0x9f,
  0xe9, 0xb1, 0xa3, 0xe9, 0xb1, 0xa9, 0xe9, 0xb1, 0xaa, 0xe9, 0xb1, 0x9c,
  0xe9, 0xb1, 0xab, 0xe9, 0xb1, 0xa8, 0xe9, 0xb1, 0xae, 0xe9, 0xb1, 0xb0,
  0xe9, 0xb1, 0xb2, 0xe9, 0xb1, 0xb5, 0xe9, 0xb1, 0xb7, 0xe9, 0xb1, 0xbb,
  0xe9, 0xb3, 0xa6, 0xe9, 0xb3, 0xb2, 0xe9, 0xb3, 0xb7, 0xe9, 0xb3, 0xb9,
  0xe9, 0xb4, 0x8b, 0xe9, 0xb4, 0x82, 0xe9, 0xb4, 0x91, 0xe9, 0xb4, 0x97,
  0xe9, 0xb4, 0x98, 0xe9, 0xb4, 0x9c, 0xe9, 0xb4, 0x9d, 0xe9, 0xb4, 0x9e,
  0xe9, 0xb4, 0xaf, 0xe9, 0xb4, 0xb0, 0xe9, 0xb4, 0xb2, 0xe9, 0xb4, 0xb3,
  0xe9, 0xb4, 0xb4, 0xe9, 0xb4, 0xba, 0xe9, 0xb4, 0xbc, 0xe9, 0xb5, 0x85,
  0xe9, 0xb4, 0xbd, 0xe9, 0xb5, 0x82, 0xe9, 0xb5, 0x83, 0xe9, 0xb5, 0x87,
  0xe9, 0xb5, 0x8a, 0xe9, 0xb5, 0x93, 0xe9, 0xb5, 0x94, 0xe9, 0xb5, 0x9f,
  0xe9, 0xb5, 0xa3, 0xe9, 0xb5, 0xa2, 0xe9, 0xb5, 0xa5, 0xe9, 0xb5, 0xa9,
  0xe9, 0xb5, 0xaa, 0xe9, 0xb5, 0xab, 0xe9, 0xb5, 0xb0, 0xe9, 0xb5, 0xb6,
  0xe9, 0xb5, 0xb7, 0xe9, 0xb5, 0xbb
};

unsigned char jis_x0212_row_76_converted_to_utf8[] = {
  0xe9, 0xb5, 0xbc, 0xe9, 0xb5, 0xbe, 0xe9, 0xb6, 0x83, 0xe9, 0xb6, 0x84,
  0xe9, 0xb6, 0x86, 0xe9, 0xb6, 0x8a, 0xe9, 0xb6, 0x8d, 0xe9, 0xb6, 0x8e,
  0xe9, 0xb6, 0x92, 0xe9, 0xb6, 0x93, 0xe9, 0xb6, 0x95, 0xe9, 0xb6, 0x96,
  0xe9, 0xb6, 0x97, 0xe9, 0xb6, 0x98, 0xe9, 0xb6, 0xa1, 0xe9, 0xb6, 0xaa,
  0xe9, 0xb6, 0xac, 0xe9, 0xb6, 0xae, 0xe9, 0xb6, 0xb1, 0xe9, 0xb6, 0xb5,
  0xe9, 0xb6, 0xb9, 0xe9, 0xb6, 0xbc, 0xe9, 0xb6, 0xbf, 0xe9, 0xb7, 0x83,
  0xe9, 0xb7, 0x87, 0xe9, 0xb7, 0x89, 0xe9, 0xb7, 0x8a, 0xe9, 0xb7, 0x94,
  0xe9, 0xb7, 0x95, 0xe9, 0xb7, 0x96, 0xe9, 0xb7, 0x97, 0xe9, 0xb7, 0x9a,
  0xe9, 0xb7, 0x9e, 0xe9, 0xb7, 0x9f, 0xe9, 0xb7, 0xa0, 0xe9, 0xb7, 0xa5,
  0xe9, 0xb7, 0xa7, 0xe9, 0xb7, 0xa9, 0xe9, 0xb7, 0xab, 0xe9, 0xb7, 0xae,
  0xe9, 0xb7, 0xb0, 0xe9, 0xb7, 0xb3, 0xe9, 0xb7, 0xb4, 0xe9, 0xb7, 0xbe,
  0xe9, 0xb8, 0x8a, 0xe9, 0xb8, 0x82, 0xe9, 0xb8, 0x87, 0xe9, 0xb8, 0x8e,
  0xe9, 0xb8, 0x90, 0xe9, 0xb8, 0x91, 0xe9, 0xb8, 0x92, 0xe9, 0xb8, 0x95,
  0xe9, 0xb8, 0x96, 0xe9, 0xb8, 0x99, 0xe9, 0xb8, 0x9c, 0xe9, 0xb8, 0x9d,
  0xe9, 0xb9, 0xba, 0xe9, 0xb9, 0xbb, 0xe9, 0xb9, 0xbc, 0xe9, 0xba, 0x80,
  0xe9, 0xba, 0x82, 0xe9, 0xba, 0x83, 0xe9, 0xba, 0x84, 0xe9, 0xba, 0x85,
  0xe9, 0xba, 0x87, 0xe9, 0xba, 0x8e, 0xe9, 0xba, 0x8f, 0xe9, 0xba, 0x96,
  0xe9, 0xba, 0x98, 0xe9, 0xba, 0x9b, 0xe9, 0xba, 0x9e, 0xe9, 0xba, 0xa4,
  0xe9, 0xba, 0xa8, 0xe9, 0xba, 0xac, 0xe9, 0xba, 0xae, 0xe9, 0xba, 0xaf,
  0xe9, 0xba, 0xb0, 0xe9, 0xba, 0xb3, 0xe9, 0xba, 0xb4, 0xe9, 0xba, 0xb5,
  0xe9, 0xbb, 0x86, 0xe9, 0xbb, 0x88, 0xe9, 0xbb, 0x8b, 0xe9, 0xbb, 0x95,
  0xe9, 0xbb, 0x9f, 0xe9, 0xbb, 0xa4, 0xe9, 0xbb, 0xa7, 0xe9, 0xbb, 0xac,
  0xe9, 0xbb, 0xad, 0xe9, 0xbb, 0xae, 0xe9, 0xbb, 0xb0, 0xe9, 0xbb, 0xb1,
  0xe9, 0xbb, 0xb2, 0xe9, 0xbb, 0xb5
};

unsigned char jis_x0212_row_77_converted_to_utf8[] = {
  0xe9, 0xbb, 0xb8, 0xe9, 0xbb, 0xbf, 0xe9, 0xbc, 0x82, 0xe9, 0xbc, 0x83,
  0xe9, 0xbc, 0x89, 0xe9, 0xbc, 0x8f, 0xe9, 0xbc, 0x90, 0xe9, 0xbc, 0x91,
  0xe9, 0xbc, 0x92, 0xe9, 0xbc, 0x94, 0xe9, 0xbc, 0x96, 0xe9, 0xbc, 0x97,
  0xe9, 0xbc, 0x99, 0xe9, 0xbc, 0x9a, 0xe9, 0xbc, 0x9b, 0xe9, 0xbc, 0x9f,
  0xe9, 0xbc, 0xa2, 0xe9, 0xbc, 0xa6, 0xe9, 0xbc, 0xaa, 0xe9, 0xbc, 0xab,
  0xe9, 0xbc, 0xaf, 0xe9, 0xbc, 0xb1, 0xe9, 0xbc, 0xb2, 0xe9, 0xbc, 0xb4,
  0xe9, 0xbc, 0xb7, 0xe9, 0xbc, 0xb9, 0xe9, 0xbc, 0xba, 0xe9, 0xbc, 0xbc,
  0xe9, 0xbc, 0xbd, 0xe9, 0xbc, 0xbf, 0xe9, 0xbd, 0x81, 0xe9, 0xbd, 0x83,
  0xe9, 0xbd, 0x84, 0xe9, 0xbd, 0x85, 0xe9, 0xbd, 0x86, 0xe9, 0xbd, 0x87,
  0xe9, 0xbd, 0x93, 0xe9, 0xbd, 0x95, 0xe9, 0xbd, 0x96, 0xe9, 0xbd, 0x97,
  0xe9, 0xbd, 0x98, 0xe9, 0xbd, 0x9a, 0xe9, 0xbd, 0x9d, 0xe9, 0xbd, 0x9e,
  0xe9, 0xbd, 0xa8, 0xe9, 0xbd, 0xa9, 0xe9, 0xbd, 0xad, 0xe9, 0xbd, 0xae,
  0xe9, 0xbd, 0xaf, 0xe9, 0xbd, 0xb0, 0xe9, 0xbd, 0xb1, 0xe9, 0xbd, 0xb3,
  0xe9, 0xbd, 0xb5, 0xe9, 0xbd, 0xba, 0xe9, 0xbd, 0xbd, 0xe9, 0xbe, 0x8f,
  0xe9, 0xbe, 0x90, 0xe9, 0xbe, 0x91, 0xe9, 0xbe, 0x92, 0xe9, 0xbe, 0x94,
  0xe9, 0xbe, 0x96, 0xe9, 0xbe, 0x97, 0xe9, 0xbe, 0x9e, 0xe9, 0xbe, 0xa1,
  0xe9, 0xbe, 0xa2, 0xe9, 0xbe, 0xa3, 0xe9, 0xbe, 0xa5
};


#endif
