// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: private/pbservice/service.proto

package pbservice

import (
	pbcommon "github.com/hashicorp/consul/proto/private/pbcommon"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ConnectProxyConfig describes the configuration needed for any proxy managed
// or unmanaged. It describes a single logical service's listener and optionally
// upstreams and sidecar-related config for a single instance. To describe a
// centralized proxy that routed traffic for multiple services, a different one
// of these would be needed for each, sharing the same LogicalProxyID.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ConnectProxyConfig
// output=service.gen.go
// name=Structs
// ignore-fields=MutualTLSMode
type ConnectProxyConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// DestinationServiceName is required and is the name of the service to accept
	// traffic for.
	DestinationServiceName string `protobuf:"bytes,1,opt,name=DestinationServiceName,proto3" json:"DestinationServiceName,omitempty"`
	// DestinationServiceID is optional and should only be specified for
	// "side-car" style proxies where the proxy is in front of just a single
	// instance of the service. It should be set to the service ID of the instance
	// being represented which must be registered to the same agent. It's valid to
	// provide a service ID that does not yet exist to avoid timing issues when
	// bootstrapping a service with a proxy.
	DestinationServiceID string `protobuf:"bytes,2,opt,name=DestinationServiceID,proto3" json:"DestinationServiceID,omitempty"`
	// LocalServiceAddress is the address of the local service instance. It is
	// optional and should only be specified for "side-car" style proxies. It will
	// default to 127.0.0.1 if the proxy is a "side-car" (DestinationServiceID is
	// set) but otherwise will be ignored.
	LocalServiceAddress string `protobuf:"bytes,3,opt,name=LocalServiceAddress,proto3" json:"LocalServiceAddress,omitempty"`
	// LocalServicePort is the port of the local service instance. It is optional
	// and should only be specified for "side-car" style proxies. It will default
	// to the registered port for the instance if the proxy is a "side-car"
	// (DestinationServiceID is set) but otherwise will be ignored.
	// mog: func-to=int func-from=int32
	LocalServicePort int32 `protobuf:"varint,4,opt,name=LocalServicePort,proto3" json:"LocalServicePort,omitempty"`
	// Config is the arbitrary configuration data provided with the proxy
	// registration.
	// mog: func-to=ProtobufTypesStructToMapStringInterface func-from=MapStringInterfaceToProtobufTypesStruct
	Config *structpb.Struct `protobuf:"bytes,5,opt,name=Config,proto3" json:"Config,omitempty"`
	// Upstreams describes any upstream dependencies the proxy instance should
	// setup.
	// mog: func-to=UpstreamsToStructs func-from=NewUpstreamsFromStructs
	Upstreams []*Upstream `protobuf:"bytes,6,rep,name=Upstreams,proto3" json:"Upstreams,omitempty"`
	// MeshGateway defines the mesh gateway configuration for upstreams
	MeshGateway *MeshGatewayConfig `protobuf:"bytes,7,opt,name=MeshGateway,proto3" json:"MeshGateway,omitempty"`
	// Expose defines whether checks or paths are exposed through the proxy
	Expose *ExposeConfig `protobuf:"bytes,8,opt,name=Expose,proto3" json:"Expose,omitempty"`
	// Mode represents how the proxy's inbound and upstream listeners are dialed.
	// mog: func-to=structs.ProxyMode func-from=string
	Mode string `protobuf:"bytes,9,opt,name=Mode,proto3" json:"Mode,omitempty"`
	// TransparentProxy defines configuration for when the proxy is in
	// transparent mode.
	TransparentProxy *TransparentProxyConfig `protobuf:"bytes,10,opt,name=TransparentProxy,proto3" json:"TransparentProxy,omitempty"`
	// LocalServiceSocketPath is the path to the unix domain socket for the local service instance
	LocalServiceSocketPath string `protobuf:"bytes,11,opt,name=LocalServiceSocketPath,proto3" json:"LocalServiceSocketPath,omitempty"`
	// mog: func-to=EnvoyExtensionsToStructs func-from=EnvoyExtensionsFromStructs
	EnvoyExtensions []*pbcommon.EnvoyExtension `protobuf:"bytes,12,rep,name=EnvoyExtensions,proto3" json:"EnvoyExtensions,omitempty"`
	// AccessLogsConfig defines envoys access log configuration.
	AccessLogs    *AccessLogsConfig `protobuf:"bytes,13,opt,name=AccessLogs,proto3" json:"AccessLogs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConnectProxyConfig) Reset() {
	*x = ConnectProxyConfig{}
	mi := &file_private_pbservice_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectProxyConfig) ProtoMessage() {}

func (x *ConnectProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectProxyConfig.ProtoReflect.Descriptor instead.
func (*ConnectProxyConfig) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{0}
}

func (x *ConnectProxyConfig) GetDestinationServiceName() string {
	if x != nil {
		return x.DestinationServiceName
	}
	return ""
}

func (x *ConnectProxyConfig) GetDestinationServiceID() string {
	if x != nil {
		return x.DestinationServiceID
	}
	return ""
}

func (x *ConnectProxyConfig) GetLocalServiceAddress() string {
	if x != nil {
		return x.LocalServiceAddress
	}
	return ""
}

func (x *ConnectProxyConfig) GetLocalServicePort() int32 {
	if x != nil {
		return x.LocalServicePort
	}
	return 0
}

func (x *ConnectProxyConfig) GetConfig() *structpb.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ConnectProxyConfig) GetUpstreams() []*Upstream {
	if x != nil {
		return x.Upstreams
	}
	return nil
}

func (x *ConnectProxyConfig) GetMeshGateway() *MeshGatewayConfig {
	if x != nil {
		return x.MeshGateway
	}
	return nil
}

func (x *ConnectProxyConfig) GetExpose() *ExposeConfig {
	if x != nil {
		return x.Expose
	}
	return nil
}

func (x *ConnectProxyConfig) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *ConnectProxyConfig) GetTransparentProxy() *TransparentProxyConfig {
	if x != nil {
		return x.TransparentProxy
	}
	return nil
}

func (x *ConnectProxyConfig) GetLocalServiceSocketPath() string {
	if x != nil {
		return x.LocalServiceSocketPath
	}
	return ""
}

func (x *ConnectProxyConfig) GetEnvoyExtensions() []*pbcommon.EnvoyExtension {
	if x != nil {
		return x.EnvoyExtensions
	}
	return nil
}

func (x *ConnectProxyConfig) GetAccessLogs() *AccessLogsConfig {
	if x != nil {
		return x.AccessLogs
	}
	return nil
}

// Upstream represents a single upstream dependency for a service or proxy. It
// describes the mechanism used to discover instances to communicate with (the
// Target) as well as any potential client configuration that may be useful such
// as load balancer options, timeouts etc.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.Upstream
// output=service.gen.go
// name=Structs
// ignore-fields=IngressHosts
type Upstream struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Destination fields are the required ones for determining what this upstream
	// points to. Depending on DestinationType some other fields below might
	// further restrict the set of instances allowable.
	//
	// DestinationType would be better as an int constant but even with custom
	// JSON marshallers it causes havoc with all the mapstructure mangling we do
	// on service definitions in various places.
	DestinationType      string `protobuf:"bytes,1,opt,name=DestinationType,proto3" json:"DestinationType,omitempty"`
	DestinationNamespace string `protobuf:"bytes,2,opt,name=DestinationNamespace,proto3" json:"DestinationNamespace,omitempty"`
	DestinationPartition string `protobuf:"bytes,12,opt,name=DestinationPartition,proto3" json:"DestinationPartition,omitempty"`
	DestinationPeer      string `protobuf:"bytes,13,opt,name=DestinationPeer,proto3" json:"DestinationPeer,omitempty"`
	DestinationName      string `protobuf:"bytes,3,opt,name=DestinationName,proto3" json:"DestinationName,omitempty"`
	// Datacenter that the service discovery request should be run against. Note
	// for prepared queries, the actual results might be from a different
	// datacenter.
	Datacenter string `protobuf:"bytes,4,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
	// LocalBindAddress is the ip address a side-car proxy should listen on for
	// traffic destined for this upstream service. Default if empty is 127.0.0.1.
	LocalBindAddress string `protobuf:"bytes,5,opt,name=LocalBindAddress,proto3" json:"LocalBindAddress,omitempty"`
	// LocalBindPort is the ip address a side-car proxy should listen on for
	// traffic destined for this upstream service. Required.
	// mog: func-to=int func-from=int32
	LocalBindPort int32 `protobuf:"varint,6,opt,name=LocalBindPort,proto3" json:"LocalBindPort,omitempty"`
	// Config is an opaque config that is specific to the proxy process being run.
	// It can be used to pass arbitrary configuration for this specific upstream
	// to the proxy.
	// mog: func-to=ProtobufTypesStructToMapStringInterface func-from=MapStringInterfaceToProtobufTypesStruct
	Config *structpb.Struct `protobuf:"bytes,7,opt,name=Config,proto3" json:"Config,omitempty"`
	// MeshGateway is the configuration for mesh gateway usage of this upstream
	MeshGateway *MeshGatewayConfig `protobuf:"bytes,8,opt,name=MeshGateway,proto3" json:"MeshGateway,omitempty"`
	// CentrallyConfigured indicates whether the upstream was defined in a proxy
	// instance registration or whether it was generated from a config entry.
	CentrallyConfigured bool `protobuf:"varint,9,opt,name=CentrallyConfigured,proto3" json:"CentrallyConfigured,omitempty"`
	// LocalBindSocketPath is the socket to create to connect to the upstream service
	LocalBindSocketPath string `protobuf:"bytes,10,opt,name=LocalBindSocketPath,proto3" json:"LocalBindSocketPath,omitempty"`
	LocalBindSocketMode string `protobuf:"bytes,11,opt,name=LocalBindSocketMode,proto3" json:"LocalBindSocketMode,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Upstream) Reset() {
	*x = Upstream{}
	mi := &file_private_pbservice_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Upstream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Upstream) ProtoMessage() {}

func (x *Upstream) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Upstream.ProtoReflect.Descriptor instead.
func (*Upstream) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{1}
}

func (x *Upstream) GetDestinationType() string {
	if x != nil {
		return x.DestinationType
	}
	return ""
}

func (x *Upstream) GetDestinationNamespace() string {
	if x != nil {
		return x.DestinationNamespace
	}
	return ""
}

func (x *Upstream) GetDestinationPartition() string {
	if x != nil {
		return x.DestinationPartition
	}
	return ""
}

func (x *Upstream) GetDestinationPeer() string {
	if x != nil {
		return x.DestinationPeer
	}
	return ""
}

func (x *Upstream) GetDestinationName() string {
	if x != nil {
		return x.DestinationName
	}
	return ""
}

func (x *Upstream) GetDatacenter() string {
	if x != nil {
		return x.Datacenter
	}
	return ""
}

func (x *Upstream) GetLocalBindAddress() string {
	if x != nil {
		return x.LocalBindAddress
	}
	return ""
}

func (x *Upstream) GetLocalBindPort() int32 {
	if x != nil {
		return x.LocalBindPort
	}
	return 0
}

func (x *Upstream) GetConfig() *structpb.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Upstream) GetMeshGateway() *MeshGatewayConfig {
	if x != nil {
		return x.MeshGateway
	}
	return nil
}

func (x *Upstream) GetCentrallyConfigured() bool {
	if x != nil {
		return x.CentrallyConfigured
	}
	return false
}

func (x *Upstream) GetLocalBindSocketPath() string {
	if x != nil {
		return x.LocalBindSocketPath
	}
	return ""
}

func (x *Upstream) GetLocalBindSocketMode() string {
	if x != nil {
		return x.LocalBindSocketMode
	}
	return ""
}

// ServiceConnect are the shared Connect settings between all service
// definitions from the agent to the state store.
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceConnect
// output=service.gen.go
// name=Structs
type ServiceConnect struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Native is true when this service can natively understand Connect.
	Native bool `protobuf:"varint,1,opt,name=Native,proto3" json:"Native,omitempty"`
	// SidecarService is a nested Service Definition to register at the same time.
	// It's purely a convenience mechanism to allow specifying a sidecar service
	// along with the application service definition. It's nested nature allows
	// all of the fields to be defaulted which can reduce the amount of
	// boilerplate needed to register a sidecar service separately, but the end
	// result is identical to just making a second service registration via any
	// other means.
	// mog: func-to=ServiceDefinitionPtrToStructs func-from=NewServiceDefinitionPtrFromStructs
	SidecarService *ServiceDefinition  `protobuf:"bytes,3,opt,name=SidecarService,proto3" json:"SidecarService,omitempty"`
	PeerMeta       *PeeringServiceMeta `protobuf:"bytes,4,opt,name=PeerMeta,proto3" json:"PeerMeta,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ServiceConnect) Reset() {
	*x = ServiceConnect{}
	mi := &file_private_pbservice_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceConnect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConnect) ProtoMessage() {}

func (x *ServiceConnect) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConnect.ProtoReflect.Descriptor instead.
func (*ServiceConnect) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{2}
}

func (x *ServiceConnect) GetNative() bool {
	if x != nil {
		return x.Native
	}
	return false
}

func (x *ServiceConnect) GetSidecarService() *ServiceDefinition {
	if x != nil {
		return x.SidecarService
	}
	return nil
}

func (x *ServiceConnect) GetPeerMeta() *PeeringServiceMeta {
	if x != nil {
		return x.PeerMeta
	}
	return nil
}

// PeeringServiceMeta is read-only information provided from an exported peer.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.PeeringServiceMeta
// output=service.gen.go
// name=Structs
type PeeringServiceMeta struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	SNI           []string               `protobuf:"bytes,1,rep,name=SNI,proto3" json:"SNI,omitempty"`
	SpiffeID      []string               `protobuf:"bytes,2,rep,name=SpiffeID,proto3" json:"SpiffeID,omitempty"`
	Protocol      string                 `protobuf:"bytes,3,opt,name=Protocol,proto3" json:"Protocol,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PeeringServiceMeta) Reset() {
	*x = PeeringServiceMeta{}
	mi := &file_private_pbservice_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PeeringServiceMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringServiceMeta) ProtoMessage() {}

func (x *PeeringServiceMeta) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringServiceMeta.ProtoReflect.Descriptor instead.
func (*PeeringServiceMeta) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{3}
}

func (x *PeeringServiceMeta) GetSNI() []string {
	if x != nil {
		return x.SNI
	}
	return nil
}

func (x *PeeringServiceMeta) GetSpiffeID() []string {
	if x != nil {
		return x.SpiffeID
	}
	return nil
}

func (x *PeeringServiceMeta) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

// ExposeConfig describes HTTP paths to expose through Envoy outside of Connect.
// Users can expose individual paths and/or all HTTP/GRPC paths for checks.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ExposeConfig
// output=service.gen.go
// name=Structs
type ExposeConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Checks defines whether paths associated with Consul checks will be exposed.
	// This flag triggers exposing all HTTP and GRPC check paths registered for the service.
	Checks bool `protobuf:"varint,1,opt,name=Checks,proto3" json:"Checks,omitempty"`
	// Paths is the list of paths exposed through the proxy.
	// mog: func-to=ExposePathSliceToStructs func-from=NewExposePathSliceFromStructs
	Paths         []*ExposePath `protobuf:"bytes,2,rep,name=Paths,proto3" json:"Paths,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExposeConfig) Reset() {
	*x = ExposeConfig{}
	mi := &file_private_pbservice_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExposeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExposeConfig) ProtoMessage() {}

func (x *ExposeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExposeConfig.ProtoReflect.Descriptor instead.
func (*ExposeConfig) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{4}
}

func (x *ExposeConfig) GetChecks() bool {
	if x != nil {
		return x.Checks
	}
	return false
}

func (x *ExposeConfig) GetPaths() []*ExposePath {
	if x != nil {
		return x.Paths
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ExposePath
// output=service.gen.go
// name=Structs
type ExposePath struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ListenerPort defines the port of the proxy's listener for exposed paths.
	// mog: func-to=int func-from=int32
	ListenerPort int32 `protobuf:"varint,1,opt,name=ListenerPort,proto3" json:"ListenerPort,omitempty"`
	// ExposePath is the path to expose through the proxy, ie. "/metrics."
	Path string `protobuf:"bytes,2,opt,name=Path,proto3" json:"Path,omitempty"`
	// LocalPathPort is the port that the service is listening on for the given path.
	// mog: func-to=int func-from=int32
	LocalPathPort int32 `protobuf:"varint,3,opt,name=LocalPathPort,proto3" json:"LocalPathPort,omitempty"`
	// Protocol describes the upstream's service protocol.
	// Valid values are "http" and "http2", defaults to "http"
	Protocol string `protobuf:"bytes,4,opt,name=Protocol,proto3" json:"Protocol,omitempty"`
	// ParsedFromCheck is set if this path was parsed from a registered check
	ParsedFromCheck bool `protobuf:"varint,5,opt,name=ParsedFromCheck,proto3" json:"ParsedFromCheck,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ExposePath) Reset() {
	*x = ExposePath{}
	mi := &file_private_pbservice_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExposePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExposePath) ProtoMessage() {}

func (x *ExposePath) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExposePath.ProtoReflect.Descriptor instead.
func (*ExposePath) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{5}
}

func (x *ExposePath) GetListenerPort() int32 {
	if x != nil {
		return x.ListenerPort
	}
	return 0
}

func (x *ExposePath) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ExposePath) GetLocalPathPort() int32 {
	if x != nil {
		return x.LocalPathPort
	}
	return 0
}

func (x *ExposePath) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *ExposePath) GetParsedFromCheck() bool {
	if x != nil {
		return x.ParsedFromCheck
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.MeshGatewayConfig
// output=service.gen.go
// name=Structs
type MeshGatewayConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// mog: func-to=structs.MeshGatewayMode func-from=string
	Mode          string `protobuf:"bytes,1,opt,name=Mode,proto3" json:"Mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshGatewayConfig) Reset() {
	*x = MeshGatewayConfig{}
	mi := &file_private_pbservice_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshGatewayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshGatewayConfig) ProtoMessage() {}

func (x *MeshGatewayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshGatewayConfig.ProtoReflect.Descriptor instead.
func (*MeshGatewayConfig) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{6}
}

func (x *MeshGatewayConfig) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.TransparentProxyConfig
// output=service.gen.go
// name=Structs
type TransparentProxyConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// mog: func-to=int func-from=int32
	OutboundListenerPort int32 `protobuf:"varint,1,opt,name=OutboundListenerPort,proto3" json:"OutboundListenerPort,omitempty"`
	// DialedDirectly indicates whether transparent proxies can dial this proxy instance directly.
	// The discovery chain is not considered when dialing a service instance directly.
	// This setting is useful when addressing stateful services, such as a database cluster with a leader node.
	DialedDirectly bool `protobuf:"varint,2,opt,name=DialedDirectly,proto3" json:"DialedDirectly,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *TransparentProxyConfig) Reset() {
	*x = TransparentProxyConfig{}
	mi := &file_private_pbservice_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TransparentProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransparentProxyConfig) ProtoMessage() {}

func (x *TransparentProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransparentProxyConfig.ProtoReflect.Descriptor instead.
func (*TransparentProxyConfig) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{7}
}

func (x *TransparentProxyConfig) GetOutboundListenerPort() int32 {
	if x != nil {
		return x.OutboundListenerPort
	}
	return 0
}

func (x *TransparentProxyConfig) GetDialedDirectly() bool {
	if x != nil {
		return x.DialedDirectly
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.AccessLogsConfig
// output=service.gen.go
// name=Structs
type AccessLogsConfig struct {
	state               protoimpl.MessageState `protogen:"open.v1"`
	Enabled             bool                   `protobuf:"varint,1,opt,name=Enabled,proto3" json:"Enabled,omitempty"`
	DisableListenerLogs bool                   `protobuf:"varint,2,opt,name=DisableListenerLogs,proto3" json:"DisableListenerLogs,omitempty"`
	// Type represents the desired envoy log sink (e.g. stdout, stderr, file ...).
	// mog: func-to=structs.LogSinkType func-from=string
	Type          string `protobuf:"bytes,3,opt,name=Type,proto3" json:"Type,omitempty"`
	Path          string `protobuf:"bytes,4,opt,name=Path,proto3" json:"Path,omitempty"`
	JSONFormat    string `protobuf:"bytes,5,opt,name=JSONFormat,proto3" json:"JSONFormat,omitempty"`
	TextFormat    string `protobuf:"bytes,6,opt,name=TextFormat,proto3" json:"TextFormat,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AccessLogsConfig) Reset() {
	*x = AccessLogsConfig{}
	mi := &file_private_pbservice_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessLogsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessLogsConfig) ProtoMessage() {}

func (x *AccessLogsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessLogsConfig.ProtoReflect.Descriptor instead.
func (*AccessLogsConfig) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{8}
}

func (x *AccessLogsConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *AccessLogsConfig) GetDisableListenerLogs() bool {
	if x != nil {
		return x.DisableListenerLogs
	}
	return false
}

func (x *AccessLogsConfig) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AccessLogsConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *AccessLogsConfig) GetJSONFormat() string {
	if x != nil {
		return x.JSONFormat
	}
	return ""
}

func (x *AccessLogsConfig) GetTextFormat() string {
	if x != nil {
		return x.TextFormat
	}
	return ""
}

// ServiceDefinition is used to JSON decode the Service definitions. For
// documentation on specific fields see NodeService which is better documented.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceDefinition
// output=service.gen.go
// name=Structs
type ServiceDefinition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// mog: func-to=structs.ServiceKind func-from=string
	Kind    string   `protobuf:"bytes,1,opt,name=Kind,proto3" json:"Kind,omitempty"`
	ID      string   `protobuf:"bytes,2,opt,name=ID,proto3" json:"ID,omitempty"`
	Name    string   `protobuf:"bytes,3,opt,name=Name,proto3" json:"Name,omitempty"`
	Tags    []string `protobuf:"bytes,4,rep,name=Tags,proto3" json:"Tags,omitempty"`
	Address string   `protobuf:"bytes,5,opt,name=Address,proto3" json:"Address,omitempty"`
	// mog: func-to=MapStringServiceAddressToStructs func-from=NewMapStringServiceAddressFromStructs
	TaggedAddresses map[string]*ServiceAddress `protobuf:"bytes,16,rep,name=TaggedAddresses,proto3" json:"TaggedAddresses,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Meta            map[string]string          `protobuf:"bytes,6,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// mog: func-to=int func-from=int32
	Port int32 `protobuf:"varint,7,opt,name=Port,proto3" json:"Port,omitempty"`
	// Path for socket
	SocketPath string     `protobuf:"bytes,18,opt,name=SocketPath,proto3" json:"SocketPath,omitempty"`
	Check      *CheckType `protobuf:"bytes,8,opt,name=Check,proto3" json:"Check,omitempty"`
	// mog: func-to=CheckTypesToStructs func-from=NewCheckTypesFromStructs
	Checks []*CheckType `protobuf:"bytes,9,rep,name=Checks,proto3" json:"Checks,omitempty"`
	// mog: func-to=WeightsPtrToStructs func-from=NewWeightsPtrFromStructs
	Weights           *Weights `protobuf:"bytes,10,opt,name=Weights,proto3" json:"Weights,omitempty"`
	Token             string   `protobuf:"bytes,11,opt,name=Token,proto3" json:"Token,omitempty"`
	EnableTagOverride bool     `protobuf:"varint,12,opt,name=EnableTagOverride,proto3" json:"EnableTagOverride,omitempty"`
	// Proxy is the configuration set for Kind = connect-proxy. It is mandatory in
	// that case and an error to be set for any other kind. This config is part of
	// a proxy service definition and is distinct from but shares some fields with
	// the Connect.Proxy which configures a managed proxy as part of the actual
	// service's definition. This duplication is ugly but seemed better than the
	// alternative which was to re-use the same struct fields for both cases even
	// though the semantics are different and the non-shared fields make no sense
	// in the other case. ProxyConfig may be a more natural name here, but it's
	// confusing for the UX because one of the fields in ConnectProxyConfig is
	// also called just "Config"
	// mog: func-to=ConnectProxyConfigPtrToStructs func-from=NewConnectProxyConfigPtrFromStructs
	Proxy *ConnectProxyConfig `protobuf:"bytes,14,opt,name=Proxy,proto3" json:"Proxy,omitempty"`
	// mog: func-to=EnterpriseMetaToStructs func-from=NewEnterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,17,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	// mog: func-to=ServiceConnectPtrToStructs func-from=NewServiceConnectPtrFromStructs
	Connect *ServiceConnect `protobuf:"bytes,15,opt,name=Connect,proto3" json:"Connect,omitempty"`
	// Locality identifies where the service is running.
	// mog: func-to=LocalityToStructs func-from=LocalityFromStructs
	Locality *pbcommon.Locality `protobuf:"bytes,19,opt,name=Locality,proto3" json:"Locality,omitempty"`
	// Ports is a list of ports that the service exposes.
	// mog: func-to=PortsToStructs func-from=NewPortsFromStructs
	Ports         []*ServicePort `protobuf:"bytes,20,rep,name=Ports,proto3" json:"Ports,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceDefinition) Reset() {
	*x = ServiceDefinition{}
	mi := &file_private_pbservice_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceDefinition) ProtoMessage() {}

func (x *ServiceDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceDefinition.ProtoReflect.Descriptor instead.
func (*ServiceDefinition) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{9}
}

func (x *ServiceDefinition) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ServiceDefinition) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *ServiceDefinition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServiceDefinition) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ServiceDefinition) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ServiceDefinition) GetTaggedAddresses() map[string]*ServiceAddress {
	if x != nil {
		return x.TaggedAddresses
	}
	return nil
}

func (x *ServiceDefinition) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *ServiceDefinition) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *ServiceDefinition) GetSocketPath() string {
	if x != nil {
		return x.SocketPath
	}
	return ""
}

func (x *ServiceDefinition) GetCheck() *CheckType {
	if x != nil {
		return x.Check
	}
	return nil
}

func (x *ServiceDefinition) GetChecks() []*CheckType {
	if x != nil {
		return x.Checks
	}
	return nil
}

func (x *ServiceDefinition) GetWeights() *Weights {
	if x != nil {
		return x.Weights
	}
	return nil
}

func (x *ServiceDefinition) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ServiceDefinition) GetEnableTagOverride() bool {
	if x != nil {
		return x.EnableTagOverride
	}
	return false
}

func (x *ServiceDefinition) GetProxy() *ConnectProxyConfig {
	if x != nil {
		return x.Proxy
	}
	return nil
}

func (x *ServiceDefinition) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *ServiceDefinition) GetConnect() *ServiceConnect {
	if x != nil {
		return x.Connect
	}
	return nil
}

func (x *ServiceDefinition) GetLocality() *pbcommon.Locality {
	if x != nil {
		return x.Locality
	}
	return nil
}

func (x *ServiceDefinition) GetPorts() []*ServicePort {
	if x != nil {
		return x.Ports
	}
	return nil
}

// ServicePort contains the port information for a service.
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServicePort
// output=service.gen.go
// name=Structs
type ServicePort struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Port is the port number.
	// mog: func-to=int func-from=int32
	Port int32 `protobuf:"varint,1,opt,name=Port,proto3" json:"Port,omitempty"`
	// Name is the name of the port.
	Name string `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	// Default is true if this is the default port for the service.
	Default       bool `protobuf:"varint,3,opt,name=Default,proto3" json:"Default,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServicePort) Reset() {
	*x = ServicePort{}
	mi := &file_private_pbservice_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServicePort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePort) ProtoMessage() {}

func (x *ServicePort) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePort.ProtoReflect.Descriptor instead.
func (*ServicePort) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{10}
}

func (x *ServicePort) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *ServicePort) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServicePort) GetDefault() bool {
	if x != nil {
		return x.Default
	}
	return false
}

// Type to hold an address and port of a service
type ServiceAddress struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Address string                 `protobuf:"bytes,1,opt,name=Address,proto3" json:"Address,omitempty"`
	// mog: func-to=int func-from=int32
	Port          int32 `protobuf:"varint,2,opt,name=Port,proto3" json:"Port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceAddress) Reset() {
	*x = ServiceAddress{}
	mi := &file_private_pbservice_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAddress) ProtoMessage() {}

func (x *ServiceAddress) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAddress.ProtoReflect.Descriptor instead.
func (*ServiceAddress) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{11}
}

func (x *ServiceAddress) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ServiceAddress) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// Weights represent the weight used by DNS for a given status
type Weights struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// mog: func-to=int func-from=int32
	Passing int32 `protobuf:"varint,1,opt,name=Passing,proto3" json:"Passing,omitempty"`
	// mog: func-to=int func-from=int32
	Warning       int32 `protobuf:"varint,2,opt,name=Warning,proto3" json:"Warning,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Weights) Reset() {
	*x = Weights{}
	mi := &file_private_pbservice_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Weights) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Weights) ProtoMessage() {}

func (x *Weights) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Weights.ProtoReflect.Descriptor instead.
func (*Weights) Descriptor() ([]byte, []int) {
	return file_private_pbservice_service_proto_rawDescGZIP(), []int{12}
}

func (x *Weights) GetPassing() int32 {
	if x != nil {
		return x.Passing
	}
	return 0
}

func (x *Weights) GetWarning() int32 {
	if x != nil {
		return x.Warning
	}
	return 0
}

var File_private_pbservice_service_proto protoreflect.FileDescriptor

const file_private_pbservice_service_proto_rawDesc = "" +
	"\n" +
	"\x1fprivate/pbservice/service.proto\x12!hashicorp.consul.internal.service\x1a\x1cgoogle/protobuf/struct.proto\x1a\x1dprivate/pbcommon/common.proto\x1a#private/pbservice/healthcheck.proto\"\xdf\x06\n" +
	"\x12ConnectProxyConfig\x126\n" +
	"\x16DestinationServiceName\x18\x01 \x01(\tR\x16DestinationServiceName\x122\n" +
	"\x14DestinationServiceID\x18\x02 \x01(\tR\x14DestinationServiceID\x120\n" +
	"\x13LocalServiceAddress\x18\x03 \x01(\tR\x13LocalServiceAddress\x12*\n" +
	"\x10LocalServicePort\x18\x04 \x01(\x05R\x10LocalServicePort\x12/\n" +
	"\x06Config\x18\x05 \x01(\v2\x17.google.protobuf.StructR\x06Config\x12I\n" +
	"\tUpstreams\x18\x06 \x03(\v2+.hashicorp.consul.internal.service.UpstreamR\tUpstreams\x12V\n" +
	"\vMeshGateway\x18\a \x01(\v24.hashicorp.consul.internal.service.MeshGatewayConfigR\vMeshGateway\x12G\n" +
	"\x06Expose\x18\b \x01(\v2/.hashicorp.consul.internal.service.ExposeConfigR\x06Expose\x12\x12\n" +
	"\x04Mode\x18\t \x01(\tR\x04Mode\x12e\n" +
	"\x10TransparentProxy\x18\n" +
	" \x01(\v29.hashicorp.consul.internal.service.TransparentProxyConfigR\x10TransparentProxy\x126\n" +
	"\x16LocalServiceSocketPath\x18\v \x01(\tR\x16LocalServiceSocketPath\x12Z\n" +
	"\x0fEnvoyExtensions\x18\f \x03(\v20.hashicorp.consul.internal.common.EnvoyExtensionR\x0fEnvoyExtensions\x12S\n" +
	"\n" +
	"AccessLogs\x18\r \x01(\v23.hashicorp.consul.internal.service.AccessLogsConfigR\n" +
	"AccessLogs\"\x81\x05\n" +
	"\bUpstream\x12(\n" +
	"\x0fDestinationType\x18\x01 \x01(\tR\x0fDestinationType\x122\n" +
	"\x14DestinationNamespace\x18\x02 \x01(\tR\x14DestinationNamespace\x122\n" +
	"\x14DestinationPartition\x18\f \x01(\tR\x14DestinationPartition\x12(\n" +
	"\x0fDestinationPeer\x18\r \x01(\tR\x0fDestinationPeer\x12(\n" +
	"\x0fDestinationName\x18\x03 \x01(\tR\x0fDestinationName\x12\x1e\n" +
	"\n" +
	"Datacenter\x18\x04 \x01(\tR\n" +
	"Datacenter\x12*\n" +
	"\x10LocalBindAddress\x18\x05 \x01(\tR\x10LocalBindAddress\x12$\n" +
	"\rLocalBindPort\x18\x06 \x01(\x05R\rLocalBindPort\x12/\n" +
	"\x06Config\x18\a \x01(\v2\x17.google.protobuf.StructR\x06Config\x12V\n" +
	"\vMeshGateway\x18\b \x01(\v24.hashicorp.consul.internal.service.MeshGatewayConfigR\vMeshGateway\x120\n" +
	"\x13CentrallyConfigured\x18\t \x01(\bR\x13CentrallyConfigured\x120\n" +
	"\x13LocalBindSocketPath\x18\n" +
	" \x01(\tR\x13LocalBindSocketPath\x120\n" +
	"\x13LocalBindSocketMode\x18\v \x01(\tR\x13LocalBindSocketMode\"\xdf\x01\n" +
	"\x0eServiceConnect\x12\x16\n" +
	"\x06Native\x18\x01 \x01(\bR\x06Native\x12\\\n" +
	"\x0eSidecarService\x18\x03 \x01(\v24.hashicorp.consul.internal.service.ServiceDefinitionR\x0eSidecarService\x12Q\n" +
	"\bPeerMeta\x18\x04 \x01(\v25.hashicorp.consul.internal.service.PeeringServiceMetaR\bPeerMetaJ\x04\b\x02\x10\x03\"^\n" +
	"\x12PeeringServiceMeta\x12\x10\n" +
	"\x03SNI\x18\x01 \x03(\tR\x03SNI\x12\x1a\n" +
	"\bSpiffeID\x18\x02 \x03(\tR\bSpiffeID\x12\x1a\n" +
	"\bProtocol\x18\x03 \x01(\tR\bProtocol\"k\n" +
	"\fExposeConfig\x12\x16\n" +
	"\x06Checks\x18\x01 \x01(\bR\x06Checks\x12C\n" +
	"\x05Paths\x18\x02 \x03(\v2-.hashicorp.consul.internal.service.ExposePathR\x05Paths\"\xb0\x01\n" +
	"\n" +
	"ExposePath\x12\"\n" +
	"\fListenerPort\x18\x01 \x01(\x05R\fListenerPort\x12\x12\n" +
	"\x04Path\x18\x02 \x01(\tR\x04Path\x12$\n" +
	"\rLocalPathPort\x18\x03 \x01(\x05R\rLocalPathPort\x12\x1a\n" +
	"\bProtocol\x18\x04 \x01(\tR\bProtocol\x12(\n" +
	"\x0fParsedFromCheck\x18\x05 \x01(\bR\x0fParsedFromCheck\"'\n" +
	"\x11MeshGatewayConfig\x12\x12\n" +
	"\x04Mode\x18\x01 \x01(\tR\x04Mode\"t\n" +
	"\x16TransparentProxyConfig\x122\n" +
	"\x14OutboundListenerPort\x18\x01 \x01(\x05R\x14OutboundListenerPort\x12&\n" +
	"\x0eDialedDirectly\x18\x02 \x01(\bR\x0eDialedDirectly\"\xc6\x01\n" +
	"\x10AccessLogsConfig\x12\x18\n" +
	"\aEnabled\x18\x01 \x01(\bR\aEnabled\x120\n" +
	"\x13DisableListenerLogs\x18\x02 \x01(\bR\x13DisableListenerLogs\x12\x12\n" +
	"\x04Type\x18\x03 \x01(\tR\x04Type\x12\x12\n" +
	"\x04Path\x18\x04 \x01(\tR\x04Path\x12\x1e\n" +
	"\n" +
	"JSONFormat\x18\x05 \x01(\tR\n" +
	"JSONFormat\x12\x1e\n" +
	"\n" +
	"TextFormat\x18\x06 \x01(\tR\n" +
	"TextFormat\"\xbc\t\n" +
	"\x11ServiceDefinition\x12\x12\n" +
	"\x04Kind\x18\x01 \x01(\tR\x04Kind\x12\x0e\n" +
	"\x02ID\x18\x02 \x01(\tR\x02ID\x12\x12\n" +
	"\x04Name\x18\x03 \x01(\tR\x04Name\x12\x12\n" +
	"\x04Tags\x18\x04 \x03(\tR\x04Tags\x12\x18\n" +
	"\aAddress\x18\x05 \x01(\tR\aAddress\x12s\n" +
	"\x0fTaggedAddresses\x18\x10 \x03(\v2I.hashicorp.consul.internal.service.ServiceDefinition.TaggedAddressesEntryR\x0fTaggedAddresses\x12R\n" +
	"\x04Meta\x18\x06 \x03(\v2>.hashicorp.consul.internal.service.ServiceDefinition.MetaEntryR\x04Meta\x12\x12\n" +
	"\x04Port\x18\a \x01(\x05R\x04Port\x12\x1e\n" +
	"\n" +
	"SocketPath\x18\x12 \x01(\tR\n" +
	"SocketPath\x12B\n" +
	"\x05Check\x18\b \x01(\v2,.hashicorp.consul.internal.service.CheckTypeR\x05Check\x12D\n" +
	"\x06Checks\x18\t \x03(\v2,.hashicorp.consul.internal.service.CheckTypeR\x06Checks\x12D\n" +
	"\aWeights\x18\n" +
	" \x01(\v2*.hashicorp.consul.internal.service.WeightsR\aWeights\x12\x14\n" +
	"\x05Token\x18\v \x01(\tR\x05Token\x12,\n" +
	"\x11EnableTagOverride\x18\f \x01(\bR\x11EnableTagOverride\x12K\n" +
	"\x05Proxy\x18\x0e \x01(\v25.hashicorp.consul.internal.service.ConnectProxyConfigR\x05Proxy\x12X\n" +
	"\x0eEnterpriseMeta\x18\x11 \x01(\v20.hashicorp.consul.internal.common.EnterpriseMetaR\x0eEnterpriseMeta\x12K\n" +
	"\aConnect\x18\x0f \x01(\v21.hashicorp.consul.internal.service.ServiceConnectR\aConnect\x12F\n" +
	"\bLocality\x18\x13 \x01(\v2*.hashicorp.consul.internal.common.LocalityR\bLocality\x12D\n" +
	"\x05Ports\x18\x14 \x03(\v2..hashicorp.consul.internal.service.ServicePortR\x05Ports\x1au\n" +
	"\x14TaggedAddressesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12G\n" +
	"\x05value\x18\x02 \x01(\v21.hashicorp.consul.internal.service.ServiceAddressR\x05value:\x028\x01\x1a7\n" +
	"\tMetaEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"O\n" +
	"\vServicePort\x12\x12\n" +
	"\x04Port\x18\x01 \x01(\x05R\x04Port\x12\x12\n" +
	"\x04Name\x18\x02 \x01(\tR\x04Name\x12\x18\n" +
	"\aDefault\x18\x03 \x01(\bR\aDefault\">\n" +
	"\x0eServiceAddress\x12\x18\n" +
	"\aAddress\x18\x01 \x01(\tR\aAddress\x12\x12\n" +
	"\x04Port\x18\x02 \x01(\x05R\x04Port\"=\n" +
	"\aWeights\x12\x18\n" +
	"\aPassing\x18\x01 \x01(\x05R\aPassing\x12\x18\n" +
	"\aWarning\x18\x02 \x01(\x05R\aWarningB\x92\x02\n" +
	"%com.hashicorp.consul.internal.serviceB\fServiceProtoP\x01Z3github.com/hashicorp/consul/proto/private/pbservice\xa2\x02\x04HCIS\xaa\x02!Hashicorp.Consul.Internal.Service\xca\x02!Hashicorp\\Consul\\Internal\\Service\xe2\x02-Hashicorp\\Consul\\Internal\\Service\\GPBMetadata\xea\x02$Hashicorp::Consul::Internal::Serviceb\x06proto3"

var (
	file_private_pbservice_service_proto_rawDescOnce sync.Once
	file_private_pbservice_service_proto_rawDescData []byte
)

func file_private_pbservice_service_proto_rawDescGZIP() []byte {
	file_private_pbservice_service_proto_rawDescOnce.Do(func() {
		file_private_pbservice_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_private_pbservice_service_proto_rawDesc), len(file_private_pbservice_service_proto_rawDesc)))
	})
	return file_private_pbservice_service_proto_rawDescData
}

var file_private_pbservice_service_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_private_pbservice_service_proto_goTypes = []any{
	(*ConnectProxyConfig)(nil),      // 0: hashicorp.consul.internal.service.ConnectProxyConfig
	(*Upstream)(nil),                // 1: hashicorp.consul.internal.service.Upstream
	(*ServiceConnect)(nil),          // 2: hashicorp.consul.internal.service.ServiceConnect
	(*PeeringServiceMeta)(nil),      // 3: hashicorp.consul.internal.service.PeeringServiceMeta
	(*ExposeConfig)(nil),            // 4: hashicorp.consul.internal.service.ExposeConfig
	(*ExposePath)(nil),              // 5: hashicorp.consul.internal.service.ExposePath
	(*MeshGatewayConfig)(nil),       // 6: hashicorp.consul.internal.service.MeshGatewayConfig
	(*TransparentProxyConfig)(nil),  // 7: hashicorp.consul.internal.service.TransparentProxyConfig
	(*AccessLogsConfig)(nil),        // 8: hashicorp.consul.internal.service.AccessLogsConfig
	(*ServiceDefinition)(nil),       // 9: hashicorp.consul.internal.service.ServiceDefinition
	(*ServicePort)(nil),             // 10: hashicorp.consul.internal.service.ServicePort
	(*ServiceAddress)(nil),          // 11: hashicorp.consul.internal.service.ServiceAddress
	(*Weights)(nil),                 // 12: hashicorp.consul.internal.service.Weights
	nil,                             // 13: hashicorp.consul.internal.service.ServiceDefinition.TaggedAddressesEntry
	nil,                             // 14: hashicorp.consul.internal.service.ServiceDefinition.MetaEntry
	(*structpb.Struct)(nil),         // 15: google.protobuf.Struct
	(*pbcommon.EnvoyExtension)(nil), // 16: hashicorp.consul.internal.common.EnvoyExtension
	(*CheckType)(nil),               // 17: hashicorp.consul.internal.service.CheckType
	(*pbcommon.EnterpriseMeta)(nil), // 18: hashicorp.consul.internal.common.EnterpriseMeta
	(*pbcommon.Locality)(nil),       // 19: hashicorp.consul.internal.common.Locality
}
var file_private_pbservice_service_proto_depIdxs = []int32{
	15, // 0: hashicorp.consul.internal.service.ConnectProxyConfig.Config:type_name -> google.protobuf.Struct
	1,  // 1: hashicorp.consul.internal.service.ConnectProxyConfig.Upstreams:type_name -> hashicorp.consul.internal.service.Upstream
	6,  // 2: hashicorp.consul.internal.service.ConnectProxyConfig.MeshGateway:type_name -> hashicorp.consul.internal.service.MeshGatewayConfig
	4,  // 3: hashicorp.consul.internal.service.ConnectProxyConfig.Expose:type_name -> hashicorp.consul.internal.service.ExposeConfig
	7,  // 4: hashicorp.consul.internal.service.ConnectProxyConfig.TransparentProxy:type_name -> hashicorp.consul.internal.service.TransparentProxyConfig
	16, // 5: hashicorp.consul.internal.service.ConnectProxyConfig.EnvoyExtensions:type_name -> hashicorp.consul.internal.common.EnvoyExtension
	8,  // 6: hashicorp.consul.internal.service.ConnectProxyConfig.AccessLogs:type_name -> hashicorp.consul.internal.service.AccessLogsConfig
	15, // 7: hashicorp.consul.internal.service.Upstream.Config:type_name -> google.protobuf.Struct
	6,  // 8: hashicorp.consul.internal.service.Upstream.MeshGateway:type_name -> hashicorp.consul.internal.service.MeshGatewayConfig
	9,  // 9: hashicorp.consul.internal.service.ServiceConnect.SidecarService:type_name -> hashicorp.consul.internal.service.ServiceDefinition
	3,  // 10: hashicorp.consul.internal.service.ServiceConnect.PeerMeta:type_name -> hashicorp.consul.internal.service.PeeringServiceMeta
	5,  // 11: hashicorp.consul.internal.service.ExposeConfig.Paths:type_name -> hashicorp.consul.internal.service.ExposePath
	13, // 12: hashicorp.consul.internal.service.ServiceDefinition.TaggedAddresses:type_name -> hashicorp.consul.internal.service.ServiceDefinition.TaggedAddressesEntry
	14, // 13: hashicorp.consul.internal.service.ServiceDefinition.Meta:type_name -> hashicorp.consul.internal.service.ServiceDefinition.MetaEntry
	17, // 14: hashicorp.consul.internal.service.ServiceDefinition.Check:type_name -> hashicorp.consul.internal.service.CheckType
	17, // 15: hashicorp.consul.internal.service.ServiceDefinition.Checks:type_name -> hashicorp.consul.internal.service.CheckType
	12, // 16: hashicorp.consul.internal.service.ServiceDefinition.Weights:type_name -> hashicorp.consul.internal.service.Weights
	0,  // 17: hashicorp.consul.internal.service.ServiceDefinition.Proxy:type_name -> hashicorp.consul.internal.service.ConnectProxyConfig
	18, // 18: hashicorp.consul.internal.service.ServiceDefinition.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	2,  // 19: hashicorp.consul.internal.service.ServiceDefinition.Connect:type_name -> hashicorp.consul.internal.service.ServiceConnect
	19, // 20: hashicorp.consul.internal.service.ServiceDefinition.Locality:type_name -> hashicorp.consul.internal.common.Locality
	10, // 21: hashicorp.consul.internal.service.ServiceDefinition.Ports:type_name -> hashicorp.consul.internal.service.ServicePort
	11, // 22: hashicorp.consul.internal.service.ServiceDefinition.TaggedAddressesEntry.value:type_name -> hashicorp.consul.internal.service.ServiceAddress
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_private_pbservice_service_proto_init() }
func file_private_pbservice_service_proto_init() {
	if File_private_pbservice_service_proto != nil {
		return
	}
	file_private_pbservice_healthcheck_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_private_pbservice_service_proto_rawDesc), len(file_private_pbservice_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_private_pbservice_service_proto_goTypes,
		DependencyIndexes: file_private_pbservice_service_proto_depIdxs,
		MessageInfos:      file_private_pbservice_service_proto_msgTypes,
	}.Build()
	File_private_pbservice_service_proto = out.File
	file_private_pbservice_service_proto_goTypes = nil
	file_private_pbservice_service_proto_depIdxs = nil
}
