// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: pbresource/resource.proto

// For more information, see: https://github.com/hashicorp/consul/tree/main/docs/resources

package pbresource

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State represents the state of the condition (i.e. true/false/unknown).
type Condition_State int32

const (
	// STATE_UNKNOWN means that the state of the condition is unknown.
	//
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	Condition_STATE_UNKNOWN Condition_State = 0
	// STATE_TRUE means that the state of the condition is true.
	Condition_STATE_TRUE Condition_State = 1
	// STATE_FALSE means that the state of the condition is false.
	Condition_STATE_FALSE Condition_State = 2
)

// Enum value maps for Condition_State.
var (
	Condition_State_name = map[int32]string{
		0: "STATE_UNKNOWN",
		1: "STATE_TRUE",
		2: "STATE_FALSE",
	}
	Condition_State_value = map[string]int32{
		"STATE_UNKNOWN": 0,
		"STATE_TRUE":    1,
		"STATE_FALSE":   2,
	}
)

func (x Condition_State) Enum() *Condition_State {
	p := new(Condition_State)
	*p = x
	return p
}

func (x Condition_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Condition_State) Descriptor() protoreflect.EnumDescriptor {
	return file_pbresource_resource_proto_enumTypes[0].Descriptor()
}

func (Condition_State) Type() protoreflect.EnumType {
	return &file_pbresource_resource_proto_enumTypes[0]
}

func (x Condition_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Condition_State.Descriptor instead.
func (Condition_State) EnumDescriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{5, 0}
}

// Type describes a resource's type. It follows the GVK (Group Version Kind)
// [pattern](https://book.kubebuilder.io/cronjob-tutorial/gvks.html) established
// by Kubernetes.
type Type struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Group describes the area of functionality to which this resource type
	// relates (e.g. "catalog", "authorization").
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// GroupVersion is incremented when sweeping or backward-incompatible changes
	// are made to the group's resource types.
	GroupVersion string `protobuf:"bytes,2,opt,name=group_version,json=groupVersion,proto3" json:"group_version,omitempty"`
	// Kind identifies the specific resource type within the group.
	Kind          string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Type) Reset() {
	*x = Type{}
	mi := &file_pbresource_resource_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type) ProtoMessage() {}

func (x *Type) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type.ProtoReflect.Descriptor instead.
func (*Type) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{0}
}

func (x *Type) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *Type) GetGroupVersion() string {
	if x != nil {
		return x.GroupVersion
	}
	return ""
}

func (x *Type) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Tenancy describes the tenancy units in which the resource resides.
type Tenancy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Partition is the topmost administrative boundary within a cluster.
	// https://developer.hashicorp.com/consul/docs/enterprise/admin-partitions
	//
	// When using the List and WatchList endpoints, provide the wildcard value "*"
	// to list resources across all partitions.
	Partition string `protobuf:"bytes,1,opt,name=partition,proto3" json:"partition,omitempty"`
	// Namespace further isolates resources within a partition.
	// https://developer.hashicorp.com/consul/docs/enterprise/namespaces
	//
	// When using the List and WatchList endpoints, provide the wildcard value "*"
	// to list resources across all namespaces.
	Namespace     string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tenancy) Reset() {
	*x = Tenancy{}
	mi := &file_pbresource_resource_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tenancy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tenancy) ProtoMessage() {}

func (x *Tenancy) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tenancy.ProtoReflect.Descriptor instead.
func (*Tenancy) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{1}
}

func (x *Tenancy) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *Tenancy) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

// ID uniquely identifies a resource.
type ID struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Uid is the unique internal identifier we gave to the resource.
	//
	// It is primarily used to tell the difference between the current resource
	// and previous deleted resources with the same user-given name.
	//
	// Concretely, Uid is a [ULID](https://github.com/ulid/spec) and you can treat
	// its timestamp component as the resource's creation time.
	Uid string `protobuf:"bytes,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// Name is the user-given name of the resource (e.g. the "billing" service).
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Type identifies the resource's type.
	Type *Type `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Tenancy identifies the tenancy units (i.e. partition, namespace) in which
	// the resource resides.
	Tenancy       *Tenancy `protobuf:"bytes,4,opt,name=tenancy,proto3" json:"tenancy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ID) Reset() {
	*x = ID{}
	mi := &file_pbresource_resource_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ID) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ID) ProtoMessage() {}

func (x *ID) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ID.ProtoReflect.Descriptor instead.
func (*ID) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{2}
}

func (x *ID) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *ID) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ID) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ID) GetTenancy() *Tenancy {
	if x != nil {
		return x.Tenancy
	}
	return nil
}

// Resource describes a resource of a known type managed by Consul.
type Resource struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID uniquely identifies the resource.
	Id *ID `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Owner (optionally) describes which resource "owns" this resource, it is
	// immutable and can only be set on resource creation. Owned resources will
	// be automatically deleted when their owner is deleted.
	Owner *ID `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	// Version is the low-level version identifier used by the storage backend
	// in CAS (Compare-And-Swap) operations. It will change when the resource is
	// modified in any way, including status updates.
	//
	// When calling the Write endpoint, providing a non-blank version will perform
	// a CAS (Compare-And-Swap) write, which will result in an Aborted error code
	// if the given version doesn't match what is stored.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Generation is incremented whenever the resource's content (i.e. not its
	// status) is modified. You can think of it as being the "user version".
	//
	// Concretely, Generation is a [ULID](https://github.com/ulid/spec) and you
	// can treat its timestamp component as the resource's modification time.
	Generation string `protobuf:"bytes,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// Metadata contains key/value pairs of arbitrary metadata about the resource.
	// "deletionTimestamp" and "finalizers" keys are reserved for internal use.
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Status is used by controllers to communicate the result of attempting to
	// reconcile and apply the resource (e.g. surface semantic validation errors)
	// with users and other controllers. Each status is identified by a unique key
	// and should only ever be updated by one controller.
	//
	// Status can only be updated via the WriteStatus endpoint. Attempting to do
	// so via the Write endpoint will result in an InvalidArgument error code.
	Status map[string]*Status `protobuf:"bytes,6,rep,name=status,proto3" json:"status,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Data contains the resource's type-specific content.
	Data          *anypb.Any `protobuf:"bytes,7,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Resource) Reset() {
	*x = Resource{}
	mi := &file_pbresource_resource_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{3}
}

func (x *Resource) GetId() *ID {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *Resource) GetOwner() *ID {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *Resource) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Resource) GetGeneration() string {
	if x != nil {
		return x.Generation
	}
	return ""
}

func (x *Resource) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Resource) GetStatus() map[string]*Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Resource) GetData() *anypb.Any {
	if x != nil {
		return x.Data
	}
	return nil
}

// Status is used by controllers to communicate the result of attempting to
// reconcile and apply a resource (e.g. surface semantic validation errors)
// with users and other controllers.
type Status struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ObservedGeneration identifies which generation of a resource this status
	// related to. It can be used to determine whether the current generation of
	// a resource has been reconciled.
	ObservedGeneration string `protobuf:"bytes,1,opt,name=observed_generation,json=observedGeneration,proto3" json:"observed_generation,omitempty"`
	// Conditions contains a set of discreet observations about the resource in
	// relation to the current state of the system (e.g. it is semantically valid).
	Conditions []*Condition `protobuf:"bytes,2,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// UpdatedAt is the time at which the status was last written.
	UpdatedAt     *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Status) Reset() {
	*x = Status{}
	mi := &file_pbresource_resource_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{4}
}

func (x *Status) GetObservedGeneration() string {
	if x != nil {
		return x.ObservedGeneration
	}
	return ""
}

func (x *Status) GetConditions() []*Condition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *Status) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

// Condition represents a discreet observation about a resource in relation to
// the current state of the system.
//
// It is heavily inspired by Kubernetes' [conditions](https://bit.ly/3H9Y6IK)
// and the Gateway API [types and reasons](https://bit.ly/3n2PPiP).
type Condition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type identifies the type of condition (e.g. "Invalid", "ResolvedRefs").
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// State represents the state of the condition (i.e. true/false/unknown).
	State Condition_State `protobuf:"varint,2,opt,name=state,proto3,enum=hashicorp.consul.resource.Condition_State" json:"state,omitempty"`
	// Reason provides more machine-readable details about the condition (e.g.
	// "InvalidProtocol").
	Reason string `protobuf:"bytes,3,opt,name=reason,proto3" json:"reason,omitempty"`
	// Message contains a human-friendly description of the status.
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	// Resource identifies which resource this condition relates to, when it is
	// not the core resource itself.
	Resource      *Reference `protobuf:"bytes,5,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Condition) Reset() {
	*x = Condition{}
	mi := &file_pbresource_resource_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{5}
}

func (x *Condition) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Condition) GetState() Condition_State {
	if x != nil {
		return x.State
	}
	return Condition_STATE_UNKNOWN
}

func (x *Condition) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *Condition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Condition) GetResource() *Reference {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Reference identifies which resource a condition relates to, when it is not
// the core resource itself.
type Reference struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type identifies the resource's type.
	Type *Type `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Tenancy identifies the tenancy units (i.e. partition, namespace) in which
	// the resource resides.
	Tenancy *Tenancy `protobuf:"bytes,2,opt,name=tenancy,proto3" json:"tenancy,omitempty"`
	// Name is the user-given name of the resource (e.g. the "billing" service).
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Section identifies which part of the resource the condition relates to.
	Section       string `protobuf:"bytes,4,opt,name=section,proto3" json:"section,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Reference) Reset() {
	*x = Reference{}
	mi := &file_pbresource_resource_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Reference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reference) ProtoMessage() {}

func (x *Reference) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reference.ProtoReflect.Descriptor instead.
func (*Reference) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{6}
}

func (x *Reference) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Reference) GetTenancy() *Tenancy {
	if x != nil {
		return x.Tenancy
	}
	return nil
}

func (x *Reference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Reference) GetSection() string {
	if x != nil {
		return x.Section
	}
	return ""
}

// Tombstone represents a promise to delete all of a resource's immediately
// owned (child) resources, if any.
type Tombstone struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Owner resource identifier.
	Owner         *ID `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tombstone) Reset() {
	*x = Tombstone{}
	mi := &file_pbresource_resource_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tombstone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tombstone) ProtoMessage() {}

func (x *Tombstone) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tombstone.ProtoReflect.Descriptor instead.
func (*Tombstone) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{7}
}

func (x *Tombstone) GetOwner() *ID {
	if x != nil {
		return x.Owner
	}
	return nil
}

// ReadRequest contains the parameters to the Read endpoint.
type ReadRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the resource.
	Id            *ID `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadRequest) Reset() {
	*x = ReadRequest{}
	mi := &file_pbresource_resource_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRequest) ProtoMessage() {}

func (x *ReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRequest.ProtoReflect.Descriptor instead.
func (*ReadRequest) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{8}
}

func (x *ReadRequest) GetId() *ID {
	if x != nil {
		return x.Id
	}
	return nil
}

// ReadResponse contains the results of calling the Read endpoint.
type ReadResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resource that was read.
	Resource      *Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadResponse) Reset() {
	*x = ReadResponse{}
	mi := &file_pbresource_resource_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResponse) ProtoMessage() {}

func (x *ReadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResponse.ProtoReflect.Descriptor instead.
func (*ReadResponse) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{9}
}

func (x *ReadResponse) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// ListRequest contains the parameters to the List endpoint.
type ListRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of resource to list.
	Type *Type `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Tenancy units in which to list resources. To list resources in all units,
	// provide the wildcard "*" value.
	Tenancy *Tenancy `protobuf:"bytes,2,opt,name=tenancy,proto3" json:"tenancy,omitempty"`
	// NamePrefix filters the results to those with a name beginning with the
	// given prefix.
	NamePrefix    string `protobuf:"bytes,3,opt,name=name_prefix,json=namePrefix,proto3" json:"name_prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListRequest) Reset() {
	*x = ListRequest{}
	mi := &file_pbresource_resource_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRequest) ProtoMessage() {}

func (x *ListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRequest.ProtoReflect.Descriptor instead.
func (*ListRequest) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{10}
}

func (x *ListRequest) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ListRequest) GetTenancy() *Tenancy {
	if x != nil {
		return x.Tenancy
	}
	return nil
}

func (x *ListRequest) GetNamePrefix() string {
	if x != nil {
		return x.NamePrefix
	}
	return ""
}

// ListResponse contains the results of calling the List endpoint.
type ListResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resources that were listed.
	Resources     []*Resource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResponse) Reset() {
	*x = ListResponse{}
	mi := &file_pbresource_resource_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResponse) ProtoMessage() {}

func (x *ListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResponse.ProtoReflect.Descriptor instead.
func (*ListResponse) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{11}
}

func (x *ListResponse) GetResources() []*Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

// ListByOwnerRequest contains the parameters to the ListByOwner endpoint.
type ListByOwnerRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Owner         *ID                    `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListByOwnerRequest) Reset() {
	*x = ListByOwnerRequest{}
	mi := &file_pbresource_resource_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListByOwnerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListByOwnerRequest) ProtoMessage() {}

func (x *ListByOwnerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListByOwnerRequest.ProtoReflect.Descriptor instead.
func (*ListByOwnerRequest) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{12}
}

func (x *ListByOwnerRequest) GetOwner() *ID {
	if x != nil {
		return x.Owner
	}
	return nil
}

// ListByOwnerResponse contains the results of calling the ListByOwner endpoint.
type ListByOwnerResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resources that were listed.
	Resources     []*Resource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListByOwnerResponse) Reset() {
	*x = ListByOwnerResponse{}
	mi := &file_pbresource_resource_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListByOwnerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListByOwnerResponse) ProtoMessage() {}

func (x *ListByOwnerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListByOwnerResponse.ProtoReflect.Descriptor instead.
func (*ListByOwnerResponse) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{13}
}

func (x *ListByOwnerResponse) GetResources() []*Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

// WriteRequest contains the parameters to the Write endpoint.
type WriteRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resource to write.
	Resource      *Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WriteRequest) Reset() {
	*x = WriteRequest{}
	mi := &file_pbresource_resource_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteRequest) ProtoMessage() {}

func (x *WriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteRequest.ProtoReflect.Descriptor instead.
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{14}
}

func (x *WriteRequest) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// WriteResponse contains the results of calling the Write endpoint.
type WriteResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resource that was written.
	Resource      *Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WriteResponse) Reset() {
	*x = WriteResponse{}
	mi := &file_pbresource_resource_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteResponse) ProtoMessage() {}

func (x *WriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteResponse.ProtoReflect.Descriptor instead.
func (*WriteResponse) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{15}
}

func (x *WriteResponse) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// WriteStatusRequest contains the parameters to the WriteStatus endpoint.
type WriteStatusRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the resource to which the status will be written. Must contain a Uid.
	Id *ID `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version may be provided to perform a CAS (Compare-And-Swap) update of the
	// status. If the given version doesn't match what is currently stored, an
	// Aborted error code will be returned.
	//
	// Note: in most cases, CAS status updates are not necessary because updates
	// are scoped to a specific status key and controllers are leader-elected so
	// there is no chance of a conflict.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Key identifies which status will be written. Generally, each controller
	// should write 1 status which it owns exclusively (i.e. no other controller
	// updates it).
	Key string `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Status that will be written to the resource.
	Status        *Status `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WriteStatusRequest) Reset() {
	*x = WriteStatusRequest{}
	mi := &file_pbresource_resource_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteStatusRequest) ProtoMessage() {}

func (x *WriteStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteStatusRequest.ProtoReflect.Descriptor instead.
func (*WriteStatusRequest) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{16}
}

func (x *WriteStatusRequest) GetId() *ID {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *WriteStatusRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *WriteStatusRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *WriteStatusRequest) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// WriteStatusResponse contains the results of calling the WriteStatus endpoint.
type WriteStatusResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Resource to which the status was written.
	Resource      *Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WriteStatusResponse) Reset() {
	*x = WriteStatusResponse{}
	mi := &file_pbresource_resource_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteStatusResponse) ProtoMessage() {}

func (x *WriteStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteStatusResponse.ProtoReflect.Descriptor instead.
func (*WriteStatusResponse) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{17}
}

func (x *WriteStatusResponse) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// DeleteRequest contains the parameters to the Delete endpoint.
type DeleteRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the resource that will be deleted.
	Id *ID `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Version may be provided to perform a CAS (Compare-And-Swap) deletion of the
	// resource. If the given version doesn't match what is currently stored, an
	// Aborted error code will be returned.
	Version       string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRequest) Reset() {
	*x = DeleteRequest{}
	mi := &file_pbresource_resource_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRequest) ProtoMessage() {}

func (x *DeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRequest.ProtoReflect.Descriptor instead.
func (*DeleteRequest) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{18}
}

func (x *DeleteRequest) GetId() *ID {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *DeleteRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// DeleteResponse contains the results of calling the Delete endpoint.
type DeleteResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteResponse) Reset() {
	*x = DeleteResponse{}
	mi := &file_pbresource_resource_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteResponse) ProtoMessage() {}

func (x *DeleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteResponse.ProtoReflect.Descriptor instead.
func (*DeleteResponse) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{19}
}

// WatchListRequest contains the parameters to the WatchList endpoint.
type WatchListRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of resource to watch.
	Type *Type `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Tenancy units in which to watch resources. To list resources in all units,
	// provide the wildcard "*" value.
	Tenancy *Tenancy `protobuf:"bytes,2,opt,name=tenancy,proto3" json:"tenancy,omitempty"`
	// NamePrefix filters the results to those with a name beginning with the
	// given prefix.
	NamePrefix    string `protobuf:"bytes,3,opt,name=name_prefix,json=namePrefix,proto3" json:"name_prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchListRequest) Reset() {
	*x = WatchListRequest{}
	mi := &file_pbresource_resource_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchListRequest) ProtoMessage() {}

func (x *WatchListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchListRequest.ProtoReflect.Descriptor instead.
func (*WatchListRequest) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{20}
}

func (x *WatchListRequest) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *WatchListRequest) GetTenancy() *Tenancy {
	if x != nil {
		return x.Tenancy
	}
	return nil
}

func (x *WatchListRequest) GetNamePrefix() string {
	if x != nil {
		return x.NamePrefix
	}
	return ""
}

// WatchEvent is emitted on the WatchList stream when a resource changes.
type WatchEvent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Event:
	//
	//	*WatchEvent_Upsert_
	//	*WatchEvent_Delete_
	//	*WatchEvent_EndOfSnapshot_
	Event         isWatchEvent_Event `protobuf_oneof:"event"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchEvent) Reset() {
	*x = WatchEvent{}
	mi := &file_pbresource_resource_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchEvent) ProtoMessage() {}

func (x *WatchEvent) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchEvent.ProtoReflect.Descriptor instead.
func (*WatchEvent) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{21}
}

func (x *WatchEvent) GetEvent() isWatchEvent_Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *WatchEvent) GetUpsert() *WatchEvent_Upsert {
	if x != nil {
		if x, ok := x.Event.(*WatchEvent_Upsert_); ok {
			return x.Upsert
		}
	}
	return nil
}

func (x *WatchEvent) GetDelete() *WatchEvent_Delete {
	if x != nil {
		if x, ok := x.Event.(*WatchEvent_Delete_); ok {
			return x.Delete
		}
	}
	return nil
}

func (x *WatchEvent) GetEndOfSnapshot() *WatchEvent_EndOfSnapshot {
	if x != nil {
		if x, ok := x.Event.(*WatchEvent_EndOfSnapshot_); ok {
			return x.EndOfSnapshot
		}
	}
	return nil
}

type isWatchEvent_Event interface {
	isWatchEvent_Event()
}

type WatchEvent_Upsert_ struct {
	Upsert *WatchEvent_Upsert `protobuf:"bytes,1,opt,name=upsert,proto3,oneof"`
}

type WatchEvent_Delete_ struct {
	Delete *WatchEvent_Delete `protobuf:"bytes,2,opt,name=delete,proto3,oneof"`
}

type WatchEvent_EndOfSnapshot_ struct {
	EndOfSnapshot *WatchEvent_EndOfSnapshot `protobuf:"bytes,3,opt,name=end_of_snapshot,json=endOfSnapshot,proto3,oneof"`
}

func (*WatchEvent_Upsert_) isWatchEvent_Event() {}

func (*WatchEvent_Delete_) isWatchEvent_Event() {}

func (*WatchEvent_EndOfSnapshot_) isWatchEvent_Event() {}

// MutateAndValidateRequest contains the parameters to the MutateAndValidate endpoint.
type MutateAndValidateRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Resource      *Resource              `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MutateAndValidateRequest) Reset() {
	*x = MutateAndValidateRequest{}
	mi := &file_pbresource_resource_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MutateAndValidateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateAndValidateRequest) ProtoMessage() {}

func (x *MutateAndValidateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateAndValidateRequest.ProtoReflect.Descriptor instead.
func (*MutateAndValidateRequest) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{22}
}

func (x *MutateAndValidateRequest) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// MutateAndValidateResponse contains the results of calling the MutateAndValidate endpoint.
type MutateAndValidateResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Resource      *Resource              `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MutateAndValidateResponse) Reset() {
	*x = MutateAndValidateResponse{}
	mi := &file_pbresource_resource_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MutateAndValidateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateAndValidateResponse) ProtoMessage() {}

func (x *MutateAndValidateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateAndValidateResponse.ProtoReflect.Descriptor instead.
func (*MutateAndValidateResponse) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{23}
}

func (x *MutateAndValidateResponse) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Upsert indicates that the resource was written (i.e. created or
// updated). All events from the initial state-of-the-world will be upsert
// events.
type WatchEvent_Upsert struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Resource      *Resource              `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchEvent_Upsert) Reset() {
	*x = WatchEvent_Upsert{}
	mi := &file_pbresource_resource_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchEvent_Upsert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchEvent_Upsert) ProtoMessage() {}

func (x *WatchEvent_Upsert) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchEvent_Upsert.ProtoReflect.Descriptor instead.
func (*WatchEvent_Upsert) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{21, 0}
}

func (x *WatchEvent_Upsert) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Delete indicates that the resource was deleted.
type WatchEvent_Delete struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Resource      *Resource              `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchEvent_Delete) Reset() {
	*x = WatchEvent_Delete{}
	mi := &file_pbresource_resource_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchEvent_Delete) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchEvent_Delete) ProtoMessage() {}

func (x *WatchEvent_Delete) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchEvent_Delete.ProtoReflect.Descriptor instead.
func (*WatchEvent_Delete) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{21, 1}
}

func (x *WatchEvent_Delete) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// EndOfSnapshot is sent to indicate that the initial snapshot events have
// been sent and future events will modify that set.
type WatchEvent_EndOfSnapshot struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchEvent_EndOfSnapshot) Reset() {
	*x = WatchEvent_EndOfSnapshot{}
	mi := &file_pbresource_resource_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchEvent_EndOfSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchEvent_EndOfSnapshot) ProtoMessage() {}

func (x *WatchEvent_EndOfSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_pbresource_resource_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchEvent_EndOfSnapshot.ProtoReflect.Descriptor instead.
func (*WatchEvent_EndOfSnapshot) Descriptor() ([]byte, []int) {
	return file_pbresource_resource_proto_rawDescGZIP(), []int{21, 2}
}

var File_pbresource_resource_proto protoreflect.FileDescriptor

const file_pbresource_resource_proto_rawDesc = "" +
	"\n" +
	"\x19pbresource/resource.proto\x12\x19hashicorp.consul.resource\x1a%annotations/ratelimit/ratelimit.proto\x1a\x19google/protobuf/any.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"U\n" +
	"\x04Type\x12\x14\n" +
	"\x05group\x18\x01 \x01(\tR\x05group\x12#\n" +
	"\rgroup_version\x18\x02 \x01(\tR\fgroupVersion\x12\x12\n" +
	"\x04kind\x18\x03 \x01(\tR\x04kind\"E\n" +
	"\aTenancy\x12\x1c\n" +
	"\tpartition\x18\x01 \x01(\tR\tpartition\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\"\x9d\x01\n" +
	"\x02ID\x12\x10\n" +
	"\x03uid\x18\x01 \x01(\tR\x03uid\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x123\n" +
	"\x04type\x18\x03 \x01(\v2\x1f.hashicorp.consul.resource.TypeR\x04type\x12<\n" +
	"\atenancy\x18\x04 \x01(\v2\".hashicorp.consul.resource.TenancyR\atenancy\"\x85\x04\n" +
	"\bResource\x12-\n" +
	"\x02id\x18\x01 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x02id\x123\n" +
	"\x05owner\x18\x02 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x05owner\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion\x12\x1e\n" +
	"\n" +
	"generation\x18\x04 \x01(\tR\n" +
	"generation\x12M\n" +
	"\bmetadata\x18\x05 \x03(\v21.hashicorp.consul.resource.Resource.MetadataEntryR\bmetadata\x12G\n" +
	"\x06status\x18\x06 \x03(\v2/.hashicorp.consul.resource.Resource.StatusEntryR\x06status\x12(\n" +
	"\x04data\x18\a \x01(\v2\x14.google.protobuf.AnyR\x04data\x1a;\n" +
	"\rMetadataEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a\\\n" +
	"\vStatusEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x127\n" +
	"\x05value\x18\x02 \x01(\v2!.hashicorp.consul.resource.StatusR\x05value:\x028\x01\"\xba\x01\n" +
	"\x06Status\x12/\n" +
	"\x13observed_generation\x18\x01 \x01(\tR\x12observedGeneration\x12D\n" +
	"\n" +
	"conditions\x18\x02 \x03(\v2$.hashicorp.consul.resource.ConditionR\n" +
	"conditions\x129\n" +
	"\n" +
	"updated_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tupdatedAt\"\x92\x02\n" +
	"\tCondition\x12\x12\n" +
	"\x04type\x18\x01 \x01(\tR\x04type\x12@\n" +
	"\x05state\x18\x02 \x01(\x0e2*.hashicorp.consul.resource.Condition.StateR\x05state\x12\x16\n" +
	"\x06reason\x18\x03 \x01(\tR\x06reason\x12\x18\n" +
	"\amessage\x18\x04 \x01(\tR\amessage\x12@\n" +
	"\bresource\x18\x05 \x01(\v2$.hashicorp.consul.resource.ReferenceR\bresource\";\n" +
	"\x05State\x12\x11\n" +
	"\rSTATE_UNKNOWN\x10\x00\x12\x0e\n" +
	"\n" +
	"STATE_TRUE\x10\x01\x12\x0f\n" +
	"\vSTATE_FALSE\x10\x02\"\xac\x01\n" +
	"\tReference\x123\n" +
	"\x04type\x18\x01 \x01(\v2\x1f.hashicorp.consul.resource.TypeR\x04type\x12<\n" +
	"\atenancy\x18\x02 \x01(\v2\".hashicorp.consul.resource.TenancyR\atenancy\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12\x18\n" +
	"\asection\x18\x04 \x01(\tR\asection\"@\n" +
	"\tTombstone\x123\n" +
	"\x05owner\x18\x01 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x05owner\"<\n" +
	"\vReadRequest\x12-\n" +
	"\x02id\x18\x01 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x02id\"O\n" +
	"\fReadResponse\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\"\xa1\x01\n" +
	"\vListRequest\x123\n" +
	"\x04type\x18\x01 \x01(\v2\x1f.hashicorp.consul.resource.TypeR\x04type\x12<\n" +
	"\atenancy\x18\x02 \x01(\v2\".hashicorp.consul.resource.TenancyR\atenancy\x12\x1f\n" +
	"\vname_prefix\x18\x03 \x01(\tR\n" +
	"namePrefix\"Q\n" +
	"\fListResponse\x12A\n" +
	"\tresources\x18\x01 \x03(\v2#.hashicorp.consul.resource.ResourceR\tresources\"I\n" +
	"\x12ListByOwnerRequest\x123\n" +
	"\x05owner\x18\x01 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x05owner\"X\n" +
	"\x13ListByOwnerResponse\x12A\n" +
	"\tresources\x18\x01 \x03(\v2#.hashicorp.consul.resource.ResourceR\tresources\"O\n" +
	"\fWriteRequest\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\"P\n" +
	"\rWriteResponse\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\"\xaa\x01\n" +
	"\x12WriteStatusRequest\x12-\n" +
	"\x02id\x18\x01 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x02id\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12\x10\n" +
	"\x03key\x18\x03 \x01(\tR\x03key\x129\n" +
	"\x06status\x18\x04 \x01(\v2!.hashicorp.consul.resource.StatusR\x06status\"V\n" +
	"\x13WriteStatusResponse\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\"X\n" +
	"\rDeleteRequest\x12-\n" +
	"\x02id\x18\x01 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x02id\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\"\x10\n" +
	"\x0eDeleteResponse\"\xa6\x01\n" +
	"\x10WatchListRequest\x123\n" +
	"\x04type\x18\x01 \x01(\v2\x1f.hashicorp.consul.resource.TypeR\x04type\x12<\n" +
	"\atenancy\x18\x02 \x01(\v2\".hashicorp.consul.resource.TenancyR\atenancy\x12\x1f\n" +
	"\vname_prefix\x18\x03 \x01(\tR\n" +
	"namePrefix\"\xab\x03\n" +
	"\n" +
	"WatchEvent\x12F\n" +
	"\x06upsert\x18\x01 \x01(\v2,.hashicorp.consul.resource.WatchEvent.UpsertH\x00R\x06upsert\x12F\n" +
	"\x06delete\x18\x02 \x01(\v2,.hashicorp.consul.resource.WatchEvent.DeleteH\x00R\x06delete\x12]\n" +
	"\x0fend_of_snapshot\x18\x03 \x01(\v23.hashicorp.consul.resource.WatchEvent.EndOfSnapshotH\x00R\rendOfSnapshot\x1aI\n" +
	"\x06Upsert\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\x1aI\n" +
	"\x06Delete\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\x1a\x0f\n" +
	"\rEndOfSnapshotB\a\n" +
	"\x05event\"[\n" +
	"\x18MutateAndValidateRequest\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\"\\\n" +
	"\x19MutateAndValidateResponse\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource2\x8e\a\n" +
	"\x0fResourceService\x12a\n" +
	"\x04Read\x12&.hashicorp.consul.resource.ReadRequest\x1a'.hashicorp.consul.resource.ReadResponse\"\b\xe2\x86\x04\x04\b\x02\x10\v\x12d\n" +
	"\x05Write\x12'.hashicorp.consul.resource.WriteRequest\x1a(.hashicorp.consul.resource.WriteResponse\"\b\xe2\x86\x04\x04\b\x03\x10\v\x12v\n" +
	"\vWriteStatus\x12-.hashicorp.consul.resource.WriteStatusRequest\x1a..hashicorp.consul.resource.WriteStatusResponse\"\b\xe2\x86\x04\x04\b\x03\x10\v\x12a\n" +
	"\x04List\x12&.hashicorp.consul.resource.ListRequest\x1a'.hashicorp.consul.resource.ListResponse\"\b\xe2\x86\x04\x04\b\x02\x10\v\x12v\n" +
	"\vListByOwner\x12-.hashicorp.consul.resource.ListByOwnerRequest\x1a..hashicorp.consul.resource.ListByOwnerResponse\"\b\xe2\x86\x04\x04\b\x02\x10\v\x12g\n" +
	"\x06Delete\x12(.hashicorp.consul.resource.DeleteRequest\x1a).hashicorp.consul.resource.DeleteResponse\"\b\xe2\x86\x04\x04\b\x03\x10\v\x12k\n" +
	"\tWatchList\x12+.hashicorp.consul.resource.WatchListRequest\x1a%.hashicorp.consul.resource.WatchEvent\"\b\xe2\x86\x04\x04\b\x02\x10\v0\x01\x12\x88\x01\n" +
	"\x11MutateAndValidate\x123.hashicorp.consul.resource.MutateAndValidateRequest\x1a4.hashicorp.consul.resource.MutateAndValidateResponse\"\b\xe2\x86\x04\x04\b\x02\x10\vB\xe9\x01\n" +
	"\x1dcom.hashicorp.consul.resourceB\rResourceProtoP\x01Z3github.com/hashicorp/consul/proto-public/pbresource\xa2\x02\x03HCR\xaa\x02\x19Hashicorp.Consul.Resource\xca\x02\x19Hashicorp\\Consul\\Resource\xe2\x02%Hashicorp\\Consul\\Resource\\GPBMetadata\xea\x02\x1bHashicorp::Consul::Resourceb\x06proto3"

var (
	file_pbresource_resource_proto_rawDescOnce sync.Once
	file_pbresource_resource_proto_rawDescData []byte
)

func file_pbresource_resource_proto_rawDescGZIP() []byte {
	file_pbresource_resource_proto_rawDescOnce.Do(func() {
		file_pbresource_resource_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_pbresource_resource_proto_rawDesc), len(file_pbresource_resource_proto_rawDesc)))
	})
	return file_pbresource_resource_proto_rawDescData
}

var file_pbresource_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_pbresource_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_pbresource_resource_proto_goTypes = []any{
	(Condition_State)(0),              // 0: hashicorp.consul.resource.Condition.State
	(*Type)(nil),                      // 1: hashicorp.consul.resource.Type
	(*Tenancy)(nil),                   // 2: hashicorp.consul.resource.Tenancy
	(*ID)(nil),                        // 3: hashicorp.consul.resource.ID
	(*Resource)(nil),                  // 4: hashicorp.consul.resource.Resource
	(*Status)(nil),                    // 5: hashicorp.consul.resource.Status
	(*Condition)(nil),                 // 6: hashicorp.consul.resource.Condition
	(*Reference)(nil),                 // 7: hashicorp.consul.resource.Reference
	(*Tombstone)(nil),                 // 8: hashicorp.consul.resource.Tombstone
	(*ReadRequest)(nil),               // 9: hashicorp.consul.resource.ReadRequest
	(*ReadResponse)(nil),              // 10: hashicorp.consul.resource.ReadResponse
	(*ListRequest)(nil),               // 11: hashicorp.consul.resource.ListRequest
	(*ListResponse)(nil),              // 12: hashicorp.consul.resource.ListResponse
	(*ListByOwnerRequest)(nil),        // 13: hashicorp.consul.resource.ListByOwnerRequest
	(*ListByOwnerResponse)(nil),       // 14: hashicorp.consul.resource.ListByOwnerResponse
	(*WriteRequest)(nil),              // 15: hashicorp.consul.resource.WriteRequest
	(*WriteResponse)(nil),             // 16: hashicorp.consul.resource.WriteResponse
	(*WriteStatusRequest)(nil),        // 17: hashicorp.consul.resource.WriteStatusRequest
	(*WriteStatusResponse)(nil),       // 18: hashicorp.consul.resource.WriteStatusResponse
	(*DeleteRequest)(nil),             // 19: hashicorp.consul.resource.DeleteRequest
	(*DeleteResponse)(nil),            // 20: hashicorp.consul.resource.DeleteResponse
	(*WatchListRequest)(nil),          // 21: hashicorp.consul.resource.WatchListRequest
	(*WatchEvent)(nil),                // 22: hashicorp.consul.resource.WatchEvent
	(*MutateAndValidateRequest)(nil),  // 23: hashicorp.consul.resource.MutateAndValidateRequest
	(*MutateAndValidateResponse)(nil), // 24: hashicorp.consul.resource.MutateAndValidateResponse
	nil,                               // 25: hashicorp.consul.resource.Resource.MetadataEntry
	nil,                               // 26: hashicorp.consul.resource.Resource.StatusEntry
	(*WatchEvent_Upsert)(nil),         // 27: hashicorp.consul.resource.WatchEvent.Upsert
	(*WatchEvent_Delete)(nil),         // 28: hashicorp.consul.resource.WatchEvent.Delete
	(*WatchEvent_EndOfSnapshot)(nil),  // 29: hashicorp.consul.resource.WatchEvent.EndOfSnapshot
	(*anypb.Any)(nil),                 // 30: google.protobuf.Any
	(*timestamppb.Timestamp)(nil),     // 31: google.protobuf.Timestamp
}
var file_pbresource_resource_proto_depIdxs = []int32{
	1,  // 0: hashicorp.consul.resource.ID.type:type_name -> hashicorp.consul.resource.Type
	2,  // 1: hashicorp.consul.resource.ID.tenancy:type_name -> hashicorp.consul.resource.Tenancy
	3,  // 2: hashicorp.consul.resource.Resource.id:type_name -> hashicorp.consul.resource.ID
	3,  // 3: hashicorp.consul.resource.Resource.owner:type_name -> hashicorp.consul.resource.ID
	25, // 4: hashicorp.consul.resource.Resource.metadata:type_name -> hashicorp.consul.resource.Resource.MetadataEntry
	26, // 5: hashicorp.consul.resource.Resource.status:type_name -> hashicorp.consul.resource.Resource.StatusEntry
	30, // 6: hashicorp.consul.resource.Resource.data:type_name -> google.protobuf.Any
	6,  // 7: hashicorp.consul.resource.Status.conditions:type_name -> hashicorp.consul.resource.Condition
	31, // 8: hashicorp.consul.resource.Status.updated_at:type_name -> google.protobuf.Timestamp
	0,  // 9: hashicorp.consul.resource.Condition.state:type_name -> hashicorp.consul.resource.Condition.State
	7,  // 10: hashicorp.consul.resource.Condition.resource:type_name -> hashicorp.consul.resource.Reference
	1,  // 11: hashicorp.consul.resource.Reference.type:type_name -> hashicorp.consul.resource.Type
	2,  // 12: hashicorp.consul.resource.Reference.tenancy:type_name -> hashicorp.consul.resource.Tenancy
	3,  // 13: hashicorp.consul.resource.Tombstone.owner:type_name -> hashicorp.consul.resource.ID
	3,  // 14: hashicorp.consul.resource.ReadRequest.id:type_name -> hashicorp.consul.resource.ID
	4,  // 15: hashicorp.consul.resource.ReadResponse.resource:type_name -> hashicorp.consul.resource.Resource
	1,  // 16: hashicorp.consul.resource.ListRequest.type:type_name -> hashicorp.consul.resource.Type
	2,  // 17: hashicorp.consul.resource.ListRequest.tenancy:type_name -> hashicorp.consul.resource.Tenancy
	4,  // 18: hashicorp.consul.resource.ListResponse.resources:type_name -> hashicorp.consul.resource.Resource
	3,  // 19: hashicorp.consul.resource.ListByOwnerRequest.owner:type_name -> hashicorp.consul.resource.ID
	4,  // 20: hashicorp.consul.resource.ListByOwnerResponse.resources:type_name -> hashicorp.consul.resource.Resource
	4,  // 21: hashicorp.consul.resource.WriteRequest.resource:type_name -> hashicorp.consul.resource.Resource
	4,  // 22: hashicorp.consul.resource.WriteResponse.resource:type_name -> hashicorp.consul.resource.Resource
	3,  // 23: hashicorp.consul.resource.WriteStatusRequest.id:type_name -> hashicorp.consul.resource.ID
	5,  // 24: hashicorp.consul.resource.WriteStatusRequest.status:type_name -> hashicorp.consul.resource.Status
	4,  // 25: hashicorp.consul.resource.WriteStatusResponse.resource:type_name -> hashicorp.consul.resource.Resource
	3,  // 26: hashicorp.consul.resource.DeleteRequest.id:type_name -> hashicorp.consul.resource.ID
	1,  // 27: hashicorp.consul.resource.WatchListRequest.type:type_name -> hashicorp.consul.resource.Type
	2,  // 28: hashicorp.consul.resource.WatchListRequest.tenancy:type_name -> hashicorp.consul.resource.Tenancy
	27, // 29: hashicorp.consul.resource.WatchEvent.upsert:type_name -> hashicorp.consul.resource.WatchEvent.Upsert
	28, // 30: hashicorp.consul.resource.WatchEvent.delete:type_name -> hashicorp.consul.resource.WatchEvent.Delete
	29, // 31: hashicorp.consul.resource.WatchEvent.end_of_snapshot:type_name -> hashicorp.consul.resource.WatchEvent.EndOfSnapshot
	4,  // 32: hashicorp.consul.resource.MutateAndValidateRequest.resource:type_name -> hashicorp.consul.resource.Resource
	4,  // 33: hashicorp.consul.resource.MutateAndValidateResponse.resource:type_name -> hashicorp.consul.resource.Resource
	5,  // 34: hashicorp.consul.resource.Resource.StatusEntry.value:type_name -> hashicorp.consul.resource.Status
	4,  // 35: hashicorp.consul.resource.WatchEvent.Upsert.resource:type_name -> hashicorp.consul.resource.Resource
	4,  // 36: hashicorp.consul.resource.WatchEvent.Delete.resource:type_name -> hashicorp.consul.resource.Resource
	9,  // 37: hashicorp.consul.resource.ResourceService.Read:input_type -> hashicorp.consul.resource.ReadRequest
	15, // 38: hashicorp.consul.resource.ResourceService.Write:input_type -> hashicorp.consul.resource.WriteRequest
	17, // 39: hashicorp.consul.resource.ResourceService.WriteStatus:input_type -> hashicorp.consul.resource.WriteStatusRequest
	11, // 40: hashicorp.consul.resource.ResourceService.List:input_type -> hashicorp.consul.resource.ListRequest
	13, // 41: hashicorp.consul.resource.ResourceService.ListByOwner:input_type -> hashicorp.consul.resource.ListByOwnerRequest
	19, // 42: hashicorp.consul.resource.ResourceService.Delete:input_type -> hashicorp.consul.resource.DeleteRequest
	21, // 43: hashicorp.consul.resource.ResourceService.WatchList:input_type -> hashicorp.consul.resource.WatchListRequest
	23, // 44: hashicorp.consul.resource.ResourceService.MutateAndValidate:input_type -> hashicorp.consul.resource.MutateAndValidateRequest
	10, // 45: hashicorp.consul.resource.ResourceService.Read:output_type -> hashicorp.consul.resource.ReadResponse
	16, // 46: hashicorp.consul.resource.ResourceService.Write:output_type -> hashicorp.consul.resource.WriteResponse
	18, // 47: hashicorp.consul.resource.ResourceService.WriteStatus:output_type -> hashicorp.consul.resource.WriteStatusResponse
	12, // 48: hashicorp.consul.resource.ResourceService.List:output_type -> hashicorp.consul.resource.ListResponse
	14, // 49: hashicorp.consul.resource.ResourceService.ListByOwner:output_type -> hashicorp.consul.resource.ListByOwnerResponse
	20, // 50: hashicorp.consul.resource.ResourceService.Delete:output_type -> hashicorp.consul.resource.DeleteResponse
	22, // 51: hashicorp.consul.resource.ResourceService.WatchList:output_type -> hashicorp.consul.resource.WatchEvent
	24, // 52: hashicorp.consul.resource.ResourceService.MutateAndValidate:output_type -> hashicorp.consul.resource.MutateAndValidateResponse
	45, // [45:53] is the sub-list for method output_type
	37, // [37:45] is the sub-list for method input_type
	37, // [37:37] is the sub-list for extension type_name
	37, // [37:37] is the sub-list for extension extendee
	0,  // [0:37] is the sub-list for field type_name
}

func init() { file_pbresource_resource_proto_init() }
func file_pbresource_resource_proto_init() {
	if File_pbresource_resource_proto != nil {
		return
	}
	file_pbresource_resource_proto_msgTypes[21].OneofWrappers = []any{
		(*WatchEvent_Upsert_)(nil),
		(*WatchEvent_Delete_)(nil),
		(*WatchEvent_EndOfSnapshot_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_pbresource_resource_proto_rawDesc), len(file_pbresource_resource_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pbresource_resource_proto_goTypes,
		DependencyIndexes: file_pbresource_resource_proto_depIdxs,
		EnumInfos:         file_pbresource_resource_proto_enumTypes,
		MessageInfos:      file_pbresource_resource_proto_msgTypes,
	}.Build()
	File_pbresource_resource_proto = out.File
	file_pbresource_resource_proto_goTypes = nil
	file_pbresource_resource_proto_depIdxs = nil
}
