// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: private/pbpeerstream/peerstream.proto

package pbpeerstream

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	pbpeering "github.com/hashicorp/consul/proto/private/pbpeering"
	pbservice "github.com/hashicorp/consul/proto/private/pbservice"
	pbstatus "github.com/hashicorp/consul/proto/private/pbstatus"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Operation enumerates supported operations for replicated resources.
type Operation int32

const (
	Operation_OPERATION_UNSPECIFIED Operation = 0
	// UPSERT represents a create or update event.
	Operation_OPERATION_UPSERT Operation = 1
)

// Enum value maps for Operation.
var (
	Operation_name = map[int32]string{
		0: "OPERATION_UNSPECIFIED",
		1: "OPERATION_UPSERT",
	}
	Operation_value = map[string]int32{
		"OPERATION_UNSPECIFIED": 0,
		"OPERATION_UPSERT":      1,
	}
)

func (x Operation) Enum() *Operation {
	p := new(Operation)
	*p = x
	return p
}

func (x Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbpeerstream_peerstream_proto_enumTypes[0].Descriptor()
}

func (Operation) Type() protoreflect.EnumType {
	return &file_private_pbpeerstream_peerstream_proto_enumTypes[0]
}

func (x Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation.Descriptor instead.
func (Operation) EnumDescriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0}
}

type ReplicationMessage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Payload:
	//
	//	*ReplicationMessage_Open_
	//	*ReplicationMessage_Request_
	//	*ReplicationMessage_Response_
	//	*ReplicationMessage_Terminated_
	//	*ReplicationMessage_Heartbeat_
	Payload       isReplicationMessage_Payload `protobuf_oneof:"Payload"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicationMessage) Reset() {
	*x = ReplicationMessage{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage) ProtoMessage() {}

func (x *ReplicationMessage) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage.ProtoReflect.Descriptor instead.
func (*ReplicationMessage) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0}
}

func (x *ReplicationMessage) GetPayload() isReplicationMessage_Payload {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *ReplicationMessage) GetOpen() *ReplicationMessage_Open {
	if x != nil {
		if x, ok := x.Payload.(*ReplicationMessage_Open_); ok {
			return x.Open
		}
	}
	return nil
}

func (x *ReplicationMessage) GetRequest() *ReplicationMessage_Request {
	if x != nil {
		if x, ok := x.Payload.(*ReplicationMessage_Request_); ok {
			return x.Request
		}
	}
	return nil
}

func (x *ReplicationMessage) GetResponse() *ReplicationMessage_Response {
	if x != nil {
		if x, ok := x.Payload.(*ReplicationMessage_Response_); ok {
			return x.Response
		}
	}
	return nil
}

func (x *ReplicationMessage) GetTerminated() *ReplicationMessage_Terminated {
	if x != nil {
		if x, ok := x.Payload.(*ReplicationMessage_Terminated_); ok {
			return x.Terminated
		}
	}
	return nil
}

func (x *ReplicationMessage) GetHeartbeat() *ReplicationMessage_Heartbeat {
	if x != nil {
		if x, ok := x.Payload.(*ReplicationMessage_Heartbeat_); ok {
			return x.Heartbeat
		}
	}
	return nil
}

type isReplicationMessage_Payload interface {
	isReplicationMessage_Payload()
}

type ReplicationMessage_Open_ struct {
	Open *ReplicationMessage_Open `protobuf:"bytes,1,opt,name=open,proto3,oneof"`
}

type ReplicationMessage_Request_ struct {
	Request *ReplicationMessage_Request `protobuf:"bytes,2,opt,name=request,proto3,oneof"`
}

type ReplicationMessage_Response_ struct {
	Response *ReplicationMessage_Response `protobuf:"bytes,3,opt,name=response,proto3,oneof"`
}

type ReplicationMessage_Terminated_ struct {
	Terminated *ReplicationMessage_Terminated `protobuf:"bytes,4,opt,name=terminated,proto3,oneof"`
}

type ReplicationMessage_Heartbeat_ struct {
	Heartbeat *ReplicationMessage_Heartbeat `protobuf:"bytes,5,opt,name=heartbeat,proto3,oneof"`
}

func (*ReplicationMessage_Open_) isReplicationMessage_Payload() {}

func (*ReplicationMessage_Request_) isReplicationMessage_Payload() {}

func (*ReplicationMessage_Response_) isReplicationMessage_Payload() {}

func (*ReplicationMessage_Terminated_) isReplicationMessage_Payload() {}

func (*ReplicationMessage_Heartbeat_) isReplicationMessage_Payload() {}

// LeaderAddress is sent when the peering service runs on a consul node
// that is not a leader. The node either lost leadership, or never was a leader.
type LeaderAddress struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// address is an ip:port best effort hint at what could be the cluster leader's address
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LeaderAddress) Reset() {
	*x = LeaderAddress{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LeaderAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeaderAddress) ProtoMessage() {}

func (x *LeaderAddress) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeaderAddress.ProtoReflect.Descriptor instead.
func (*LeaderAddress) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{1}
}

func (x *LeaderAddress) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// ExportedService is one of the types of data returned via peer stream replication.
type ExportedService struct {
	state         protoimpl.MessageState        `protogen:"open.v1"`
	Nodes         []*pbservice.CheckServiceNode `protobuf:"bytes,1,rep,name=Nodes,proto3" json:"Nodes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExportedService) Reset() {
	*x = ExportedService{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportedService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportedService) ProtoMessage() {}

func (x *ExportedService) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportedService.ProtoReflect.Descriptor instead.
func (*ExportedService) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{2}
}

func (x *ExportedService) GetNodes() []*pbservice.CheckServiceNode {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// ExportedServiceList is one of the types of data returned via peer stream replication.
type ExportedServiceList struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The identifiers for the services being exported.
	Services      []string `protobuf:"bytes,1,rep,name=Services,proto3" json:"Services,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExportedServiceList) Reset() {
	*x = ExportedServiceList{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportedServiceList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportedServiceList) ProtoMessage() {}

func (x *ExportedServiceList) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportedServiceList.ProtoReflect.Descriptor instead.
func (*ExportedServiceList) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{3}
}

func (x *ExportedServiceList) GetServices() []string {
	if x != nil {
		return x.Services
	}
	return nil
}

type ExchangeSecretRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// PeerID is the ID of the peering, as determined by the cluster that generated the
	// peering token.
	PeerID string `protobuf:"bytes,1,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	// EstablishmentSecret is the one-time-use secret encoded in the received peering token.
	EstablishmentSecret string `protobuf:"bytes,2,opt,name=EstablishmentSecret,proto3" json:"EstablishmentSecret,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ExchangeSecretRequest) Reset() {
	*x = ExchangeSecretRequest{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExchangeSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeSecretRequest) ProtoMessage() {}

func (x *ExchangeSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeSecretRequest.ProtoReflect.Descriptor instead.
func (*ExchangeSecretRequest) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{4}
}

func (x *ExchangeSecretRequest) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (x *ExchangeSecretRequest) GetEstablishmentSecret() string {
	if x != nil {
		return x.EstablishmentSecret
	}
	return ""
}

type ExchangeSecretResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// StreamSecret is the long-lived secret to be used for authentication with the
	// peering stream handler.
	StreamSecret  string `protobuf:"bytes,1,opt,name=StreamSecret,proto3" json:"StreamSecret,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExchangeSecretResponse) Reset() {
	*x = ExchangeSecretResponse{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExchangeSecretResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangeSecretResponse) ProtoMessage() {}

func (x *ExchangeSecretResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangeSecretResponse.ProtoReflect.Descriptor instead.
func (*ExchangeSecretResponse) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{5}
}

func (x *ExchangeSecretResponse) GetStreamSecret() string {
	if x != nil {
		return x.StreamSecret
	}
	return ""
}

// Open is the initial message send by a dialing peer to establish the peering stream.
type ReplicationMessage_Open struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// An identifier for the peer making the request.
	// This identifier is provisioned by the serving peer prior to the request from the dialing peer.
	PeerID string `protobuf:"bytes,1,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	// StreamSecretID contains the long-lived secret from stream authn/authz.
	StreamSecretID string `protobuf:"bytes,2,opt,name=StreamSecretID,proto3" json:"StreamSecretID,omitempty"`
	// Remote contains metadata about the remote peer.
	Remote        *pbpeering.RemoteInfo `protobuf:"bytes,3,opt,name=Remote,proto3" json:"Remote,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicationMessage_Open) Reset() {
	*x = ReplicationMessage_Open{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationMessage_Open) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Open) ProtoMessage() {}

func (x *ReplicationMessage_Open) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Open.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Open) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ReplicationMessage_Open) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (x *ReplicationMessage_Open) GetStreamSecretID() string {
	if x != nil {
		return x.StreamSecretID
	}
	return ""
}

func (x *ReplicationMessage_Open) GetRemote() *pbpeering.RemoteInfo {
	if x != nil {
		return x.Remote
	}
	return nil
}

// A Request requests to subscribe to a resource of a given type.
type ReplicationMessage_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// An identifier for the peer making the request.
	// This identifier is provisioned by the serving peer prior to the request from the dialing peer.
	PeerID string `protobuf:"bytes,1,opt,name=PeerID,proto3" json:"PeerID,omitempty"`
	// ResponseNonce corresponding to that of the response being ACKed or NACKed.
	// Initial subscription requests will have an empty nonce.
	// The nonce is generated and incremented by the exporting peer.
	// TODO
	ResponseNonce string `protobuf:"bytes,2,opt,name=ResponseNonce,proto3" json:"ResponseNonce,omitempty"`
	// The type URL for the resource being requested or ACK/NACKed.
	ResourceURL string `protobuf:"bytes,3,opt,name=ResourceURL,proto3" json:"ResourceURL,omitempty"`
	// The error if the previous response was not applied successfully.
	// This field is empty in the first subscription request.
	Error         *pbstatus.Status `protobuf:"bytes,5,opt,name=Error,proto3" json:"Error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicationMessage_Request) Reset() {
	*x = ReplicationMessage_Request{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationMessage_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Request) ProtoMessage() {}

func (x *ReplicationMessage_Request) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Request.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Request) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ReplicationMessage_Request) GetPeerID() string {
	if x != nil {
		return x.PeerID
	}
	return ""
}

func (x *ReplicationMessage_Request) GetResponseNonce() string {
	if x != nil {
		return x.ResponseNonce
	}
	return ""
}

func (x *ReplicationMessage_Request) GetResourceURL() string {
	if x != nil {
		return x.ResourceURL
	}
	return ""
}

func (x *ReplicationMessage_Request) GetError() *pbstatus.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A Response contains resources corresponding to a subscription request.
type ReplicationMessage_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Nonce identifying a response in a stream.
	Nonce string `protobuf:"bytes,1,opt,name=Nonce,proto3" json:"Nonce,omitempty"`
	// The type URL of resource being returned.
	ResourceURL string `protobuf:"bytes,2,opt,name=ResourceURL,proto3" json:"ResourceURL,omitempty"`
	// An identifier for the resource being returned.
	// This could be the SPIFFE ID of the service.
	ResourceID string `protobuf:"bytes,3,opt,name=ResourceID,proto3" json:"ResourceID,omitempty"`
	// The resource being returned.
	Resource *anypb.Any `protobuf:"bytes,4,opt,name=Resource,proto3" json:"Resource,omitempty"`
	// REQUIRED. The operation to be performed in relation to the resource.
	Operation     Operation `protobuf:"varint,5,opt,name=operation,proto3,enum=hashicorp.consul.internal.peerstream.Operation" json:"operation,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicationMessage_Response) Reset() {
	*x = ReplicationMessage_Response{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationMessage_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Response) ProtoMessage() {}

func (x *ReplicationMessage_Response) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Response.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Response) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 2}
}

func (x *ReplicationMessage_Response) GetNonce() string {
	if x != nil {
		return x.Nonce
	}
	return ""
}

func (x *ReplicationMessage_Response) GetResourceURL() string {
	if x != nil {
		return x.ResourceURL
	}
	return ""
}

func (x *ReplicationMessage_Response) GetResourceID() string {
	if x != nil {
		return x.ResourceID
	}
	return ""
}

func (x *ReplicationMessage_Response) GetResource() *anypb.Any {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *ReplicationMessage_Response) GetOperation() Operation {
	if x != nil {
		return x.Operation
	}
	return Operation_OPERATION_UNSPECIFIED
}

// Terminated is sent when a peering is deleted locally.
// This message signals to the peer that they should clean up their local state about the peering.
type ReplicationMessage_Terminated struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicationMessage_Terminated) Reset() {
	*x = ReplicationMessage_Terminated{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationMessage_Terminated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Terminated) ProtoMessage() {}

func (x *ReplicationMessage_Terminated) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Terminated.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Terminated) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 3}
}

// Heartbeat is sent to verify that the connection is still active.
type ReplicationMessage_Heartbeat struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicationMessage_Heartbeat) Reset() {
	*x = ReplicationMessage_Heartbeat{}
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationMessage_Heartbeat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationMessage_Heartbeat) ProtoMessage() {}

func (x *ReplicationMessage_Heartbeat) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbpeerstream_peerstream_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationMessage_Heartbeat.ProtoReflect.Descriptor instead.
func (*ReplicationMessage_Heartbeat) Descriptor() ([]byte, []int) {
	return file_private_pbpeerstream_peerstream_proto_rawDescGZIP(), []int{0, 4}
}

var File_private_pbpeerstream_peerstream_proto protoreflect.FileDescriptor

const file_private_pbpeerstream_peerstream_proto_rawDesc = "" +
	"\n" +
	"%private/pbpeerstream/peerstream.proto\x12$hashicorp.consul.internal.peerstream\x1a%annotations/ratelimit/ratelimit.proto\x1a\x19google/protobuf/any.proto\x1a\x1fprivate/pbpeering/peering.proto\x1a\x1cprivate/pbservice/node.proto\x1a\x1dprivate/pbstatus/status.proto\"\xbb\b\n" +
	"\x12ReplicationMessage\x12S\n" +
	"\x04open\x18\x01 \x01(\v2=.hashicorp.consul.internal.peerstream.ReplicationMessage.OpenH\x00R\x04open\x12\\\n" +
	"\arequest\x18\x02 \x01(\v2@.hashicorp.consul.internal.peerstream.ReplicationMessage.RequestH\x00R\arequest\x12_\n" +
	"\bresponse\x18\x03 \x01(\v2A.hashicorp.consul.internal.peerstream.ReplicationMessage.ResponseH\x00R\bresponse\x12e\n" +
	"\n" +
	"terminated\x18\x04 \x01(\v2C.hashicorp.consul.internal.peerstream.ReplicationMessage.TerminatedH\x00R\n" +
	"terminated\x12b\n" +
	"\theartbeat\x18\x05 \x01(\v2B.hashicorp.consul.internal.peerstream.ReplicationMessage.HeartbeatH\x00R\theartbeat\x1a\x8d\x01\n" +
	"\x04Open\x12\x16\n" +
	"\x06PeerID\x18\x01 \x01(\tR\x06PeerID\x12&\n" +
	"\x0eStreamSecretID\x18\x02 \x01(\tR\x0eStreamSecretID\x12E\n" +
	"\x06Remote\x18\x03 \x01(\v2-.hashicorp.consul.internal.peering.RemoteInfoR\x06Remote\x1a\xa9\x01\n" +
	"\aRequest\x12\x16\n" +
	"\x06PeerID\x18\x01 \x01(\tR\x06PeerID\x12$\n" +
	"\rResponseNonce\x18\x02 \x01(\tR\rResponseNonce\x12 \n" +
	"\vResourceURL\x18\x03 \x01(\tR\vResourceURL\x12>\n" +
	"\x05Error\x18\x05 \x01(\v2(.hashicorp.consul.internal.status.StatusR\x05Error\x1a\xe3\x01\n" +
	"\bResponse\x12\x14\n" +
	"\x05Nonce\x18\x01 \x01(\tR\x05Nonce\x12 \n" +
	"\vResourceURL\x18\x02 \x01(\tR\vResourceURL\x12\x1e\n" +
	"\n" +
	"ResourceID\x18\x03 \x01(\tR\n" +
	"ResourceID\x120\n" +
	"\bResource\x18\x04 \x01(\v2\x14.google.protobuf.AnyR\bResource\x12M\n" +
	"\toperation\x18\x05 \x01(\x0e2/.hashicorp.consul.internal.peerstream.OperationR\toperation\x1a\f\n" +
	"\n" +
	"Terminated\x1a\v\n" +
	"\tHeartbeatB\t\n" +
	"\aPayload\")\n" +
	"\rLeaderAddress\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\"\\\n" +
	"\x0fExportedService\x12I\n" +
	"\x05Nodes\x18\x01 \x03(\v23.hashicorp.consul.internal.service.CheckServiceNodeR\x05Nodes\"1\n" +
	"\x13ExportedServiceList\x12\x1a\n" +
	"\bServices\x18\x01 \x03(\tR\bServices\"a\n" +
	"\x15ExchangeSecretRequest\x12\x16\n" +
	"\x06PeerID\x18\x01 \x01(\tR\x06PeerID\x120\n" +
	"\x13EstablishmentSecret\x18\x02 \x01(\tR\x13EstablishmentSecret\"<\n" +
	"\x16ExchangeSecretResponse\x12\"\n" +
	"\fStreamSecret\x18\x01 \x01(\tR\fStreamSecret*<\n" +
	"\tOperation\x12\x19\n" +
	"\x15OPERATION_UNSPECIFIED\x10\x00\x12\x14\n" +
	"\x10OPERATION_UPSERT\x10\x012\xc1\x02\n" +
	"\x11PeerStreamService\x12\x93\x01\n" +
	"\x0fStreamResources\x128.hashicorp.consul.internal.peerstream.ReplicationMessage\x1a8.hashicorp.consul.internal.peerstream.ReplicationMessage\"\b\xe2\x86\x04\x04\b\x02\x10\x02(\x010\x01\x12\x95\x01\n" +
	"\x0eExchangeSecret\x12;.hashicorp.consul.internal.peerstream.ExchangeSecretRequest\x1a<.hashicorp.consul.internal.peerstream.ExchangeSecretResponse\"\b\xe2\x86\x04\x04\b\x03\x10\x02B\xa7\x02\n" +
	"(com.hashicorp.consul.internal.peerstreamB\x0fPeerstreamProtoP\x01Z6github.com/hashicorp/consul/proto/private/pbpeerstream\xa2\x02\x04HCIP\xaa\x02$Hashicorp.Consul.Internal.Peerstream\xca\x02$Hashicorp\\Consul\\Internal\\Peerstream\xe2\x020Hashicorp\\Consul\\Internal\\Peerstream\\GPBMetadata\xea\x02'Hashicorp::Consul::Internal::Peerstreamb\x06proto3"

var (
	file_private_pbpeerstream_peerstream_proto_rawDescOnce sync.Once
	file_private_pbpeerstream_peerstream_proto_rawDescData []byte
)

func file_private_pbpeerstream_peerstream_proto_rawDescGZIP() []byte {
	file_private_pbpeerstream_peerstream_proto_rawDescOnce.Do(func() {
		file_private_pbpeerstream_peerstream_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_private_pbpeerstream_peerstream_proto_rawDesc), len(file_private_pbpeerstream_peerstream_proto_rawDesc)))
	})
	return file_private_pbpeerstream_peerstream_proto_rawDescData
}

var file_private_pbpeerstream_peerstream_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_private_pbpeerstream_peerstream_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_private_pbpeerstream_peerstream_proto_goTypes = []any{
	(Operation)(0),                        // 0: hashicorp.consul.internal.peerstream.Operation
	(*ReplicationMessage)(nil),            // 1: hashicorp.consul.internal.peerstream.ReplicationMessage
	(*LeaderAddress)(nil),                 // 2: hashicorp.consul.internal.peerstream.LeaderAddress
	(*ExportedService)(nil),               // 3: hashicorp.consul.internal.peerstream.ExportedService
	(*ExportedServiceList)(nil),           // 4: hashicorp.consul.internal.peerstream.ExportedServiceList
	(*ExchangeSecretRequest)(nil),         // 5: hashicorp.consul.internal.peerstream.ExchangeSecretRequest
	(*ExchangeSecretResponse)(nil),        // 6: hashicorp.consul.internal.peerstream.ExchangeSecretResponse
	(*ReplicationMessage_Open)(nil),       // 7: hashicorp.consul.internal.peerstream.ReplicationMessage.Open
	(*ReplicationMessage_Request)(nil),    // 8: hashicorp.consul.internal.peerstream.ReplicationMessage.Request
	(*ReplicationMessage_Response)(nil),   // 9: hashicorp.consul.internal.peerstream.ReplicationMessage.Response
	(*ReplicationMessage_Terminated)(nil), // 10: hashicorp.consul.internal.peerstream.ReplicationMessage.Terminated
	(*ReplicationMessage_Heartbeat)(nil),  // 11: hashicorp.consul.internal.peerstream.ReplicationMessage.Heartbeat
	(*pbservice.CheckServiceNode)(nil),    // 12: hashicorp.consul.internal.service.CheckServiceNode
	(*pbpeering.RemoteInfo)(nil),          // 13: hashicorp.consul.internal.peering.RemoteInfo
	(*pbstatus.Status)(nil),               // 14: hashicorp.consul.internal.status.Status
	(*anypb.Any)(nil),                     // 15: google.protobuf.Any
}
var file_private_pbpeerstream_peerstream_proto_depIdxs = []int32{
	7,  // 0: hashicorp.consul.internal.peerstream.ReplicationMessage.open:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Open
	8,  // 1: hashicorp.consul.internal.peerstream.ReplicationMessage.request:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Request
	9,  // 2: hashicorp.consul.internal.peerstream.ReplicationMessage.response:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Response
	10, // 3: hashicorp.consul.internal.peerstream.ReplicationMessage.terminated:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Terminated
	11, // 4: hashicorp.consul.internal.peerstream.ReplicationMessage.heartbeat:type_name -> hashicorp.consul.internal.peerstream.ReplicationMessage.Heartbeat
	12, // 5: hashicorp.consul.internal.peerstream.ExportedService.Nodes:type_name -> hashicorp.consul.internal.service.CheckServiceNode
	13, // 6: hashicorp.consul.internal.peerstream.ReplicationMessage.Open.Remote:type_name -> hashicorp.consul.internal.peering.RemoteInfo
	14, // 7: hashicorp.consul.internal.peerstream.ReplicationMessage.Request.Error:type_name -> hashicorp.consul.internal.status.Status
	15, // 8: hashicorp.consul.internal.peerstream.ReplicationMessage.Response.Resource:type_name -> google.protobuf.Any
	0,  // 9: hashicorp.consul.internal.peerstream.ReplicationMessage.Response.operation:type_name -> hashicorp.consul.internal.peerstream.Operation
	1,  // 10: hashicorp.consul.internal.peerstream.PeerStreamService.StreamResources:input_type -> hashicorp.consul.internal.peerstream.ReplicationMessage
	5,  // 11: hashicorp.consul.internal.peerstream.PeerStreamService.ExchangeSecret:input_type -> hashicorp.consul.internal.peerstream.ExchangeSecretRequest
	1,  // 12: hashicorp.consul.internal.peerstream.PeerStreamService.StreamResources:output_type -> hashicorp.consul.internal.peerstream.ReplicationMessage
	6,  // 13: hashicorp.consul.internal.peerstream.PeerStreamService.ExchangeSecret:output_type -> hashicorp.consul.internal.peerstream.ExchangeSecretResponse
	12, // [12:14] is the sub-list for method output_type
	10, // [10:12] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_private_pbpeerstream_peerstream_proto_init() }
func file_private_pbpeerstream_peerstream_proto_init() {
	if File_private_pbpeerstream_peerstream_proto != nil {
		return
	}
	file_private_pbpeerstream_peerstream_proto_msgTypes[0].OneofWrappers = []any{
		(*ReplicationMessage_Open_)(nil),
		(*ReplicationMessage_Request_)(nil),
		(*ReplicationMessage_Response_)(nil),
		(*ReplicationMessage_Terminated_)(nil),
		(*ReplicationMessage_Heartbeat_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_private_pbpeerstream_peerstream_proto_rawDesc), len(file_private_pbpeerstream_peerstream_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_private_pbpeerstream_peerstream_proto_goTypes,
		DependencyIndexes: file_private_pbpeerstream_peerstream_proto_depIdxs,
		EnumInfos:         file_private_pbpeerstream_peerstream_proto_enumTypes,
		MessageInfos:      file_private_pbpeerstream_peerstream_proto_msgTypes,
	}.Build()
	File_private_pbpeerstream_peerstream_proto = out.File
	file_private_pbpeerstream_peerstream_proto_goTypes = nil
	file_private_pbpeerstream_peerstream_proto_depIdxs = nil
}
