// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             (unknown)
// source: private/pboperator/operator.proto

package pboperator

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	OperatorService_TransferLeader_FullMethodName = "/hashicorp.consul.internal.operator.OperatorService/TransferLeader"
)

// OperatorServiceClient is the client API for OperatorService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Operator defines a set of operators operation applicable to Consul
type OperatorServiceClient interface {
	// Transfer raft leadership to another node
	TransferLeader(ctx context.Context, in *TransferLeaderRequest, opts ...grpc.CallOption) (*TransferLeaderResponse, error)
}

type operatorServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewOperatorServiceClient(cc grpc.ClientConnInterface) OperatorServiceClient {
	return &operatorServiceClient{cc}
}

func (c *operatorServiceClient) TransferLeader(ctx context.Context, in *TransferLeaderRequest, opts ...grpc.CallOption) (*TransferLeaderResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TransferLeaderResponse)
	err := c.cc.Invoke(ctx, OperatorService_TransferLeader_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OperatorServiceServer is the server API for OperatorService service.
// All implementations should embed UnimplementedOperatorServiceServer
// for forward compatibility.
//
// Operator defines a set of operators operation applicable to Consul
type OperatorServiceServer interface {
	// Transfer raft leadership to another node
	TransferLeader(context.Context, *TransferLeaderRequest) (*TransferLeaderResponse, error)
}

// UnimplementedOperatorServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedOperatorServiceServer struct{}

func (UnimplementedOperatorServiceServer) TransferLeader(context.Context, *TransferLeaderRequest) (*TransferLeaderResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferLeader not implemented")
}
func (UnimplementedOperatorServiceServer) testEmbeddedByValue() {}

// UnsafeOperatorServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OperatorServiceServer will
// result in compilation errors.
type UnsafeOperatorServiceServer interface {
	mustEmbedUnimplementedOperatorServiceServer()
}

func RegisterOperatorServiceServer(s grpc.ServiceRegistrar, srv OperatorServiceServer) {
	// If the following call pancis, it indicates UnimplementedOperatorServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&OperatorService_ServiceDesc, srv)
}

func _OperatorService_TransferLeader_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferLeaderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperatorServiceServer).TransferLeader(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperatorService_TransferLeader_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperatorServiceServer).TransferLeader(ctx, req.(*TransferLeaderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// OperatorService_ServiceDesc is the grpc.ServiceDesc for OperatorService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var OperatorService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "hashicorp.consul.internal.operator.OperatorService",
	HandlerType: (*OperatorServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TransferLeader",
			Handler:    _OperatorService_TransferLeader_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "private/pboperator/operator.proto",
}
