/******************************************************************************
* choria
* Copyright (c) 2025 Alan Witkowski
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*******************************************************************************/
#include <objects/components/fighter.h>
#include <ae/ui.h>
#include <hud/hud.h>
#include <objects/item.h>
#include <objects/status_effect.h>

// Get starting side for potential action based on target type
int _Fighter::GetStartingSide(const _Item *Item) {

	// Default to enemy side
	int StartingSide = !BattleSide;

	// Check for self/ally target
	if(Item->TargetID != TargetType::ANY && Item->CanTargetAlly())
		StartingSide = BattleSide;

	return StartingSide;
}

// Create a UI element for battle
void _Fighter::CreateBattleElement(ae::_Element *Parent) {
	if(BattleElement)
		throw std::runtime_error(std::string(__func__) + " BattleElement already exists!");

	BattleElement = new ae::_Element();
	BattleElement->ID = "battle_element";
	BattleElement->BaseSize = glm::vec2(100 + BATTLE_HEALTHBAR_WIDTH + 10, 100);
	BattleElement->BaseOffset = BattleBaseOffset;
	BattleElement->Alignment = ae::CENTER_MIDDLE;
	BattleElement->Active = true;
	BattleElement->Index = _HUD::WINDOW_HUD_EFFECTS;
	BattleElement->UserData = Object;
	BattleElement->Parent = Parent;
	BattleElement->Clickable = true;
	BattleElement->CalculateBounds();
	Parent->Children.push_back(BattleElement);
}

// Remove battle element
void _Fighter::RemoveBattleElement() {
	if(!BattleElement)
		return;

	if(BattleElement->Parent)
		BattleElement->Parent->RemoveChild(BattleElement);

	// Prevent StatusEffect's destructor from deleting the battle element
	for(auto &Child : BattleElement->Children) {
		if(Child->UserData)
			((_StatusEffect *)Child->UserData)->BattleElement = nullptr;
	}

	delete BattleElement;
	BattleElement = nullptr;
}
