/******************************************************************************
* choria
* Copyright (c) 2025 Alan Witkowski
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*******************************************************************************/
#pragma once

// Libraries
#include <hud/screen.h>
#include <vector>

// Classes
class _TraderScreen : public _Screen {

	public:

		_TraderScreen(ae::_Element *CurrentElement) : _Screen(CurrentElement) { }

		void Init() override;
		bool Close(bool SendNotify=true, bool Delay=false) override;

		void TradeItem();

		void Update(double FrameTime);
		void Render(double BlendFactor) override;

		// Items
		std::vector<int> RequiredAmounts;
		std::vector<int> RequiredTotals;
		int RewardTotal;

	private:

		bool CanUse{false};
		int UsesLeft{0};
		int LastAmount{0};

};
