#	CMake module to find libwebp
#	Alan Witkowski
#
#	Input:
# 		WEBP_ROOT          - Environment variable that points to the libwebp root directory
#
#	Output:
#		WEBP_FOUND         - Set to true if libwebp was found
#		WEBP_INCLUDE_DIR   - Path to decode.h
#		WEBP_LIBRARIES     - Contains the list of libwebp libraries
#

set(WEBP_FOUND false)

# find include path
find_path(
		WEBP_INCLUDE_DIR
	NAMES
		decode.h
	HINTS
		ENV WEBP_ROOT
		ENV WEBPDIR
	PATHS
		/usr
		/usr/local
	PATH_SUFFIXES
		include/webp
)

# find library
find_library(
		WEBP_LIBRARY webp
	HINTS
		ENV WEBP_ROOT
		ENV WEBPDIR
	PATHS
		/usr
		/usr/local
	PATH_SUFFIXES
		lib
)

# set libraries var
set(WEBP_LIBRARIES ${WEBP_LIBRARY})

# handle QUIET and REQUIRED
include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(WebP DEFAULT_MSG WEBP_LIBRARIES WEBP_INCLUDE_DIR)

# advanced variables only show up in gui if show advanced is turned on
mark_as_advanced(WEBP_INCLUDE_DIR WEBP_LIBRARIES)
