#!/bin/bash

# check programs
for program in "ninja" "cmake"; do
	type $program >/dev/null 2>&1 || {
		echo >&2 "'$program' is not installed!"
		exit 1
	}
done

# constants
generator="Ninja"

# get type
build_type="Release"
if [ -n "$1" ]; then
	build_type="$1"
fi

# get build dir
build_dir=$(echo "$build_type" | tr '[:upper:]' '[:lower:]')

# build
cmake -G "$generator" -D "CMAKE_BUILD_TYPE=$build_type" -B "build/$build_dir"
cmake --build "build/$build_dir"
