from __future__ import print_function
import sys
import time
from pdb import pm
from miasm.core.utils import decode_hex
from miasm.arch.aarch64.arch import *
from miasm.core.locationdb import LocationDB

loc_db = LocationDB()

reg_tests_aarch64 = [

    ("XXXXXXXX    MOV        W1, WZR",
     "E1031F2A"),
    ("XXXXXXXX    TST        W5, W3",
     "BF00036A"),
    ("XXXXXXXX    LDP        X19, X20, [SP, 0x10]",
     "F35341A9"),
    ("XXXXXXXX    STP        X24, X23, [SP, 0x10]",
     "F85F01A9"),

    ("004024DC    MVN        X1, X0",
     "E10320AA"),

    ("00011374    SUB        SP, SP, 0x20",
     "FF8300D1"),
    ("0009F254    SUB        W19, W19, 0x40",
     "73020151"),
    ("00025F24    SUBS       W3, W0, 0x1",
     "03040071"),
    ("00071338    SUBS       X1, X1, 0x1",
     "210400F1"),
    ("0000E678    SUB        SP, SP, 0x360",
     "FF830DD1"),
    ("0000E7E4    ADD        X0, X24, 0x40",
     "00030191"),
    ("00011230    ADDS       X19, X19, 0x8",
     "732200B1"),
    ("0000CC68    ADRP       X3, 0xCF000",
     "630600F0"),
    ("000432A0    ADR        X1, 0xC",
     "61000010"),
    ("0000E928    SUB        X22, X22, X2",
     "D60202CB"),
    ("00035B50    SUB        W2, W0, W1",
     "0200014B"),
    ("00012018    ADD        X0, X0, X3 LSL 0x1",
     "0004038B"),
    ("0000E9A4    SUBS       W23, W2, W23",
     "5700176B"),
    ("0006D500    ADD        X0, X0, 0x1000",
     "00044091"),
    ("000A57C0    ADD        X0, X0, 0x5000",
     "00144091"),
    ("0001EDF4    ADD        W0, W0, W2 LSR 0x1",
     "0004420B"),
    ("00067434    ADD        X19, X0, X19 LSR 0x3",
     "130C538B"),
    ("0008E148    SUB        W20, W1, W20 ASR 0x1",
     "3404944B"),
    ("00013258    SUB        X19, X1, X19 ASR 0x3F",
     "33FC93CB"),
    ("0000D66C    SUB        SP, X23, X0 UXTX 0x0",
     "FF6220CB"),
    ("00071EF4    SUBS       X0, X0, 0x10000",
     "004040F1"),
    ("0000D5AC    NEG        W6, W6",
     "E603064B"),


    ("004028B8    CMP        X0, XZR",
     "1F001FEB"),
    ("004029D0    CMP        X0, 0x3F",
     "1FFC00F1"),

    ("XXXXXXXX    CMN        W12, W9",
     "9F01092B"),
    ("XXXXXXXX    CMN        W0, 0x1",
     "1F040031"),

    ("0007FA38    AND        W0, W0, 0x7000000",
     "00080812"),

    ("0009E5C4    AND        W0, W0, 0xFF",
     "001C0012"),
    ("0007BDB0    AND        W0, W0, 0x7",
     "00080012"),

    ("000A0A14    EOR        W24, W24, 0x6",
     "18071F52"),

    ("0004A0C0    EOR        W19, W0, 0x3",
     "13040052"),

    ("00010234    EOR        W0, W0, 0x4000",
     "00001252"),

    ("00020924    EOR        W0, W0, 0x4",
     "00001E52"),

    ("0002094C    EOR        W0, W0, 0x8",
     "00001D52"),
    ("0004B410    EOR        W0, W0, 0x1",
     "00000052"),


    ("000466BC    AND        X19, X0, 0xFFFFFFFFFFFFFFF8",
     "13F07D92"),
    ("0000FA3C    AND        W0, W0, 0xFF00",
     "001C1812"),
    ("0002049C    AND        W1, W0, 0x7FFF",
     "01380012"),
    ("0001F650    AND        X0, X0, 0x1FFFFFFF0",
     "00707C92"),
    ("0009B4B0    AND        W0, W0, 0xFFFFFF87",
     "006C1912"),
    ("0005D7D4    AND        W0, W0, 0xFF0000FF",
     "003C0812"),
    ("0000D564    ORR        W0, W0, 0xFFFFFFF8",
     "00701D32"),
    ("00065E24    ORR        X19, X19, 0x1",
     "730240B2"),
    ("000165AC    ANDS       W0, W24, 0xE",
     "000B1F72"),
    ("00079A80    ANDS       X20, X2, 0xFF",
     "541C40F2"),
    ("XXXXXXXX    TST        W14, 0x1",
     "DF010072"),
    ("XXXXXXXX    ANDS       W12, W13, 0x1",
     "AC010072"),


    ("0005BD5C    AND        W0, W0, W24",
     "0000180A"),
    ("0008F824    AND        W0, W24, W23",
     "0003170A"),
    ("0001AFE4    BIC        X5, X23, X5",
     "E502258A"),

    ("000A36B4    BIC        W0, W21, W19",
     "A002330A"),
    ("0000CD54    ORR        W0, W2, W0 LSL 0x10",
     "4040002A"),
    ("0000CD88    ORR        X0, X0, X1 LSL 0x20",
     "008001AA"),
    ("0001C420    ORR        X21, X21, X0 LSL 0x30",
     "B5C200AA"),
    ("0006C060    ORR        W1, W5, W1 ASR 0x8",
     "A120812A"),
    ("0002962C    ORN        W0, W0, W25",
     "0000392A"),
    ("0000FBE4    EOR        W1, W1, W0",
     "2100004A"),
    ("0001C3B0    EOR        X3, X2, X2 ASR 0x3F",
     "43FC82CA"),
    ("00022174    EOR        W3, W3, W1 LSL 0x8",
     "6320014A"),
    ("00010B0C    ANDS       W19, W19, W1",
     "7302016A"),
    ("0006634C    ANDS       X2, X20, X2",
     "820202EA"),
    ("0003E0C8    BICS       W19, W19, W2",
     "7302226A"),

    ("00026388    MOVK       W0, 0x4550 LSL 0x10",
     "00AAA872"),
    ("000218A4    MOVZ       W0, 0x2580",
     "00B08452"),
    ("000340E8    MOVZ       X1, 0x0",
     "010080D2"),
    ("0001D628    MOVZ       X1, 0x100000",
     "0102A0D2"),
    ("0003317C    MOVN       W2, 0x0",
     "02008012"),
    ("00034FC0    MOVN       W2, 0x80000000",
     "0200B012"),
    ("000234C8    MOVN       X2, 0x8000000000000000",
     "0200F092"),
    ("000290B0    MOVN       X3, 0x0",
     "03008092"),

    ("00029074    MOV        X0, X26",
     "E0031AAA"),
    ("00028F40    MOV        W0, W24",
     "E003182A"),
    ("00028D84    B.NE       0x40",
     "01020054"),
    ("00028DC0    B.GE       0xC",
     "6A000054"),
    ("0000C880    B.NE       0xFFFFFFFFFFFFFFD8",
     "C1FEFF54"),
    ("0000D27C    B.LS       0x2C",
     "69010054"),

    ("XXXXXXXX    ADD        W0, W0, W0 UXTB 0x3",
     "000C200B"),
    ("XXXXXXXX    ADD        W0, W0, W0 UXTB 0x1",
     "0004200B"),
    ("XXXXXXXX    ADD        W0, W0, W0 UXTB 0x0",
     "0000200B"),
    ("0000B330    BR         X17",
     "20021FD6"),
    ("000A54F0    BLR        X20",
     "80023FD6"),
    ("000A5684    RET        LR",
     "C0035FD6"),
    ("000A563C    BL         0xFFFFFFFFFFF66A54",
     "959AFD97"),
    ("000A4CF4    B          0xFFFFFFFFFFFFFFD0",
     "F4FFFF17"),

    ("00012008    STRB       W7, [X6], 0x2",
     "C7240038"),
    ("00010A2C    LDRB       W1, [X19], 0x1",
     "61164038"),
    ("0002FDF0    LDR        W0, [X24], 0x4",
     "004740B8"),
    ("000A8F38    STR        W2, [X1], 0x4",
     "224400B8"),
    ("0003F2D0    STR        X0, [X1], 0x8",
     "208400F8"),
    ("00081764    LDRSB      W1, [X19], 0x1",
     "6116C038"),
    ("0002CABC    STRH       W1, [X0], 0x2",
     "01240078"),
    ("00037EF0    LDRH       W2, [X1], 0x4",
     "22444078"),

    ("00081504    LDR        Q0, [X1], 0x10",
     "2004C13C"),
    ("00081508    STR        B0, [X1], 0x10",
     "2004013C"),
    ("0008150C    LDR        B0, [X1], 0x10",
     "2004413C"),
    ("00081510    STR        Q0, [X1], 0x10",
     "2004813C"),
    ("00081508    STR        S0, [X1], 0x10",
     "200401BC"),


    ("0006A108    LDR        X0, [X24, 0x8]!",
     "008F40F8"),
    ("0007D490    LDRB       W1, [X0, 0x1]!",
     "011C4038"),
    ("00028888    LDRB       W1, [X24, 0xFFFFFFFFFFFFFFFF]!",
     "01FF5F38"),
    ("0000F550    STRB       W27, [X0, 0xFFFFFFFFFFFFFFFF]!",
     "1BFC1F38"),
    ("0001104C    STR        W0, [X1, 0xFFFFFFFFFFFFFFFC]!",
     "20CC1FB8"),
    ("00016BF0    STR        WZR, [X20, 0xFFFFFFFFFFFFFFFC]!",
     "9FCE1FB8"),
    ("000169BC    STR        XZR, [X2, 0xFFFFFFFFFFFFFFF8]!",
     "5F8C1FF8"),

    ("000169CC    STR        X2, [SP, 0x48]",
     "E22700F9"),
    ("000169C8    STR        X2, [SP, 0x40]",
     "E22300F9"),
    ("0007C144    LDR        W0, [X0, 0x4]",
     "000440B9"),
    ("0006C158    LDR        W6, [X2, 0x1DD8]",
     "46D85DB9"),
    ("00017F04    STR        XZR, [SP, 0xA8]",
     "FF5700F9"),
    ("00061B04    LDR        X20, [X0, 0xC30]",
     "141846F9"),


    ("0000F55C    STURB      W19, [X24, 0xFFFFFFFFFFFFFFFF]",
     "13F31F38"),
    ("0000FCC4    STUR       X4, [X25, 0xFFFFFFFFFFFFFFF8]",
     "24831FF8"),
    ("00029C40    STUR       W22, [X20, 0x1A]",
     "96A201B8"),
    ("00036364    STURB      WZR, [X20, 0xFFFFFFFFFFFFFFFF]",
     "9FF21F38"),
    ("0003CEF0    STURH      W2, [X0, 0xFFFFFFFFFFFFFFFE]",
     "02E01F78"),
    ("0000E91C    LDUR       X2, [X1, 0xFFFFFFFFFFFFFF80]",
     "220058F8"),
    ("00010318    LDUR       W0, [X0, 0xFFFFFFFFFFFFFFF0]",
     "00005FB8"),
    ("0000F54C    LDURB      W19, [X24, 0xFFFFFFFFFFFFFFFF]",
     "13F35F38"),
    ("0006D484    LDURH      W4, [X3, 0xFFFFFFFFFFFFFFFE]",
     "64E05F78"),
    ("000A028C    LDURSH     W3, [X3, 0xFFFFFFFFFFFFFFFE]",
     "63E0DF78"),

    ("0000C6E8    STTRB      W7, [X5, 0xF]",
     "A7F80038"),
    ("0000C6F8    LDTRB      W7, [X5, 0xF]",
     "A7F84038"),
    ("0000C700    LDURSB     X7, [X5, 0xF]",
     "A7F08038"),
    ("0000C708    LDTRSB     X7, [X5, 0xF]",
     "A7F88038"),
    ("0000C728    STTR       B7, [X5, 0xF]",
     "A7F8003C"),
    ("0000C738    LDTR       B7, [X5, 0xF]",
     "A7F8403C"),
    ("0000C740    STUR       Q7, [X5, 0xF]",
     "A7F0803C"),









# brute force
    ("0000C6E0    ADD        W7, W5, 0xF",
     "A73C0011"),
    ("0000C6E4    ADD        W7, W5, 0xF000",
     "A73C4011"),
    ("0000C6E8    ADDS       W7, W5, 0xF",
     "A73C0031"),
    ("0000C6EC    ADDS       W7, W5, 0xF000",
     "A73C4031"),
    ("0000C6F0    SUB        W7, W5, 0xF",
     "A73C0051"),
    ("0000C6F4    SUB        W7, W5, 0xF000",
     "A73C4051"),
    ("0000C6F8    SUBS       W7, W5, 0xF",
     "A73C0071"),
    ("0000C6FC    SUBS       W7, W5, 0xF000",
     "A73C4071"),
    ("0000C700    ADD        X7, X5, 0xF",
     "A73C0091"),
    ("0000C704    ADD        X7, X5, 0xF000",
     "A73C4091"),
    ("0000C708    ADDS       X7, X5, 0xF",
     "A73C00B1"),
    ("0000C70C    ADDS       X7, X5, 0xF000",
     "A73C40B1"),
    ("0000C710    SUB        X7, X5, 0xF",
     "A73C00D1"),
    ("0000C714    SUB        X7, X5, 0xF000",
     "A73C40D1"),
    ("0000C718    SUBS       X7, X5, 0xF",
     "A73C00F1"),
    ("0000C71C    SUBS       X7, X5, 0xF000",
     "A73C40F1"),

    ("0000C6E0    ADD        W15, W7, W5 LSL 0xF",
     "EF3C050B"),
    ("0000C6E4    ADD        W15, W7, W5 LSR 0xF",
     "EF3C450B"),
    ("0000C6E8    ADDS       W15, W7, W5 LSL 0xF",
     "EF3C052B"),
    ("0000C6EC    ADDS       W15, W7, W5 LSR 0xF",
     "EF3C452B"),
    ("0000C6F0    SUB        W15, W7, W5 LSL 0xF",
     "EF3C054B"),
    ("0000C6F4    SUB        W15, W7, W5 LSR 0xF",
     "EF3C454B"),
    ("0000C6F8    SUBS       W15, W7, W5 LSL 0xF",
     "EF3C056B"),
    ("0000C6FC    SUBS       W15, W7, W5 LSR 0xF",
     "EF3C456B"),
    ("0000C700    ADD        X15, X7, X5 LSL 0xF",
     "EF3C058B"),
    ("0000C704    ADD        X15, X7, X5 LSR 0xF",
     "EF3C458B"),
    ("0000C708    ADDS       X15, X7, X5 LSL 0xF",
     "EF3C05AB"),
    ("0000C70C    ADDS       X15, X7, X5 LSR 0xF",
     "EF3C45AB"),
    ("0000C710    SUB        X15, X7, X5 LSL 0xF",
     "EF3C05CB"),
    ("0000C714    SUB        X15, X7, X5 LSR 0xF",
     "EF3C45CB"),
    ("0000C718    SUBS       X15, X7, X5 LSL 0xF",
     "EF3C05EB"),
    ("0000C71C    SUBS       X15, X7, X5 LSR 0xF",
     "EF3C45EB"),


    ("0000C6E0    ADD        W3, W15, W7 UXTB 0x3",
     "E30D270B"),
    ("0000C6E4    ADD        W3, W15, W7 UXTH 0x3",
     "E32D270B"),
    ("0000C6E8    ADD        W3, W15, W7 UXTW 0x3",
     "E34D270B"),
    ("0000C6EC    ADD        W3, W15, W7 UXTX 0x3",
     "E36D270B"),
    ("0000C6F0    ADD        W3, W15, W7 SXTB 0x3",
     "E38D270B"),
    ("0000C6F4    ADD        W3, W15, W7 SXTH 0x3",
     "E3AD270B"),
    ("0000C6F8    ADD        W3, W15, W7 SXTW 0x3",
     "E3CD270B"),
    ("0000C6FC    ADD        W3, W15, W7 SXTX 0x3",
     "E3ED270B"),
    ("0000C700    ADDS       W3, W15, W7 UXTB 0x3",
     "E30D272B"),
    ("0000C704    ADDS       W3, W15, W7 UXTH 0x3",
     "E32D272B"),
    ("0000C708    ADDS       W3, W15, W7 UXTW 0x3",
     "E34D272B"),
    ("0000C70C    ADDS       W3, W15, W7 UXTX 0x3",
     "E36D272B"),
    ("0000C710    ADDS       W3, W15, W7 SXTB 0x3",
     "E38D272B"),
    ("0000C714    ADDS       W3, W15, W7 SXTH 0x3",
     "E3AD272B"),
    ("0000C718    ADDS       W3, W15, W7 SXTW 0x3",
     "E3CD272B"),
    ("0000C71C    ADDS       W3, W15, W7 SXTX 0x3",
     "E3ED272B"),
    ("0000C720    SUB        W3, W15, W7 UXTB 0x3",
     "E30D274B"),
    ("0000C724    SUB        W3, W15, W7 UXTH 0x3",
     "E32D274B"),
    ("0000C728    SUB        W3, W15, W7 UXTW 0x3",
     "E34D274B"),
    ("0000C72C    SUB        W3, W15, W7 UXTX 0x3",
     "E36D274B"),
    ("0000C730    SUB        W3, W15, W7 SXTB 0x3",
     "E38D274B"),
    ("0000C734    SUB        W3, W15, W7 SXTH 0x3",
     "E3AD274B"),
    ("0000C738    SUB        W3, W15, W7 SXTW 0x3",
     "E3CD274B"),
    ("0000C73C    SUB        W3, W15, W7 SXTX 0x3",
     "E3ED274B"),
    ("0000C740    SUBS       W3, W15, W7 UXTB 0x3",
     "E30D276B"),
    ("0000C744    SUBS       W3, W15, W7 UXTH 0x3",
     "E32D276B"),
    ("0000C748    SUBS       W3, W15, W7 UXTW 0x3",
     "E34D276B"),
    ("0000C74C    SUBS       W3, W15, W7 UXTX 0x3",
     "E36D276B"),
    ("0000C750    SUBS       W3, W15, W7 SXTB 0x3",
     "E38D276B"),
    ("0000C754    SUBS       W3, W15, W7 SXTH 0x3",
     "E3AD276B"),
    ("0000C758    SUBS       W3, W15, W7 SXTW 0x3",
     "E3CD276B"),
    ("0000C75C    SUBS       W3, W15, W7 SXTX 0x3",
     "E3ED276B"),
    ("0000C760    ADD        X3, X15, W7 UXTB 0x3",
     "E30D278B"),
    ("0000C764    ADD        X3, X15, W7 UXTH 0x3",
     "E32D278B"),
    ("0000C768    ADD        X3, X15, W7 UXTW 0x3",
     "E34D278B"),
    ("0000C76C    ADD        X3, X15, X7 UXTX 0x3",
     "E36D278B"),
    ("0000C770    ADD        X3, X15, W7 SXTB 0x3",
     "E38D278B"),
    ("0000C774    ADD        X3, X15, W7 SXTH 0x3",
     "E3AD278B"),
    ("0000C778    ADD        X3, X15, W7 SXTW 0x3",
     "E3CD278B"),
    ("0000C77C    ADD        X3, X15, X7 SXTX 0x3",
     "E3ED278B"),
    ("0000C780    ADDS       X3, X15, W7 UXTB 0x3",
     "E30D27AB"),
    ("0000C784    ADDS       X3, X15, W7 UXTH 0x3",
     "E32D27AB"),
    ("0000C788    ADDS       X3, X15, W7 UXTW 0x3",
     "E34D27AB"),
    ("0000C78C    ADDS       X3, X15, X7 UXTX 0x3",
     "E36D27AB"),
    ("0000C790    ADDS       X3, X15, W7 SXTB 0x3",
     "E38D27AB"),
    ("0000C794    ADDS       X3, X15, W7 SXTH 0x3",
     "E3AD27AB"),
    ("0000C798    ADDS       X3, X15, W7 SXTW 0x3",
     "E3CD27AB"),
    ("0000C79C    ADDS       X3, X15, X7 SXTX 0x3",
     "E3ED27AB"),
    ("0000C7A0    SUB        X3, X15, W7 UXTB 0x3",
     "E30D27CB"),
    ("0000C7A4    SUB        X3, X15, W7 UXTH 0x3",
     "E32D27CB"),
    ("0000C7A8    SUB        X3, X15, W7 UXTW 0x3",
     "E34D27CB"),
    ("0000C7AC    SUB        X3, X15, X7 UXTX 0x3",
     "E36D27CB"),
    ("0000C7B0    SUB        X3, X15, W7 SXTB 0x3",
     "E38D27CB"),
    ("0000C7B4    SUB        X3, X15, W7 SXTH 0x3",
     "E3AD27CB"),
    ("0000C7B8    SUB        X3, X15, W7 SXTW 0x3",
     "E3CD27CB"),
    ("0000C7BC    SUB        X3, X15, X7 SXTX 0x3",
     "E3ED27CB"),
    ("0000C7C0    SUBS       X3, X15, W7 UXTB 0x3",
     "E30D27EB"),
    ("0000C7C4    SUBS       X3, X15, W7 UXTH 0x3",
     "E32D27EB"),
    ("0000C7C8    SUBS       X3, X15, W7 UXTW 0x3",
     "E34D27EB"),
    ("0000C7CC    SUBS       X3, X15, X7 UXTX 0x3",
     "E36D27EB"),
    ("0000C7D0    SUBS       X3, X15, W7 SXTB 0x3",
     "E38D27EB"),
    ("0000C7D4    SUBS       X3, X15, W7 SXTH 0x3",
     "E3AD27EB"),
    ("0000C7D8    SUBS       X3, X15, W7 SXTW 0x3",
     "E3CD27EB"),
    ("0000C7DC    SUBS       X3, X15, X7 SXTX 0x3",
     "E3ED27EB"),


    ("0000C6E0    AND        W3, W15, 0xFE000001",
     "E31D0712"),
    ("0000C6E4    ORR        W3, W15, 0xFE000001",
     "E31D0732"),
    ("0000C6E8    EOR        W3, W15, 0xFE000001",
     "E31D0752"),
    ("0000C6EC    ANDS       W3, W15, 0xFE000001",
     "E31D0772"),
# XXX???? TODO CHECK
#    ("0000C6F0    AND        X3, X15, 0xFE000001FE000001",
#     "E31D0792"),
#    ("0000C6F4    ORR        X3, X15, 0xFE000001FE000001",
#     "E31D07B2"),
#    ("0000C6F8    EOR        X3, X15, 0xFE000001FE000001",
#     "E31D07D2"),
#    ("0000C6FC    ANDS       X3, X15, 0xFE000001FE000001",
#     "E31D07F2"),


    ("0000C6E0    AND        W3, W15, W7 LSL 0xB",
     "E32D070A"),
    ("0000C6E4    BIC        W3, W15, W7 LSL 0xB",
     "E32D270A"),
    ("0000C6E8    AND        W3, W15, W7 LSR 0xB",
     "E32D470A"),
    ("0000C6EC    BIC        W3, W15, W7 LSR 0xB",
     "E32D670A"),
    ("0000C6F0    AND        W3, W15, W7 ASR 0xB",
     "E32D870A"),
    ("0000C6F4    BIC        W3, W15, W7 ASR 0xB",
     "E32DA70A"),
    ("0000C6F8    AND        W3, W15, W7 ROR 0xB",
     "E32DC70A"),
    ("0000C6FC    BIC        W3, W15, W7 ROR 0xB",
     "E32DE70A"),
    ("0000C700    ORR        W3, W15, W7 LSL 0xB",
     "E32D072A"),
    ("0000C704    ORN        W3, W15, W7 LSL 0xB",
     "E32D272A"),
    ("0000C708    ORR        W3, W15, W7 LSR 0xB",
     "E32D472A"),
    ("0000C70C    ORN        W3, W15, W7 LSR 0xB",
     "E32D672A"),
    ("0000C710    ORR        W3, W15, W7 ASR 0xB",
     "E32D872A"),
    ("0000C714    ORN        W3, W15, W7 ASR 0xB",
     "E32DA72A"),
    ("0000C718    ORR        W3, W15, W7 ROR 0xB",
     "E32DC72A"),
    ("0000C71C    ORN        W3, W15, W7 ROR 0xB",
     "E32DE72A"),
    ("0000C720    EOR        W3, W15, W7 LSL 0xB",
     "E32D074A"),
    ("0000C724    EON        W3, W15, W7 LSL 0xB",
     "E32D274A"),
    ("0000C728    EOR        W3, W15, W7 LSR 0xB",
     "E32D474A"),
    ("0000C72C    EON        W3, W15, W7 LSR 0xB",
     "E32D674A"),
    ("0000C730    EOR        W3, W15, W7 ASR 0xB",
     "E32D874A"),
    ("0000C734    EON        W3, W15, W7 ASR 0xB",
     "E32DA74A"),
    ("0000C738    EOR        W3, W15, W7 ROR 0xB",
     "E32DC74A"),
    ("0000C73C    EON        W3, W15, W7 ROR 0xB",
     "E32DE74A"),
    ("0000C740    ANDS       W3, W15, W7 LSL 0xB",
     "E32D076A"),
    ("0000C744    BICS       W3, W15, W7 LSL 0xB",
     "E32D276A"),
    ("0000C748    ANDS       W3, W15, W7 LSR 0xB",
     "E32D476A"),
    ("0000C74C    BICS       W3, W15, W7 LSR 0xB",
     "E32D676A"),
    ("0000C750    ANDS       W3, W15, W7 ASR 0xB",
     "E32D876A"),
    ("0000C754    BICS       W3, W15, W7 ASR 0xB",
     "E32DA76A"),
    ("0000C758    ANDS       W3, W15, W7 ROR 0xB",
     "E32DC76A"),
    ("0000C75C    BICS       W3, W15, W7 ROR 0xB",
     "E32DE76A"),
    ("0000C760    AND        X3, X15, X7 LSL 0xB",
     "E32D078A"),
    ("0000C764    BIC        X3, X15, X7 LSL 0xB",
     "E32D278A"),
    ("0000C768    AND        X3, X15, X7 LSR 0xB",
     "E32D478A"),
    ("0000C76C    BIC        X3, X15, X7 LSR 0xB",
     "E32D678A"),
    ("0000C770    AND        X3, X15, X7 ASR 0xB",
     "E32D878A"),
    ("0000C774    BIC        X3, X15, X7 ASR 0xB",
     "E32DA78A"),
    ("0000C778    AND        X3, X15, X7 ROR 0xB",
     "E32DC78A"),
    ("0000C77C    BIC        X3, X15, X7 ROR 0xB",
     "E32DE78A"),
    ("0000C780    ORR        X3, X15, X7 LSL 0xB",
     "E32D07AA"),
    ("0000C784    ORN        X3, X15, X7 LSL 0xB",
     "E32D27AA"),
    ("0000C788    ORR        X3, X15, X7 LSR 0xB",
     "E32D47AA"),
    ("0000C78C    ORN        X3, X15, X7 LSR 0xB",
     "E32D67AA"),
    ("0000C790    ORR        X3, X15, X7 ASR 0xB",
     "E32D87AA"),
    ("0000C794    ORN        X3, X15, X7 ASR 0xB",
     "E32DA7AA"),
    ("0000C798    ORR        X3, X15, X7 ROR 0xB",
     "E32DC7AA"),
    ("0000C79C    ORN        X3, X15, X7 ROR 0xB",
     "E32DE7AA"),
    ("0000C7A0    EOR        X3, X15, X7 LSL 0xB",
     "E32D07CA"),
    ("0000C7A4    EON        X3, X15, X7 LSL 0xB",
     "E32D27CA"),
    ("0000C7A8    EOR        X3, X15, X7 LSR 0xB",
     "E32D47CA"),
    ("0000C7AC    EON        X3, X15, X7 LSR 0xB",
     "E32D67CA"),
    ("0000C7B0    EOR        X3, X15, X7 ASR 0xB",
     "E32D87CA"),
    ("0000C7B4    EON        X3, X15, X7 ASR 0xB",
     "E32DA7CA"),
    ("0000C7B8    EOR        X3, X15, X7 ROR 0xB",
     "E32DC7CA"),
    ("0000C7BC    EON        X3, X15, X7 ROR 0xB",
     "E32DE7CA"),
    ("0000C7C0    ANDS       X3, X15, X7 LSL 0xB",
     "E32D07EA"),
    ("0000C7C4    BICS       X3, X15, X7 LSL 0xB",
     "E32D27EA"),
    ("0000C7C8    ANDS       X3, X15, X7 LSR 0xB",
     "E32D47EA"),
    ("0000C7CC    BICS       X3, X15, X7 LSR 0xB",
     "E32D67EA"),
    ("0000C7D0    ANDS       X3, X15, X7 ASR 0xB",
     "E32D87EA"),
    ("0000C7D4    BICS       X3, X15, X7 ASR 0xB",
     "E32DA7EA"),
    ("0000C7D8    ANDS       X3, X15, X7 ROR 0xB",
     "E32DC7EA"),
    ("0000C7DC    BICS       X3, X15, X7 ROR 0xB",
     "E32DE7EA"),




    ("0000C6E0    STURB      W7, [X5, 0xF]",
     "A7F00038"),
    ("0000C6E4    STRB       W7, [X5], 0xF",
     "A7F40038"),
    ("0000C6E8    STTRB      W7, [X5, 0xF]",
     "A7F80038"),
    ("0000C6EC    STRB       W7, [X5, 0xF]!",
     "A7FC0038"),
    ("0000C6F0    LDURB      W7, [X5, 0xF]",
     "A7F04038"),
    ("0000C6F4    LDRB       W7, [X5], 0xF",
     "A7F44038"),
    ("0000C6F8    LDTRB      W7, [X5, 0xF]",
     "A7F84038"),
    ("0000C6FC    LDRB       W7, [X5, 0xF]!",
     "A7FC4038"),
    ("0000C700    LDURSB     X7, [X5, 0xF]",
     "A7F08038"),
    ("0000C704    LDRSB      X7, [X5], 0xF",
     "A7F48038"),
    ("0000C708    LDTRSB     X7, [X5, 0xF]",
     "A7F88038"),
    ("0000C70C    LDRSB      X7, [X5, 0xF]!",
     "A7FC8038"),
    ("0000C710    LDURSB     W7, [X5, 0xF]",
     "A7F0C038"),
    ("0000C714    LDRSB      W7, [X5], 0xF",
     "A7F4C038"),
    ("0000C718    LDTRSB     W7, [X5, 0xF]",
     "A7F8C038"),
    ("0000C71C    LDRSB      W7, [X5, 0xF]!",
     "A7FCC038"),
    ("0000C720    STUR       B7, [X5, 0xF]",
     "A7F0003C"),
    ("0000C724    STR        B7, [X5], 0xF",
     "A7F4003C"),
    ("0000C728    STTR       B7, [X5, 0xF]",
     "A7F8003C"),
    ("0000C72C    STR        B7, [X5, 0xF]!",
     "A7FC003C"),
    ("0000C730    LDUR       B7, [X5, 0xF]",
     "A7F0403C"),
    ("0000C734    LDR        B7, [X5], 0xF",
     "A7F4403C"),
    ("0000C738    LDTR       B7, [X5, 0xF]",
     "A7F8403C"),
    ("0000C73C    LDR        B7, [X5, 0xF]!",
     "A7FC403C"),
    ("0000C740    STUR       Q7, [X5, 0xF]",
     "A7F0803C"),
    ("0000C744    STR        Q7, [X5], 0xF",
     "A7F4803C"),
    ("0000C748    STTR       Q7, [X5, 0xF]",
     "A7F8803C"),
    ("0000C74C    STR        Q7, [X5, 0xF]!",
     "A7FC803C"),
    ("0000C750    LDUR       Q7, [X5, 0xF]",
     "A7F0C03C"),
    ("0000C754    LDR        Q7, [X5], 0xF",
     "A7F4C03C"),
    ("0000C758    LDTR       Q7, [X5, 0xF]",
     "A7F8C03C"),
    ("0000C75C    LDR        Q7, [X5, 0xF]!",
     "A7FCC03C"),
    ("0000C760    STURH      W7, [X5, 0xF]",
     "A7F00078"),
    ("0000C764    STRH       W7, [X5], 0xF",
     "A7F40078"),
    ("0000C768    STTRH      W7, [X5, 0xF]",
     "A7F80078"),
    ("0000C76C    STRH       W7, [X5, 0xF]!",
     "A7FC0078"),
    ("0000C770    LDURH      W7, [X5, 0xF]",
     "A7F04078"),
    ("0000C774    LDRH       W7, [X5], 0xF",
     "A7F44078"),
    ("0000C778    LDTRH      W7, [X5, 0xF]",
     "A7F84078"),
    ("0000C77C    LDRH       W7, [X5, 0xF]!",
     "A7FC4078"),
    ("0000C780    LDURSH     X7, [X5, 0xF]",
     "A7F08078"),
    ("0000C784    LDRSH      X7, [X5], 0xF",
     "A7F48078"),
    ("0000C788    LDTRSH     X7, [X5, 0xF]",
     "A7F88078"),
    ("0000C78C    LDRSH      X7, [X5, 0xF]!",
     "A7FC8078"),
    ("0000C790    LDURSH     W7, [X5, 0xF]",
     "A7F0C078"),
    ("0000C794    LDRSH      W7, [X5], 0xF",
     "A7F4C078"),
    ("0000C798    LDTRSH     W7, [X5, 0xF]",
     "A7F8C078"),
    ("0000C79C    LDRSH      W7, [X5, 0xF]!",
     "A7FCC078"),
    ("0000C7A0    STUR       H7, [X5, 0xF]",
     "A7F0007C"),
    ("0000C7A4    STR        H7, [X5], 0xF",
     "A7F4007C"),
    ("0000C7A8    STTR       H7, [X5, 0xF]",
     "A7F8007C"),
    ("0000C7AC    STR        H7, [X5, 0xF]!",
     "A7FC007C"),
    ("0000C7B0    LDUR       H7, [X5, 0xF]",
     "A7F0407C"),
    ("0000C7B4    LDR        H7, [X5], 0xF",
     "A7F4407C"),
    ("0000C7B8    LDTR       H7, [X5, 0xF]",
     "A7F8407C"),
    ("0000C7BC    LDR        H7, [X5, 0xF]!",
     "A7FC407C"),
    ("0000C7E0    STUR       W7, [X5, 0xF]",
     "A7F000B8"),
    ("0000C7E4    STR        W7, [X5], 0xF",
     "A7F400B8"),
    ("0000C7E8    STTR       W7, [X5, 0xF]",
     "A7F800B8"),
    ("0000C7EC    STR        W7, [X5, 0xF]!",
     "A7FC00B8"),
    ("0000C7F0    LDUR       W7, [X5, 0xF]",
     "A7F040B8"),
    ("0000C7F4    LDR        W7, [X5], 0xF",
     "A7F440B8"),
    ("0000C7F8    LDTR       W7, [X5, 0xF]",
     "A7F840B8"),
    ("0000C7FC    LDR        W7, [X5, 0xF]!",
     "A7FC40B8"),
    ("0000C800    LDURSW     X7, [X5, 0xF]",
     "A7F080B8"),
    ("0000C804    LDRSW      X7, [X5], 0xF",
     "A7F480B8"),
    ("0000C808    LDTRSW     X7, [X5, 0xF]",
     "A7F880B8"),
    ("0000C80C    LDRSW      X7, [X5, 0xF]!",
     "A7FC80B8"),
    ("0000C820    STUR       S7, [X5, 0xF]",
     "A7F000BC"),
    ("0000C824    STR        S7, [X5], 0xF",
     "A7F400BC"),
    ("0000C828    STTR       S7, [X5, 0xF]",
     "A7F800BC"),
    ("0000C82C    STR        S7, [X5, 0xF]!",
     "A7FC00BC"),
    ("0000C830    LDUR       S7, [X5, 0xF]",
     "A7F040BC"),
    ("0000C834    LDR        S7, [X5], 0xF",
     "A7F440BC"),
    ("0000C838    LDTR       S7, [X5, 0xF]",
     "A7F840BC"),
    ("0000C83C    LDR        S7, [X5, 0xF]!",
     "A7FC40BC"),
    ("0000C860    STUR       X7, [X5, 0xF]",
     "A7F000F8"),
    ("0000C864    STR        X7, [X5], 0xF",
     "A7F400F8"),
    ("0000C868    STTR       X7, [X5, 0xF]",
     "A7F800F8"),
    ("0000C86C    STR        X7, [X5, 0xF]!",
     "A7FC00F8"),
    ("0000C870    LDUR       X7, [X5, 0xF]",
     "A7F040F8"),
    ("0000C874    LDR        X7, [X5], 0xF",
     "A7F440F8"),
    ("0000C878    LDTR       X7, [X5, 0xF]",
     "A7F840F8"),
    ("0000C87C    LDR        X7, [X5, 0xF]!",
     "A7FC40F8"),
    ("0000C8A0    STUR       D7, [X5, 0xF]",
     "A7F000FC"),
    ("0000C8A4    STR        D7, [X5], 0xF",
     "A7F400FC"),
    ("0000C8A8    STTR       D7, [X5, 0xF]",
     "A7F800FC"),
    ("0000C8AC    STR        D7, [X5, 0xF]!",
     "A7FC00FC"),
    ("0000C8B0    LDUR       D7, [X5, 0xF]",
     "A7F040FC"),
    ("0000C8B4    LDR        D7, [X5], 0xF",
     "A7F440FC"),
    ("0000C8B8    LDTR       D7, [X5, 0xF]",
     "A7F840FC"),
    ("0000C8BC    LDR        D7, [X5, 0xF]!",
     "A7FC40FC"),
    ("0000C8E0    STRB       W7, [X7]",
     "E7000039"),
    ("0000C8E4    LDRB       W7, [X7]",
     "E7004039"),
    ("0000C8E8    LDRSB      X7, [X7]",
     "E7008039"),
    ("0000C8EC    LDRSB      W7, [X7]",
     "E700C039"),
    ("0000C8F0    STR        B7, [X7]",
     "E700003D"),
    ("0000C8F4    LDR        B7, [X7]",
     "E700403D"),
    ("0000C8F8    STR        Q7, [X7]",
     "E700803D"),
    ("0000C8FC    LDR        Q7, [X7]",
     "E700C03D"),
    ("0000C900    STRH       W7, [X7]",
     "E7000079"),
    ("0000C904    LDRH       W7, [X7]",
     "E7004079"),
    ("0000C908    LDRSH      X7, [X7]",
     "E7008079"),
    ("0000C90C    LDRSH      W7, [X7]",
     "E700C079"),
    ("0000C910    STR        H7, [X7]",
     "E700007D"),
    ("0000C914    LDR        H7, [X7]",
     "E700407D"),
    ("0000C920    STR        W7, [X7]",
     "E70000B9"),
    ("0000C924    LDR        W7, [X7]",
     "E70040B9"),
    ("0000C928    LDRSW      X7, [X7]",
     "E70080B9"),
    ("0000C930    STR        S7, [X7]",
     "E70000BD"),
    ("0000C934    LDR        S7, [X7]",
     "E70040BD"),
    ("0000C940    STR        X7, [X7]",
     "E70000F9"),
    ("0000C944    LDR        X7, [X7]",
     "E70040F9"),
    ("0000C950    STR        D7, [X7]",
     "E70000FD"),
    ("0000C954    LDR        D7, [X7]",
     "E70040FD"),

    ("0000C6E0    STRB       W17, [X0, 0xF]",
     "113C0039"),
    ("0000C6E4    LDRB       W17, [X0, 0xF]",
     "113C4039"),
    ("0000C6E8    LDRSB      X17, [X0, 0xF]",
     "113C8039"),
    ("0000C6EC    LDRSB      W17, [X0, 0xF]",
     "113CC039"),
    ("0000C6F0    STR        B17, [X0, 0xF]",
     "113C003D"),
    ("0000C6F4    LDR        B17, [X0, 0xF]",
     "113C403D"),
    ("0000C6F8    STR        Q17, [X0, 0xF0]",
     "113C803D"),
    ("0000C6FC    LDR        Q17, [X0, 0xF0]",
     "113CC03D"),
    ("0000C700    STRH       W17, [X0, 0x1E]",
     "113C0079"),
    ("0000C704    LDRH       W17, [X0, 0x1E]",
     "113C4079"),
    ("0000C708    LDRSH      X17, [X0, 0x1E]",
     "113C8079"),
    ("0000C70C    LDRSH      W17, [X0, 0x1E]",
     "113CC079"),
    ("0000C710    STR        H17, [X0, 0x1E]",
     "113C007D"),
    ("0000C714    LDR        H17, [X0, 0x1E]",
     "113C407D"),
    ("0000C720    STR        W17, [X0, 0x3C]",
     "113C00B9"),
    ("0000C724    LDR        W17, [X0, 0x3C]",
     "113C40B9"),
    ("0000C728    LDRSW      X17, [X0, 0x3C]",
     "113C80B9"),
    ("0000C730    STR        S17, [X0, 0x3C]",
     "113C00BD"),
    ("0000C734    LDR        S17, [X0, 0x3C]",
     "113C40BD"),
    ("0000C740    STR        X17, [X0, 0x78]",
     "113C00F9"),
    ("0000C744    LDR        X17, [X0, 0x78]",
     "113C40F9"),
    ("0000C750    STR        D17, [X0, 0x78]",
     "113C00FD"),
    ("0000C754    LDR        D17, [X0, 0x78]",
     "113C40FD"),
    ("0000C760    STURH      W7, [X5, 0xF]",
     "A7F00078"),
    ("0000C764    STRH       W7, [X5], 0xF",
     "A7F40078"),
    ("0000C768    STTRH      W7, [X5, 0xF]",
     "A7F80078"),
    ("0000C76C    STRH       W7, [X5, 0xF]!",
     "A7FC0078"),
    ("0000C770    LDURH      W7, [X5, 0xF]",
     "A7F04078"),
    ("0000C774    LDRH       W7, [X5], 0xF",
     "A7F44078"),
    ("0000C778    LDTRH      W7, [X5, 0xF]",
     "A7F84078"),
    ("0000C77C    LDRH       W7, [X5, 0xF]!",
     "A7FC4078"),
    ("0000C780    LDURSH     X7, [X5, 0xF]",
     "A7F08078"),
    ("0000C784    LDRSH      X7, [X5], 0xF",
     "A7F48078"),
    ("0000C788    LDTRSH     X7, [X5, 0xF]",
     "A7F88078"),
    ("0000C78C    LDRSH      X7, [X5, 0xF]!",
     "A7FC8078"),
    ("0000C790    LDURSH     W7, [X5, 0xF]",
     "A7F0C078"),
    ("0000C794    LDRSH      W7, [X5], 0xF",
     "A7F4C078"),
    ("0000C798    LDTRSH     W7, [X5, 0xF]",
     "A7F8C078"),
    ("0000C79C    LDRSH      W7, [X5, 0xF]!",
     "A7FCC078"),
    ("0000C7A0    STUR       H7, [X5, 0xF]",
     "A7F0007C"),
    ("0000C7A4    STR        H7, [X5], 0xF",
     "A7F4007C"),
    ("0000C7A8    STTR       H7, [X5, 0xF]",
     "A7F8007C"),
    ("0000C7AC    STR        H7, [X5, 0xF]!",
     "A7FC007C"),
    ("0000C7B0    LDUR       H7, [X5, 0xF]",
     "A7F0407C"),
    ("0000C7B4    LDR        H7, [X5], 0xF",
     "A7F4407C"),
    ("0000C7B8    LDTR       H7, [X5, 0xF]",
     "A7F8407C"),
    ("0000C7BC    LDR        H7, [X5, 0xF]!",
     "A7FC407C"),
    ("0000C7E0    STUR       W7, [X5, 0xF]",
     "A7F000B8"),
    ("0000C7E4    STR        W7, [X5], 0xF",
     "A7F400B8"),
    ("0000C7E8    STTR       W7, [X5, 0xF]",
     "A7F800B8"),
    ("0000C7EC    STR        W7, [X5, 0xF]!",
     "A7FC00B8"),
    ("0000C7F0    LDUR       W7, [X5, 0xF]",
     "A7F040B8"),
    ("0000C7F4    LDR        W7, [X5], 0xF",
     "A7F440B8"),
    ("0000C7F8    LDTR       W7, [X5, 0xF]",
     "A7F840B8"),
    ("0000C7FC    LDR        W7, [X5, 0xF]!",
     "A7FC40B8"),
    ("0000C800    LDURSW     X7, [X5, 0xF]",
     "A7F080B8"),
    ("0000C804    LDRSW      X7, [X5], 0xF",
     "A7F480B8"),
    ("0000C808    LDTRSW     X7, [X5, 0xF]",
     "A7F880B8"),
    ("0000C80C    LDRSW      X7, [X5, 0xF]!",
     "A7FC80B8"),
    ("0000C820    STUR       S7, [X5, 0xF]",
     "A7F000BC"),
    ("0000C824    STR        S7, [X5], 0xF",
     "A7F400BC"),
    ("0000C828    STTR       S7, [X5, 0xF]",
     "A7F800BC"),
    ("0000C82C    STR        S7, [X5, 0xF]!",
     "A7FC00BC"),
    ("0000C830    LDUR       S7, [X5, 0xF]",
     "A7F040BC"),
    ("0000C834    LDR        S7, [X5], 0xF",
     "A7F440BC"),
    ("0000C838    LDTR       S7, [X5, 0xF]",
     "A7F840BC"),
    ("0000C83C    LDR        S7, [X5, 0xF]!",
     "A7FC40BC"),
    ("0000C860    STUR       X7, [X5, 0xF]",
     "A7F000F8"),
    ("0000C864    STR        X7, [X5], 0xF",
     "A7F400F8"),
    ("0000C868    STTR       X7, [X5, 0xF]",
     "A7F800F8"),
    ("0000C86C    STR        X7, [X5, 0xF]!",
     "A7FC00F8"),
    ("0000C870    LDUR       X7, [X5, 0xF]",
     "A7F040F8"),
    ("0000C874    LDR        X7, [X5], 0xF",
     "A7F440F8"),
    ("0000C878    LDTR       X7, [X5, 0xF]",
     "A7F840F8"),
    ("0000C87C    LDR        X7, [X5, 0xF]!",
     "A7FC40F8"),
    ("0000C8A0    STUR       D7, [X5, 0xF]",
     "A7F000FC"),
    ("0000C8A4    STR        D7, [X5], 0xF",
     "A7F400FC"),
    ("0000C8A8    STTR       D7, [X5, 0xF]",
     "A7F800FC"),
    ("0000C8AC    STR        D7, [X5, 0xF]!",
     "A7FC00FC"),
    ("0000C8B0    LDUR       D7, [X5, 0xF]",
     "A7F040FC"),
    ("0000C8B4    LDR        D7, [X5], 0xF",
     "A7F440FC"),
    ("0000C8B8    LDTR       D7, [X5, 0xF]",
     "A7F840FC"),
    ("0000C8BC    LDR        D7, [X5, 0xF]!",
     "A7FC40FC"),
    ("0000C8E0    STRB       W7, [X7]",
     "E7000039"),
    ("0000C8E4    LDRB       W7, [X7]",
     "E7004039"),
    ("0000C8E8    LDRSB      X7, [X7]",
     "E7008039"),
    ("0000C8EC    LDRSB      W7, [X7]",
     "E700C039"),
    ("0000C8F0    STR        B7, [X7]",
     "E700003D"),
    ("0000C8F4    LDR        B7, [X7]",
     "E700403D"),
    ("0000C8F8    STR        Q7, [X7]",
     "E700803D"),
    ("0000C8FC    LDR        Q7, [X7]",
     "E700C03D"),
    ("0000C900    STRH       W7, [X7]",
     "E7000079"),
    ("0000C904    LDRH       W7, [X7]",
     "E7004079"),
    ("0000C908    LDRSH      X7, [X7]",
     "E7008079"),
    ("0000C90C    LDRSH      W7, [X7]",
     "E700C079"),
    ("0000C910    STR        H7, [X7]",
     "E700007D"),
    ("0000C914    LDR        H7, [X7]",
     "E700407D"),
    ("0000C920    STR        W7, [X7]",
     "E70000B9"),
    ("0000C924    LDR        W7, [X7]",
     "E70040B9"),
    ("0000C928    LDRSW      X7, [X7]",
     "E70080B9"),
    ("0000C930    STR        S7, [X7]",
     "E70000BD"),
    ("0000C934    LDR        S7, [X7]",
     "E70040BD"),
    ("0000C940    STR        X7, [X7]",
     "E70000F9"),
    ("0000C944    LDR        X7, [X7]",
     "E70040F9"),
    ("0000C950    STR        D7, [X7]",
     "E70000FD"),
    ("0000C954    LDR        D7, [X7]",
     "E70040FD"),


    ("0000C6F0    STRB       W17, [X3, W7 UXTW 0x0]",
     "71482738"),
    ("0000C6F8    STRB       W17, [X3, X7]",
     "71682738"),
    ("0000C710    STRB       W17, [X3, W7 SXTW 0x0]",
     "71C82738"),
    ("0000C718    STRB       W17, [X3, X7 SXTX 0x0]",
     "71E82738"),
    ("0000C730    LDRB       W17, [X3, W7 UXTW 0x0]",
     "71486738"),
    ("0000C738    LDRB       W17, [X3, X7]",
     "71686738"),
    ("0000C750    LDRB       W17, [X3, W7 SXTW 0x0]",
     "71C86738"),
    ("0000C758    LDRB       W17, [X3, X7 SXTX 0x0]",
     "71E86738"),
    ("0000C770    LDRSB      X17, [X3, W7 UXTW 0x0]",
     "7148A738"),
    ("0000C778    LDRSB      X17, [X3, X7]",
     "7168A738"),
    ("0000C790    LDRSB      X17, [X3, W7 SXTW 0x0]",
     "71C8A738"),
    ("0000C798    LDRSB      X17, [X3, X7 SXTX 0x0]",
     "71E8A738"),
    ("0000C7B0    LDRSB      W17, [X3, W7 UXTW 0x0]",
     "7148E738"),
    ("0000C7B8    LDRSB      W17, [X3, X7]",
     "7168E738"),
    ("0000C7D0    LDRSB      W17, [X3, W7 SXTW 0x0]",
     "71C8E738"),
    ("0000C7D8    LDRSB      W17, [X3, X7 SXTX 0x0]",
     "71E8E738"),
    ("0000C7F0    STR        B17, [X3, W7 UXTW 0x0]",
     "7148273C"),
    ("0000C7F8    STR        B17, [X3, X7]",
     "7168273C"),
    ("0000C810    STR        B17, [X3, W7 SXTW 0x0]",
     "71C8273C"),
    ("0000C818    STR        B17, [X3, X7 SXTX 0x0]",
     "71E8273C"),
    ("0000C830    LDR        B17, [X3, W7 UXTW 0x0]",
     "7148673C"),
    ("0000C838    LDR        B17, [X3, X7]",
     "7168673C"),
    ("0000C850    LDR        B17, [X3, W7 SXTW 0x0]",
     "71C8673C"),
    ("0000C858    LDR        B17, [X3, X7 SXTX 0x0]",
     "71E8673C"),
    ("0000C870    STR        Q17, [X3, W7 UXTW 0x0]",
     "7148A73C"),
    ("0000C878    STR        Q17, [X3, X7]",
     "7168A73C"),
    ("0000C87C    STR        Q17, [X3, X7 LSL 0x4]",
     "7178A73C"),
    ("0000C890    STR        Q17, [X3, W7 SXTW 0x0]",
     "71C8A73C"),
    ("0000C894    STR        Q17, [X3, W7 SXTW 0x4]",
     "71D8A73C"),
    ("0000C898    STR        Q17, [X3, X7 SXTX 0x0]",
     "71E8A73C"),
    ("0000C89C    STR        Q17, [X3, X7 SXTX 0x4]",
     "71F8A73C"),
    ("0000C8B0    LDR        Q17, [X3, W7 UXTW 0x0]",
     "7148E73C"),
    ("0000C8B4    LDR        Q17, [X3, W7 UXTW 0x4]",
     "7158E73C"),
    ("0000C8B8    LDR        Q17, [X3, X7]",
     "7168E73C"),
    ("0000C8BC    LDR        Q17, [X3, X7 LSL 0x4]",
     "7178E73C"),
    ("0000C8D0    LDR        Q17, [X3, W7 SXTW 0x0]",
     "71C8E73C"),
    ("0000C8D4    LDR        Q17, [X3, W7 SXTW 0x4]",
     "71D8E73C"),
    ("0000C8D8    LDR        Q17, [X3, X7 SXTX 0x0]",
     "71E8E73C"),
    ("0000C8DC    LDR        Q17, [X3, X7 SXTX 0x4]",
     "71F8E73C"),
    ("0000C8F0    STRH       W17, [X3, W7 UXTW 0x0]",
     "71482778"),
    ("0000C8F4    STRH       W17, [X3, W7 UXTW 0x1]",
     "71582778"),
    ("0000C8F8    STRH       W17, [X3, X7]",
     "71682778"),
    ("0000C8FC    STRH       W17, [X3, X7 LSL 0x1]",
     "71782778"),
    ("0000C910    STRH       W17, [X3, W7 SXTW 0x0]",
     "71C82778"),
    ("0000C914    STRH       W17, [X3, W7 SXTW 0x1]",
     "71D82778"),
    ("0000C918    STRH       W17, [X3, X7 SXTX 0x0]",
     "71E82778"),
    ("0000C91C    STRH       W17, [X3, X7 SXTX 0x1]",
     "71F82778"),
    ("0000C930    LDRH       W17, [X3, W7 UXTW 0x0]",
     "71486778"),
    ("0000C934    LDRH       W17, [X3, W7 UXTW 0x1]",
     "71586778"),
    ("0000C938    LDRH       W17, [X3, X7]",
     "71686778"),
    ("0000C93C    LDRH       W17, [X3, X7 LSL 0x1]",
     "71786778"),
    ("0000C950    LDRH       W17, [X3, W7 SXTW 0x0]",
     "71C86778"),
    ("0000C954    LDRH       W17, [X3, W7 SXTW 0x1]",
     "71D86778"),
    ("0000C958    LDRH       W17, [X3, X7 SXTX 0x0]",
     "71E86778"),
    ("0000C95C    LDRH       W17, [X3, X7 SXTX 0x1]",
     "71F86778"),
    ("0000C970    LDRSH      X17, [X3, W7 UXTW 0x0]",
     "7148A778"),
    ("0000C974    LDRSH      X17, [X3, W7 UXTW 0x1]",
     "7158A778"),
    ("0000C978    LDRSH      X17, [X3, X7]",
     "7168A778"),
    ("0000C97C    LDRSH      X17, [X3, X7 LSL 0x1]",
     "7178A778"),
    ("0000C990    LDRSH      X17, [X3, W7 SXTW 0x0]",
     "71C8A778"),
    ("0000C994    LDRSH      X17, [X3, W7 SXTW 0x1]",
     "71D8A778"),
    ("0000C998    LDRSH      X17, [X3, X7 SXTX 0x0]",
     "71E8A778"),
    ("0000C99C    LDRSH      X17, [X3, X7 SXTX 0x1]",
     "71F8A778"),
    ("0000C9B0    LDRSH      W17, [X3, W7 UXTW 0x0]",
     "7148E778"),
    ("0000C9B4    LDRSH      W17, [X3, W7 UXTW 0x1]",
     "7158E778"),
    ("0000C9B8    LDRSH      W17, [X3, X7]",
     "7168E778"),
    ("0000C9BC    LDRSH      W17, [X3, X7 LSL 0x1]",
     "7178E778"),
    ("0000C9D0    LDRSH      W17, [X3, W7 SXTW 0x0]",
     "71C8E778"),
    ("0000C9D4    LDRSH      W17, [X3, W7 SXTW 0x1]",
     "71D8E778"),
    ("0000C9D8    LDRSH      W17, [X3, X7 SXTX 0x0]",
     "71E8E778"),
    ("0000C9DC    LDRSH      W17, [X3, X7 SXTX 0x1]",
     "71F8E778"),
    ("0000C9F0    STR        H17, [X3, W7 UXTW 0x0]",
     "7148277C"),
    ("0000C9F4    STR        H17, [X3, W7 UXTW 0x1]",
     "7158277C"),
    ("0000C9F8    STR        H17, [X3, X7]",
     "7168277C"),
    ("0000C9FC    STR        H17, [X3, X7 LSL 0x1]",
     "7178277C"),
    ("0000CA10    STR        H17, [X3, W7 SXTW 0x0]",
     "71C8277C"),
    ("0000CA14    STR        H17, [X3, W7 SXTW 0x1]",
     "71D8277C"),
    ("0000CA18    STR        H17, [X3, X7 SXTX 0x0]",
     "71E8277C"),
    ("0000CA1C    STR        H17, [X3, X7 SXTX 0x1]",
     "71F8277C"),
    ("0000CA30    LDR        H17, [X3, W7 UXTW 0x0]",
     "7148677C"),
    ("0000CA34    LDR        H17, [X3, W7 UXTW 0x1]",
     "7158677C"),
    ("0000CA38    LDR        H17, [X3, X7]",
     "7168677C"),
    ("0000CA3C    LDR        H17, [X3, X7 LSL 0x1]",
     "7178677C"),
    ("0000CA50    LDR        H17, [X3, W7 SXTW 0x0]",
     "71C8677C"),
    ("0000CA54    LDR        H17, [X3, W7 SXTW 0x1]",
     "71D8677C"),
    ("0000CA58    LDR        H17, [X3, X7 SXTX 0x0]",
     "71E8677C"),
    ("0000CA5C    LDR        H17, [X3, X7 SXTX 0x1]",
     "71F8677C"),
    ("0000CAF0    STR        W17, [X3, W7 UXTW 0x0]",
     "714827B8"),
    ("0000CAF4    STR        W17, [X3, W7 UXTW 0x2]",
     "715827B8"),
    ("0000CAF8    STR        W17, [X3, X7]",
     "716827B8"),
    ("0000CAFC    STR        W17, [X3, X7 LSL 0x2]",
     "717827B8"),
    ("0000CB10    STR        W17, [X3, W7 SXTW 0x0]",
     "71C827B8"),
    ("0000CB14    STR        W17, [X3, W7 SXTW 0x2]",
     "71D827B8"),
    ("0000CB18    STR        W17, [X3, X7 SXTX 0x0]",
     "71E827B8"),
    ("0000CB1C    STR        W17, [X3, X7 SXTX 0x2]",
     "71F827B8"),
    ("0000CB30    LDR        W17, [X3, W7 UXTW 0x0]",
     "714867B8"),
    ("0000CB34    LDR        W17, [X3, W7 UXTW 0x2]",
     "715867B8"),
    ("0000CB38    LDR        W17, [X3, X7]",
     "716867B8"),
    ("0000CB3C    LDR        W17, [X3, X7 LSL 0x2]",
     "717867B8"),
    ("0000CB50    LDR        W17, [X3, W7 SXTW 0x0]",
     "71C867B8"),
    ("0000CB54    LDR        W17, [X3, W7 SXTW 0x2]",
     "71D867B8"),
    ("0000CB58    LDR        W17, [X3, X7 SXTX 0x0]",
     "71E867B8"),
    ("0000CB5C    LDR        W17, [X3, X7 SXTX 0x2]",
     "71F867B8"),
    ("0000CB70    LDRSW      X17, [X3, W7 UXTW 0x0]",
     "7148A7B8"),
    ("0000CB74    LDRSW      X17, [X3, W7 UXTW 0x2]",
     "7158A7B8"),
    ("0000CB78    LDRSW      X17, [X3, X7]",
     "7168A7B8"),
    ("0000CB7C    LDRSW      X17, [X3, X7 LSL 0x2]",
     "7178A7B8"),
    ("0000CB90    LDRSW      X17, [X3, W7 SXTW 0x0]",
     "71C8A7B8"),
    ("0000CB94    LDRSW      X17, [X3, W7 SXTW 0x2]",
     "71D8A7B8"),
    ("0000CB98    LDRSW      X17, [X3, X7 SXTX 0x0]",
     "71E8A7B8"),
    ("0000CB9C    LDRSW      X17, [X3, X7 SXTX 0x2]",
     "71F8A7B8"),
    ("0000CBF0    STR        S17, [X3, W7 UXTW 0x0]",
     "714827BC"),
    ("0000CBF4    STR        S17, [X3, W7 UXTW 0x2]",
     "715827BC"),
    ("0000CBF8    STR        S17, [X3, X7]",
     "716827BC"),
    ("0000CBFC    STR        S17, [X3, X7 LSL 0x2]",
     "717827BC"),
    ("0000CC10    STR        S17, [X3, W7 SXTW 0x0]",
     "71C827BC"),
    ("0000CC14    STR        S17, [X3, W7 SXTW 0x2]",
     "71D827BC"),
    ("0000CC18    STR        S17, [X3, X7 SXTX 0x0]",
     "71E827BC"),
    ("0000CC1C    STR        S17, [X3, X7 SXTX 0x2]",
     "71F827BC"),
    ("0000CC30    LDR        S17, [X3, W7 UXTW 0x0]",
     "714867BC"),
    ("0000CC34    LDR        S17, [X3, W7 UXTW 0x2]",
     "715867BC"),
    ("0000CC38    LDR        S17, [X3, X7]",
     "716867BC"),
    ("0000CC3C    LDR        S17, [X3, X7 LSL 0x2]",
     "717867BC"),
    ("0000CC50    LDR        S17, [X3, W7 SXTW 0x0]",
     "71C867BC"),
    ("0000CC54    LDR        S17, [X3, W7 SXTW 0x2]",
     "71D867BC"),
    ("0000CC58    LDR        S17, [X3, X7 SXTX 0x0]",
     "71E867BC"),
    ("0000CC5C    LDR        S17, [X3, X7 SXTX 0x2]",
     "71F867BC"),
    ("0000CCF0    STR        X17, [X3, W7 UXTW 0x0]",
     "714827F8"),
    ("0000CCF4    STR        X17, [X3, W7 UXTW 0x3]",
     "715827F8"),
    ("0000CCF8    STR        X17, [X3, X7]",
     "716827F8"),
    ("0000CCFC    STR        X17, [X3, X7 LSL 0x3]",
     "717827F8"),
    ("0000CD10    STR        X17, [X3, W7 SXTW 0x0]",
     "71C827F8"),
    ("0000CD14    STR        X17, [X3, W7 SXTW 0x3]",
     "71D827F8"),
    ("0000CD18    STR        X17, [X3, X7 SXTX 0x0]",
     "71E827F8"),
    ("0000CD1C    STR        X17, [X3, X7 SXTX 0x3]",
     "71F827F8"),
    ("0000CD30    LDR        X17, [X3, W7 UXTW 0x0]",
     "714867F8"),
    ("0000CD34    LDR        X17, [X3, W7 UXTW 0x3]",
     "715867F8"),
    ("0000CD38    LDR        X17, [X3, X7]",
     "716867F8"),
    ("0000CD3C    LDR        X17, [X3, X7 LSL 0x3]",
     "717867F8"),
    ("0000CD50    LDR        X17, [X3, W7 SXTW 0x0]",
     "71C867F8"),
    ("0000CD54    LDR        X17, [X3, W7 SXTW 0x3]",
     "71D867F8"),
    ("0000CD58    LDR        X17, [X3, X7 SXTX 0x0]",
     "71E867F8"),
    ("0000CD5C    LDR        X17, [X3, X7 SXTX 0x3]",
     "71F867F8"),
    ("0000CDF0    STR        D17, [X3, W7 UXTW 0x0]",
     "714827FC"),
    ("0000CDF4    STR        D17, [X3, W7 UXTW 0x3]",
     "715827FC"),
    ("0000CDF8    STR        D17, [X3, X7]",
     "716827FC"),
    ("0000CDFC    STR        D17, [X3, X7 LSL 0x3]",
     "717827FC"),
    ("0000CE10    STR        D17, [X3, W7 SXTW 0x0]",
     "71C827FC"),
    ("0000CE14    STR        D17, [X3, W7 SXTW 0x3]",
     "71D827FC"),
    ("0000CE18    STR        D17, [X3, X7 SXTX 0x0]",
     "71E827FC"),
    ("0000CE1C    STR        D17, [X3, X7 SXTX 0x3]",
     "71F827FC"),
    ("0000CE30    LDR        D17, [X3, W7 UXTW 0x0]",
     "714867FC"),
    ("0000CE34    LDR        D17, [X3, W7 UXTW 0x3]",
     "715867FC"),
    ("0000CE38    LDR        D17, [X3, X7]",
     "716867FC"),
    ("0000CE3C    LDR        D17, [X3, X7 LSL 0x3]",
     "717867FC"),
    ("0000CE50    LDR        D17, [X3, W7 SXTW 0x0]",
     "71C867FC"),
    ("0000CE54    LDR        D17, [X3, W7 SXTW 0x3]",
     "71D867FC"),
    ("0000CE58    LDR        D17, [X3, X7 SXTX 0x0]",
     "71E867FC"),
    ("0000CE5C    LDR        D17, [X3, X7 SXTX 0x3]",
     "71F867FC"),



    ("0000C6F8    STP        D10, D11, [SP, 0x68]",
     "EAAF066D"),
    ("004009E4    STP        X29, LR, [SP, 0xFFFFFFFFFFFFFFF0]!",
     "FD7BBFA9"),

    ("0000C6E0    STP        W3, W15, [X3], 0x7C",
     "63BC8F28"),
    ("0000C6E4    LDP        W3, W15, [X3], 0x7C",
     "63BCCF28"),
    ("0000C6E8    STP        W3, W15, [X3, 0x7C]!",
     "63BC8F29"),
    ("0000C6EC    LDP        W3, W15, [X3, 0x7C]!",
     "63BCCF29"),
    ("0000C6F0    STP        X3, X15, [X3], 0xF8",
     "63BC8FA8"),
    ("0000C6F4    LDP        X3, X15, [X3], 0xF8",
     "63BCCFA8"),
    ("0000C6F8    STP        X3, X15, [X3, 0xF8]!",
     "63BC8FA9"),
    ("0000C6FC    LDP        X3, X15, [X3, 0xF8]!",
     "63BCCFA9"),

    ("0000C6E0    STP        S3, S15, [X3], 0x7C",
     "63BC8F2C"),
    ("0000C6E4    LDP        S3, S15, [X3], 0x7C",
     "63BCCF2C"),
    ("0000C6E8    STP        S3, S15, [X3, 0x7C]!",
     "63BC8F2D"),
    ("0000C6EC    LDP        S3, S15, [X3, 0x7C]!",
     "63BCCF2D"),
    ("0000C6F0    STP        D3, D15, [X3], 0xF8",
     "63BC8F6C"),
    ("0000C6F4    LDP        D3, D15, [X3], 0xF8",
     "63BCCF6C"),
    ("0000C6F8    STP        D3, D15, [X3, 0xF8]!",
     "63BC8F6D"),
    ("0000C6FC    LDP        D3, D15, [X3, 0xF8]!",
     "63BCCF6D"),
    ("0000C700    STP        Q3, Q15, [X3], 0x1F0",
     "63BC8FAC"),
    ("0000C704    LDP        Q3, Q15, [X3], 0x1F0",
     "63BCCFAC"),
    ("0000C708    STP        Q3, Q15, [X3, 0x1F0]!",
     "63BC8FAD"),
    ("0000C70C    LDP        Q3, Q15, [X3, 0x1F0]!",
     "63BCCFAD"),

    ("00028614    STP        D8, D9, [SP, 0x70]",
     "E827076D"),



    ("0000C6E0    RBIT       W3, W3",
     "6300C05A"),
    ("0000C6E4    REV16      W3, W3",
     "6304C05A"),
    ("0000C6E8    REV        W3, W3",
     "6308C05A"),
    ("0000C6F0    CLZ        W3, W3",
     "6310C05A"),
    ("0000C6F4    CLS        W3, W3",
     "6314C05A"),
    ("0000C710    RBIT       X3, X3",
     "6300C0DA"),
    ("0000C714    REV16      X3, X3",
     "6304C0DA"),
    ("0000C718    REV32      X3, X3",
     "6308C0DA"),
    ("0000C71C    REV        X3, X3",
     "630CC0DA"),
    ("0000C720    CLZ        X3, X3",
     "6310C0DA"),
    ("0000C724    CLS        X3, X3",
     "6314C0DA"),

    ("00028678    CBNZ       W0, 0x24",
     "20010035"),
    ("0000C734    CBZ        X1, 0x4C4",
     "212600B4"),

    ("0000D088    FMOV       D10, D0",
     "0A40601E"),
    ("0000C710    FMOV       D14, X0",
     "0E00679E"),
    ("0000C738    FMOV       X0, D14",
     "C001669E"),
    ("00010308    FMOV       W0, S12",
     "8001261E"),

    ("0000CC94    FSUB       D0, D5, D0",
     "A038601E"),
    ("0000D1A4    FADD       D0, D1, D10",
     "20286A1E"),
    ("00044DB4    FDIV       D1, D0, D8",
     "0118681E"),
    ("0001AB48    FMUL       D0, D8, D0",
     "0009601E"),
    ("0001C5C0    FMUL       S0, S0, S1",
     "0008211E"),
    ("0000CCA0    FMADD      D1, D0, D4, D1",
     "0104441F"),
    ("0002F938    FMSUB      D2, D2, D1, D3",
     "428C411F"),
    ("0000CFE8    FABS       D10, D8",
     "0AC1601E"),
    ("00010014    FNEG       D11, D0",
     "0B40611E"),
    ("0000CCBC    FMOV       D0, 0x40",
     "0010681E"),
    ("0008BD54    FCMP       D0, D1",
     "0020611E"),
    ("0000C6E4    FCMP       S3, 0x0",
     "6820201E"),
    ("0000C6EC    FCMP       D3, 0x0",
     "6820601E"),
    ("0008BD54    FCMP       D0, D1",
     "0020611E"),
    ("0000F58C    FCMPE      D8, 0x0",
     "1821601E"),


    ("0000CD28    FCVTZU     W1, D0",
     "0100791E"),
    ("0000CAB0    FCVTZS     X2, D0",
     "0200789E"),
    ("0001C5C4    FCVT       D0, S0",
     "00C0221E"),
    ("0002F90C    FCVT       S1, D0",
     "0140621E"),


    ("0000CCA4    SCVTF      D0, W5",
     "A000621E"),
    ("0000CAC0    SCVTF      D1, X2",
     "4100629E"),
    ("0000CD6C    UCVTF      D1, W0",
     "0100631E"),

    ("0003D25C    UBFM       X1, X0, 0x3D, 0x3",
     "010C7DD3"),

    ("0000C6E0    CSEL       W7, W3, W1, EQ",
     "6700811A"),
    ("0000C6E4    CSINC      W7, W3, W1, EQ",
     "6704811A"),
    ("0000C6E8    CSINV      W7, W3, W1, EQ",
     "6700815A"),
    ("0000C6EC    CSNEG      W7, W3, W1, EQ",
     "6704815A"),
    ("0000C6F0    CSEL       W7, W3, W1, CC",
     "6730811A"),
    ("0000C6F4    CSINC      W7, W3, W1, CC",
     "6734811A"),
    ("0000C6F8    CSINV      W7, W3, W1, CC",
     "6730815A"),
    ("0000C6FC    CSNEG      W7, W3, W1, CC",
     "6734815A"),
    ("0000C700    CSEL       W7, W3, W1, NV",
     "67F0811A"),
    ("0000C704    CSINC      W7, W3, W1, NV",
     "67F4811A"),
    ("0000C708    CSINV      W7, W3, W1, NV",
     "67F0815A"),
    ("0000C70C    CSNEG      W7, W3, W1, NV",
     "67F4815A"),
    ("0000C710    CSEL       W7, W3, W1, EQ",
     "6700811A"),
    ("0000C714    CSINC      W7, W3, W1, EQ",
     "6704811A"),
    ("0000C718    CSINV      W7, W3, W1, EQ",
     "6700815A"),
    ("0000C71C    CSNEG      W7, W3, W1, EQ",
     "6704815A"),
    ("0000C720    CSEL       W7, W3, W1, CC",
     "6730811A"),
    ("0000C724    CSINC      W7, W3, W1, CC",
     "6734811A"),
    ("0000C728    CSINV      W7, W3, W1, CC",
     "6730815A"),
    ("0000C72C    CSNEG      W7, W3, W1, CC",
     "6734815A"),
    ("0000C730    CSEL       W7, W3, W1, NV",
     "67F0811A"),
    ("0000C734    CSINC      W7, W3, W1, NV",
     "67F4811A"),
    ("0000C738    CSINV      W7, W3, W1, NV",
     "67F0815A"),
    ("0000C73C    CSNEG      W7, W3, W1, NV",
     "67F4815A"),
    ("0000C740    CSEL       X7, X3, X1, EQ",
     "6700819A"),
    ("0000C744    CSINC      X7, X3, X1, EQ",
     "6704819A"),
    ("0000C748    CSINV      X7, X3, X1, EQ",
     "670081DA"),
    ("0000C74C    CSNEG      X7, X3, X1, EQ",
     "670481DA"),
    ("0000C750    CSEL       X7, X3, X1, CC",
     "6730819A"),
    ("0000C754    CSINC      X7, X3, X1, CC",
     "6734819A"),
    ("0000C758    CSINV      X7, X3, X1, CC",
     "673081DA"),
    ("0000C75C    CSNEG      X7, X3, X1, CC",
     "673481DA"),
    ("0000C760    CSEL       X7, X3, X1, NV",
     "67F0819A"),
    ("0000C764    CSINC      X7, X3, X1, NV",
     "67F4819A"),
    ("0000C768    CSINV      X7, X3, X1, NV",
     "67F081DA"),
    ("0000C76C    CSNEG      X7, X3, X1, NV",
     "67F481DA"),
    ("0000C770    CSEL       X7, X3, X1, EQ",
     "6700819A"),
    ("0000C774    CSINC      X7, X3, X1, EQ",
     "6704819A"),
    ("0000C778    CSINV      X7, X3, X1, EQ",
     "670081DA"),
    ("0000C77C    CSNEG      X7, X3, X1, EQ",
     "670481DA"),
    ("0000C780    CSEL       X7, X3, X1, CC",
     "6730819A"),
    ("0000C784    CSINC      X7, X3, X1, CC",
     "6734819A"),
    ("0000C788    CSINV      X7, X3, X1, CC",
     "673081DA"),
    ("0000C78C    CSNEG      X7, X3, X1, CC",
     "673481DA"),
    ("0000C790    CSEL       X7, X3, X1, NV",
     "67F0819A"),
    ("0000C794    CSINC      X7, X3, X1, NV",
     "67F4819A"),
    ("0000C798    CSINV      X7, X3, X1, NV",
     "67F081DA"),
    ("0000C79C    CSNEG      X7, X3, X1, NV",
     "67F481DA"),
    ("0000DEB8    CSET       W0, NE",
     "E0079F1A"),
    ("00031190    CSET       X3, NE",
     "E3079F9A"),
    ("00068EE4    CSETM      W19, NE",
     "F3039F5A"),
    ("00083E20    CSETM      W19, MI",
     "F3539F5A"),
    ("0000D7FC    CSINC      W2, W2, W2, NE",
     "4214821A"),
    ("0007FB50    CSNEG      W0, W0, W0, EQ",
     "0004805A"),




    ("000A3304    TBNZ       W19, 0x1F, 0xFFFFFFFFFFFFFEEC",
     "73F7FF37"),
    ("0000CA34    TBZ        W0, 0x1F, 0x1C",
     "E000F836"),
    ("0001332C    TBZ        X19, 0x3F, 0x14",
     "B300F8B6"),

    ("0006BC4C    MADD       X15, X15, X0, XZR",
     "EF7D009B"),
    ("0000EAC0    MADD       W22, W0, W22, W1",
     "1604161B"),
    ("00011F00    MSUB       W0, W4, W3, W0",
     "8080031B"),
    ("0001A1B8    MSUB       X0, X0, X1, X22",
     "00D8019B"),
    ("000100C8    SMADDL     X25, W25, W20, X0",
     "3903349B"),
    ("00055860    UMADDL     X0, W0, W20, X1",
     "0004B49B"),
    ("00462068    UMULH      X10, X5, X9",
     "AA7CC99B"),

    ("0003A290    UDIV       W1, W23, W1",
     "E10AC11A"),
    ("0000D26C    SDIV       X1, X0, X1",
     "010CC19A"),

    ("0000CC50    LDR        D4, [PC, 0xD0]",
     "8406005C"),
    ("0000CC50    LDR        D4, [PC]",
     "0400005C"),

    ("0000CC50    LDRSW      X4, [PC, 0xD0]",
     "84060098"),


    ("0000CC90    LSL        W5, W7, W3",
     "E520C31A"),
    ("0000D5B0    LSL        X1, X1, X6",
     "2120C69A"),
    ("0001CE98    ASR        W0, W0, W20",
     "0028D41A"),
    ("0005DD30    ASR        X19, X3, X19",
     "7328D39A"),
    ("0001B118    LSR        W4, W1, W3",
     "2424C31A"),
    ("000374E8    LSR        X3, X4, X1",
     "8324C19A"),
    ("0009EB84    ROR        X3, X3, X6",
     "632CC69A"),
    ("00050634    NOP        ",
     "1F2003D5"),

    ("0006C588    EXTR       W2, W2, W2, 0x1F",
     "427C8213"),
    ("XXXXXXXX    EXTR       X12, X12, X12, 0x20",
     "8C81CC93"),

    ("00458AB8    CCMP       X3, X5, 0x8, GE",
     "68A045FA"),
    ("00458F90    CCMP       W3, 0x1, 0x0, CS",
     "6028417A"),

    ("00463288    SVC        0x0",
     "010000D4"),


    ("00458FF4    MRS        X0, 0x3, 0x3, c13, c0, 0x2",
     "40D03BD5"),
    ("0045BA04    MSR        0x3, 0x3, c13, c0, 0x2, X0",
     "40D01BD5"),
    ("0048A2E8    MRS        X8, 0x3, 0x3, c4, c2, 0x0",
     "08423BD5"),
    ("0048A9DC    MSR        0x3, 0x3, c4, c2, 0x0, X7",
     "07421BD5"),

    ("004010C8    ORR        W2, 0x0, 0x1",
     "E2030032"),

    ("0045B008    LDXR       W7, [X19]",
     "677E5F88"),
    ("0045AEC4    LDXR       W13, [X19]",
     "6D7E5F88"),
    ("0045B014    STXR       W2, W6, [X19]",
     "667E0288"),

    ("00464084    LDAXR      W13, [X20]",
     "8DFE5F88"),
    ("0046FA7C    LDAXR      X17, [X16]",
     "11FE5FC8"),
    ("XXXXXXXX    LDARB      W0, [X20]",
     "80FEDF08"),
    ("00464090    STLXR      W14, W2, [X20]",
     "82FE0E88"),

    ("0045ADB0    DMB        c11",
     "BF3B03D5"),

    ("00484A08    BRK        0x3E8",
     "007D20D4"),

    ("XXXXXXXX    LDR        WZR, [X20]",
     "9F0240B9"),
    ("XXXXXXXX    MADD       W0, W0, W1, WZR",
     "007C011B"),
    ("XXXXXXXX    STP        W20, WZR, [X19, 0x8]",
     "747E0129"),
    ("XXXXXXXX    STP        WZR, W20, [X19, 0x8]",
     "7F520129"),
    ("XXXXXXXX    STP        WZR, WZR, [X22, 0x2C]",
     "DFFE0529"),
    ("XXXXXXXX    STR        WZR, [X0, 0x14]",
     "1F1400B9"),
    ("XXXXXXXX    STRB       WZR, [X0, 0xFFF]",
     "1FFC3F39"),

    ("XXXXXXXX    CSEL       X22, X4, XZR, CS",
     "96209F9A"),
    ("XXXXXXXX    CSEL       X0, XZR, X0, EQ",
     "E003809A"),
    ("XXXXXXXX    ADD        X0, SP, XZR UXTX 0x0",
     "E0633F8B"),

    ("XXXXXXXX    ORR        X8, 0x0, 0x1000100010001",
     "E88300B2"),


    ("XXXXXXXX    CASP       X0, X2, [X4]",
     "827C2048"),
    ("XXXXXXXX    CASPL      X0, X2, [X4]",
     "82FC2048"),
    ("XXXXXXXX    CASPA      X0, X2, [X4]",
     "827C6048"),
    ("XXXXXXXX    CASPAL     X0, X2, [X4]",
     "82FC6048"),

    ("XXXXXXXX    CASP       W0, W2, [X4]",
     "827C2008"),
    ("XXXXXXXX    CASPL      W0, W2, [X4]",
     "82FC2008"),
    ("XXXXXXXX    CASPA      W0, W2, [X4]",
     "827C6008"),
    ("XXXXXXXX    CASPAL     W0, W2, [X4]",
     "82FC6008"),

    ("XXXXXXXX    LDAXRB     W15, [X14]",
     "CFFD5F08"),
    ("XXXXXXXX    STLXRB     W17, W16, [X14]",
     "D0FD1108"),

    ("XXXXXXXX    STLR       W9, [X8]",
     "09FD9F88"),
    ("XXXXXXXX    STLRB      W1, [X0]",
     "01FC9F08"),
    ("XXXXXXXX    STLRH      W9, [X8]",
     "09FD9F48"),

    ("XXXXXXXX    IC         0x0, c1, 0x0, XZR",
     "1F7108D5"),
    ("XXXXXXXX    CLREX      0xF",
     "5F3F03D5"),
    ("XXXXXXXX    TLBI       0x0, c7, 0x0, XZR",
     "1F8708D5"),
    ("XXXXXXXX    YIELD      ",
     "3F2003D5")
]



def h2i(s):
    return decode_hex(s.replace(' ', ''))


ts = time.time()

for s, l in reg_tests_aarch64[:]:
    print("-" * 80)
    print(s[:12], l)
    s = s[12:]
    b = h2i((l))
    mn = mn_aarch64.dis(b, 'l')
    print([str(x) for x in mn.args])
    print(s)
    print(mn)
    assert(str(mn) == s)
    l = mn_aarch64.fromstring(s, loc_db, 'l')
    assert(str(l) == s)
    a = mn_aarch64.asm(l)
    print([x for x in a])
    print(repr(b))
    assert(b in a)
    print(l.to_html())

